/*
This code is written by kerukuro for cppcrypto library (http://cppcrypto.sourceforge.net/)
and released into public domain.
*/

#include "kuznyechik.h"
// #include <memory.h>
// #include <algorithm>
// #include "portability.h"

#ifdef _MSC_VER
#define inline __forceinline
#endif

//#define CPPCRYPTO_DEBUG

	static const byte S[256] = {
		252, 238, 221, 17, 207, 110, 49, 22, 251, 196, 250, 218, 35, 197, 4, 77, 233, 119, 240, 219, 147, 46, 153, 186, 23, 54, 241, 187, 20, 205, 95, 193,
		249, 24, 101, 90, 226, 92, 239, 33, 129, 28, 60, 66, 139, 1, 142, 79, 5, 132, 2, 174, 227, 106, 143, 160, 6, 11, 237, 152, 127, 212, 211, 31,
		235, 52, 44, 81, 234, 200, 72, 171, 242, 42, 104, 162, 253, 58, 206, 204, 181, 112, 14, 86, 8, 12, 118, 18, 191, 114, 19, 71, 156, 183, 93, 135,
		21, 161, 150, 41, 16, 123, 154, 199, 243, 145, 120, 111, 157, 158, 178, 177, 50, 117, 25, 61, 255, 53, 138, 126, 109, 84, 198, 128, 195, 189, 13, 87,
		223, 245, 36, 169, 62, 168, 67, 201, 215, 121, 214, 246, 124, 34, 185, 3, 224, 15, 236, 222, 122, 148, 176, 188, 220, 232, 40, 80, 78, 51, 10, 74,
		167, 151, 96, 115, 30, 0, 98, 68, 26, 184, 56, 130, 100, 159, 38, 65, 173, 69, 70, 146, 39, 94, 85, 47, 140, 163, 165, 125, 105, 213, 149, 59,
		7, 88, 179, 64, 134, 172, 29, 247, 48, 55, 107, 228, 136, 217, 231, 137, 225, 27, 131, 73, 76, 63, 248, 254, 141, 83, 170, 144, 202, 216, 133, 97,
		32, 113, 103, 164, 45, 43, 9, 91, 203, 155, 37, 208, 190, 229, 108, 82, 89, 166, 116, 210, 230, 244, 180, 192, 209, 102, 175, 194, 57, 75, 99, 182
	};

	static const byte IS[256] = {
		165, 45, 50, 143, 14, 48, 56, 192, 84, 230, 158, 57, 85, 126, 82, 145, 100, 3, 87, 90, 28, 96, 7, 24, 33, 114, 168, 209, 41, 198, 164, 63,
		224, 39, 141, 12, 130, 234, 174, 180, 154, 99, 73, 229, 66, 228, 21, 183, 200, 6, 112, 157, 65, 117, 25, 201, 170, 252, 77, 191, 42, 115, 132, 213,
		195, 175, 43, 134, 167, 177, 178, 91, 70, 211, 159, 253, 212, 15, 156, 47, 155, 67, 239, 217, 121, 182, 83, 127, 193, 240, 35, 231, 37, 94, 181, 30,
		162, 223, 166, 254, 172, 34, 249, 226, 74, 188, 53, 202, 238, 120, 5, 107, 81, 225, 89, 163, 242, 113, 86, 17, 106, 137, 148, 101, 140, 187, 119, 60,
		123, 40, 171, 210, 49, 222, 196, 95, 204, 207, 118, 44, 184, 216, 46, 54, 219, 105, 179, 20, 149, 190, 98, 161, 59, 22, 102, 233, 92, 108, 109, 173,
		55, 97, 75, 185, 227, 186, 241, 160, 133, 131, 218, 71, 197, 176, 51, 250, 150, 111, 110, 194, 246, 80, 255, 93, 169, 142, 23, 27, 151, 125, 236, 88,
		247, 31, 251, 124, 9, 13, 122, 103, 69, 135, 220, 232, 79, 29, 78, 4, 235, 248, 243, 62, 61, 189, 138, 136, 221, 205, 11, 19, 152, 2, 147, 128,
		144, 208, 36, 52, 203, 237, 244, 206, 153, 16, 68, 64, 146, 58, 1, 38, 18, 26, 72, 104, 245, 129, 139, 199, 214, 32, 10, 8, 0, 76, 215, 116
	};

	static const uint64 T[16][256][2] = {
		{
			{LL(0x9680c07a0cd5fbe9), LL(0xb5aec91b93871119)}, {LL(0xce1a17b28ce00819), LL(0x0af2fef8abfc327b)}, {LL(0x77dcb250a2d0cbbf), LL(0x89c7884eefcabdc0)}, {LL(0xd642635e1a104162), LL(0xc01393d33c12c469)},
			{LL(0x2f46659822e5384f), LL(0x369bbfadd7b19ea2)}, {LL(0xe74a6f116a39b338), LL(0xefc0cb2f2997703c)}, {LL(0x4d567d06c2b71ffb), LL(0x68fe0f96fd783508)}, {LL(0x7379a4c39bf8884a), LL(0xaa09c5a389e794c7)},
			{LL(0x33bb07e78d3d32c1), LL(0xdfb49f6b267241b7)}, {LL(0xf79b37188e997c6a), LL(0x637e3c1d7223d420)}, {LL(0x49f36b95fb9f5c0e), LL(0x4b30427b9b551c0f)}, {LL(0xd2e775cd23380297), LL(0xe3ddde3e5a3fed6e)},
			{LL(0x15ccaace4282ec0b), LL(0xd7a23875c503166a)}, {LL(0x8dd35b6af83b12a5), LL(0xf7fae10dcf048998)}, {LL(0x2be3730b1bcd7bba), LL(0x1555f240b19cb7a5)}, {LL(0xf286c5df28bb5f33), LL(0x3862f35aec946656)},
			{LL(0x6b21d02f0d08c131), LL(0x60e8a8881e0962d5)}, {LL(0x670dea59467004ed), LL(0x05797f7cb47e19dc)}, {LL(0xeb665567214176e4), LL(0x8a511cdb83e00b35)}, {LL(0xa8af19bf559a6c58), LL(0x7759032ee718b0d6)},
			{LL(0x0b82c319104e261e), LL(0xceeadf2407373c9d)}, {LL(0x126253a119b40fc9), LL(0x7cd930a5684351fe)}, {LL(0xa917fdebca900cf4), LL(0x0f8b81841f822ba7)}, {LL(0xbcdb57258812e0ff), LL(0xd829b9f1da813dcd)},
			{LL(0x0931c8b1ed5ae685), LL(0x3e8d18b334c0c97f)}, {LL(0xe86dba9b435fd6d3), LL(0x02e459e6488d65a6)}, {LL(0x912e391557e3182b), LL(0x1ed5c1cb3ec7568d)}, {LL(0xc6933b57feb08e30), LL(0x4cad64e167a66075)},
			{LL(0x87e97c27777f5417), LL(0x41c2bc8330a92e74)}, {LL(0xdbd6bd7cce62e412), LL(0xdd50c68d6eff2411)}, {LL(0xaa1c1217a88eacc3), LL(0x873ec4b9d4ef4534)}, {LL(0xa6302861e3f6691f), LL(0xe2af134d7e983e3d)},
			{LL(0xc72bdf0361baee9c), LL(0x347fe64b9f3cfb04)}, {LL(0xfa0fe93a5aebd91a), LL(0x7e3d694320ce3458)}, {LL(0x3f973d91c645f71d), LL(0xba25489f8c053abe)}, {LL(0xfbb70d6ec5e1b9b6), LL(0x06efebe9d854af29)},
			{LL(0xb3fc82afa1748514), LL(0x350d2b38bb9b2857)}, {LL(0x24c4a68132ab1e51), LL(0xf8716089d086a23f)}, {LL(0xb4527bc0fa4266d6), LL(0x9e7623e816db6fc3)}, {LL(0xe15c722aae053056), LL(0x3c6941557c4dacd9)},
			{LL(0x531814d1907bd5ee), LL(0x71b6e8c73f4c1fff)}, {LL(0xd1ec9a314126a2a0), LL(0x6b689b03915283fd)}, {LL(0x4af884699981fc39), LL(0xc38507465038729c)}, {LL(0x01b8e4549f0a60ac), LL(0x78d282aaf89a9b71)},
			{LL(0xf18d2a234aa5ff04), LL(0xb0d7b66727f908c5)}, {LL(0x7a486c7276a26ecf), LL(0x9484dd10bd275db8)}, {LL(0xa026355a27caea71), LL(0x310699372b42e2d8)}, {LL(0x06161d3bc43c836e), LL(0xd3a98a7a55dadce5)},
			{LL(0x51ab1f796d6f1575), LL(0x81d12f500cbbea1d)}, {LL(0x02b30ba8fd14c09b), LL(0xf067c79733f7f5e2)}, {LL(0xf490d8e4ec87dc5d), LL(0xebcb7920b94ebab3)}, {LL(0x3b322b02ff6db4e8), LL(0x99eb0572ea2813b9)},
			{LL(0xc9b4eeddd7d6ebdb), LL(0xa189f62806bc75ef)}, {LL(0xcca91c1a71f4c882), LL(0xfa95396f980bc799)}, {LL(0xda6e5928516884be), LL(0xa58244279665bf60)}, {LL(0xb24466fb3e7ee5b8), LL(0x4ddfa9924301b326)},
			{LL(0xdf73abeff74aa7e7), LL(0xfe9e8b6008d20d16)}, {LL(0xd8dd5280ac7c4425), LL(0x55e583b0a5924a82)}, {LL(0x40c2a32416c5ba8b), LL(0x75bd5ac8af95d570)}, {LL(0xd35f9199bc32623b), LL(0x9b0f5c94a2a5761f)},
			{LL(0x31080c4f7029f25a), LL(0x2fd358fc1585b455)}, {LL(0x5b913834e22b53c7), LL(0x37e972def3164df1)}, {LL(0xfeaaffa963c39aef), LL(0x5df324ae46e31d5f)}, {LL(0x5f342ea7db031032), LL(0x14273f33953b64f6)},
			{LL(0x9fb108cbe18f1d6c), LL(0x8b23d1a8a747d866)}, {LL(0x1cfd627fafd80a8e), LL(0xe92f20c6f1c3df15)}, {LL(0xe6f28b45f533d394), LL(0x97124985d10deb4d)}, {LL(0x236a5fee699dfd93), LL(0x530a68597dc6e5ab)},
			{LL(0xe5f964b9972d73a3), LL(0x1fa70cb81a6085de)}, {LL(0x8a7da205a30df167), LL(0x5c81e9dd6244ce0c)}, {LL(0xa32ddaa645d44a46), LL(0xb9b3dc0ae02f8c4b)}, {LL(0x6a99347b9202a19d), LL(0x183a2a22e693f9a4)},
			{LL(0x1ff68d83cdc6aab9), LL(0x619a65fb3aaeb186)}, {LL(0x398120aa02797473), LL(0x698cc2e5d9dfe65b)}, {LL(0x3839c4fe9d7314df), LL(0x115e404f21457d2a)}, {LL(0x46d4be1fd2f939e5), LL(0xa614d0b2fa4f0995)},
			{LL(0xecc8ac087a779526), LL(0x212a140b2ea04ca1)}, {LL(0x958b2f866ecb5bde), LL(0x3d1b8c2658ea7f8a)}, {LL(0x550e09ea54475680), LL(0xa21f62bd6a96c31a)}, {LL(0xa19ed10eb8c08add), LL(0x49d41b9dd3d879a9)},
			{LL(0x4fe576ae3fa3df60), LL(0x9899c801ce8fc0ea)}, {LL(0xc2362dc4c798cdc5), LL(0x6f63290c018b4972)}, {LL(0x89764df9c1135150), LL(0xd434ace0a929a09f)}, {LL(0x86519873e87534bb), LL(0x39103e29c833b505)},
			{LL(0x5605e6163659f6b7), LL(0x2aaa2780a1fbad89)}, {LL(0x7de6951d2d948d0d), LL(0x3fffd5c010671a2c)}, {LL(0x1d45862b30d26a22), LL(0x91fda26c09594464)}, {LL(0x589ad7c88035f3f0), LL(0xbf5c37e3387b2362)},
			{LL(0xed70485ce57df58a), LL(0x59f896a1d63ad7d0)}, {LL(0x36a6f5202b1f1198), LL(0x84a8502cb8c5f3c1)}, {LL(0x22d2bbbaf6979d3f), LL(0x2bd8eaf3855c7eda)}, {LL(0x5013fb2df26575d9), LL(0xf903adfaf421716c)},
			{LL(0xf8bce292a7ff1981), LL(0x8e5aaed41339c1ba)}, {LL(0xbb75ae4ad324033d), LL(0x7352b12177c17a59)}, {LL(0x5e8ccaf34409709e), LL(0x6cf5bd996da1ff87)}, {LL(0x8c6bbf3e67317209), LL(0x8f2863a7379e12e9)},
			{LL(0xfda1105501dd3ad8), LL(0xd54661938d8e73cc)}, {LL(0xc80c0a8948dc8b77), LL(0xd95b7482fe26ee9e)}, {LL(0x5a29dc607d21336b), LL(0x4f3bf0740b8cd680)}, {LL(0xb759943c985cc6e1), LL(0x16c366d5ddb60150)},
			{LL(0xac0a0f2c6cb22fad), LL(0x54974ec3813599d1)}, {LL(0x1aeb7f446be489e0), LL(0x3a86aabca41903f0)}, {LL(0x27cf497d50b5be66), LL(0x70c425b41bebccac)}, {LL(0x7943838e14bccef8), LL(0x1c31982d764a332b)},
			{LL(0x65bee1f1bb64c476), LL(0xf51eb8eb8789ec3e)}, {LL(0xff121bfdfcc9fa43), LL(0x2521a604be79862e)}, {LL(0x9433cbd2f1c13b72), LL(0x45c90e8ca070e4fb)}, {LL(0x9d0203631c9bddf7), LL(0x7b44163f94b02d84)},
			{LL(0x82f48ee0d15d774e), LL(0x1ade73c4ae1e9c02)}, {LL(0x0c2c3a764b78c5dc), LL(0x6591d7f4aa777b09)}, {LL(0xeadeb133be4b1648), LL(0xf2839e717b7a9044)}, {LL(0x640605a5246ea4da), LL(0x8dcc3a417f13774f)},
			{LL(0xc38ec9905892ad69), LL(0x17b1aba6f911d203)}, {LL(0x939d32bdaaf7d8b0), LL(0xeeb2065c0d30a36f)}, {LL(0x804785482c49b7d5), LL(0xeab9b4539de969e0)}, {LL(0x30b0e81bef2392f6), LL(0x5701da56ed1f2f24)},
			{LL(0x185874ec96f0497b), LL(0xcae16d2b97eef612)}, {LL(0x66b50e0dd97a6441), LL(0x7dabfdd64ce482ad)}, {LL(0x8bc546513c0791cb), LL(0x24536b779ade557d)}, {LL(0x4b40603d068b9c95), LL(0xbb5785eca8a2e9ed)},
			{LL(0x6992db87f01c01aa), LL(0x908f6f1f2dfe9737)}, {LL(0x72c1409704f2e8e6), LL(0xd2db4709717d0fb6)}, {LL(0x030beffc621ea037), LL(0x88b5453dcb6d6e93)}, {LL(0x295078a3e6d9bb21), LL(0xe53235d7826b4247)},
			{LL(0x52a0f0850f71b542), LL(0x09646a6dc7d6848e)}, {LL(0x19e090b809fa29d7), LL(0xb233ef816f746d63)}, {LL(0x07aef96f5b36e3c2), LL(0xab7b08d0ad404794)}, {LL(0xfc19f4019ed75a74), LL(0xad94e3397514e8bd)},
			{LL(0x834c6ab44e5717e2), LL(0x620cf16e56840773)}, {LL(0xbacd4a1e4c2e6391), LL(0x0b80338b8f5be128)}, {LL(0xb0f76d53c36a2523), LL(0xbdb86e0570f646c4)}, {LL(0x9e09ec9f7e857dc0), LL(0xf3f153025fdd4317)},
			{LL(0xbe685c8d75062064), LL(0x284e7e66e976c82f)}, {LL(0xe44180ed0827130f), LL(0x67758e12e2fa1eaf)}, {LL(0x7bf08826e9a80e63), LL(0xec565fba45bdc6c9)}, {LL(0xf035ce77d5af9fa8), LL(0xc80534cddf6393b4)},
			{LL(0xd5498ca2780ee155), LL(0x48a6d6eef77faafa)}, {LL(0xee7ba7a0876355bd), LL(0xd14dd39c1d57b943)}, {LL(0xaf01e0d00eac8f9a), LL(0xdc220bfe4a58f742)}, {LL(0x3415fe88d60bd103), LL(0x74cf97bb8b320623)},
			{LL(0xbfd0b8d9ea0c40c8), LL(0x509cfccc11ec535e)}, {LL(0x6f84c6bc342082c4), LL(0x4326e56578244bd2)}, {LL(0x3203e3b31237526d), LL(0xa7661dc1dee8dac6)}, {LL(0x8ed8b4969a25b292), LL(0x7f4fa4300469e70b)},
			{LL(0x476c5a4b4df35949), LL(0xdec6521802d592e4)}, {LL(0xf33e218bb7b13f9f), LL(0x40b071f0140efd27)}, {LL(0x3a8acf566067d444), LL(0xe13987d812b288c8)}, {LL(0xf90406c638f5792d), LL(0xf6882c7eeba35acb)},
			{LL(0x60a313361d46e72f), LL(0xae0277ac193e5e48)}, {LL(0xaeb9048491a6ef36), LL(0xa4f08954b2c26c33)}, {LL(0x1e4e69d752ccca15), LL(0x1948e751c2342af7)}, {LL(0x63a8fcca7f584718), LL(0x26b73291d25330db)},
			{LL(0x0d94de22d472a570), LL(0x1d43555e52ede078)}, {LL(0x1169bc5d7baaaffe), LL(0xf46c7598a32e3f6d)}, {LL(0xcd11f84eeefea82e), LL(0x8247bbc560915ce8)}, {LL(0x5922339c1f3f935c), LL(0xc78eb549c0e1b813)},
			{LL(0x7c5e7149b29eeda1), LL(0x472d576ae8fd815d)}, {LL(0xb9c6a5e22e30c3a6), LL(0x833576b644368fbb)}, {LL(0xa2953ef2dade2aea), LL(0xc1615ea018b5173a)}, {LL(0x57bd0242a953961b), LL(0x5278a52a596136f8)},
			{LL(0x177fa166bf962c90), LL(0x27c5ffe2f6f4e388)}, {LL(0x2061b0120b835da4), LL(0xdbbf2d64b6ab8b38)}, {LL(0x6e3c22e8ab2ae268), LL(0x3bf467cf80bed0a3)}, {LL(0x4cee99525dbd7f57), LL(0x102c8d3c05e2ae79)},
			{LL(0x257c42d5ada17efd), LL(0x80a3e223281c394e)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x9aacfa0c47ad3e35), LL(0xd03f1eef39f06a10)}, {LL(0xdecb4fbb6840c74b), LL(0x864c09caf0489667)},
			{LL(0x0e9f31deb66c0547), LL(0x95f6106399808eeb)}, {LL(0x484b8fc164953ca2), LL(0x33e2c0d163cf877e)}, {LL(0x611bf762824c8783), LL(0xd6d0f506e1a4c539)}, {LL(0xddc0a0470a5e677c), LL(0x0ef94cf73b25f8f4)},
			{LL(0x45df51e3b0e799d2), LL(0x2ea1958f31226706)}, {LL(0x766456043ddaab13), LL(0xf1150ae4175026b1)}, {LL(0x4467b5b72fedf97e), LL(0x56731725c9b8fc77)}, {LL(0x8f6050c2052fd23e), LL(0x079d269afcf37c7a)},
			{LL(0xb5ea9f946548067a), LL(0xe6a4a142ee41f4b2)}, {LL(0xa48323c91ee2a984), LL(0x12c8d4da4d6fcbdf)}, {LL(0x2a5b975f84c71b16), LL(0x6d8770ea49062cd4)}, {LL(0x71caaf6b66ec48d1), LL(0x5a6e0234ba106125)},
			{LL(0x3e2fd9c5594f97b1), LL(0xc2f7ca35749fa1cf)}, {LL(0xd0547e65de2cc20c), LL(0x13ba19a969c8188c)}, {LL(0x08892ce572508629), LL(0x465f9a19cc5a520e)}, {LL(0x682a3fd36f166106), LL(0xe85dedb5d5640c46)},
			{LL(0x54b6edbecb4d362c), LL(0xdacde017920c586b)}, {LL(0x3c9cd26da45b572a), LL(0x32900da24768542d)}, {LL(0xe3ef79825311f0cd), LL(0xcc0e86c24fba593b)}, {LL(0xc598d4ab9cae2e07), LL(0xc41821dcaccb0ee6)},
			{LL(0x4271a88cebd17a10), LL(0x85da9d5f9c622092)}, {LL(0x21d9544694893d08), LL(0xa36dafce4e311049)}, {LL(0xd4f168f6e70481f9), LL(0x307454440fe5318b)}, {LL(0xefc343f418693511), LL(0xa99f5136e5cd2232)},
			{LL(0xa53bc79d81e8c928), LL(0x6a1a5670b5f550ae)}, {LL(0x0f27d58a296665eb), LL(0xed2492c9611a159a)}, {LL(0x9096dd41c8e97887), LL(0x66074361c65dcdfc)}, {LL(0xf5283cb0738dbcf1), LL(0x9319fb8a41d421c2)},
			{LL(0xf623d34c11931cc6), LL(0x1bacbeb78ab94f51)}, {LL(0xcfa2f3e613ea68b5), LL(0x72207c525366a90a)}, {LL(0xaba4f6433784cc6f), LL(0xffec46132c75de45)}, {LL(0x4e5d92faa0a9bfcc), LL(0xe04b4aab36155b9b)},
			{LL(0x371e1174b4157134), LL(0xfc7ad286405f68b0)}, {LL(0x9225d6e935fdb81c), LL(0x966084f6f5aa381e)}, {LL(0xb6e170680756a64d), LL(0x6e11e47f252c9a21)}, {LL(0x6c8f2940563e22f3), LL(0xcb93a058b3492541)},
			{LL(0x7f559eb5d0804d96), LL(0xcf9812572390efce)}, {LL(0x5c3fc15bb91db005), LL(0x9c927a0e5e560a65)}, {LL(0xe2579dd6cc1b9061), LL(0xb4dc0468b720c24a)}, {LL(0x051df2c7a6222359), LL(0x5b1ccf479eb7b276)},
			{LL(0x3d2436393b513786), LL(0x4a428f08bff2cf5c)}, {LL(0x74d75dacc0ce6b88), LL(0x0172cd7324a7d353)}, {LL(0xa788cc357cfc09b3), LL(0x9a7d91e78602a54c)}, {LL(0xd965b6d433762489), LL(0x2d37011a5d08d1f3)},
			{LL(0x88cea9ad5e1931fc), LL(0xace62e4a51b33bee)}, {LL(0xc42030ff03a44eab), LL(0xbccaa37654519597)}, {LL(0xbd63b37117188053), LL(0xa0fb3b5b221ba6bc)}, {LL(0x6210189ee05227b4), LL(0x5e65b03b2ac9abaa)},
			{LL(0x2efe81ccbdef58e3), LL(0x4e493d072f2b05d3)}, {LL(0xd7fa870a851a21ce), LL(0xb8c11179c4885f18)}, {LL(0x10d15809e4a0cf52), LL(0x8cbef7325bb4a41c)}, {LL(0x855a778f8a6b948c), LL(0xb1a57b14035edb96)},
			{LL(0x7eed7ae14f8a2d3a), LL(0xb74a90fddb0a74bf)}, {LL(0x2677ad29cfbfdeca), LL(0x0816a71ee37157dd)}, {LL(0x78fb67da8bb6ae54), LL(0x64e31a878ed0a85a)}, {LL(0x14744e9add888ca7), LL(0xaf70badf3d998d1b)},
			{LL(0x9b141e58d8a75e99), LL(0xa8ed9c45c16af161)}, {LL(0xb87e41b6b13aa30a), LL(0xfbe7f41cbcac14ca)}, {LL(0xcb07e5752ac22b40), LL(0x51ee31bf354b800d)}, {LL(0x99a715f025b39e02), LL(0x588a5bd2f29d0483)},
			{LL(0x9cbae7378391bd5b), LL(0x039694956c2ab6f5)}, {LL(0x43c94cd874db1abc), LL(0xfd081ff564f8bbe3)}, {LL(0x2c4d8a6440fb9878), LL(0xbe2efa901cdcf031)}, {LL(0x81ff611cb343d779), LL(0x926b36f96573f291)},
			{LL(0x04a51693392843f5), LL(0x23ce4ded662d2907)}, {LL(0x5d87250f2617d0a9), LL(0xe440f8a4a6cc9114)}, {LL(0xcabf0121b5c84bec), LL(0x293cb315cdd11b7c)}, {LL(0x70724b3ff9e6287d), LL(0x22bc809e428afa54)},
			{LL(0x9738242e93df9b45), LL(0xcd7c4bb16b1d8a68)}, {LL(0x16c74532209c4c3c), LL(0x5f177d480e6e78f9)}, {LL(0x13dab7f586be6f65), LL(0x040bb20f90d9ca8f)}, {LL(0xadb2eb78f3b84f01), LL(0x2c45cc6979af02a0)},
			{LL(0x756fb9f85fc40b24), LL(0x79a04fd9dc3d4822)}, {LL(0x6d37cd14c934425f), LL(0xb34122f24bd3be30)}, {LL(0xe9d55ecfdc55b67f), LL(0x7a36db4cb017fed7)}, {LL(0x84e293db1561f420), LL(0xc977f9befbc440e7)},
			{LL(0x981ff1a4bab9feae), LL(0x2058d9780a079ff2)}, {LL(0xc085266c3a8c0d5e), LL(0x9f04ee9b327cbc90)}, {LL(0x35ad1adc4901b1af), LL(0x0c1d151173a89d52)}, {LL(0xdc784413955407d0), LL(0x762bce5dc3bf6385)},
			{LL(0x0a3a274d8f4446b2), LL(0xb6385d8effada7ec)}, {LL(0xb14f89075c60458f), LL(0xc56aecaf886cddb5)}, {LL(0x417a477089cfda27), LL(0x0d6fd862570f4e01)}, {LL(0x28e89cf779d3db8d), LL(0x9de0b77d7af1d936)},
			{LL(0x1b539b10f4eee94c), LL(0x425428165c839881)}, {LL(0x2df56e30dff1f8d4), LL(0xc6fc783ae4466b40)}, {LL(0xe0e4967e310f50fa), LL(0x44bbc3ff84d737a8)}, {LL(0xc13dc238a5866df2), LL(0xe7d66c31cae627e1)}
		}, {
			{LL(0xcf250ca2ea58362f), LL(0x3650d392499ed97c)}, {LL(0xb8828c7e3ad63348), LL(0x339fa60be4876cf4)}, {LL(0xd9afa26576e99c5c), LL(0x9c9481a8540a7201)}, {LL(0x9e1b1a098515650c), LL(0x65b81d61d17b0a53)},
			{LL(0xae0822b9a667993b), LL(0x995bf431f913c789)}, {LL(0xfe3d6aaac3f15e62), LL(0x5ebd0cc181ab5324)}, {LL(0x6e44c23c2a6cefe7), LL(0xef51d6b259707567)}, {LL(0x69759b921c288542), LL(0x857b54bbbc20636f)},
			{LL(0x384b8d397365d661), LL(0xd6939a4824c5b040)}, {LL(0x7bd38ef0a8733a1a), LL(0x3a87de8da703175f)}, {LL(0xde9efbcb40adf6f9), LL(0xf6be03a1b15a6409)}, {LL(0x2ec123feefd47c12), LL(0x7c57c87239511b3d)},
			{LL(0x19e342e0fae2ea80), LL(0xea9ea32bf469c0ef)}, {LL(0x9d06f8029bbb1a82), LL(0x1aaa4764329cc316)}, {LL(0x1ed21b4ecca68025), LL(0x80b421221139d6e7)}, {LL(0xe7de284a3913b4e2), LL(0xb423afea75c293cb)},
			{LL(0x4fec0de5a3ebd306), LL(0xd35cefd189dc05c8)}, {LL(0x5c41463f1d6bf824), LL(0xf8ae53e472a2367a)}, {LL(0xed9021707d717540), LL(0x754fb0f47ad56096)}, {LL(0xc814550cdc1c5c8a), LL(0x5c7a519baccecf74)},
			{LL(0xd7cd10fa1a6148d5), LL(0x48c046ba5daa5e11)}, {LL(0xdd8319c05e038977), LL(0x89ac59a452bdad4c)}, {LL(0xe4c3ca4127bdcb6c), LL(0xcb31f5ef96255a8e)}, {LL(0xfd2088a1dd5f21ec), LL(0x21af56c4624c9a61)},
			{LL(0x8fa0ed602fe0a5da), LL(0xa556cd5229bfb726)}, {LL(0x992a43a7b3510fa9), LL(0x0f929f68342b1c5b)}, {LL(0x0b4557824eb955d8), LL(0x5562291def4ab4df)}, {LL(0x1bf5fe53ee970174), LL(0x0182cf2df7d34e28)},
			{LL(0x661c77b57a7bc5b1), LL(0xc521a5aa55dd08fd)}, {LL(0xa161ce9ec034d9c8), LL(0xd901052010eeac1b)}, {LL(0x9079a896e99db185), LL(0xb1ecda73d8db2643)}, {LL(0x83d4e34c571d9aa7), LL(0x9a1e664623a515f1)},
			{LL(0x3722611e15369692), LL(0x96c96b59cd38dbd2)}, {LL(0x44a95a67ed5286de), LL(0x863ec6cc6696b117)}, {LL(0x2be6c6e3cde5fd43), LL(0xfd61267ddfbb83f2)}, {LL(0x687ec52a16f31138), LL(0x117562b85c7d24ed)},
			{LL(0x9a37a1acadff7027), LL(0x7080c56dd7ccd51e)}, {LL(0x79c53243bc06d1ee), LL(0xd19bb28ba4b99998)}, {LL(0x5e57fa8c091e13d0), LL(0x13b23fe27118b8bd)}, {LL(0x168aaec79cb1aa73), LL(0xaac4523a1d94ab7d)},
			{LL(0xa06a9026caef4db2), LL(0x4d0f3323f0b3eb99)}, {LL(0x5a7b412921f406fb), LL(0x068ae7ee77af67f0)}, {LL(0xaa24991c8e8d8c10), LL(0x8c632c3dffa418c4)}, {LL(0x2cd79f4dfba197e6), LL(0x974ba4743aeb95fa)},
			{LL(0x93644a9df733ce0b), LL(0xcefe80763b3cef06)}, {LL(0xe6d576f233c82098), LL(0x202d99e9959fd449)}, {LL(0x6b632721085d6eb6), LL(0x6e6738bdbf9aeda8)}, {LL(0xe8b7c46d5f40f411), LL(0xf4795efb9c3ff859)},
			{LL(0xf8076dbcff6ea0bd), LL(0xa099b8cb84a602ae)}, {LL(0x586dfd9a3581ed0f), LL(0xed968be87415e937)}, {LL(0x0f69ec27665340f3), LL(0x405af111e9fd6b92)}, {LL(0x9b3cff14a724e45d), LL(0xe48ef36e3791929c)},
			{LL(0x7ce2d75e9e3750bf), LL(0x50ad5c8442530157)}, {LL(0xe0ef71e40f57de47), LL(0xde092de3909285c3)}, {LL(0x8db651d33b954e2e), LL(0x4e4aa1542a0539e1)}, {LL(0xb6e03ee1565ee7c1), LL(0xe7cb6119ed2740e4)},
			{LL(0x11bbf769aaf5c0d6), LL(0xc0eed033f8c4bd75)}, {LL(0xd5dbac490e14a321), LL(0xa3dc2abc5e10d0d6)}, {LL(0x513e16ab6f4d5323), LL(0x53e8cef398e5d32f)}, {LL(0x0216bcb31475ebf4), LL(0xeb1c6c0603ba8ec7)},
			{LL(0x602670a346e43b6e), LL(0x3b0511a050d05977)}, {LL(0x031de20b1eae7f8e), LL(0x7f125a05e3e7c945)}, {LL(0xf473639087939fc0), LL(0x9fd113df8ebca079)}, {LL(0xb3c7dbfc746f6690), LL(0x66fd8f160bcdd82b)},
			{LL(0x4085e1c2c5b893f5), LL(0x93061ec060216e5a)}, {LL(0x9643af80d5024f5a), LL(0x4fc86e79ddd677c9)}, {LL(0xd2eaf5e73850c984), LL(0xc9f6a8b5bb40c6de)}, {LL(0xbda5696318e7b219), LL(0xb2a94804026df43b)},
			{LL(0xa6509730f670b36d), LL(0xb32b8729f5beba13)}, {LL(0x5966a3223f5a7975), LL(0x7998bdeb9448aeb5)}, {LL(0x1fd945f6c67d145f), LL(0x14ba1721f1649165)}, {LL(0x633b92a8584a44e0), LL(0x44174ba5b3379032)},
			{LL(0xe2f9cd571b2235b3), LL(0x351541e593280b04)}, {LL(0xc351028e92a50952), LL(0x0918788643847bab)}, {LL(0xef869dc369049eb4), LL(0x9e53dcf2796fee51)}, {LL(0xb989d2c6300da732), LL(0xa791900804da2b76)},
			{LL(0x29f07a50d99016b7), LL(0x167d4a7bdc010d35)}, {LL(0xbb9f6e7524784cc6), LL(0x4c8dfc0e0760a5b1)}, {LL(0x48dd544b95afb9a3), LL(0xb9766dd86c8c13c0)}, {LL(0x47b4b86cf3fcf950), LL(0xf92c9cc985717852)},
			{LL(0x36293fa61fed02e8), LL(0x02c75d5a2d659c50)}, {LL(0xab2fc7a48456186a), LL(0x186d1a3e1ff95f46)}, {LL(0x2ddcc1f5f17a039c), LL(0x03459277dab6d278)}, {LL(0x4acbe8f881da5257), LL(0x526a01de6f369d07)},
			{LL(0x3c67369c5b8fc34a), LL(0xc3ab424422726f0d)}, {LL(0x22b52dd29729436f), LL(0x431f6366334bb9ea)}, {LL(0xba9430cd2ea3d8bc), LL(0xd883ca0de73de233)}, {LL(0x77a780dcd08e0567), LL(0x05cf7599ad19b588)},
			{LL(0x0527e51d22318151), LL(0x8136ee0fe6ea98cf)}, {LL(0xa4462b83e2055899), LL(0x5837eb2ff60434d4)}, {LL(0x9172f62ee34625ff), LL(0x25e2ec70388661c1)}, {LL(0xd4d0f2f104cf375b), LL(0x37d21cbfbe4d9754)},
			{LL(0x1cc4a7fdd8d36bd1), LL(0x6ba84d2412835820)}, {LL(0x3940d38179be421b), LL(0x429dac4bc498f7c2)}, {LL(0x9f1044b18fcef176), LL(0xf1b62b6231264dd1)}, {LL(0xb1d1674f601a8d64), LL(0x8de1e310087756ec)},
			{LL(0x80c9014749b3e529), LL(0xe50c3c43c042dcb4)}, {LL(0x503548136596c759), LL(0xc7e6f8f078b894ad)}, {LL(0x2fca7d46e50fe868), LL(0xe859fe71d90c5cbf)}, {LL(0x2aed985bc73e6939), LL(0x696f107e3fe6c470)},
			{LL(0x78ce6cfbb6dd4594), LL(0x4595848844e4de1a)}, {LL(0x7ef46bed8a42bb4b), LL(0xbbb1308241e98f90)}, {LL(0x0d7f50947226ab07), LL(0xab469d17ea47e555)}, {LL(0x926f1425fde85a71), LL(0x5af0b675db61a884)},
			{LL(0x042cbba528ea152b), LL(0x1538d80c06b7df4d)}, {LL(0xd8a4fcdd7c320826), LL(0x089ab7abb4573583)}, {LL(0x9748f138dfd9db20), LL(0xdbc6587a3d8b304b)}, {LL(0x18e81c58f0397efa), LL(0x7e9095281434876d)},
			{LL(0xfa11d10feb1b4b49), LL(0x4b85d4cd871c8c69)}, {LL(0x13ad4bdabe802b22), LL(0x2bf2bc35fb7e33b2)}, {LL(0xc147be3d86d0e2a6), LL(0xe2041480403ef56c)}, {LL(0x28fb24e8d34b82cd), LL(0x82737c783c5c4ab7)},
			{LL(0x87f858e97ff78f8c), LL(0x8f26be4a2512cabc)}, {LL(0x5328aa187b38b8d7), LL(0xb8f4a2f59b5f5de8)}, {LL(0xa27c2c95de9aa646), LL(0xa6135f25f309655e)}, {LL(0x4cf1efeebd45ac88), LL(0xac4eb5d46a3bcc8d)},
			{LL(0x26999677bfc35644), LL(0x5627bb6a35fc66a7)}, {LL(0x7096d972e6ca6fc2), LL(0x6fe5f7904849a380)}, {LL(0x75b13c6fc4fbee93), LL(0xeed3199faea33b4f)}, {LL(0x86f30651752c1bf6), LL(0x1b288849c54f8d3e)},
			{LL(0x1781f07f966a3e09), LL(0x3eca6439fdc9ecff)}, {LL(0x45a204dfe78912a4), LL(0x1230f0cf86cbf695)}, {LL(0x74ba62d7ce207ae9), LL(0x7add2f9c4efe7ccd)}, {LL(0x46bfe6d4f9276d2a), LL(0x6d22aaca652c3fd0)},
			{LL(0x8cbd0f6b314eda54), LL(0xda449757ca587e63)}, {LL(0x0a4e093a4462c1a2), LL(0xc16c1f1e0f17f35d)}, {LL(0xc4605b20a4e163f7), LL(0x6332fa8fa6d46da3)}, {LL(0xac1e9e0ab21272cf), LL(0x72479837faa9494e)},
			{LL(0xd6c64e4210badcaf), LL(0xdcce70b9bdf71993)}, {LL(0x15974ccc821fd5fd), LL(0xd5d6083ffe736238)}, {LL(0xee8dc37b63df0ace), LL(0x0a5deaf19932a9d3)}, {LL(0x6c527e8f3e190413), LL(0x044dbab45acafba0)},
			{LL(0xa54d753be8decce3), LL(0xcc39dd2c16597356)}, {LL(0x8a87087d0dd1248b), LL(0x2460235dcf552fe9)}, {LL(0xca02e9bfc869b77e), LL(0xb7663d9daf7441b3)}, {LL(0xbfb3d5d00c9259ed), LL(0x59b5240201d77afc)},
			{LL(0xeaa178de4b351fe5), LL(0x1f6532fd9f85769e)}, {LL(0x719d87caec11fbb8), LL(0xfbebc193a814e402)}, {LL(0x0c740e2c78fd3f7d), LL(0x3f48ab140a1aa2d7)}, {LL(0xfc2bd619d784b596), LL(0xb5a160c78211dde3)},
			{LL(0x899aea76137f5b05), LL(0x5b7279582cb2e6ac)}, {LL(0xff363412c92aca18), LL(0xcab33ac261f614a6)}, {LL(0x149c127488c44187), LL(0x41d83e3c1e2e25ba)}, {LL(0xe9bc9ad5559b606b), LL(0x607768f87c62bfdb)},
			{LL(0x955e4d8bcbac30d4), LL(0x30da347c3e31be8c)}, {LL(0xcb09b707c2b22304), LL(0x23680b9e4f290631)}, {LL(0xb7eb60595c8573bb), LL(0x73c5571a0d7a0766)}, {LL(0x301338b02372fc37), LL(0xfce3e9502868cdda)},
			{LL(0x98211d1fb98a9bd3), LL(0x9b9ca96bd4765bd9)}, {LL(0x20a39161835ca89b), LL(0xa8030f6030f1372d)}, {LL(0xce2e521ae083a255), LL(0xa25ee591a9c39efe)}, {LL(0xec9b7fc877aae13a), LL(0xe14186f79a882714)},
			{LL(0x3f7ad4974521bcc4), LL(0xbcb91841c195a648)}, {LL(0xa9397b179023f39e), LL(0xf37176381c43d181)}, {LL(0xcc38eea9f4f649a1), LL(0x49428997aa791039)}, {LL(0x5b701f912b2f9281), LL(0x9284d1ed97f22072)},
			{LL(0x0e62b29f6c88d489), LL(0xd454c71209a02c10)}, {LL(0x612d2e1b4c3faf14), LL(0xaf0b27a3b08d1ef5)}, {LL(0x330edabb3ddc83b9), LL(0x83f1b355cb8f049f)}, {LL(0x10b0a9d1a02e54ac), LL(0x54e0e6301899faf7)},
			{LL(0x418ebf7acf63078f), LL(0x070828c3807c29d8)}, {LL(0xc91f0bb4d6c7c8f0), LL(0xc87467984c9388f6)}, {LL(0xd3e1ab5f328b5dfe), LL(0x5df89eb65b1d815c)}, {LL(0x42935d71d1cd7801), LL(0x781a72c6639be09d)},
			{LL(0x5512ad0e47a74608), LL(0x46d016ff9e520c62)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xdc88477854d81d0d), LL(0x1da26fa7b2e0eace)}, {LL(0x3d6c682451545730), LL(0x57a57447c22f288f)},
			{LL(0x4bc0b6408b01c62d), LL(0xc66437dd8f6bda85)}, {LL(0xf2496486bb0c611f), LL(0x61f5a7d58bb1f1f3)}, {LL(0xb4f68252422b0c35), LL(0x0cd70d1fee9dce23)}, {LL(0x49d60af39f742dd9), LL(0x2d785bdb8cd15442)},
			{LL(0xcd33b011fe2ddddb), LL(0xdd4cbf944a2457bb)}, {LL(0xf5783d288d480bba), LL(0x0bdf25dc6ee1e7fb)}, {LL(0xe1e42f5c058c4a3d), LL(0x4a071be070cfc241)}, {LL(0xc56b0598ae3af78d), LL(0xf73ccc8c46892a21)},
			{LL(0x728065c1f2bf8436), LL(0x84f99b964bf32d47)}, {LL(0xdbb91ed6629c77a8), LL(0x7788edae57b0fcc6)}, {LL(0x32058403370717c3), LL(0x17ff85562bd2431d)}, {LL(0x3118660829a9684d), LL(0x68eddf53c8358a58)},
			{LL(0x073159ae36446aa5), LL(0x6a2a8209e5501608)}, {LL(0x76acde64da55911d), LL(0x91c1439a4d44f20a)}, {LL(0xa377722dd441323c), LL(0x321d6926135422dc)}, {LL(0x3b566f326dcba9ef), LL(0xa981c04dc7227905)},
			{LL(0x640acb066e0e2e45), LL(0x2e3dc9ac5667863a)}, {LL(0x5f5ca43403c587aa), LL(0x87bc09e19145ff3f)}, {LL(0x4ee7535da930477c), LL(0x4752d9d26981424a)}, {LL(0x6f4f9c8420b77b9d), LL(0x7b5fe0b1b92d32e5)},
			{LL(0x0953eb315accbe2c), LL(0xbe7e451becf03a18)}, {LL(0xe5c894f92d665f16), LL(0x5f3fc3ec76781d0c)}, {LL(0xc676e793b0948803), LL(0x882e9689a56ee364)}, {LL(0x5d4a188717b06c5e), LL(0x6ca065e792ff71f8)},
			{LL(0xf76e819b993de04e), LL(0xe0c349da6d5b693c)}, {LL(0x6717290d70a051cb), LL(0x512f93a9b5804f7f)}, {LL(0x2792c8cfb518c23e), LL(0xc2298d69d5a12125)}, {LL(0x23be736a9df2d715), LL(0xd7115565d316fe68)},
			{LL(0x570411bd53d2adfc), LL(0xadcc7af99de882a5)}, {LL(0x94551333c177a4ae), LL(0xa4d4027fde6cf90e)}, {LL(0xbcae37db123c2663), LL(0x26a77e07e230b3b9)}, {LL(0x1afea0ebe44c950e), LL(0x958cf92e178e09aa)},
			{LL(0x8891b4ce19a4cf7f), LL(0xcf7c4f5bccefa12e)}, {LL(0x7fff355580992f31), LL(0x2fbf0681a1b4c812)}, {LL(0x063a07163c9ffedf), LL(0xfe24b40a050d518a)}, {LL(0x8b8c56c5070ab0f1), LL(0xb06e155e2f08686b)},
			{LL(0x7ad8d048a2a8ae60), LL(0xae89e88e475e50dd)}, {LL(0xc77db92bba4f1c79), LL(0x1c20a08a4533a4e6)}, {LL(0x6230cc105291d09a), LL(0xd0197da6536ad7b0)}, {LL(0x9c0da6ba91608ef8), LL(0x8ea47167d2c18494)},
			{LL(0x738b3b79f864104c), LL(0x10f7ad95abae6ac5)}, {LL(0xad15c0b2b8c9e6b5), LL(0xe649ae341af40ecc)}, {LL(0xaf037c01acbc0d41), LL(0x0d55c232194e800b)}, {LL(0xf90c3304f5b534c7), LL(0x34978ec864fb452c)},
			{LL(0x010b5eb80adb947a), LL(0x940e3603e05d4782)}, {LL(0x439803c9db16ec7b), LL(0xec1444c583c6a71f)}, {LL(0xd1f717ec26feb60a), LL(0xb6e4f2b058a70f9b)}, {LL(0xc04ce0858c0b76dc), LL(0x760a2283a063b2ee)},
			{LL(0x82dfbdf45dc60edd), LL(0x0e105045c3f85273)}, {LL(0xb2cc85447eb4f2ea), LL(0xf2f3b915eb909fa9)}, {LL(0x85eee45a6b826478), LL(0x643ad24c26a8447b)}, {LL(0x3e718a2f4ffa28be), LL(0x28b72e4221c8e1ca)},
			{LL(0x560f4f0559093986), LL(0x39c24cfa7db5c527)}, {LL(0x21a8cfd989873ce1), LL(0x3c0d3963d0ac70af)}, {LL(0xbeb88b680649cd97), LL(0xcdbb1201e18a3d7e)}, {LL(0x3534ddad01437d66), LL(0x7dd5075fce825515)},
			{LL(0xf05fd835af798aeb), LL(0x8ae9cbd3880b7f34)}, {LL(0x4dfab156b79e38f2), LL(0x384083d78a668b0f)}, {LL(0x248f2ac4abb6bdb0), LL(0xbd3bd76c3646e860)}, {LL(0xa83225af9af867e4), LL(0x677f403bfc1e9603)},
			{LL(0x343f83150b98e91c), LL(0xe9db315c2edf1297)}, {LL(0x2584747ca16d29ca), LL(0x2935e16fd61bafe2)}, {LL(0xdab2406e6847e3d2), LL(0xe386dbadb7edbb44)}, {LL(0x8eabb3d8253b31a0), LL(0x3158fb51c9e2f0a4)},
			{LL(0xb0da39f76ac1191e), LL(0x19efd513e82a116e)}, {LL(0xebaa266641ee8b9f), LL(0x8b6b04fe7fd8311c)}, {LL(0x0858b58950172a56), LL(0x2a7073180cad7d9a)}, {LL(0x1dcff945d208ffab), LL(0xffa67b27f2de1fa2)},
			{LL(0xe3f293ef11f9a1c9), LL(0xa11b77e673754c86)}, {LL(0x6d59203734c29069), LL(0x90438cb7ba97bc22)}, {LL(0xf154868da5a21e91), LL(0x1ee7fdd0685638b6)}, {LL(0x5419f3b64d7cd272), LL(0xd2de20fc7e0f4be0)},
			{LL(0x81c25fff43687153), LL(0x71020a40201f9b36)}, {LL(0xa75bc988fcab2717), LL(0x2725b12a15e3fd91)}, {LL(0xb5fddcea48f0984f), LL(0x98d93b1c0ec089a1)}, {LL(0x12a61562b45bbf58), LL(0xbffc8a361b237430)},
			{LL(0x84e5bae26159f002), LL(0xf034e44fc6f503f9)}, {LL(0xf3423a3eb1d7f565), LL(0xf5fb91d66becb671)}, {LL(0xd0fc49542c252270), LL(0x22eac4b3b8fa4819)}, {LL(0x650195be64d5ba3f), LL(0xba33ffafb63ac1b8)},
			{LL(0xfb1a8fb7e1c0df33), LL(0xdf8be2ce6741cbeb)}, {LL(0xc25a5c36987e9d28), LL(0x9d164e85a3d93c29)}, {LL(0x7de989e694ecc4c5), LL(0xc4a36a87a20e46d5)}, {LL(0x6a6879990286facc), LL(0xfa690ebe5fc7aa2a)},
			{LL(0x5223f4a071e32cad), LL(0x2cfa94f67b021a6a)}, {LL(0xf665df2393e67434), LL(0x74cd7fd98d062ebe)}, {LL(0x3a5d318a67103d95), LL(0x3d8ff64e277f3e87)}, {LL(0xdf95a5734a766283), LL(0x62b035a25107238b)}
		}, {
			{LL(0xcd6118711b69f937), LL(0x5237cbafd6541969)}, {LL(0x3b4adbd8f8038b93), LL(0x1c937d52c35a7b03)}, {LL(0x571e87e44e6345db), LL(0x1adb0680194bc063)}, {LL(0x248d3414d320fb38), LL(0x0238294ef70f6920)},
			{LL(0xa135444dad09377f), LL(0x547fb07d0c45a209)}, {LL(0xed3ed4a62f72a0b6), LL(0xaeb6d828c29b3c72)}, {LL(0xf09047ea96ad81a0), LL(0xcfa091b166ae08ad)}, {LL(0x0d60f5c6a333ecb7), LL(0x1fb7a13baeb3c733)},
			{LL(0xe48cd9a36b7aeeb8), LL(0x4fb843da8fe8b77a)}, {LL(0x4605df2e1df141c5), LL(0xbac501815bfd20f1)}, {LL(0xaaee35c87bfd28cc), LL(0xcacc360ad1560ffd)}, {LL(0x7ef346363e705254), LL(0x07548ef540f76e70)},
			{LL(0x06bb844375c7f304), LL(0x8104274c73a06ac7)}, {LL(0x086733450d7687b1), LL(0x3fb1745105439876)}, {LL(0xfb4b366f40599e13), LL(0x511317c6bbbda559)}, {LL(0xeb8550e55ab553b2), LL(0x2fb2ff64b13b56b5)},
			{LL(0x12a71a0a88109c1c), LL(0x011cf5279ae6d510)}, {LL(0xfc258c6c7ce0a4a8), LL(0x0ea8df29802ddce0)}, {LL(0x03bc42c0db829802), LL(0xa102f226d8503582)}, {LL(0x3091aa5d2ef79420), LL(0x8220fb251e49d6f7)},
			{LL(0x6e3d20bc249c9ff5), LL(0x79f566574a719d9c)}, {LL(0x86043299a5ab5445), LL(0xf7456b15231afeab)}, {LL(0xc76f57b484e32f3b), LL(0x123ba27b4377a7e3)}, {LL(0xc1d4d3f7f124dc3f), LL(0x933f853730d7cd24)},
			{LL(0x430219adb3b42ac3), LL(0x9ac3d4ebf00d7fb4)}, {LL(0xd97d8638e6be962f), LL(0xd22f19c43f12a6be)}, {LL(0x4ddeaeabcb055e76), LL(0x247687f686ee8d05)}, {LL(0x8fb63f9ce1a31a4b), LL(0x164bf0e76e6975a3)},
			{LL(0x91a4ee1083fea35f), LL(0xd65f4b58120c74fe)}, {LL(0x3df15f9b8dc47897), LL(0x9d975a1eb0fa11c4)}, {LL(0x1dae934cb9df2116), LL(0x61164999a43534df)}, {LL(0xf32c052a4d2f19a2), LL(0x6ea26397befe3d2f)},
			{LL(0x7848c2754bb7a150), LL(0x8650a9b9335704b7)}, {LL(0x5f79b4a14315c26a), LL(0x256a72d11c085815)}, {LL(0x0a0e4fc59f8ad60c), LL(0x400c69d49523be8a)}, {LL(0xa8874948e9017971), LL(0xb5712b8f41362901)},
			{LL(0xf597816938e8eaa6), LL(0xefa644dbcd5e57e8)}, {LL(0xcf0864f18995a88a), LL(0x2d8ad62a46343f95)}, {LL(0x752837b3e8844de7), LL(0x99e708829de4c384)}, {LL(0x9a7f9f95550abcec), LL(0x48eccd2fcf1fd90a)},
			{LL(0x9816e315c7f6ed51), LL(0x3751d0aa5f7ffff6)}, {LL(0xa43282ce034c5c79), LL(0x74796517a7b5fd4c)}, {LL(0x702ff13046c126e1), LL(0xb9e1dde836149cc1)}, {LL(0xf7fefde9aa14bb1b), LL(0x901b595e5d3e7114)},
			{LL(0x3144941d67895d9f), LL(0x5c9f14865679c589)}, {LL(0x4e62ec6b1087c674), LL(0x857475d05ebeb887)}, {LL(0x846d4e19375705f8), LL(0x88f87690b37ad857)}, {LL(0x77414b337a781c5a), LL(0xe65a15070d84e578)},
			{LL(0xb529da0450de5867), LL(0xd4676216e5031dde)}, {LL(0x2d3f39119728b536), LL(0xe336b2bcba7ce228)}, {LL(0x9cc41bd620cd4fe8), LL(0xc9e8ea63bcbfb3cd)}, {LL(0x50703de772da7f60), LL(0x4560ce6f22dbb9da)},
			{LL(0xbbf56d02286f2cd2), LL(0x6ad2310b93e0ef6f)}, {LL(0x1675e2c96f2b3ea5), LL(0xffa5cfee7926992b)}, {LL(0xca0fa27227d0c38c), LL(0x0d8c0340edc460d0)}, {LL(0x02697c8092fc51bd), LL(0x7fbd1d85906026fc)},
			{LL(0x678f2db96094d1fb), LL(0x98fbfda507021694)}, {LL(0xe7309b63b0f876ba), LL(0xeebab1fc57b882f8)}, {LL(0xe9ec2c65c849020f), LL(0x500fe2e1215b7049)}, {LL(0x890dbbdf9464e94f), LL(0x974fd7ab1dc91f64)},
			{LL(0xc9b3e0b2fc525b8e), LL(0xac8ef16635945552)}, {LL(0x2cea0751de567c89), LL(0x3d895d1ff24cf156)}, {LL(0x0507c683ae456b06), LL(0x2006d56aabf05f45)}, {LL(0x769475733306d5e5), LL(0x38e5faa445b4f606)},
			{LL(0x8e6301dca8ddd3f4), LL(0xc8f41f44265966dd)}, {LL(0x45b99deec673d9c7), LL(0x1bc7f3a783ad1573)}, {LL(0x1ac0294f85661bad), LL(0x3ead81769fa54d66)}, {LL(0x4fb7d22b59f90fcb), LL(0x5bcb9a73168eabf9)},
			{LL(0xc001edb7b85a1580), LL(0x4d806a9478e7de5a)}, {LL(0x88d8859fdd1a20f0), LL(0x49f0380855f90c1a)}, {LL(0x5eac8ae10a6b0bd5), LL(0xfbd59d7254384b6b)}, {LL(0xe559e7e322042707), LL(0x9107ac79c7d8a404)},
			{LL(0x9f785916fb4fd7ea), LL(0x68ea184564ef864f)}, {LL(0x7d4f04f6e5f2ca56), LL(0xa6567cd398a75bf2)}, {LL(0x8ab1f91f4fe6714d), LL(0x364d258dc5992ae6)}, {LL(0x9ead6756b2311e55), LL(0xb655f7e62cdf9531)},
			{LL(0x8303f41a0bee3f43), LL(0xd743be7f88eaa1ee)}, {LL(0x17a0dc892655f71a), LL(0x211a204d31168a55)}, {LL(0xef57a826bd8ef10b), LL(0xd10bc5ad52fb1a8e)}, {LL(0x7393b3f09d43bee3), LL(0x18e32fceee44a943)},
			{LL(0xddaf7efb01853496), LL(0x2c96230ddcd2ea85)}, {LL(0xd5c84dbe0cf3b327), LL(0x1327575cd99172f3)}, {LL(0x52194167e0262edd), LL(0x3addd3eab2bb9f26)}, {LL(0x665a13f929ea1844), LL(0x464412064f3205ea)},
			{LL(0x35966cde80b2ff26), LL(0xa2262e4fb5b989b2)}, {LL(0xcedd5ab1c0eb6135), LL(0xf33539890e042ceb)}, {LL(0xb24760076c6762dc), LL(0x8bdcaaf9de936467)}, {LL(0xf62bc3a9e36a72a4), LL(0x4ea4b6fd150e626a)},
			{LL(0x74fd09f3a1fa8458), LL(0x4758e721d5d4d0fa)}, {LL(0x490c56682c3efccf), LL(0xdacfbd3f652ec13e)}, {LL(0xb8492fc2f3edb4d0), LL(0xcbd0c32d4bb0daed)}, {LL(0x42d727edfacae37c), LL(0x447c3b48b83d6cca)},
			{LL(0x72468db0d43d775c), LL(0xc65cc06da674ba3d)}, {LL(0x416b652d21487b7e), LL(0xe57ec96e606d5948)}, {LL(0x816a889a99126efe), LL(0xa8fea3fa188a8712)}, {LL(0xff99ceaca7623caa), LL(0xafaa2d0f587de962)},
			{LL(0xdfc6027b9379652b), LL(0x532b3e884cb2cc79)}, {LL(0x4c0b90eb827b97c9), LL(0xfac96855cede9e7b)}, {LL(0xdb14fab87442c792), LL(0xad920441af728042)}, {LL(0xafe9f34bd5b843ca), LL(0xeacae3607aa650b8)},
			{LL(0x6aefd87fc3a73d4c), LL(0x874c5c9ea9b1d1a7)}, {LL(0x32f8d6ddbc0bc59d), LL(0xfd9de6a08e29f00b)}, {LL(0x15c9a009b4a9a6a7), LL(0x5ea73dc8a176aca9)}, {LL(0x94a328932dbbc859), LL(0xf6599e32b9fc2bbb)},
			{LL(0xd11ab57debc8119e), LL(0xed9e6d953a513ec8)}, {LL(0xf2f93b6a0451d01d), LL(0xb01d8c34f6ce2e51)}, {LL(0xe05e21608c414c01), LL(0xb10179136c28fb41)}, {LL(0xa35c38cd3ff566c2), LL(0x2bc2adf89c2584f5)},
			{LL(0x3c2461dbc4bab128), LL(0x4328b5bdf8ca02ba)}, {LL(0xee829666f4f038b4), LL(0x0fb42a0e1acb09f0)}, {LL(0xf442bf2971962319), LL(0x3119ab78856e4496)}, {LL(0x26e4489441dcaa85), LL(0x7d8534cb676f4fdc)},
			{LL(0x2236b057a6e7083c), LL(0x833c0e0284af03e7)}, {LL(0x60e197ba5c2deb40), LL(0xc740354a3c926f2d)}, {LL(0x111b58ca5392041e), LL(0xa01e070142b6e092)}, {LL(0x3e4d1d5b5646e095), LL(0x3c95a83868aa2446)},
			{LL(0x1fc7efcc2b2370ab), LL(0x1eab541c34551223)}, {LL(0x0bdb7185d6f41fb3), LL(0x9eb38677dd13adf4)}, {LL(0x7f267876770e9beb), LL(0xd9eb615608c77d0e)}, {LL(0x87d10cd9ecd59dfa), LL(0x29fa84b66b2aedd5)},
			{LL(0x3f98231b1f38292a), LL(0xe22a479b209a3738)}, {LL(0xfa9e082f092757ac), LL(0x8facf865f38db627)}, {LL(0xdac1c4f83d3c0e2d), LL(0x732debe2e742933c)}, {LL(0xd6740f7ed7712b25), LL(0xb225a57a01c14771)},
			{LL(0x6fe81efc6de2564a), LL(0xa74a89f402418ee2)}, {LL(0xe83912258137cbb0), LL(0x8eb00d42696b6337)}, {LL(0x80bfb6dad06ca741), LL(0x76414c5950ba946c)}, {LL(0x2838ff92396dde30), LL(0xc33067d6118cbd6d)},
			{LL(0xcbda9c326eae0a33), LL(0xd333ece3a5f473ae)}, {LL(0xb69598c48b5cc065), LL(0x756590303d53285c)}, {LL(0x2f56459105d4e48b), LL(0x9c8baf392a1cc4d4)}, {LL(0x799dfc3502c968ef), LL(0x58ef461a7b6717c9)},
			{LL(0xecebeae6660c6909), LL(0x7009378b8aab2f0c)}, {LL(0x37ff105e124eae9b), LL(0xdd9b33ca25d9af4e)}, {LL(0xb99c1182ba937d6f), LL(0x156f2c8e0380c993)}, {LL(0xc6ba69f4cd9de684), LL(0xcc844dd80b47b49d)},
			{LL(0xfe4cf0ecee1cf515), LL(0x7115c2ac104dfa1c)}, {LL(0xae3ccd0b9cc68a75), LL(0x34750cc3329643c6)}, {LL(0xb02e1c87fe9b3361), LL(0xf461b77c4ef3429b)}, {LL(0x64336f79bb1649f9), LL(0x39f90f83df522316)},
			{LL(0x1b15170fcc18d212), LL(0xe0126ed5d7955e18)}, {LL(0x48d9682865403570), LL(0x0470529c2d1ed240)}, {LL(0x1372244ac16e55a3), LL(0xdfa31a84d2d6c66e)}, {LL(0xd2a6f7bd304a899c), LL(0x4c9c9fb3e2010b4a)},
			{LL(0x69539abf1825a54e), LL(0x264eaeb871e1e425)}, {LL(0x1c7bad0cf0a1e8a9), LL(0xbfa9a63aec0527a1)}, {LL(0xa78ec00ed8cec47b), LL(0xd57b97317fe5c8ce)}, {LL(0x85b870597e29cc47), LL(0x56479933fb4acb29)},
			{LL(0x7c9a3ab6ac8c03e9), LL(0x78e99370d097488c)}, {LL(0x47d0e16e548f887a), LL(0x647aee2213cd338f)}, {LL(0x6886a4ff515b6cf1), LL(0xf8f1411b39d1f75b)}, {LL(0xa65bfe4e91b00dc4), LL(0x0bc4789237d5dbb0)},
			{LL(0x197c6b8f5ee483af), LL(0x9faf735047f578e4)}, {LL(0x5cc5f66198975a68), LL(0x846880f7c4586d97)}, {LL(0xe18b1f20c53f85be), LL(0x6fbe96b02418e83f)}, {LL(0x01d53e40497ec9bf), LL(0xdebfefa34830137e)},
			{LL(0x3923a7586affda2e), LL(0x632e60d7533a5dff)}, {LL(0x6c545c3cb660ce48), LL(0x06487bd2da11bb60)}, {LL(0xa9527708a07fb0ce), LL(0x6bcec42c09063a7f)}, {LL(0xc26891372aa6443d), LL(0x323d7711e887f8a6)},
			{LL(0x2b84bd52e2ef4632), LL(0x623295f0c9dc88ef)}, {LL(0x957616d364c501e6), LL(0x28e67191f1cc38c5)}, {LL(0xbf2795c1cf548e6b), LL(0x946b0bc27020a354)}, {LL(0x076eba033cb93abb), LL(0x5fbbc8ef3b9079b9)},
			{LL(0x38f6991823811391), LL(0xbd918f741b0a4e81)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x23e38e17ef99c183), LL(0x5d83e1a1cc9f1099)}, {LL(0x9071d050ca806ae0), LL(0x08e0a4fb5a3c6780)},
			{LL(0xc3bdaf7763d88d82), LL(0xec8298b2a0b7ebd8)}, {LL(0x5d10c821d1e993d7), LL(0x5ad76f548c687ee9)}, {LL(0x8b64c75f0698b8f2), LL(0xe8f2ca2e8da93998)}, {LL(0x4ab014a8f7bc64cd), LL(0x7bcd4f19bd7ef4bc)},
			{LL(0x446ca3ae8f0d1078), LL(0xc5781c04cb9d060d)}, {LL(0xa0e07a0de477fec0), LL(0x8ac05fde4475b177)}, {LL(0xb3925e472519ab63), LL(0x5563455a96a37719)}, {LL(0x25580a549a5e3287), LL(0xdc87c6edbf3f7a5e)},
			{LL(0x82d6ca5a4290f6fc), LL(0x09fc51dcc0dab290)}, {LL(0xde133c3bda07ac94), LL(0x8d94d12b0482df07)}, {LL(0x0cb5cb86ea4d2508), LL(0xc1084e98e683d44d)}, {LL(0x205fccd7341b5981), LL(0xfc81138714cf251b)},
			{LL(0xfdf0b22c359e6d17), LL(0xd017308ac81dcf9e)}, {LL(0x53cc7f27a958e762), LL(0xe4623c49fa8b8c58)}, {LL(0xb4fce44419a091d8), LL(0x0ad88db5ad330ea0)}, {LL(0xc866def2b52c9231), LL(0x72311ec57da4462c)},
			{LL(0x18a955cf179a4a10), LL(0x41109cf30fc56b9a)}, {LL(0xd0cf8b3da2b6d821), LL(0x3321823672612db6)}, {LL(0xb740a684c22209da), LL(0xabda7f9375633b22)}, {LL(0x5577fb64dc9f1466), LL(0x65661b05892be69f)},
			{LL(0xc4d315745f61b739), LL(0xb339505d9b279261)}, {LL(0x6288eb3aced1bafd), LL(0xb8fd28cfacf249d1)}, {LL(0x09b20d0544084e0e), LL(0xe10e9bf24d738b08)}, {LL(0x59c230e236d2316e), LL(0xa46e559d6fa832d2)},
			{LL(0x29edc1d27013178f), LL(0x1d8f887559bcae13)}, {LL(0x3443529ec9cc3699), LL(0x7c99c1ecfd899acc)}, {LL(0xba2053426111e56d), LL(0xb46ddea8dbd0fc11)}, {LL(0x6b3ae63f8ad9f4f3), LL(0x59f3b33de181c2d9)},
			{LL(0xb1fb22c7b7e5fade), LL(0x2ade58df06c351e5)}, {LL(0xccb4263152173088), LL(0x8c88240c9e640a17)}, {LL(0xea506ea513cb9a0d), LL(0xf10d10c7f90b45cb)}, {LL(0x2a518312ab918f8d), LL(0xbc8d7a5381ec9b91)},
			{LL(0xbef2ab81862a47d4), LL(0x4ad4e4613810b02a)}, {LL(0x971f6a53f639505b), LL(0x575b6c1461ac1e39)}, {LL(0x58170ea27facf8d1), LL(0x7ad1ba3e279821ac)}, {LL(0x9218acd0587c3b5d), LL(0x775db97eca5c417c)},
			{LL(0xe3e263a057c3d403), LL(0x10038b35b478cec3)}, {LL(0xac55b18b0e3adbc8), LL(0x4bc81146a2f6653a)}, {LL(0x40be5b6d6836b2c1), LL(0x3bc126cd285d4a36)}, {LL(0xad808fcb47441277), LL(0x9577fee5eac67644)},
			{LL(0x273176d408a2633a), LL(0xa33adb682f5f5ca2)}, {LL(0x8ddf431c735f4bf6), LL(0x69f6ed62fe09535f)}, {LL(0x04d2f8c3e73ba2b9), LL(0xfeb93ac9e3c04c3b)}, {LL(0x10ce668a1aeccda1), LL(0x7ea1e8a20a86f3ec)},
			{LL(0xa5e7bc8e4a3295c6), LL(0xaac68ab4ef85ee32)}, {LL(0xa289068d768baf7d), LL(0xf57d425bd415978b)}, {LL(0x362a2e1e5b306724), LL(0x0324dc696de9bc30)}, {LL(0x51a503a73ba4b6df), LL(0x9bdf21cc6aebaaa4)},
			{LL(0x56cbb9a4071d8c64), LL(0xc464e923517bd31d)}, {LL(0xd373c9fd79344023), LL(0x92237010aa311834)}, {LL(0xab3b0b883283e173), LL(0x1473d9a999661c83)}, {LL(0xbc9bd70114d61669), LL(0x3569f9e4a87096d6)},
			{LL(0x141c9e49fdd76f18), LL(0x8018d26be946bfd7)}, {LL(0xe2375de01ebd1dbc), LL(0xcebc6496fc48ddbd)}, {LL(0x635dd57a87af7342), LL(0x6642c76ce4c25aaf)}, {LL(0xf14579aadfd3481f), LL(0x111f7e122e9e1bd3)},
			{LL(0xd41d73fe458d7a98), LL(0xcd98b8ff91a1618d)}, {LL(0x9baaa1d51c747553), LL(0x9653228c872fca74)}, {LL(0x96ca5413bf4799e4), LL(0x89e483b7299c0d47)}, {LL(0xf9224aefd2a5cfae), LL(0x2eae0a432bdd83a5)},
			{LL(0x54a2c52495e1ddd9), LL(0xbbd9f4a6c11bf5e1)}, {LL(0x332de89df5750c22), LL(0x23220903c619e375)}, {LL(0x7bf480b590353952), LL(0x27525b9feb073135)}, {LL(0xe6e5a523f986bf05), LL(0x30055e5f1f889186)},
			{LL(0x5a7e7222ed50a96c), LL(0x056ca7bbb7f80750)}, {LL(0x5bab4c62a42e60d3), LL(0xdbd34818ffc8142e)}, {LL(0x6134a9fa155322ff), LL(0x19ffdae974a27c53)}, {LL(0xd7a1313e9e0fe29a), LL(0x6c9a4ad949f1540f)},
			{LL(0x3a9fe598b17d422c), LL(0xc22c92f18b6a687d)}, {LL(0xdc7a40bb48fbfd29), LL(0xf229ccae94e2f9fb)}, {LL(0x71facf700fbfef5e), LL(0x675e324b7e248fbf)}, {LL(0x9d11259669b38657), LL(0x175705c0f48fa0b3)},
			{LL(0x7a21bef5d94bf0ed), LL(0xf9edb43ca337224b)}, {LL(0x65e65139f2688046), LL(0xe746e02097623068)}, {LL(0x2e837bd14caa2d34), LL(0x4234409a622cd7aa)}, {LL(0x4b652ae8bec2ad72), LL(0xa572a0baf54ee7c2)},
			{LL(0x0edcb70678b174b5), LL(0xbeb5531d76e3f2b1)}, {LL(0xf8f774af9bdb0611), LL(0xf011e5e063ed90db)}, {LL(0x93cd92901102f2e2), LL(0xa9e256dd826c5202)}, {LL(0xbd4ee9415da8dfd6), LL(0xebd61647e04085a8)},
			{LL(0x99c3dd558e8824ee), LL(0xe9ee3f09174fec88)}, {LL(0xd8a8b878afc05f90), LL(0x0c90f6677722b5c0)}, {LL(0x1e12d18c625db914), LL(0xc014bbbf7c65015d)}, {LL(0x218af2977d65903e), LL(0x223efc245cff3665)},
			{LL(0xc5062b34161f7e86), LL(0x6d86bffed317811f)}, {LL(0x8c0a7d5c3a218249), LL(0xb74902c1b6394021)}, {LL(0x6d81627cff1e07f7), LL(0xd8f794719221a81e)}, {LL(0x0f09894631cfbd0a), LL(0x600abcbe3ed3e1cf)}
		}, {
			{LL(0xccaa9a639a4178a8), LL(0x1b8e63bf2db66b6d)}, {LL(0x9b3742c942ad31b4), LL(0xf815c9c0cb2980c6)}, {LL(0x1018d590d529de96), LL(0x4ef0907ad240edbc)}, {LL(0x79a4cc37cc7ce41e), LL(0xd3e237d7b6279a97)},
			{LL(0x47850d3a0dc5978a), LL(0xad6b3a0534df0617)}, {LL(0x05e68d2d8dcd02f5), LL(0x2f332db071146154)}, {LL(0xbf018f0e8f64989f), LL(0x960a0ecb79b93352)}, {LL(0x3fc1e804e8efa7a5), LL(0xa386049d26fc57fb)},
			{LL(0x8acfbe50bed23b13), LL(0x6bea50f5bd6da601)}, {LL(0xb904793879532539), LL(0x1d2838aa27a1cc8b)}, {LL(0x90d8b29ab2a2e1ac), LL(0x7b7c9a2c8d058915)}, {LL(0x567df1a3f1ba9d2d), LL(0x3e94a330429b20d0)},
			{LL(0xe89c57a45788d183), LL(0x7591a4b49f26d8f9)}, {LL(0xa31375f27523ff86), LL(0x0dbef27317c9e39f)}, {LL(0x685c30ae3003eeb9), LL(0x401daee2c063bc50)}, {LL(0xed7ada89da45d376), LL(0x5aa28904ee32b9ad)},
			{LL(0xdd5266fa663e720f), LL(0x8871fa8a5bf24daa)}, {LL(0xacfa218521b7f95a), LL(0x7ceb856084f54063)}, {LL(0x744eca52ca4489a0), LL(0xdba9525aae136c9d)}, {LL(0x4c6afd69fdca4792), LL(0x2e0269e972f30fc4)},
			{LL(0xd35b1b841bfca0e2), LL(0x242b84d66cca252d)}, {LL(0x4a6f0b5f0bfdfa34), LL(0xa5205f882cebf01d)}, {LL(0x37cd634c631ac8ee), LL(0x84fe4ca04fdcc0a5)}, {LL(0xdf5134e83492196d), LL(0xf16fe814d0fa185c)},
			{LL(0x25d6e4cee49f7d1a), LL(0xb310ce44169478ef)}, {LL(0xf964ab3dabf7db24), LL(0xe66e3d81e962fe3e)}, {LL(0x6e59c698c634531f), LL(0xcb3f98839e7b4389)}, {LL(0xc546382238e2c3d2), LL(0xe1f922cde0923748)},
			{LL(0x0beff053f00fd018), LL(0x836953ec462c09d3)}, {LL(0x73ab156d1525e037), LL(0x8d846d74540f583f)}, {LL(0xbae7022302a99a6a), LL(0xb939237b08ad5206)}, {LL(0xcb4f455c4520113f), LL(0x4da35c91d7aa5fcf)},
			{LL(0xbee1a607a6324cae), LL(0x4b050784ddbdf829)}, {LL(0xb30ba062a00a2110), LL(0x434e6209c5890e23)}, {LL(0xfb67f92ff95bb046), LL(0x9f702f1f626aabc8)}, {LL(0xc8ac3e473edaae6c), LL(0xe9b24740f8a6c142)},
			{LL(0x23d312f812a8c0bc), LL(0x3832f825488c8736)}, {LL(0x94de16be16393768), LL(0x8940bed35815233a)}, {LL(0x81204e034eddeb0b), LL(0xe8830319fb41afd2)}, {LL(0xdcb24ff34f68a63e), LL(0x557ef3c5fff686d1)},
			{LL(0x84c6c32ec310e9fe), LL(0xc7b02ea98a55ce86)}, {LL(0xdb5790cc9009cfa9), LL(0x0353cceb05eab273)}, {LL(0x1df2d3f5d311b328), LL(0x46bbf5f7ca741bb6)}, {LL(0x7ba79e259ed08f7c), LL(0xaafc25493d2fcf61)},
			{LL(0x6050bbe6bbf681f2), LL(0x6765e6dfa9432b0e)}, {LL(0x1a170cca0c70dabf), LL(0x1096cad930682f14)}, {LL(0x121b87828785b5f4), LL(0x37ee82e45948b84a)}, {LL(0xd954c2dec2a5a4cb), LL(0x7a4dde758ee2e785)},
			{LL(0x724b3c643c733406), LL(0x508b643bf00b9344)}, {LL(0xf68dff4aff63ddf8), LL(0x973b4a927a5e5dc2)}, {LL(0x342e185718e077bd), LL(0x20ef577160d05e28)}, {LL(0xd4bec4bbc49dc975), LL(0x7206bbf896d6118f)},
			{LL(0x39c41e321ed81a03), LL(0x28a432fc78e4a822)}, {LL(0x6dbabd83bdceec4c), LL(0x6f2e8352b177dd04)}, {LL(0x080c8b488bf56f4b), LL(0x2778483d6920975e)}, {LL(0x58748cdd8c784fc0), LL(0x92cedd6c75a34857)},
			{LL(0x5c7228f928e39904), LL(0x60f2f993a0b3e278)}, {LL(0xfe8174027496b2b3), LL(0xb04302af137eca9c)}, {LL(0xb50e5654563d9cb6), LL(0xc86c54689b91f1fa)}, {LL(0x2dda6f866f6a1251), LL(0x946886797fb4efb1)},
			{LL(0x7c42411a41b1e6eb), LL(0xfcd11a67c733fbc3)}, {LL(0xdab7b9c5b95f1b98), LL(0xde5cc5a4a1ee7908)}, {LL(0x9cd29df69dcc5823), LL(0xae38f6ee3135b464)}, {LL(0xf56e8451849962ab), LL(0x332a51435552c34f)},
			{LL(0xe97c7ead7ede05b2), LL(0xa89eadfb3b221382)}, {LL(0xcd4ab36ab317ac99), LL(0xc6816af089b2a016)}, {LL(0x7e411308131d8d89), LL(0x85cf08f94c3bae35)}, {LL(0x362d4a454a4c1cdf), LL(0x59f145efebd80bde)},
			{LL(0xf36b726772aedf0d), LL(0xb80867220b4a3c96)}, {LL(0x01e029092956d431), LL(0xdd0f094fa404cb7b)}, {LL(0x9f31e6ede636e770), LL(0x0a29ed3f1e392ae9)}, {LL(0xa6f5f8dff8eefd73), LL(0x228ddfc366dd82cb)},
			{LL(0x4060d205d2a4fe1d), LL(0xfb46052bcec332b5)}, {LL(0x22333bf13bfe148d), LL(0xe53df16aec884c4d)}, {LL(0x5994a5d4a52e9bf1), LL(0x4fc1d423d1a7832c)}, {LL(0x6c5a948a9498387d), LL(0xb2218a1d1573167f)},
			{LL(0xd6bd96a99631a217), LL(0x0b18a9661dde4479)}, {LL(0x4180fb0cfbf22a2c), LL(0x26490c646ac7f9ce)}, {LL(0x5d9201f001b54d35), LL(0xbdfdf0dc04b72903)}, {LL(0x69bc19a719553a88), LL(0x9d12a7ad6467772b)},
			{LL(0x498c704470074567), LL(0x0131445903e76e90)}, {LL(0xea9f05b60524bae1), LL(0x0c8fb62a142e8d0f)}, {LL(0x8cca486648e586b5), LL(0xe0c86694e37559d8)}, {LL(0x70486e766edf5f64), LL(0x299576a57b03c6b2)},
			{LL(0xd0b8609f60061fb1), LL(0x803a9f0743c6bba0)}, {LL(0xb8e450315005f108), LL(0xc02731e583a507f0)}, {LL(0xb6ed2d4f2dc723e5), LL(0x6c7d4fb9b49d6f77)}, {LL(0x579dd8aad8ec491c), LL(0xe39baa7fe69febab)},
			{LL(0xad1a088c08e12d6b), LL(0xa1e48c2f20f18b18)}, {LL(0xdeb11de11dc4cd5c), LL(0x2c60e15b74fed327)}, {LL(0x4d8ad460d49c93a3), LL(0xf30d60a6d6f7c4bf)}, {LL(0x09eca241a2a3bb7a), LL(0xfa774172cd245c25)},
			{LL(0x45865f285f69fce8), LL(0xd475289bbfd753e1)}, {LL(0x7da2681368e732da), LL(0x21de1328633730b8)}, {LL(0x8ec91a741a49edd7), LL(0x99d6740a687d0c2e)}, {LL(0xd8b4ebd7ebf370fa), LL(0xa742d73a2ae62cfe)},
			{LL(0x11f8fc99fc7f0aa7), LL(0x93ff9935764426c7)}, {LL(0x426380178008957f), LL(0x825817b545cb6743)}, {LL(0xa11027e0278f94e4), LL(0x74a0e0ed9cc1b669)}, {LL(0x0c0a2f6c2f6eb98f), LL(0xd5446cc2bc303d71)},
			{LL(0x63b3c0fdc00c3ea1), LL(0xc374fd0e864fb583)}, {LL(0x141e71b471b20852), LL(0xbcccb48507504793)}, {LL(0x19f477d1778a65ec), LL(0xb487d1081f64b199)}, {LL(0x973d6da56dc3883b), LL(0x2d51a5027719bdb7)},
			{LL(0x5a77decfded424a2), LL(0xebd0cff2feab1da1)}, {LL(0xe77503d3031cd75f), LL(0x04c4d3a70c1a7b05)}, {LL(0x3a2765296522a550), LL(0x8cb5292d57e836af)}, {LL(0x1ff181e781bdd84a), LL(0x3fa5e769417c4e40)},
			{LL(0x5f9153e253192657), LL(0xc4e3e2428fbf7cf5)}, {LL(0x71a8477f47898b55), LL(0xf49a7feadf070dc9)}, {LL(0x0fe95477549406dc), LL(0x71557713933ca3fc)}, {LL(0x21d040ea4004abde), LL(0x412ceabbc384d2c0)},
			{LL(0x91389b939bf4359d), LL(0xa67393632901426e)}, {LL(0x98d439d239578ee7), LL(0x5c04d211e4251e4b)}, {LL(0xa91caca8ac7afbaf), LL(0x53d8a8d0f5e12137)}, {LL(0x07e5df3fdf616997), LL(0x562d3f2efa1c34a2)},
			{LL(0xe2938efe8ed1d5aa), LL(0x2bf7fe177d0e1a51)}, {LL(0xd75dbfa0bf677626), LL(0xd617a029b9da8f02)}, {LL(0x7a47b72cb7865b4d), LL(0x77f32c06992b041a)}, {LL(0x66554dd04dc13c54), LL(0xec47d0bef75bd4d7)},
			{LL(0x2bdf99b0995daff7), LL(0x1f4ab01821ac1068)}, {LL(0x44667621763f28d9), LL(0x097a21d41bd3989a)}, {LL(0x8d2a616f61b35284), LL(0x3dc76fdb477192a3)}, {LL(0x9ed1cfe4cf603341), LL(0xd726e470ba3de192)},
			{LL(0xff615d0b5dc06682), LL(0x6d4c0be0b77a01e7)}, {LL(0x993410db10015ad6), LL(0x810bdb5e4021d530)}, {LL(0xa2f35cfb5c752bb7), LL(0xd0b1fb3cb3cd28e4)}, {LL(0x6a5f62bc62af85db), LL(0x3903bc7c4b6be9a6)},
			{LL(0x2436cdc7cdc9a92b), LL(0x6e1fc70bb290b394)}, {LL(0x0605f636f637bda6), LL(0x8b2236615e18ffd9)}, {LL(0xaef97397731b9238), LL(0x05f597fe0ffd1595)}, {LL(0x92dbe088e00e8ace), LL(0x026288b2060ddce3)},
			{LL(0x29dccba2cbf1c495), LL(0x6654a286aaa4459e)}, {LL(0x88ccec42ec7e5071), LL(0x12f4426b3665f3f7)}, {LL(0x61b092ef92a055c3), LL(0xba6aef900d47e075)}, {LL(0x1bf725c325260e8e), LL(0xcd99c396946ce46f)},
			{LL(0xf48ead58adcfb69a), LL(0xee25580cf1560834)}, {LL(0x203069e369527fef), LL(0x9c23e3f4678019bb)}, {LL(0xee99a192a1bf6c25), LL(0xfeb392d5c13e2720)}, {LL(0x283ce2abe2a710a4), LL(0xbb5babc90ea08ee5)},
			{LL(0x527b558755214be9), LL(0xcca887cf978b8aff)}, {LL(0xf28b5b6e5bf80b3c), LL(0x65076e6daf4ef7ed)}, {LL(0xf16820752002b46f), LL(0xc11675bc80426960)}, {LL(0x2e39149d1490ad02), LL(0x30799da850b8713c)},
			{LL(0x17fd0aaf0a48b701), LL(0x18ddaf54285cd91e)}, {LL(0x96dd44ac44955c0a), LL(0xf05eac4dd31d76cc)}, {LL(0xaf195a9e5a4d4609), LL(0xd8fa9eb1abf9deee)}, {LL(0x3e21c10dc1b97394), LL(0x7e890dd282f89c80)},
			{LL(0x0e097d7e7dc2d2ed), LL(0xac5a7e5c37386887)}, {LL(0x953e3fb73f6fe359), LL(0x544fb79cfc11e841)}, {LL(0x3bc74c204c747161), LL(0x51ba2062f3ecfdd4)}, {LL(0x83231c111c718069), LL(0x919d11877049fa24)},
			{LL(0x0a0fd95ad9590429), LL(0x5e665aa3e228c2a8)}, {LL(0xc7456a306a4ea8b0), LL(0x98e730536b9a62be)}, {LL(0x161d23a6231e6330), LL(0xc5d2a61b8c581265)}, {LL(0x2c3a468f463cc660), LL(0x49678f36dbb024ca)},
			{LL(0xc343ce14ced57e74), LL(0x6adb14acbe8ac891)}, {LL(0x8b2f97599784ef22), LL(0xb6e559ba19696d7a)}, {LL(0xe49678c878e6680c), LL(0xa0d5c8762316e588)}, {LL(0xab1ffebafed690cd), LL(0x2ac6ba4e7ee974c1)},
			{LL(0x1e11a8eea8eb0c7b), LL(0xe2aaee26e578853b)}, {LL(0xbb072b2a2bff4e5b), LL(0x64362a34aca9997d)}, {LL(0x892cc54bc5288440), LL(0xcffb4b249261388c)}, {LL(0xc4a6112b11b417e3), LL(0x3cf62b824496fc33)},
			{LL(0xef79889b88e9b814), LL(0x23bc9b9a653aec5b)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xbd02dd1cddc8f3fd), LL(0xef141c55f2b166a4)}, {LL(0x27d5b6dcb6331678), LL(0xca0edcda9d9c2d19)},
			{LL(0x8725b835b8ea56ad), LL(0x63a13578a559500b)}, {LL(0xeb7f2cbf2c726ed0), LL(0xd180bf65b02a4674)}, {LL(0x75aee35be3125d91), LL(0x06a65b150a17a7e6)}, {LL(0xaaffd7b3d78044fc), LL(0xf7c9b301daedbfba)},
			{LL(0xe170f5e5f52b6af9), LL(0x8fe6e5c6520284dc)}, {LL(0x6bbf4bb54bf951ea), LL(0xe40cb533ef6f22dd)}, {LL(0x9ad76bc06bfbe585), LL(0x251ac08f6f2d4bbd)}, {LL(0x559e8ab88a40227e), LL(0x9a85b8e16d97be5d)},
			{LL(0xfa87d026d00d6477), LL(0x427f2650c66e60b3)}, {LL(0x3dc2ba16ba43ccc7), LL(0xda981603adf4020d)}, {LL(0x13fbae8baed361c5), LL(0xeae18babfd4c7331)}, {LL(0xc94c174e178c7a5d), LL(0x34bd4e0f5ca20a39)},
			{LL(0x80c0670a678b3f3a), LL(0x358c0a565f4564a9)}, {LL(0xa0f00ee90ed940d5), LL(0xa9afe9a238c57d12)}, {LL(0x5e717aeb7a4ff266), LL(0x19eceb0d2bbbb78e)}, {LL(0x50780795078d208b), LL(0xb5b695511c83df09)},
			{LL(0x26359fd59f65c249), LL(0x1701d5953998e662)}, {LL(0x764d984098e8e2c2), LL(0xa2b740c4251b396b)}, {LL(0x2a3fb0b9b00b7bc6), LL(0xc245b95785a8db13)}, {LL(0x486c594d59519156), LL(0xdc3e4d16a7e3a5eb)},
			{LL(0x4383a91ea95e414e), LL(0x5f571efae1cfac38)}, {LL(0xc0a0b50fb52fc127), LL(0xceca0f7d9186561c)}, {LL(0x8f29337d331f39e6), LL(0x44d97d45cc79c755)}, {LL(0x5b97f7c6f782f093), LL(0x36dfc6bd5aafd6da)},
			{LL(0x46652433249343bb), LL(0x7064334a90dbcd6c)}, {LL(0xfc822610263ad9d1), LL(0xc95d103198769f6a)}, {LL(0x15fe58bd58e4dc63), LL(0x61c3bdcaa3548ce8)}, {LL(0x4f8986728630f8c1), LL(0x8a1372385dff9149)},
			{LL(0xc2a3e71de783aa45), LL(0xb7d41de31a8e03ea)}, {LL(0xe090dcecdc7dbec8), LL(0x52e9ec89f6064fa7)}, {LL(0xc1409c069c791516), LL(0x13c5063235829d67)}, {LL(0x322bee61eed7ca1b), LL(0xabcd61103ec8a1f1)},
			{LL(0xa51683c483144220), LL(0x869cc41249d11c46)}, {LL(0xe373a7f7a787019b), LL(0xf6f8f758d90ad12a)}, {LL(0x77adb149b1be36f3), LL(0x7fb8498b811ff210)}, {LL(0x7fa13a013a4b59b8), LL(0x58c001b6e83f654e)},
			{LL(0x4e69af7baf662cf0), LL(0x571c7b77f9fb5a32)}, {LL(0x7844e53ee52a302f), LL(0x0eed3e98122351ec)}, {LL(0x51982e9c2edbf4ba), LL(0x68b99c1eb8871472)}, {LL(0x547ea3b1a316f64f), LL(0x478ab1aec9937526)},
			{LL(0x0dea066506386dbe), LL(0x084b658d1834f60a)}, {LL(0x9d32b4ffb49a8c12), LL(0x7337ffa195317f1f)}, {LL(0xb0e8db79dbf09e43), LL(0xe75f79d8ea8590ae)}, {LL(0x8526ea27ea463dcf), LL(0x1abf27e62e5105fd)},
			{LL(0xf76dd643d63509c9), LL(0x4a3443ddde5a96b9)}, {LL(0x33cbc768c7811e2a), LL(0x76c2685f9acc6a8a)}, {LL(0xa4f6aacdaa429611), LL(0x5b93cd5dedd5d73d)}, {LL(0xf884823482a10f15), LL(0x3b6134ce4d663545)},
			{LL(0x3c22931f931518f6), LL(0x07971f4c09f0c976)}, {LL(0x0203521252ac6b62), LL(0x791e129e8b0855f6)}, {LL(0xbce2f415f49e27cc), LL(0x321b151a56b5addf)}, {LL(0xfd620f190f6c0de0), LL(0x1452197e3c725411)},
			{LL(0x35ce315e31b6a38c), LL(0xfde05e3ec4d49553)}, {LL(0x6253e9f4e95aea90), LL(0x1e7bf441224b7ef8)}, {LL(0xec9af380f3130747), LL(0x87ad804b4a3672d6)}, {LL(0x933bc981c9585eff), LL(0xdf6d81fda2091798)},
			{LL(0xc6a5433943187c81), LL(0x45e8391ccf9ea9c5)}, {LL(0xf088097c0954605e), LL(0x1c197cf32446a21b)}, {LL(0xcf49e178e1bbc7fb), LL(0xbf9f786e02baf5e0)}, {LL(0x3028bc73bc7ba179), LL(0xd2d3738eb5c0f407)},
			{LL(0x64561fc21f6d5736), LL(0x9559c2207c538121)}, {LL(0x3824373b378ece32), LL(0xf5ab3bb3dce06359)}, {LL(0xcaaf6c556c76c50e), LL(0x90ac55de73ae94b4)}, {LL(0xd2bb328d32aa74d3), LL(0xf9248d99c8ceee56)},
			{LL(0x2fd93d943dc67933), LL(0xed7694e7f4bcba47)}, {LL(0x03e37b1b7bfabf53), LL(0xa4111bd12f0c9e8d)}, {LL(0xb4ee7f5d7f6b4887), LL(0x15635d273f953a81)}, {LL(0xb2eb896b895cf521), LL(0x9e416b46618dc558)},
			{LL(0xb70d04460491f7d4), LL(0xb17246f61099a40c)}, {LL(0x65b636cb363b8307), LL(0x4856cb6fd8574a5a)}, {LL(0x31c8957a952d7548), LL(0x0fdc7ac111c43f7c)}, {LL(0x18145ed85edcb1dd), LL(0x6988d847bb607ae2)},
			{LL(0xe6952ada2a4a036e), LL(0xd9cbdae8a81eb07e)}, {LL(0x0406a424a49bd6c4), LL(0xf23c24ffd510aa2f)}, {LL(0x82c3351835275458), LL(0x4c9218c8d44d315f)}, {LL(0x86c5913c91bc829c), LL(0xbeae3c37015d9b70)},
			{LL(0x4b8f225622ab2e05), LL(0x782f56c788ef3b66)}, {LL(0x1c12fafcfa476719), LL(0x9bb4fcb86e70d0cd)}, {LL(0x539b7c8e7c779fd8), LL(0x11a78e80338f4184)}, {LL(0xd15849964950cb80), LL(0x5d359648e7c270db)},
			{LL(0xa8fc85a1852c2f9e), LL(0x8ed7a19f51e5ea4c)}, {LL(0xd55eedb2edcb1d44), LL(0xaf09b2b732d2daf4)}, {LL(0xcea9c871c8ed13ca), LL(0x62907121a6be3e9b)}, {LL(0xe57651c151b0bc3d), LL(0x7ddac13987122ef3)},
			{LL(0x6fb9ef91ef62872e), LL(0x163091cc3a7f88f2)}, {LL(0xb108f270f2a64a72), LL(0x3a5070974e815bd5)}, {LL(0xa715d1d6d1b82942), LL(0xff82d68cc2d949b0)}, {LL(0x67b564d96497e865), LL(0x3148d9f1535f1fac)}
		}, {
			{LL(0xde4d3e3681b6c304), LL(0x8f11725e92ccbe9f)}, {LL(0x8a217a33ba2934c5), LL(0xb532fb900b9b6027)}, {LL(0x648be19c9b407bdf), LL(0xb7bd2db8a8103d4d)}, {LL(0x5a66c8651f2784b7), LL(0xbfc4f31861798a26)},
			{LL(0x30e7a599a0df8c1e), LL(0x8d9ea4763147e3f5)}, {LL(0x8ea7125ea2149426), LL(0xdb705dc4c1055843)}, {LL(0x5ba6d2ef19b9acff), LL(0x45353b0db2bf843f)}, {LL(0xfd74d6854bfcf2c8), LL(0xb4949084bb3faf12)},
			{LL(0x795f20d6d56db57b), LL(0x844111c2488a9bab)}, {LL(0xafddce3a64a1f57a), LL(0xd7d4ec348db955fc)}, {LL(0xc259e5f6c90525e8), LL(0x461c8631a1901660)}, {LL(0xc399ff7ccf9b0da0), LL(0xbced4e2472561879)},
			{LL(0x0fca96ea22265b3e), LL(0x7f16b2c32be85a87)}, {LL(0x14db0b1a78c965e9), LL(0x15897bc764a3d837)}, {LL(0xa918928070630509), LL(0x8eb7194a226871aa)}, {LL(0x816d84b48032cf18), LL(0xa466ef07eaed02c4)},
			{LL(0x2d3364d3eef242ba), LL(0xbe62980cd1dd4513)}, {LL(0x45f13df85df51a83), LL(0xbb199c48e4ac30f2)}, {LL(0xe6654b751113cc1f), LL(0xde0b5980f4742da2)}, {LL(0x789f3a5cd3f39d33), LL(0x7eb0d9d79b4c95b2)},
			{LL(0xebece9483fcac7b1), LL(0x963cb869bad36b17)}, {LL(0x8ce42689aeebc4b6), LL(0xec510eeea44a4471)}, {LL(0xcfd047cbe7dc2e46), LL(0x0e2b67d8ef3750d5)}, {LL(0xc01ad121c5fa7578), LL(0x713dd51bc4df0a52)},
			{LL(0x467213a55794625b), LL(0x76c90777522522d9)}, {LL(0xfcb4cc0f4d62da80), LL(0x4e65589168f9a10b)}, {LL(0x5d638e550d7b5c8c), LL(0x1c56ce731d6ea069)}, {LL(0x7b1c1401d992e5eb), LL(0xb36042e82dc58799)},
			{LL(0x48789fc5732c112d), LL(0xf32e7da1aa0b7647)}, {LL(0x85ebecd9980f6ffb), LL(0xca24495320733aa0)}, {LL(0xd501c0b1bbad38d9), LL(0x9e4566c973badc7c)}, {LL(0xbdc3999a08aa60e0), LL(0x9b3e628d46cba99d)},
			{LL(0xcc536996edbd569e), LL(0xc3fbfce759be42fe)}, {LL(0x7050ea86e3891e36), LL(0xa234567fccb3e57a)}, {LL(0x119d79fd666aed42), LL(0x813a15867dfbee4a)}, {LL(0xc71f9711d7a6ad43), LL(0xd2afe870b8c8201d)},
			{LL(0xb2090f702a8c3bde), LL(0xe428d04e6d23f31a)}, {LL(0xdb0b4cd19f154baf), LL(0x1ba21c1f8b9488e2)}, {LL(0x3127bf13a641a456), LL(0x776f6c63e281edec)}, {LL(0xbac6dfaa1af6b8db), LL(0x38ac5fe63adc83d2)},
			{LL(0xbf80ad4d04553070), LL(0xac1f31a72384b5af)}, {LL(0xd948780693ea1b3f), LL(0x2c834f35eedb94d0)}, {LL(0xd888628c95743377), LL(0xd67287203d1d9ac9)}, {LL(0xb74f7d97342fb375), LL(0x709bbe0f747bc567)},
			{LL(0x9bbc03cedc43d987), LL(0x3408ee1676608e6d)}, {LL(0xbb06c5201c689093), LL(0xc25d97f3e91a8dcb)}, {LL(0x89a2546eb0484c1d), LL(0x78e260afbd12720c)}, {LL(0x3461cdf4b8e22cfd), LL(0xe3dc0222fbd9db91)},
			{LL(0x121e57a06c0b959a), LL(0x4cea8eb9cb72fc61)}, {LL(0xad9efaed685ea5ea), LL(0xe0f5bf1ee8f649ce)}, {LL(0xb50c494038d0e3e5), LL(0x47baed251134d955)}, {LL(0x88624ee4b6d66455), LL(0x8213a8ba6ed47c15)},
			{LL(0x090fca5036e4ab4d), LL(0x267547bd84397ed1)}, {LL(0x27bf80ded277912f), LL(0x55c7448ee36d29e9)}, {LL(0x32a4914eac20dc8e), LL(0xbabff75c5408ffc7)}, {LL(0x054672e71ea388ab), LL(0x94b36e411958367d)},
			{LL(0x1c14dbc048b3e6ec), LL(0xc90df46f335ca8ff)}, {LL(0x9f3a6ba3c47e7964), LL(0x5a4a4842bcfeb609)}, {LL(0x842bf6539e9147b3), LL(0x30d58146f3b534b9)}, {LL(0x74d682ebfbb4bed5), LL(0xcc76f02b062ddd1e)},
			{LL(0xd4c1da3bbd331091), LL(0x64b4aedca07cd265)}, {LL(0x4ebdc37f67eee15e), LL(0xaa4d88df05da5211)}, {LL(0xe9afdd9f33359721), LL(0xa11deb43df9c7725)}, {LL(0xd742f466b7526849), LL(0xa96435e316f5c04e)},
			{LL(0x983f2d93d622a15f), LL(0xf9d87529c0e99c46)}, {LL(0x49b8854f75b23965), LL(0x09dfb5b479cd785e)}, {LL(0x39e86fc9963b2753), LL(0xabebe3cbb57e9d24)}, {LL(0x5825fcb213d8d427), LL(0x88e5a03204369614)},
			{LL(0x2339e8b3ca4a31cc), LL(0x3b85e2da29f3118d)}, {LL(0x97f5bb79f404fa61), LL(0x86cec7eaeb01c6c1)}, {LL(0x9373d314ec395a82), LL(0xe88c61be219ffea5)}, {LL(0x9a7c1944daddf1cf), LL(0xcef92603a5a68074)},
			{LL(0x5369023529c32ffa), LL(0x99b1b4a5e540f4f7)}, {LL(0x25fcb409de88c1bf), LL(0x62e617a4862235db)}, {LL(0x92b3c99eeaa772ca), LL(0x127da9abf259f0bc)}, {LL(0xb04a3ba726736b4e), LL(0xd3098364086cef28)},
			{LL(0x654bfb169dde5397), LL(0x4d4ce5ad7bd63354)}, {LL(0xc49cb94cddc7d59b), LL(0x1f7f734f0e413236)}, {LL(0x8be160b9bcb71c8d), LL(0x4fc33385d85d6e3e)}, {LL(0x3eed29f98467ff68), LL(0x0879dea0c969b76b)},
			{LL(0xf638280271e70915), LL(0xa5c084135a49cdf1)}, {LL(0xe2e32318092e6cfc), LL(0xb049ffd43eea15c6)}, {LL(0x8d243c03a875ecfe), LL(0x16a0c6fb778c4a68)}, {LL(0xff37e2524703a258), LL(0x83b5c3aede70b320)},
			{LL(0x9130e7c3e0c60a12), LL(0xdfad329444d0e297)}, {LL(0x3828754390a50f1b), LL(0x511a2bde66b8933d)}, {LL(0xfef7f8d8419d8a10), LL(0x79440bbb0db6bd39)}, {LL(0x546c44053b9ff7c1), LL(0x3a2389ce9957deb8)},
			{LL(0xd2048681a9f1e0e2), LL(0x3dd75ba20fadf633)}, {LL(0x57ef6a5831fe8f19), LL(0xf7f312f12fdecc93)}, {LL(0xef6a812527f76752), LL(0xf87e1e3d704d5373)}, {LL(0xa5512a37582426ef), LL(0x3c7130b6bf093906)},
			{LL(0xddce106b8bd7bbdc), LL(0x42c1e9612445acb4)}, {LL(0x433461424937eaf0), LL(0xe27a69364b7d14a4)}, {LL(0x600d89f1837ddb3c), LL(0xd9ff8bec628e0529)}, {LL(0xa394768d4ce6d69c), LL(0x6512c5c810d81d50)},
			{LL(0xf37e5ae56f4481be), LL(0x3173ea524311fb8c)}, {LL(0xbe40b7c702cb1838), LL(0x56eef9b2f042bbb6)}, {LL(0xf9f2bee853c1522b), LL(0xdad636d071a19776)}, {LL(0x2bf63869fa30b2c9), LL(0xe7016d727e0c6145)},
			{LL(0xe1600d45034f1424), LL(0x7d9964eb886307ed)}, {LL(0x7dd948bbcd501598), LL(0xea03b7968214a3cf)}, {LL(0xc1dacbabc3645d30), LL(0x8bcc1d0e1719044b)}, {LL(0xa1d7425a4019860c), LL(0x523396e275970162)},
			{LL(0xe86fc71535abbf69), LL(0x5bec23560c5a793c)}, {LL(0x5ee0a008071a2454), LL(0xd186554cabe7b242)}, {LL(0x73d3c4dbe9e866ee), LL(0x6fe4cd407a3af751)}, {LL(0x35a1d77ebe7c04b5), LL(0x192dca37281fd588)},
			{LL(0x66c8d54b97bf2b4f), LL(0x809c7e92cd5f217f)}, {LL(0x68c2592bb3075839), LL(0x057b0444357175e1)}, {LL(0x512a36e2253c7f6a), LL(0xae90e78f800fe8c5)}, {LL(0x5f20ba8201840c1c), LL(0x2b779d597821bc5b)},
			{LL(0x55ac5e8f3d01df89), LL(0xc0d241db4a91d0a1)}, {LL(0xf0fd74b86525f966), LL(0xfca3716df598e9a7)}, {LL(0xcb562fa6ffe18ea5), LL(0x6069c18c25a968b1)}, {LL(0x638ea7ac891ca3e4), LL(0x142f10d3d4071702)},
			{LL(0xd047b256a50eb072), LL(0x0af608886ae2ea01)}, {LL(0xf2be406f69daa9f6), LL(0xcb82224790d7f595)}, {LL(0x20bac6eec02b4914), LL(0xf65579e59f7a03a6)}, {LL(0x6fc71f1ba15b8002), LL(0xa6e9392f49665fae)},
			{LL(0x80ad9e3e86ace750), LL(0x5e972712392b0cdd)}, {LL(0x4a3bab127fd341bd), LL(0xc40f2e8bcf446a75)}, {LL(0x1ad1877a5c71169f), LL(0x906e01119c8d8ca9)}, {LL(0x0486686d183da0e3), LL(0x6e42a654ca9e3864)},
			{LL(0x08cfd0da307a8305), LL(0xdc848fa857ff70c8)}, {LL(0x6708cfc191210307), LL(0x7a6db6871e992f66)}, {LL(0x832eb0638ccd9f88), LL(0x9347bc2d8fa21ef6)}, {LL(0x443127725b6b32cb), LL(0x41e8545d376a3eeb)},
			{LL(0xd187a8dca390983a), LL(0xf007c09db924e418)}, {LL(0xf47b1cd57d185985), LL(0x92e1d7393f06d1c3)}, {LL(0xa8d8880a76fd2d41), LL(0x7446d15ff1ae7fb3)}, {LL(0x2f705004e20d122a), LL(0x8943cb26b4925921)},
			{LL(0x6d842bccada4d092), LL(0x91c86a052c29439c)}, {LL(0x94769524fe6582b9), LL(0x4b1e5cd55d88d4ea)}, {LL(0x0c49b8b7284723e6), LL(0xb2c629fc9d6148ac)}, {LL(0x2cf37e59e86c6af2), LL(0x44935019021b4b0a)},
			{LL(0x40b74f1f43569228), LL(0x2faaf209fdf4068f)}, {LL(0xc8d501fbf580f67d), LL(0xadb95ab393207a9a)}, {LL(0xfbb18a3f5f3e02bb), LL(0xedf765fa14ee8b44)}, {LL(0xfa7190b559a02af3), LL(0x1706adefc728855d)},
			{LL(0xdacb565b998b63e7), LL(0xe153d40a585286fb)}, {LL(0xb4cc53ca3e4ecbad), LL(0xbd4b2530c2f2d74c)}, {LL(0xce105d41e142060e), LL(0xf4daafcd3cf15ecc)}, {LL(0x0e0a8c6024b87376), LL(0x85e77ad6f82e549e)},
			{LL(0x07054630125cd83b), LL(0xa3923d6b7c172a4f)}, {LL(0x3622f923b41d7c6d), LL(0xd4fd51089e96c7a3)}, {LL(0x3f2d337382f9d720), LL(0xf28816b51aafb972)}, {LL(0x6a816dfcbff808a9), LL(0x325a576e503e69d3)},
			{LL(0xc6df8d9bd138850b), LL(0x285e20656b0e2e04)}, {LL(0x4cfef7a86b11b1ce), LL(0x9d6cdbf560954e23)}, {LL(0xe4267fa21dec9c8f), LL(0xe92a0aaa913b3190)}, {LL(0xdc0e0ae18d499394), LL(0xb8302174f783a2ad)},
			{LL(0xdf8d24bc8728eb4c), LL(0x75e0ba4b410ab086)}, {LL(0x9635a1f3f29ad229), LL(0x7c3f0fff38c7c8d8)}, {LL(0x90f0fd49e658225a), LL(0x255cfa819716ec8e)}, {LL(0xe32339920fb044b4), LL(0x4ab837c1ed2c1bdf)},
			{LL(0x8f6708d4a48abc6e), LL(0x218195d112c3565a)}, {LL(0xeeaa9baf21694f1a), LL(0x028fd628a38b5d6a)}, {LL(0x243cae83d816e9f7), LL(0x9817dfb155e43bc2)}, {LL(0x267f9a54d4e9b967), LL(0xaf368c9b30ab27f0)},
			{LL(0xa2546c074a78fed4), LL(0x9fe30dddc31e1349)}, {LL(0x42f47bc84fa9c2b8), LL(0x188ba12398bb1abd)}, {LL(0x03832e5d0a6178d8), LL(0xcdd09b3fb689122b)}, {LL(0xece9af782d961f8a), LL(0x35ae8502c6c44158)},
			{LL(0x6c443146ab3af8da), LL(0x6b39a210ffef4d85)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xb68f671d32b19b3d), LL(0x8a6a761aa7bdcb7e)}, {LL(0xab5ba6577c9c5599), LL(0xb9964a6047276d98)},
			{LL(0xc55ca3c6db59fdd3), LL(0xe58ebb5add873c2f)}, {LL(0x75169861fd2a969d), LL(0x3687383ed5ebd307)}, {LL(0x7190f00ce517367e), LL(0x58c59e6a1f75eb63)}, {LL(0xb18a212d20ed4306), LL(0x29f84b71dbaae131)},
			{LL(0xaa9bbcdd7a027dd1), LL(0x4367827594e16381)}, {LL(0xd3c49c0baf6fc8aa), LL(0xc72693b7dc6bf82a)}, {LL(0x1dd4c14a4e2dcea4), LL(0x33fc3c7ae09aa6e6)}, {LL(0xb945f1f71097c003), LL(0xf57cc4d98c5591f9)},
			{LL(0x8668c284926e1723), LL(0x07f4d26c96fa288b)}, {LL(0x105d637760f4c50a), LL(0x7bcbdd93ae3de053)}, {LL(0x1e57ef17444cb67c), LL(0xfe2ca7455613b4cd)}, {LL(0x50ea2c6823a25722), LL(0x54612f9a53c9e6dc)},
			{LL(0xa6d2046a52455e37), LL(0xf1a1ab8909802b2d)}, {LL(0x6e070591a7c5a84a), LL(0x5c18f13a9aa051b7)}, {LL(0xf13d6e3263bbd12e), LL(0x0652b978265ee7be)}, {LL(0x37e2e3a9b2835425), LL(0x2e0c991d4d50c9ba)},
			{LL(0x3cae1d2e8898aff8), LL(0x3f588d8aac26ab59)}, {LL(0x0b4cfe873a1bfbdd), LL(0x11541497e17662e3)}, {LL(0x1758254772a81d31), LL(0xd859e0f8d22aca1c)}, {LL(0x61cd937b85e3f374), LL(0x230e43f9b1480b30)},
			{LL(0x29b50cbef6cfe259), LL(0xd0203e581b437d77)}, {LL(0xf5bb065f7b8671cd), LL(0x68101f2cecc0dfda)}, {LL(0xf7f832887779215d), LL(0x5f314c06898fc3e8)}, {LL(0x7f9a7c6cc1af4508), LL(0xdd22e4bce75bbffd)},
			{LL(0xa7121ee054db767f), LL(0x0b50639cda462534)}, {LL(0x7213de51ef764ea6), LL(0x95150555a9fcf948)}, {LL(0xea2cf3c23954eff9), LL(0x6ccd707c6915650e)}, {LL(0x024334d70cff5090), LL(0x3721532a654f1c32)},
			{LL(0x1892b3ad508e460f), LL(0xa74f523bf9c2909b)}, {LL(0x3d6e07a48e0687b0), LL(0xc5a9459f7fe0a540)}, {LL(0x624ebd268f828bac), LL(0xeeded8c607c1191b)}, {LL(0x4177559545c8ba60), LL(0xd55b3a1c2e320896)},
			{LL(0xe0a017cf05d13c6c), LL(0x8768acfe5ba509f4)}, {LL(0x47b2092f510a4a13), LL(0x8c38cf6281e32cc0)}, {LL(0x9cb945fece1f01bc), LL(0x979ad37d0a77a422)}, {LL(0xae1dd4b0623fdd32), LL(0x2d2524215e7f5be5)},
			{LL(0x95b68faef8fbaaf1), LL(0xb1ef94c08e4edaf3)}, {LL(0xcd93731ceb237ed6), LL(0x390a34f28a784ce7)}, {LL(0xa01758d04687ae44), LL(0xa8c25ef7a6510f7b)}, {LL(0x2eb04a8ee4933a62), LL(0x73b2033367545738)},
			{LL(0xbc0383100e3448a8), LL(0x61cfaa98950da784)}, {LL(0x7e5a66e6c7316d40), LL(0x27d32ca9349db1e4)}, {LL(0x0a8ce40d3c85d395), LL(0xeba5dc8232b06cfa)}, {LL(0x28751634f051ca11), LL(0x2ad1f64dc885736e)},
			{LL(0x3a6b41949c5a5f8b), LL(0x663b78f403f78f0f)}, {LL(0xd682eeecb1cc4001), LL(0x5395fdf6c533ce57)}, {LL(0x7755acb6f1d5c60d), LL(0x01a66b14b0a4cf35)}, {LL(0x6b417776b96620e1), LL(0xc8ab9f7b83f867ca)},
			{LL(0x87a8d80e94f03f6b), LL(0xfd051a79453c2692)}, {LL(0xed29b5f22b0837c2), LL(0xcf5f4d1715024f41)}, {LL(0x217adc64c6b5615c), LL(0x0ca4b1f04cbc0dbf)}, {LL(0xe5e665281b72b4c7), LL(0x13dbc2bf42fd3f89)},
			{LL(0x22f9f239ccd41984), LL(0xc1742acffa351f94)}, {LL(0x7695b63cf74bee45), LL(0xfb57a3016362c12c)}, {LL(0x16983fcd74363579), LL(0x22a828ed01ecc405)}, {LL(0xb885eb7d1609e84b), LL(0x0f8d0ccc5f939fe0)},
			{LL(0x01c01a8a069e2848), LL(0xfaf1c815d3c60e19)}, {LL(0x59e5e6381546fc6f), LL(0x72146827d7f0980d)}, {LL(0xa49130bd5eba0ea7), LL(0xc680f8a36ccf371f)}, {LL(0xac5ee0676ec08da2), LL(0x1a04770b3b3047d7)},
			{LL(0x82eeaae98a53b7c0), LL(0x69b674385c6410ef)}, {LL(0x9efa7129c2e0512c), LL(0xa0bb80576f38b810)}, {LL(0x2a3622e3fcae9a81), LL(0x1df0a567adca6f5c)}, {LL(0x7c195231cbce3dd0), LL(0x10f27f8351d2add6)},
			{LL(0x99ff3719d0bc8917), LL(0x0329bd3c132f925f)}, {LL(0x7adc0e8bdf0ccda3), LL(0x49918afdfe038980)}, {LL(0x13de4d2a6a95bdd2), LL(0xb61b46ac18b4f278)}, {LL(0xe7a551ff178de457), LL(0x24fa919527b223bb)},
			{LL(0x690243a1b5997071), LL(0xff8acc51e6b77bf8)}, {LL(0x151b11907e574da1), LL(0xef78b3d2b765d62e)}, {LL(0x3bab5b1e9ac477c3), LL(0x9ccab0e1d0318116)}, {LL(0x562f70d23760a751), LL(0x0d02dae4fc18c28a)},
			{LL(0xc9151b71f31ede35), LL(0x574892a640e67483)}, {LL(0x1952a92756106e47), LL(0x5dbe9a2e2a049e82)}, {LL(0x4bfbb198794d69f5), LL(0x3efee69e1c82646c)}, {LL(0x52a918bf2f5d07b2), LL(0x63407cb03686faee)},
			{LL(0x1b119df05aef3ed7), LL(0x6a9fc9044f4b82b0)}, {LL(0x4f7dd9f56170c916), LL(0x50bc40cad61c5c08)}, {LL(0x4d3eed226d8f9986), LL(0x679d13e0b353403a)}, {LL(0x06c55cba14c2f073), LL(0x5963f57eafd12456)},
			{LL(0x5ca394df0be574c4), LL(0xe6a70666cea8ae70)}, {LL(0x1f97f59d42d29e34), LL(0x04dd6f5085d5bad4)}, {LL(0x33648bc4aabef4c6), LL(0x404e3f4987cef1de)}, {LL(0xb3c915fa2c121396), LL(0x1ed9185bbee5fd03)},
			{LL(0xca96352cf97fa6ed), LL(0x9a980999f66f66a8)}, {LL(0x9d795f74c88129f4), LL(0x6d6b1b68d9b1aa3b)}, {LL(0x0d89a23d2ed90bae), LL(0x4837e1e94ea746b5)}, {LL(0xf832a462555f7a63), LL(0x2027fec5a267996f)}
		}, {
			{LL(0x97506fa9e7ab8079), LL(0xb4f01ab55adb20be)}, {LL(0x6e9f451416971a91), LL(0xaa62580a55efe760)}, {LL(0x309432d1935fdc99), LL(0xce7f098967fc373d)}, {LL(0x8bb82d43c2f942b9), LL(0x9d0b8ec0afb0f18a)},
			{LL(0xc95b186c62634671), LL(0xd0ed4b3668c8f0e3)}, {LL(0x0fbd471d410e4aea), LL(0x0704c7efe240f358)}, {LL(0x0251ccd0a74e56d7), LL(0x27f3d968f2ebf484)}, {LL(0x417b9f97b5f37995), LL(0x988d91aa4c078faf)},
			{LL(0x5d93dd7d90a1bb55), LL(0xb17605dfb96c5e9b)}, {LL(0x0887b6c6d9fb9bda), LL(0x9c4ae2634e2a5655)}, {LL(0x73be619681e2f3db), LL(0x7101414bd9104c16)}, {LL(0xfa578005e455e7b5), LL(0xcbf916e3844b4918)},
			{LL(0xfb9ee66d5672cc3f), LL(0x39619bd7fddf335a)}, {LL(0x26aa0a2dc8b8d354), LL(0x5c3da6f72e5644d8)}, {LL(0xb8b4b52a44cfe37d), LL(0x861fd31543334871)}, {LL(0xf423a170177c86d5), LL(0x3e655c381f9fc002)},
			{LL(0xa45cf7c0619d21bd), LL(0xafe44760b6589945)}, {LL(0x37aec30a0baa0da9), LL(0x55312c05cb969230)}, {LL(0x9c4f73d72b3966fe), LL(0xfdd1ac8a9f8ef82d)}, {LL(0xd47a3ceef516af3b), LL(0x0b8e5277e4375b95)},
			{LL(0xb6c0945fb7e6821d), LL(0x738399ced8e7c16b)}, {LL(0xdeac46f88ba36236), LL(0xb037697c58f6f944)}, {LL(0x5931861e1d3d1738), LL(0xff53740f9e797550)}, {LL(0xa2af60734b4fdb07), LL(0xc632efd863a6460a)},
			{LL(0x6f56237ca4b0311b), LL(0x58fad53e2c7b9d22)}, {LL(0xc8927e04d0446dfb), LL(0x2275c602115c8aa1)}, {LL(0xb262cf3c3a7a2e70), LL(0x3da6e81efff2eaa0)}, {LL(0x8c82dc985a0c9389), LL(0x0645ab4c03da5487)},
			{LL(0x1d2124829775e94a), LL(0xdb6319418cffab76)}, {LL(0x9501a37940e5d6ae), LL(0x9303c3dda830d43a)}, {LL(0x0dec8bcde6401c3d), LL(0x20f71e8710ab07dc)}, {LL(0x9e1ebf078c773029), LL(0xda2275e26d650ca9)},
			{LL(0x01c96668b2272b8a), LL(0xf2988d3479947a42)}, {LL(0x163e38fc5be70fcd), LL(0x9242af7e49aa73e5)}, {LL(0xce61e9b7fa969741), LL(0x4ba36ebac4a255ee)}, {LL(0x9b75820cb3ccb7ce), LL(0x669f890633e45d20)},
			{LL(0x6580596ada05fc16), LL(0xe343ee3590ba3ff3)}, {LL(0x7f9b8c33d585c46c), LL(0xa36ed2f8b02f3188)}, {LL(0x40b2f9ff07d4521f), LL(0x6a151c9e3593f5ed)}, {LL(0xa7c45d7874f45ce0), LL(0x7a8f133c3d271783)},
			{LL(0x4f0fbee246da18f5), LL(0x6d11db71d7d306b5)}, {LL(0xae8a8dd61f28ecb0), LL(0x145d7c6b0a993b94)}, {LL(0x27636c457a9ff8de), LL(0xaea52bc357c23e9a)}, {LL(0x8d4bbaf0e82bb803), LL(0xf4dd26787a4e2ec5)},
			{LL(0xa0feaca3ec018dd0), LL(0xe1c136b0914db28e)}, {LL(0x2e2dbceb1143488e), LL(0xc0774494607c128d)}, {LL(0x3667a562b98d2623), LL(0xa7a9a131b202e872)}, {LL(0xa8791a6535fa160a), LL(0x7d8bd4d3df67e4db)},
			{LL(0x969909c1558cabf3), LL(0x46689781234f5afc)}, {LL(0xd996b7231356b306), LL(0x2b794cf0f49c5c49)}, {LL(0x5c5abb15228690df), LL(0x43ee88ebc0f824d9)}, {LL(0xbf8e44f1dc3a324d), LL(0x1d51f699ef59ed7c)},
			{LL(0x4bade581cb46b498), LL(0x2334aaa1f0c62d7e)}, {LL(0xb709f23705c1a997), LL(0x811b14faa173bb29)}, {LL(0x184a1989a8ce6ead), LL(0x67dee5a5d27efaff)}, {LL(0xe8cbe39a322e4415), LL(0x179ec84deaf41136)},
			{LL(0xe4ee0e3f664973a2), LL(0xc5f15bfe83cb6ca8)}, {LL(0xc1dcaeaabb98ddab), LL(0x4ca7a95526e2a6b6)}, {LL(0x1ce842ea2552c2c0), LL(0x29fb9475f56bd134)}, {LL(0x771c3af50c7e5fb6), LL(0x3f24309bfe0567dd)},
			{LL(0x84056a5e83f70853), LL(0x9a0f492f4df002d2)}, {LL(0xad12276e0a4191ed), LL(0xc136283781e6b552)}, {LL(0x67d195ba7d4baac1), LL(0xc4b0375d6251cb77)}, {LL(0xdcfd8a282ced34e1), LL(0x97c4b014aa1d0dc0)},
			{LL(0xf8064cd5431bb162), LL(0xec0acf8b76a0bd9c)}, {LL(0x94c8c511f2c2fd24), LL(0x619b4ee9d1a4ae78)}, {LL(0x82f6fdeda925f2e9), LL(0xf3d9e197980edd9d)}, {LL(0x5aa92ca608546a65), LL(0x2a3820531506fb96)},
			{LL(0xd62bf03e5258f9ec), LL(0x2c7d8b1f16dcaf11)}, {LL(0x0398aab815697d5d), LL(0xd56b545c8b7f8ec6)}, {LL(0x62baa8b142f02d26), LL(0x780dcbb93cd09afe)}, {LL(0x29174d3089b699be), LL(0x5b396118cc16b780)},
			{LL(0xc015c8c209bff621), LL(0xbe3f24615f76dcf4)}, {LL(0x6618f3d2cf6c814b), LL(0x3628ba691bc5b135)}, {LL(0xeb53492227473948), LL(0xc2f59c11618b9ff0)}, {LL(0xb491588f10a8d4ca), LL(0x547040a62a0c35ef)},
			{LL(0xb97dd342f6e8c8f7), LL(0x74875e213aa73233)}, {LL(0xc38d627a1cd68b7c), LL(0x6b54703dd4095232)}, {LL(0xe776a48773200eff), LL(0x109a0fa208b4e26e)}, {LL(0xbb2c1f9251a69e20), LL(0x53748749c84cc6b7)},
			{LL(0xdbc77bf3b418e5d1), LL(0x0c8a95980677a8cd)}, {LL(0xfd6d71de7ca03685), LL(0x50b7336f2821ec15)}, {LL(0x5745a76bee147658), LL(0x0acf3ed405adfc4a)}, {LL(0x906a9e727f5e5149), LL(0x2fbe3f39f6b185b3)},
			{LL(0xb3aba954885d05fa), LL(0xcf3e652a866690e2)}, {LL(0x0b1f1c7ecc92e687), LL(0x4921b63fc555d893)}, {LL(0x19837fe11ae94527), LL(0x95466891abea80bd)}, {LL(0xf9cf2abdf13c9ae8), LL(0x1e9242bf0f34c7de)},
			{LL(0x343669b21ec370f4), LL(0x805a785940e91cf6)}, {LL(0xa137cacb5e26a65a), LL(0x1359bb84e8d9c8cc)}, {LL(0xd7e29656e07fd266), LL(0xdee5062b6f48d553)}, {LL(0x1bd2b331bda713f0), LL(0xb2b5b1f959017439)},
			{LL(0xcfa88fdf48b1bccb), LL(0xb93be38ebd362fac)}, {LL(0x879dc0e6969e750e), LL(0x4f641d73c68f8c14)}, {LL(0x51b630d8c4c68ce2), LL(0x6319966cd0532305)}, {LL(0xabe1b0dd20936b57), LL(0xa8e0808f54186a1d)},
			{LL(0x330c98698636a1c4), LL(0x1b145dd5ec83b9fb)}, {LL(0xc6e65f71236d0c9b), LL(0xd7e98cd98a8803bb)}, {LL(0x20599d9ee26a29ee), LL(0x35eb0e4ffba89b97)}, {LL(0x146ff42cfca9591a), LL(0xb5b17616bb418761)},
			{LL(0xa59591a8d3ba0a37), LL(0x5d7cca54cfcce307)}, {LL(0x3cb1df74c738eb2e), LL(0x1c109a3a0ec34aa3)}, {LL(0x2b4681e02ef8cf69), LL(0x7ccab8703efd4304)}, {LL(0x7af0b138ea3e438b), LL(0x1fd32e1ceeae6001)},
			{LL(0xee38742918fcbeaf), LL(0x7e4860f53f0ace79)}, {LL(0xea9a2f4a956012c2), LL(0x306d1125181fe5b2)}, {LL(0x4ec6d88af4fd337f), LL(0x9f895645ae477cf7)}, {LL(0x2190fbf6504d0264), LL(0xc773837b823ce1d5)},
			{LL(0xe185333459f2f445), LL(0x794ca71add4a3d21)}, {LL(0x93f234ca6a372c14), LL(0xfad56b657dce0b75)}, {LL(0x1104c927c312defd), LL(0x090c8af2e5c0d6e8)}, {LL(0x6373ced9f0d706ac), LL(0x8a95468d4544e0bc)},
			{LL(0x7026cb2e948b8e86), LL(0xa46a1517526fc2d0)}, {LL(0x6bf4781f292c9d76), LL(0x16dfa4ee0b6eb6e9)}, {LL(0x381384174aa44743), LL(0x5235ebea29d66168)}, {LL(0x094ed0ae6bdcb050), LL(0x6ed26f5737be2c17)},
			{LL(0xe5276857d46e5828), LL(0x3769d6cafa5f16ea)}, {LL(0xbae579fae381b5aa), LL(0xa1ec0a7db1d8bcf5)}, {LL(0x8ed31048fd42c55e), LL(0x21b67224f131a003)}, {LL(0xaa28d6b592b440dd), LL(0x5a780dbb2d8c105f)},
			{LL(0x7dca40e372cb92bb), LL(0x849d0b9042c4c50c)}, {LL(0xcc3025675dd8c196), LL(0x6c50b7d23649a16a)}, {LL(0x54dd0dd3fb7d0b05), LL(0xdfa46a888ed2728c)}, {LL(0x612202095799507b), LL(0xad669fe5b7af1438)},
			{LL(0xc2440412aef1a0f6), LL(0x99ccfd09ad9d2870)}, {LL(0x686cd2a73c45e02b), LL(0xc3b4f0b28011382f)}, {LL(0x2532a095ddd1ae09), LL(0x8956f2aba529ca1e)}, {LL(0xbe4722996e1d19c7), LL(0xefc97bad96cd973e)},
			{LL(0x6cce89c4b1d94c46), LL(0x8d918162a70413e4)}, {LL(0x0ad67a167eb5cd0d), LL(0xbbb93b0bbcc1a2d1)}, {LL(0x315d54b92178f713), LL(0x3ce784bd1e684d7f)}, {LL(0x754df625ab300961), LL(0x18d7e9f30cee9359)},
			{LL(0x7b39d75058196801), LL(0xed4ba328973a1a43)}, {LL(0x5b604aceba7341ef), LL(0xd8a0ad676c9281d4)}, {LL(0xa366061bf968f08d), LL(0x34aa62ec1a323c48)}, {LL(0x2db51653042a35d3), LL(0x151c10c8eb039c4b)},
			{LL(0xdf652090398449bc), LL(0x42afe44821628306)}, {LL(0x60eb6461e5be7bf1), LL(0x5ffe12d1ce3b6e7a)}, {LL(0xf1489c7b28c70132), LL(0x82d8a0dc411e918b)}, {LL(0x78a17de84d70155c), LL(0x3820f7741c459485)},
			{LL(0xf6726da0b032d002), LL(0x19968550ed743486)}, {LL(0xd5b35a86473184b1), LL(0xf916df439da321d7)}, {LL(0xd0d8678d788a0356), LL(0x45ab23a7c322705e)}, {LL(0x727707fe33c5d851), LL(0x8399cc7fa0843654)},
			{LL(0x39dae27ff8836cc9), LL(0xa0ad66de50421b2a)}, {LL(0x79681b80ff573ed6), LL(0xcab87a4065d1eec7)}, {LL(0x32c5fe0134118a4e), LL(0xe98cd0e19517c3b9)}, {LL(0x42e3352fa09a04c8), LL(0x4de6c5f6c7780169)},
			{LL(0x129c639fd67ba3a0), LL(0xdc67deae6ebf582e)}, {LL(0x7c03268bc0ecb931), LL(0x760586a43b50bf4e)}, {LL(0x4d5e7232e1944e22), LL(0x4ae202192538f231)}, {LL(0x46416e4c2d06a8a5), LL(0x03c3b426e06d2aa2)},
			{LL(0x1eb98e3a821c9417), LL(0x0e084d1d078025b0)}, {LL(0x8a714b2b70de6933), LL(0x6f9303f4d6248bc8)}, {LL(0x3a4248c7edea1194), LL(0x75c63282db3d95ec)}, {LL(0x7484904d191722eb), LL(0xea4f64c7757ae91b)},
			{LL(0x8654a68e24b95e84), LL(0xbdfc9047bf1bf656)}, {LL(0x5e0b77c585c8c608), LL(0x641d51833213d05d)}, {LL(0xeff11241aadb9525), LL(0x8cd0edc1469eb43b)}, {LL(0x3ee013a46076bdf9), LL(0x3be34352fc28be27)},
			{LL(0x2208514e45247f39), LL(0x1218d72709436f13)}, {LL(0x0e742175f3296160), LL(0xf59c4adb9bd4891a)}, {LL(0x58f8e076af1a3cb2), LL(0x0dcbf93be7ed0f12)}, {LL(0x8f1a76204f65eed4), LL(0xd32eff1088a5da41)},
			{LL(0xf2d036c33dae7c6f), LL(0x57b3f480ca611f4d)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x04a25b638d9cac6d), LL(0x4e2571d027152bcb)}, {LL(0x69a5b4cf8e62cba1), LL(0x312c7d86f985426d)},
			{LL(0x4a6483e979619f12), LL(0xd1ac27958952573c)}, {LL(0xfef5db6669c94bd8), LL(0x85dc6733a35e62d3)}, {LL(0x9fd7d96f3e501ba3), LL(0x28baf8d614f176eb)}, {LL(0x3d78b91c751fc0a4), LL(0xee88170e775730e1)},
			{LL(0xe04c555cebd5dfcf), LL(0x8bd42a2ea4de4763)}, {LL(0xbddf88217b74649a), LL(0x3aa22ff11db219f8)}, {LL(0x6d07efac03fe67cc), LL(0x7f090c56de9069a6)}, {LL(0xff3cbd0edbee6052), LL(0x7744ea07daca1891)},
			{LL(0xcdf9430fefffea1c), LL(0x9ec83ae64fdddb28)}, {LL(0x478808249f21832f), LL(0xf15b391299f950e0)}, {LL(0x35ff0fdaace45b7e), LL(0x72c2f56d397d66b4)}, {LL(0x98ed28b4a6a5ca93), LL(0xb3f4dd5ab89bd3e6)},
			{LL(0x432a534712bd2f42), LL(0xbf7e48c2beec7b2b)}, {LL(0x23c13726f70354b3), LL(0xe0805a1370d71551)}, {LL(0xe21d998c4c9b8918), LL(0xac27f3465635b3e7)}, {LL(0xf081fa139ae02ab8), LL(0x70402de8388aebc9)},
			{LL(0x6a3d1e779b0bb6fc), LL(0xe44729da72faccab)}, {LL(0x9abce46401eb9c44), LL(0x940704324a702762)}, {LL(0x7e52ea5b67a2efe6), LL(0x51f65fccc9bb4bca)}, {LL(0xd85fd14ba171988c), LL(0xd9e1c1c48d08260b)},
			{LL(0xc57ef5c9360471c6), LL(0x0282d88501f78d7d)}, {LL(0x833f9b851b02d963), LL(0x01416ca3e19aa7df)}, {LL(0x522e9a60d1aff1bf), LL(0xb672c2305b2cadc3)}, {LL(0xeda0de910d95c3f2), LL(0xab2334a9b47540bf)},
			{LL(0xcac3b2d4770a3b2c), LL(0x05861f6ae3b77e25)}, {LL(0xc72f3919914a2711), LL(0x257101edf31c79f9)}, {LL(0x3f2975ccd2519673), LL(0xc97bce6685bcc465)}, {LL(0xd11101e5caad28dc), LL(0xb733ae93bab60a1c)},
			{LL(0x85cc0c3631d023d9), LL(0x6897c41b34647890)}, {LL(0xe3d4ffe4febca292), LL(0x5ebf7e722fa1c9a5)}, {LL(0x80a7313d0e6ba43e), LL(0xd42a38ff6ae52919)}, {LL(0x568cc1035c335dd2), LL(0xf857b3e07c398608)},
			{LL(0x2c7c703bb60d1e59), LL(0xe7849dfc9297e609)}, {LL(0xe6bfc2efc1072575), LL(0xe20282967120982c)}, {LL(0x99244edc1482e119), LL(0x416c506ec10fa9a4)}, {LL(0x816e5755bc4c8fb4), LL(0x26b2b5cb1371535b)},
			{LL(0xd289ab5ddfc45581), LL(0x6258facf31c984da)}, {LL(0x882087fbd7903fe4), LL(0x4860da9c24cf7f4c)}, {LL(0xf31950ab8f8957e5), LL(0xa52b79b4b3f5650f)}, {LL(0xfca417b6ce871d0f), LL(0xa22fbe5b51b59657)},
			{LL(0x17f75e94e9c02447), LL(0x60da224a303e09a7)}, {LL(0x64493f026822d79c), LL(0x11db6301e92e45b1)}, {LL(0x135505f7645c882a), LL(0x2eff539a172b226c)}, {LL(0x4c97145a53b365a8), LL(0xb87a8f2d5cac8873)},
			{LL(0xda0e1d9b063fce5b), LL(0xfe1218ac7fe3d28f)}, {LL(0x55146bbb495a208f), LL(0x2d3ce7bcf74608ce)}, {LL(0x2fe4da83a3646304), LL(0x32efc9a019e868cf)}, {LL(0xcb0ad4bcc52d10a6), LL(0xf71e925e9a230467)},
			{LL(0x4410a29c8a48fe72), LL(0x24306d4e1286de26)}, {LL(0x06f397b32ad2faba), LL(0x69d6a8b8d5fedf4f)}, {LL(0x073af1db98f5d130), LL(0x9b4e258cac6aa50d)}, {LL(0xc4b793a184235a4c), LL(0xf01a55b17863f73f)},
			{LL(0x5fc211ad37efed82), LL(0x9685dcb74b87aa1f)}, {LL(0xa60d3b10c6d3776a), LL(0x88179e0844b36dc1)}, {LL(0xf7bb0bc80215fb88), LL(0xeb0e086494e04ec4)}, {LL(0x76d55c9dbe59743c), LL(0xcdbcbdaf87911d9f)},
			{LL(0x89e9e19365b7146e), LL(0xbaf857a85d5b050e)}, {LL(0xd340cd356de37e0b), LL(0x90c077fb485dfe98)}, {LL(0x923b52a2d810079e), LL(0x084de651045a7137)}, {LL(0x507f56b076e1a768), LL(0x91811b58a9c75947)},
			{LL(0xacdb4106b866ba67), LL(0x33aea503f872cf10)}, {LL(0x48354f39de2fc9c5), LL(0xf65ffefd7bb9a3b8)}, {LL(0x9d8615bf991e4d74), LL(0x0f4921bee61a826f)}, {LL(0xb5583ee7a28fff40), LL(0xa6e8cd9253984fad)},
			{LL(0x71efad4626aca50c), LL(0x56f298232bfbb892)}, {LL(0x056b3d0b3fbb87e7), LL(0xbcbdfce45e815189)}, {LL(0x1f70e852303bbf9d), LL(0xfc90c0297e145ff2)}, {LL(0x15a692444e8e7290), LL(0x4729fb22c2d5fd23)},
			{LL(0x1a1bd5590f80387a), LL(0x402d3ccd20950e7b)}, {LL(0xaf43ebbead0fc73a), LL(0xe6c5f15f730d41d6)}, {LL(0x53e7fc086388da35), LL(0x44ea4f0422b8d781)}, {LL(0x28de2b583b91b234), LL(0xa9a1ec2cb582cdc2)},
			{LL(0xe90285f280096f9f), LL(0xe506457993606b74)}, {LL(0x0c25eda5546737b7), LL(0xd26f93b3693f7d9e)}, {LL(0x45d9c4f4386fd5f8), LL(0xd6a8e07a6b12a464)}, {LL(0x49fc29516c08e24f), LL(0x04c773c9022dd9fa)},
			{LL(0xdd34ec409eca1f6b), LL(0x655c3d20d3897782)}, {LL(0x24fbc6fd6ff68583), LL(0x7bce7f9fdcbdb05c)}, {LL(0xf5eac718a55bad5f), LL(0xccfdd10c660bba40)}, {LL(0xb03303ec9d3478a7), LL(0x1a5531760d191e24)},
			{LL(0x3b8b2eaf5fcd3a1e), LL(0x875ebfb6a2a9efae)}, {LL(0xbc16ee49c9534f10), LL(0xc83aa2c5642663ba)}, {LL(0x91a3f81acd797ac3), LL(0xdd26b20d8f25fff1)}, {LL(0xec69b8f9bfb2e878), LL(0x59bbb99dcde13afd)},
			{LL(0xb1fa65842f13532d), LL(0xe8cdbc42748d6466)}, {LL(0x10cdaf4f7135f577), LL(0xfb9407c69c54acaa)}, {LL(0x2a8fe7889cdfe4e3), LL(0x8e52354447693946)}, {LL(0xa9b07c0d87dd3d80), LL(0x8f1359e7a6f39e99)}
		}, {
			{LL(0x65c2b33be281c8a2), LL(0xfc07a04ba88823c5)}, {LL(0x8f944c1f73ba5e7e), LL(0xeee6fd67b453c472)}, {LL(0xc13cd8790b9bcf65), LL(0xdd16ebda96a1fe2a)}, {LL(0x3ad9cd22281fce09), LL(0x1150b36b1eef1689)},
			{LL(0x2b6a275d9aa059b9), LL(0xcff7b6f68a7a199d)}, {LL(0x187cdadc8fa223aa), LL(0x6eddb992f50608a1)}, {LL(0x6fe309621719403c), LL(0x312ea2c79f6b25cd)}, {LL(0xa8c0062c4f4bf792), LL(0x169ef6d8a52ad95e)},
			{LL(0xf7db783585d5f139), LL(0xfbc9e5f8134dec12)}, {LL(0x7f0a244b5c64c3f0), LL(0xc4b8cd9a396f94b2)}, {LL(0x061fd73753c978cb), LL(0xfaa6bfc5ace002b9)}, {LL(0x532513776ccff6fe), LL(0xdad8ae692d6431fd)},
			{LL(0x85b5f6468622d6e0), LL(0x23cfffeb83b0c27a)}, {LL(0x8ece8b498a784a02), LL(0xc5d797a786c27a19)}, {LL(0x4296f908de70614e), LL(0x047fabf4b9f13ee9)}, {LL(0x9dc92c9a0980f54a), LL(0x4d12467976b6cadb)},
			{LL(0x1d8d871114ee67e5), LL(0xe928b8d40f960ba5)}, {LL(0xa64a26eed85d2f3f), LL(0x77739fd25ac86239)}, {LL(0xa3bb7b2343116b70), LL(0xf0869e94a058613d)}, {LL(0xa2e1bc75bad37f0c), LL(0xdbb7f45492c9df56)},
			{LL(0x8c7ac6e5bb3f62fa), LL(0x93b543e4e223c5cf)}, {LL(0xb208915cf1aefcc0), LL(0x2e219b0934cd6e29)}, {LL(0x29de6af1abe77141), LL(0x999562b5ee9ba64b)}, {LL(0xac6b9cb72dc5a7a1), LL(0xba5a9d5e6d2b6431)},
			{LL(0x5904a92e99577e60), LL(0x17f1ace51a8737f5)}, {LL(0xfdfac26c704d79a7), LL(0x36e0e77424aeea1a)}, {LL(0x527fd421950de282), LL(0xf1e9c4a91ff58f96)}, {LL(0x5daf33b5fbd92e53), LL(0xbb35c763d2868a9a)},
			{LL(0x898b9b28207326b5), LL(0x144042a218b3c6cb)}, {LL(0x0a21ba59f598889e), LL(0xcd29028c37e30608)}, {LL(0x779fd3be98bb6396), LL(0x5ff31b556a6d2d6c)}, {LL(0xcc58724154082b4c), LL(0xc1a83c533f3344f0)},
			{LL(0xd690e531eaed201e), LL(0xf9175182aed4f387)}, {LL(0x4ff2533081e38567), LL(0x18c17c7d10638433)}, {LL(0x4c1cd9ca4966b9e3), LL(0x6592c2fe4613858e)}, {LL(0xc4cd85b490d78b2a), LL(0x5ae3ea9c6c31fd2e)},
			{LL(0x49ed8407d22afdac), LL(0xe267c3b8bc83868a)}, {LL(0xa710e1b8219f3b43), LL(0x5c42f5126859dc52)}, {LL(0x7e50e31da5a6d78c), LL(0xef89a75a0bfe2ad9)}, {LL(0xa4fe6b42e91a07c7), LL(0x21114b913e29ddef)},
			{LL(0x662c39c12a04f426), LL(0x81541ec8fef82278)}, {LL(0x0d64aa385f93e429), LL(0x1cbed789a992bada)}, {LL(0x585e6e7860956a1c), LL(0x3cc0c6252816899e)}, {LL(0x8b3fd68411340e4d), LL(0x422296e17c52791d)},
			{LL(0xc38895d53adce79d), LL(0x8b743f99f24041fc)}, {LL(0xf1c4af02d61c89f2), LL(0x016f5a3dbfadeeab)}, {LL(0x70dac3df32b00f21), LL(0x8e64ce50f41c91be)}, {LL(0xbc82b19e66b8246d), LL(0x4fccf203cb2fd54e)},
			{LL(0xb352560a086ce8bc), LL(0x0510f1c9065cd042)}, {LL(0xd57e6fcb22681c9a), LL(0x8444ef01f8a4f23a)}, {LL(0x214b9d046f38d127), LL(0x02deb47abd991f95)}, {LL(0x25e0079f0db68114), LL(0xae1adffc7598a2fa)},
			{LL(0xb8292b050436745e), LL(0xe3089985032e6821)}, {LL(0x5aea23d451d242e4), LL(0x6aa212664cf73648)}, {LL(0x811e6cdde4ac86d3), LL(0x8f0b946d4bb17f15)}, {LL(0xc2d25283c31ef3e1), LL(0xa0455559c0d1ff97)},
			{LL(0x63dd640cb148b069), LL(0x06a11f8e0468217c)}, {LL(0x54600316c6c49a49), LL(0x0b4f7b6cb3158d2f)}, {LL(0x5f1b7e19ca9e06ab), LL(0xed571320b667354c)}, {LL(0xd81ac5f37dfbf8b3), LL(0x98fa3888513648e0)},
			{LL(0x22a517fea7bdeda3), LL(0x7f8d0af9ebe91e28)}, {LL(0xb417466ba267840b), LL(0xd48724cc982d6c90)}, {LL(0x260e8d65c533bd90), LL(0xd349617f23e8a347)}, {LL(0xddeb983ee6b7bcfc), LL(0x1f0f39ceaba64be4)},
			{LL(0x3cc61a157bd6b6c2), LL(0xebf60caeb20f1430)}, {LL(0xdcb15f681f75a880), LL(0x343e530e9937f58f)}, {LL(0x93430c589e962de7), LL(0x2cff2f73895471bc)}, {LL(0x90ad86a256131163), LL(0x51ac91f0df247001)},
			{LL(0xcd02b517adca3f30), LL(0xea9956930da2fa9b)}, {LL(0xb973ec53fdf46022), LL(0xc839f34531bfd64a)}, {LL(0x2e9b7a9001ec1df6), LL(0x4802b7b070ea1a99)}, {LL(0x96b2519505da69a8), LL(0xab0a2e3573c472b8)},
			{LL(0x82f0e6272c29ba57), LL(0xf2582aee1dc17ea8)}, {LL(0xf09e68542fde9d8e), LL(0x2a5e30fd8d3c50c0)}, {LL(0x7ba1bed03eea93c3), LL(0x687ca61cf16e29dd)}, {LL(0xe399cf87ac2622c6), LL(0xa29be1237d48e002)},
			{LL(0x94061c39349d4150), LL(0xfd68fa761725cd6e)}, {LL(0x3b830a74d1ddda75), LL(0x3a61d9ab2c7ea8e2)}, {LL(0xdaae885f4cbcd04b), LL(0xce98eccb35d7f736)}, {LL(0xfbe5155b2384016c), LL(0xcc4658b1884ee8a3)},
			{LL(0xba9d66a935715ca6), LL(0xb56a4dc667cfd7f7)}, {LL(0x3453ede0bf0916a4), LL(0x70bdda61e10dadee)}, {LL(0xe732551ccea872f5), LL(0x0e5f8aa5b5495d6d)}, {LL(0x02b44dac314728f8), LL(0x5662d44364e1bfd6)},
			{LL(0x84ef31107fe0c29c), LL(0x08fe952bb1217c11)}, {LL(0xc679c818a190a3d2), LL(0x0c813edf08d042f8)}, {LL(0x578e89ec0e41a6cd), LL(0x761cc5efe5658c92)}, {LL(0xea56ff24913b96dc), LL(0x12e15d2c1cdbe7b7)},
			{LL(0x1f39cabd25a94f1d), LL(0xbf4a6c976b77b473)}, {LL(0x151870e4d031c783), LL(0x72636e1b5c94b27b)}, {LL(0x1b92502647271f2e), LL(0x138e0711a376091c)}, {LL(0x386d808e1958e6f1), LL(0x473267287a0ea95f)},
			{LL(0x9a8c3cfba38b99fd), LL(0x9c85937ce8c77609)}, {LL(0x9bd6fbad5a498d81), LL(0xb7b4f9bcda56c862)}, {LL(0x56d44ebaf783b2b1), LL(0x5d2daf2fd7f432f9)}, {LL(0x05f15dcd9b4c444f), LL(0x87f50146fa900304)},
			{LL(0x784f342af66faf47), LL(0x152f189fa71e2860)}, {LL(0x3316fd8115027a13), LL(0xa12a0f647f7c113c)}, {LL(0x3f2890efb3538a46), LL(0x96a5b22de47f158d)}, {LL(0x20115a5296fac55b), LL(0x29efdeba8f08a1fe)},
			{LL(0xcb1d6220fe0347fb), LL(0x103fe956a142f822)}, {LL(0x6033eef679cd8ced), LL(0x7bf2a10d521820c1)}, {LL(0xf95158f712c32994), LL(0x9a248cf2ecaf5775)}, {LL(0xaf85164de5409b25), LL(0xc70923dd3b5b658c)},
			{LL(0x73344925fa3533a5), LL(0xf33770d3a26c9003)}, {LL(0xad315be1d407b3dd), LL(0x916bf79e5fbada5a)}, {LL(0xb0bcdcf0c0e9d438), LL(0x78434f4a502cd1ff)}, {LL(0xe9b875de59beaa58), LL(0x6fb2e3af4aabe60a)},
			{LL(0x6b4893f97597100f), LL(0x9deac941576a98a2)}, {LL(0xbbc7a1ffccb348da), LL(0x9e5b2706555e699c)}, {LL(0x2884ada75225653d), LL(0xb2a40875dc0a1820)}, {LL(0xf80b9fa1eb013de8), LL(0xb115e632de3ee91e)},
			{LL(0xbf6c3b64ae3d18e9), LL(0x329f4c809d5fd4f3)}, {LL(0x8701bbeab765fe18), LL(0x75ad2ba8e7517dac)}, {LL(0xbe36fc3257ff0c95), LL(0x19ae2640afce6a98)}, {LL(0xa99ac17ab689e3ee), LL(0x3daf9c1897bb6735)},
			{LL(0xb54d813d5ba59077), LL(0xffb64e0caabcd2fb)}, {LL(0x2d75f06ac9692172), LL(0x35510933269a1b24)}, {LL(0x324c3ad7ecc06e6f), LL(0x8a1b65a44dedaf57)}, {LL(0xd361b8fc71a16451), LL(0x7ee250c45444f083)},
			{LL(0xc8f3e8da36867b7f), LL(0x6d6c57d5f732f99f)}, {LL(0x23ffd0a85e7ff9df), LL(0x54bc6039d978a043)}, {LL(0x5e41b94f335c12d7), LL(0xc66679e084f68b27)}, {LL(0x97e896c3fc187dd4), LL(0x803b44f54155ccd3)},
			{LL(0xed13ef453b30fa6b), LL(0xc376882982aa5b65)}, {LL(0x3e7257b94a919e3a), LL(0xbd94d8edd6eeabe6)}, {LL(0x37bd671a778c2a20), LL(0x0dee64e2b77dac53)}, {LL(0xf370e2aee75ba10a), LL(0x570d8e7edb4c517d)},
			{LL(0xe077457d64a31e42), LL(0xdfc85fa02b38e1bf)}, {LL(0x10e92d294b7d83cc), LL(0xf5966f5da604b17f)}, {LL(0x17ac3d48e176ef7b), LL(0x2401ba5838750dad)}, {LL(0xb7f9cc916ae2b88f), LL(0xa9d49a4fce5d6d2d)},
			{LL(0x7915f37c0fadbb3b), LL(0x3e1e725f958f960b)}, {LL(0x463d6393bcfe317d), LL(0xa8bbc07271f08386)}, {LL(0x7afb7986c72887bf), LL(0x434dccdcc3ff97b6)}, {LL(0x48b743512be8e9d0), LL(0xc956a9788e1238e1)},
			{LL(0x6498746d1b43dcde), LL(0xd736ca8b9a199dae)}, {LL(0x417873f216f55dca), LL(0x792c1577ef813f54)}, {LL(0x955cdb6fcd5f552c), LL(0xd65990b625b47305)}, {LL(0xc0661f2ff259db19), LL(0xf627811aa4304041)},
			{LL(0xf22a25f81e99b576), LL(0x7c3ce4bee9ddef16)}, {LL(0x74715944503e5f12), LL(0x22a0a5d63c1d2cd1)}, {LL(0x7ce4aeb194e1ff74), LL(0xb9eb73196f1f950f)}, {LL(0xd08f3206b92458d5), LL(0x03b1ee470234f13e)},
			{LL(0x68a61903bd122c8b), LL(0xe0b977c2011a991f)}, {LL(0x16f6fa1e18b4fb07), LL(0x0f30d0980ae4b3c6)}, {LL(0xaedfd11b1c828f59), LL(0xec38491d09cadbe7)}, {LL(0x11b3ea7fb2bf97b0), LL(0xdea7059d94950f14)},
			{LL(0x91f741f4afd1051f), LL(0x7a9dfb30edb5ce6a)}, {LL(0x1e630debdc6b5b61), LL(0x947b065759e60a18)}, {LL(0x09cf30a33d1db41a), LL(0xb07abc0f619307b5)}, {LL(0xcfb6f8bb9c8d17c8), LL(0xbcfb82d06943454d)},
			{LL(0x30f8777bdd874697), LL(0xdc79b1e7290c1081)}, {LL(0xec492813c2f2ee17), LL(0xe847e2e9b03be50e)}, {LL(0xd1d5f55040e64ca9), LL(0x2880848730a54f55)}, {LL(0x616929a0800f9891), LL(0x50c3cbcd60899eaa)},
			{LL(0x4d461e9cb0a4ad9f), LL(0x4ea3a83e74823be5)}, {LL(0x4ea894667821911b), LL(0x33f016bd22f23a58)}, {LL(0xa5a4ac1410d813bb), LL(0x0a2021510cb86384)}, {LL(0x0fd0e7946ed4ccd1), LL(0x4adc03cacd73050c)},
			{LL(0x50cb998da44aca7a), LL(0xa78b10ea7b143040)}, {LL(0xceec3fed654f03b4), LL(0x97cae8105bd2fb26)}, {LL(0xff4e8fc0410a515f), LL(0x60823337404f55cc)}, {LL(0xe4dcdfe6062d4e71), LL(0x730c3426e3395cd0)},
			{LL(0x2c2f373c30ab350e), LL(0x1e6063f3140ba54f)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xde0512c42e328078), LL(0x625c874dfdd64a59)}, {LL(0xe8e2b288a07cbe24), LL(0x4483896f783a5861)},
			{LL(0x6eb9ce34eedb5440), LL(0x1a1fc807adfa9ba6)}, {LL(0x8d2001b342fd7686), LL(0xb8842924d0b27ba4)}, {LL(0x1ac89770bee50b52), LL(0x38bf6dd191e7b777)}, {LL(0xb6a30bc79320acf3), LL(0x82e5f08ffcccd346)},
			{LL(0xbdd876c89f7a3011), LL(0x64fd98c3f9be6b25)}, {LL(0x4a030efd1aafc128), LL(0x9f347d3beaf38737)}, {LL(0x36e7a04c8e4e3e5c), LL(0x26df0e2285ec1238)}, {LL(0x5bb0e482a8105698), LL(0x419378a67e668823)},
			{LL(0xf56f3599b492d9c1), LL(0xadab31bb77ac53c4)}, {LL(0x19261d8a766037d6), LL(0x45ecd352c797b6ca)}, {LL(0xc9a92f8ccf446f03), LL(0x465d3d15c5a347f4)}, {LL(0x7dbe69e76d23eb08), LL(0x92da19d95d8e2b64)},
			{LL(0xc7230f4e5852b7ae), LL(0x27b0541f3a41fc93)}, {LL(0x865b7cbc4ea7ea64), LL(0x5e9c4168d5c0c3c7)}, {LL(0xd23b7faa8863702d), LL(0x55d33a0466d54ee8)}, {LL(0x43cc3e5e27b27532), LL(0x2f4ec1348b608082)},
			{LL(0x51915edb5d88de06), LL(0x8cba7a2a49858e2b)}, {LL(0x125d60857a3aab34), LL(0xa3f4bb1ec2e50ea9)}, {LL(0x71800489cb721b5d), LL(0xa555a490c68d2fd5)}, {LL(0x03ee8afac8853c84), LL(0x7d53be83567001bd)},
			{LL(0x8a6511d2e8f61a31), LL(0x6913fc214ec3c776)}, {LL(0x45d3e969747b0df9), LL(0xd5e87ef12780823b)}, {LL(0xefa7a2e90a77d293), LL(0x95145c6ae64be4b3)}, {LL(0xca47a57607c15387), LL(0x3b0e839693d34649)},
			{LL(0x9219cb0e6754399b), LL(0x07ce45b3bbc5cfd7)}, {LL(0xe58618b0ffef5a0d), LL(0x583d5ee6d1a8e2bb)}, {LL(0xd94002a58439eccf), LL(0xb3cb524863a7f68b)}, {LL(0xaa744b807e0cdf6a), LL(0x40fc229bc1cb6688)},
			{LL(0xf435f2cf4d50cdbd), LL(0x869a5b7b453dedaf)}, {LL(0x04ab9a9b628e5033), LL(0xacc46b86c801bd6f)}, {LL(0xfca0053a898f6ddb), LL(0x1dd18db4163f5471)}, {LL(0x31a2b02d244552eb), LL(0xf748db271b9daeea)},
			{LL(0x9e27a660c105c9ce), LL(0x3041f8fa20c6cb66)}, {LL(0x0c3e6d6ea651f055), LL(0x378fbd499b0304b1)}, {LL(0xab2e8cd687cecb16), LL(0x6bcd485bf35ad8e3)}, {LL(0x2a30e00b63624dc5), LL(0xe4c6dc36b8eba7f6)},
			{LL(0x1307a7d383f8bf48), LL(0x88c5d1def074b0c2)}, {LL(0x83aa2171d5ebae2b), LL(0xd969402e2f50c0c3)}, {LL(0xfabfd20dda461510), LL(0xe7773271badf56c8)}, {LL(0xe2c308d155e436ba), LL(0x89aa8be34fd95e69)},
			{LL(0x9962b6016b0ea579), LL(0xe1d62dffbeb777b4)}, {LL(0x9f7d613638c7ddb2), LL(0x1b70923a1257750d)}, {LL(0x4767a4c5453c2501), LL(0x838aaab243613ded)}, {LL(0xdf5fd592d7f09404), LL(0x496ded8dcf47f432)},
			{LL(0x6c0d8398df9c7cb8), LL(0x4c7d1c44c91b2470)}, {LL(0x88d15c7ed9b132c9), LL(0x3f7128622a2278a0)}, {LL(0x27544a333cf1a9ec), LL(0xf8780bbf11791d2c)}, {LL(0x44892e3f8db91985), LL(0xfed9143115113c50)},
			{LL(0xa055f1d98b9457f4), LL(0x8dd52017f6286080)}, {LL(0xb1e61ba6392bc044), LL(0x5372258a62bd6f94)}, {LL(0x6776fe97d3c6e05a), LL(0xaa657408cc699c13)}, {LL(0x5cf5f4e3021b3a2f), LL(0x9004ada3e01734f1)},
			{LL(0x9838715792ccb105), LL(0xcae7473f8c26c9df)}, {LL(0x726e8e7303f727d9), LL(0xd8061a1390fd2e68)}, {LL(0x24bac0c9f4749568), LL(0x852bb53c47091c91)}, {LL(0x0e8a20c29716d8ad), LL(0x61ed690affe2bb67)},
			{LL(0x553ac4403f068e35), LL(0x207e11ac81843344)}, {LL(0xc59742e269159f56), LL(0x71d2805c5ea04345)}, {LL(0x6d5744ce265e68c4), LL(0x674c7684fb8a9a1b)}, {LL(0x8044ab8b1d6e92af), LL(0xa43afead7920c17e)},
			{LL(0x6287a35a488aa415), LL(0x2d90754e36f99f17)}, {LL(0x015ac756f9c2147c), LL(0x2b316ac03291be6b)}, {LL(0x752b9e12a9fc4b6e), LL(0x0991cf160e8c92ba)}, {LL(0x35092ab646cb02d8), LL(0x5b8cb0a1d39c1385)},
			{LL(0x69fcde5544d038f7), LL(0xcb881d02338b2774)}, {LL(0x0895f7f5c4dfa066), LL(0x9b4bd6cf5302b9de)}, {LL(0xe668924a376a6689), LL(0x256ee06587d8e306)}, {LL(0xf681bf637c17e545), LL(0xd0f88f3821dc5279)},
			{LL(0xeefd65bff3b5c6ef), LL(0xbe2536aad4da5ad8)}, {LL(0xdbf44f09b57ec437), LL(0xe5a9860b0746495d)}, {LL(0x393747d8e09af28d), LL(0x6c030de8489f1734)}, {LL(0x4022b4a4ef3749b6), LL(0x521d7fb7dd10813f)},
			{LL(0x1442b7b229f3d3ff), LL(0x595204db6e050c10)}, {LL(0xa10f368f72564388), LL(0xa6e44ad7c4b9deeb)}, {LL(0x76c514e8617977ea), LL(0x74c2719558fc9307)}, {LL(0xd7ca2267132f3462), LL(0xd2263b429c454dec)},
			{LL(0x0b7b7d0f0c5a9ce2), LL(0xe618684c0572b863)}, {LL(0xe12d822b9d610a3e), LL(0xf4f9356019a95fd4)}, {LL(0x4b59c9abe36dd554), LL(0xb40517fbd862395c)}, {LL(0x3d9cdd438214a2be), LL(0xc0c7666e809eaa5b)},
			{LL(0x07451061aa0b6cb7), LL(0xd197d5059e71bcd2)}, {LL(0x9c93ebccf042e136), LL(0x66232cb9442774b0)}, {LL(0xd424a89ddbaa08e6), LL(0xaf7585c1ca354c51)}, {LL(0x1cd74047ed2c7399), LL(0xc219d2143d07b5ce)},
			{LL(0xeb0c387268f982a0), LL(0x39d037ec2e4a59dc)}, {LL(0xfe144896b8c84523), LL(0x4bb359f772deeba7)}, {LL(0x2fc1bdc6f82e098a), LL(0x6333dd70427ba4f2)}, {LL(0x6a1254af8c550473), LL(0xb6dba38165fb26c9)}
		}, {
			{LL(0x5433fb988d1d595e), LL(0xb20e82b31ba4d47c)}, {LL(0x5a5608c136be7690), LL(0xec0f994cf83840f4)}, {LL(0x4b04cb5b391faeb8), LL(0x9f2c52d84e349701)}, {LL(0x0f8f417605de4818), LL(0x90a0f8cdd3044d53)},
			{LL(0x4561380282bc8176), LL(0xc12d4927ada80389)}, {LL(0x9b90b39ec81a19c4), LL(0x327959da2f9fd124)}, {LL(0xae5f1f11dbf7230d), LL(0x465cc809965df867)}, {LL(0xb37f888cd00f1a84), LL(0x34ff1d06a33eca6f)},
			{LL(0xe8c3326258cc0bc2), LL(0x165167786b9e5340)}, {LL(0xfdbf7c44ea5a8c34), LL(0xdbb3a6241db7665f)}, {LL(0x56245cc632e79731), LL(0xed8f87d77b57a509)}, {LL(0xf7f402a1eccefc24), LL(0x3b73b7133e0e103d)},
			{LL(0xa03aec4860540cc3), LL(0x185dd3f675c16cef)}, {LL(0x435812e0807110c7), LL(0x206d468b0d7e9016)}, {LL(0xbd1a7bd56bac354a), LL(0x6afe06f940a25ee7)}, {LL(0x3baa5fd6a84e1507), LL(0x2a248a2c5a5ebdcb)},
			{LL(0xe6a6c13be36f240c), LL(0x48507c878802c7c8)}, {LL(0x2d2b04811b5f3b48), LL(0x76e6ad267c1c207a)}, {LL(0x501d7624302a0680), LL(0x0ccf887bdb813696)}, {LL(0x49136c0586e560d7), LL(0xc0ad57bc2ec7e674)},
			{LL(0x714426a22f2cdc69), LL(0x7ba93bc624f2f311)}, {LL(0x1af30f50b748cfee), LL(0x5d423991a52d784c)}, {LL(0x777d0c402de14dd8), LL(0x9ae9346a8424608e)}, {LL(0xd747e0084db5411b), LL(0x82b4e79cf1e50c61)},
			{LL(0x0d98e628ba248677), LL(0xcf21fda9b3f73c26)}, {LL(0x12afd6eb0e267191), LL(0xe2032dc2e6677f5b)}, {LL(0xeefa18805a019a73), LL(0xf71168d4cb48c0df)}, {LL(0x69a08eac279edde8), LL(0x796a0733e12cfa28)},
			{LL(0x0c7254070459e1a1), LL(0x01801e9b836fe5fd)}, {LL(0xfa6ce48956ea7a53), LL(0xf4524aba8df92c1b)}, {LL(0x35cfac8f13ed3ac9), LL(0x742591d3b9c22943)}, {LL(0xfe426935ebdd258d), LL(0x4a9340724ddccef1)},
			{LL(0x57ceeee98c9af0e7), LL(0x232e64e54bcf7cd2)}, {LL(0x085cd9bbb96ebe7f), LL(0xbf411453434a0717)}, {LL(0x234ef7d8a0fc1486), LL(0x28e7b6d99f80b4f2)}, {LL(0x3632b9fe126a9370), LL(0xe5057785e9a981ed)},
			{LL(0x5e78857d8b89294e), LL(0x52ce9384381da21e)}, {LL(0x34251ea0ad905d1f), LL(0xba8472e1895af098)}, {LL(0xe4b166655c95ea63), LL(0x17d179e3e8f1b6bd)}, {LL(0x1f3730c3b402f7e6), LL(0x2d22d06b5590437d)},
			{LL(0x7f21d5fb948ff3a7), LL(0x25a82039c76e6799)}, {LL(0xb546a26ed2c28b35), LL(0xd5bf12aa03e859f0)}, {LL(0x1496fc090cebe020), LL(0x0343226e46b1ecc4)}, {LL(0x3e6e6045ab042d0f), LL(0x5a4463d6aae386fa)},
			{LL(0x7918ff1996426216), LL(0xc4e82f9567b8f406)}, {LL(0xbee76ea46a2b9cf3), LL(0xfbdee0af10c9f649)}, {LL(0x7ae5ea6897c5cbaf), LL(0x55c8c9c337d35ca8)}, {LL(0x84a7835d7c18ee22), LL(0x1f5b89b17a0f9259)},
			{LL(0x03fd15710187a9b9), LL(0x9120e656506ba8ae)}, {LL(0x7cdcc08a95085a1e), LL(0xb488c66f9705cf37)}, {LL(0xbf0ddc8bd456fb25), LL(0x357f039d20512f92)}, {LL(0xdb35b40f49eca0ba), LL(0x8334f907728ae99c)},
			{LL(0xe09febd9e1a2b5bd), LL(0xa910732b28d45457)}, {LL(0x268ac84ba3b62c8e), LL(0x58875f236f3d8fc3)}, {LL(0xc40284ccfdee575c), LL(0xae16296c271aaae1)}, {LL(0x6016e538208d0441), LL(0x088af05292fe24e4)},
			{LL(0x0217a75ebfface6f), LL(0x5f81056460f37175)}, {LL(0xb8de444668e60d42), LL(0x1a9eef03b01f65d6)}, {LL(0x5bbcbaee88c31146), LL(0x22ae7a7ec8a0992f)}, {LL(0xc99a62e447cad12b), LL(0x6137d4c594ed96c7)},
			{LL(0x941ff2e8cdc451dc), LL(0xa2d9a117fc9b9c77)}, {LL(0x4cd7539685af58df), LL(0xb0cdbe46de7add45)}, {LL(0xf0279a6c507e0a43), LL(0x14925b8dae405a79)}, {LL(0xb4ac10416cbfece3), LL(0x1b1ef1983370802b)},
			{LL(0x59ab1db03739df29), LL(0x7d2f7f1aa853e85a)}, {LL(0xada20a60da708ab4), LL(0xd77c2e5fc63650c9)}, {LL(0xa5fed3db631e34cb), LL(0x683d3a0c857c57de)}, {LL(0x8eecfdb87a8c9e32), LL(0xff9b988659b6e43b)},
			{LL(0xe74c73145d1243da), LL(0x86f19fb5b89a1e13)}, {LL(0xf991f1f8576dd3ea), LL(0x6572acecdd9284b5)}, {LL(0x38574aa7a9c9bcbe), LL(0xbb046c7a0a351565)}, {LL(0xd8c8a17e486b0903), LL(0x12141f5122e14132)},
			{LL(0xef10aaafe47cfda5), LL(0x39b08be6fbd01904)}, {LL(0xa7e97485dce4faa4), LL(0x37bc3f68e58f26ab)}, {LL(0x998714c077e0d7ab), LL(0x6df85cbe4f6ca051)}, {LL(0xdf1b39b3f4dbff64), LL(0x3df5f3cfb2af0b76)},
			{LL(0xead4953ce736c5ad), LL(0x49d0621c0b6d2235)}, {LL(0x16815b57b3112e4f), LL(0x5cc2270a26429db1)}, {LL(0xfb8656a6e8971d85), LL(0x3af3a988bd61f5c0)}, {LL(0x448b8a2d3cc1e6a0), LL(0x0f8caa159d30da52)},
			{LL(0xd283df9b4eff7913), LL(0xf2d40e6601583750)}, {LL(0x91dbcd7bce8e69d4), LL(0xd2b948ed0c26a746)}, {LL(0xbb2351376961a4fb), LL(0x8bbe0955e074cd78)}, {LL(0x321c3442af5dccae), LL(0x5bc47d4d298c6307)},
			{LL(0xb934f669d69b6a94), LL(0xd43f0c318087bc0d)}, {LL(0x042e8dbcbd375fde), LL(0xbec10ac8c025e2ea)}, {LL(0x93cc6a257174a7bb), LL(0x8d384d896cd5d633)}, {LL(0x0e65f359bba32fce), LL(0x5e011bffe39c9488)},
			{LL(0xd4baf5794c32e8a2), LL(0x139401caa18ea4cf)}, {LL(0x2ed611f01ad892f1), LL(0xe7c64b702c7788d4)}, {LL(0xb0829dfdd188b33d), LL(0xa5dffb50f35562c1)}, {LL(0x3d937534aa8384b6), LL(0xcb648580fa882e54)},
			{LL(0x748019312c66e461), LL(0x0bc9d23cd44fc820)}, {LL(0x6d8e03109aa98236), LL(0xc7ab0dfb210918c2)}, {LL(0x8ac27004c7bbc1ec), LL(0x415a924e999306d1)}, {LL(0x7d3672a52b753dc8), LL(0x7a29255da79d16ec)},
			{LL(0xb2953aa36e727d52), LL(0xfa5efe3493a613b4)}, {LL(0xdef18b9c4aa698b2), LL(0xf35410fd8237d2ad)}, {LL(0x72b933d32eab75d0), LL(0xea89dd9074995bbf)}, {LL(0xa603c6aa62999d72), LL(0xf91ddc5ad517ff70)},
			{LL(0xb1682fd26ff5d4eb), LL(0x6b7e1862c3cdbb1a)}, {LL(0x2905893da6686496), LL(0xc827a7eebc39c290)}, {LL(0x7697be6f939c2a0e), LL(0x5448d758b4bcb955)}, {LL(0xfc55ce6b5427ebe2), LL(0x151245162d2fbf84)},
			{LL(0x51f7c40b8e576156), LL(0xc26e6b49eb19ef4d)}, {LL(0xce49fa29fb7a274c), LL(0x4ed6385b04a3dc83)}, {LL(0x28ef3b1218150340), LL(0x068644dc8ca11b4b)}, {LL(0x2577dd3aa2318537), LL(0xc9a7b9753f56276d)},
			{LL(0xca677795464d7892), LL(0xf0173293c4863e69)}, {LL(0xcb8dc5baf8301f44), LL(0x3eb6d1a1f41ee7b2)}, {LL(0x6e7316619b2e2b8f), LL(0x568bebad7162b06c)}, {LL(0x6f99a44e25534c59), LL(0x982a089f41fa69b7)},
			{LL(0xafb5ad3e658a44db), LL(0x88fd2b3ba6c521bc)}, {LL(0x9226d80acf09c06d), LL(0x4399aebb5c4d0fe8)}, {LL(0xb6bbb71fd345228c), LL(0x449ff4fc5383f15e)}, {LL(0xaa7192ad66c07cd3), LL(0xf89dc2c156781a8d)},
			{LL(0x55d949b733603e88), LL(0x7caf61812b3c0da7)}, {LL(0x134564c4b05b1647), LL(0x2ca2cef0d6ffa680)}, {LL(0xc7ff91bdfc69fee5), LL(0x3f36cf3a7771024f)}, {LL(0x2af89c4ca7efcd2f), LL(0x590741b8ec526a3e)},
			{LL(0x9a7a01b176677e12), LL(0xfcd8bae81f0708ff)}, {LL(0x8d11e8c97b0b378b), LL(0x6ebb7ed009dd4c95)}, {LL(0x42b2a0cf3e0c7711), LL(0xeecca5b93de649cd)}, {LL(0xc1c6bb5ffea46f54), LL(0xde76c096d7a791d0)},
			{LL(0x414fb5be3f8bdea8), LL(0x7fec43ef6d8de163)}, {LL(0x6bb729f298641387), LL(0x26eb025781df8b5d)}, {LL(0xbac9e318d71cc32d), LL(0x451fea67d0ec14a3)}, {LL(0x8cfb5ae6c576505d), LL(0xa01a9de23945954e)},
			{LL(0xf40917d0ed49559d), LL(0xaa5351456e65b893)}, {LL(0x53e0635531adaf39), LL(0x9def6e2d8bea9e38)}, {LL(0x1cca25b2b5855e5f), LL(0xbc02363d05fbebd3)}, {LL(0x67c57df59c3df226), LL(0x276b1ccc02b06ea0)},
			{LL(0xab9b2082d8bd1b05), LL(0x363c21f366e0c356)}, {LL(0xd9221351f6166ed5), LL(0xdcb5fc63127998e9)}, {LL(0x80890ee1c12fb1fc), LL(0xa19a8379ba2a70b3)}, {LL(0x47769f5c3d464f19), LL(0x9eac4c43cd5b72fc)},
			{LL(0x4d3de1b93bd23f09), LL(0x7e6c5d74eee2049e)}, {LL(0x960855b6723e9fb3), LL(0xfd58a4739c68ed02)}, {LL(0xf3da8f1d51f9a3fa), LL(0x85b2bddbfe2bf2d7)}, {LL(0x520ad17a8fd0c8ef), LL(0x534e8d1fbb7247e3)},
			{LL(0x95f540c773b9360a), LL(0x6c784225cc0345ac)}, {LL(0x1edd82ec0a7f9030), LL(0xe383335965089aa6)}, {LL(0xd6ad5227f3c826cd), LL(0x4c1504aec17dd5ba)}, {LL(0x01eab22fbe7d67d6), LL(0xcea1e3323098d9db)},
			{LL(0xe17559f65fdfd26b), LL(0x67b19019184c8d8c)}, {LL(0x05c43f93034a3808), LL(0x7060e9faf0bd3b31)}, {LL(0xe55bd44ae2e88db5), LL(0xd9709ad1d8696f66)}, {LL(0x4aee79748762c96e), LL(0x518db1ea7eac4eda)},
			{LL(0x97e2e799cc43f865), LL(0x33f94741acf034d9)}, {LL(0xcdb4ef58fafd8ef5), LL(0xdff6de0d54c8742d)}, {LL(0xd17ecaea4f78d0aa), LL(0x63f4e83051339ffe)}, {LL(0xd5504756f24f8f74), LL(0xdd35e2f891167d14)},
			{LL(0xf5e3a5ff5334324b), LL(0x64f2b2775efd6148)}, {LL(0x5841af9f8944b8ff), LL(0xb38e9c2898cb3181)}, {LL(0x18e4a80e08b20181), LL(0x02c33cf5c5de0939)}, {LL(0x300b931c10a702c1), LL(0x04457829497f1272)},
			{LL(0x3a40edf9163372d1), LL(0xe485691e6ac66410)}, {LL(0x1152c39a0fa1d828), LL(0x7323cb94b60cd7f5)}, {LL(0x06392ae202cd91b1), LL(0xe1400faca0d6939f)}, {LL(0x875a962c7d9f479b), LL(0x8e7b6fe72a643af7)},
			{LL(0xdce62cc2f55c56dd), LL(0xacd51599e2c4a3d8)}, {LL(0xcc5e5d774480e923), LL(0x11573d3f6450adf6)}, {LL(0x20b3e2a9a17bbd3f), LL(0xb9c7508fcfeb1c5c)}, {LL(0x90317f5470f30e02), LL(0x1c18abdf3cbe7e9d)},
			{LL(0x0a4b7ee506947010), LL(0xe0c0113723b97662)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x9fbe3e22752d461a), LL(0x8cb85312efba33ce)}, {LL(0x3c79c71b14fee360), LL(0x05c566b2ca10f78f)},
			{LL(0xb75105306d38455a), LL(0x8a3e17ce631b2885)}, {LL(0x684a3c8399e3ba3e), LL(0xb7cbe401d1b423f3)}, {LL(0xa98c87dc6747d56a), LL(0x69bd24970613b223)}, {LL(0x7ecb67d42af29471), LL(0xeb09c30bf7f6be42)},
			{LL(0x9da9997ccad78875), LL(0xd33956768f4942bb)}, {LL(0x756aab1e921b83b7), LL(0xc568310ee4d711fb)}, {LL(0xa3c7f93961d3a57a), LL(0x897d35a025aac441)}, {LL(0x3f84d26a15794ad9), LL(0x94e580e49a7b5f21)},
			{LL(0xdadf0620f791c76c), LL(0x4d951a3542123047)}, {LL(0x829ea9bf7ed57f93), LL(0xfe1b861ddad901c6)}, {LL(0x83741b90c0a81845), LL(0x30ba652fea41d81d)}, {LL(0xcfa348064507409a), LL(0x8077db69343b0558)},
			{LL(0x1d20979d0bf83989), LL(0x72a3d50f35633208)}, {LL(0x8b28c22b79c6a63a), LL(0x8ffb717ca90bdf0a)}, {LL(0x33f6866d1120ab78), LL(0x95659e7f1914badc)}, {LL(0xa41461f4dd63531d), LL(0xa69cd93eb5e48e05)},
			{LL(0xc5e836e34393308a), LL(0x60b7ca5e1782733a)}, {LL(0x61fc57179ef06397), LL(0xc62b1360a266fd3f)}, {LL(0x63ebf049210aadf8), LL(0x99aa1604c2958c4a)}, {LL(0x2b122e631992aaf9), LL(0x97a6a28adccab3e5)},
			{LL(0x27607a641dcb4b58), LL(0x9626bc115fa55618)}, {LL(0xf2303d32ef84c42c), LL(0x4b135ee9ceb32b0c)}, {LL(0x735381fc90d61206), LL(0x24283ea244018264)}, {LL(0xa86635f3d93ab2bc), LL(0xa71cc7a5368b6bf8)},
			{LL(0xbcf0c9fad5d1529c), LL(0xa45fe5cb703a873c)}, {LL(0x893f6575c63c6855), LL(0xd07a7418c9f8ae7f)}, {LL(0xd09478c5f105b77c), LL(0xad550b0261ab4625)}, {LL(0x8163bcce7f52d62a), LL(0x6f3b604b8ab2a968)},
			{LL(0xc3d11c01415ea13b), LL(0x81f7c5f2b754e0a5)}, {LL(0x643868849dba5b9f), LL(0xb64bfa9a52dbc60e)}, {LL(0x0ba1cccab8e917c6), LL(0x2e61f2051321afb9)}, {LL(0xecedbfdee5fb541c), LL(0xa8906db0abbbb1aa)},
			{LL(0x10b871b5b1dcbffe), LL(0xbd8228a686940e2e)}, {LL(0xac48b84f640ded62), LL(0x19ddcd6df6ae8912)}, {LL(0x986da6efc99db07d), LL(0xa359bf8c7ff4798a)}, {LL(0x5c6f22233473e721), LL(0x0d4f96e058eed36b)},
			{LL(0x78f24d36283f05c0), LL(0x0a49cca757202ddd)}, {LL(0xf61eb08e52b39bf2), LL(0xf5d254210e96c9e6)}, {LL(0x5d85900c8a0e80f7), LL(0xc3ee75d268760ab0)}, {LL(0xc615239242149933), LL(0xf1972c0847e9db94)},
			{LL(0x5f92375235f44e98), LL(0x9c6f70b608857bc5)}, {LL(0x09b66b940713d9a9), LL(0x71e0f76173d2decc)}, {LL(0xc02c097040d90882), LL(0x10d723a4e73f480b)}, {LL(0x86b02403c3e2204d), LL(0x40da8cd51afce32c)},
			{LL(0x854d3172c26589f4), LL(0xd1fa6a834a974b82)}, {LL(0x157c4e26b29687f6), LL(0xcde2c15c7629351f)}, {LL(0xe929804de6b16c14), LL(0xd8f0844a5b068a9b)}, {LL(0xeb3e2713594ba27b), LL(0x8771812e3bf5fbee)},
			{LL(0x7b0f584729b8ac79), LL(0x9b692af1074b8573)}, {LL(0x31e12133aeda6517), LL(0xcae49b1b79e7cba9)}, {LL(0x662fcfda224095f0), LL(0xe9cafffe3228b77b)}, {LL(0x70ae948d9151bbbf), LL(0xb508d8f4146a2aca)},
			{LL(0x469c2d73833b28cf), LL(0x500daf71fdc3ab27)}, {LL(0x48f9de2a38980701), LL(0x0e0cb48e1e5f3faf)}, {LL(0xc23bae2eff23c6ed), LL(0x4f5626c087cc397e)}, {LL(0x9e548c0dcb5021cc), LL(0x4219b020df22ea15)},
			{LL(0xa1d05e67de296b15), LL(0xd6fc30c44559b534)}, {LL(0x2f3ca3dfa4a5f527), LL(0x2967a8421cef510f)}, {LL(0x9c432b5374aaefa3), LL(0x1d98b544bfd19b60)}, {LL(0xdd0c9eed4b21310b), LL(0x6274f6abd25c7a03)},
			{LL(0x1b19bd7f0935a838), LL(0x93e3daa395b5a197)}, {LL(0x190e1a21b6cf6657), LL(0xcc62dfc7f546d0e2)}, {LL(0x07d398cdbcb0f667), LL(0x2fe1ec9e904e4a44)}, {LL(0x88d5d75a78410f83), LL(0x1edb972af96077a4)},
			{LL(0xf87b43d7e910b43c), LL(0xabd34fdeed0a5d6e)}, {LL(0xc870d0cbf9b7b6fd), LL(0xaf9637f7a4754f1c)}, {LL(0xa22d4b16dfaec2ac), LL(0x47dcd69215321d9a)}, {LL(0xf1cd2843ee036d95), LL(0xda33b8bf9ed883a2)},
			{LL(0x6a5d9bdd26197451), LL(0xe84ae165b1475286)}, {LL(0xe2884c875e587bd2), LL(0xf691764f48272522)}, {LL(0x249d6f151c4ce2e1), LL(0x07065a470fcefeb6)}, {LL(0x8f064f97c4f1f9e4), LL(0x313a7bb4692e3de0)},
			{LL(0x37d80bd1ac17f4a6), LL(0x2ba494b7d9315836)}, {LL(0x620142669f77ca2e), LL(0x570bf536f20d5591)}, {LL(0x2cc1b6aea5225c9e), LL(0xb8474e144c84f9a1)}, {LL(0x4ec0f4c83a5596b0), LL(0xef4cbb22be89ac30)},
			{LL(0xe362fea8e0251c04), LL(0x3830957d78bffcf9)}, {LL(0xed070df15b8633ca), LL(0x66318e829b236871)}, {LL(0x6c64b13f24d4e5e0), LL(0x090aeec91191c119)}, {LL(0x40a5079181f6b97e), LL(0xb14da0dd5d1538b8)},
			{LL(0x4f2a46e78428f166), LL(0x21ed58108e1175eb)}, {LL(0x22a445f71e817350), LL(0xe64655ebaf186d29)}, {LL(0x65d2daab23c73c49), LL(0x78ea19a862431fd5)}, {LL(0xffa8db1a55a0425b), LL(0x8432a3407d44172a)},
			{LL(0x176be9780d6c4999), LL(0x9263c43816da446a)}, {LL(0x39bdf88817b4db68), LL(0x75a58f483aadccbe)}, {LL(0x215950861f06dae9), LL(0x7766b3bdff73c587)}, {LL(0xd3696db4f0821ec5), LL(0x3c75ed5431c0ee8b)}
		}, {
			{LL(0xd92529bea31248d7), LL(0xfc012d6adfaeec10)}, {LL(0x6c820e60de114463), LL(0xeea0cb202af27c92)}, {LL(0x72af0d3d2274135e), LL(0xdd47d2aa23c727fa)}, {LL(0x0a1b018a54238caa), LL(0x115db6c707138899)},
			{LL(0xc7082ae35f771fea), LL(0xcfe634e0d69bb778)}, {LL(0x533d5758428b692a), LL(0x6ee8718966c0f698)}, {LL(0x7544868473e41629), LL(0x314f797c14fe4b7a)}, {LL(0x6375eeafa0c28e9c), LL(0x16322665cf09b0a6)},
			{LL(0xb04bc69b57f34ae1), LL(0xfb6ebdc817b4d42f)}, {LL(0x17d35d550f1658a4), LL(0xc4ff2733507eef2b)}, {LL(0x649e6516f1528beb), LL(0xfa3a8db3f830dc26)}, {LL(0x1bc1e218d6951168), LL(0xda284208ebdd1fc5)},
			{LL(0xc0e3a15a0ee71a9d), LL(0x23ee9f36e1a2dbf8)}, {LL(0xc306fed8a9b799ae), LL(0xc5ab1748bffae722)}, {LL(0xd6d2c971ddc18228), LL(0x0493c02f3a552024)}, {LL(0x93def6024c6c73b7), LL(0x4d06eebf87622d60)},
			{LL(0x05ece1452af04655), LL(0xe9cf5b82e2e844ad)}, {LL(0x364107306fe922d0), LL(0x7750841015793e49)}, {LL(0x6090b12d07920daf), LL(0xf077ae1b91518c7c)}, {LL(0xcf1441957034d062), LL(0xdb7c7273045917cc)},
			{LL(0x5ecddd6b4738e0f7), LL(0x93bd6c9856ea1281)}, {LL(0xad839a440cc69eef), LL(0x2ecc2c3c40d9b39d)}, {LL(0x5ac30950b1f866b3), LL(0x99f04f303f8b42db)}, {LL(0x9a20a80abf1f7c2e), LL(0xba1ed006de299923)},
			{LL(0xb7a04d2206634f96), LL(0x1766161e208db8af)}, {LL(0x1c2a69a18705141f), LL(0x3620e9dedce47345)}, {LL(0xb44512a0a133cca5), LL(0xf1239e607ed58475)}, {LL(0x4ef50b8719bebd24), LL(0xbb4ae07d31ad912a)},
			{LL(0x081c6b762f43cf88), LL(0x149a4693d2c2a0b4)}, {LL(0xac61af3ad0f65efe), LL(0xcd4e5416cb50a76a)}, {LL(0x2679d1dc316f7f03), LL(0x5fa708f5723ebde2)}, {LL(0x15d437a974761b86), LL(0xc138d76785afc706)},
			{LL(0xdb224342d8720bf5), LL(0xf9c6dd3e0a7fc43d)}, {LL(0xb1a9f3e58bc38af0), LL(0x18ecc5e29c3dc0d8)}, {LL(0x83e620ee12ea2e64), LL(0x65f1625ae025aecb)}, {LL(0x247ebb204a0f3c21), LL(0x5a60f8a1a7ef95cf)},
			{LL(0xd53796f37a91011b), LL(0xe2d64851640d1cfe)}, {LL(0x99c5f788184fff1d), LL(0x5c5b58788071a5f9)}, {LL(0xb857aded78b08569), LL(0xeff4fb5bc576749b)}, {LL(0xab8a248381665b89), LL(0x2146ffc0fc69cbea)},
			{LL(0xeb6afab53a3bec43), LL(0x811c8ad2a3b68203)}, {LL(0x677b3a94560208d8), LL(0x1c7f05cda668e0fc)}, {LL(0x1824bd9a71c5925b), LL(0x3c6dca76b585231f)}, {LL(0x95d748c5c1ccb6d1), LL(0x428c3d433bd25517)},
			{LL(0xef642e8eccfb6a07), LL(0x8b51a97acad7d259)}, {LL(0xd4d5a38da6a1c10a), LL(0x0154307bef840809)}, {LL(0xed634472b79b2925), LL(0x8e96592e1f06fa74)}, {LL(0xf8b773dbc3ed32a3), LL(0x4fae8e499aa93d72)},
			{LL(0x02076afc7b604322), LL(0x05c7f054d5d1282d)}, {LL(0xe96d9049415baf61), LL(0x84db7a867667aa2e)}, {LL(0x6b6985d98f814114), LL(0x02a860f61dcb1012)}, {LL(0x923cc37c905cb3a6), LL(0xae8496950ceb3997)},
			{LL(0x01e2357edc30c011), LL(0xe382782a8b8914f7)}, {LL(0x85ef9e299f4aeb02), LL(0x6a7bb1a65c95d6bc)}, {LL(0x39b6e7ff113ae82f), LL(0x8fc26955f082f27d)}, {LL(0x40e0de36bb5db7ca), LL(0xa05a75125fdf49e9)},
			{LL(0xbdbb4ca85240c33c), LL(0x063ba0d9279e3036)}, {LL(0xd0db77b65061474e), LL(0x0b1913d386e55853)}, {LL(0xd33e2834f731c47d), LL(0xed5c9badd8bd6489)}, {LL(0x8e16aadd1759a7b9), LL(0x98a47f4bd00f4ad2)},
			{LL(0x592656d216a8e580), LL(0x7fb5c74e61d37e01)}, {LL(0xc91dff52fd941504), LL(0xd4f6a18fb8e96fbb)}, {LL(0xa073107709751732), LL(0xd399312d70f35784)}, {LL(0xd8c71cc07f2288c6), LL(0x1f8355405427f8e7)},
			{LL(0x6e85649ca5710741), LL(0xeb673b74ff2354bf)}, {LL(0x7743ec780884550b), LL(0x34888928c12f6357)}, {LL(0xc6ea1f9d8347dffb), LL(0x2c644cca5d12a38f)}, {LL(0xf4a5cc961a6e7b6f), LL(0x5179eb72210acd9c)},
			{LL(0xba50c71103d0c64b), LL(0xea330b0f10a75cb6)}, {LL(0xae66c5c6ab961ddc), LL(0xc889a4421e818f47)}, {LL(0x91d99cfe370c3095), LL(0x48c11eeb52b3054d)}, {LL(0x903ba980eb3cf084), LL(0xab4366c1d93a11ba)},
			{LL(0x0bf934f488134cbb), LL(0xf2dfceed8c9a9c6e)}, {LL(0x7b515335d1071cc7), LL(0x2a5fec137a8c93b9)}, {LL(0xee861bf010cbaa16), LL(0x68d3d150415ec6ae)}, {LL(0x2b895bef34dcf6de), LL(0xa2f215e4421459fb)},
			{LL(0x0df08a3305b389dd), LL(0xfd551d11302ae419)}, {LL(0xa59ff13223855167), LL(0x3a566aaf921b1329)}, {LL(0x13dd896ef9d6dee0), LL(0xceb2049b391fbf71)}, {LL(0x78b40cb776579ff4), LL(0xcc1a646d24d4af63)},
			{LL(0x9c2916cd32bfb948), LL(0xb59403fa6299e154)}, {LL(0x5f2fe8159b0820e6), LL(0x703f14b2dd630676)}, {LL(0xd2dc1d4a2b01046c), LL(0x0edee3875334707e)}, {LL(0x9dcb23b3ee8f7959), LL(0x56167bd0e910f5a3)},
			{LL(0x6f6751e27941c750), LL(0x08e5435e74aa4048)}, {LL(0xb9b59893a4804578), LL(0x0c7683714eff606c)}, {LL(0xe294a4bdc948e3da), LL(0x7604b46bfafd3640)}, {LL(0xb5a727de7d030cb4), LL(0x12a1e64af55c9082)},
			{LL(0x9827c2f6c47f3f0c), LL(0xbfd920520bf8b10e)}, {LL(0x34466dcc148961f2), LL(0x72977444c0a81664)}, {LL(0x61728453dba2cdbe), LL(0x13f5d6311ad8988b)}, {LL(0x97d02239baacf5f3), LL(0x474bcd17ee037d3a)},
			{LL(0x58c463acca982591), LL(0x9c37bf64ea5a6af6)}, {LL(0xf7409314bd3ef85c), LL(0xb73c630c7f52f146)}, {LL(0x4d105405beee3e17), LL(0x5d0f68036ff5adf0)}, {LL(0x56d1b61d687b2f7f), LL(0x87272a0b8428b235)},
			{LL(0xdcc9c8fb89e20e82), LL(0x15ce76e83d46a8bd)}, {LL(0x94357dbb1dfc76c0), LL(0xa10e4569b05b41e0)}, {LL(0x5ccab7973c58a3d5), LL(0x967a9ccc833b3aac)}, {LL(0xc4ed7561f8279cd9), LL(0x29a3bc9e88c38ba2)},
			{LL(0xdecea207f2824da0), LL(0x100986bce8978090)}, {LL(0x8ff49fa3cb6967a8), LL(0x7b2607615b865e25)}, {LL(0xe57f2f0498d8e6ad), LL(0x9a0c1fbdcdc45ac0)}, {LL(0xa86f7b012636d8ba), LL(0xc70377bea231f730)},
			{LL(0xdf2c97792eb28db1), LL(0xf38bfe96631e9467)}, {LL(0x35a458b2c8b9a1e3), LL(0x91150c6e4b210293)}, {LL(0x3048b9f7e249e7b6), LL(0x78da57eca9c9463e)}, {LL(0x87e8f4d5e42aa820), LL(0x6fbc41f28944fe91)},
			{LL(0x8c11c0216c39e49b), LL(0x9d638f1f05de62ff)}, {LL(0x33ade67545196485), LL(0x9e9fdf92f7917ae4)}, {LL(0xf547f9e8c65ebb7e), LL(0xb2fb9358aa83d96b)}, {LL(0x4afbdfbcef7e3b60), LL(0xb107c3d558ccc170)},
			{LL(0xcaf8a0d05ac49637), LL(0x32b329f1e6b15361)}, {LL(0x5d2882e9e06863c4), LL(0x75f8e4e608b22e5b)}, {LL(0x657c50682d624bfa), LL(0x19b8f59973b9c8d1)}, {LL(0xccf11e17d7645351), LL(0x3d39fa0d5a012b16)},
			{LL(0x66990fea8a32c8c9), LL(0xfffd7de72de1f40b)}, {LL(0xa3964ff5ae259401), LL(0x35dcb9532eab6b5e)}, {LL(0x3bb18d036a5aab0d), LL(0x8a0599012553da50)}, {LL(0x8df3f55fb009248a), LL(0x7ee1f7358e577608)},
			{LL(0xec81710c6babe934), LL(0x6d142104948fee83)}, {LL(0xf6a2a66a610e384d), LL(0x54be1b26f4dbe5b1)}, {LL(0x7cbad88c809719b0), LL(0xc65747c54db5ff39)}, {LL(0x3fbf59389c9a2d49), LL(0x8048baa94c328a0a)},
			{LL(0x7ebdb270fbf75a92), LL(0xc390b7919864d714)}, {LL(0xf34e472f4bfe7e18), LL(0xbd7140a41633a11c)}, {LL(0x6d603b1e02218472), LL(0x0d22b30aa17b6865)}, {LL(0x491e803e482eb853), LL(0x57424bab0694fdaa)},
			{LL(0x19c688e4adf5524a), LL(0xdfefb25c3e0c37e8)}, {LL(0x6297dbd17cf24e8d), LL(0xf5b05e4f4480a451)}, {LL(0xa98d4e7ffa0618ab), LL(0x24810f9429b8e3c7)}, {LL(0xfb522c5964bdb190), LL(0xa9eb0637c4f101a8)},
			{LL(0x734d3843fe44d34f), LL(0x3ec5aa80a84e330d)}, {LL(0x2f878fd4c21c709a), LL(0xa8bf364c2b7509a1)}, {LL(0x4102eb48676d77db), LL(0x43d80d38d4565d1e)}, {LL(0x7ab3664b0d37dcd6), LL(0xc9dd9439f105874e)},
			{LL(0x76a1d906d4b4951a), LL(0xd70af1024aa677a0)}, {LL(0xe49d1a7a44e826bc), LL(0x798e6797464d4e37)}, {LL(0xa2747a8b72155410), LL(0xd65ec179a5227fa9)}, {LL(0xdd2bfd8555d2ce93), LL(0xf64c0ec2b6cfbc4a)},
			{LL(0xe69a70863f88659e), LL(0x7c4997c3939c661a)}, {LL(0x143602d7a846db97), LL(0x22baaf4d0e26d3f1)}, {LL(0x259c8e5e963ffc30), LL(0xb9e2808b2c668138)}, {LL(0xbfbc26542920801e), LL(0x03fc508df24f181b)},
			{LL(0xbe5e132af510400f), LL(0xe07e28a779c60cec)}, {LL(0x0609bec78da0c566), LL(0x0f8ad3fcbcb07877)}, {LL(0x07eb8bb951900577), LL(0xec08abd637396c80)}, {LL(0xcd132b690b549340), LL(0xdebb8227d1883fe1)},
			{LL(0x5b213c2e6dc8a6a2), LL(0x7a72371ab402562c)}, {LL(0x37a3324eb3d9e2c1), LL(0x94d2fc3a9ef02abe)}, {LL(0x9e2e7c3149dffa6a), LL(0xb053f3aeb748c979)}, {LL(0x279be4a2ed5fbf12), LL(0xbc2570dff9b7a915)},
			{LL(0xa67aaeb084d5d254), LL(0xdc13e2d1cc432ff3)}, {LL(0xd13942c88c51875f), LL(0xe89b6bf90d6c4ca4)}, {LL(0x1038d6ec5e865dd3), LL(0x28f78ce5674783ab)}, {LL(0x20706f1bbccfba65), LL(0x502ddb09ce8ec595)},
			{LL(0x2c62d056654cf3a9), LL(0x4efabe32752d357b)}, {LL(0x1e2d035dfc65573d), LL(0x33e7198a09355b68)}, {LL(0x040ed43bf6c08644), LL(0x0a4d23a86961505a)}, {LL(0xfab01927b88d7181), LL(0x4a697e1d4f78155f)},
			{LL(0x298e31134fbcb5fc), LL(0xa735e5b097c571d6)}, {LL(0x881f141a9af962df), LL(0x972eacb76cbf32a5)}, {LL(0x81e14a12698a6d46), LL(0x6036920e35f486e6)}, {LL(0xe093ce41b228a0f8), LL(0x73c3443f2f2c1e6d)},
			{LL(0x0c12bf4dd98349cc), LL(0x1ed7653bbba3f0ee)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xea88cfcbe60b2c52), LL(0x629ef2f8283f96f4)}, {LL(0x286c046d938c75ed), LL(0x44b79d9a1c4c6521)},
			{LL(0xdac0763c0442cbe4), LL(0x1a44a51481f6d0ca)}, {LL(0xf1492dd3309e3d3a), LL(0xb8b6b0f0c3e28931)}, {LL(0xcef674ebac041073), LL(0x38fe0a598fd0033b)}, {LL(0x54d6dce1131b6c5d), LL(0x82e0da5f51f99a18)},
			{LL(0x57338363b44bef6e), LL(0x64a552210fa1a6c2)}, {LL(0xe77845f8e3b8a58f), LL(0x9fcbefe9181572ed)}, {LL(0xc2e4cba6758759bf), LL(0x26296f623473f3d5)}, {LL(0x2a6b6e91e8ec36cf), LL(0x41706dcec99d4d0c)},
			{LL(0x2d80e528b97c33b8), LL(0xad78c618fea4218c)}, {LL(0xfcb9a7e0352db4e7), LL(0x45e3ade1f3c86d28)}, {LL(0x430581b41c0d34f9), LL(0x461ffd6c01877533)}, {LL(0x8a187ee6e19921fd), LL(0x92e95ce3b96e1a88)},
			{LL(0x1631682bd32698b5), LL(0x277d5f19dbf7fbdc)}, {LL(0xf2ac725197cebe09), LL(0x5ef3388e9dbab5eb)}, {LL(0x227705e7c7aff947), LL(0x55ea2b5d1b5fedb8)}, {LL(0x795639c9aa675fe5), LL(0x2f981c47af5dbb94)},
			{LL(0x860ac1ab381a6831), LL(0x8c3e39d802cdea66)}, {LL(0xff5cf862927d37d4), LL(0xa3a6259fad9051f2)}, {LL(0x42e7b4cac03df4e8), LL(0xa59d85468a0e61c4)}, {LL(0x324fd30b9929a494), LL(0x7d1da7b87c186e13)},
			{LL(0x3a53b87db66a6b1c), LL(0x6987e12baedacea7)}, {LL(0x1dc85cdf5b35d40e), LL(0xd5a291f4576d67b2)}, {LL(0xe37691c3157823cb), LL(0x9586cc41717422b7)}, {LL(0x714a52bf8524906d), LL(0x3b025ad47d9f1b20)},
			{LL(0x696eef25f4e10236), LL(0x076f90a2c81a383f)}, {LL(0x4f173ef9c58e7d35), LL(0x58c89857ba2485dd)}, {LL(0x21925a6560ff7a74), LL(0xb3afa3234507d162)}, {LL(0xfebecd1c4e4df7c5), LL(0x40245db526194505)},
			{LL(0x82041590cedaee75), LL(0x86731a706bacba3c)}, {LL(0xf95546a51fddf2b2), LL(0xac2cf66311202985)}, {LL(0xb3ae9919f0a3c9d2), LL(0x1d2b35b649ece8f5)}, {LL(0x09fe5e08f3730f99), LL(0xf7183eb9594bb443)},
			{LL(0xa1912509d545d723), LL(0x301b4907fb7a4373)}, {LL(0xc8ffca2c21a4d515), LL(0x3774d9a533607b4c)}, {LL(0x513a3da439eb2a08), LL(0x6b2f81ddb311deb5)}, {LL(0x688cda5b28d1c227), LL(0xe4ede88843932cc8)},
			{LL(0x50d808dae5dbea19), LL(0x88adf9f73898ca42)}, {LL(0xa47dc44cffb59176), LL(0xd9d41285199207de)}, {LL(0xd730fc0f01f14239), LL(0xe711b805b1dc34d3)}, {LL(0x840dab57437a2b13), LL(0x89f9c98cd71cc24b)},
			{LL(0x6a8bb0a753b18105), LL(0xe12a18dc964204e5)}, {LL(0x0e15d5b1a2e30aee), LL(0x1b10956f6e72d8c3)}, {LL(0x80037f6cb5baad57), LL(0x83b4ea24be7d9211)}, {LL(0x450c3f7391adf19f), LL(0x49952e90bd370d44)},
			{LL(0x470b558feacdb2bd), LL(0x4c52dec468e62569)}, {LL(0xa7989bce58e51245), LL(0x3f919afb47ca3b04)}, {LL(0x0ff7e0cf7ed3caff), LL(0xf892ed45e5fbcc34)}, {LL(0xb24cac672c9309c3), LL(0xfea94d9cc265fc02)},
			{LL(0x52df62269ebba93b), LL(0x8d6a09a3ed49e26f)}, {LL(0x9fcc494f95ef3a7b), LL(0x53d18b843cc1dd8e)}, {LL(0x44ee0a0d4d9d318e), LL(0xaa1756ba36be19b3)}, {LL(0xe171fb3f6e1860e9), LL(0x90413c15a4a50a9a)},
			{LL(0xc50f401f24175cc8), LL(0xca21c4b4034a9f55)}, {LL(0x70a867c15914507c), LL(0xd88022fef6160fd7)}, {LL(0x3db833c4e7fa6e6b), LL(0x858f4afd99e3a227)}, {LL(0x5534e99fcf2bac4c), LL(0x6162a275da708eef)},
			{LL(0x7f5f870e27c79a83), LL(0x2012cfbb13edc3e3)}, {LL(0x8bfa4b983da9e1ec), LL(0x716b24c932e70e7f)}, {LL(0xe88fa5379d6b6f70), LL(0x675902acfdeebed9)}, {LL(0x96321747669c35e2), LL(0xa4c9b53d658a69cd)},
			{LL(0x123fbc1025e61ef1), LL(0x2d307cb1b296ab86)}, {LL(0xaf84f0b877a6ddcd), LL(0x2b0bdc6895089bb0)}, {LL(0xbbb2f26fdfe0065a), LL(0x09b173259b2e4841)}, {LL(0xf0ab18adecaefd2b), LL(0x5b34c8da486b9dc6)},
			{LL(0x11dae39282b69dc2), LL(0xcb75f4cfecce975c)}, {LL(0x31aa8c893e7927a7), LL(0x9b582fc6224052c9)}, {LL(0x7d58edf25ca7d9a1), LL(0x25d53fefc63cebce)}, {LL(0x1fcf36232055972c), LL(0xd06561a082bc4f9f)},
			{LL(0x4cf2617b62defe06), LL(0xbe8d1029e47cb907)}, {LL(0xbc5979d68e70032d), LL(0xe5b9d8f3ac1724c1)}, {LL(0x3854d281cd0a283e), LL(0x6c40117f7b0be68a)}, {LL(0x4b19eac2334efb71), LL(0x5285bbffd345d587)},
			{LL(0x9bc29d74632fbc3f), LL(0x599ca82c55a08dd4)}, {LL(0xfd5b929ee91d74f6), LL(0xa661d5cb784179df)}, {LL(0x89fd216446c9a2ce), LL(0x74acd49de7362652)}, {LL(0x74a6b3faafd4d638), LL(0xd2cd01569f775f8d)},
			{LL(0x03e55f82a7508333), LL(0xe645887e5e583cda)}, {LL(0xb642785cda538f87), LL(0xf4e46e34ab04ac58)}, {LL(0x48fcb540941e7842), LL(0xb4c033818d1de95d)}, {LL(0xc1019424d2d7da8c), LL(0xc06ce71c6a2bcf0f)},
			{LL(0xcb1a95ae86f45626), LL(0xd13151db6d384796)}, {LL(0x3c5a06ba3bcaae7a), LL(0x660d32d7126ab6d0)}, {LL(0x46e960f136fd72ac), LL(0xafd0a6eee36f319e)}, {LL(0xaa6811fd5d569b98), LL(0xc2c487ea77e0df1d)},
			{LL(0x1a23d7660aa5d179), LL(0x39aa3a2260540b32)}, {LL(0x2e65baaa1e2cb08b), LL(0x4b3d4e66a0fc1d56)}, {LL(0x3e5d6c4640aaed58), LL(0x63cac283c7bb9efd)}, {LL(0x239530991b9f3956), LL(0xb668537790d6f94f)}
		}, {
			{LL(0xb3a97ed91e9d2ca8), LL(0xb483a3c43d6b01c0)}, {LL(0x4c14776c9da46bb4), LL(0xaa39ded25980a017)}, {LL(0xd8d18f72d6c39596), LL(0xce15226d28ed47b2)}, {LL(0xcd43e90a399ceb1e), LL(0x9da554d42f9a5d63)},
			{LL(0x276c86c755fad28a), LL(0xd0af5f7b4c06e665)}, {LL(0xda1d3753e15099f5), LL(0x07b14249e961e86f)}, {LL(0x09d0f97526a1369f), LL(0x2787738203334f7d)}, {LL(0x06970b63597614a5), LL(0x982fa06c805732a4)},
			{LL(0x787d9cb07e77d313), LL(0xb109577c92a66e07)}, {LL(0x24c6621798c1d839), LL(0x9c590f4d0cccff37)}, {LL(0xd7967d64a914b7ac), LL(0x71bdf183ab893a6b)}, {LL(0x13056d1bb6296a2d), LL(0xcb9fd6d587202875)},
			{LL(0xf66df0c0a5987183), LL(0x393d0e9467d8eeaa)}, {LL(0x8b2d83c34fa2bc86), LL(0x5ceda9b235e3ab5b)}, {LL(0xf92a02d6da4f53b9), LL(0x8695dd7ae4bc9373)}, {LL(0x2c70c79344c8e876), LL(0x3e8c4cdd8eb906c5)},
			{LL(0x87c09505fd4e940f), LL(0xafb32a6af64dcfd0)}, {LL(0x260ada36af52d45a), LL(0x55fd6f69cd4050ea)}, {LL(0x7bd77860b34cd9a0), LL(0xfdff074ad26c7755)}, {LL(0xbcee8ccf614a0e92), LL(0x0b2b702abe0f7c19)},
			{LL(0xc65fa85e28aed1e2), LL(0x73864772ed25bdc3)}, {LL(0x91f817addf2ae034), LL(0xb0f50ce5b1f0cc53)}, {LL(0x6a1ead5a32f6bfee), LL(0xffc4b1bb94c0f0fd)}, {LL(0x9c735d9a976ece6d), LL(0xc6f9bf2ff3181e57)},
			{LL(0xa97ceab78e15701a), LL(0x589b0693b97866c8)}, {LL(0xc2041b1c464bc924), LL(0x220d873aacfe20ba)}, {LL(0xd43c99b4642fbd1f), LL(0x3d4ba1b5eb432339)}, {LL(0x3398bc4e400daad2), LL(0x064d19d0ca374a3b)},
			{LL(0x9b820a0834b0dc18), LL(0xdb842f51f2099a7c)}, {LL(0xba7987ac383c1a37), LL(0x9304d0463e584ebd)}, {LL(0xd3cdce26c7f1af6a), LL(0x203631cbea52a712)}, {LL(0x7207811595edef3f), LL(0xda7874c8d15f3828)},
			{LL(0xe5689ddb13b11bae), LL(0xf2a2d841e0f8c6df)}, {LL(0x53fc0cb199612910), LL(0x92f88bdf1d0eece9)}, {LL(0xd9b7d3832c6b9346), LL(0x4b47127fa9abf13d)}, {LL(0x850c2d24cadd986c), LL(0x66174a4e37c1600d)},
			{LL(0x846a71d530759ebc), LL(0xe3457a5cb687d682)}, {LL(0xe1332e997d540368), LL(0xa3291809a1235ba6)}, {LL(0xe3ff96b84ac70f0b), LL(0x6a8d782d60aff47b)}, {LL(0x6b78f1abc85eb93e), LL(0x7a9681a915864672)},
			{LL(0x39e2a1ebab9796fe), LL(0x6d3c3a6489ce1c14)}, {LL(0xaad60e67432e7aa9), LL(0x146d56a5f9b27f9a)}, {LL(0x6e451e185c13a728), LL(0xae4f71f3d51b6d84)}, {LL(0xd6f0219553bcb17c), LL(0xf4efc1912acf8ce4)},
			{LL(0x95a3a4efb1cff8f2), LL(0xe17eccadf02b512a)}, {LL(0xafebe1d4d76364bf), LL(0xc0b4a6ff392f546c)}, {LL(0xc36247edbce3cff4), LL(0xa75fb7282db89635)}, {LL(0xb165c6f8290e20cb), LL(0x7d27c3e0fce7ae1d)},
			{LL(0x56c1e3020d2c3706), LL(0x46217b85dd93c71f)}, {LL(0x6f2342e9a6bba1f8), LL(0x2b1d41e1545ddb0b)}, {LL(0x9d15016b6dc6c8bd), LL(0x43ab8f3d725ea8d8)}, {LL(0x07f15792a3de1275), LL(0x1d7d907e0111842b)},
			{LL(0x2b819001e716fa03), LL(0x23f1dca38fa882ee)}, {LL(0x233735853b1fca4c), LL(0x81249f330ddd7b1c)}, {LL(0x6c89a6396b80ab4b), LL(0x67eb11d71497c259)}, {LL(0x529a504063c92fc0), LL(0x17aabbcd9c485a66)},
			{LL(0x643f03bdb7899b04), LL(0xc53e524796e23bab)}, {LL(0x03aae4d0cd3b0ab3), LL(0x4cf6503640ca1952)}, {LL(0x7eea97d32701c7b6), LL(0x2926f71012f15ca3)}, {LL(0xc5f54c8ee595db51), LL(0x3f701744adefa491)},
			{LL(0x175ede59d8cc72eb), LL(0x9a14169dc6fbb50c)}, {LL(0x466e6ac9763e5798), LL(0xc148fd661a79f638)}, {LL(0x8dba88a016d4a823), LL(0xc4c209deb5b499ff)}, {LL(0x9828eed8f98bd6ab), LL(0x97727f67b2c3832e)},
			{LL(0x1ad5946e90885cb2), LL(0xec18a55784136708)}, {LL(0x5f111a772b8d0199), LL(0x61a60807dea08862)}, {LL(0x0ced16c6b2ec2889), LL(0xf35e83d8c3ae648b)}, {LL(0x86a6c9f407e692df), LL(0x2ae11a78770b795f)},
			{LL(0xb53e75ba47eb380d), LL(0x2cac03a8bd3c3364)}, {LL(0xecb864ae35102d31), LL(0xd525abc3e3cb89a2)}, {LL(0x7ab1249149e4df70), LL(0x78ad3758532ac1da)}, {LL(0x5130b490aef22573), LL(0x5b5cebfbdc824334)},
			{LL(0xe6c2790bde8a111d), LL(0xbe548877a032df8d)}, {LL(0x68d2157b0565b38d), LL(0x3660d19f554c5f20)}, {LL(0xbe2234ee56d902f1), LL(0xc28f100e7f83d3c4)}, {LL(0xcf8f512b0e0fe77d), LL(0x540134f0ee16f2be)},
			{LL(0x1c429f0dc9fe4817), LL(0x7437053b044455ac)}, {LL(0x0a7a1da5eb9a3c2c), LL(0x6b7123b443f9562f)}, {LL(0x888767138299b635), LL(0x101bf9847529b209)}, {LL(0x15926678ef5f7e88), LL(0x53b076b907771ad1)},
			{LL(0x66f3bb9c801a9767), LL(0x0c9a3263576e9476)}, {LL(0xedde385fcfb82be1), LL(0x50779bd1628d3f2d)}, {LL(0x556b07d2c0173db5), LL(0x0ad72bb39d59de4d)}, {LL(0x4d722b9d670c6d64), LL(0x2f6beec0d8c61698)},
			{LL(0x3154046f779ea6b1), LL(0xcfe979f40bbbe5e6)}, {LL(0xc87e06b9add1f508), LL(0x497ca48eef077695)}, {LL(0x89e13be27831b0e5), LL(0x9549c996f46f0486)}, {LL(0xffbd09b58339471c), LL(0x1eba7d1664eba1d7)},
			{LL(0xcab2be989a42f96b), LL(0x80d8c4aa2e8bd948)}, {LL(0x70cb3934a27ee35c), LL(0x13dc14ec10d397f5)}, {LL(0x5056e861545a23a3), LL(0xde0edbe95dc4f5bb)}, {LL(0x8031c2975e90867a), LL(0xb2ceba14f75c4bfb)},
			{LL(0x3cdf4e583fda88e8), LL(0xb9e5ca3e495337e2)}, {LL(0xfbe6baf7eddc5fda), LL(0x4f31bd5e25303cae)}, {LL(0x4ed8cf4daa3767d7), LL(0x639dbef6980c0fca)}, {LL(0x5ddda2561c1e0dfa), LL(0xa80268231f2c27bf)},
			{LL(0x3469ebdce3d3b8a7), LL(0x1b3089aecb26ce10)}, {LL(0xfd71b194b4aa4b7f), LL(0xd71e1d32a5670e0a)}, {LL(0x909e4b5c2582e6e4), LL(0x35a73cf730b67adc)}, {LL(0x5a2cf5c4bfc01f8f), LL(0xb57ff85d1e3da394)},
			{LL(0x62a808deeeff8fa1), LL(0x5d11f22b16b5090f)}, {LL(0xee74dc8f02832152), LL(0x1c81cbe72247267f)}, {LL(0x58e04de5885313ec), LL(0x7cdb9879dfb10c49)}, {LL(0x163882a82264743b), LL(0x1f46268f47bd0383)},
			{LL(0x492998df09e975a2), LL(0x7ee02e88991d8be1)}, {LL(0x5b4aa9354568195f), LL(0x302dc84f9f7b151b)}, {LL(0xdc8a3c30b8268d50), LL(0x9f9ee2256936dacb)}, {LL(0x75f6d6873633fd4a), LL(0xc705e4b6d04ebc03)},
			{LL(0x9334af8ce8b9ec57), LL(0x79516cc1707c638e)}, {LL(0xa1ca4f33521c4055), LL(0xfa4e45033b0d9f3a)}, {LL(0xad2759f5e0f068dc), LL(0x0910c6dbf8a3fbb1)}, {LL(0x9fd9b94a5a55c4de), LL(0x8a0fef19b3d20705)},
			{LL(0x3b2e19ca9c049a9d), LL(0xa4985a404842b3c9)}, {LL(0xbb1fdb5dc2941ce7), LL(0x1656e054bf1ef832)}, {LL(0xfc17ed654e024daf), LL(0x524c2d202421b885)}, {LL(0xc1aeffcc8b70c397), LL(0x6efbd70cec3439e8)},
			{LL(0x81579e66a43880aa), LL(0x379c8a06761afd74)}, {LL(0xf0fafba3fcee6526), LL(0xa112aef8e78fdc0e)}, {LL(0x3a48453b66ac9c4d), LL(0x21ca6a52c9040546)}, {LL(0xb8b53f8d0faf1654), LL(0x5aa0b062ffd4e160)},
			{LL(0xe8e3d7ec5bf535f7), LL(0x84ae6b8ba21014db)}, {LL(0xd0672af60acaa5d9), LL(0x6cc061fdaa98be40)}, {LL(0xb9d3637cf5071084), LL(0xdff280707e9257ef)}, {LL(0x9609403f7cf4f241), LL(0xad889c9bb0e14878)},
			{LL(0xef12807ef82b2782), LL(0x99d3fbf5a30190f0)}, {LL(0x57a7bff3f78431d6), LL(0xc3734b975cd57190)}, {LL(0x6795e76d7ab291b7), LL(0x89c80271d62822f9)}, {LL(0xe299ca49b06f09db), LL(0xefdf483fe1e942f4)},
			{LL(0x45c48e19bb055d2b), LL(0x8dbead505ab3ef6a)}, {LL(0x2d169b62be60eea6), LL(0xbbde7ccf0fffb04a)}, {LL(0x3db912a9c5728e38), LL(0x3cb7fa2cc815816d)}, {LL(0xcc25b5fbc334edce), LL(0x18f764c6aedcebec)},
			{LL(0xf3501f7331d56f95), LL(0xede4fecea745c55c)}, {LL(0x63ce542f14578971), LL(0xd843c23997f3bf80)}, {LL(0x791bc04184dfd5c3), LL(0x345b676e13e0d888)}, {LL(0x4353857ae273498e), LL(0x15910d3cdae4ddce)},
			{LL(0x74908a76cc9bfb9a), LL(0x4257d4a451080a8c)}, {LL(0x7361dde46f45e9ef), LL(0x5f2a44da50198ea7)}, {LL(0xdb7b6ba21bf89f25), LL(0x82e3725b68275ee0)}, {LL(0x1fe87bdd04c542a4), LL(0x38c1550d448e4cfe)},
			{LL(0x25a03ee66269dee9), LL(0x190b3f5f8d8a49b8)}, {LL(0x5986111472fb153c), LL(0xf989a86b5ef7bac6)}, {LL(0xae8dbd252dcb626f), LL(0x45e696edb869e2e3)}, {LL(0x32fee0bfbaa5ac02), LL(0x831f29c24b71fcb4)},
			{LL(0x197f70be5db35601), LL(0xa0eef561c4d97e5a)}, {LL(0xfa80e6061774590a), LL(0xca638d4ca4768a21)}, {LL(0xd1017607f062a309), LL(0xe99251ef2bde08cf)}, {LL(0xea2f6fcd6c663994), LL(0x4d0a0baf639cbb06)},
			{LL(0x419f3d5bd5e045ed), LL(0xdc356d181b687213)}, {LL(0x0d8b4a3748442e59), LL(0x760cb3ca42e8d204)}, {LL(0x3032589e8d36a061), LL(0x4abb49e68afd5369)}, {LL(0xf84c5e2720e75569), LL(0x03c7ed6865fa25fc)},
			{LL(0x773a6ea601a0f129), LL(0x0ea1849211c213de)}, {LL(0x282b74d12a2df0b0), LL(0x6f078c95cf629bbc)}, {LL(0xf5c7141068a37b30), LL(0x75cb5ea22712f7f8)}, {LL(0x294d2820d085f660), LL(0xea55bc874e242d33)},
			{LL(0x1e8e272cfe6d4474), LL(0xbd93651fc5c8fa71)}, {LL(0x94c5f81e4b67fe22), LL(0x642cfcbf716de7a5)}, {LL(0xac4105041a586e0c), LL(0x8c42f6c979e54d3e)}, {LL(0xe7a425fa242217cd), LL(0x3b06b86521746902)},
			{LL(0x994eb2290323d07b), LL(0x12204f75338535a1)}, {LL(0x3f75aa88f2e1825b), LL(0xf5139a0809992eb0)}, {LL(0x8f7630812147a440), LL(0x0d6669fa74383622)}, {LL(0xdf20d8e0751d87e3), LL(0xd368b21329fcc399)},
			{LL(0x37c30f0c2ee8b214), LL(0x57c6d9988becd742)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x126331ea4c816cfd), LL(0x4ecde6c706669efa)}, {LL(0xb2cf2228e4352a78), LL(0x31d193d6bc2db74f)},
			{LL(0xcee90ddaf4a7e1ad), LL(0xd15304e26f504431)}, {LL(0x01665cf1faa806d0), LL(0x855230128146b68f)}, {LL(0x976f1cce865cf491), LL(0x28daac8931a7fef7)}, {LL(0x0b1c415411323afc), LL(0xee2313a6c2bfe0a0)},
			{LL(0x765c3257fb08f7f9), LL(0x8bf3b4809084a551)}, {LL(0x0e21aee7857f24ea), LL(0x3afae3fc0222cb56)}, {LL(0xa0ac13c2a8b44685), LL(0x7f1c7511ba4b29b5)}, {LL(0xe40ec12ae9191d7e), LL(0x77f0e85361be7050)},
			{LL(0x350fb72d197bbe77), LL(0x9e62b9bc4a60789f)}, {LL(0x1d24c3fc33564ec7), LL(0xf16535298502e323)}, {LL(0x2fda234389f3e2c5), LL(0x727a1cebce731f97)}, {LL(0x69b4498affcdb55d), LL(0xb332e18dd40ae9af)},
			{LL(0x0f47f2167fd7223a), LL(0xbfa8d3ee83647dd9)}, {LL(0x7c262ff21092cbd5), LL(0xe0829734d37df37e)}, {LL(0x7f8ccb22dda9c166), LL(0xac74c70293b7ea2c)}, {LL(0x3e13f6790849848b), LL(0x7041aa1a88df983f)},
			{LL(0x5e774686d1250749), LL(0xe4f438155fe63eed)}, {LL(0x6064b0ffd96c83c2), LL(0x94b5920fd739a6d2)}, {LL(0x045bb3426ee518c6), LL(0x518bc04841db9d79)}, {LL(0x8a4bdf32b50aba56), LL(0xd9bf99a0b4a51dd4)},
			{LL(0x11c9d53a81ba664e), LL(0x023bb6f146ac87a8)}, {LL(0xe9858b1da15d3327), LL(0x01fc5b992356a254)}, {LL(0xa260abe39f274ae6), LL(0xb6b815357bc78668)}, {LL(0xa591fc713cf95893), LL(0xabc5854b7ad60243)},
			{LL(0xcbd4e26960eaffbb), LL(0x058af4b8afcd6fc7)}, {LL(0x18192c4fa71b50d1), LL(0x25bcc573459fc8d5)}, {LL(0x02ccb82137930c63), LL(0xc9a46024c18cafdd)}, {LL(0x4be520fe3e7a79c1), LL(0xb7444eac5891243c)},
			{LL(0xf2364382cb7d6945), LL(0x68b6cedc260373d3)}, {LL(0x9ae456f9ce18dac8), LL(0x5ed61f43734f2cf3)}, {LL(0x053defb3944d1e16), LL(0xd4d9f05ac09d2bf6)}, {LL(0xb0039a09d3a6261b), LL(0xf875f3f27da11892)},
			{LL(0xa63b18a1f1c25220), LL(0xe733d57d3a1c1b11)}, {LL(0x6deffac89128ad9b), LL(0xe2b921c595d174d6)}, {LL(0x8cdcd451ec7caef3), LL(0x419039cc34f22f70)}, {LL(0xe055726887fc05b8), LL(0x267b281b2065ed29)},
			{LL(0xa75d44500b6a54f0), LL(0x6261e56fbb5aad9e)}, {LL(0x21fb8da40c8cc62f), LL(0x4880ff17cc51d4c1)}, {LL(0xd2ab92d73d59a9ba), LL(0xa56401d96b14119d)}, {LL(0x08b6a584dc09304f), LL(0xa2d543908275f9f2)},
			{LL(0xb694916a8ad032be), LL(0x605a539efdf62a36)}, {LL(0x6102ec0e23c48512), LL(0x11e7a21d567f105d)}, {LL(0xa4f7a080c6515e43), LL(0x2e97b559fb90b4cc)}, {LL(0xd55ac5459e87bbcf), LL(0xb81991a76a0595b6)},
			{LL(0x839b264793ab8cc9), LL(0xfe38ea22b79652a9)}, {LL(0x5cbbfea7e6b60b2a), LL(0x2d5058319e6a9130)}, {LL(0x4a837c0fc4d27f11), LL(0x32167ebed9d792b3)}, {LL(0x2ebc7fb2735be415), LL(0xf7282cf94f35a918)},
			{LL(0xf19ca752064663f6), LL(0x24409eea66c96a81)}, {LL(0x1bb3c89f6a205a62), LL(0x694a95450555d187)}, {LL(0xfedb5544799141cc), LL(0x9be84d04e5ad1758)}, {LL(0xf4a148e1920b7de0), LL(0xf0996eb0a6544177)},
			{LL(0x71ad65c558d6e58c), LL(0x968e24fe9195217a)}, {LL(0x8e106c70dbefa290), LL(0x883459e8f57e80ad)}, {LL(0xc0c8a33d71d8c547), LL(0xeba9e71e6d728f67)}, {LL(0x209dd155f624c0ff), LL(0xcdd2cf054d17624e)},
			{LL(0xc493107f1f3ddd81), LL(0xba2227562ca9121e)}, {LL(0x4235d98b18db4f5e), LL(0x90c33d2e5ba26b41)}, {LL(0x44a2d2e841ad5bfb), LL(0x08ec9d42dbf559e5)}, {LL(0xabb05296b9867c79), LL(0x913f66b778f4c915)},
			{LL(0xa306f712658f4c36), LL(0x33ea2527fa8130e7)}, {LL(0xc739f4afd206d732), LL(0xf6d477606c630b4c)}, {LL(0x9ebfe5bba0fdc20e), LL(0x0f5ddf0b3294b18a)}, {LL(0x2ae7ccf01dbefcd3), LL(0xa6a3ecb10eee3461)},
			{LL(0xde4684118fb58133), LL(0x563a8201a8ba7516)}, {LL(0xf70bac315f307753), LL(0xbc6f3e86e69e5825)}, {LL(0x9252f37d1211ea87), LL(0xfc035cd3f13ad501)}, {LL(0xbf44681fac710421), LL(0x47dd201cfec5654b)},
			{LL(0x65595f4c4d219dd4), LL(0x406c625517a48d24)}, {LL(0x4fbe93bc509f6107), LL(0xe6cf8ee4194ab945)}, {LL(0x470836388c965148), LL(0x441acd749b3f40b7)}, {LL(0xb458294bbd433edd), LL(0xa9fe33ba3c7a85eb)},
			{LL(0xb7f2cd9b7078346e), LL(0xe508638c7cb09cb9)}, {LL(0x36a553fdd440b4c4), LL(0xd294e98a0aaa61cd)}, {LL(0x14f43a8915f77858), LL(0xd6e246ab8631ac5e)}, {LL(0x22516974c1b7cc9c), LL(0x0476af218c9bcd93)},
			{LL(0x7d407303ea3acd05), LL(0x65d0a726523b45f1)}, {LL(0x82fd7ab669038a19), LL(0x7b6ada3036d0e426)}, {LL(0xc9185a485779f3d8), LL(0xcc2e949c6e41c01a)}, {LL(0xddec60c1428e8b80), LL(0x1accd237e8706c44)},
			{LL(0x10af89cb7b12609e), LL(0x876986e3c7ea3127)}, {LL(0xeb49333c96ce3f44), LL(0xc8583bbde2da0d89)}, {LL(0xa81ab64674bd76ca), LL(0xddc93681383ed047)}, {LL(0x40f961aa2f48433d), LL(0x59675d0a9a2ec49c)},
			{LL(0x3884fd1a513f902e), LL(0xe86e0a760888aa9b)}, {LL(0x484fc42ef3417372), LL(0xfbb21e9a185b3d6e)}, {LL(0xbd88d03e9be20842), LL(0x8e7940383f49ca96)}, {LL(0x540d5b233abf3b65), LL(0x8f851ba11c1f68c2)}
		}, {
			{LL(0x9cd3c3c2d42d19d4), LL(0x8fbed12c18a95de1)}, {LL(0x04a6349440cb7b40), LL(0xb560256bdb14b350)}, {LL(0x84817b3c97d2c097), LL(0xb73d0f9587d171c2)}, {LL(0xc11d84d94db6694d), LL(0xbf8aa7eb3443ffcf)},
			{LL(0x1cf48c6a0334a203), LL(0x8de3fbd2446c9f73)}, {LL(0xb80c947cd1713cd1), LL(0xdb581f99d41d3f74)}, {LL(0xeed6ace3f87908f8), LL(0x4584483647d0dcc6)}, {LL(0x4454f2c0ca26c7ca), LL(0xb4af3014f597d219)},
			{LL(0x199ab5db53bdb753), LL(0x849b46d3d97d7037)}, {LL(0x3edef50a66272066), LL(0xd755e3d8dfc6f69e)}, {LL(0x2e03251fa58d0fa5), LL(0x461677b735967f1d)}, {LL(0x01c80d2510426e10), LL(0xbc18986a46055c14)},
			{LL(0x76a35bb56c9f6a6c), LL(0x7f5abc71846d3277)}, {LL(0x094765ce90179890), LL(0x15d8d2bc332df9b4)}, {LL(0xdc2105965ec0a55e), LL(0x8e71c453362a3ca8)}, {LL(0xceafcfc9bdee56bd), LL(0xa402a3e850700d03)},
			{LL(0x81ef428dc75bd5c7), LL(0xbe45b2941ac09e86)}, {LL(0x02531a4a2084dc20), LL(0xbb30f3d48c0ab828)}, {LL(0x3bb0ccbb36ae3536), LL(0xde2d5ed942d719da)}, {LL(0x36519de1e672d6e6), LL(0x7e95a90eaaee533e)},
			{LL(0x1346c77af36c9df3), LL(0x966bffd1205f6dbf)}, {LL(0xe659c408782cfe78), LL(0xec4402e032f87966)}, {LL(0x06f52ede604fa760), LL(0x0e50d6bf571e0b78)}, {LL(0x7056756b0cd0cd0c), LL(0x710a6aced373390f)},
			{LL(0x73cd62043c167f3c), LL(0x76220170197cdd33)}, {LL(0x6b9fdafa7fe9a67f), LL(0x4ea1dfc98604f110)}, {LL(0x0c295c7fc09e8dc0), LL(0x1ca06fbdae3c16f0)}, {LL(0x47cfe5affae075fa), LL(0xb3875baa3f983625)},
			{LL(0x2aa5118be54674e5), LL(0xf37652dcee82cc4d)}, {LL(0x72056f212c54112c), LL(0xca3a991a5f798127)}, {LL(0x56da389f29083429), LL(0x9edc57af93cde3b2)}, {LL(0xd5666058ced73dce), LL(0x9ba916ef0507c51c)},
			{LL(0x776b56907cdd047c), LL(0xc342241bc2686e63)}, {LL(0x8dc61ef207c55807), LL(0xa2e5dd29b4fc8876)}, {LL(0x9a26ed1cb462beb4), LL(0x81ee07934fb75699)}, {LL(0xbd62adcd81f82981), LL(0xd220a298490cd030)},
			{LL(0xa3c53beda24857a2), LL(0xe4f3aa9e816af76b)}, {LL(0x0fb24b10f0583ff0), LL(0x1b8804036433f2cc)}, {LL(0x333fa450b6fbc3b6), LL(0x77ed140f37ffbc7a)}, {LL(0x1852b8fe43ffd943), LL(0x3883deb99f782c23)},
			{LL(0x8b33302c678aff67), LL(0xacb50b96e3e2830e)}, {LL(0x51e71b645905fd59), LL(0x2c94197a82d6b4de)}, {LL(0x7e2c335eecca9cec), LL(0xd69af6a7f14597d7)}, {LL(0x30a4b33f863d7186), LL(0x70c57fb1fdf05846)},
			{LL(0x9e80d988f4a9c5f4), LL(0x348e22f894a3e5c9)}, {LL(0x379990c4f630b8f6), LL(0xc28d3164eceb0f2a)}, {LL(0x75384cda5c59d85c), LL(0x7872d7cf4e62d64b)}, {LL(0xa05e2c82928ee592), LL(0xe3dbc1204b651357)},
			{LL(0xebb89552a8f01da8), LL(0x4cfcf537dac13382)}, {LL(0x608ba57ecf7ae2cf), LL(0xe049fea13923b08c)}, {LL(0x6ef1e34b2f60b32f), LL(0x47d962c81b151e54)}, {LL(0x5af364e0e996b9e9), LL(0x827c38123df1f542)},
			{LL(0x945cab295478ef54), LL(0x267e9bfa6d81f841)}, {LL(0x642d91ea8fb1998f), LL(0x5529dbcae23703dc)}, {LL(0x42a1dc1eaa6960aa), LL(0xbaffe6aba289d961)}, {LL(0x936188d224752624), LL(0x9436d52f7c9aaf2d)},
			{LL(0xb2d0e6dd71a01671), LL(0xc9a8a69b2d3f22fc)}, {LL(0x222a796065138265), LL(0x5ab6180a9baa69ed)}, {LL(0x5dce471b999b7099), LL(0x303476c72ceaa22e)}, {LL(0x316cbe1a967f1f96), LL(0xccdde7dbbbf50452)},
			{LL(0x791110a59cc7559c), LL(0x64d2b872e05ec0bb)}, {LL(0xc85ae117dda1f1dd), LL(0xaa527557076e067b)}, {LL(0x4d13970e5a315f5a), LL(0xa177e2a8c6ba2bad)}, {LL(0x088f68eb8055f680), LL(0xa9c04ad67528a5a0)},
			{LL(0xef1ea1c6e83b66e8), LL(0xf99cd05c01d580d2)}, {LL(0x056e39b150891550), LL(0x0978bd019d11ef44)}, {LL(0x88a82743574c4d57), LL(0xab9d602829ed6732)}, {LL(0x9f48d4ade4ebabe4), LL(0x8896ba92d2a6b9dd)},
			{LL(0xd88731021e0bde1e), LL(0x3b11e138ed3e8ff8)}, {LL(0x99bdfa7384a40c84), LL(0x86c66c2d85b8b2a5)}, {LL(0x25175a9b151e4b15), LL(0xe8fe56df8ab13e81)}, {LL(0xb14bf1b24166a441), LL(0xce80cd25e730c6c0)},
			{LL(0x55412ff019ce8619), LL(0x99f43c1159c2078e)}, {LL(0x3a78c19e26ec5b26), LL(0x6235c6b304d245ce)}, {LL(0x0adc72a1a0d12aa0), LL(0x12f0b902f9221d88)}, {LL(0xfd906b990b15950b), LL(0xd3efb7e7678fb179)},
			{LL(0xab4a5306221da122), LL(0x4d33e048f44252cb)}, {LL(0xccfcd5839d6a8a9d), LL(0x1f32503cdc7ab52b)}, {LL(0x2b6d1caef5041af5), LL(0x4f6ecab6a8879059)}, {LL(0x459cffe5da64a9da), LL(0x08b7a87eb3928e0d)},
			{LL(0x8e5d099d3703ea37), LL(0xa5cdb6977ef36c4a)}, {LL(0x871a6c53a71472a7), LL(0xb015642b4dde95fe)}, {LL(0xc992ec32cde39fcd), LL(0x164aed3d416b5a6f)}, {LL(0x1a01a2b4637b0563), LL(0x83b32d6d1372940b)},
			{LL(0x7b420aefbc4389bc), LL(0xdfe24ba66c547893)}, {LL(0xa7630f79e2832ce2), LL(0x51938ff55a7e443b)}, {LL(0x35ca8a8ed6b464d6), LL(0x79bdc2b060e1b702)}, {LL(0x9875f75694e66294), LL(0x3adef447c3bdeeb1)},
			{LL(0x9beee039a420d0a4), LL(0x3df69ff909b20a8d)}, {LL(0xe9eb8f188874c188), LL(0xf7cc06e356cb8baa)}, {LL(0xafec679262d6da62), LL(0xf853c5232f56e19b)}, {LL(0xdb1c266d2ecd6c2e), LL(0x3c398a8627316bc4)},
			{LL(0xed4dbb8cc8bfbac8), LL(0x42ac23888ddf38fa)}, {LL(0xe0acead618635918), LL(0xe214d45f65e6721e)}, {LL(0x382bdbd406688706), LL(0xd905356788d8fde6)}, {LL(0x39e3d6f1162ae916), LL(0x651dad0dcedda1f2)},
			{LL(0x1d3c814f1376cc13), LL(0x31fb63b80269c367)}, {LL(0xa4f81816d2459ed2), LL(0x56bbe44b9071a007)}, {LL(0xf8fe52285b9c805b), LL(0xda970ae6fa9e5e3d)}, {LL(0x6310b211ffbc50ff), LL(0xe761951ff32c54b0)},
			{LL(0xf684141dbb86d1bb), LL(0x7d07968fd8a8f0e5)}, {LL(0xa5301533c207f0c2), LL(0xeaa37c21d674fc13)}, {LL(0x5f9d5d51b91facb9), LL(0x8b048513a0e01a06)}, {LL(0x67b68685bf772bbf), LL(0x5201b0742838e7e0)},
			{LL(0x62d8bf34effe3eef), LL(0x5b790d75b52908a4)}, {LL(0x7db72431dc0c2edc), LL(0xd1b29d193b4a73eb)}, {LL(0xfc5866bc1b57fb1b), LL(0x6ff72f8d218aed6d)}, {LL(0x8f9504b827418427), LL(0x19d52efd38f6305e)},
			{LL(0xdad42b483e8f023e), LL(0x802112ec613437d0)}, {LL(0x83bc58c7e7df09e7), LL(0x0575414096ca26ae)}, {LL(0x0b147f84b09344b0), LL(0xaee82168bf27419c)}, {LL(0x527c0c0b69c34f69), LL(0x2bbc72c448d950e2)},
			{LL(0xb7bedf6c21290321), LL(0xc0d01b9ab02ecdb8)}, {LL(0x6ca2f9010fe46f0f), LL(0xfce9911c971fa67c)}, {LL(0xba5f8e36f1f5e0f1), LL(0x6068ec4d5817875c)}, {LL(0x49b5a39a1afa241a), LL(0x1417c7c31dae98fd)},
			{LL(0xc5bbb04d0d7d120d), LL(0x0aea8280ef574c9f)}, {LL(0x32f7a975a6b9ada6), LL(0xcbf58c6571fae06e)}, {LL(0xa919494c02997d02), LL(0xf603139c7848eae3)}, {LL(0x4e8880616af7ed6a), LL(0xa65f89160cb5cf91)},
			{LL(0xe164e7f308213708), LL(0x5e0c4c3523e32e0a)}, {LL(0x74f041ff4c1bb64c), LL(0xc46a4fa508678a5f)}, {LL(0x502f164149479349), LL(0x908c8110c4d3e8ca)}, {LL(0xbcaaa0e891ba4791), LL(0x6e383af20f098c24)},
			{LL(0xbb978313e1b78ee1), LL(0xdc7074271e12db48)}, {LL(0xf51f03728b40638b), LL(0x7a2ffd3112a714d9)}, {LL(0x90fa9fbd14b39414), LL(0x931ebe91b6954b11)}, {LL(0x2d983270954bbd95), LL(0x413e1c09ff999b21)},
			{LL(0xea709877b8b273b8), LL(0xf0e46d5d9cc46f96)}, {LL(0xd00859e99e5e289e), LL(0x92d1abee98162a58)}, {LL(0xf3ea2daceb0fc4eb), LL(0x747f2b8e45b91fa1)}, {LL(0xdfba12f96e06176e), LL(0x8959afedfc25d894)},
			{LL(0x10ddd015c3aa2fc3), LL(0x9143946fea508983)}, {LL(0xe823823d9836af98), LL(0x4bd49e8910ced7be)}, {LL(0x073d23fb700dc970), LL(0xb2484ed5111b576c)}, {LL(0xae246ab77294b472), LL(0x444b5d496953bd8f)},
			{LL(0x9132929804f1fa04), LL(0x2f0626fbf0901705)}, {LL(0xcbc1f678ed6743ed), LL(0xad7a1ee9cd61e247)}, {LL(0xa6ab025cf2c142f2), LL(0xed8b179f1c7b182f)}, {LL(0x89602a66470e2347), LL(0x1785f8426fe83b26)},
			{LL(0x2079632a45975e45), LL(0xe186ebde17a0d1c5)}, {LL(0x413acb719aafd29a), LL(0xbdd78d1568863d5d)}, {LL(0x293e06e4d580c6d5), LL(0xf45e3962248d2871)}, {LL(0x5968738fd9500bd9), LL(0x855453acf7fe117e)},
			{LL(0xcd34d8a68d28e48d), LL(0xa32ac8569a7fe93f)}, {LL(0xfe0b7cf63bd3273b), LL(0xd4c7dc59ad805545)}, {LL(0x6a57d7df6fabc86f), LL(0xf2b947a3c001ad04)}, {LL(0xdde908b34e82cb4e), LL(0x32695c39702f60bc)},
			{LL(0x92a985f734374834), LL(0x282e4d453a9ff339)}, {LL(0x960fb16374fc3374), LL(0x9d4e682ee18b4069)}, {LL(0x65e59ccf9ff3f79f), LL(0xe93143a0a4325fc8)}, {LL(0xc28693b67d70db7d), LL(0xb8a2cc55fe4c1bf3)},
			{LL(0xb318ebf861e27861), LL(0x75b03ef16b3a7ee8)}, {LL(0xb676d249316b6d31), LL(0x7cc883f0f62b91ac)}, {LL(0x548922d5098ce809), LL(0x25eca47b1fc75b9a)}, {LL(0xa8d1446912db1312), LL(0x4a1b8bf63e4db6f7)},
			{LL(0x97c7bc4664be5d64), LL(0x2156f044a78e1c7d)}, {LL(0x80274fa8d719bbd7), LL(0x025d2afe5cc5c292)}, {LL(0x15b3e9a493233a93), LL(0x983b296e774166c7)}, {LL(0x4be6b9d03a7ef83a), LL(0xaf27341791a420d5)},
			{LL(0x1628fecba3e588a3), LL(0x9f1342d0bd4e82fb)}, {LL(0xcf67c2ecadac38ad), LL(0x181a3b8216755117)}, {LL(0x719e784e1c92a31c), LL(0xcd12f2a49576651b)}, {LL(0xde721fdc7e44797e), LL(0x35413787ba208480)},
			{LL(0x3f16f82f76654e76), LL(0x6b4d7bb299c3aa8a)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x1f6f9b0533f21033), LL(0x8acb906c8e637b4f)}, {LL(0x827455e2f79d67f7), LL(0xb96dd92ad0cf7aba)},
			{LL(0xe337fdb928a5eb28), LL(0xe53cbfe1afe99622)}, {LL(0x1ea7962023b07e23), LL(0x36d30806c866275b)}, {LL(0xa20d36c8b20a39b2), LL(0x58eb32f4c76fab7f)}, {LL(0xd25b43a3bedaf4be), LL(0x29e1583a141c9270)},
			{LL(0xadbf7dd842520642), LL(0x436336f7a35c59b3)}, {LL(0xb425c80311efb111), LL(0xc7f870247a212984)}, {LL(0x9d1bcee7c46f77c4), LL(0x33a649465eac01f5)}, {LL(0x69ccc0b05f6d7a5f), LL(0xf5912c1d0a0e4938)},
			{LL(0x039b176f30c6b230), LL(0x07286bbeca0fe43c)}, {LL(0xb5edc52601addf01), LL(0x7be0e84e3c247590)}, {LL(0xec85b6a9d8fdd4d8), LL(0xfeb4bbe2cbda64ee)}, {LL(0x24df57be055c2505), LL(0x54e6ceb5ccb46295)},
			{LL(0xaa825e23325fcf32), LL(0xf12b7822b2470edf)}, {LL(0x6143a85bdf388cdf), LL(0x5c5166cb7f26ec98)}, {LL(0x4369d13bba2b0eba), LL(0x06e77ec1e48c8575)}, {LL(0xd1c054cc8e1c468e), LL(0x2ec93384de13764c)},
			{LL(0x1bc9af9173396b73), LL(0x3fabb5075577c81f)}, {LL(0xca09fb5dfd252dfd), LL(0x116286838b64be53)}, {LL(0x78d91d808c853b8c), LL(0xd8ca2018a65b9caf)}, {LL(0x17e0f3eeb3a7e6b3), LL(0x230bdabafb4bdeef)},
			{LL(0x3d45e26556e19256), LL(0xd07d886615c912a2)}, {LL(0xffc371d32b91492b), LL(0x68df4433eb850951)}, {LL(0xa19621a782cc8b82), LL(0x5fc3594a0d604f43)}, {LL(0xfb6545476b5a326b), LL(0xddbf61583091ba01)},
			{LL(0x854976198790ae87), LL(0x0b2597ffc1d42dd6)}, {LL(0xd3934e86ae989aae), LL(0x95f9c0505219ce64)}, {LL(0x3c8def4046a3fc46), LL(0x6c65100c53cc4eb6)}, {LL(0x5e555074a95dc2a9), LL(0x371c1d79e6e54612)},
			{LL(0x0e7a4635e01a51e0), LL(0xa7909c692236aed8)}, {LL(0x340287abc6f60ac6), LL(0xc5a55ada26e4eb16)}, {LL(0x667e8ba0af3545af), LL(0xee19281e6e3dbbf4)}, {LL(0xbef9baa2b13e9bb1), LL(0xd508c9268303340c)},
			{LL(0xd94f3c270e49b00e), LL(0x87097952ab3bd3ec)}, {LL(0x5c064a3e89d91e89), LL(0x8c2ceead6aeffe3a)}, {LL(0x53b4012e79812179), LL(0x97a4eaae0edc0cf6)}, {LL(0x1115dd30d3e841d3), LL(0x2d5b0c05ac55d597)},
			{LL(0xc7e8aa072df9ce2d), LL(0xb1da7154635df4b7)}, {LL(0x58a07eaac91265c9), LL(0x394ccbc6b1fb4d6a)}, {LL(0x487daebf0ab84a0a), LL(0xa80f5fa95babc4e9)}, {LL(0xf0713ac3dbc976db), LL(0x735740308fb6fb9d)},
			{LL(0xfaad48627b185c7b), LL(0x61a7f9327694e615)}, {LL(0xd4ae6d7dde9553de), LL(0x27b18e8543029908)}, {LL(0xe5c2d36748ea4c48), LL(0xeb6c695ef8f79d5a)}, {LL(0x128eca5fe32ef3e3), LL(0x2a7367bb665a31ab)},
			{LL(0xf9365f0d4bdeee4b), LL(0x668f928cbc9b0229)}, {LL(0x274440d1359a9735), LL(0x53cea50b06bb86a9)}, {LL(0x40f2c6548aedbc8a), LL(0x01cf157f2e836149)}, {LL(0xf2222089fb4daafb), LL(0xc867b3e403bc43b5)},
			{LL(0x2c503f558509d385), LL(0xfd268463b99cc735)}, {LL(0xf1b937e6cb8b18cb), LL(0xcf4fd85ac9b3a789)}, {LL(0x86d26176b7561cb7), LL(0x0c0dfc410bdbc9ea)}, {LL(0x4a2eb4f52a3c962a), LL(0x133fac7dd7a17cc1)},
			{LL(0xf74c1938abc4bfab), LL(0xc11f0ee59eadacf1)}, {LL(0x6f39ee6e3f22dd3f), LL(0xfbc1faa25d104240)}, {LL(0x571235ba394a5a39), LL(0x22c4cfc5d5c8bfa6)}, {LL(0x4607e88aeaa21bea), LL(0x0f9fc3c0799d6a31)},
			{LL(0x2fcb283ab5cf61b5), LL(0xfa0eefdd73932309)}, {LL(0xb083fc975124ca51), LL(0x7298554fa1359ad4)}, {LL(0xf4d70e579b020d9b), LL(0xc637655b54a248cd)}, {LL(0x4f408d447ab5837a), LL(0x1a47117c4ab09385)},
			{LL(0xbf31b787a17cf5a1), LL(0x6910514cc5066818)}, {LL(0x0de1515ad0dce3d0), LL(0xa0b8f7d7e8394ae4)}, {LL(0x4cdb9a2b4a73314a), LL(0x1d6f7ac280bf77b9)}, {LL(0x8afb3d0977c89177), LL(0x10ad93fca5e7df1a)},
			{LL(0xc0d589fc5df4075d), LL(0x03923f817246a3db)}, {LL(0x6804cd954f2f144f), LL(0x4989b4774c0b152c)}, {LL(0xc473bd681d3f7c1d), LL(0xb6f21aeaa952108b)}, {LL(0x147be48183615483), LL(0x2423b10431443ad3)},
			{LL(0xac7770fd52106852), LL(0xff7bae9de55905a7)}, {LL(0x268c4df425d8f925), LL(0xefd63d6140bedabd)}, {LL(0xd6fd7737fe118ffe), LL(0x9c817d51cf082120)}, {LL(0xc620a7223dbba03d), LL(0x0dc2e93e2558a8a3)},
			{LL(0xe40ade4258a82258), LL(0x5774f134bef2c14e)}, {LL(0x21b16e0f55d53055), LL(0x5d9e73b451a58dd1)}, {LL(0x5b3b69c5f9d4d7f9), LL(0x3e64a0787bf4a956)}, {LL(0x7a8a07caac01e7ac), LL(0x63fad3cc2a512487)},
			{LL(0x7fe43e7bfc88f2fc), LL(0x6a826ecdb740cbc3)}, {LL(0xe791c92d686e9068), LL(0x505c9a8a74fd2572)}, {LL(0xb9c49959c13352c1), LL(0x674087f392186360)}, {LL(0xe2fff09c38e78538), LL(0x5924278be9ecca36)},
			{LL(0x23e274457551ec75), LL(0xe6ae8060ddaf35f9)}, {LL(0xc34e9e936d32b56d), LL(0x04ba543fb84947e7)}, {LL(0x6d6af4241fa6011f), LL(0x40f10976d11afa68)}, {LL(0x8c0e13d717873617), LL(0x1efd4543f2f9d462)},
			{LL(0x9594a60c443a8144), LL(0x9a6603902b84a455)}, {LL(0x7c7f2914cc4e40cc), LL(0x6daa05737d4f2fff)}, {LL(0x28f60bc1c5c2a8c5), LL(0x4846a10862887465)}, {LL(0xd7357a12ee53e1ee), LL(0x2099e53b890d7d34)}
		}, {
			{LL(0x09ad9bfc7c7150fe), LL(0x1b53683f3f385efc)}, {LL(0xe9d1e2eef4d89f6d), LL(0xf8bca3dada3c90ee)}, {LL(0x3a0e92dd01e49453), LL(0x4e5d24a6a6b0b8dd)}, {LL(0xf0f491115314b8ab), LL(0xd35f7d9595c51811)},
			{LL(0xda72ebcf894d5bc0), LL(0xadb2ef4343b476cf)}, {LL(0xa43b656e24a6bd7d), LL(0x2f469afafa27c46e)}, {LL(0x722fc03167ea51af), LL(0x9680e29d9db30d31)}, {LL(0x615fda166fc67b72), LL(0xa32d01e4e47a8416)},
			{LL(0x9806d0fb40a39327), LL(0x6b21144e4e87c2fb)}, {LL(0x0bbc86c45f2e87f9), LL(0x1d450e31318934c4)}, {LL(0x297e88fa09c8be8e), LL(0x7bf0c7dfdf7931fa)}, {LL(0xaba5d9da3d36578a), LL(0x3e2f58d7d70f24da)},
			{LL(0x9253b923ef439e3c), LL(0x756f297878b7c323)}, {LL(0xbac4dec51645aa50), LL(0x0d94dda0a077c7c5)}, {LL(0x8123a304e76fb4e1), LL(0x40c2ca01017e4a04)}, {LL(0x3668dc4dcbe52341), LL(0x5a29b3828290074d)},
			{LL(0x787aa9e9c80a5cb4), LL(0x88cedfabab830ce9)}, {LL(0x958971777a6caed7), LL(0x7c5eb06d6d1e4877)}, {LL(0x49c8bdf096c04f1e), LL(0xdbd6f53c3cba80f0)}, {LL(0x1add81db745d7a23), LL(0x2efe8b4646f1d7db)},
			{LL(0x1ceea69311bcc02a), LL(0x24c4215454e16993)}, {LL(0x634ec72e4c99ac75), LL(0xa53b67eaeacbee2e)}, {LL(0x7c5893998eb431ba), LL(0x84e213b7b722d899)}, {LL(0xee0b2aba61f7af86), LL(0xf18d3acfcf951bba)},
			{LL(0xd027821726ad56db), LL(0xb3fcd27575847717)}, {LL(0xe3848b365b389276), LL(0xe6f29eecec0c9136)}, {LL(0xf8b0e5f1dfab62b7), LL(0xcb0726adad4473f1)}, {LL(0x5f7372bb289c822f), LL(0xe15ce95e5e6be8bb)},
			{LL(0xc0af6a14fd1021e3), LL(0x834c64050545a114)}, {LL(0x7b825bcd1b9b0151), LL(0x8dd38aa2a28b53cd)}, {LL(0xd614a55f434cecd2), LL(0xb9c678676794c95f)}, {LL(0x3be77dc1f12a1eb1), LL(0x4d5617a1a1098dc1)},
			{LL(0x39f660f9d275c9b6), LL(0x4b4071afafb8e7f9)}, {LL(0x80ca4c1817a13e03), LL(0x43c9f90606c77f18)}, {LL(0x75f50865f2c56144), LL(0x9fb17b88881a8665)}, {LL(0xe64f5e5aed48759a), LL(0xe9d561f7f714705a)},
			{LL(0xa9b4c4e21e69808d), LL(0x38393ed9d9be4ee2)}, {LL(0xc69c4d5c98f19bea), LL(0x8976ce1717551f5c)}, {LL(0x58a9baefbdb3b2c4), LL(0xe86d704b4bc263ef)}, {LL(0x33a309217d95c4ad), LL(0x550e4c999988e621)},
			{LL(0xfc92df8199150fb9), LL(0xc72beab1b1e5a781)}, {LL(0x01e9ef1cf0ce8ae2), LL(0x030b330707b9351c)}, {LL(0x8332be3cc43063e6), LL(0x46d4ac0f0fcf203c)}, {LL(0x66851242fae94b99), LL(0xaa1c98f1f1d30f42)},
			{LL(0x9c24ea8b061dfe29), LL(0x670dd8525226168b)}, {LL(0xb1785801496b2da9), LL(0x10d1d39191fef301)}, {LL(0xac7f118ea8196761), LL(0x371ec1c2c2a6af8e)}, {LL(0x97986c4f593379d0), LL(0x7a48d66363af224f)},
			{LL(0x305bfb05ae049948), LL(0x501319909080b905)}, {LL(0xccc92484371196f1), LL(0x9738f32121651e84)}, {LL(0xa1f0b00292d65a91), LL(0x206165e1e13f2502)}, {LL(0x2ea440ae9ce78e65), LL(0x72c15ecacad0baae)},
			{LL(0x18cc9ce35702ad24), LL(0x28e8ed484840bde3)}, {LL(0x2518c66ac3c9099c), LL(0x6f8450fbfb598e6a)}, {LL(0x1d07498fe1724ac8), LL(0x27cf125353585c8f)}, {LL(0xcf31d6a0e480cb14), LL(0x9225a628286d41a0)},
			{LL(0x20d3130675b9ee70), LL(0x60a3afe0e0416f06)}, {LL(0xd1ce6d0bd663dc39), LL(0xb0f7e172723d420b)}, {LL(0xf9590aed2f65e855), LL(0xc80c15aaaafd46ed)}, {LL(0xcd20cb98c7df1c13), LL(0x9433c02626dc2b98)},
			{LL(0x54cff47f77b205d6), LL(0xfc19e76f6fe2dc7f)}, {LL(0x4a304fd4455112fb), LL(0xdecba03535b2dfd4)}, {LL(0xdb9b04d37983d122), LL(0xaeb9dc44440d43d3)}, {LL(0x1161071f2b73fdda), LL(0x33bb85777778e31f)},
			{LL(0xd98a19eb5adc0625), LL(0xa8afba4a4abc29eb)}, {LL(0x42743b34c9eec8e7), LL(0xc693fb0d0d33b434)}, {LL(0xc2be772cde4ff6e4), LL(0x855a020b0bf4cb2c)}, {LL(0x378133513b2ba9a3), LL(0x5922808585293251)},
			{LL(0x68f241ea13b72b8c), LL(0xb87e69dbdb42daea)}, {LL(0x4bd9a0c8b59f9819), LL(0xddc09332320beac8)}, {LL(0x0633274865e1ba09), LL(0x0a3aaa121210be48)}, {LL(0x1effbbab32e3172d), LL(0x22d2475a5a5003ab)},
			{LL(0xe8380df20416158f), LL(0xfbb790dddd85a5f2)}, {LL(0xe26d642aabf61894), LL(0xe5f9adebebb5a42a)}, {LL(0x84e87668511f530d), LL(0x4fe5351a1a66ab68)}, {LL(0x6ec166a276569185), LL(0xb244c3c9c95264a2)},
			{LL(0xb8d5c3fd351a7d57), LL(0x0b82bbaeaec6adfd)}, {LL(0xa3e1ad3ab1898d96), LL(0x267703efef8e4f3a)}, {LL(0x6b0ab3cec0267669), LL(0xbd633cd2d24a85ce)}, {LL(0xcafa03cc52f02cf8), LL(0x9d0259333375a0cc)},
			{LL(0xbee6e4b550fbc75e), LL(0x01b811bcbcd613b5)}, {LL(0x04223a7046be6d0e), LL(0x0c2ccc1c1ca1d470)}, {LL(0xe195960e78674571), LL(0xe0e4f8e2e2bdfb0e)}, {LL(0xa62a785607f96a7a), LL(0x2950fcf4f496ae56)},
			{LL(0xc14685080ddeab01), LL(0x8047570202fc9408)}, {LL(0x4065260ceab11fe0), LL(0xc0859d030382de0c)}, {LL(0x24f129763307837e), LL(0x6c8f63fcfce0bb76)}, {LL(0xe07c791288a9cf93), LL(0xe3efcbe5e504ce12)},
			{LL(0xde50d1bfcff336ce), LL(0xa19e235f5f15a2bf)}, {LL(0xa5d28a72d468379f), LL(0x2c4da9fdfd9ef172)}, {LL(0x51042113c1c2e23a), LL(0xf33e187474fa3d13)}, {LL(0x56dee94754edd2d1), LL(0xfa0f81616153b647)},
			{LL(0x4c03689c20b0a8f2), LL(0xd4f10a2727a2619c)}, {LL(0x1f1654b7c22d9dcf), LL(0x21d9745d5de936b7)}, {LL(0x77e4155dd19ab643), LL(0x99a71d8686abec5d)}, {LL(0xdc41cc87ecace1c9), LL(0xa788455151a4c887)},
			{LL(0x71d73215b47b0c4a), LL(0x939db79494bb5215)}, {LL(0x7e498ea1adebe6bd), LL(0x82f475b9b993b2a1)}, {LL(0x2cb55d96bfb85962), LL(0x74d738c4c461d096)}, {LL(0xf2e58c29704b6fac), LL(0xd5491b9b9b747229)},
			{LL(0x418cc9101a7f9502), LL(0xc38eae04043beb10)}, {LL(0xd5ec577b90ddb137), LL(0xbcdb2d6e6e9c967b)}, {LL(0x6cd07b9a55094682), LL(0xb452a5c7c7e30e9a)}, {LL(0x1b346ec78493f0c1), LL(0x2df5b8414148e2c7)},
			{LL(0x594055f34d7d3826), LL(0xeb66434c4c7b56f3)}, {LL(0xbd1e1691836a9abb), LL(0x04a544b5b5de4c91)}, {LL(0xc564bf784b60c60f), LL(0x8c6b9b1e1e5d4078)}, {LL(0x15433d6f6dcd90d4), LL(0x3f97496b6bd9376f)},
			{LL(0xfd7b309d69db855b), LL(0xc420d9b6b65c929d)}, {LL(0xedf3d89eb266f263), LL(0xf4906fc6c69d449e)}, {LL(0x2f4dafb26c290487), LL(0x71ca6dcdcd698fb2)}, {LL(0x3fc547b1b79473bf), LL(0x417adbbdbda859b1)},
			{LL(0x62a72832bc572697), LL(0xa63054eded72db32)}, {LL(0x3479c175e8baf446), LL(0x5c3fd58c8c216d75)}, {LL(0x31b214195eca13aa), LL(0x53182a9797398c19)}, {LL(0x324ae63d8d5b4e4f), LL(0x56057f9e9e31d33d)},
			{LL(0x192573ffa7cc27c6), LL(0x2be3de4f4ff988ff)}, {LL(0xf30c63358085e54e), LL(0xd642289c9ccd4735)}, {LL(0x2d5cb28a4f76d380), LL(0x77dc0bc3c3d8e58a)}, {LL(0xe5b7ac7e3ed9287f), LL(0xecc834fefe1c2f7e)},
			{LL(0xb4b38d6dff1bca45), LL(0x1ff62c8a8ae6126d)}, {LL(0x07dac854952f30eb), LL(0x0931991515a98b54)}, {LL(0xaa4c36c6cdf8dd68), LL(0x3d246bd0d0b611c6)}, {LL(0x4dea8780d07e2210), LL(0xd7fa3920201b5480)},
			{LL(0x9a17cdc363fc4420), LL(0x6d3772404036a8c3)}, {LL(0x7fa061bd5d256c5f), LL(0x81ff46bebe2a87bd)}, {LL(0xf11d7e0da3da3249), LL(0xd0544e92927c2d0d)}, {LL(0x175220574e9247d3), LL(0x39812f6565685d57)},
			{LL(0x9bfe22df9332cec2), LL(0x6e3c4147478f9ddf)}, {LL(0x799346f538c4d656), LL(0x8bc5ecacac3a39f5)}, {LL(0x03f8f224d3915de5), LL(0x051d550909085f24)}, {LL(0xbf0f0ba9a0354dbc), LL(0x02b322bbbb6f26a9)},
			{LL(0x22c20e3e56e63977), LL(0x66b5c9eeeef0053e)}, {LL(0x0e7753a8e95e6015), LL(0x1262f12a2a91d5a8)}, {LL(0xd7fd4a43b3826630), LL(0xbacd4b60602dfc43)}, {LL(0xfaa1f8c9fcf4b5b0), LL(0xcd1140a3a3f519c9)},
			{LL(0x5ab8a7d79eec65c3), LL(0xee7b1645457309d7)}, {LL(0x741ce779020beba6), LL(0x9cba488f8fa3b379)}, {LL(0xebc0ffd6d787486a), LL(0xfeaac5d4d48dfad6)}, {LL(0x691baef6e379a16e), LL(0xbb755adcdcfbeff6)},
			{LL(0x44471c7cac0f72ee), LL(0xcca9511f1f230a7c)}, {LL(0x232be122a628b395), LL(0x65befae9e9493022)}, {LL(0xfe83c2b9ba4ad8be), LL(0xc13d8cbfbf54cdb9)}, {LL(0x1088e803dbbd7738), LL(0x30b0b67070c1d603)},
			{LL(0x084474e08cbfda1c), LL(0x18585b3838816be0)}, {LL(0x50edce0f310c68d8), LL(0xf0352b737343080f)}, {LL(0x482152ec660ec5fc), LL(0xd8ddc63b3b03b5ec)}, {LL(0x2a867adeda59e36b), LL(0x7eed92d6d6716ede)},
			{LL(0x64940f7ad9b69c9e), LL(0xac0afeffff62657a)}, {LL(0x8d45ed942d6e03f3), LL(0x54b65d25255ef594)}, {LL(0x8ebd1fb0feff5e16), LL(0x51ab082c2c56aab0)}, {LL(0xced839bc144e41f6), LL(0x912e952f2fd474bc)},
			{LL(0x8b76cadc488fb9fa), LL(0x5e8cf737374e4bdc)}, {LL(0xc902f1e88161711d), LL(0x981f0c3a3a7dffe8)}, {LL(0x439dd42839204205), LL(0xc598c80a0a8a8128)}, {LL(0x86f96b507240840a), LL(0x49f3531414d7c150)},
			{LL(0x26e0344e10585479), LL(0x6a9905f2f251d14e)}, {LL(0xd3df7033f53c0b3e), LL(0xb6e1877c7c8c2833)}, {LL(0x60b6350a9f08f190), LL(0xa02632e3e3c3b10a)}, {LL(0xa7c3974af737e098), LL(0x2a5bcff3f32f9b4a)},
			{LL(0x5e9a9da7d85208cd), LL(0xe257da5959d2dda7)}, {LL(0x9dcd0597f6d374cb), LL(0x6406eb55559f2397)}, {LL(0x45aef3605cc1f80c), LL(0xcfa26218189a3f60)}, {LL(0x14aad2739d031a36), LL(0x3c9c7a6c6c600273)},
			{LL(0xa0195f1e6218d073), LL(0x236a56e6e686101e)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xe45e4362ce17a29d), LL(0xefc307f9f9a51a62)}, {LL(0x465601448f50a5e9), LL(0xcabf371111926044)},
			{LL(0x213afc1a85776492), LL(0x63a89ce7e7f85a1a)}, {LL(0x4ffb9ab8f321f517), LL(0xd1ec5f2e2eaa3eb8)}, {LL(0x02111d38235fd707), LL(0x0616660e0eb16a38)}, {LL(0xec1a378242a87881), LL(0xf79b5cc1c1247182)},
			{LL(0xc48d5064bbae4ced), LL(0x8f60a81919e47564)}, {LL(0x5c8b809ffb0ddfca), LL(0xe441bc575763b79f)}, {LL(0xa208422641470774), LL(0x257c30e8e8377a26)}, {LL(0x760dfa4121543ca1), LL(0x9aac2e818112d941)},
			{LL(0x3e2ca8ad475af95d), LL(0x4271e8baba116cad)}, {LL(0xf72e5945c63b8840), LL(0xda6ee480806c9345)}, {LL(0xe7a6b1461d86ff78), LL(0xeade52f0f0ad4546)}, {LL(0xad96fe9258d7ed83), LL(0x3415f2c5c51f9a92)},
			{LL(0x13701a27082c2add), LL(0x35ade37979c98927)}, {LL(0x676cfd5e0a27c17b), LL(0xa917abf6f66a3a5e)}, {LL(0xb6a29055dc441d42), LL(0x19e04a8484577855)}, {LL(0xd2369f2f05f281dc), LL(0xb5eab47b7b351d2f)},
			{LL(0x0d8fa18c3acf3df0), LL(0x177fa42323998a8c)}, {LL(0xdfb93ea33f3dbc2c), LL(0xa295105858ac97a3)}, {LL(0xff6a2da54a84525c), LL(0xc236bfb8b8edf8a5)}, {LL(0xf53f447de5645f47), LL(0xdc78828e8eddf97d)},
			{LL(0x35902e6918747ea4), LL(0x5f34e68b8b985869)}, {LL(0xfb4817d50c3a3f52), LL(0xce1a73a4a44c2cd5)}, {LL(0x3c3db59564052e5a), LL(0x44678eb4b4a00695)}, {LL(0x1299f53bf8e2a03f), LL(0x36a6d07e7e70bc3b)},
			{LL(0x91ab4b073cd2c3d9), LL(0x70727c7171bf9c07)}, {LL(0x47bfee587f9e2f0b), LL(0xc9b40416162b5558)}, {LL(0x9e35f7b32542292e), LL(0x611bbe5c5c977cb3)}, {LL(0xc775a240683f1108), LL(0x8a7dfd1010ec2a40)},
			{LL(0x6d399486a5c7cc60), LL(0xb75996c0c05a3b86)}, {LL(0x8f54f0ac0e31d4f4), LL(0x52a03b2b2bef9fac)}, {LL(0xb091b71db9a5a74b), LL(0x13dae0969647c61d)}, {LL(0xd863f6f7aa128cc7), LL(0xaba4894d4d051cf7)},
			{LL(0xc35798302e817c06), LL(0x8651310c0c4dfe30)}, {LL(0x52fcd3371253bfdf), LL(0xf6234d7d7df26237)}, {LL(0x94609e6b8aa22435), LL(0x7f55836a6aa77d6b)}, {LL(0x8967d7e46bd06efd), LL(0x589a913939ff21e4)},
			{LL(0x8cac0288dda08911), LL(0x57bd6e2222e7c088)}, {LL(0xbb2d31d9e68b20b2), LL(0x0e9feea7a7cef2d9)}, {LL(0x99ef3fe7b06d19c5), LL(0x682a2749493ef7e7)}, {LL(0x3dd45a8994cba4b8), LL(0x476cbdb3b3193389)},
			{LL(0xb93c2ce1c5d4f7b5), LL(0x088988a9a97f98e1)}, {LL(0x9042a41bcc1c493b), LL(0x73794f767606a91b)}, {LL(0x5d626f830bc35528), LL(0xe74a8f5050da8283)}, {LL(0xb74b7f492c8a97a0), LL(0x1aeb798383ee4d49)},
			{LL(0x8710844c828e0ee8), LL(0x4af86013136ef44c)}, {LL(0x93ba563f1f8d14de), LL(0x76641a7f7f0ef63f)}, {LL(0x888e38f89b1ee41f), LL(0x5b91a23e3e4614f8)}, {LL(0xa85d2bfeeea70a6f), LL(0x3b320ddede077bfe)},
			{LL(0xbcf7f98d73a41059), LL(0x07ae77b2b267798d)}, {LL(0x96718353a9fdf332), LL(0x7943e56464161753)}, {LL(0xaf87e3aa7b883a84), LL(0x320394cbcbaef0aa)}, {LL(0x0c664e90ca01b712), LL(0x147497242420bf90)},
			{LL(0xea2910ca2749c288), LL(0xfda1f6d3d334cfca)}, {LL(0x0a5569d8afe00d1b), LL(0x1e4e3d36363001d8)}, {LL(0x7db17c857e7abb58), LL(0x87e920b0b09bed85)}, {LL(0xf4d6ab6115aad5a5), LL(0xdf73b1898964cc61)},
			{LL(0x82db512034fee904), LL(0x45df9f0808761520)}, {LL(0xb55a62710fd540a7), LL(0x1cfd1f8d8d5f2771)}, {LL(0xd405b86760133bd5), LL(0xbfd01e696925a367)}, {LL(0x4e1275a403ef7ff5), LL(0xd2e76c2929130ba4)},
			{LL(0x73c62f2d9724db4d), LL(0x958bd19a9a0a382d)}, {LL(0x53153c2be29d353d), LL(0xf5287e7a7a4b572b)}, {LL(0x703edd0944b586a8), LL(0x9096849393026709)}, {LL(0x5737065ba4235833), LL(0xf904b26666ea835b)},
			{LL(0x5b5148cb6e22ef21), LL(0xed70254242ca3ccb)}, {LL(0xdda8239b1c626b2b), LL(0xa4837656561dfd9b)}, {LL(0xb280aa259afa704c), LL(0x15cc869898f6ac25)}, {LL(0xcb13ecd0a23ea61a), LL(0x9e096a3434cc95d0)},
			{LL(0x6f2889be86981b67), LL(0xb14ff0ceceeb51be)}, {LL(0x381f8fe522bb4354), LL(0x484b42a8a801d2e5)}, {LL(0x05cbd56cb670e7ec), LL(0x0f27ff1b1b18e16c)}, {LL(0x2709db52e096de9b), LL(0x699236f5f5e8e452)},
			{LL(0xf6c7b65936f502a2), LL(0xd965d78787d5a659)}, {LL(0xefe2c5a691392564), LL(0xf28609c8c82c2ea6)}, {LL(0x85019974a1d1d9ef), LL(0x4cee061d1ddf9e74)}, {LL(0x6ae35cd230e8fc8b), LL(0xbe680fd5d5f3b0d2)},
			{LL(0x289767e6f906346c), LL(0x78fbf4d8d8c004e6)}, {LL(0xc8eb1ef471affbff), LL(0x9b143f3d3dc4caf4)}, {LL(0x0f9ebcb41990eaf7), LL(0x1169c22d2d28e0b4)}, {LL(0x8a9f25c0b8413318), LL(0x5d87c43030f77ec0)},
			{LL(0x7a6bb4d1eb558bb3), LL(0x8ed8b9a5a53266d1)}, {LL(0x657de0662978167c), LL(0xaf01cdf8f8db5066)}, {LL(0x9fdc18afd58ca3cc), LL(0x62108d5b5b2e49af)}, {LL(0x2b6f95c22a976989), LL(0x7de6a1d1d1c85bc2)},
			{LL(0xb36945396a34faae), LL(0x16c7b59f9f4f9939)}, {LL(0x16bbcf4bbe5ccd31), LL(0x3a8a1c6262d1684b)}, {LL(0x55261b63877c8f34), LL(0xff12d468685be963)}, {LL(0xae6e0cb68b46b066), LL(0x3108a7cccc17c5b6)}
		}, {
			{LL(0xd94ca1d0b19e9555), LL(0x521af24c1cf92f5a)}, {LL(0x6c815d85cf87edfa), LL(0x1c58e1811e8b4855)}, {LL(0x72ccac48560abe0c), LL(0x1a09f1cc58455c67)}, {LL(0x0a3beefa777b3152), LL(0x028eb13b83fb0caf)},
			{LL(0xc701501d2813c6a3), LL(0x544be2015a373b68)}, {LL(0x534f51f7c9ab1c73), LL(0xaec7174ff2a062e2)}, {LL(0x75e9ed0797709ce1), LL(0xcfd96de9b881e7f2)}, {LL(0x6346c40262202581), LL(0x1f91e9463dec424c)},
			{LL(0xb0318b28a4c58186), LL(0x4f05aa31a2ee61b9)}, {LL(0x1722321c19033502), LL(0xbae27722a5411a4e)}, {LL(0x6463854da35a076c), LL(0xca417563dd28f9d9)}, {LL(0x1bb186b04351aadf), LL(0x0716a9b1e6521284)},
			{LL(0xc0241152e969e44e), LL(0x819b7e24baf380fd)}, {LL(0xc3703c791e9cb3e8), LL(0x3fa6a870da87822e)}, {LL(0xd68b38571c395d2e), LL(0x51d3fa8b3f9e2543)}, {LL(0x936b40a520c2f83d), LL(0x2f5c696b4853e21f)},
			{LL(0x05fc777ddadcf929), LL(0x0147b9fca09c06b6)}, {LL(0x36a1cfa386a2977d), LL(0x0e2c91a10fa424cb)}, {LL(0x6012e92995d57227), LL(0xa1ac3f125d98409f)}, {LL(0xcfe388d544ce2c35), LL(0x825276e399948ae4)},
			{LL(0x5e51fe427faa0fcc), LL(0x79993a51919fd5d8)}, {LL(0xad2857cecabd85d6), LL(0xf7696c2884547758)}, {LL(0x5a20922649257a87), LL(0x12747020112f6c9e)}, {LL(0x9a048374a04c9ec9), LL(0x93ef0e04abdcec63)},
			{LL(0xb714ca6765bfa36b), LL(0x9ad53614422ada2c)}, {LL(0x1c94c7ff822b8832), LL(0xd2c635940696a911)}, {LL(0xb440e74c924af4cd), LL(0x24e8e040225ed8ff)}, {LL(0x4e568d11a7d31823), LL(0x16abd156d41a7403)},
			{LL(0x08e2d8c86cddea96), LL(0xd61994e2c3a3b18c)}, {LL(0xaca54cd726ee09b4), LL(0x9dc39fa5a478c8a8)}, {LL(0x26a6bcf05edb8092), LL(0x611e7aa64a218510)}, {LL(0x15fb042e02a5eec6), LL(0x6e7552fbe519a76d)},
			{LL(0xdb9597e2aa384e91), LL(0x868dd7955ca19279)}, {LL(0xb1bc903148960de4), LL(0x25af59bc82c2de49)}, {LL(0x836c33f6f8bbefd2), LL(0x406e826c0dd643c4)}, {LL(0x247f8ac2457d5b56), LL(0xb5895f7f0a793833)},
			{LL(0xd5df157cebcc0a88), LL(0xefee2cdf5fea2790)}, {LL(0x9950ae5f57b9c96f), LL(0x2dd2d850cba8eeb0)}, {LL(0xb8d353e0c8186b10), LL(0x991c3ed3614dd035)}, {LL(0xab800d98e7942b59), LL(0x4813038044bc733d)},
			{LL(0xeb9c021701b37763), LL(0x37db299c93edb2d7)}, {LL(0x6737a86654af50ca), LL(0x747ca337bd5cfb0a)}, {LL(0x18e5ab9bb4a4fd79), LL(0xb92b7fe586261057)}, {LL(0x95c31af30deb56b2), LL(0x902606c388bbe67a)},
			{LL(0xefed6e73373c0228), LL(0x5c3663ed135d0b91)}, {LL(0xd4520e65079f86ea), LL(0x8544df527fc69860)}, {LL(0xed3458412c9ad9ec), LL(0x88a146345305b6b2)}, {LL(0xf8cf5c6f2e3f372a), LL(0xe6d414cfb61c11df)},
			{LL(0x02d936321ba6dbc4), LL(0xd49725d94058bd23)}, {LL(0xe94534251a15aca7), LL(0xe34c0c45d3b50ff4)}, {LL(0x6ba41cca0efdcf17), LL(0xc9887da4fe4ff3c0)}, {LL(0x92e65bbccc91745f), LL(0x45f69ae6687f5def)},
			{LL(0x018d1b19ec538c62), LL(0x6aaaf38d202cbff0)}, {LL(0x85c469a0d592415d), LL(0xff14edc4cd3e47a1)}, {LL(0x396656242b055f06), LL(0x0de599662cc32ed2)}, {LL(0x401c0f8fe6275c3a), LL(0x7fc82a1cd751c1ea)},
			{LL(0xbd2f249d12c49239), LL(0x985b872fc1d1d683)}, {LL(0xd02362013110f3a1), LL(0xeea99523ff762126)}, {LL(0xd3774f2ac6e5a407), LL(0x509443779f0223f5)}, {LL(0x8e729c434ebafc6d), LL(0x9730af726ee9f4fe)},
			{LL(0x5974bf0dbed02d21), LL(0xac49a674715b6e4d)}, {LL(0xc94bd28369e782ba), LL(0x3d28194b597c8e81)}, {LL(0xa036f87b7cbc9669), LL(0x20374136e76bc062)}, {LL(0xd8c1bac95dcd1937), LL(0x38b001c13cd590aa)},
			{LL(0x6e586bb7d421363e), LL(0xc8cfc4585ed3f576)}, {LL(0x7730db358cd64725), LL(0x1b4e4830f8d95ad1)}, {LL(0xc68c4b04c4404ac1), LL(0x3ee1118c7a1b8498)}, {LL(0xf45ce8c3746da8f7), LL(0x5b20ca5cf50f1915)},
			{LL(0xba0a65d2d3beb0d4), LL(0x4d8b1b0a21156d16)}, {LL(0xae7c7ae53d48d270), LL(0x4954ba7ce420758b)}, {LL(0x91b276973b6423f9), LL(0xfbcb4cb2080b5f3c)}, {LL(0x903f6d8ed737af9b), LL(0x9161bf3f2827e0cc)},
			{LL(0x0bb6f5e39b28bd30), LL(0x682442b6a3d7b35f)}, {LL(0x7ba36f99d684d8f8), LL(0xa6ba96a3bbca521b)}, {LL(0xee60756adb6f8e4a), LL(0x369c90603371b461)}, {LL(0x2bb81345e8da932d), LL(0xb64057b8291e322a)},
			{LL(0x0d1eafb5b60113bf), LL(0xd75e2d1e633fb73a)}, {LL(0xa5ca8f06a6606f40), LL(0x2170f8ca47f7c6d4)}, {LL(0x13535e782f8c4049), LL(0xd10f3d5325f1a308)}, {LL(0x78f742b221718f5e), LL(0x188740f7dbbe50c8)},
			{LL(0x9cacd9228d653046), LL(0x2c9561ac6b34e806)}, {LL(0x5fdce55b93f983ae), LL(0x1333c9dcb1b36a28)}, {LL(0xd2fa54332ab62865), LL(0x3a3eb0fabf2e9c05)}, {LL(0x9d21c23b6136bc24), LL(0x463f92214b1857f6)},
			{LL(0x6fd570ae3872ba5c), LL(0xa26537d57eff4a86)}, {LL(0xb95e48f9244be772), LL(0xf3b6cd5e41616fc5)}, {LL(0xe2f3c1c6813d1197), LL(0x8b684ef37062bcab)}, {LL(0xb5cdfc557e1978af), LL(0x4e4213cd0272670f)},
			{LL(0x98ddb546bbea450d), LL(0x47782bddeb845140)}, {LL(0x3478f9919d044cb9), LL(0xdabbb4784ffc99e8)}, {LL(0x619ff2307986fe45), LL(0xcb06cc9f7db4ff6f)}, {LL(0x971a2cc1164d8d76), LL(0x44b1231ac8e35b59)},
			{LL(0x58f9a4145283a143), LL(0xc6e355f95177d1bd)}, {LL(0xf708c5e88398ff51), LL(0xe51d1c08957b1bc6)}, {LL(0x4d02a03a50264f85), LL(0xa8960702b46e76d0)}, {LL(0x56b3268a1377e55a), LL(0xaf80aeb3523c6454)},
			{LL(0xdcb0d6ad6b426c7c), LL(0x535d4bb0bc6529ec)}, {LL(0x944e01eae1b8dad0), LL(0xfa8cf54ea897598a)}, {LL(0x5c88c870640cd408), LL(0xad0e1f88d1c768fb)}, {LL(0xc4557d36dfe69105), LL(0xea7634553a4339bb)},
			{LL(0xde69e09f70e4b7b8), LL(0x87ca6e69fc3d94cf)}, {LL(0x8fff875aa2e9700f), LL(0xfd9a5cff4ec54b0e)}, {LL(0xe5d680894047337a), LL(0x5eb8d2d690a6073e)}, {LL(0xa8d420b310617cff), LL(0xf62ed5d424c871ee)},
			{LL(0xdfe4fb869cb73bda), LL(0xed609de4dc112b3f)}, {LL(0x35f5e2887157c0db), LL(0xb01147f56fd02618)}, {LL(0x300995f5ab8b39f2), LL(0xb156fe09cf4c20ae)}, {LL(0x871d5f92ce349a99), LL(0x2b83c81d8d66fa82)},
			{LL(0x8cabaa71551c27a9), LL(0x43a78aab2eb149dd)}, {LL(0x335db8de5c7e6e54), LL(0x0f6b285daf38227d)}, {LL(0xf5d1f3da983e2495), LL(0x318a39d1d523a6e5)}, {LL(0x4a27e175915c6d68), LL(0x7d469b2754aacd45)},
			{LL(0xca1fffa89e12d51c), LL(0x8315cf1f39088c52)}, {LL(0x5d05d369885f586a), LL(0xc7a4ec05f1ebd70b)}, {LL(0x65ee9e544f098b0e), LL(0xa0eb86eefd044629)}, {LL(0xccb7a5feb33b7b93), LL(0x3c6fa0b7f9e08837)},
			{LL(0x66bab37fb8fcdca8), LL(0x1ed650ba9d7044fa)}, {LL(0xa362d5508b49c1cf), LL(0x9e0a9762871fc2b1)}, {LL(0x3bbf601630a384c2), LL(0xd972bcbf6c9b93f1)}, {LL(0x8d26b168b94fabcb), LL(0x290d79260e9df62d)},
			{LL(0xecb94358c0c9558e), LL(0xe20bb5b973290942)}, {LL(0xf685def16fcb7333), LL(0x8fb7ef85b557a436)}, {LL(0x7c862ed617fefa15), LL(0x736a0a865b0ee98e)}, {LL(0x3fce0c72062cf189), LL(0xb29ff6ceec2b2ab7)},
			{LL(0x7e5f18e40c5821d1), LL(0xa7fd2f5f1b5654ad)}, {LL(0xf379a98cb5178a1a), LL(0x8ef0567915cba280)}, {LL(0x6d0c469c23d46198), LL(0x76f2120c3ea7f7a5)}, {LL(0x4973cc5e66a93ace), LL(0xc37b4d7334decf96)},
			{LL(0x1968b08258f7711b), LL(0xd3818c68a60aafa7)}, {LL(0x62cbdf1b8e73a9e3), LL(0x753b1acb1dc0fdbc)}, {LL(0xa9593baafc32f09d), LL(0x9c84265904e4ce1e)}, {LL(0xfb9b7144d9ca608c), LL(0x58e9c29bd668130c)},
			{LL(0x7341b751ba59326e), LL(0x70a302417869e397)}, {LL(0x2fc97f21de55e666), LL(0xddad1dc9a9ae8b6c)}, {LL(0x419114960a74d058), LL(0x1562d991f77d7e1a)}, {LL(0x7a2e74803ad7549a), LL(0xcc10652e9be6edeb)},
			{LL(0x76bdc02c6085cb47), LL(0x71e4bbbdd8f5e521)}, {LL(0xe45b9b90ac14bf18), LL(0x3412215bb08ab8ce)}, {LL(0xa2efce49671a4dad), LL(0xf4a064efa7337d41)}, {LL(0xdd3dcdb48711e01e), LL(0x39f7b83d9c49961c)},
			{LL(0xe682ada2b7b264dc), LL(0xe0850482f0d205ed)}, {LL(0x14761f37eef662a4), LL(0x04dfa176c535189d)}, {LL(0x25f291dba92ed734), LL(0xdf23acf22a5587c3)}, {LL(0xbff612af096249fd), LL(0x4ccca2f681896ba0)},
			{LL(0xbe7b09b6e531c59f), LL(0x2666517ba1a5d450)}, {LL(0x06a85a562d29ae8f), LL(0xbf7a6fa8c0e80465)}, {LL(0x0725414fc17a22ed), LL(0xd5d09c25e0c4bb95)}, {LL(0xcd3abee75f68f7f1), LL(0x56c5533ad9cc37c7)},
			{LL(0x5bad893fa576f6e5), LL(0x78de83ad3103d36e)}, {LL(0x372cd4ba6af11b1f), LL(0x6486622c2f889b3b)}, {LL(0x9e75ef1096c3eb82), LL(0xf80244752b6c5525)}, {LL(0x272ba7e9b2880cf0), LL(0x0bb4892b6a0d3ae0)},
			{LL(0xa69ea22d519538e6), LL(0x9f4d2e9e2783c407)}, {LL(0xd1ae7918dd437fc3), LL(0x840366aedf5a9ed6)}, {LL(0x10077353d87917ef), LL(0x6f32eb074585a1db)}, {LL(0x200ee6a673f22e1d), LL(0xde64150e8ac98175)},
			{LL(0x2c9d520a29a0b1c0), LL(0x6390cb9dc9da89bf)}, {LL(0x1e4df1cd998d53f6), LL(0x0651104d46ce1432)}, {LL(0x04716c64368f754b), LL(0x6bed4a7180b0b946)}, {LL(0xfa166a5d3599ecee), LL(0x32433116f644acfc)},
			{LL(0x29612577f37c48e9), LL(0x62d7726169468f09)}, {LL(0x88dac615639352e2), LL(0x284ac0daae01f09b)}, {LL(0x81b505c4e31d3416), LL(0x94f9a7b54d8efee7)}, {LL(0xe02af7f49a9bca53), LL(0x5fff6b2a303a0188)},
			{LL(0x0c93b4ac5a529fdd), LL(0xbdf4de93431308ca)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xea11190eede0fb01), LL(0x5d71da11b3c10d27)}, {LL(0x28ec3e6e1f2fc48b), LL(0x087d81ec496a30f9)},
			{LL(0xda188cfb466bc2f3), LL(0xec2724187c8d2d89)}, {LL(0xf1a09fbeaeb151de), LL(0x5a6773a055931fa3)}, {LL(0xce6e93cca89da057), LL(0xe8f8856eb9b83514)}, {LL(0x546a10b808d13e9e), LL(0x7b178b6a1264d977)},
			{LL(0x573e3d93ff246938), LL(0xc52a5d3e7210dba4)}, {LL(0xe70fb6bb5be1e8be), LL(0x8a2ff70fd0feba1d)}, {LL(0xc2fd2760f2cf3f8a), LL(0x550c5bfdfaab3dde)}, {LL(0x2a35085c04891f4f), LL(0xdceaa43509328dda)},
			{LL(0x2d104913c5f33da2), LL(0x093a3810e9f6364f)}, {LL(0xfcbe300b18b04261), LL(0x8d395ebe36aca899)}, {LL(0x434822a411d20b9c), LL(0xc1f5fc48b725c339)}, {LL(0x8a03f02778358926), LL(0xfcdde503ee594db8)},
			{LL(0x16af2905f550b960), LL(0xd04884af856da5be)}, {LL(0xf2f4b29559440678), LL(0xe45aa5f435e71d70)}, {LL(0x22d7d0946854f5d9), LL(0x0af330d7ca913c56)}, {LL(0x797a59abcd22033c), LL(0x722db37afb92ef38)},
			{LL(0x8690448b226716fb), LL(0x41293b90ad4a4572)}, {LL(0xffea1d20ef4515c7), LL(0x330488ea56d8aa4a)}, {LL(0x42c539bdfd8187fe), LL(0xab5f0fc597097cc9)}, {LL(0x32d0a3c7b02de236), LL(0x65c1dbd08f149d8d)},
			{LL(0x3a327b0fdcf008a0), LL(0xb3d84f324cb72c01)}, {LL(0x1d19dce66e780450), LL(0xb86cc61926ba16e1)}, {LL(0xe37edadf6d6e9df5), LL(0xe1c2bd7e504e035b)}, {LL(0x71988163a1ffe9aa), LL(0xa434279838315eb4)},
			{LL(0x697d2af8155b14d3), LL(0x1d1f587dbe174ee3)}, {LL(0x4fdb96084b809441), LL(0x7c0122dbf436cbf3)}, {LL(0x2183fdbf9fa1a27f), LL(0xb4cee683aae53e85)}, {LL(0xfe670639031699a5), LL(0x59ae7b6776f415ba)},
			{LL(0x82e128ef14e863b0), LL(0x2ac471e12dfafc34)}, {LL(0xf9424776c26cbb48), LL(0x8c7ee7429630ae2f)}, {LL(0xb365a6035330d620), LL(0xf1387c65c29a636a)}, {LL(0x096fc3d1808e66f4), LL(0xbcb3676fe38f0e7c)},
			{LL(0xa1bbe36290ef1a0b), LL(0x4a9db2bbc7477f92)}, {LL(0xc8c6c99a85b40ed8), LL(0x5782eac679503171)}, {LL(0x519667c5d20dc7b7), LL(0x7a503296b2f8dfc1)}, {LL(0x68f031e1f90898b1), LL(0x77b5abf09e3bf113)},
			{LL(0x501b7cdc3e5e4bd5), LL(0x10fac11b92d46031)}, {LL(0xa447941f4a33e322), LL(0x4bda0b4767db7924)}, {LL(0xd706234ef06ad14c), LL(0x3b7909061fb29ab3)}, {LL(0x844972b939c1cd3f), LL(0x95be1e49ed12f851)},
			{LL(0x6a2907d3e2ae4375), LL(0xa3228e29de634c30)}, {LL(0x0e4a829e41f44419), LL(0x6963fb4a034bb5e9)}, {LL(0x80381edd0f4eb874), LL(0xfe5354386da24117)}, {LL(0x45e078f23cfba513), LL(0x7e8f93e077cdc75c)},
			{LL(0x47394ec0275d7ed7), LL(0xaa18b63937957a7f)}, {LL(0xa713b934bdc6b484), LL(0xf5e7dd1307af7bf7)}, {LL(0x0fc79987ada7c87b), LL(0x03c908c723670a19)}, {LL(0xb2e8bd1abf635a42), LL(0x9b928fe8e2b6dc9a)},
			{LL(0x52c24aee25f89011), LL(0xc46de4c2d28cdd12)}, {LL(0x9ff8f4097a9067e0), LL(0x92a8b7f80b40ead5)}, {LL(0x446d63ebd0a82971), LL(0x1425606d57e178ac)}, {LL(0xe1a7eced76c84631), LL(0x355598a71016be78)},
			{LL(0xc5d8662f33b51d67), LL(0x80dcc7d81a6f864b)}, {LL(0x70159a7a4dac65c8), LL(0xce9ed415181de144)}, {LL(0x3d173a401d8a2a4d), LL(0x6608d317ac739794)}, {LL(0x55e70ba1e482b2fc), LL(0x11bd78e732486687)},
			{LL(0x7fd203fde00badb3), LL(0xcd57dcd23b7aeb5d)}, {LL(0x8b8eeb3e94660544), LL(0x9677168ece75f248)}, {LL(0xe8c82f3cf64620c5), LL(0x89e6ffc8f399b004)}, {LL(0x969737d8fa1e0114), LL(0x2e1bd097e8cfe4a9)},
			{LL(0x12de4561c3dfcc2b), LL(0xbba5cede05dd1cf8)}, {LL(0xaff161fcd11b5e12), LL(0x23fe49f1c40cca7b)}, {LL(0xbb877ecb3fed3cb6), LL(0x2721e8870139d2e6)}, {LL(0xf02d84a742e2ddbc), LL(0x30cd802d75bfa053)},
			{LL(0x118a684a342a9b8d), LL(0x0598188a65a91e2b)}, {LL(0x31848eec47d8b590), LL(0xdbfc0d84ef609f5e)}, {LL(0x7d0b35cffbad7677), LL(0x19c0f90b7b22567e)}, {LL(0x1fc0ead475dedf94), LL(0x6cfbe3c066e2abc2)},
			{LL(0x4c8fbb23bc75c3e7), LL(0xc23cf48f9442c920)}, {LL(0xbca23f84fe971e5b), LL(0xf2f174a2e1fd6973)}, {LL(0x38eb4d3dc756d364), LL(0x674f6aeb0cef9122)}, {LL(0x4baafa6c7d0fe10a), LL(0x17ec68aa748672b5)},
			{LL(0x9b89986d4c1f12ab), LL(0xf945fd898bf05393)}, {LL(0xfd332b12f4e3ce03), LL(0xe793ad3316801769)}, {LL(0x8957dd0c8fc0de80), LL(0x42e033578e2d4f6b)}, {LL(0x7464f61e7b231083), LL(0xa5739e6498ad5802)},
			{LL(0x03542d2bf7f557a6), LL(0xbe3dd654607402d3)}, {LL(0xb699d17e89ec2f09), LL(0xf07fc599620665dc)}, {LL(0x48fed7478afab6ac), LL(0xa9d1befe14f27066)}, {LL(0xc1a90a4b053a682c), LL(0xeb318da99adf3f0d)},
			{LL(0xcb92e4b17241597e), LL(0xe9bf3c92192433a2)}, {LL(0x3c9a2159f1d9a62f), LL(0x0ca2209a8c5f2864)}, {LL(0x46b455d9cb0ef2b5), LL(0xc0b245b417b9c58f)}, {LL(0xaa0d16810bc7a73b), LL(0x22b9f00d6490cccd)},
			{LL(0x1a3c9da9af0226bd), LL(0x6dbc5a3cc67ead74)}, {LL(0x2e44643832066a04), LL(0xb707ee448982349c)}, {LL(0x3e43176bea7f7deb), LL(0xd8350543cc079547)}, {LL(0x235acb8d840779bb), LL(0x6059c35aeabd83a6)}
		}, {
			{LL(0xe1133bc96d2d1a79), LL(0x36b7807580805879)}, {LL(0x50b11ffec6cb5891), LL(0x33891a1d1a1ad691)}, {LL(0xc2337988bcd20999), LL(0x9c07dc3bdcdce999)}, {LL(0xcf7e229397b68eb9), LL(0x657a42a3424215b9)},
			{LL(0x73915dbf17344b71), LL(0x9939465346466771)}, {LL(0x7463dccb5471c7ea), LL(0x5efc4a804a4af1ea)}, {LL(0xc6ab620f5279d9d7), LL(0xeff6561556566cd7)}, {LL(0x19f02cc5fb269195), LL(0x85ce790e79792895)},
			{LL(0x379d359f01bd0555), LL(0xd603bbd8bbbb6555)}, {LL(0x9ee94b3c8b27e2da), LL(0x3a5e9b549b9b73da)}, {LL(0x1d683742158d41db), LL(0xf63ff320f3f3addb)}, {LL(0x14bd77ded04216b5), LL(0x7cb3e796e7e7d4b5)},
			{LL(0x77094638f99f9b3f), LL(0xeac8cc7dcccce23f)}, {LL(0xb41c49e19f17a654), LL(0x1a62d3acd3d3bb54)}, {LL(0xa85208f250c0d37d), LL(0x80f0e366e3e3a67d)}, {LL(0x036a9af3adee5cd5), LL(0xb43486fd868613d5)},
			{LL(0x863f11a8aa5b47bd), LL(0xd33d21b02121ebbd)}, {LL(0x28b9ee7f63842ca9), LL(0xf8a50def0d0d6ba9)}, {LL(0xdae5231c9daeacfe), LL(0x756466df666671fe)}, {LL(0x3e487503c472523b), LL(0x5c8faf6eafaf1c3b)},
			{LL(0xbf85e5df2d6c991d), LL(0x4877820d8282611d)}, {LL(0x660a5c301d2c6936), LL(0x8927622f62620336)}, {LL(0x7808f181a54f7438), LL(0xcb2c17f21717bd38)}, {LL(0x0f01b7b95cd0ef07), LL(0x21e4db8fdbdb5f07)},
			{LL(0x33052e18ef16d51b), LL(0xa5f231f63131e01b)}, {LL(0x10256c593ee9c6fb), LL(0x0f426db86d6d51fb)}, {LL(0xf01021c1899ee870), LL(0x55582e272e2eb970)}, {LL(0x25f4b56448e0ab89), LL(0x01d8937793939789)},
			{LL(0x4dd928bcd346194a), LL(0xc5b6e93de9e97b4a)}, {LL(0x27b859c63f54c3ae), LL(0xd941d660d6d634ae)}, {LL(0xb2c8bec406081e3d), LL(0xb10a1c951c1c9d3d)}, {LL(0x1c4e4113cfd77529), LL(0x9a9230ca30301d29)},
			{LL(0x63b431e629dd8d8a), LL(0x967b2beb2b2b368a)}, {LL(0x762f306923c5afcd), LL(0x86650f970f0f52cd)}, {LL(0x991bca48c8626e41), LL(0xfd9b97879797e541)}, {LL(0x306fb4eb42f889ce), LL(0x11c6b70bb7b7f3ce)},
			{LL(0x6b47072b3648ee16), LL(0x705afcb7fcfcff16)}, {LL(0xcc14b8603a58d26c), LL(0xd14ec45ec4c4066c)}, {LL(0x7a441d23d2fb1c1f), LL(0x13b552e552521e1f)}, {LL(0x23204241d1ff13e0), LL(0xaab05c4e5c5cb1e0)},
			{LL(0x0e27c1e8868adbf5), LL(0x4d4918651818eff5)}, {LL(0xde7d389b73057cb0), LL(0x0695ecf1ececf4b0)}, {LL(0xd7a87807b6ca2bde), LL(0x8c19f847f8f88dde)}, {LL(0x46408482613d2603), LL(0x97a3b89cb8b8a103)},
			{LL(0xc9aad5b60ea936d0), LL(0xce128d9a8d8d33d0)}, {LL(0x2af502dd1430448e), LL(0x203c48f84848c88e)}, {LL(0x4b0ddf994a59a123), LL(0x6ede260426265d23)}, {LL(0x57439e8a858ed40a), LL(0xf44c16ce1616400a)},
			{LL(0x82a70a2f44f097f3), LL(0xa0ccab9eabab6ef3)}, {LL(0x8c80cbc7c27a4c06), LL(0xed85b3fbb3b38106)}, {LL(0x54290479286088df), LL(0x40789033909053df)}, {LL(0x42d89f058f96f64d), LL(0xe45232b23232244d)},
			{LL(0x41b205f62278aa98), LL(0x5066b44fb4b43798)}, {LL(0xdc31d43904b11497), LL(0xde0ca9e6a9a95797)}, {LL(0x61f8dd445e69e5ad), LL(0x4ee26efc6e6e95ad)}, {LL(0x2d0783a95775c815), LL(0xe7f9442b44445e15)},
			{LL(0xfc7b0c8b78a05ba2), LL(0xc08873557373f5a2)}, {LL(0xed7816839c13a9ab), LL(0xa367dd07dddd14ab)}, {LL(0x2e6d195afa9b94c0), LL(0x53cdc2d6c2c24dc0)}, {LL(0x52fdf35cb17f30b6), LL(0xeb105f0a5f5f75b6)},
			{LL(0xbb1dfe58c3c74953), LL(0x3b8608230808e453)}, {LL(0x7b626b7208a128ed), LL(0x7f18910f9191aeed)}, {LL(0xadec6524643137c1), LL(0x9facaaa2aaaa93c1)}, {LL(0xa0a13e3f4f55b0e1), LL(0x66d1343a34346fe1)},
			{LL(0xd21615d1823bcf62), LL(0x9345b183b1b1b862)}, {LL(0x440c682016894e24), LL(0x4f3afd8bfdfd0224)}, {LL(0x32235849354ce1e9), LL(0xc95ff21cf2f250e9)}, {LL(0xdd17a268deeb2065), LL(0xb2a16a0c6a6ae765)},
			{LL(0xf8e3170c960b8bec), LL(0xb379f97bf9f970ec)}, {LL(0xa51f53e97ba4545d), LL(0x798d7dfe7d7d5a5d)}, {LL(0x81cd90dce91ecb26), LL(0x14f82d632d2d7d26)}, {LL(0xc07f952acb6661be), LL(0x449e992c99994abe)},
			{LL(0x8ecc2765b5ce2421), LL(0x351cf6ecf6f62221)}, {LL(0xce5854c24decba4b), LL(0x09d781498181a54b)}, {LL(0x8818d0402cd19c48), LL(0x9e7439d539390448)}, {LL(0x792e87d07f1540ca), LL(0xa781d418d4d40dca)},
			{LL(0xcbe63914791d5ef7), LL(0x168bc88dc8c890f7)}, {LL(0x2bd3748cce6a707c), LL(0x4c918b128b8b787c)}, {LL(0x59645f6203040fff), LL(0xb9050eab0e0eafff)}, {LL(0x0d4d5b1b2b648720), LL(0xf97d9e989e9efc20)},
			{LL(0x4a2ba9c8900395d1), LL(0x0273e5eee5e5edd1)}, {LL(0xfe37e0290f143385), LL(0x1811364236365685)}, {LL(0x6fdf1cacd8e33e58), LL(0x03ab769976767a58)}, {LL(0x0b99ac3eb27b3f49), LL(0x521551a15151da49)},
			{LL(0x93a41027a04365fa), LL(0xc32305cc05058ffa)}, {LL(0x3bf618d5f083b687), LL(0x43d3e6aae6e62987)}, {LL(0x024ceca277b46827), LL(0xd89945174545a327)}, {LL(0xb1a22437abe642e8), LL(0x053e9a689a9a8ee8)},
			{LL(0x8da6bd96182078f4), LL(0x81287011707031f4)}, {LL(0xaa1ee4502774bb5a), LL(0x5869a671a6a6055a)}, {LL(0x9b5726eabfd60666), LL(0x2502d290d2d24666)}, {LL(0xc4e78ead25cdb1f0), LL(0x376f13021313cff0)},
			{LL(0xfaaffbaee1bfe3cb), LL(0x6be0bc6cbcbcd3cb)}, {LL(0x1e02adb1b8631d0e), LL(0x420b75dd7575be0e)}, {LL(0xe6e1babd2e6896e2), LL(0xf1728ca68c8ccee2)}, {LL(0xf25ccd63fe2a8057), LL(0x8dc16b306b6b1a57)},
			{LL(0x672c2a61c7765dc4), LL(0xe58aa1c5a1a1b3c4)}, {LL(0x07f2817443458c9b), LL(0xc7c50cd30c0c969b)}, {LL(0x3d22eff0699c0eee), LL(0xe8bb299329290fee)}, {LL(0xb084526671bc761a), LL(0x6993598259593e1a)},
			{LL(0xe58b204e8386ca37), LL(0x45460a5b0a0add37)}, {LL(0x134ff6aa93079a2e), LL(0xbb76eb45ebeb422e)}, {LL(0x06d4f725991fb869), LL(0xab68cf39cfcf2669)}, {LL(0xe0354d98b7772e8b), LL(0x5a1a439f4343e88b)},
			{LL(0xa43925b8a1fe60af), LL(0x1520be14bebeeaaf)}, {LL(0xebace1a6050c11c2), LL(0x080f123e121232c2)}, {LL(0x6d93f00eaf57567f), LL(0xdb32338e3333d97f)}, {LL(0x5e96de1640418364), LL(0x7ec0027802023964)},
			{LL(0xd05af973f58fa745), LL(0x4bdcf494f4f41b45)}, {LL(0xae86ffd7c9df6b14), LL(0x2b982c5f2c2c8014)}, {LL(0x9ca5a79efc938afd), LL(0xe2c7de43deded0fd)}, {LL(0xe279a13ac0c346ac), LL(0x8283068806064bac)},
			{LL(0xb87764ab6e291586), LL(0x8fb28ede8e8ef786)}, {LL(0x7c90ea064be4a476), LL(0xb8dd9ddc9d9d3876)}, {LL(0x5cda32b437f5eb43), LL(0xa659476f47479a43)}, {LL(0xfd5d7adaa2fa6f50), LL(0xac25b0bfb0b04550)},
			{LL(0x9fcf3d6d517dd628), LL(0x56f358be5858c328)}, {LL(0x6ef96afd02b90aaa), LL(0x6f06b573b5b5caaa)}, {LL(0xe35fd76b1a99725e), LL(0xee2ec562c5c5fb5e)}, {LL(0x91e8fc85d7f70ddd), LL(0x1bba40db40402cdd)},
			{LL(0x0abfda6f68210bbb), LL(0x3eb8924b92926abb)}, {LL(0x5fb0a8479a1bb796), LL(0x126dc192c1c18996)}, {LL(0xcac04f45a3476a05), LL(0x7a260b670b0b2005)}, {LL(0x24d2c33592ba9f7b), LL(0x6d75509d5050277b)},
			{LL(0x4867456ae7b7fdf6), LL(0xdaeaa0f9a0a04ef6)}, {LL(0xd98fb9ef3040f02b), LL(0xc150e022e0e0622b)}, {LL(0x11031a08e4b3f209), LL(0x63efae52aeaee109)}, {LL(0x216caee3a64b7bc7), LL(0x72291959191912c7)},
			{LL(0x961a7df194b28146), LL(0xdc7f4c084c4cba46)}, {LL(0x58422933d95e3b0d), LL(0xd5a8cd41cdcd1f0d)}, {LL(0xa187486e950f8413), LL(0x0a7cf7d0f7f7df13)}, {LL(0x94569153e306e961), LL(0x04e6091f09091961)},
			{LL(0x83817c7e9eaaa301), LL(0xcc6168746868de01)}, {LL(0xbea3938ef736adef), LL(0x24da41e74141d1ef)}, {LL(0x6cb5865f750d628d), LL(0xb79ff064f0f0698d)}, {LL(0x8fea51346f9410d3), LL(0x59b13506353592d3)},
			{LL(0x05be6dd634f1e4bc), LL(0x1f5c49c4494935bc)}, {LL(0x4766f2d3bb6712f1), LL(0xfb0e7b767b7b11f1)}, {LL(0x2f4b6f0b20c1a032), LL(0x3f60013c0101fd32)}, {LL(0x269e2f97e50ef75c), LL(0xb5ec158a1515845c)},
			{LL(0xc5c1f8fcff978502), LL(0x5bc2d0e8d0d07f02)}, {LL(0x5dfc44e5edafdfb1), LL(0xcaf4848584842ab1)}, {LL(0x71ddb11d60802356), LL(0x41a003440303c456)}, {LL(0x7edc06a43c50cc51), LL(0x6044d8cbd8d89b51)},
			{LL(0x3f6e03521e2866c9), LL(0x30226c846c6cacc9)}, {LL(0x452a1e71ccd37ad6), LL(0x23973e613e3eb2d6)}, {LL(0x04981b87eeabd04e), LL(0x73f18a2e8a8a854e)}, {LL(0xbcef7f2c8082c5c8), LL(0xfc4304f0040472c8)},
			{LL(0x39baf4778737dea0), LL(0x9b4aa3bda3a38aa0)}, {LL(0x690beb8941fc8631), LL(0xa8c3b9a0b9b95c31)}, {LL(0xc88ca3e7d4f30222), LL(0xa2bf4e704e4e8322)}, {LL(0xf37abb322470b4a5), LL(0xe16ca8daa8a8aaa5)},
			{LL(0xe8c67b55a8e24d17), LL(0xbc3b94c394942117)}, {LL(0xacca1375be6b0333), LL(0xf301694869692333)}, {LL(0x9a7150bb658c3294), LL(0x49af117a1111f694)}, {LL(0xf7e2a0b5cadb64eb), LL(0x929d22f422222feb)},
			{LL(0x7db69c5791be9084), LL(0xd4705e365e5e8884)}, {LL(0x928266767a195108), LL(0xaf8ec626c6c63f08)}, {LL(0xc78d145e8823ed25), LL(0x835b95ff9595dc25)}, {LL(0xd5e494a5c17e43f9), LL(0x5480bd50bdbd2ef9)},
			{LL(0xfb898dff3be5d739), LL(0x074d7f867f7f6339)}, {LL(0x17d7ed2d7dac4a60), LL(0xc887616b6161c760)}, {LL(0x1bbcc0678c92f9b2), LL(0x5d573c193c3c8bb2)}, {LL(0x80ebe68d3344ffd4), LL(0x7855ee89eeeecdd4)},
			{LL(0x8a543ce25b65f46f), LL(0x46ed7cc27c7ca76f)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x4f95c41ea4f2716d), LL(0x1d2fac2aacacd86d)}, {LL(0xba3b8809199d7da1), LL(0x572bcbc9cbcb54a1)},
			{LL(0x220634100ba52712), LL(0xc61d9fa49f9f0112)}, {LL(0x5b28b3c074b067d8), LL(0x619c4bbc4b4b0cd8)}, {LL(0x7ffa70f5e60af8a3), LL(0x0ce91b211b1b2ba3)}, {LL(0x70fbc74cbada17a4), LL(0x2d0dc0aec0c074a4)},
			{LL(0xb3eec895dc522acf), LL(0xdda7df7fdfdf2dcf)}, {LL(0x8473fd0addef2f9a), LL(0x0ba464a76464489a)}, {LL(0xf5ae4c17bd6f0ccc), LL(0x4a0467e367678ccc)}, {LL(0x389c82265d6dea52), LL(0xf7e7605760603a52)},
			{LL(0x3c0499a1b3c63a1c), LL(0x8416ea79eaeabf1c)}, {LL(0x90ce8ad40dad392f), LL(0x7717833183839c2f)}, {LL(0xee128c7031fdf57e), LL(0x17535bfa5b5b077e)}, {LL(0x9570e702395cdd93), LL(0x684bcaf5cacaa993)},
			{LL(0xdf5b4ecaa95f4842), LL(0x6a382f1b2f2f4442)}, {LL(0x983dbc1912385ab3), LL(0x9136546d545455b3)}, {LL(0x7545aa9a8e2bf318), LL(0x3251896a89894118)}, {LL(0x4cff5eed091c2db8), LL(0xa91b2ad72a2acbb8)},
			{LL(0x1f24dbe0623929fc), LL(0x2ea6b637b6b60efc)}, {LL(0x53db850d6b250444), LL(0x87bd9ce09c9cc544)}, {LL(0xafa0898613855fe6), LL(0x4735efb5efef30e6)}, {LL(0xef34fa21eba7c18c), LL(0x7bfe98109898b78c)},
			{LL(0xa2edd29d38e1d8c6), LL(0xbe48712d7171ccc6)}, {LL(0x519769af1c916c63), LL(0x5f24d9f7d9d96663)}, {LL(0x43fee95455ccc2bf), LL(0x88fff158f1f194bf)}, {LL(0x01267651da5a34f2), LL(0x6cadc3eac3c3b0f2)},
			{LL(0xd68e0e566c901f2c), LL(0xe0b43bad3b3b3d2c)}, {LL(0x6446b0926a980111), LL(0x51be27382727a011)}, {LL(0xb650a543e8a3ce73), LL(0xc2fb96bb96961873)}, {LL(0x126980fb495daedc), LL(0xd7db28af2828f2dc)},
			{LL(0xd8a9cfbeea1ac4d9), LL(0xadfd23c82323d2d9)}, {LL(0x16f19b7ca7f67e92), LL(0xa42aa281a2a27792)}, {LL(0xf4883a466735383e), LL(0x26a9a409a4a43c3e)}, {LL(0x0c6b2d4af13eb3d2), LL(0x95d05d725d5d4cd2)},
			{LL(0xec5e60d246499d59), LL(0xcfca1eed1e1ea459)}, {LL(0x3ad06e842ad98275), LL(0x2f7e254025259975)}, {LL(0xf6c4d6e410815019), LL(0xfe30e11ee1e19f19)}, {LL(0x973c0ba04ee8b5b4), LL(0xb0d28fe28f8f0ab4)},
			{LL(0xb776d31232f9fa81), LL(0xae5655515555a881)}, {LL(0x6a61717aec12dae4), LL(0x1cf73f5d3f3f4fe4)}, {LL(0xe9e00d0472b879e5), LL(0xd0965729575791e5)}, {LL(0x9d83d1cf26c9be0f), LL(0x8e6a1da91d1d600f)},
			{LL(0x159b018f0a182247), LL(0x101e247c24246447)}, {LL(0x08f336cd1f95639c), LL(0xe621d75cd7d7c99c)}, {LL(0x5a0ec591aeea532a), LL(0x0d3188568888bc2a)}, {LL(0xab389201fd2e8fa8), LL(0x34c4659b6565b5a8)},
			{LL(0x299f982eb9de185b), LL(0x9408ce05cecedb5b)}, {LL(0xa9747ea38a9ae78f), LL(0xec5d208c2020168f)}, {LL(0x4941333b3dedc904), LL(0xb64763136363fe04)}, {LL(0xb53a3fb0454d92a6), LL(0x76cf104610100ba6)},
			{LL(0x35d1d93d76096d72), LL(0x0e9afecffefec672)}, {LL(0x893ea611f68ba8ba), LL(0xf2d9fa3ffafab4ba)}, {LL(0xea8a97f7df562530), LL(0x64a2d1d4d1d18230)}, {LL(0xc159e37b113c554c), LL(0x28335ac65a5afa4c)},
			{LL(0xf136579053c4dc82), LL(0x39f5edcdeded0982)}, {LL(0x409473a7f8229e6a), LL(0x3ccb77a57777876a)}, {LL(0xa675c91ad64a0888), LL(0xcdb9fb03fbfb4988)}, {LL(0x3149c2ba98a2bd3c), LL(0x7d6b74e17474433c)},
			{LL(0x09d5409cc5cf576e), LL(0x8a8c14b61414796e)}, {LL(0xd4c2e2f41b24770b), LL(0x382d7eba7e7e9e0b)}, {LL(0xcd32ce31e002e69e), LL(0xbde307b40707b69e)}, {LL(0x85558b5b07b51b68), LL(0x6709a74da7a7f868)},
			{LL(0x18d65a94217ca567), LL(0xe963bae4baba9867)}, {LL(0xe4ad561f59dcfec5), LL(0x29ebc9b1c9c96dc5)}, {LL(0xb95112fab4732174), LL(0xe31f4d344d4d4774)}, {LL(0x1a9ab63656c8cd40), LL(0x31fafff3ffff3b40)},
			{LL(0xdbc3554d47f4980c), LL(0x19c9a535a5a5c10c)}, {LL(0x2c21f5f88d2ffce7), LL(0x8b5487c18787eee7)}, {LL(0x8b724ab3813fc09d), LL(0x2a40bf28bfbf179d)}, {LL(0xd33063805861fb90), LL(0xffe8726972720890)},
			{LL(0xa753bf4b0c103c7a), LL(0xa11438e93838f97a)}, {LL(0xbdc9097d5ad8f13a), LL(0x90eec71ac7c7c23a)}, {LL(0x204ad8b27c114f35), LL(0x1e84dab3dadaa235)}, {LL(0xa3cba4cce2bbec34), LL(0xd2e5b2c7b2b27c34)},
			{LL(0x4eb3b24f7ea8459f), LL(0x71826fc06f6f689f)}, {LL(0xd17c8f222fd593b7), LL(0x2771377e3737abb7)}, {LL(0x5665e8db5fd4e0f8), LL(0x98e1d524d5d5f0f8)}, {LL(0x871967f97001734f), LL(0xbf90e25ae2e25b4f)},
			{LL(0xc3150fd966883d6b), LL(0xf0aa1fd11f1f596b)}, {LL(0x72b72beecd6e7f83), LL(0xf59485b98585d783)}, {LL(0x60deab158433d15f), LL(0x224fad16adad255f)}, {LL(0x36bb43cedbe731a7), LL(0xbaae78327878d5a7)},
			{LL(0xf9c5615d4c51bf1e), LL(0xdfd43a913a3ac01e)}, {LL(0xe7c7ccecf432a210), LL(0x9ddf4f4c4f4f7e10)}, {LL(0x682d9dd89ba6b2c3), LL(0xc46e7a4a7a7aecc3)}, {LL(0x629247b7f387b978), LL(0xfad6e801e8e88678)},
			{LL(0x550f7228f23abc2d), LL(0x2cd553d95353e32d)}, {LL(0xff119678d54e0777), LL(0x74bcf5a8f5f5e677)}, {LL(0x6560c6c3b0c235e3), LL(0x3d13e4d2e4e410e3)}, {LL(0x34f7af6cac535980), LL(0x62373d253d3d7680)}
		}, {
			{LL(0xfb5673f66e45af0a), LL(0xb5642c66c8d51c47)}, {LL(0x08d95b24e56852ca), LL(0x0a2f6bac5ee01eeb)}, {LL(0xcbc56a2e75f680f3), LL(0x89869508cfd05878)}, {LL(0x41b5ae0670cb4e17), LL(0xc067ebddce108371)},
			{LL(0x384a42fcfedb7d33), LL(0x36cdd2c259e55ad4)}, {LL(0xb388b531afeb285f), LL(0xeff099e32339f2f8)}, {LL(0x1f307492839bb1a3), LL(0x682036be40b7b805)}, {LL(0x88d7a221ad273b37), LL(0xaa9a14fef7f83d43)},
			{LL(0x32347fd1b3a9da2a), LL(0xdf99d345f13da275)}, {LL(0x7cc0130d492981c9), LL(0x6380d8bdc399a514)}, {LL(0x5c22bc9d5b4a0a67), LL(0x4b3cb748789fdd3e)}, {LL(0x02a76609a81af5d3), LL(0xe37b6a2bf638e64a)},
			{LL(0xecbf5c4008b64c63), LL(0xd76b7174d682baa9)}, {LL(0x12d6d041a1ca5184), LL(0xf725bcb04a3bda5f)}, {LL(0x7b588af3260ac6f7), LL(0x15d1533461cd3fef)}, {LL(0x5f37e971a75d643c), LL(0x389be897f5bb4851)},
			{LL(0xc1bb5703388427ea), LL(0x60d2948f6708a0d9)}, {LL(0x048dcc1293342965), LL(0x05f6d4562f700f94)}, {LL(0x76be2e20045b26d0), LL(0x8ad4d93a6b415db5)}, {LL(0x6cb1a54540f9259e), LL(0x77de0e267f9a9901)},
			{LL(0x26c8058b294d5718), LL(0xce31d188624e91f4)}, {LL(0x0f41c2da8a4b15f4), LL(0x7c7ee025fcb48410)}, {LL(0x0c549736765c7baf), LL(0x0fd9bffa7190117f)}, {LL(0xe0ebcb767eea37cc), LL(0xd8b2ce8ea712abd6)},
			{LL(0xe6c1616d45c4eb7a), LL(0x3e3f70f37e5a4208)}, {LL(0xd65278b55e77c483), LL(0x02ddc99d795f0637)}, {LL(0x18a8ed6cecb8f69d), LL(0x1e71bd37e2e322fe)}, {LL(0x8efd083a9609e781), LL(0x4c17aa832eb0d49d)},
			{LL(0x54fbe7b9be2258ad), LL(0x4113dce4267fc3d5)}, {LL(0xe4660764edde1ea9), LL(0xdd441ad88862a442)}, {LL(0xacb8c1a32c7099fc), LL(0x87d0af5d638e4afd)}, {LL(0x698e5ab287c09773), LL(0xe2f4ef842bf6e5b0)},
			{LL(0xee183a49a0acb9b0), LL(0x34101b5f20ba5ce3)}, {LL(0xd913ba6fd43cd177), LL(0x7ea329b885eb8227)}, {LL(0xf702e4c01819d4a5), LL(0xbabd939cb9450d38)}, {LL(0xb9f6881ce2998f46), LL(0x06a498648be10a59)},
			{LL(0x853106f28f76db10), LL(0x359f9ef0fd745f19)}, {LL(0x1e824777d7962a2b), LL(0xf8fc034a3babcb20)}, {LL(0x66cf98680d8b8287), LL(0x9e8a0fa1d74261a0)}, {LL(0x309319d81bb32ff9), LL(0x3ce2b96e0705443f)},
			{LL(0xd5472d59a260aad8), LL(0x717a9642f47b9358)}, {LL(0xa24b309cf2361780), LL(0x6b727a8ce426bdc8)}, {LL(0xfcceea080166e834), LL(0xc335a7ef6a8186bc)}, {LL(0x60e5327336a55e31), LL(0x7807b1dc0e0a887e)},
			{LL(0xffdbbfe4fd71866f), LL(0xb092f830e7a513d3)}, {LL(0x6e16c34ce8e3d04d), LL(0x94a5640d89a27f4b)}, {LL(0xea95f65b339890d5), LL(0x31e6cf090fca5377)}, {LL(0x831bace9b45807a6), LL(0xd312208d243cb6c7)},
			{LL(0x154e49bfcee916ba), LL(0x81743739e86f40a4)}, {LL(0xc00964e66c89bc62), LL(0xf00ea17b1c14d3fc)}, {LL(0xdc2c45981305639a), LL(0xeb89c81ad187fe96)}, {LL(0xb4102ccfc0c86f61), LL(0x99a1126a816d6803)},
			{LL(0xeb27c5be67950b5d), LL(0xa13afafd74d62052)}, {LL(0xc8d03fc289e1eea8), LL(0xfa21cad742f4cd17)}, {LL(0x84833517db7b4098), LL(0xa543ab0486682c3c)}, {LL(0xe5d43481b9d38521), LL(0x4d982f2cf37ed767)},
			{LL(0xa774cf6b350fa56d), LL(0xfe589b2eb04ac179)}, {LL(0x448a51f1b7f2fcfa), LL(0x554d0a7f9a7cffc0)}, {LL(0xbae3ddf01e8ee11d), LL(0x7503c7bb06c59f36)}, {LL(0x6242547a9ebfabe2), LL(0x9b7cdbf7f8326e34)},
			{LL(0xf23d1b37df206648), LL(0x2f97723eed297189)}, {LL(0x53637e47d1011f93), LL(0x3742576d842b592e)}, {LL(0x9a0172600ced6ab3), LL(0x5dbfa84ebdc3e71c)}, {LL(0x1071b64809d0a457), LL(0x145ed69bbc033c15)},
			{LL(0x1d97129b2b814470), LL(0x8b5b5c95b68f5e4f)}, {LL(0x0a7e3d2d4d72a719), LL(0xe9540187a8d8f8a1)}, {LL(0xd36d8742994e766e), LL(0x97f7283f2d337a86)}, {LL(0xfd7cd9ed556b73bc), LL(0x53e9921b119df599)},
			{LL(0x7381d1d7c362943d), LL(0x1ffe38983f2d2104)}, {LL(0xf1284edb23370813), LL(0x5c302de1600de4e6)}, {LL(0x4a79a0ce69b47286), LL(0xb9efdfae1dd408f5)}, {LL(0xa15e65700e2179db), LL(0x18d52553690228a7)},
			{LL(0xaa926bb8175e454a), LL(0x615d1120bac6a323)}, {LL(0x74194829ac41d303), LL(0x69afb3119d79bbff)}, {LL(0x14fc7a5a9ae48d32), LL(0x11a802cd93733381)}, {LL(0x39f87119aad6e6bb), LL(0xa611e73622f929f1)},
			{LL(0x9540b0ba86a67f47), LL(0x21c1486b4177630c)}, {LL(0x5bba256334694d59), LL(0x3d6d3cc1dacb47c5)}, {LL(0x565c81b01638ad7e), LL(0xa268b6cfd047259f)}, {LL(0x8a70c428053dcee4), LL(0x49e17ed501c0db09)},
			{LL(0xdf391074ef120dc1), LL(0x982e97c55ca36bf9)}, {LL(0xcdefc0354ed85c45), LL(0x6f0b2b751698b1a6)}, {LL(0x51c4184e791bea40), LL(0xd4393d467213bf64)}, {LL(0x341ed5ca8887069c), LL(0x39146d3828754bab)},
			{LL(0xf6b0d7254c144f2d), LL(0x2a61a668c2597e1d)}, {LL(0x8de85dd66a1e89da), LL(0x3fb0f55ca39441f2)}, {LL(0x6a9b0f5e7bd7f928), LL(0x9153b05ba6d270df)}, {LL(0xf38f28d28b2dfdc0), LL(0xbf4b47ca963502ac)},
			{LL(0xf5a582c9b0032176), LL(0x59c6f9b74f7deb72)}, {LL(0x11c385ad5ddd3fdf), LL(0x8482e36fc71f4f30)}, {LL(0x9d99eb9e63ce2d8d), LL(0x2bee23c71f977de7)}, {LL(0x75ab7bccf84c488b), LL(0xf97386e5e665c8da)},
			{LL(0x191ade89b8b56d15), LL(0x8ead88c399ff51db)}, {LL(0x031555ecfc176e5b), LL(0x73a75fdf8d24956f)}, {LL(0x7094843b3f75fa66), LL(0x6c596747b209b46b)}, {LL(0x7233e232976f0fb5), LL(0x8f220d6c44315221)},
			{LL(0x3aed24f556c188e0), LL(0xd5b6b8e9afddbc9e)}, {LL(0x8bc2f7cd5130556c), LL(0xd93d4b217adca82c)}, {LL(0x33864c34e7a441a2), LL(0x4f45e6b18a21d150)}, {LL(0xc623cefd57a760d4), LL(0x16831f06c55c3a22)},
			{LL(0x2fa36d4a98289e5a), LL(0x54c28fd047b2fc3a)}, {LL(0x896591c4f92aa0bf), LL(0x3a46210a8ce44e66)}, {LL(0xbe6e11e28dbac878), LL(0x70f513ed29b590a2)}, {LL(0xcefa95d9b2cf321e), LL(0x1cac74aa9bbc24c9)},
			{LL(0xc484a8f4ffbd9507), LL(0xf5f8752d3364dc68)}, {LL(0xfae440133a483482), LL(0x25b81992b3c96f62)}, {LL(0x3b5f171002cc1368), LL(0x456a8d1dd4c1cfbb)}, {LL(0xdd9e767d4708f812), LL(0x7b55fdeeaa9b8db3)},
			{LL(0x770c1dc55056bd58), LL(0x1a08ecce105d2e90)}, {LL(0xc5369b11abb00e8f), LL(0x652440d94878af4d)}, {LL(0x165b1c5332fe78e1), LL(0xf2d368e6654bd5cb)}, {LL(0xa4619a87c918cb36), LL(0x8dffc4f13d6e5416)},
			{LL(0xad0af246787d0274), LL(0x170c9aa9189239d8)}, {LL(0xd8a1898a80314aff), LL(0xee7f1c4cfef7f102)}, {LL(0xb70579233cdf013a), LL(0xea064db50c49fd6c)}, {LL(0x92d82944e9853879), LL(0x5790c3e2e323f9f7)},
			{LL(0x496cf52295a31cdd), LL(0xca48807190f09d9a)}, {LL(0x6468fe61a5917754), LL(0x7df1658a217a87ea)}, {LL(0x91cd7ca815925622), LL(0x24379c3d6e076c98)}, {LL(0x9c2bd87b37c3b605), LL(0xbb321633648b0ec2)},
			{LL(0x01b233e5540d9b88), LL(0x90dc35f47b1c7325)}, {LL(0xe83290529b826506), LL(0xd29da522f9f2b53d)}, {LL(0xa0ec56955a2ce253), LL(0x880910a7121e5b82)}, {LL(0xbb51ee154a837a95), LL(0xe5dff24f7dd9ec13)},
			{LL(0xb5a21f2a94c5f4e9), LL(0x097d279efa711b26)}, {LL(0x2989c751a30642ec), LL(0xb24f31ad9efa15e4)}, {LL(0xe3fe9e9a82fd5997), LL(0xab1591512a363eb9)}, {LL(0x5a0816866064d6d1), LL(0xadb10935a1d734e0)},
			{LL(0x17e92fb666f3e369), LL(0x620f5d121e57a6ee)}, {LL(0x63f0679fcab2306a), LL(0x0ba0ee03832e1d11)}, {LL(0x25dd5067d55a3943), LL(0xbd968e57ef6a049b)}, {LL(0x7d7220e81d241a41), LL(0xf35ced49b885d631)},
			{LL(0x20e2af9012638bae), LL(0x28bc6ff5bb06782a)}, {LL(0x1364e3a4f5c7ca0c), LL(0x67f989443127a97a)}, {LL(0x0ef3f13fde468e7c), LL(0xeca2d5d187a8f735)}, {LL(0x9f3e8d97cbd4d85e), LL(0xc89549ece9af9bad)},
			{LL(0xe159f8932ae7ac44), LL(0x486efb7adc0ed8f3)}, {LL(0x5549d45cea2fc325), LL(0xd1cfe9105d63b0f0)}, {LL(0x8f4f3bdfc2047c09), LL(0xdccb9f7755aca7b8)}, {LL(0xd1cae14b315483bd), LL(0x748c4214db0b9ccc)},
			{LL(0x40079de324c6d59f), LL(0x50bbde29b50cf054)}, {LL(0x82a99f0ce0559c2e), LL(0x43ce15795f20c5e2)}, {LL(0x52d14da2850c841b), LL(0xa79e6299ff372a0b)}, {LL(0xb23a86d4fbe6b3d7), LL(0x7f2cac17582581dd)},
			{LL(0x591d436a9c73b88a), LL(0xde1656ea2cf3a18f)}, {LL(0x3fd2db0291f83a0d), LL(0x409c594bfbb1c02f)}, {LL(0xd4f51ebcf66d3150), LL(0xe1a6a3b68f67e07d)}, {LL(0x79ffecfa8e103324), LL(0xf6aa391f97f5d9a5)},
			{LL(0xe773528811c970f2), LL(0xaee345070546312d)}, {LL(0xefaa09acf4a12238), LL(0xa4cc2eab5ba62fc6)}, {LL(0xca7759cb21fb1b7b), LL(0x195aa0fcb4cc2b5d)}, {LL(0x479f041d4be592a1), LL(0x26ea55a017586aaf)},
			{LL(0xa5d3a9629d1550be), LL(0x1d23f10546722733)}, {LL(0xafad944fd067f7a7), LL(0xf477f082eeaadf92)}, {LL(0xa8350db1bf44b099), LL(0x82267b0b4cfe4569)}, {LL(0x936a1aa1bd88a3f1), LL(0xc74cf616983f8ad2)},
			{LL(0xed0d6fa55cbbd7eb), LL(0x47b74480ad9ec98c)}, {LL(0xc31c310a909ed239), LL(0x83a9fea491304693)}, {LL(0x2a9c92bd5f112cb7), LL(0xc1e86e7213de808b)}, {LL(0x9655e5567ab1111c), LL(0x526617b4cc53f663)},
			{LL(0x2cb638a6643ff001), LL(0x2765d00fca966955)}, {LL(0x5d908f780f4791ef), LL(0xdbe082bc0383ae1b)}, {LL(0xe24cad7fd6f0c21f), LL(0x3bc9a4a5512a4d9c)}, {LL(0x7fd546e1b53eef92), LL(0x102787624ebd307b)},
			{LL(0x7e677504e133741a), LL(0x80fbb29635a1435e)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x3e60e8e7c5f5a185), LL(0xd0406cbf80adb30a)}, {LL(0xc791fd1803aafb5c), LL(0x865f2af2be404907)},
			{LL(0x053ffff7c739b2ed), LL(0x952ae1a2546c7cb1)}, {LL(0x3cc78eee6def5456), LL(0x333b069476955540)}, {LL(0x879660fb276c2ec3), LL(0xd6e4f4db0b4cb953)}, {LL(0x677dab8d5986190f), LL(0x0e563a55ac5e1285)},
			{LL(0x9914278cf0fa04e8), LL(0x2e18f79130e77273)}, {LL(0xab20585d4353dec2), LL(0xf18124d4c1dad006)}, {LL(0xf9f115ffc65f5ad9), LL(0x561f464d3eedfa0d)}, {LL(0xd2dfb4a7cd43ede6), LL(0x072b1dcb562f09a3)},
			{LL(0x062aaa1b3b2edcb6), LL(0xe68dbe7dd948e9de)}, {LL(0xa9873e54eb492b11), LL(0x12fa4eff37e2364c)}, {LL(0x1bbdb88010af98c6), LL(0x6dd6e2e86fc7b791)}, {LL(0x48dec6c7c1ae8755), LL(0x5a94b585ebeceebf)},
			{LL(0x97e7d6b32ebc8a94), LL(0xc2ba2240b74f8546)}, {LL(0xc2ae02efc49349b1), LL(0x1375cb50ea2c35b6)}, {LL(0x8624531e7361b54b), LL(0x4638c12f7050ca76)}, {LL(0x6157019662a8c5b9), LL(0xe8db84287516fb5b)},
			{LL(0x36b9b3c3209df34f), LL(0xda6f0713de4dade1)}, {LL(0x57eeb255423536f6), LL(0x32b4833bab5b56ba)}, {LL(0xf09a7d3e773a939b), LL(0xccec18151b1197c3)}, {LL(0x2e115eafcc2505d2), LL(0xc41eba243cae8f1f)},
			{LL(0x7aeab91672075d7f), LL(0x850d66c01ad14cca)}, {LL(0x3d75bd0b39e2cfde), LL(0xa3e733600d892665)}, {LL(0x81bccae01c42f275), LL(0x30694aa6d204508d)}, {LL(0x35ace62fdc8a9d14), LL(0xa9c858cc5369388e)},
			{LL(0xc9620c27ddec7520), LL(0x6afdff2339e8be32)}, {LL(0x65dacd84f19cecdc), LL(0xed2d507e5a66f4cf)}, {LL(0x784ddf1fda1da8ac), LL(0x66760cebece9aa80)}, {LL(0xbcc977eb25a03dab), LL(0x938e79c6df8d76e8)},
			{LL(0x1c25217e7f8cdff8), LL(0x1b876961cd932d6a)}, {LL(0x683c6957d3cd0cfb), LL(0x7228da7050ea9695)}, {LL(0xcc5df3d01ad5c7cd), LL(0xffd71e816d84c283)}, {LL(0xbfdc2207d9b753f0), LL(0xe029261952a9e387)},
			{LL(0x7126b7de6b7861ee), LL(0xfc8552b3c915c74e)}, {LL(0xb844bbf9b69414ce), LL(0x9678ad90f0fd797c)}, {LL(0xa6c6fc8e61023ee5), LL(0x6e84aedacb56b25c)}, {LL(0x2245c999ba797e7d), LL(0xcbc705de4d3e9e60)},
			{LL(0x4de13930069735b8), LL(0xcfbe5427bf80920e)}, {LL(0xb09de0dd53fc4604), LL(0x9c57c63cae1d6797)}, {LL(0x907f4f4d419fcdaa), LL(0xb4eba9c9151b1fbd)}, {LL(0x23f7fa7cee74e5f5), LL(0x5b1b302a3622ed45)},
			{LL(0x370b8026749068c7), LL(0x4ab332e7a551dec4)}, {LL(0x6b293cbb2fda62a0), LL(0x018f85afddce03fa)}, {LL(0x096b68c1b165c942), LL(0x9af35e5825fc6dce)}, {LL(0x246f63828157a2cb), LL(0x2d4abba3947677be)},
			{LL(0x31212a3d4fbeb471), LL(0xac3e8c9a7c19371a)}, {LL(0x4ef46cdcfa805be3), LL(0xbc190bf832a40761)}, {LL(0x800ef905484f69fd), LL(0xa0b57f52a91823a8)}, {LL(0x277a366e7d40cc90), LL(0x5eede47c1952e2d1)},
			{LL(0x58af708fc87e2302), LL(0x4eca631e57efd2aa)}, {LL(0x21509c75466e1026), LL(0xb8605a01c01a0b0f)}, {LL(0xcf48a63ce6c2a996), LL(0x8c70415ee0a057ec)}, {LL(0x94f2835fd2abe4cf), LL(0xb11d7d9f3a6b1029)},
			{LL(0x2d040b4330326b89), LL(0xb7b9e5fbb18a1a70)}, {LL(0xde8b2391bb1f9649), LL(0x08f2a23127bf18dc)}, {LL(0xae1fa7aa846a6c2f), LL(0x64abc57695b6acb7)}, {LL(0x8c5a6e333e131252), LL(0xaf6cc0a8d88832d7)},
			{LL(0x5e85da94f350ffb4), LL(0xa847dd638ea73b74)}, {LL(0xa3f90379a63b8c08), LL(0xfbae4f789f3aceed)}, {LL(0x2b2ea1580b1cb73f), LL(0x51345b8668c2f3ae)}, {LL(0x9e8cbe729fd943d6), LL(0x58497c1892b3e888)},
			{LL(0xbd7b440e71ada623), LL(0x03524c32a49105cd)}, {LL(0x1a0f8b6544a2034e), LL(0xfd0ad71c14dbc4b4)}, {LL(0x98a61469a4f79f60), LL(0xbec4c2654bfb0156)}, {LL(0xd7e04b500a7a5f0b), LL(0x9201fc6902437512)},
			{LL(0x4312c80fd8d1bbc4), LL(0x231c81f63828653b)}, {LL(0xd078d2ae65591835), LL(0xe45077e0a017efe9)}, {LL(0x4bcb932b3db9e90e), LL(0x2933ea5a66c87bd0)}, {LL(0x283bf4b4f70bd964), LL(0x22930459e5e666c1)},
			{LL(0x9bb3418558e0f13b), LL(0xcd639dbac6df9439)}, {LL(0x4c530ad5529aae30), LL(0x5f6261d3c49ce12b)}, {LL(0x6fa4f0a9bcee4bc5), LL(0x047951f9f2be0c6e)}, {LL(0x4f465f39ae8dc06b), LL(0x2cc53e0c49b87444)},
			{LL(0x0bcc0ec8197f3c91), LL(0x79883473d3c48b84)}, {LL(0x42a0fbea8cdc204c), LL(0xb3c0b4024334161e)}, {LL(0xb6b74ac668d29ab2), LL(0x7ada784177558e49)}, {LL(0xf417b12ce40ebafe), LL(0xc91acc4334619857)},
			{LL(0xfe698c01a97c1de7), LL(0x204ecdc49cb960f6)}, {LL(0x0de6a4d32251e027), LL(0x9f058a0e0a8c625a)}, {LL(0xb12fd33807f1dd8c), LL(0x0c8bf3c8d50114b2)}, {LL(0x079899fe6f23473e), LL(0x76518b89a2549afb)},
			{LL(0x462d37f81fe80929), LL(0xb63660546c44198a)}, {LL(0x45386214e3ff6772), LL(0xc5913f8be1608ce5)}, {LL(0xda06ef83282bbf2c), LL(0x0d04766708cf1748)}, {LL(0xdbb4dc667c2624a4), LL(0x9dd8439373d3646d)},
			{LL(0xe980a3b7cf8ffe8e), LL(0x424190d682eec618)}, {LL(0xf843261a9252c151), LL(0xc6c373b945f18928)}, {LL(0x50762bab2d1671c8), LL(0x44e508b2090fcc41)}, {LL(0x6d0396a014f4be16), LL(0xe7023bd20486ea24)}
		},
		{
			{LL(0x199680c07a0cd5fb), LL(0xfcb5aec91b938711)}, {LL(0x7bce1a17b28ce008), LL(0xee0af2fef8abfc32)}, {LL(0xc077dcb250a2d0cb), LL(0xdd89c7884eefcabd)}, {LL(0x69d642635e1a1041), LL(0x11c01393d33c12c4)},
			{LL(0xa22f46659822e538), LL(0xcf369bbfadd7b19e)}, {LL(0x3ce74a6f116a39b3), LL(0x6eefc0cb2f299770)}, {LL(0x084d567d06c2b71f), LL(0x3168fe0f96fd7835)}, {LL(0xc77379a4c39bf888), LL(0x16aa09c5a389e794)},
			{LL(0xb733bb07e78d3d32), LL(0xfbdfb49f6b267241)}, {LL(0x20f79b37188e997c), LL(0xc4637e3c1d7223d4)}, {LL(0x0f49f36b95fb9f5c), LL(0xfa4b30427b9b551c)}, {LL(0x6ed2e775cd233802), LL(0xdae3ddde3e5a3fed)},
			{LL(0x6a15ccaace4282ec), LL(0x23d7a23875c50316)}, {LL(0x988dd35b6af83b12), LL(0xc5f7fae10dcf0489)}, {LL(0xa52be3730b1bcd7b), LL(0x041555f240b19cb7)}, {LL(0x56f286c5df28bb5f), LL(0x4d3862f35aec9466)},
			{LL(0xd56b21d02f0d08c1), LL(0xe960e8a8881e0962)}, {LL(0xdc670dea59467004), LL(0x7705797f7cb47e19)}, {LL(0x35eb665567214176), LL(0xf08a511cdb83e00b)}, {LL(0xd6a8af19bf559a6c), LL(0xdb7759032ee718b0)},
			{LL(0x9d0b82c319104e26), LL(0x93ceeadf2407373c)}, {LL(0xfe126253a119b40f), LL(0x2e7cd930a5684351)}, {LL(0xa7a917fdebca900c), LL(0x990f8b81841f822b)}, {LL(0xcdbcdb57258812e0), LL(0xbad829b9f1da813d)},
			{LL(0x7f0931c8b1ed5ae6), LL(0x173e8d18b334c0c9)}, {LL(0xa6e86dba9b435fd6), LL(0x3602e459e6488d65)}, {LL(0x8d912e391557e318), LL(0xf11ed5c1cb3ec756)}, {LL(0x75c6933b57feb08e), LL(0xbb4cad64e167a660)},
			{LL(0x7487e97c27777f54), LL(0x1441c2bc8330a92e)}, {LL(0x11dbd6bd7cce62e4), LL(0xcddd50c68d6eff24)}, {LL(0x34aa1c1217a88eac), LL(0x5f873ec4b9d4ef45)}, {LL(0x3da6302861e3f669), LL(0xc1e2af134d7e983e)},
			{LL(0x04c72bdf0361baee), LL(0xf9347fe64b9f3cfb)}, {LL(0x58fa0fe93a5aebd9), LL(0x187e3d694320ce34)}, {LL(0xbe3f973d91c645f7), LL(0x65ba25489f8c053a)}, {LL(0x29fbb70d6ec5e1b9), LL(0x5a06efebe9d854af)},
			{LL(0x57b3fc82afa17485), LL(0xe2350d2b38bb9b28)}, {LL(0x3f24c4a68132ab1e), LL(0x5cf8716089d086a2)}, {LL(0xc3b4527bc0fa4266), LL(0xef9e7623e816db6f)}, {LL(0xd9e15c722aae0530), LL(0x213c6941557c4dac)},
			{LL(0xff531814d1907bd5), LL(0x8171b6e8c73f4c1f)}, {LL(0xfdd1ec9a314126a2), LL(0x1c6b689b03915283)}, {LL(0x9c4af884699981fc), LL(0x3cc3850746503872)}, {LL(0x7101b8e4549f0a60), LL(0x4278d282aaf89a9b)},
			{LL(0xc5f18d2a234aa5ff), LL(0x8bb0d7b66727f908)}, {LL(0xb87a486c7276a26e), LL(0x019484dd10bd275d)}, {LL(0xd8a026355a27caea), LL(0x8e310699372b42e2)}, {LL(0xe506161d3bc43c83), LL(0x4fd3a98a7a55dadc)},
			{LL(0x1d51ab1f796d6f15), LL(0x0581d12f500cbbea)}, {LL(0xe202b30ba8fd14c0), LL(0x84f067c79733f7f5)}, {LL(0xb3f490d8e4ec87dc), LL(0x02ebcb7920b94eba)}, {LL(0xb93b322b02ff6db4), LL(0xae99eb0572ea2813)},
			{LL(0xefc9b4eeddd7d6eb), LL(0xe3a189f62806bc75)}, {LL(0x99cca91c1a71f4c8), LL(0x6afa95396f980bc7)}, {LL(0x60da6e5928516884), LL(0x8fa58244279665bf)}, {LL(0x26b24466fb3e7ee5), LL(0xa04ddfa9924301b3)},
			{LL(0x16df73abeff74aa7), LL(0x06fe9e8b6008d20d)}, {LL(0x82d8dd5280ac7c44), LL(0x0b55e583b0a5924a)}, {LL(0x7040c2a32416c5ba), LL(0xed75bd5ac8af95d5)}, {LL(0x1fd35f9199bc3262), LL(0x989b0f5c94a2a576)},
			{LL(0x5531080c4f7029f2), LL(0x7f2fd358fc1585b4)}, {LL(0xf15b913834e22b53), LL(0xd437e972def3164d)}, {LL(0x5ffeaaffa963c39a), LL(0xd35df324ae46e31d)}, {LL(0xf65f342ea7db0310), LL(0x1f14273f33953b64)},
			{LL(0x669fb108cbe18f1d), LL(0xeb8b23d1a8a747d8)}, {LL(0x151cfd627fafd80a), LL(0x34e92f20c6f1c3df)}, {LL(0x4de6f28b45f533d3), LL(0x2c97124985d10deb)}, {LL(0xab236a5fee699dfd), LL(0x51530a68597dc6e5)},
			{LL(0xdee5f964b9972d73), LL(0xea1fa70cb81a6085)}, {LL(0x0c8a7da205a30df1), LL(0xc85c81e9dd6244ce)}, {LL(0x4ba32ddaa645d44a), LL(0x48b9b3dc0ae02f8c)}, {LL(0xa46a99347b9202a1), LL(0xab183a2a22e693f9)},
			{LL(0x861ff68d83cdc6aa), LL(0xf2619a65fb3aaeb1)}, {LL(0x5b398120aa027974), LL(0x2a698cc2e5d9dfe6)}, {LL(0x2a3839c4fe9d7314), LL(0x68115e404f21457d)}, {LL(0x9546d4be1fd2f939), LL(0xa2a614d0b2fa4f09)},
			{LL(0xa1ecc8ac087a7795), LL(0xfd212a140b2ea04c)}, {LL(0x8a958b2f866ecb5b), LL(0x3a3d1b8c2658ea7f)}, {LL(0x1a550e09ea544756), LL(0xcea21f62bd6a96c3)}, {LL(0xa9a19ed10eb8c08a), LL(0xcc49d41b9dd3d879)},
			{LL(0xea4fe576ae3fa3df), LL(0xb59899c801ce8fc0)}, {LL(0x72c2362dc4c798cd), LL(0x706f63290c018b49)}, {LL(0x9f89764df9c11351), LL(0x0ed434ace0a929a0)}, {LL(0x0586519873e87534), LL(0x5639103e29c833b5)},
			{LL(0x895605e6163659f6), LL(0x082aaa2780a1fbad)}, {LL(0x2c7de6951d2d948d), LL(0x0c3fffd5c010671a)}, {LL(0x641d45862b30d26a), LL(0x7691fda26c095944)}, {LL(0x62589ad7c88035f3), LL(0x12bf5c37e3387b23)},
			{LL(0xd0ed70485ce57df5), LL(0xbf59f896a1d63ad7)}, {LL(0xc136a6f5202b1f11), LL(0x7284a8502cb8c5f3)}, {LL(0xda22d2bbbaf6979d), LL(0x132bd8eaf3855c7e)}, {LL(0x6c5013fb2df26575), LL(0x47f903adfaf42171)},
			{LL(0xbaf8bce292a7ff19), LL(0x9c8e5aaed41339c1)}, {LL(0x59bb75ae4ad32403), LL(0xb77352b12177c17a)}, {LL(0x875e8ccaf3440970), LL(0x5d6cf5bd996da1ff)}, {LL(0xe98c6bbf3e673172), LL(0x878f2863a7379e12)},
			{LL(0xccfda1105501dd3a), LL(0x15d54661938d8e73)}, {LL(0x9ec80c0a8948dc8b), LL(0xa1d95b7482fe26ee)}, {LL(0x805a29dc607d2133), LL(0x964f3bf0740b8cd6)}, {LL(0x50b759943c985cc6), LL(0x2916c366d5ddb601)},
			{LL(0xd1ac0a0f2c6cb22f), LL(0x1054974ec3813599)}, {LL(0xf01aeb7f446be489), LL(0x7b3a86aabca41903)}, {LL(0xac27cf497d50b5be), LL(0x9a70c425b41bebcc)}, {LL(0x2b7943838e14bcce), LL(0xc71c31982d764a33)},
			{LL(0x3e65bee1f1bb64c4), LL(0xf3f51eb8eb8789ec)}, {LL(0x2eff121bfdfcc9fa), LL(0x912521a604be7986)}, {LL(0xfb9433cbd2f1c13b), LL(0x7845c90e8ca070e4)}, {LL(0x849d0203631c9bdd), LL(0x6f7b44163f94b02d)},
			{LL(0x0282f48ee0d15d77), LL(0x9d1ade73c4ae1e9c)}, {LL(0x090c2c3a764b78c5), LL(0x9e6591d7f4aa777b)}, {LL(0x44eadeb133be4b16), LL(0xb2f2839e717b7a90)}, {LL(0x4f640605a5246ea4), LL(0xb18dcc3a417f1377)},
			{LL(0x03c38ec9905892ad), LL(0x3217b1aba6f911d2)}, {LL(0x6f939d32bdaaf7d8), LL(0x75eeb2065c0d30a3)}, {LL(0xe0804785482c49b7), LL(0x19eab9b4539de969)}, {LL(0x2430b0e81bef2392), LL(0x3d5701da56ed1f2f)},
			{LL(0x12185874ec96f049), LL(0xffcae16d2b97eef6)}, {LL(0xad66b50e0dd97a64), LL(0x357dabfdd64ce482)}, {LL(0x7d8bc546513c0791), LL(0x8a24536b779ade55)}, {LL(0xed4b40603d068b9c), LL(0x7ebb5785eca8a2e9)},
			{LL(0x376992db87f01c01), LL(0x6d908f6f1f2dfe97)}, {LL(0xb672c1409704f2e8), LL(0x54d2db4709717d0f)}, {LL(0x93030beffc621ea0), LL(0xc688b5453dcb6d6e)}, {LL(0x47295078a3e6d9bb), LL(0x80e53235d7826b42)},
			{LL(0x8e52a0f0850f71b5), LL(0xc309646a6dc7d684)}, {LL(0x6319e090b809fa29), LL(0xbdb233ef816f746d)}, {LL(0x9407aef96f5b36e3), LL(0x0dab7b08d0ad4047)}, {LL(0xbdfc19f4019ed75a), LL(0x57ad94e3397514e8)},
			{LL(0x73834c6ab44e5717), LL(0xdf620cf16e568407)}, {LL(0x28bacd4a1e4c2e63), LL(0xf50b80338b8f5be1)}, {LL(0xc4b0f76d53c36a25), LL(0x24bdb86e0570f646)}, {LL(0x179e09ec9f7e857d), LL(0xa9f3f153025fdd43)},
			{LL(0x2fbe685c8d750620), LL(0x3e284e7e66e976c8)}, {LL(0xafe44180ed082713), LL(0xa867758e12e2fa1e)}, {LL(0xc97bf08826e9a80e), LL(0x43ec565fba45bdc6)}, {LL(0xb4f035ce77d5af9f), LL(0xc9c80534cddf6393)},
			{LL(0xfad5498ca2780ee1), LL(0xd748a6d6eef77faa)}, {LL(0x43ee7ba7a0876355), LL(0x79d14dd39c1d57b9)}, {LL(0x42af01e0d00eac8f), LL(0xd6dc220bfe4a58f7)}, {LL(0x233415fe88d60bd1), LL(0xf674cf97bb8b3206)},
			{LL(0x5ebfd0b8d9ea0c40), LL(0x7c509cfccc11ec53)}, {LL(0xd26f84c6bc342082), LL(0x224326e56578244b)}, {LL(0xc63203e3b3123752), LL(0xb9a7661dc1dee8da)}, {LL(0x0b8ed8b4969a25b2), LL(0x037f4fa4300469e7)},
			{LL(0xe4476c5a4b4df359), LL(0xe0dec6521802d592)}, {LL(0x27f33e218bb7b13f), LL(0x0f40b071f0140efd)}, {LL(0xc83a8acf566067d4), LL(0xece13987d812b288)}, {LL(0xcbf90406c638f579), LL(0xdef6882c7eeba35a)},
			{LL(0x4860a313361d46e7), LL(0x7aae0277ac193e5e)}, {LL(0x33aeb9048491a6ef), LL(0x94a4f08954b2c26c)}, {LL(0xf71e4e69d752ccca), LL(0xb01948e751c2342a)}, {LL(0xdb63a8fcca7f5847), LL(0xbc26b73291d25330)},
			{LL(0x780d94de22d472a5), LL(0xdc1d43555e52ede0)}, {LL(0x6d1169bc5d7baaaf), LL(0xe8f46c7598a32e3f)}, {LL(0xe8cd11f84eeefea8), LL(0x288247bbc560915c)}, {LL(0x135922339c1f3f93), LL(0x50c78eb549c0e1b8)},
			{LL(0x5d7c5e7149b29eed), LL(0x4e472d576ae8fd81)}, {LL(0xbbb9c6a5e22e30c3), LL(0x33833576b644368f)}, {LL(0x3aa2953ef2dade2a), LL(0x0ac1615ea018b517)}, {LL(0xf857bd0242a95396), LL(0x4a5278a52a596136)},
			{LL(0x88177fa166bf962c), LL(0xa727c5ffe2f6f4e3)}, {LL(0x382061b0120b835d), LL(0x97dbbf2d64b6ab8b)}, {LL(0xa36e3c22e8ab2ae2), LL(0x603bf467cf80bed0)}, {LL(0x794cee99525dbd7f), LL(0x73102c8d3c05e2ae)},
			{LL(0x4e257c42d5ada17e), LL(0x1e80a3e223281c39)}, {LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x109aacfa0c47ad3e), LL(0x62d03f1eef39f06a)}, {LL(0x67decb4fbb6840c7), LL(0x44864c09caf04896)},
			{LL(0xeb0e9f31deb66c05), LL(0x1a95f6106399808e)}, {LL(0x7e484b8fc164953c), LL(0xb833e2c0d163cf87)}, {LL(0x39611bf762824c87), LL(0x38d6d0f506e1a4c5)}, {LL(0xf4ddc0a0470a5e67), LL(0x820ef94cf73b25f8)},
			{LL(0x0645df51e3b0e799), LL(0x642ea1958f312267)}, {LL(0xb1766456043ddaab), LL(0x9ff1150ae4175026)}, {LL(0x774467b5b72fedf9), LL(0x2656731725c9b8fc)}, {LL(0x7a8f6050c2052fd2), LL(0x41079d269afcf37c)},
			{LL(0xb2b5ea9f94654806), LL(0xade6a4a142ee41f4)}, {LL(0xdfa48323c91ee2a9), LL(0x4512c8d4da4d6fcb)}, {LL(0xd42a5b975f84c71b), LL(0x466d8770ea49062c)}, {LL(0x2571caaf6b66ec48), LL(0x925a6e0234ba1061)},
			{LL(0xcf3e2fd9c5594f97), LL(0x27c2f7ca35749fa1)}, {LL(0x8cd0547e65de2cc2), LL(0x5e13ba19a969c818)}, {LL(0x0e08892ce5725086), LL(0x55465f9a19cc5a52)}, {LL(0x46682a3fd36f1661), LL(0x2fe85dedb5d5640c)},
			{LL(0x6b54b6edbecb4d36), LL(0x8cdacde017920c58)}, {LL(0x2d3c9cd26da45b57), LL(0xa332900da2476854)}, {LL(0x3be3ef79825311f0), LL(0xa5cc0e86c24fba59)}, {LL(0xe6c598d4ab9cae2e), LL(0x7dc41821dcaccb0e)},
			{LL(0x924271a88cebd17a), LL(0x6985da9d5f9c6220)}, {LL(0x4921d9544694893d), LL(0xd5a36dafce4e3110)}, {LL(0x8bd4f168f6e70481), LL(0x95307454440fe531)}, {LL(0x32efc343f4186935), LL(0x3ba99f5136e5cd22)},
			{LL(0xaea53bc79d81e8c9), LL(0x076a1a5670b5f550)}, {LL(0x9a0f27d58a296665), LL(0x58ed2492c9611a15)}, {LL(0xfc9096dd41c8e978), LL(0xb366074361c65dcd)}, {LL(0xc2f5283cb0738dbc), LL(0x409319fb8a41d421)},
			{LL(0x51f623d34c11931c), LL(0x861bacbeb78ab94f)}, {LL(0x0acfa2f3e613ea68), LL(0xac72207c525366a9)}, {LL(0x45aba4f6433784cc), LL(0x1dffec46132c75de)}, {LL(0x9b4e5d92faa0a9bf), LL(0xf7e04b4aab36155b)},
			{LL(0xb0371e1174b41571), LL(0x30fc7ad286405f68)}, {LL(0x1e9225d6e935fdb8), LL(0x37966084f6f5aa38)}, {LL(0x21b6e170680756a6), LL(0x6b6e11e47f252c9a)}, {LL(0x416c8f2940563e22), LL(0xe4cb93a058b34925)},
			{LL(0xce7f559eb5d0804d), LL(0x88cf9812572390ef)}, {LL(0x655c3fc15bb91db0), LL(0xd99c927a0e5e560a)}, {LL(0x4ae2579dd6cc1b90), LL(0xe7b4dc0468b720c2)}, {LL(0x76051df2c7a62223), LL(0x895b1ccf479eb7b2)},
			{LL(0x5c3d2436393b5137), LL(0xe14a428f08bff2cf)}, {LL(0x5374d75dacc0ce6b), LL(0x1b0172cd7324a7d3)}, {LL(0x4ca788cc357cfc09), LL(0x839a7d91e78602a5)}, {LL(0xf3d965b6d4337624), LL(0x492d37011a5d08d1)},
			{LL(0xee88cea9ad5e1931), LL(0x4cace62e4a51b33b)}, {LL(0x97c42030ff03a44e), LL(0x3fbccaa376545195)}, {LL(0xbcbd63b371171880), LL(0xf8a0fb3b5b221ba6)}, {LL(0xaa6210189ee05227), LL(0xfe5e65b03b2ac9ab)},
			{LL(0xd32efe81ccbdef58), LL(0x8d4e493d072f2b05)}, {LL(0x18d7fa870a851a21), LL(0x53b8c11179c4885f)}, {LL(0x1c10d15809e4a0cf), LL(0xaa8cbef7325bb4a4)}, {LL(0x96855a778f8a6b94), LL(0x90b1a57b14035edb)},
			{LL(0xbf7eed7ae14f8a2d), LL(0xcab74a90fddb0a74)}, {LL(0xdd2677ad29cfbfde), LL(0xd80816a71ee37157)}, {LL(0x5a78fb67da8bb6ae), LL(0x8564e31a878ed0a8)}, {LL(0x1b14744e9add888c), LL(0x61af70badf3d998d)},
			{LL(0x619b141e58d8a75e), LL(0x20a8ed9c45c16af1)}, {LL(0xcab87e41b6b13aa3), LL(0x71fbe7f41cbcac14)}, {LL(0x0dcb07e5752ac22b), LL(0x6751ee31bf354b80)}, {LL(0x8399a715f025b39e), LL(0xa4588a5bd2f29d04)},
			{LL(0xf59cbae7378391bd), LL(0x2d039694956c2ab6)}, {LL(0xe343c94cd874db1a), LL(0x2bfd081ff564f8bb)}, {LL(0x312c4d8a6440fb98), LL(0x09be2efa901cdcf0)}, {LL(0x9181ff611cb343d7), LL(0x5b926b36f96573f2)},
			{LL(0x0704a51693392843), LL(0xcb23ce4ded662d29)}, {LL(0x145d87250f2617d0), LL(0x9be440f8a4a6cc91)}, {LL(0x7ccabf0121b5c84b), LL(0x25293cb315cdd11b)}, {LL(0x5470724b3ff9e628), LL(0xd022bc809e428afa)},
			{LL(0x689738242e93df9b), LL(0xbecd7c4bb16b1d8a)}, {LL(0xf916c74532209c4c), LL(0xe55f177d480e6e78)}, {LL(0x8f13dab7f586be6f), LL(0x6c040bb20f90d9ca)}, {LL(0xa0adb2eb78f3b84f), LL(0x522c45cc6979af02)},
			{LL(0x22756fb9f85fc40b), LL(0x5979a04fd9dc3d48)}, {LL(0x306d37cd14c93442), LL(0xa6b34122f24bd3be)}, {LL(0xd7e9d55ecfdc55b6), LL(0x747a36db4cb017fe)}, {LL(0xe784e293db1561f4), LL(0xd2c977f9befbc440)},
			{LL(0xf2981ff1a4bab9fe), LL(0xe62058d9780a079f)}, {LL(0x90c085266c3a8c0d), LL(0xf49f04ee9b327cbc)}, {LL(0x5235ad1adc4901b1), LL(0xb40c1d151173a89d)}, {LL(0x85dc784413955407), LL(0xc0762bce5dc3bf63)},
			{LL(0xec0a3a274d8f4446), LL(0xd1b6385d8effada7)}, {LL(0xb5b14f89075c6045), LL(0x66c56aecaf886cdd)}, {LL(0x01417a477089cfda), LL(0xaf0d6fd862570f4e)}, {LL(0x3628e89cf779d3db), LL(0xc29de0b77d7af1d9)},
			{LL(0x811b539b10f4eee9), LL(0x39425428165c8398)}, {LL(0x402df56e30dff1f8), LL(0x4bc6fc783ae4466b)}, {LL(0xa8e0e4967e310f50), LL(0x6344bbc3ff84d737)}, {LL(0xe1c13dc238a5866d), LL(0xb6e7d66c31cae627)}
		}
	}; 

	static const uint64 IT[16][256][2] = {
		{
			{LL(0x59ba4fc2860ecca5), LL(0xf011538279efe33b)}, {LL(0xb62a6c959496032d), LL(0xbd918337e7ba9cf5)}, {LL(0xd211f9a6abb11732), LL(0xad925890c98ec303)}, {LL(0xbf6596274482a58f), LL(0x84685128596eda60)},
			{LL(0xa029a9e0ac34d40e), LL(0x5113c1f94d76899f)}, {LL(0x685f4086d27afc30), LL(0x7115b474111e37b0)}, {LL(0xc5a4e106f5d0d638), LL(0x874c8262f71b6139)}, {LL(0x63bfc35dce2b76c0), LL(0x075495134478dc85)},
			{LL(0x0f7d710947dbd254), LL(0xe8f2049740c172b6)}, {LL(0x9f070a78d95820e6), LL(0xfeb9baa4f11f98f2)}, {LL(0x7b77aaf4d791659e), LL(0xc5784b763a2c0c09)}, {LL(0x98835c1628544239), LL(0xe9eef4109b531b81)},
			{LL(0x525acc199a5f4655), LL(0x865072e52c89080e)}, {LL(0xe9a2a8ec8557bb7e), LL(0x9c8b063d60404bed)}, {LL(0x02af7969cc452c52), LL(0x4fb8f378ebb2ada0)}, {LL(0x8679be04a6212591), LL(0xfac9fcfd1b12ff2e)},
			{LL(0x6722318f95a12e64), LL(0x99e7b0e351df4506)}, {LL(0xe7690430a44f7f03), LL(0xb2259a96b4d88e0b)}, {LL(0xe8147539e394ad57), LL(0x5ad79e01f419fcbd)}, {LL(0xaf54d8e9ebef065a), LL(0xb9e1c56e0db7fb29)},
			{LL(0x835291039b686b1c), LL(0xa22641319aecd1fd)}, {LL(0xd0be80cf67f43b60), LL(0xe22aabe8223c6ea3)}, {LL(0x50f5b570561a6a07), LL(0xc9e8819dc73ba5ae)}, {LL(0x34ce2043693d7e18), LL(0xd9eb5a3ae90ffa58)},
			{LL(0xac4d7c5541693c21), LL(0x3005ae2a725ce1d9)}, {LL(0xf3c5b82c50a88472), LL(0x111f2b20f5a636c1)}, {LL(0x1efae2128e7567a8), LL(0x132708ed8041e4af)}, {LL(0xa7adff8e5d38b6d1), LL(0x46448f4d273a0aec)},
			{LL(0x01b6ddd566c31629), LL(0xc65c983c9459b750)}, {LL(0x6e6dcb3d45b588c6), LL(0xa01e62fcef0b0393)}, {LL(0x049df2d25b8a58a4), LL(0x9eb325f015a79983)}, {LL(0x95515476a3cabc3f), LL(0x4ea403ff3020c497)},
			{LL(0x92d5021852c6dee0), LL(0x59f34d4b5a6c47e4)}, {LL(0xa19f7435caf7c227), LL(0x974f59c5d92f3ecf)}, {LL(0x052b2f073d494e8d), LL(0x58efbdcc81fe2ed3)}, {LL(0x1a6710c0d5ff3f0c), LL(0x8d942d1d95e67d2c)},
			{LL(0xf8253bf74cf90e82), LL(0x675e0a47a0c0ddf4)}, {LL(0x85601ab80ca71fea), LL(0x732d97b964f9e5de)}, {LL(0x1328ea7205eb99ae), LL(0xb46dff022b323bb9)}, {LL(0x9da87311151d0cb4), LL(0xb10149dc1aad3552)},
			{LL(0xcceb1bb425c4709a), LL(0xbeb5507d49cf27ac)}, {LL(0x37d784ffc3bb4463), LL(0x500f317e96e4e0a8)}, {LL(0xd1085d1a01372d49), LL(0x247633d4b665d9f3)}, {LL(0x786e0e487d175fe5), LL(0x4c9c203245c716f9)},
			{LL(0x9b9af8aa82d27842), LL(0x600a9f54e4b80171)}, {LL(0x2549b358a093cbe4), LL(0x223e5640298f6c41)}, {LL(0x738e8d936146d515), LL(0x3add015510a1fdcc)}, {LL(0x7ac17721b15273b7), LL(0x0324d34aae75bb59)},
			{LL(0xce4462dde9815cc8), LL(0xf10da305a27d8a0c)}, {LL(0x0dd208608b9efe06), LL(0xa74af7efab73df16)}, {LL(0x498b010c29636f70), LL(0xcd98c7c42d36c272)}, {LL(0x9c1eaec473de1a9d), LL(0x775dd1e08ef48202)},
			{LL(0x7cf3fc9a269d0741), LL(0xd22f05c250608f7a)}, {LL(0xa3300d5c06b2ee75), LL(0xd8f7aabd329d936f)}, {LL(0x69e99d53b4b9ea19), LL(0xb7492c48854780e0)}, {LL(0x9363dfcd3405c8c9), LL(0x9fafd577ce35f0b4)},
			{LL(0xa4b45b32f7be8caa), LL(0xcfa0e40958d1101c)}, {LL(0x1187931bc9aeb5fc), LL(0xfbd50c7ac0809619)}, {LL(0x6694ec5af362384d), LL(0x5fbb28dfc586f256)}, {LL(0xd73ad6a196f859bf), LL(0xf57de55c4870edd0)},
			{LL(0xe6dfd9e5c28c692a), LL(0x747902aa2081395b)}, {LL(0xaee2053c8d2c1073), LL(0x7fbd5d5299ee4c79)}, {LL(0xf5f73397c767f084), LL(0xc014fda80bb302e2)}, {LL(0x10314eceaf6da3d5), LL(0x3d89944654d92149)},
			{LL(0x84d6c76d6a6409c3), LL(0xb5710f85f0a0528e)}, {LL(0x4e0f5762d86f0daf), LL(0xdacf8970477a4101)}, {LL(0xbbf864f51f08fd2b), LL(0x1adb74d84cc943e3)}, {LL(0x4fb98ab7beac1b86), LL(0x1c93114cd323f651)},
			{LL(0xe3f4f6e2ffc527a7), LL(0x2c96bf66a17f1788)}, {LL(0x77137f413acc8db1), LL(0xa46e24a50506644f)}, {LL(0x907a7b719e83f2b2), LL(0x164bbe33b1deea44)}, {LL(0xf27365f9366b925b), LL(0xd743b31c61ff8191)},
			{LL(0x2c0649ea70876d46), LL(0x1bc7845f975b2ad4)}, {LL(0x1de346ae24f35dd3), LL(0x9ac363a9ffaafe5f)}, {LL(0x265017e40a15f19f), LL(0xabda3d04566476b1)}, {LL(0x4ca02e0b142a21fd), LL(0x95777a08acc8eca1)},
			{LL(0x4d16f3de72e937d4), LL(0x532be23438915bf1)}, {LL(0xfd0e14f071b0400f), LL(0x3fb1b78b213ef327)}, {LL(0xc13913d4ae5a8e9c), LL(0x19ffa792e2bcf8ba)}, {LL(0x0c64d5b5ed5de82f), LL(0x61166fd33f2a6846)},
			{LL(0x91cca6a4f840e49b), LL(0xd017260f25875d14)}, {LL(0xc6bd45ba5f56ec43), LL(0x0ea8e92688f07bc9)}, {LL(0x6fdb16e823769eef), LL(0x6642fac07b52b4c3)}, {LL(0x0a565e0e7a929cd9), LL(0xb01db95bc13f5c65)},
			{LL(0xb9571d9cd34dd179), LL(0x556387a0a77bee43)}, {LL(0x27e6ca316cd6e7b6), LL(0x6d86a538c23dc1e1)}, {LL(0x5f88c47911c1b853), LL(0x211a850a87fad718)}, {LL(0xb48515fc58d32f7f), LL(0xf229704f0c083155)},
			{LL(0x3e987e4d13afe2c1), LL(0x69f6e3612830a63d)}, {LL(0x0be083db1c518af0), LL(0x764121675566eb35)}, {LL(0x1603c57538a2d723), LL(0xec8242ceaacc156a)}, {LL(0xc220b76804dcb4e7), LL(0x901bccd69d57e24a)},
			{LL(0x1bd1cd15b33c2925), LL(0x4bc8b52101bfca7c)}, {LL(0x18c869a919ba135e), LL(0xc22cde657e54d08c)}, {LL(0xc08fce01c89998b5), LL(0xdfa33fae76e54fea)}, {LL(0x391c2823e2a3801e), LL(0x7ea1add5427c254e)},
			{LL(0x094ffab2d014a6a2), LL(0x39f9d21fbed44695)}, {LL(0x0784566ef10c62df), LL(0x17574eb46a4c8373)}, {LL(0xbed34bf22241b3a6), LL(0x4234c914cd376d30)}, {LL(0xabc92a3bb0655efe), LL(0x2752e09e181062aa)},
			{LL(0xa96653527c2072ac), LL(0x68ea13e6f3a2cf0a)}, {LL(0x4b247865e5264322), LL(0x822034bcc6846fd2)}, {LL(0xfb3c9f4be67f34f9), LL(0xeeba6103df2bc704)}, {LL(0x289bbb382b0d35e2), LL(0x8574a1af82fcb357)},
			{LL(0x3661592aa578524a), LL(0x9653a94202bd57f8)}, {LL(0x3053d29132b726bc), LL(0x47587fcafca863db)}, {LL(0x82e44cd6fdab7d35), LL(0x647ad90d0eb566ad)}, {LL(0x740adbfd904ab7ca), LL(0x2d8a4fe17aed7ebf)},
			{LL(0x32fcabf8fef20aee), LL(0x08e08cb2171ace7b)}, {LL(0xe470a08c0ec94578), LL(0x3bc1f1d2cb3394fb)}, {LL(0xeabb0c502fd18105), LL(0x156f6d791fab511d)}, {LL(0x9a2c257fe4116e6b), LL(0xa656076870e1b621)},
			{LL(0xe5c67d59680a5351), LL(0xfd9d69ee5f6a23ab)}, {LL(0xcff2bf088f424ae1), LL(0x37513b3936243d5c)}, {LL(0x483ddcd94fa07959), LL(0x0bc45ff8b96f7522)}, {LL(0x546847a20d9032a3), LL(0x575ba46dd29c3c2d)},
			{LL(0xb1ae3afb659a61f2), LL(0xaac6cd838df61f86)}, {LL(0x14acbc1cf4e7fb71), LL(0xa33ab1b6417eb8ca)}, {LL(0xb533c8293e103956), LL(0x3475e87398518605)}, {LL(0xc4123cd39313c011), LL(0x41101a5e6342d669)},
			{LL(0xc70b986f3995fa6a), LL(0xc8f4711a1ca9cc99)}, {LL(0xb2b79e47cf1c5b89), LL(0x2322a6c7f21d0576)}, {LL(0x6cc2b25489f0a494), LL(0xefa6918404b9ae33)}, {LL(0x3a058c9f4825ba65), LL(0xf745c6913d973fbe)},
			{LL(0x580c9217e0cdda8c), LL(0x364dcbbeedb6546b)}, {LL(0x60a667e164ad4cbb), LL(0x8eb0fe573b93c675)}, {LL(0x197eb47c7f790577), LL(0x04704659ea0d67dc)}, {LL(0x723850460785c33c), LL(0xfc81996984f84a9c)},
			{LL(0x0319a4bcaa863a7b), LL(0x89e46b447feb1af0)}, {LL(0x5c9160c5bb478228), LL(0xa8feee4ef811cde8)}, {LL(0xf993e6222a3a18ab), LL(0xa102927b34996aa4)}, {LL(0x40c4fbbef977c9d2), LL(0xf46115db93e284e7)},
			{LL(0x3578fd960ffe6831), LL(0x1fb7c2067d564d08)}, {LL(0x5aa3eb7e2c88f6de), LL(0x79f538c60604f9cb)}, {LL(0xd423721d3c7e63c4), LL(0x7c998e18379bf720)}, {LL(0x45efd4b9c43e875f), LL(0xac8ea817121caa34)},
			{LL(0x79d8d39d1bd449cc), LL(0x8ac0b80ed19ea1a9)}, {LL(0x9eb1d7adbf9b36cf), LL(0x38e5229865462fa2)}, {LL(0x4459096ca2fd9176), LL(0x6ad2302b86451d64)}, {LL(0xeb0dd1854912972c), LL(0xd333f5458bf2e64d)},
			{LL(0x87cf63d1c0e233b8), LL(0x3c9564c18f4b487e)}, {LL(0x5771e31ea71608d8), LL(0xdebfcf29ad7726dd)}, {LL(0x514368a530d97c2e), LL(0x0fb419a1536212fe)}, {LL(0x658d48e659e40236), LL(0xd65f439bba6de8a6)},
			{LL(0xb018e72e035977db), LL(0x6c9a55bf19afa8d6)}, {LL(0x20629c5f9dda8569), LL(0x7ad1eb8ca8714292)}, {LL(0xcd5dc661430766b3), LL(0x78e9c841dd9690fc)}, {LL(0x2ea93083bcc24114), LL(0x547f77277ce98774)},
			{LL(0x31e50f4454743095), LL(0x8104e7f668f1d48b)}, {LL(0x8a1d6bb14b7ccdbe), LL(0x9bdf932e24389768)}, {LL(0x6af039ef1e3fd062), LL(0x3ead470cfaac9a10)}, {LL(0xee26fe82745bd9a1), LL(0x8bdc48890a0cc89e)},
			{LL(0x22cde536519fa93b), LL(0x356918f443c3ef32)}, {LL(0x94e789a3c509aa16), LL(0x88f89bc3a47973c7)}, {LL(0xdd6c88afec6ac566), LL(0x45605c07894fb1b5)}, {LL(0x62091e88a8e860e9), LL(0xc1080d2fd0216bd5)},
			{LL(0xa286d0896071f85c), LL(0x1eab3281a6c4243f)}, {LL(0xcad9900fb20b046c), LL(0x6fbe86f5b7da138f)}, {LL(0x97fe2d1f6f8f906d), LL(0x011cf087db926937)}, {LL(0xf441ee42a1a4e6ad), LL(0x064865949feab5b2)},
			{LL(0x38aaf5f684609637), LL(0xb8fd35e9d625921e)}, {LL(0x8d993ddfba70af61), LL(0x8c88dd9a4e74141b)}, {LL(0x6b46e43a78fcc64b), LL(0xf8f1df306ef52d40)}, {LL(0xdae8dec11d66a7b9), LL(0x523712b3e30332c6)},
			{LL(0x75bc0628f689a1e3), LL(0xebd6d7ddeeb4c9ef)}, {LL(0x3d81daf1b929d8ba), LL(0xe012882557dbbccd)}, {LL(0x56c73ecbc1d51ef1), LL(0x18e35715392e918d)}, {LL(0xb3014392a9df4da0), LL(0xe57e3efb6644b226)},
			{LL(0xa8d08e871ae36485), LL(0xaeb68bda67fb785a)}, {LL(0xa50286e7917d9a83), LL(0x09fc7c35cc88a74c)}, {LL(0xed3f5a3ededde3da), LL(0x023823cd75e7d26e)}, {LL(0x7121f4faad03f947), LL(0x7565f22dfb13506c)},
			{LL(0x8904cf0de1faf7c5), LL(0x123bf86a5bd38d98)}, {LL(0x2a34c251e74819b0), LL(0xcacc52d7694e1ef7)}, {LL(0x8f3644b676358333), LL(0xc3302ee2a5c6b9bb)}, {LL(0x1c559b7b42304bfa), LL(0x5c9ffb956bf3490f)},
			{LL(0xd68c0b74f03b4f96), LL(0x33217d60dc295a80)}, {LL(0x2db0943f16447b6f), LL(0xdd9b1c6303029d84)}, {LL(0x7097292fcbc0ef6e), LL(0xb3396a116f4ae73c)}, {LL(0xd9f17a7db7e09dc2), LL(0xdbd379f79ce82836)},
			{LL(0x06328bbb97cf74f6), LL(0xd10bd688fe153423)}, {LL(0xb8e1c049b58ec750), LL(0x933f1f9c33225913)}, {LL(0xf6ee972b6de1caff), LL(0x49f096ec74581812)}, {LL(0xffa16d99bdf56c5d), LL(0x700944f3ca8c5e87)},
			{LL(0x43dd5f0253f1f3a9), LL(0x7d857e9fec099e17)}, {LL(0xe2422b379906318e), LL(0xeaca275a3526a0d8)}, {LL(0xc9c034b3188d3e17), LL(0xe65aedb1c831097f)}, {LL(0xd3a72473cd72011b), LL(0x6bcec0ac5dd77453)},
			{LL(0x8babb6642dbfdb97), LL(0x5d830b12b0612038)}, {LL(0x0ecbacdc2118c47d), LL(0x2eae9cabd498c5e6)}, {LL(0x88b212d88739e1ec), LL(0xd4676056cf8a3ac8)}, {LL(0x151a61c99224ed58), LL(0x6566298ad5270f9a)},
			{LL(0x5b1536ab4a4be0f7), LL(0xbfa9a0fa925d4e9b)}, {LL(0x643b95333f27141f), LL(0x1003dba72e345ff6)}, {LL(0x4172266b9fb4dffb), LL(0x323d8de707bb33b7)}, {LL(0x53ec11ccfc9c507c), LL(0x400cead9b8d0bf5e)},
			{LL(0xf0dc1c90fa2ebe09), LL(0x98fb40648a4d2c31)}, {LL(0x4740add0087bab0d), LL(0xe3365b6ff9ae0794)}, {LL(0x5e3e19ac7702ae7a), LL(0xe7461d3613a36048)}, {LL(0x804b35bf31ee5167), LL(0x2bc22a75e507cb0d)},
			{LL(0xcb6f4ddad4c81245), LL(0xa9e21ec92383a4df)}, {LL(0x129e37a763288f87), LL(0x7231673ebf6b8ce9)}, {LL(0xe0ed525e55431ddc), LL(0xa572d422de940d78)}, {LL(0x3f2ea398756cf4e8), LL(0xafaa7b5dbc69116d)},
			{LL(0xdcda557a8aa9d34f), LL(0x833cc43b1d1606e5)}, {LL(0xde752c1346ecff1d), LL(0xcc843743f6a4ab45)}, {LL(0x81fde86a572d474e), LL(0xed9eb249715e7c5d)}, {LL(0xb79cb140f2551504), LL(0x7bcd1b0b73e32ba5)},
			{LL(0xd847a7a8d1238beb), LL(0x1d8fe1cb08b19f66)}, {LL(0xa61b225b3bfba0f8), LL(0x80181771b363bdbc)}, {LL(0xec8987ebb81ef5f3), LL(0xc464bbf1e1be653e)}, {LL(0xc876e9667e4e283e), LL(0x2006758d5c68be2f)},
			{LL(0x2f1fed56da01573d), LL(0x9223ef1be8b03024)}, {LL(0x6d746f81ef33b2bd), LL(0x29fa09b890e01963)}, {LL(0x55de9a776b53248a), LL(0x91073c5146c58b7d)}, {LL(0xef9023571298cf88), LL(0x4d80d0b59e557fce)},
			{LL(0xbdcaef4e88c789dd), LL(0xcbd0a250b2dc77c0)}, {LL(0x24ff6e8dc650ddcd), LL(0xe462ce7cbdd6db11)}, {LL(0x4a92a5b083e5550b), LL(0x447cac8052ddd882)}, {LL(0x7e5c85f3ead82b13), LL(0x9d97f6babbd222da)},
			{LL(0x76a5a2945c0f9b98), LL(0x6232bc99915fd31f)}, {LL(0xba4eb92079cbeb02), LL(0xdc87ece4d890f4b3)}, {LL(0x3c370724dfeace93), LL(0x264e1019c3820b9d)}, {LL(0x426b82d73532e580), LL(0xbbd9e6a378502947)},
			{LL(0xdb5e03147ba5b190), LL(0x946b8a8f775a8596)}, {LL(0xfa8a429e80bc22d0), LL(0x28e6f93f4b727054)}, {LL(0x46f670056eb8bd24), LL(0x256ac3536df7b0c4)}, {LL(0xdfc3f1c6202fe934), LL(0x0ad8af7f62fd1c15)},
			{LL(0x292d66ed4dce23cb), LL(0x4328399316a50407)}, {LL(0xd595afc85abd75ed), LL(0xbac51624a3c24070)}, {LL(0xbc7c329bee049ff4), LL(0x0d8c3a6c2685c090)}, {LL(0xc3966abd621fa2ce), LL(0x564754ea090e551a)},
			{LL(0x2b821f84818b0f99), LL(0x0c90caebfd17a9a7)}, {LL(0x993581c34e975410), LL(0x2fb26c2c0f0aacd1)}, {LL(0x9648f0ca094c8644), LL(0xc74068bb4fcbde67)}, {LL(0x21d4418afb199340), LL(0xbc8d73b03c28f5c2)},
			{LL(0x6110ba34026e5a92), LL(0x48ec666bafca7125)}, {LL(0x7fea58268c1b3d3a), LL(0x5bcb6e862f8b958a)}, {LL(0x5d27bd10dd849401), LL(0x6ea276726c487ab8)}, {LL(0xfcb8c92517735626), LL(0xf9ed2fb7b5674477)},
			{LL(0x237b38e3375cbf12), LL(0xf33580c8d79a5862)}, {LL(0x8e80996310f6951a), LL(0x056cb6de319f0eeb)}, {LL(0x8c2fe00adcb3b948), LL(0x4ad445a6da2da34b)}, {LL(0x7d45214f405e1168), LL(0x14739dfec439382a)},
			{LL(0xe15b8f8b33800bf5), LL(0x632e4c1e4acdba28)}, {LL(0x1f4c3fc7e8b67181), LL(0xd57b90d1141853ff)}, {LL(0x08f92767b6d7b08b), LL(0xffa54a232a8df1c5)}, {LL(0x334a762d98311cc7), LL(0xcebc148e8343792b)},
			{LL(0xf7584afe0b22dcd6), LL(0x8fac0ed0e001af42)}, {LL(0xf16ac1459ceda820), LL(0x5ea7d8581e149b61)}, {LL(0x17b518a05e61c10a), LL(0x2adedaf23e95a23a)}, {LL(0xadfba18027aa2a08), LL(0xf6593616e6055689)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x3bb3514a2ee6ac4c), LL(0x31195eada9ce88ee)}, {LL(0xaa7ff7eed6a648d7), LL(0xe10e78a28c49d5fa)}, {LL(0xfe17b04cdb367a74), LL(0xb655dccf5ed5e9d7)}
		}, {
			{LL(0xc397111b1518eccc), LL(0x9b933a773e7d9af0)}, {LL(0xcd0591a4324c5203), LL(0x23a6ad710e447bbd)}, {LL(0xd8399218a99a0c17), LL(0x74027d7846f20aad)}, {LL(0x3c2c688604ab43a5), LL(0x98407bdb17358384)},
			{LL(0x64bf1372463d39d4), LL(0x40ea1b794e18c451)}, {LL(0x4ec715c9b35285fc), LL(0xee61786bdeb72671)}, {LL(0x53b94c0bdbf4e4d6), LL(0xc32e6c27fb609687)}, {LL(0xfb9a54a2898b5176), LL(0x3e47236ffe999807)},
			{LL(0x3db5f2f922a59dd2), LL(0x0665829b529032e8)}, {LL(0xf660b99cc4cd4e20), LL(0xe71d7ca9018c69fe)}, {LL(0x4daf7848d9402465), LL(0x8f0eb0ab119b36c5)}, {LL(0x18c6ee82d6904142), LL(0x8efe8fcfb7a380e9)},
			{LL(0x76ca50702fc13846), LL(0x4bb561731e532486)}, {LL(0xc20e8b64331632bb), LL(0x05b6c3377bd82b9c)}, {LL(0x4474b8490c3ec52c), LL(0x6bc08dae395f464f)}, {LL(0x626fc9b39219b825), LL(0x8234483a1340e4fa)},
			{LL(0x7372e73091f7182e), LL(0xe804faf08c271499)}, {LL(0xdd81255817ac2c7f), LL(0xd7b3e6fbd4863ab2)}, {LL(0xe034d7a13509b1ad), LL(0xd1d664608616085a)}, {LL(0x590ae18b6498a406), LL(0x468f99e21c88f6b9)},
			{LL(0xc8bd26e48c7a726b), LL(0x801736f29c304ba2)}, {LL(0x9c4d2a51a5a4c93b), LL(0x1fc2f0d67fad4ce2)}, {LL(0x32bee83923fffd6a), LL(0x2075ecdd270c62c9)}, {LL(0x2782eb85b829a37e), LL(0x77d13cd46fba13d9)},
			{LL(0x3f4405076eb9e23c), LL(0xf92fb31bd8199330)}, {LL(0x304f1fc76fe38284), LL(0xdf3fdd5dad85c311)}, {LL(0x7aa927314489f967), LL(0x0ccac7f5a4e36413)}, {LL(0x8a19446c546036b6), LL(0x2909e81ff8372d46)},
			{LL(0x223a5cc5061f8316), LL(0xd460a757fdce23c6)}, {LL(0x825b1e12a7100988), LL(0x53e22c5a9556eca0)}, {LL(0x88e8b392187c4958), LL(0xd643d99f72be8c9e)}, {LL(0x6107a432f80b19bc), LL(0xe35b80fadc6cf44e)},
			{LL(0x8fa1f32cea5616de), LL(0x8ab8739c6a431d59)}, {LL(0x46854fb74022bac2), LL(0x948abc2eb3d6e797)}, {LL(0xaad2ef571e63ca4e), LL(0x02237ec88f70af58)}, {LL(0xf24194a35cf5b03f), LL(0xda891e6ad65de88d)},
			{LL(0x85125eac553a560e), LL(0x0f1986598dab7d67)}, {LL(0x04212d3f9838fe1f), LL(0x3d9462c3d7d18173)}, {LL(0x03686d816a12a199), LL(0x616fc8c0cf2c10b4)}, {LL(0xb21401d5c8f38b0c), LL(0x8cddf10738d32fb1)},
			{LL(0xa290b529ed13f570), LL(0x78c8ba8de2116ebe)}, {LL(0x41cc0f09b208e544), LL(0xc871162dab2b7650)}, {LL(0xbe777694a3bb4a2d), LL(0xcba2578182636f24)}, {LL(0x2be19cc4d361625f), LL(0x30ae9a52d50a534c)},
			{LL(0x7e880a0edcb10778), LL(0x315ea5367332e560)}, {LL(0x609e3e4dde05c7cb), LL(0x7d7e79ba99c94522)}, {LL(0x9ebcddafe9b8b6d5), LL(0xe088c156f524ed3a)}, {LL(0x6f95248ddf5fa773), LL(0x5b6e17fcec551503)},
			{LL(0xe6e40d60e12d305c), LL(0x13083723db4e28f1)}, {LL(0x79c14ab02e9b58fe), LL(0x6da50f356bcf74a7)}, {LL(0xa6b19816752b0b6f), LL(0x455cd84e35c0efcd)}, {LL(0x902e5d10ceec081a), LL(0x58bd5650c51d0c77)},
			{LL(0xa3092f56cb1d2b07), LL(0xe6ed43cda7b4dfd2)}, {LL(0x02f1f7fe4c1c7fee), LL(0xff4a31808a89a1d8)}, {LL(0x6cfd490cb54d06ea), LL(0x3a01df3c237905b7)}, {LL(0xad9bafe9ec4995c8), LL(0x5ed8d4cb978d3e9f)},
			{LL(0xec57a0e05e41708c), LL(0x96a9c2e63ca648cf)}, {LL(0x471cd5c8662c64b5), LL(0x0aaf456ef67356fb)}, {LL(0x5148bbf597e89b38), LL(0x3c645da771e9375f)}, {LL(0x72eb7d4fb7f9c659), LL(0x762103b0c982a5f5)},
			{LL(0xffbb799d11b3af69), LL(0x03d341ac29481974)}, {LL(0x7b30bd4e62872710), LL(0x92ef3eb5e146d57f)}, {LL(0xfcd3141c7ba10ef0), LL(0x62bc896ce66409c0)}, {LL(0x6526890d6033e7a3), LL(0xdecfe2390bbd753d)},
			{LL(0x261b71fa9e277d09), LL(0xe9f4c5942a1fa2b5)}, {LL(0x4817cf086776040d), LL(0x2cbf2b2883ef06da)}, {LL(0xb4c4db141cd70afd), LL(0x4e03a244658b0f1a)}, {LL(0x6a2d93cd6169871b), LL(0xf8df8c7f7e21251c)},
			{LL(0x556996ca0fd06527), LL(0x01f03f64a638b62c)}, {LL(0x16546e3df1c4ff8d), LL(0x36cb18c9879a61a4)}, {LL(0xcbd54b65e668d3f2), LL(0xe178fe32531c5b16)}, {LL(0x1275430269fc0192), LL(0x0b5f7a0a504be0d7)},
			{LL(0x91b7c76fe8e2d66d), LL(0xc698af1080b8bd1b)}, {LL(0x1ce7c3bd4ea8bf5d), LL(0xb36aed0c6072019a)}, {LL(0x06d0dac1d42481f1), LL(0xc2de53435d5820ab)}, {LL(0x0c6377416b48c121), LL(0x477fa686bab04095)},
			{LL(0x2e592b846d574237), LL(0x931f01d1477e6353)}, {LL(0x2fc0b1fb4b599c40), LL(0x0d3af89102dbd23f)}, {LL(0xdb51ff99c388ad8e), LL(0x156db5b889de1a19)}, {LL(0x5bfb16752884dbe8), LL(0xb9c5a86296015761)},
			{LL(0xe9ef17a0e07750e4), LL(0x35185965aed278d0)}, {LL(0x35f7a887d1d5a2ec), LL(0x7c8e46de3ff1f30e)}, {LL(0xa06142d7a10f8a9e), LL(0x87828b0d6898cf66)}, {LL(0x97671dae3cc6579c), LL(0x0446fc53dde09db0)},
			{LL(0xf0b0635d10e9cfd1), LL(0x25c32fea5cd44955)}, {LL(0x24ea8604d23b02e7), LL(0x16bef414a096036d)}, {LL(0x0f0b1ac0015a60b8), LL(0x26106e46759c5021)}, {LL(0x897129ed3e72972f), LL(0x486620df371b3df2)},
			{LL(0xb0e5f62b84eff4e2), LL(0x7397c087b25a8e69)}, {LL(0xb55d416b3ad9d48a), LL(0xd0265b04202ebe76)}, {LL(0xa9ba82d674716bd7), LL(0x634cb608405cbfec)}, {LL(0xbd1f1b15c9a9ebb4), LL(0xaacd9f414d4f7f90)},
			{LL(0xd07bc8665aea3329), LL(0x0ee9b93d2b93cb4b)}, {LL(0xb6352cea50cb7513), LL(0xb14993c4ef02aec2)}, {LL(0xf96ba35cc5972e98), LL(0xc10d12ef741039df)}, {LL(0x5e43a13596b2fb80), LL(0x1a7433e10475677e)},
			{LL(0xf129f92236e711a6), LL(0xbbe6d6aa1971f839)}, {LL(0xeea6571e125d0f62), LL(0x69e3f366b62fe917)}, {LL(0x1e16344302b4c0b3), LL(0x4c20dc8ceafba042)}, {LL(0xd1e252197ce4ed5e), LL(0x90cc407d6e367a27)},
			{LL(0x9596ea5070da2872), LL(0xfb0ccdd357693c68)}, {LL(0xe2c5205f7915ce43), LL(0x2e9c55e00c9fa982)}, {LL(0xe35cba205f1b1034), LL(0xb0b9aca0493a18ee)}, {LL(0x195f74fdf09e9f35), LL(0x10db768ff2063185)},
			{LL(0x63f653ccb4176652), LL(0x1c11b17a56e55596)}, {LL(0xaf6a5817a055ea26), LL(0xa192e54b1d049f47)}, {LL(0xea877a218a65f17d), LL(0x547791a561fe6864)}, {LL(0x701a8ab1fbe5b9b7), LL(0x896b3230430b042d)},
			{LL(0xeb1ee05eac6b2f0a), LL(0xca5268e5245bd908)}, {LL(0xbbcfc1d41d8d6a45), LL(0x6813cc0210175f3b)}, {LL(0xa4406fe839377481), LL(0xba16e9cebf494e15)}, {LL(0x5cb256cbdaae846e), LL(0xe53e02618efcc6a6)},
			{LL(0x99f59d111b92e953), LL(0xbc736b55edd97cfd)}, {LL(0xc4de51a5e732b34a), LL(0xc768907426800b37)}, {LL(0x848bc4d373348879), LL(0x913c7f19c80ecc0b)}, {LL(0xba565bab3b83b432), LL(0xf636354255b2ee57)},
			{LL(0x23a3c6ba20115d61), LL(0x4a455e17b86b92aa)}, {LL(0xedce3a9f784faefb), LL(0x088c3ba67903f9a3)}, {LL(0xab4b7528386d1439), LL(0x9c068788cad51e34)}, {LL(0x718310ceddeb67c0), LL(0x174ecb7006aeb541)},
			{LL(0x17cdf442d7ca21fa), LL(0xa8eee189c23fd0c8)}, {LL(0x45ed22362a301b5b), LL(0xf5e574ee7cfaf723)}, {LL(0xc62fa65bab2ecca4), LL(0x3822a1f4ac09aaef)}, {LL(0x380d45b99c93bdba), LL(0xa5d41918c0e402f7)},
			{LL(0xe1ad4dde13076fda), LL(0x4ff39d20c3b3b936)}, {LL(0x9dd4b02e83aa174c), LL(0x81e709963a08fd8e)}, {LL(0x940f702f56d4f605), LL(0x6529349312cc8d04)}, {LL(0xbc86816aefa735c3), LL(0x34e8660108eacefc)},
			{LL(0x664ee48c0a21463a), LL(0xbfa02af9c4916589)}, {LL(0x6945fe4c0b7b2682), LL(0x99b044bfb10d35a8)}, {LL(0xa72802695325d518), LL(0xdb79210e70655ea1)}, {LL(0x5798613443cc1ac9), LL(0xfeba0ee42cb117f4)},
			{LL(0x05b8b740be362068), LL(0xa3b19b839274301f)}, {LL(0xa5d9f5971f39aaf6), LL(0x2433108efaecff79)}, {LL(0x14a599c3bdd88063), LL(0xc98129490d13c07c)}, {LL(0xfd4a8e635dafd087), LL(0xfc99702ca3c1b8ac)},
			{LL(0x09dbc001d57ee149), LL(0xe4ce3d0528c4708a)}, {LL(0xd45ae559c2d2cd36), LL(0x337ddbfefc424a38)}, {LL(0xdf70d2a65bb05391), LL(0x28f9d77b5e0f9b6a)}, {LL(0x867a332d3f28f797), LL(0x6e764e9942876dd3)},
			{LL(0x4055957694063b33), LL(0x5654ef6dee8ec73c)}, {LL(0xdc18bf2731a2f208), LL(0x49961fbb91238bde)}, {LL(0x1084b4fc25e07e7c), LL(0xf4154b8adac2410f)}, {LL(0x37065f799dc9dd02), LL(0x83c4775eb57852d6)},
			{LL(0x01999a7f260ede77), LL(0x9e25f94045a5b16c)}, {LL(0xca4cd11ac0660d85), LL(0x7f5d077216b9ea7a)}, {LL(0x80aae9eceb0c7666), LL(0xaca81dda1fdf4d78)}, {LL(0xd5c37f26e4dc1341), LL(0xad5822beb9e7fb54)},
			{LL(0x8d5004d2a64a6930), LL(0x75f2421ce0cabc81)}, {LL(0x3994dfc6ba9d63cd), LL(0x3bf1e0588541b39b)}, {LL(0x0ab3ad80bf6c40d0), LL(0x85a1f5c5e7e8603e)}, {LL(0x2ca8dc7a214b3dd9), LL(0x6c553051cdf7c28b)},
			{LL(0x8e386953cc58c8a9), LL(0x149d8adc2fe6ac35)}, {LL(0x433df8f7fe149aaa), LL(0x373b27ad21a2d788)}, {LL(0xe58c60e18b3f91c5), LL(0x7267ffe314623845)}, {LL(0xd9a008678f94d260), LL(0xea2784380357bbc1)},
			{LL(0x20cbab3b4a03fcf8), LL(0x2b2a96d77747821e)}, {LL(0x6e0cbef2f9517904), LL(0xc54beebca9f0a46f)}, {LL(0x25731c7bf435dc90), LL(0x889b0d54e533b201)}, {LL(0xdee948d97dbe8de6), LL(0xb6dc2e3b1baa2a06)},
			{LL(0x7c79fdf090ad7896), LL(0xce1494b6f9bb44b8)}, {LL(0xd73288d8a8c06caf), LL(0x5212133e336e5a8c)}, {LL(0x2889f145b973c3c6), LL(0x51c152921a2643f8)}, {LL(0x0b2a37ff99629ea7), LL(0x1b840c85a24dd152)},
			{LL(0x5220d674fdfa3aa1), LL(0x5d0b9567bec527eb)}, {LL(0xd6ab12a78eceb2d8), LL(0xcc37ea7e76cbebe0)}, {LL(0xfe22e3e237bd711e), LL(0x9df6b8ec6ceda818)}, {LL(0x67d77ef32c2f984d), LL(0x2185d3b98134d4e5)},
			{LL(0xb7acb69576c5ab64), LL(0x2f6c6a84aaa71fae)}, {LL(0xce6dfc25585ef39a), LL(0x42c965b1c1686b09)}, {LL(0x4ae638f62b6a7be3), LL(0xd3f51aa80966a702)}, {LL(0xdac865e6e58673f9), LL(0x8b484cf8cc7bab75)},
			{LL(0x5fda3b4ab0bc25f7), LL(0x8451caa141d0d612)}, {LL(0x5d2bccb4fca05a19), LL(0x7b1bfb21cb5977ca)}, {LL(0x93463091a4fea983), LL(0x39d29e900a311cc3)}, {LL(0x3edd9f7848b73c4b), LL(0x670a4a5b9dbc225c)},
			{LL(0x50d1218ab1e6454f), LL(0xa241a4e7344c8633)}, {LL(0xb38d9baaeefd557b), LL(0x12f808477d769edd)}, {LL(0xf8f23923e399f0ef), LL(0x5f28ebaf31b588b3)}, {LL(0x6d64d3739343d89d), LL(0xa424267c66dcb4db)},
			{LL(0xcc9c0bdb14428c74), LL(0xbd8354314be1cad1)}, {LL(0xd28a3f9816f64cc7), LL(0xf1a388bda11a6a93)}, {LL(0x9a9df090718048ca), LL(0xdd1ca39522f56c49)}, {LL(0x6bb409b24767596c), LL(0x66fa753f3b849470)},
			{LL(0x31d685b849ed5cf3), LL(0x411a241de820727d)}, {LL(0x7753ca0f09cfe631), LL(0xd59098335bf695ea)}, {LL(0x08425a7ef3703f3e), LL(0x7aebc4456d61c1e6)}, {LL(0xfa03ceddaf858f01), LL(0xa062da2fbb3c296b)},
			{LL(0x1bae8303bc82e0db), LL(0xef91470f788f905d)}, {LL(0x1f8fae3c24ba1ec4), LL(0xd20525ccaf5e112e)}, {LL(0x7de0678fb6a3a6e1), LL(0x50316df6bc1ef5d4)}, {LL(0xcff4665a7e502ded), LL(0xdcec9cf184cdda65)},
			{LL(0x87e3a952192629e0), LL(0xf053b7d90722dcbf)}, {LL(0x153c03bc9bd65e14), LL(0x57a4d00948b67110)}, {LL(0x75a23df145d399df), LL(0x2adaa9b3d17f3432)}, {LL(0x54f00cb529debb50), LL(0x9fd5c624e39d0740)},
			{LL(0x5601fb4b65c2c4be), LL(0x609ff7a46914a698)}, {LL(0xb93e362a519115ab), LL(0x9759fd829a9efee3)}, {LL(0x2d3146050745e3ae), LL(0xf270c911885273e7)}, {LL(0xaef3c268865b3451), LL(0x3fb71c0b58a12e2b)},
			{LL(0x4c36e237ff4efa12), LL(0x112b49eb543e87a9)}, {LL(0x215231446c0d228f), LL(0xb50f6f9732e23372)}, {LL(0x3327724605f1231d), LL(0xbe50159d62a9d3a5)}, {LL(0x92dfaaee82f077f4), LL(0xa7f767d04f94adaf)},
			{LL(0xc7b63c248d2012d3), LL(0xa60758b4e9ac1b83)}, {LL(0x83c2846d811ed7ff), LL(0xcdc7d51ad0f35dcc)}, {LL(0x8cc99ead8044b747), LL(0xebd7bb5ca56f0ded)}, {LL(0xef3fcd613453d115), LL(0xf7c60a26f38a587b)},
			{LL(0x4f5e8fb6955c5b8b), LL(0x7044812b9b12971d)}, {LL(0xa82318a9527fb5a0), LL(0xfd694f4805f90e80)}, {LL(0x68dc64332d75f8f5), LL(0x0795bdfff4a884c4)}, {LL(0x2a7806bbf56fbc28), LL(0xae8b631290afe220)},
			{LL(0xf7f923e3e2c39057), LL(0x793885e94429d892)}, {LL(0xe415fa9ead314fb2), LL(0xec4206a351c78929)}, {LL(0x986c076e3d9c3724), LL(0x22569215a87ccd91)}, {LL(0x0e9280bf2754becf), LL(0xb83597063039e14d)},
			{LL(0x7858d0cf08958689), LL(0xf380f6752e6ac5cb)}, {LL(0x42a46288d81a44dd), LL(0xa91edeed640766e4)}, {LL(0xc0ff7c9a7f0a4d55), LL(0xfafcf2b7f1518a44)}, {LL(0xe77d971fc723ee2b), LL(0x8d2dce639eeb999d)},
			{LL(0x346e32f8f7db7c9b), LL(0xe2abbf9e7a544262)}, {LL(0x96fe87d11ac889eb), LL(0x9a63051398452cdc)}, {LL(0xf4914e6288d131ce), LL(0x18574d298b05c826)}, {LL(0x13ecd97d4ff2dfe5), LL(0x957a834a15ee51bb)},
			{LL(0x29106b3a9f7d1db1), LL(0xcfe4abd25f83f294)}, {LL(0xc166e6e559049322), LL(0x64d90bf7b4f43b28)}, {LL(0x9b046aef578e96bd), LL(0x43395ad56750dd25)}, {LL(0xa1f8d8a8870154e9), LL(0x19a7724d2d3d7e0a)},
			{LL(0x3b652838f6811c23), LL(0xc4bbd1d80fc81243)}, {LL(0x369fc506bbc70375), LL(0x1de18e1ef0dde3ba)}, {LL(0x5a628c0a0e8a059f), LL(0x27e05122d3a4e60d)}, {LL(0x9f2547d0cfb668a2), LL(0x7ead3816b0815c56)},
			{LL(0x7f119071fabfd90f), LL(0xaf7b5c763697540c)}, {LL(0x3afcb247d08fc254), LL(0x5a9e28984a6da32f)}, {LL(0x074940bef22a5f86), LL(0x5cfbaa0318fd91c7)}, {LL(0xe8768ddfc6798e93), LL(0xab3da025eb77c9bc)},
			{LL(0xbfeeeceb85b5945a), LL(0x5587aec1c7c6de48)}, {LL(0xc547cbdac13c6d3d), LL(0x594d69346325ba5b)}, {LL(0x4b7fa2890d64a594), LL(0x4dd0e3e84cc3166e)}, {LL(0x0dfaed3e4d461f56), LL(0xd95a5fc6ff15f1f9)},
			{LL(0xac023596ca474bbf), LL(0xc0fd2d8bd2288ff3)}, {LL(0xb17c6c54a2e12a95), LL(0xedb239c7f7ff3f05)}, {LL(0xf508d41daedfefb9), LL(0x8672b469cea0794a)}, {LL(0x81337393cd02a811), LL(0x328de49a5a7afc14)},
			{LL(0x111d2e8303eea00b), LL(0x6a30b2ca9f67f063)}, {LL(0x58937bf442967a71), LL(0xd8aa60a2592d47d5)}, {LL(0xd313a5e730f892b0), LL(0x6f8671fde4bfdbff)}, {LL(0xc924bc9baa74ac1c), LL(0x1e32cfb2d995face)},
			{LL(0xb8a7ac55779fcbdc), LL(0x097c04c2df3b4f8f)}, {LL(0x743ba78e63dd47a8), LL(0xb4ff50f394da855e)}, {LL(0x8b80de13726ee8c1), LL(0xb72c115fbd929c2a)}, {LL(0x1d7e59c268a6612a), LL(0x2d4f144c25d7b0f6)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x1a37197c9a8c3eac), LL(0x71b4be4f3d2a2131)}, {LL(0xf3d80edc7afb6e48), LL(0x44ace72a93f859e1)}, {LL(0x498e55774178da7a), LL(0xb29ad268c64ab7b6)}
		}, {
			{LL(0xe630efefb5ef3547), LL(0xe65f85138689a0af)}, {LL(0x6798babae4ba63e9), LL(0x67a57c21945ad618)}, {LL(0x86f78e8ede8eb28f), LL(0x8615296eab6477b8)}, {LL(0xad956e6efc6ee24e), LL(0xade5695e44ddf861)},
			{LL(0x587a76769976ab03), LL(0x583ee3d8ac1cdf6f)}, {LL(0x59a41e1eed1ecacf), LL(0x599d4946d2605eec)}, {LL(0xa32b1b1b211be90c), LL(0xa3f80ae6f570fa7f)}, {LL(0xa7d578783278aeba), LL(0xa731e7dbce43bb36)},
			{LL(0x9689c1c192c16d12), LL(0x96b71b9a47a8b05f)}, {LL(0x6b591f1fd11faaf0), LL(0x6b3d8866d90f15c3)}, {LL(0x14802c2c5f2c982b), LL(0x146bdfc9d7ff86ae)}, {LL(0x2de35353d953d52c), LL(0x2dbc3af228720f55)},
			{LL(0x184189896a895132), LL(0x18f32b8e9aaa4575)}, {LL(0xdd2c4040db40ba1b), LL(0xdd0df7d785fce891)}, {LL(0x347cb2b2c7b2e5d2), LL(0x34ecbbe2cca4cba3)}, {LL(0xc23212123e120f08), LL(0xc2110c05a6e1aceb)},
			{LL(0xcf2ddfdf7fdfa7dd), LL(0xcf2a52dc95c8eeb3)}, {LL(0x519bd8d8cbd84460), LL(0x51cc503ca406dc7e)}, {LL(0xc712191959192972), LL(0xc77b4ba6e3ae6c21)}, {LL(0xcef3b7b70bb7c611), LL(0xce89f842ebb46f30)},
			{LL(0xb0f4ececf1ec9506), LL(0xb07c05739b387dde)}, {LL(0xb28b3c3c193c575d), LL(0xb2f9928c67c0bc1b)}, {LL(0x2c3d3b3bad3bb4e0), LL(0x2c1f906c560e8ed6)}, {LL(0xcd520f0f970f6586), LL(0xcdafc52369302f76)},
			{LL(0xe0b15c5c4e5cb0aa), LL(0xe013ffd141422023)}, {LL(0x5a05a6a671a66958), LL(0x5abb742750e41eaa)}, {LL(0xefd14141e741da24), LL(0xefad36f78e93a3be)}, {LL(0x1ec03a3a913ad4df), LL(0x1ebf514c5d61c5f9)},
			{LL(0x1a3e595982599369), LL(0x1a76bc71665284b0)}, {LL(0x05200b0b670b267a), LL(0x056a47a3454fc0ca)}, {LL(0x68f8a7a74da70967), LL(0x681bb5075b8b5585)}, {LL(0x8f1620208c205dec), LL(0x8fe79a8aa37e74a9)},
			{LL(0xc9ac6c6c846c2230), LL(0xc966281e52036e3f)}, {LL(0x42442f2f1b2f386a), LL(0x42485fa9ca4e5bdf)}, {LL(0x72c6fefecffe9a0e), LL(0x726d09763dd9d135)}, {LL(0x8729e6e6aae6d343), LL(0x87b683f0d518f63b)},
			{LL(0xa474c0c0aec00d2d), LL(0xa417daba4cc7fb70)}, {LL(0xec70f9f97bf979b3), LL(0xec8b0b960c17e3f8)}, {LL(0x4d243232b23252e4), LL(0x4df6968f059fd842)}, {LL(0x5f25adad16ad4f22), LL(0x5fd1338415abde60)},
			{LL(0x6926cfcf39cf68ab), LL(0x69b81f9925f7d406)}, {LL(0xe310e4e4d2e4133d), LL(0xe335c2b0c3c66065)}, {LL(0xa8b565659b65c434), LL(0xa88f2efd019238ab)}, {LL(0x3ac2c7c71ac7ee90), LL(0x3af1d85a7d09c9bd)},
			{LL(0x03a1b8b89cb8a397), LL(0x03263d6182844046)}, {LL(0xb40a8f8fe28fd2b0), LL(0xb4b5e84ea00b3c97)}, {LL(0xc4b3a1a1c5a18ae5), LL(0xc45d76c7612a2c67)}, {LL(0x0ebe7575dd750b42), LL(0x0e1d63b8b1ad021e)},
			{LL(0x5d5a7d7dfe7d8d79), LL(0x5d54a47be9531fa5)}, {LL(0xa2f57373557388c0), LL(0xa25ba0788b0c7bfc)}, {LL(0x8556363642361118), LL(0x8533140f29e037fe)}, {LL(0x451bf4f494f4dc4b), LL(0x45a78ff573f95ad0)},
			{LL(0x523a60605760e7f7), LL(0x52ea6d5d26829c38)}, {LL(0x76389d9ddc9dddb8), LL(0x76a4e44b06ea907c)}, {LL(0x439a47476f4759a6), LL(0x43ebf537b432da5c)}, {LL(0xd39235350635b159), LL(0xd310946f3451ea8f)},
			{LL(0x3082d1d1d4d1a264), LL(0x302556dff7978aea)}, {LL(0x795880807580b736), LL(0x791a2d6dc93b13e1)}, {LL(0xd5138686fd8634b4), LL(0xd55ceeadf39a6a03)}, {LL(0xf431707011702881), LL(0xf478201896bda68d)},
			{LL(0x4ba581814981d709), LL(0x4bbaec4dc25458ce)}, {LL(0xd4cdeeee89ee5578), LL(0xd4ff44338de6eb80)}, {LL(0x0681b3b3fbb385ed), LL(0x064c7ac2c7cb808c)}, {LL(0x6366d9d9f7d9245f), LL(0x636c911caf699751)},
			{LL(0xf64ea0a0f9a0eada), LL(0xf6fdb7e76a456748)}, {LL(0xc3ec7a7a4a7a6ec4), LL(0xc3b2a69bd89d2d68)}, {LL(0xc56dc9c9b1c9eb29), LL(0xc5fedc591f56ade4)}, {LL(0xd9d22323c823fdad), LL(0xd9c41aeabecfa9d8)},
			{LL(0x39637f7f867f4d07), LL(0x39d7e53bff8d89fb)}, {LL(0xac4b060688068382), LL(0xac46c3c03aa179e2)}, {LL(0xfdd0dede43dec7e2), LL(0xfd8a93fc9ea7a59c)}, {LL(0x403bfffff3fffa31), LL(0x40cdc85636b69a1a)},
			{LL(0x7e075b5bfa5b5317), LL(0x7ef5fd31708c12ee)}, {LL(0xc193aaaaa2aaac9f), LL(0xc13731642465ecad)}, {LL(0x9a486464a764a40b), LL(0x9a2fefdd0afd7384)}, {LL(0xf790c8c88dc88b16), LL(0xf75e1d791439e6cb)},
			{LL(0xedae91910f91187f), LL(0xed28a108726b627b)}, {LL(0xd6b23e3e613e9723), LL(0xd67ad3cc711e2a45)}, {LL(0xcbd3bcbc6cbce06b), LL(0xcbe3bfe1aefbaffa)}, {LL(0xb8cb2a2ad72a1ba9), LL(0xb82d1c09ed5eff4c)},
			{LL(0xe7ee8787c187548b), LL(0xe7fc2f8df8f5212c)}, {LL(0x8d69f0f064f09fb7), LL(0x8d620d755f86b56c)}, {LL(0x1f1e5252e552b513), LL(0x1f1cfbd2231d447a)}, {LL(0xe44f3f3f5d3ff71c), LL(0xe4da12ec7a71616a)},
			{LL(0xf1117b7b767b0efb), LL(0xf11267bbd3f26647)}, {LL(0x80763d3d253d3762), LL(0x805953ac6caff734)}, {LL(0xbab4fafa3ffad9f2), LL(0xbaa88bf611a63e89)}, {LL(0x53e408082308863b), LL(0x5349c7c358fe1dbb)},
			{LL(0x291d3030ca30929a), LL(0x2975d7cf13414e1c)}, {LL(0xfe716666df666475), LL(0xfeacae9d1c23e5da)}, {LL(0x3fe2cccc7dccc8ea), LL(0x3f9b9ff938460977)}, {LL(0xe5915757295796d0), LL(0xe579b872040de0e9)},
			{LL(0x9d17bfbf28bf402a), LL(0x9dc03f81b34a728b)}, {LL(0xb35554546d543691), LL(0xb35a381219bc3d98)}, {LL(0xd1ede5e5eee57302), LL(0xd1950390c8a92b4a)}, {LL(0x6fa77c7cc27ced46), LL(0x6ff4655be23c548a)},
			{LL(0xca0dd4d418d481a7), LL(0xca40157fd0872e79)}, {LL(0x46ba4c4c084c7fdc), LL(0x4681b294f17d1a96)}, {LL(0xb7ab37377e377127), LL(0xb793d52f228f7cd1)}, {LL(0xa60b10104610cf76), LL(0xa6924d45b03f3ab5)},
			{LL(0x9277a2a281a22aa4), LL(0x927ef6a77c9bf116)}, {LL(0xb12a84848584f4ca), LL(0xb1dfafede544fc5d)}, {LL(0x8a362b2beb2b7b96), LL(0x8a8ddd29e631b463)}, {LL(0x16fffcfcb7fc5a70), LL(0x16ee48362b07476b)},
			{LL(0xf92ebdbd50bd8054), LL(0xf9437ec1a594e4d5)}, {LL(0xa5aaa8a8daa86ce1), LL(0xa5b4702432bb7af3)}, {LL(0xaacab5b573b5066f), LL(0xaa0ab902fd6af96e)}, {LL(0x8209ededcdedf539), LL(0x82dcc453905736f1)},
			{LL(0x91d61a1a1d1a8933), LL(0x9158cbc6fe1fb150)}, {LL(0x7fd933338e3332db), LL(0x7f5657af0ef0936d)}, {LL(0xf36eabab9eabcca0), LL(0xf397f0442f0aa782)}, {LL(0x199fe1e11ee130fe), LL(0x19508110e4d6c4f6)},
			{LL(0x65e76a6a0c6aa1b2), LL(0x6520ebde68a217dd)}, {LL(0x476424247c241e10), LL(0x4722180a8f019b15)}, {LL(0x9f686f6fc06f8271), LL(0x9f45a87e4fb2b34e)}, {LL(0x44c59c9ce09cbd87), LL(0x4404256b0d85db53)},
			{LL(0x2122f6f6ecf61c35), LL(0x2124ceb56527cc8e)}, {LL(0x0b9e7e7eba7e2d38), LL(0x0b77241bf4e2c2d4)}, {LL(0x49da5151a1511552), LL(0x493f7bb23eac990b)}, {LL(0xb9154242a3427a65), LL(0xb98eb69793227ecf)},
			{LL(0x9757a9a9e6a90cde), LL(0x9714b10439d431dc)}, {LL(0x0f601d1da91d6a8e), LL(0x0fbec926cfd1839d)}, {LL(0x315cb9b9a0b9c3a8), LL(0x3186fc4189eb0b69)}, {LL(0x41e5979787979bfd), LL(0x416e62c848ca1b99)},
			{LL(0xfc0eb6b637b6a62e), LL(0xfc293962e0db241f)}, {LL(0x899793937793d801), LL(0x89abe04864b5f425)}, {LL(0xa96b0d0def0da5f8), LL(0xa92c84637feeb928)}, {LL(0xde8df8f847f8198c), LL(0xde2bcab60778a8d7)},
			{LL(0x2e42ebeb45eb76bb), LL(0x2e9a0793aaf64f13)}, {LL(0x94f611117a11af49), LL(0x94328c65bb50719a)}, {LL(0xbe4a99992c999e44), LL(0xbe6166cb2a957fc0)}, {LL(0x4f5be2e25ae290bf), LL(0x4f730170f9671987)},
			{LL(0xd76c56561556f6ef), LL(0xd7d979520f62abc6)}, {LL(0xc8720404f00443fc), LL(0xc8c582802c7fefbc)}, {LL(0xda739b9b549b5e3a), LL(0xdae2278b3c4be99e)}, {LL(0x3d9d1c1c951c0ab1), LL(0x3d1e0806c4bec8b2)},
			{LL(0x20fc9e9e989e7df9), LL(0x2087642b1b5b4d0d)}, {LL(0x7167464653463999), LL(0x714b3417bf5d9173)}, {LL(0x27a34545174599d8), LL(0x2768b477a2ec4c02)}, {LL(0xe950f2f21cf25fc9), LL(0xe9e14c3549582332)},
			{LL(0xd80c4b4bbc4b9c61), LL(0xd867b074c0b3285b)}, {LL(0x6a877777a577cb3c), LL(0x6a9e22f8a7739440)}, {LL(0x360362622f622789), LL(0x36692c1d305c0a66)}, {LL(0xfb516d6db86d420f), LL(0xfbc6e93e596c2510)},
			{LL(0x3b1cafaf6eaf8f5c), LL(0x3b5272c40375483e)}, {LL(0xc6cc71712d7148be), LL(0xc6d8e1389dd2eda2)}, {LL(0x73189696bb96fbc2), LL(0x73cea3e843a550b6)}, {LL(0x4a7be9e93de9b6c5), LL(0x4a1946d3bc28d94d)},
			{LL(0xbf94f1f158f1ff88), LL(0xbfc2cc5554e9fe43)}, {LL(0x7af93838e93814a1), LL(0x7a3c100c4bbf53a7)}, {LL(0x6dd8acac2aac2f1d), LL(0x6d71f2a41ec4954f)}, {LL(0x9b960c0cd30cc5c7), LL(0x9b8c45437481f207)},
			{LL(0xf2b0c3c3eac3ad6c), LL(0xf2345ada51762601)}, {LL(0x952879790e79ce85), LL(0x959126fbc52cf019)}, {LL(0x107e4f4f4c4fdf9d), LL(0x10a232f4ecccc7e7)}, {LL(0xbdeb2121b0213dd3), LL(0xbd475baaa8113f86)},
			{LL(0x6c06c4c45ec44ed1), LL(0x6cd2583a60b814cc)}, {LL(0x35a2dadab3da841e), LL(0x354f117cb2d84a20)}, {LL(0xbb6a92924b92b83e), LL(0xbb0b21686fdabf0a)}, {LL(0x1cbfeaea79ea1684), LL(0x1c3ac6b3a199043c)},
			{LL(0x7599252540257e2f), LL(0x7582d92a846ed03a)}, {LL(0x3c437474e1746b7d), LL(0x3cbda298bac24931)}, {LL(0x77e6f5f5a8f5bc74), LL(0x77074ed5789611ff)}, {LL(0x56c403034403a041), LL(0x562380601db1dd71)},
			{LL(0x9837b4b44fb46650), LL(0x98aa7822f605b241)}, {LL(0x075fdbdb8fdbe421), LL(0x07efd05cb9b7010f)}, {LL(0x70b92e2e272e5855), LL(0x70e89e89c12110f0)}, {LL(0x155e44442b44f9e7), LL(0x15c87557a983072d)},
			{LL(0x8849fbfb03fbb9cd), LL(0x88084ad61ac975a6)}, {LL(0x2abc88885688310d), LL(0x2a53eaae91c50e5a)}, {LL(0xb5d4e7e796e7b37c), LL(0xb51642d0de77bd14)}, {LL(0xf0cf131302136f37), LL(0xf0b1cd25ad8ee7c4)},
			{LL(0x54bbd3d3acd3621a), LL(0x54a6179fe1491cb4)}, {LL(0x22834e4e704ebfa2), LL(0x2202f3d4e7a38cc8)}, {LL(0x083fc6c626c68eaf), LL(0x0851197a76668292)}, {LL(0xdbadf3f320f33ff6), LL(0xdb418d154237681d)},
			{LL(0xee0f29299329bbe8), LL(0xee0e9c69f0ef223d)}, {LL(0x643902027802c07e), LL(0x6483414016de965e)}, {LL(0xeaf14a4a804afc5e), LL(0xeac77154cbdc6374)}, {LL(0x7886e8e801e8d6fa), LL(0x78b987f3b7479262)},
			{LL(0x5c8415158a15ecb5), LL(0x5cf70ee5972f9e26)}, {LL(0xeb2f2222f4229d92), LL(0xeb64dbcab5a0e2f7)}, {LL(0x28c35858be58f356), LL(0x28d67d516d3dcf9f)}, {LL(0xe2ce8c8ca68c72f1), LL(0xe296682ebdbae1e6)},
			{LL(0x611909091f09e604), LL(0x61e906e353915694)}, {LL(0x235d26260426de6e), LL(0x23a1594a99df0d4b)}, {LL(0x1be03131f631f2a5), LL(0x1bd516ef182e0533)}, {LL(0x9cc9d7d75cd721e6), LL(0x9c63951fcd36f308)},
			{LL(0x60c761616b6187c8), LL(0x604aac7d2dedd717)}, {LL(0x8cb798981098fe7b), LL(0x8cc1a7eb21fa34ef)}, {LL(0x4e858a8a2e8af173), LL(0x4ed0abee871b9804)}, {LL(0x11a027273827be51), LL(0x1101986a92b04664)},
			{LL(0xd24c5d5d725dd095), LL(0xd2b33ef14a2d6b0c)}, {LL(0xe16f34343a34d166), LL(0xe1b0554f3f3ea1a0)}, {LL(0x5565bbbbd8bb03d6), LL(0x5505bd019f359d37)}, {LL(0x027fd0d0e8d0c25b), LL(0x028597fffcf8c1c5)},
			{LL(0x74474d4d344d1fe3), LL(0x742173b4fa1251b9)}, {LL(0x09e1aeae52aeef63), LL(0x09f2b3e4081a0311)}, {LL(0xa08aa3a3bda34a9b), LL(0xa0de378777f4ba39)}, {LL(0x9eb60707b407e3bd), LL(0x9ee602e031ce32cd)},
			{LL(0x2f9c838331831777), LL(0x2f39ad0dd48ace90)}, {LL(0x571a6b6b306bc18d), LL(0x57802afe63cd5cf2)}, {LL(0x17219494c3943bbc), LL(0x174de2a8557bc6e8)}, {LL(0x33236969486901f3), LL(0x33036bbe7513caac)},
			{LL(0x0a401616ce164cf4), LL(0x0ad48e858a9e4357)}, {LL(0x3e3ca4a409a4a926), LL(0x3e383567463a88f4)}, {LL(0x84885e5e365e70d4), LL(0x8490be91579cb67d)}, {LL(0x7da6e3e366e3f080), LL(0x7dd3c050f20852a8)},
			{LL(0x62b8b1b183b14593), LL(0x62cf3b82d11516d2)}, {LL(0x04fe6363136347b6), LL(0x04c9ed3d3b334149)}, {LL(0xafeabebe14be2015), LL(0xaf60fea1b82539a4)}, {LL(0x01de6868746861cc), LL(0x01a3aa9e7e7c8183)},
			{LL(0x5045b0b0bfb025ac), LL(0x506ffaa2da7a5dfd)}, {LL(0x2b62e0e022e050c1), LL(0x2bf04030efb98fd9)}, {LL(0x5efbc5c562c52eee), LL(0x5e72991a6bd75fe3)}, {LL(0x81a85555515556ae), LL(0x81faf93212d376b7)},
			{LL(0x99e9dcdc3bdc079c), LL(0x9909d2bc887933c2)}, {LL(0xae34d6d660d641d9), LL(0xaec3543fc659b827)}, {LL(0xab14dddd07dd67a3), LL(0xaba9139c831678ed)}, {LL(0x6646d2d290d20225), LL(0x6606d6bfea26579b)},
			{LL(0xb6755f5f0a5f10eb), LL(0xb6307fb15cf3fd52)}, {LL(0xdf53909033907840), LL(0xdf88602879042954)}, {LL(0x1d6182820d827748), LL(0x1d996c2ddfe585bf)}, {LL(0x7b2750509d50756d), LL(0x7b9fba9235c3d224)},
			{LL(0x4cfa5a5ac65a3328), LL(0x4c553c117be359c1)}, {LL(0x900872726972e8ff), LL(0x90fb6158806330d3)}, {LL(0x13dff7f7d0f77c0a), LL(0x13840f956e4887a1)}, {LL(0x2402fdfd8bfd3a4f), LL(0x244e891620680c44)},
			{LL(0x0cc1a5a535a5c919), LL(0x0c98f4474d55c3db)}, {LL(0xc04dc2c2d6c2cd53), LL(0xc0949bfa5a196d2e)}, {LL(0x83d78585b98594f5), LL(0x837f6ecdee2bb772)}, {LL(0xffaf0e0eab0e05b9), LL(0xff0f0403625f6459)},
			{LL(0x38bd1717f2172ccb), LL(0x38744fa581f10878)}, {LL(0x37dd0a0a5b0a4645), LL(0x37ca86834e208be5)}, {LL(0xa154cbcbc9cb2b57), LL(0xa17d9d1909883bba)}, {LL(0xdcf22828af28dbd7), LL(0xdcae5d49fb806912)},
			{LL(0x93a9cacaf5ca4b68), LL(0x93dd5c3902e77095)}, {LL(0x7c788b8b128b914c), LL(0x7c706ace8c74d32b)}, {LL(0x8ec84848f8483c20), LL(0x8e443014dd02f52a)}, {LL(0xcc8c6767e367044a), LL(0xcc0c6fbd174caef5)},
			{LL(0xe88e9a9a689a3e05), LL(0xe842e6ab3724a2b1)}, {LL(0x12019f9fa49f1dc6), LL(0x1227a50b10340622)}, {LL(0x267d2d2d632df814), LL(0x26cb1ee9dc90cd81)}, {LL(0x48043939d539749e), LL(0x489cd12c40d01888)},
			{LL(0x0d1fcdcd41cda8d5), LL(0x0d3b5ed933294258)}, {LL(0xf5ef18186518494d), LL(0xf5db8a86e8c1270e)}, {LL(0xd0338d8d9a8d12ce), LL(0xd036a90eb6d5aac9)}, {LL(0x8be843439f431a5a), LL(0x8b2e77b7984d35e0)},
			{LL(0x32fd01013c01603f), LL(0x32a0c1200b6f4b2f)}, {LL(0x6e791414b6148c8a), LL(0x6e57cfc59c40d509)}, {LL(0x25dc9595ff955b83), LL(0x25ed23885e148dc7)}, {LL(0xfa8f0505cc0523c3), LL(0xfa6543a02710a493)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x5bdbcece05ce0894), LL(0x5b18deb92e989f29)}, {LL(0xbc354949c4495c1f), LL(0xbce4f134d66dbe05)}, {LL(0xf8f0d5d524d5e198), LL(0xf8e0d45fdbe86556)}
		}, {
			{LL(0xc97c0997c50f5fab), LL(0xfe8781fdbd39c542)}, {LL(0xf81cdd05decea5bb), LL(0x2bccdfc36145de12)}, {LL(0x528c08391fcf1583), LL(0x1cd5129ea8ff1fca)}, {LL(0xd22ec32c6699e50d), LL(0x065f052b24566639)},
			{LL(0x059c2ebffab03e3a), LL(0x6528b62a3354fad2)}, {LL(0x927f47c7bbb29d4a), LL(0x0b1aef9062e3bba1)}, {LL(0x1435b8b96e85f8e8), LL(0x57a09da8cc936ece)}, {LL(0x0d3fdf9aa98d31eb), LL(0x2c683a054b0aa9c1)},
			{LL(0x36a457b585efb78f), LL(0x3373cb6ff1de85f6)}, {LL(0xd302746054d63dbe), LL(0xa657f5f72b2d5403)}, {LL(0x7d2238af5d286b0f), LL(0x546e7e5cdeb85d33)}, {LL(0x74ad7ec63c5abc6d), LL(0xbd2602afa99d3c1a)},
			{LL(0x563c91cad730f30a), LL(0xd9f5546894d0d722)}, {LL(0x2df69d0e26790d29), LL(0xcbab4fb968b1268d)}, {LL(0xb5728674aa68ec17), LL(0x0ae10f7d6cfaaa4b)}, {LL(0x1826d06ff54711b0), LL(0xdbc0577188e2f535)},
			{LL(0xa4db10723e5d2ac5), LL(0x386924ff933d3e57)}, {LL(0xa06b8981f6a2cc4c), LL(0xfd496209af12f6bf)}, {LL(0x96cfde34734d7bc3), LL(0xce3aa9665ecc7349)}, {LL(0x3338790a7f5f89b5), LL(0x565b7d45c28a7f24)},
			{LL(0x0afb5cbd37a37c74), LL(0xca50af5466a83767)}, {LL(0xe7fe8e4db5a7f994), LL(0x16341de3c405b581)}, {LL(0xe34e17be7d581f1d), LL(0xd3145b15f82a7d69)}, {LL(0x49dec282bc59af25), LL(0xe40d96483190bcb1)},
			{LL(0x3d73bc4480031348), LL(0x592b94e7980d80ab)}, {LL(0xe899fc4f78b4bbda), LL(0xb94c049d91f97834)}, {LL(0x6c8baea9c91daddd), LL(0x66e655de217fc92f)}, {LL(0xa2332419923cbfe9), LL(0x7e594172b1e492cb)},
			{LL(0xbb39433a553476ea), LL(0x0591e6df367d55c4)}, {LL(0x8ee90e5b860a6a73), LL(0x15fafe17d62e867c)}, {LL(0xa9e4cfe897d01b2e), LL(0x14011efad8379796)}, {LL(0xf77baf0713dde7f5), LL(0x84b4c6bd34b913a7)},
			{LL(0x50d4a5a17b516626), LL(0x9fc531e5b6097bbe)}, {LL(0xbea56d85af8448d0), LL(0x60b950f50529af16)}, {LL(0x12dd8cd2c2e46dc4), LL(0x1190f825ee4ac252)}, {LL(0xc56f61415ecdb6f3), LL(0x72e74b24f9485eb9)},
			{LL(0x77d964126a8b177b), LL(0x9e3ed108b8106a54)}, {LL(0x166d15210a1b8b4d), LL(0xd4b0bed3d2650aba)}, {LL(0xef5d7f68e69af645), LL(0x5f7491ccbc5be692)}, {LL(0x6670f214febed1a9), LL(0xacb6fa8a47d7fe48)},
			{LL(0x3e07a690d6d2b85e), LL(0x7a3347408980d6e5)}, {LL(0x479507cc430535d8), LL(0xeb7d7fea6b17433e)}, {LL(0x5cc7cd77e0938f7e), LL(0x13a5fb3cf278e045)}, {LL(0x7369fde1a274f1f2), LL(0x5b1e97fe843fa2bc)},
			{LL(0x7ae6bb88c3062690), LL(0xb256eb0df31ac395)}, {LL(0x13f13b9ef0abb577), LL(0xb19808f9e131f068)}, {LL(0xec2965bcb04b5d53), LL(0x7c6c426badd6b0dc)}, {LL(0xc61b7b95081c1de5), LL(0x51ff9883e8c508f7)},
			{LL(0x8b7520e47cba5449), LL(0x70d2483de57a7cae)}, {LL(0x83d6d1c12f875b98), LL(0x3992c4129d242fbd)}, {LL(0x286ab3b1dcc93313), LL(0xae83f9935be5dc5f)}, {LL(0xdd49b12eab8aa743), LL(0xa9271c5571aaab8c)},
			{LL(0xda8d320935a4eadc), LL(0x4f1f89045c08352a)}, {LL(0x0bd7ebf105eca4c7), LL(0x6a585f8869d3055d)}, {LL(0x294604fdee86eba0), LL(0x0e8b094f549eee65)}, {LL(0xebede69b2e6510cc), LL(0x9a54d73a80742e7a)},
			{LL(0xac78e1576d602514), LL(0x7129a8d0eb636d44)}, {LL(0x5a2ff91c4cf21a52), LL(0x55959eb1d0a14cd9)}, {LL(0x1fe253486b695c2f), LL(0x3df8c220a5406b93)}, {LL(0x405184ebdd2b7847), LL(0x0d45eabb46b5dd98)},
			{LL(0x1b52cabba396baa6), LL(0xf8d884d6996fa37b)}, {LL(0x88013a302a6bff5f), LL(0x53ca9b9af4f72ae0)}, {LL(0xf40fb5d3450c4ce3), LL(0xa7ac151a253445e9)}, {LL(0xe116ba2619c66cb8), LL(0x5004786ee6dc191d)},
			{LL(0xad54561b5f2ffda7), LL(0xd121580ce4185f7e)}, {LL(0x8fc5b917b445b2c0), LL(0xb5f20ecbd955b446)}, {LL(0x7bca0cc4f149fe23), LL(0x125e1bd1fc61f1af)}, {LL(0x34fcfa2de171c42a), LL(0xb063e814ef28e182)},
			{LL(0x098f46696172d762), LL(0xe9487cf377256129)}, {LL(0x45cdaa54279b467d), LL(0x686d5c9175e1274a)}, {LL(0xe5a623d5d1398a31), LL(0x95243e98daf3d1f5)}, {LL(0x53a0bf752d80cd30), LL(0xbcdde242a7842df0)},
			{LL(0x39c325b748fcf5c1), LL(0x9c0bd211a4224843)}, {LL(0x62c06be736413720), LL(0x6996bc7c7bf836a0)}, {LL(0x1dbafed00ff72f8a), LL(0xbee8e15bbbb60fe7)}, {LL(0x3ab73f631e2d5ed7), LL(0xbf1301b6b5af1e0d)},
			{LL(0x818e7c594b19283d), LL(0xba82e76983d24bc9)}, {LL(0x6504e8c0a86f7abf), LL(0x8fae292d565aa806)}, {LL(0xbdd17751f955e3c6), LL(0x43a1835214a4f958)}, {LL(0x38ef92fb7ab32d72), LL(0x3c0322cdab597a79)},
			{LL(0x5e9f60ef840dfcdb), LL(0x90b5d847ec8e8431)}, {LL(0x1a7e7df791d96215), LL(0x58d0740a96149141)}, {LL(0x35d04d61d33e1c99), LL(0x106b18c8e053d3b8)}, {LL(0x2479db67470bda4b), LL(0x22e3334a1f9447a4)},
			{LL(0xceb88ab05b211234), LL(0x18bf14ac909b5be4)}, {LL(0xa683bdea5ac35960), LL(0xbb7907848dcb5a23)}, {LL(0xd5ea400bf8b7a892), LL(0xe067907a09f4f89f)}, {LL(0x4d6e5b7174a649ac), LL(0x212dd0be0dbf7459)},
			{LL(0x6da719e5fb52756e), LL(0xc6eea5022e04fb15)}, {LL(0x9f40985d123faca1), LL(0x2772d59529e91260)}, {LL(0xfd80f3ba247e9b81), LL(0x4ee469e9521124c0)}, {LL(0xb39ab21f0609793b), LL(0x4cd16af04e2306d7)},
			{LL(0x7e56227b0bf9c019), LL(0x7776adfbcf350b7d)}, {LL(0x701de735f4a55ae4), LL(0x7806445995b2f4f2)}, {LL(0x06e8346bac61952c), LL(0x4630658d22d9ac9c)}, {LL(0xca08134393def4bd), LL(0xdd9f525aacb4930c)},
			{LL(0x2a321e29b85740b6), LL(0x2d93dae84513b82b)}, {LL(0xa7af0aa6688c81d3), LL(0x1b71f75882b06819)}, {LL(0x6917801633ad93e7), LL(0x03cee3f4122b33fd)}, {LL(0x9adcb6e2e88f929b), LL(0x425a63bf1abde8b2)},
			{LL(0x2fae309642e77e8c), LL(0x48bb6cc2764742f9)}, {LL(0x9d1835c576a1df04), LL(0xa462f6ee371f7614)}, {LL(0x7992a15c95d78d86), LL(0x914e38aae29795db)}, {LL(0x9027ea5fdf2ceeef), LL(0x880acceb7c15dfd5)},
			{LL(0xfcac44f616314332), LL(0xeeec99355d6a16fa)}, {LL(0xe03a0d6a2b89b40b), LL(0xf00c88b2e9a72b27)}, {LL(0xb1c21f8762970a9e), LL(0xcfc1498b50d562a3)}, {LL(0x4b866f1ad8c7dc80), LL(0x671db5332f66d8c5)},
			{LL(0x55488b1e81e1581c), LL(0xfaed87cf855d816c)}, {LL(0xae204ccf09fe56b1), LL(0xf2398babf5950930)}, {LL(0x23bd5840d92597d4), LL(0xc4dba61b3236d902)}, {LL(0xc1dff8b29632507a), LL(0xb7c70dd2c5679651)},
			{LL(0x15190ff55cca205b), LL(0xf7a86d74c3e85cf4)}, {LL(0x304c63de298e22a3), LL(0x7543aee2d307296a)}, {LL(0x9353f08b89fd45f9), LL(0xab121f4c6d98899b)}, {LL(0x4aaad856ea880433), LL(0xc71545ef201deaff)},
			{LL(0x5fb3d7a3b6422468), LL(0x30bd289be3f5b60b)}, {LL(0x48f275ce8e167796), LL(0x440566943eeb8e8b)}, {LL(0xf657184b21923f46), LL(0x24bc36613bc2219d)}, {LL(0xaf0cfb833bb18e02), LL(0x52317b77faee3b0a)},
			{LL(0xa1473ecdc4ed14ff), LL(0x5d4192d5a069c485)}, {LL(0x51f812ed491ebe95), LL(0x3fcdc139b9724984)}, {LL(0x3b9b882f2c628664), LL(0x1f1bf16abad42c37)}, {LL(0xc443d60d6c826e40), LL(0xd2efbbf8f6336c83)},
			{LL(0x72454aad903b2941), LL(0xfb1667228b449086)}, {LL(0x03741ad456d1ab16), LL(0x2318d3a7118d564e)}, {LL(0xcb24a40fa1912c0e), LL(0x7d97a286a3cfa136)}, {LL(0x57102686e57f2bb9), LL(0x79fda4b49babe518)},
			{LL(0x0e4bc54eff5c9afd), LL(0x0f70e9a25a87ff8f)}, {LL(0xdba1854507eb326f), LL(0xef1779d853730710)}, {LL(0xcce027283fbf6191), LL(0x9baf37d78e6d3f90)}, {LL(0x0258ad98649e73a5), LL(0x8310237b1ef66474)},
			{LL(0xf2e781b8e96dd9cf), LL(0xe19c709707ede975)}, {LL(0xc737ccd93a53c556), LL(0xf1f7685fe7be3acd)}, {LL(0x4e1a41a52277e2ba), LL(0x023503191c322217)}, {LL(0x1085214aa67a1e61), LL(0x9280db5ef0bca626)},
			{LL(0xc850bedbf7408718), LL(0x5e8f7121b242f778)}, {LL(0x683b375a01e24b54), LL(0xa3c613281d5001c7)}, {LL(0xabbc6270f34e688b), LL(0x97113d81c6c1f3e2)}, {LL(0x98841b7a8c11e13e), LL(0xc14a40c4044b8cc6)},
			{LL(0xa31f9355a073675a), LL(0xde51b1aebe9fa0f1)}, {LL(0x44e11d1815d49ece), LL(0xc865ac4d7a9a1570)}, {LL(0x58775484286c69f7), LL(0xd685bdcace5728ad)}, {LL(0x11a996069435c6d2), LL(0x32882b82ffc7941c)},
			{LL(0xe48a9499e3765282), LL(0x352cce44d588e3cf)}, {LL(0x012cb74c324fd8b3), LL(0xa008f0dc0f7b323a)}, {LL(0x853ee5aa83e6ceb4), LL(0x7fa2a19fbffd8321)}, {LL(0x8cb1a3c3e29419d6), LL(0x96eadd6cc8d8e208)},
			{LL(0x5b034e507ebdc2e1), LL(0xf59d6e6ddfda7ee3)}, {LL(0x20c942948ff43cc2), LL(0xe7c375bc23bb8f4c)}, {LL(0x270dc1b311da715d), LL(0x01fbe0ed0e1911ea)}, {LL(0x8a5997a84ef58cfa), LL(0xd0dab8e1ea014e94)},
			{LL(0xb45e3138982734a4), LL(0xaae9ffa163819871)}, {LL(0x4c42ec3d46e9911f), LL(0x8125206202c44663)}, {LL(0x64285f8c9a20a20c), LL(0x2fa6d9f159219a3c)}, {LL(0xb6069ca0fcb94701), LL(0x29f9dcda7d77fc05)},
			{LL(0xb0eea8cb50d8d22d), LL(0x6fc9b9575fae5099)}, {LL(0x2291ef0ceb6a4f67), LL(0x64d356c73d4deb38)}, {LL(0x42092973b9b50be2), LL(0x8e55c9c05843b9ec)}, {LL(0x4f36f6e910383a09), LL(0xa23df3c51349102d)},
			{LL(0x71315079c6ea8257), LL(0xd80eb4859ac9c6c8)}, {LL(0x87664832e778bd11), LL(0xfcb282e4a10be755)}, {LL(0x9c34828944ee07b7), LL(0x046a06323864442e)}, {LL(0xc387552af2ac23df), LL(0x34d72ea9db91f225)},
			{LL(0xf0bf2c208df3aa6a), LL(0x628c53ec191b8d01)}, {LL(0x63ecdcab040eef93), LL(0xc99e4ca07483049a)}, {LL(0xffd85e2240e0e824), LL(0xcdf44a924ce740b4)}, {LL(0xeac151d71c2ac87f), LL(0x3a5c27e68f0f1c40)},
			{LL(0x949773ac17d30866), LL(0x4d2a8a1d403a173d)}, {LL(0x1741a26d385453fe), LL(0x74b84e0fdd1e3880)}, {LL(0x841252e6b1a91607), LL(0xdfaa5143b086b11b)}, {LL(0x595be3c81a23b144), LL(0x768d4d16c12c1a97)},
			{LL(0x2e8287da70a8a63f), LL(0xe8b39c1e793c70c3)}, {LL(0x25556c2b754402f8), LL(0x82ebc39610ef759e)}, {LL(0x3214ce464d105106), LL(0xf6538d99cdf14d1e)}, {LL(0xd9f928dd637541ca), LL(0x6c075aa34d856364)},
			{LL(0xfb68c7d1881f0ead), LL(0x08d40c6470c8885c)}, {LL(0x82fa668d1dc8832b), LL(0x999a34ce925f1d87)}, {LL(0xe262a0f24f17c7ae), LL(0x731cabc9f7514f53)}, {LL(0xcdcc90640df0b922), LL(0x3ba7c70b81160daa)},
			{LL(0x1c96499c3db8f739), LL(0x1ee01187b4cd3ddd)}, {LL(0x7581c98a0e1564de), LL(0x1d2ef273a6e60e20)}, {LL(0xfa44709dba50d61e), LL(0xa8dcfcb87fb3ba66)}, {LL(0xd0766eb4020796a8), LL(0x854f26503aa0024d)},
			{LL(0x0c1368d69bc2e958), LL(0x8c60cad944719bfb)}, {LL(0xb2b605533446a188), LL(0xecd99a2c415834ed)}, {LL(0x2cda2a421436d59a), LL(0x6ba3bf6567ca14b7)}, {LL(0xe9b54b034afb6369), LL(0x1944f4419e824a0e)},
			{LL(0x9bf001aedac04a28), LL(0xe252936315c6da88)}, {LL(0x8d9d148fd0dbc165), LL(0x36e22db0c7a3d032)}, {LL(0x95bbc4e0259cd0d5), LL(0xed227ac14f412507)}, {LL(0xf3cb36f4db22017c), LL(0x4194804b0896db4f)},
			{LL(0x7c0e8fe36f67b3bc), LL(0xf4668e80d1c36f09)}, {LL(0xaa90d53cc101b038), LL(0x3719cd5dc9bac1d8)}, {LL(0xb961eea231aa054f), LL(0x8681c5a4288b31b0)}, {LL(0xed05d2f0820485e0), LL(0xdc64b2b7a2ad82e6)},
			{LL(0xe6d2390187e82127), LL(0xb63ced3fcb7e87bb)}, {LL(0xa5f7a73e0c12f276), LL(0x9861d4239c460c6d)}, {LL(0x6ed30331ad83de78), LL(0xe5f676a53f89ad5b)}, {LL(0x04b099f3c8ffe689), LL(0xc52046f63c2fc8e8)},
			{LL(0x99a8ac36be5e398d), LL(0x6142b0180b30befc)}, {LL(0x54643c52b3ae80af), LL(0x5ae577138a26b356)}, {LL(0x07c483279e2e4d9f), LL(0xe63895512da29ea6)}, {LL(0xd69e5adfae660384), LL(0xc37f43dd1879aed1)},
			{LL(0xdf111cb6cf14d4e6), LL(0x2a373f2e6f5ccff8)}, {LL(0x6a639ac2657c38f1), LL(0x20d6305303a665b3)}, {LL(0xbf89dac99dcb9063), LL(0xc0b1a0290a529d2c)}, {LL(0x43259e3f8bfad351), LL(0x2e5d391c57388bd6)},
			{LL(0x76f5d35e58c4cfc8), LL(0x3e3621d4b76b586e)}, {LL(0x190a6723c708c903), LL(0x7bc8a7ad8799c70f)}, {LL(0x3f2b11dce49d60ed), LL(0xda3bb79c86fbe4df)}, {LL(0x97e369784102a370), LL(0x6e3259ba51b74173)},
			{LL(0x3788e0f9b7a06f3c), LL(0x937b3bb3fea5b7cc)}, {LL(0x80a2cb157956f08e), LL(0x1a8a17b58ca979f3)}, {LL(0xf1939b6cbfbc72d9), LL(0xc284a3301660bf3b)}, {LL(0x3160d4921bc1fa10), LL(0xd54b5e3edc7c1b50)},
			{LL(0x675c4558ccf1091a), LL(0x0cbe0a5648accc72)}, {LL(0xa8c878a4a59fc39d), LL(0xb409ee26d74ca5ac)}, {LL(0x262176ff2395a9ee), LL(0xa1f31031016223d0)}, {LL(0x6fffb47d9fcc06cb), LL(0x45fe867930f29f61)},
			{LL(0xfef4e96e72af3097), LL(0x6dfcba4e439c728e)}, {LL(0xc0f34ffea47d88c9), LL(0x17cffd0eca1ca46b)}, {LL(0xd8d59f91513a9979), LL(0xcc0faa7f42fe515e)}, {LL(0xb72a2beccef69fb2), LL(0x89f12c06720cce3f)},
			{LL(0x78be1610a7985535), LL(0x3146c876edeca7e1)}, {LL(0xc2abe266c0e3fb6c), LL(0x94dfde75d4eac01f)}, {LL(0x1ecee4045926849c), LL(0x9df032fcaa3b59a9)}, {LL(0xd15ad9f830484e1b), LL(0x2547d68c35db3077)},
			{LL(0x2b1ea9658a189805), LL(0x8d9b2a344a688a11)}, {LL(0xf523029f77439450), LL(0x07a4e5c62a4f77d3)}, {LL(0xdc65066299c57ff0), LL(0x092fec897ed199b6)}, {LL(0x08a3f125533d0fd1), LL(0x49408c2f785e5313)},
			{LL(0x9e6c2f1120707412), LL(0x877a25492692205a)}, {LL(0xcf943dfc696eca87), LL(0xb8b7e4709fe069de)}, {LL(0xf9306a49ec817d08), LL(0x8bc42f1f6e3eec28)}, {LL(0xba15f476677bae59), LL(0xa5991603390667fe)},
			{LL(0xb84d59ee03e5ddfc), LL(0x2689357827f0038a)}, {LL(0xd4c6f747caf87021), LL(0x406f60a6068fcaa5)}, {LL(0x6098c67f52df4485), LL(0xea869f07650e52d4)}, {LL(0xde3dabfafd5b0c55), LL(0x8a3fcff26027fdc2)},
			{LL(0x0f677202cd13424e), LL(0xaf78197e55fccdb5)}, {LL(0x892d8d7c182427ec), LL(0xf3c26b46fb8c18da)}, {LL(0x3c5f0b08b24ccbfb), LL(0xf923643b9776b291)}, {LL(0x61b4713360909c36), LL(0x4a8e6fdb6a7560ee)},
			{LL(0xbcfdc01dcb1a3b75), LL(0xe3a9738e1bdfcb62)}, {LL(0xd7b2ed939c29db37), LL(0x6377b30117029ceb)}, {LL(0x910b5d13ed63365c), LL(0x28023c37736eedef)}, {LL(0xee71c824d4d52ef6), LL(0xff7c6110b320d4a8)},
			{LL(0x417d33a7ef64a0f4), LL(0xad4d1a6749ceefa2)}, {LL(0x5deb7a3bd2dc57cd), LL(0xb3ad0be0fd03d27f)}, {LL(0x46b9b080714aed6b), LL(0x4b758f36646c7104)}, {LL(0x864aff7ed53765a2), LL(0x5cba7238ae70d56f)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x7f7a953739b618aa), LL(0xd77e5d27c04e3947)}, {LL(0x21e5f5d8bdbbe471), LL(0x47cb85602cc0bd76)}, {LL(0x6b4f2d8e5733e042), LL(0x80dec08f0cdd5789)}
		}, {
			{LL(0xa5f8edb8b8bf36c2), LL(0x5c52844aa52d6aff)}, {LL(0x2d380a9a9ad18b95), LL(0x4ddb24972d2fc673)}, {LL(0x32db72eded5430a6), LL(0x972657bc3228a762)}, {LL(0x8f5c58535312cf27), LL(0xc84a72e18f49071d)},
			{LL(0x0efbbde2e2f8e4e0), LL(0x714567780e9695e1)}, {LL(0x30fe4d0c0c315186), LL(0x067c812e309857c3)}, {LL(0x386ab10e0e661606), LL(0x07d75f23381d1102)}, {LL(0xc07ef73030c4875d), LL(0x183341b8c0259f8a)},
			{LL(0x548ba91515993109), LL(0xeb302f9554c8da07)}, {LL(0xe604c0d8d8f4fb78), LL(0x6c3406f9e6679728)}, {LL(0x9e449dc6c66f90f4), LL(0x63f266b29ed8f3ed)}, {LL(0x39994f9f9fb5c716), LL(0xaefa346a394569b3)},
			{LL(0x55785784844ae019), LL(0x421d44dc5590a2b6)}, {LL(0x7e2f1cfefe34c8ec), LL(0x7f28d93e7eacb7e5)}, {LL(0x52e4e8f5f5369269), LL(0x9bde96e052db0927)}, {LL(0x914cdeb5b544a504), LL(0xbb9a6a8391161ebd)},
			{LL(0x6475e41919a8608f), LL(0xed4caebb64508dc4)}, {LL(0x03d6c17070b6b030), LL(0x3877bddb03e88810)}, {LL(0x575d6865652f8139), LL(0xd347924e57205217)}, {LL(0x5a7014f7f761d5e9), LL(0x9a7548ed5a5e4fe6)},
			{LL(0x1c35b90707330b03), LL(0xe28acef01cefe901)}, {LL(0x603f9a181862a2cf), LL(0x0cf8c15c60f3ae45)}, {LL(0x079cbf71717c7270), LL(0xd9c3d23c074bab91)}, {LL(0x187fc70606f9c943), LL(0x033ea117184cca80)},
			{LL(0x21e68899994c0e55), LL(0xadc4957d2109a333)}, {LL(0x72f19efdfda94d2c), LL(0x9f3768d4728ad2a5)}, {LL(0xa8d5912a2af16212), LL(0x15605ee9a853770e)}, {LL(0xd16632a5a5b9d88e), LL(0xb38b55ebd1b46b7a)},
			{LL(0x2972749b9b1b49d5), LL(0xac6f4b70298ce5f2)}, {LL(0xc611b6d0d06b243d), LL(0x68ddf8cdc6364caa)}, {LL(0xa40b1329296ce7d2), LL(0xf57fef03a475124e)}, {LL(0x3ff60e7f7f1a6476), LL(0xde148d1f3f56ba93)},
			{LL(0xe06b8138385b5818), LL(0x1cdabf8ce0744408)}, {LL(0x2789c97979e3ad35), LL(0xdd2a2c08271a7013)}, {LL(0x8d7967b2b277ae07), LL(0x5910a4738df9f7bc)}, {LL(0x0cde8203039d85c0), LL(0xe01fb1ea0c266540)},
			{LL(0x827124c1c15c9bf7), LL(0x8178a84282371aec)}, {LL(0xeada42dbdb697eb8), LL(0x8c2bb713ea41f268)}, {LL(0xaebad0caca5ec172), LL(0x658ee79cae40a42e)}, {LL(0xb4e0282d2dc26911), LL(0xf7ea9019b4bc9e0f)},
			{LL(0x9a0ee3c7c7a552b4), LL(0x824609559a7bd06c)}, {LL(0x63e95b6868d412ff), LL(0x348f7c87631b2655)}, {LL(0x494dee838379eb1a), LL(0xa0978a2c497f4bb7)}, {LL(0xe5d201a8a8424b48), LL(0x5443bb22e58f1f38)},
			{LL(0x420fd3f1f1981caa), LL(0x994be9fa42128566)}, {LL(0xe421ff3939919a58), LL(0xfd6ed06be4d76789)}, {LL(0x1552bb9494b79d93), LL(0x4a0c7bb41532d771)}, {LL(0xb736e95d5d74d921), LL(0xcf9d2dc2b754161f)},
			{LL(0xc8ea0b323293c0dd), LL(0x19989fb5c8a0d94b)}, {LL(0x066f41e0e0afa360), LL(0x70eeb9750613d320)}, {LL(0x70d4a11c1ccc2c0c), LL(0x0e6dbe46703a2204)}, {LL(0x9d925cb6b6d920c4), LL(0x5b85db699d307bfd)},
			{LL(0x41d91281812eac9a), LL(0xa13c542141fa0d76)}, {LL(0x756d218c8cd53f5c), LL(0x46f4bae875c17934)}, {LL(0x198c3997972a1853), LL(0xaa13ca5e1914b231)}, {LL(0xc919f5a3a34011cd), LL(0xb0b5f4fcc9f8a1fa)},
			{LL(0xaaf0aecbcb940332), LL(0x843a887baae387af)}, {LL(0xfc5e383f3f68531b), LL(0xfe50717cfc9bad09)}, {LL(0x4d07908282b3295a), LL(0x4123e5cb4ddc6836)}, {LL(0xbfa2155f5f239ea1), LL(0xce36f3cfbfd150de)},
			{LL(0x2aa4b5ebebadf9e5), LL(0x9418f6ab2a646de2)}, {LL(0x7302606c6c7a9c3c), LL(0x361a039d73d2aa14)}, {LL(0x841e652121f33897), LL(0xf19611378424c9cc)}, {LL(0xd52c4ca4a4731ace), LL(0x523f3a0cd51748fb)},
			{LL(0xc3a836404072376d), LL(0x2044fc63c3cd179a)}, {LL(0xaf492e5b5b8d1062), LL(0xcca38cd5af18dc9f)}, {LL(0x2b574b7a7a7e28f5), LL(0x3d359de22b3c1553)}, {LL(0x863b5ac0c09659b7), LL(0x60ccc7a58694396d)},
			{LL(0xa7ddd25959da57e2), LL(0xcd0852d8a79d9a5e)}, {LL(0xb159a8bdbddb7a41), LL(0xbf7394b7b147c53f)}, {LL(0xb28f69cdcd6dca71), LL(0x8704296cb2af4d2f)}, {LL(0x5b83ea6666b204f9), LL(0x335823a45b063757)},
			{LL(0x4645adf0f052deea), LL(0x78ff861d46b1a6e7)}, {LL(0xd3430d4444dcb9ae), LL(0x22d18379d3049bdb)}, {LL(0x9fb7635757bc41e4), LL(0xcadf0dfb9f808b5c)}, {LL(0xfdadc6aeaebb820b), LL(0x577d1a35fdc3d5b8)},
			{LL(0xd4dfb23535a0cbde), LL(0xfb125145d44f304a)}, {LL(0x0f084373732b35f0), LL(0xd8680c310fceed50)}, {LL(0x9c61a227270af1d4), LL(0xf2a8b0209c68034c)}, {LL(0x2f1d357b7bb4eab5), LL(0xdc81f2052f9f36d2)},
			{LL(0x9bfd1d56567683a4), LL(0x2b6b621c9b23a8dd)}, {LL(0x43fc2d60604bcdba), LL(0x306682b3434afdd7)}, {LL(0xef63c24b4b706de8), LL(0xc4b2b3bdefbaa958)}, {LL(0xd9f2cea7a7ee9f0e), LL(0xb2208be6d9312dbb)},
			{LL(0x79b3a38f8f48ba9c), LL(0xa6eb0b0279e71c74)}, {LL(0xb6c517cccca70831), LL(0x66b0468bb60c6eae)}, {LL(0x5317166464e54379), LL(0x32f3fda953837196)}, {LL(0x7fdce26f6fe719fc), LL(0xd605b2777ff4cf54)},
			{LL(0xc18d09a1a117564d), LL(0xb11e2af1c17de73b)}, {LL(0xf080ba3c3cf5d6db), LL(0x1e4fc096f0bdc849)}, {LL(0x23c3b77878296f75), LL(0x3c9e43ef23b95392)}, {LL(0xe7f73e4949272a68), LL(0xc5196db0e73fef99)},
			{LL(0x25acf6989886cc15), LL(0x4c70fa9a25aa80b2)}, {LL(0x5e3a6af6f6ab17a9), LL(0x7bc1270a5efd6c67)}, {LL(0xb513d6bcbc11b801), LL(0x5ec7fb50b5e4e6be)}, {LL(0x1e1086e6e6566a23), LL(0x73d018621e5f19a0)},
			{LL(0xa26452c9c9c344b2), LL(0x85915676a266c16e)}, {LL(0xdf9d8f4747413c6e), LL(0xc2ce3293df22fe9b)}, {LL(0xa62e2cc8c80986f2), LL(0x64253991a6c5e2ef)}, {LL(0xfe7b07dede0d323b), LL(0x6f0aa7eefe2b5da8)},
			{LL(0xac9fef2b2b3ba052), LL(0xf4d4310eacf0548f)}, {LL(0x223049e9e9fabe65), LL(0x95b328a622e12b23)}, {LL(0xf9e7b8afaf71404b), LL(0xb6c975d2f960f639)}, {LL(0xe24ebed9d93e3938), LL(0x8d80691ee2c4b4a9)},
			{LL(0x4a9b2ff3f3cf5b2a), LL(0x98e037f74a97c3a7)}, {LL(0xbc74d42f2f952e91), LL(0xf6414e14bc39d8ce)}, {LL(0x3547cd9c9c2842d6), LL(0x4ee5858035630cf3)}, {LL(0xcacf34d3d3f6a1fd), LL(0x88c24927ca1029ea)},
			{LL(0xee903cdadaa3bcf8), LL(0x6d9fd8f4eee2d1e9)}, {LL(0x78405d1e1e9b6b8c), LL(0x0fc6604b78bf64c5)}, {LL(0x05b9809090191350), LL(0x489904ae05fb5b30)}, {LL(0x6b7da76a6a83557f), LL(0x3524a28a6b9e6094)},
			{LL(0x5132298585802259), LL(0xa3a92b3b51338137)}, {LL(0xe1987fa9a9888908), LL(0xb5f7d4c5e12c3cb9)}, {LL(0x59a6d58787d765d9), LL(0xa202f53659b6c7f6)}, {LL(0xa397ac58581095a2), LL(0x2cbc3d3fa33eb9df)},
			{LL(0xf2a585dddd90b7fb), LL(0x8f151604f20d38e8)}, {LL(0x71275f8d8d1ffd1c), LL(0xa740d50f71625ab5)}, {LL(0x56ae96f4f4fc5029), LL(0x7a6af90756782aa6)}, {LL(0x1118c595957d5fd3), LL(0xabb814531191f4f0)},
			{LL(0x6a8e59fbfb50846f), LL(0x9c09c9c36ac61825)}, {LL(0x893319b3b3bd6c47), LL(0xb8a4cb94895ad43d)}, {LL(0x94f55e25255db654), LL(0xf3036e2d94ed458d)}, {LL(0x65861a88887bb19f), LL(0x4461c5f26508f575)},
			{LL(0x8c8a992323a47f17), LL(0xf03dcf3a8ca18f0d)}, {LL(0xbbe86b5e5ee95ce1), LL(0x2f829c28bb72735f)}, {LL(0x77481e6d6db05e7c), LL(0xd7ae6c7a77718995)}, {LL(0x3c20cf0f0facd446), LL(0xe66330c43cbe3283)},
			{LL(0x7b969c6e6e2ddbbc), LL(0x37b1dd907b57ecd5)}, {LL(0x28818a0a0ac898c5), LL(0x0542203928d49d43)}, {LL(0xab03505a5a47d222), LL(0x2d17e332abbbff1e)}, {LL(0xd2b0f3d5d50f68be), LL(0x8bfce830d25ce36a)},
			{LL(0x310db39d9de28096), LL(0xaf51ea6731c02f72)}, {LL(0xde6e71d6d692ed7e), LL(0x6be359dade7a862a)}, {LL(0xc4348931310e451d), LL(0xf9872e5fc486bc0b)}, {LL(0x5fc994676778c6b9), LL(0xd2ec4c435fa514d6)},
			{LL(0xcca075333359029d), LL(0xf82cf052cc03faca)}, {LL(0xcf76b44343efb2ad), LL(0xc05b4d89cfeb72da)}, {LL(0x76bbe0fcfc638f6c), LL(0x7e8307337629f124)}, {LL(0x2ccbf40b0b025a85), LL(0xe4f64fde2c77bec2)},
			{LL(0xb83eaa2e2e5fecd1), LL(0x17f521f3b89afb4f)}, {LL(0xd8013036363d4e1e), LL(0x1b0de0afd869550a)}, {LL(0x2eeecbeaea673ba5), LL(0x75ac994c2ec74e63)}, {LL(0x36910cecec9ef2e6), LL(0x7692385b368b84e3)},
			{LL(0xdbd7f146468bfe2e), LL(0x237a5d74db81dd1a)}, {LL(0x6958988b8be6345f), LL(0xa47e7418692e9035)}, {LL(0xb37c975c5cbe1b61), LL(0x2e294225b3f7359e)}, {LL(0x14a1450505644c83), LL(0xe32110fd146aafc0)},
			{LL(0x9506a0b4b48e6744), LL(0x5a2e056495b53d3c)}, {LL(0xbe51ebcecef04fb1), LL(0x671b9886be89286f)}, {LL(0x621aa5f9f907c3ef), LL(0x9da217ce62435ee4)}, {LL(0xa1b293b9b975f482), LL(0xbde6ebada18e497e)},
			{LL(0x3bbc707e7ed0a636), LL(0x3fa0e2f83bf59912)}, {LL(0x16847ae4e4012da3), LL(0x727bc66f16da5f61)}, {LL(0x6650dbf8f8cd01af), LL(0x7c16782966e07d65)}, {LL(0xe90c83ababdfce88), LL(0xb45c0ac8e9a97a78)},
			{LL(0x5c1f551717ce7689), LL(0xea9bf1985c4d9cc6)}, {LL(0x6ce1181b1bff270f), LL(0xece770b66cd5cb05)}, {LL(0x6d12e68a8a2cf61f), LL(0x45ca1bff6d8db3b4)}, {LL(0xad6c11babae87142), LL(0x5df95a47ada82c3e)},
			{LL(0x3762f27d7d4d23f6), LL(0xdfbf531237d3fc52)}, {LL(0x61cc648989b173df), LL(0xa5d5aa1561abd6f4)}, {LL(0x4b68d162621c8a3a), LL(0x31cd5cbe4bcfbb16)}, {LL(0xb9cd54bfbf8c3dc1), LL(0xbed84abab9c283fe)},
			{LL(0xe3bd404848ede828), LL(0x24ad0257e39ccc18)}, {LL(0xba1b95cfcf3a8df1), LL(0x86aff761ba2a0bee)}, {LL(0xf17344adad2607cb), LL(0xb762abdff1e5b0f8)}, {LL(0xa0416d2828a62592), LL(0x14cb80e4a0d631cf)},
			{LL(0x85ed9bb0b020e987), LL(0x58bb7a7e857cb17d)}, {LL(0x8382da50508f4ae7), LL(0x2855c30b836f625d)}, {LL(0xda240fd7d7582f3e), LL(0x8a57363ddad9a5ab)}, {LL(0x47b6536161810ffa), LL(0xd1d2ed5447e9de56)},
			{LL(0xc5c777a0a0dd940d), LL(0x50aa4516c5dec4ba)}, {LL(0xb0aa562c2c08ab51), LL(0x165efffeb01fbd8e)}, {LL(0x33288c7c7c87e1b6), LL(0x3e0b3cf53370dfd3)}, {LL(0xfa3179dfdfc7f07b), LL(0x8ebec809fa887e29)},
			{LL(0x96d061c4c438d774), LL(0x6259b8bf965db52c)}, {LL(0x6f37d96b6b49973f), LL(0xd490cd6d6f3d4315)}, {LL(0x6ec427fafa9a462f), LL(0x7dbda6246e653ba4)}, {LL(0xc25bc8d1d1a1e67d), LL(0x8969972ac2956f2b)},
			{LL(0xf6effbdcdc5a75bb), LL(0x6ea179e3f6ae1b69)}, {LL(0x50c1d7141453f349), LL(0x0a844072506bf986)}, {LL(0xff88f94f4fdee32b), LL(0xc627cca7ff732519)}, {LL(0x5decab86861da799), LL(0x43b69ad15d15e477)},
			{LL(0xa9266fbbbb22b302), LL(0xbc4d35a0a90b0fbf)}, {LL(0x8eafa6c2c2c11e37), LL(0x616719a88e117fac)}, {LL(0x1777847575d2fcb3), LL(0xdb56ad26178227d0)}, {LL(0x1ba90676764f7973), LL(0x3b491ccc1ba44290)},
			{LL(0x97239f5555eb0664), LL(0xcb74d3f69705cd9d)}, {LL(0x7df9dd8e8e8278dc), LL(0x475f64e57d443ff5)}, {LL(0xecb5033b3bc6ddd8), LL(0xfcc50e66ec522148)}, {LL(0x58552b161604b4c9), LL(0x0b2f9e7f58eebf47)},
			{LL(0xf71c054d4d89a4ab), LL(0xc78c12aaf7f663d8)}, {LL(0x1fe378777785bb33), LL(0xdafd732b1f076111)}, {LL(0xfbc2874e4e14216b), LL(0x2793a340fbd00698)}, {LL(0x7c0a231f1f51a9cc), LL(0xee720fac7c1c4744)},
			{LL(0x0967029393849690), LL(0xa886b54409dd3e70)}, {LL(0x0d2d7c92924e54d0), LL(0x4932daa30d7e1df1)}, {LL(0x7a6562fffffe0aac), LL(0x9e9cb6d97a0f9464)}, {LL(0x67a32569691ed0bf), LL(0xd53b136067b805d4)},
			{LL(0x45936c8080e46eda), LL(0x40883bc645592ef7)}, {LL(0x87c8a451514588a7), LL(0xc9e1acec87cc41dc)}, {LL(0xdc4b4e3737f78c5e), LL(0xfab98f48dcca768b)}, {LL(0xe8ff7d3a3a0c1f98), LL(0x1d716181e8f102c9)},
			{LL(0x4f22af6363d6487a), LL(0xd07933594f6c9897)}, {LL(0x1dc6479696e0da13), LL(0x4ba7a5b91db791b0)}, {LL(0x4ed151f2f205996a), LL(0x795458104e34e026)}, {LL(0x044a7e0101cac240), LL(0xe1b46fe704a32381)},
			{LL(0xeb29bc4a4abaafa8), LL(0x2506dc5aeb198ad9)}, {LL(0xf814463e3ea2915b), LL(0x1fe41e9bf8388e88)}, {LL(0xf3567b4c4c4366eb), LL(0x26387d4df3554059)}, {LL(0x3e05f0eeeec9b566), LL(0x7739e6563e0ec222)},
			{LL(0x3dd3319e9e7f0556), LL(0x4f4e5b8d3de64a32)}, {LL(0xbd872abebe46ff81), LL(0x5f6c255dbd61a07f)}, {LL(0x8ae5d8c3c30bdc77), LL(0x80d3764f8ab25c2d)}, {LL(0x88c0e722226ebd57), LL(0x1189a0dd8802ac8c)},
			{LL(0xddb8b0a6a6245d4e), LL(0x5394e401dd920e3a)}, {LL(0xcd538ba2a28ad38d), LL(0x51019b1bcd5b827b)}, {LL(0x0b423d7272e1f7b0), LL(0x39dc63d60b6dced1)}, {LL(0x133dfa7474183ef3), LL(0x3ae2c2c113210451)},
			{LL(0x982bdc2626c03394), LL(0x131cdfc798cb20cd)}, {LL(0x02253fe1e1656120), LL(0x915ad69202b0f0a1)}, {LL(0x9369e1545421c424), LL(0x2ac0bc1193a6ee1c)}, {LL(0x80541b202039fad7), LL(0x10227ed08087ea4d)},
			{LL(0x90bf202424977414), LL(0x12b701ca904e660c)}, {LL(0xd095cc34346a099e), LL(0x1aa63ea2d0ec13cb)}, {LL(0x245f080909551d05), LL(0xe55d91d324f2f803)}, {LL(0x34b4330d0dfb93c6), LL(0xe7c8eec9343b7442)},
			{LL(0xcb3cca42422570ed), LL(0x21ef226ecb48515b)}, {LL(0xed46fdaaaa150cc8), LL(0x55e8652fed0a59f9)}, {LL(0xf4cac43d3d3f149b), LL(0xfffbaf71f41eebc8)}, {LL(0xce854ad2d23c63bd), LL(0x697626c0ceb30a6b)},
			{LL(0x99d822b7b713e284), LL(0xba31b48e9993587c)}, {LL(0x10eb3b0404ae8ec3), LL(0x02957f1a10c98c41)}, {LL(0x446092111137bfca), LL(0xe9a5508f44015646)}, {LL(0x402aec1010fd7d8a), LL(0x08113f6840a275c7)},
			{LL(0x929a1fc5c5f21534), LL(0x83edd75892fe96ad)}, {LL(0x3a4f8eefef037726), LL(0x968d89b13aade1a3)}, {LL(0x01f3fe9191d3d110), LL(0xa92d6b49015878b1)}, {LL(0x267a37e8e8307c25), LL(0x74074741264208a2)},
			{LL(0x12ce04e5e5cbefe3), LL(0x93cfa98812797ce0)}, {LL(0x1a5af8e7e79ca863), LL(0x926477851afc3a21)}, {LL(0x48be101212aa3a0a), LL(0x09bae16548273306)}, {LL(0x68ab661a1a35e54f), LL(0x0d531f516876e884)},
			{LL(0xf5393aacacecc58b), LL(0x56d6c438f5469379)}, {LL(0x81a7e5b1b1ea2bc7), LL(0xb90f159981df92fc)}, {LL(0x8b16265252d80d67), LL(0x29fe1d068bea249c)}, {LL(0xc7e2484141b8f52d), LL(0xc1f09384c76e341b)},
			{LL(0xd6fa8dd4d4c5aafe), LL(0x6a4887d7d6ffc0eb)}, {LL(0x20157608089fdf45), LL(0x04e9fe342051db82)}, {LL(0x0ab1c3e3e33226a0), LL(0x90f1089f0a35b660)}, {LL(0x0894fc0202574780), LL(0x01abde0d088546c1)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x4cf46e131360f84a), LL(0xe80e8e824c841087)}, {LL(0xd709734545167bee), LL(0xc365ec9ed7a7b85a)}, {LL(0x749edf1d1d06ee4c), LL(0xefd9d1a174990185)}
		}, {
			{LL(0xaf9c5ba61820cad8), LL(0x8c3b858c801dd978)}, {LL(0x186806c54c511069), LL(0xa1f57ca187b731bf)}, {LL(0xb8cd2eb09a1bd0c0), LL(0x210329216cdfbeb7)}, {LL(0x61d989a2abe6ffba), LL(0xaa6069aa1edca142)},
			{LL(0x6f5a6b413ded4a16), LL(0xcd9fe3cd32ec92c9)}, {LL(0xecd33bab52790987), LL(0x0eb0490e273c4fd9)}, {LL(0x7fab6fc7f432eb58), LL(0xb2390ab2c8360da2)}, {LL(0x36caece98b272459), LL(0x3885e7389cf0ffe2)},
			{LL(0x5f8a6708a54f6ac4), LL(0x4cb61b4cff41f074)}, {LL(0xc3cb40b7cd6e826a), LL(0xfcf288fc7b3ee47f)}, {LL(0xae26ca9640417505), LL(0xe709dfe7c758bc83)}, {LL(0x55a4842b9003669a), LL(0x44813a440ca69495)},
			{LL(0x75858ce4c17ee706), LL(0xba0e2bba3bd16943)}, {LL(0x91cfb50c16895fa6), LL(0x6aedf76a6180884e)}, {LL(0xa3a858253ee9c20d), LL(0x3da0bb3d22a720c6)}, {LL(0xeb734a3b199db2d1), LL(0xdc2e0cdc3124b77d)},
			{LL(0xb3595ca3f7366343), LL(0x42065242d87dbfad)}, {LL(0x7e11fef7ac535485), LL(0xd90b50d98f736859)}, {LL(0x219b99ff091c3e41), LL(0x95bd4b957032982d)}, {LL(0x30d00c4998a220d2), LL(0x8129f881cdad62bd)},
			{LL(0xdeb4d6827a19942c), LL(0x59fd0559641be751)}, {LL(0x1b657695a4f212cd), LL(0x1ca3921c4e789e71)}, {LL(0xd62dd4c1ff97250b), LL(0x87ae908719764985)}, {LL(0x7688fcb429dde5a2), LL(0x0758c507f21ec68d)},
			{LL(0x232c789fb9de8338), LL(0x43d9ff43feb85218)}, {LL(0xaa8bcb56e306ccf7), LL(0x88c17488188febe9)}, {LL(0xbed7ce10899ed44b), LL(0x98af36983d8223e8)}, {LL(0xf935afdd6080aee6), LL(0x75ec51754574e223)},
			{LL(0xb0542cf31f9561e7), LL(0xff50bcff11b21063)}, {LL(0xcae8d3c410818c90), LL(0x4993474941162f50)}, {LL(0x8593b04a7c11471a), LL(0x7a83b57a448d404f)}, {LL(0xa986bb060ba5ce53), LL(0x35979a35d1404427)},
			{LL(0x3fe97f9a56c82aa3), LL(0x8de4288da6d834cd)}, {LL(0xdf0e47b222782bf1), LL(0x32cf5f32235e82aa)}, {LL(0x35c79cb9638426fd), LL(0x85d30985553f502c)}, {LL(0x3b447e5af58f9351), LL(0xe22c83e2790f63a7)},
			{LL(0x70921c143a58e129), LL(0xbef4dabea3435bd2)}, {LL(0xf88f3eed38e1113b), LL(0x1ede0b1e023187d8)}, {LL(0x42f5f13d12387c82), LL(0xe9b996e9e064f35a)}, {LL(0x60631892f3874067), LL(0xc15233c15999c4b9)},
			{LL(0x061ae0a01385048b), LL(0xb9ac1fb9515d9d5f)}, {LL(0x6574886208a14648), LL(0xc5a8c2c5c10bf628)}, {LL(0xab315a66bb67732a), LL(0xe3f32ee35fca8e12)}, {LL(0xbddabe40613dd6ef), LL(0x25f9d825f44d8c26)},
			{LL(0x4658f0fdb17fc570), LL(0x86713d863fb3a430)}, {LL(0x97d555ac050c5b2d), LL(0xd341e8d330dd1511)}, {LL(0x67c36902b863fb31), LL(0x13cc76134f813c1d)}, {LL(0x1e72e6655fd414e2), LL(0x18596318d6eaace0)},
			{LL(0xa5b2b8852d6cc686), LL(0x840ca48473fabd99)}, {LL(0xfc223f2d9ba6a8c9), LL(0x7116a071dde6d0b2)}, {LL(0xfe95de4d2b6415b0), LL(0xa77214a7536c1a87)}, {LL(0xd0373461ec122180), LL(0x3e028f3e482bd4da)},
			{LL(0x38490e0a1d2c91f5), LL(0x5f7a6d5fb0c0cc69)}, {LL(0x7ca61f971c91e9fc), LL(0x0f6fe40f01f9a26c)}, {LL(0x5c8717584dec6860), LL(0xf1e0f5f1368e5fba)}, {LL(0x8fbd5369495d4b44), LL(0x72b49472b76a24ae)},
			{LL(0xeac9db0b41fc0d0c), LL(0xb71c56b77661d286)}, {LL(0xe15da9182cd1be8f), LL(0xd4192dd4c2c3d39c)}, {LL(0x030d7050e8a302a4), LL(0xbd56eebdc9cfafce)}, {LL(0x8d0ab209f99ff63d), LL(0xa4d020a439e0ee9b)},
			{LL(0xce45d204b3c63562), LL(0x265bec269ec1783a)}, {LL(0x808420ba87374135), LL(0x7e79447edc1f72de)}, {LL(0x8cb02339a1fe49e0), LL(0xcfe27acf7ea58b60)}, {LL(0x510985eb3344df68), LL(0x2b49912bd371c3ff)},
			{LL(0x48db121e277470dc), LL(0xe18eb7e1138397bb)}, {LL(0x68fa1ad17609f140), LL(0x1f01a61f24f46a6d)}, {LL(0xe44a39e8d7f7b8a0), LL(0xd0e3dcd05a51e10d)}, {LL(0xd8ae3622699c90a7), LL(0xe0511ae035467a0e)},
			{LL(0xfb824ebdd042139f), LL(0xa388e5a3cbfe2816)}, {LL(0xe250d948c472bc2b), LL(0x694fc3690b0c7c52)}, {LL(0x9c4127bf6821e8ae), LL(0xb04493b0847f140b)}, {LL(0x1adfe7a5fc93ad10), LL(0x7791c877093dfb8a)},
			{LL(0xee64dacbe2bbb4fe), LL(0xd8d4fdd8a9b685ec)}, {LL(0xad2bbac6a8e277a1), LL(0x5a5f315a0e97134d)}, {LL(0x8429217a2470f8c7), LL(0x11b1ef1103c825b4)}, {LL(0xcb5242f448e0334d), LL(0x22a11d2206534aab)},
			{LL(0x7b066e07577552aa), LL(0xddf1a1dd17e15ac8)}, {LL(0x455580ad59dcc7d4), LL(0x3b27d33bf67c0bfe)}, {LL(0xfa38df8d8823ac42), LL(0xc8babfc88cbb4ded)}, {LL(0x4c7613de8433c92e), LL(0x8e461c8ecc54c0d1)},
			{LL(0x2c150b4c77b48949), LL(0x4f142f4f95cd0468)}, {LL(0x6c571b11d54e48b2), LL(0x70c90d70fb233d07)}, {LL(0x7abcff370f14ed77), LL(0xb6c3fbb650a43f33)}, {LL(0x6a4dfbb1c6cb4c39), LL(0xc96512c9aa7ea058)},
			{LL(0x47e261cde91e7aad), LL(0xed4367ed78f6c1cb)}, {LL(0x347d0d893be59920), LL(0xeee153ee127a35d7)}, {LL(0x89a7b3c95ad84fcf), LL(0xcb188bcbe637b9f1)}, {LL(0xbbc05ee072b8d264), LL(0x9c55c79ca5101179)},
			{LL(0x1cc50705ef16a99b), LL(0xce3dd7ce586066d5)}, {LL(0xda19d742d95e2dde), LL(0x3635ae36bbccb03b)}, {LL(0x77326d8471bc5a7f), LL(0x6c6a9f6cb55ba376)}, {LL(0xe9c4ab5ba95f0fa8), LL(0x0a4ab80abfae7d48)},
			{LL(0x8b1052a9ea1af2b6), LL(0x1d7c3f1d68bd73c4)}, {LL(0x98ec267fcb66515c), LL(0xdf8c38df5ba84361)}, {LL(0x4a6cf37e97b6cda5), LL(0x37ea03379d095d8e)}, {LL(0x8aaac399b27b4d6b), LL(0x764e65762ff8163f)},
			{LL(0x79b18f67e7b7efd3), LL(0x0b95150b996b90fd)}, {LL(0x966fc49c5d6de4f0), LL(0xb873b2b8779870ea)}, {LL(0xd18da551b4739e5d), LL(0x5530d5550f6eb121)}, {LL(0xb543bc03e4b367c8), LL(0xfbaa4dfb892022f2)},
			{LL(0x16ebe426da5aa5c5), LL(0xc60af6c6ab870234)}, {LL(0x5d3d8668158dd7bd), LL(0x9ad2af9a71cb3a41)}, {LL(0x636e68c21b2442c3), LL(0x7c04dd7c90566b77)}, {LL(0x6bf76a819eaaf3e4), LL(0xa25748a2ed3bc5a3)},
			{LL(0xd520a491173427af), LL(0x3af87e3ad0b9e64b)}, {LL(0xf31b4cfe55cca2b8), LL(0x7ddb707db69386c2)}, {LL(0x6ee0fa71658cf5cb), LL(0xa6adb9a675a9f732)}, {LL(0xf1acad9ee50e1fc1), LL(0xabbfc4ab38194cf7)},
			{LL(0x50b314db6b2560b5), LL(0x407bcb409434a604)}, {LL(0x6ded8a218d2ff76f), LL(0x1bfb571bbc6658fc)}, {LL(0x8233c1da37f5fc4c), LL(0xa81df0a85295b8eb)}, {LL(0xf60cdc0eaeeaa497), LL(0x792181792e01b453)},
			{LL(0xddb9a6d292ba9688), LL(0xe4abebe4add4489f)}, {LL(0x15e6947632f9a761), LL(0x7b5c187b6248adfa)}, {LL(0x4ec1f2be34f17457), LL(0x5822a85842de0ae4)}, {LL(0x53be648b83866211), LL(0xfd2d25fd5dfb09ca)},
			{LL(0x8e07c259113cf499), LL(0x1986ce19f02f4155)}, {LL(0xd49a35a14f559872), LL(0x51ca245197fc83b0)}, {LL(0x0b9472136d2db383), LL(0x63057b63b4a2011a)}, {LL(0xcfff4334eba78abf), LL(0x4d69b64dd9841dc1)},
			{LL(0xdc0337e2cadb2955), LL(0x8f99b18fea912d64)}, {LL(0x9dfbb68f30405773), LL(0xdb76c9dbc33a71f0)}, {LL(0x69408be12e684e9d), LL(0x7433fc7463b10f96)}, {LL(0x9956b74f9307ee81), LL(0xb4be62b41ced269a)},
			{LL(0x1fc8775507b5ab3f), LL(0x736b397391afc91b)}, {LL(0x2536983faa5b87b3), LL(0xfa75e0faafe5cf47)}, {LL(0x28b80a8cd4f330bb), LL(0x20dc84204a1a5302)}, {LL(0xd79745f1a7f69ad6), LL(0xec9ccaec5e332c7e)},
			{LL(0x13fc74d6217ca3ea), LL(0xc2f007c2331530a5)}, {LL(0x9a5bc71f7ba4ec25), LL(0x09e88c09d5228954)}, {LL(0xc0c630e725cd80ce), LL(0x41a46641b2f14bb1)}, {LL(0x8724512accd3fa63), LL(0xace701acca078a7a)},
			{LL(0xc6dcd04736488445), LL(0xf80879f8e3acd6ee)}, {LL(0xbc602f70395c6932), LL(0x4ecb824eb308e9dd)}, {LL(0x9ef6c6dfd8e355d7), LL(0x662027660af5de3e)}, {LL(0xb2e3cd93af57dc9e), LL(0x293408299f38da56)},
			{LL(0x0d8e92b37ea8b708), LL(0xdaa964dae5ff9c45)}, {LL(0x739f6c44d2fbe38d), LL(0x03a234036a8cf41c)}, {LL(0x02b7e160b0c2bd79), LL(0xd664b4d68e8aca35)}, {LL(0x3267ed2928609dab), LL(0x574d4c574327a888)},
			{LL(0x5b2766c80608d336), LL(0x237eb0232096a71e)}, {LL(0x4042105da2fac1fb), LL(0x3fdd223f6eee396f)}, {LL(0x6679f832e00244ec), LL(0x78fe2c7808c459e6)}, {LL(0x10f10486c9dfa14e), LL(0x7fa6e97ffada9f6b)},
			{LL(0x3e53eeaa0ea9957e), LL(0xe6d672e6e19d5136)}, {LL(0xa212c91566887dd0), LL(0x5692e15665e2453d)}, {LL(0xb64ecc530c10656c), LL(0x46fca34640ef8d3c)}, {LL(0x4dcc82eedc5276f3), LL(0xe57446e58b11a52a)},
			{LL(0x434f600d4a59c35f), LL(0x828bcc82a72196a1)}, {LL(0xa70559e59dae7bff), LL(0x52681052fd7077ac)}, {LL(0x4f7b638e6c90cb8a), LL(0x3310f233059b6f1f)}, {LL(0x07a071904be4bb56), LL(0xd29e45d21618f8a4)},
			{LL(0x01ba91305861bfdd), LL(0x6b325a6b474565fb)}, {LL(0x19d297f51430afb4), LL(0xcac726cac0f25444)}, {LL(0xe74749b83f54ba04), LL(0x6db5326d939e4ec3)}, {LL(0x869ec01a94b245be), LL(0xc7d55bc78d42ef81)},
			{LL(0xccf233640304881b), LL(0xf03f58f0104bb20f)}, {LL(0x202108cf517d819c), LL(0xfe8f11fe3777fdd6)}, {LL(0x0a2ee323354c0c5e), LL(0x08372108f3e764e1)}, {LL(0x3ce40fcabe6b2807), LL(0x30b2c6306f179b03)},
			{LL(0x3afeef6aadee2c8c), LL(0x891ed9893e4a065c)}, {LL(0x316a9d79c0c39f0f), LL(0xea1ba2ea8ae80746)}, {LL(0xff2f4f7d7305aa6d), LL(0xcc404ecc14297f7c)}, {LL(0x71288d2462395ef4), LL(0xd5c680d5e4063e29)},
			{LL(0x41f8816dfa9b7e26), LL(0x54ef785429ab5c94)}, {LL(0x0f3973d3ce6a0a71), LL(0x0ccdd00c6b755670)}, {LL(0xf0163caebd6fa01c), LL(0xc08d9ec07f5c290c)}, {LL(0x2daf9a7c2fd53694), LL(0x24267524d2886193)},
			{LL(0xa6bfc8d5c5cfc422), LL(0x395a4a39ba351257)}, {LL(0x5a9df7f85e696ceb), LL(0x484cea4867d3c2e5)}, {LL(0x145c05466a9818bc), LL(0x106e4210250dc801)}, {LL(0xc46b3127868a393c), LL(0x2e6ccd2e6d261cdb)},
			{LL(0xb4f92d33bcd2d815), LL(0x90981790ce654709)}, {LL(0xc85f32a4a04331e9), LL(0x9ff7f39fcf9ce565)}, {LL(0x92c2c55cfe2a5d02), LL(0xd7bb19d7a84f2780)}, {LL(0x1d7f9635b7771646), LL(0xa50f8da51f25032e)},
			{LL(0x3d5e9efae60a97da), LL(0x5b809c5b2852fef8)}, {LL(0x5e30f638fd2ed519), LL(0x27844127b804958f)}, {LL(0x743f1dd4991f58db), LL(0xd13c71d17c940cb8)}, {LL(0x62d4f9f24345fd1e), LL(0x17368717d7130e8c)},
			{LL(0x263be86f42f88517), LL(0x47230e47662a6089)}, {LL(0xf7b64d3ef68b1b4a), LL(0x1213db126944d1a8)}, {LL(0x9f4c57ef8082ea0a), LL(0x0d127d0d4db0bbc5)}, {LL(0xe6fdd888673505d9), LL(0x06876806d4db2b38)},
			{LL(0x94d825fcedaf5989), LL(0x6e17066ef912badf)}, {LL(0x4bd6624ecfd77278), LL(0x5cd8595cda4c3875)}, {LL(0x33dd7c1970012276), LL(0x3c7f163c0462cd73)}, {LL(0x08990243858eb127), LL(0xde5395de7d6daed4)},
			{LL(0x17517516823b1a18), LL(0xad38acadecc267cf)}, {LL(0xefde4bfbbada0b23), LL(0xb3e6a7b3eef3e017)}, {LL(0x04ad01c0a347b9f2), LL(0x6fc8ab6fdfd7576a)}, {LL(0x64ce195250c0f995), LL(0xae9a98ae864e93d3)},
			{LL(0x0c34038326c908d5), LL(0xb19b3eb1a2baf9be)}, {LL(0xa0a52875d64ac0a9), LL(0x80f65580eb688f08)}, {LL(0x37707dd9d3469b84), LL(0x53b7bd53dbb59a19)}, {LL(0xc5d1a017deeb86e1), LL(0x455e97452a637920)},
			{LL(0xb977bf80c27a6f1d), LL(0x4a31734a2b9adb4c)}, {LL(0x114b95b691be1e93), LL(0x1494b314bd9ffa90)}, {LL(0x39f39f3a454d2e28), LL(0x34483734f785a992)}, {LL(0xcd48a2545b6537c6), LL(0x9b0d029b570ed7f4)},
			{LL(0x9075243c4ee8e07b), LL(0x01dfad0126c5edb5)}, {LL(0xf2a1ddce0dad1d65), LL(0x16e92a16f1d6e339)}, {LL(0xe87e3a6bf13eb075), LL(0x6178e261f8eb18b3)}, {LL(0xac912bf6f083c87c), LL(0x316d6b3149d276b6)},
			{LL(0x5713654b20c1dbe3), LL(0x92e58e92822c5ea0)}, {LL(0xf4bb3d6e1e2819ee), LL(0xaf4535afa08b7e66)}, {LL(0x7d1c8ea744f05621), LL(0x645dbe6446bcc797)}, {LL(0xa83c2a3653c4718e), LL(0x5ea5c05e960521dc)},
			{LL(0xd280d5015cd09cf9), LL(0xe8663be8c6a11eef)}, {LL(0x4961832e7f15cf01), LL(0x8abced8a54c6f240)}, {LL(0xa40829b5750d795b), LL(0xef3efeef34bfd862)}, {LL(0x838950ea6f944391), LL(0xc32faac315d0dd10)},
			{LL(0xfd98ae1dc3c71714), LL(0x1a24fa1a9aa3b549)}, {LL(0xd914a71231fd2f7a), LL(0x8b63408b72031ff5)}, {LL(0xe3ea48789c1303f6), LL(0x027d99024c4919a9)}, {LL(0xb7f45d635471dab1), LL(0x2dcef92d07aae8c7)},
			{LL(0xc271d187950f3db7), LL(0x97c0d2973c7b8184)}, {LL(0x2781795f1a993aca), LL(0x2c11542c216f0572)}, {LL(0xed69aa9b0a18b65a), LL(0x6582136560792a22)}, {LL(0x9be1562f23c553f8), LL(0x62dad6629267ecaf)},
			{LL(0x5204f5bbdbe7ddcc), LL(0x961f7f961abe6c31)}, {LL(0x541e151bc862d947), LL(0x2fb3602f4be3f16e)}, {LL(0xbf6d5f20d1ff6b96), LL(0xf39d6cf37ac74613)}, {LL(0x248c090ff23a386e), LL(0x9147ba91e8a0aabc)},
			{LL(0xc17ca1d77dac3f13), LL(0x2a963c2af5b42e4a)}, {LL(0xd33a443104b12324), LL(0x8354618381e47b14)}, {LL(0xa11fb9458e2b7f74), LL(0xebc40febac2deaf3)}, {LL(0x44ef119d01bd7809), LL(0x50158950b1396e05)},
			{LL(0xdba34672813f9203), LL(0x5d07f45dfc89d5c0)}, {LL(0x2ea2ea2cc7763430), LL(0x99709b991b47ce5d)}, {LL(0x7225fd748a9a5c50), LL(0x68906e682dc991e7)}, {LL(0x599087a8b6ca6e4f), LL(0xf51a04f5ae1c6d2b)},
			{LL(0x780b1e57bfd6500e), LL(0x60a74f60de2ef506)}, {LL(0xe5f0a8d88f96077d), LL(0xbbd186bb1d1484f6)}, {LL(0xba7acfd02ad96db9), LL(0xf7679df7e2557482)}, {LL(0x1246e5e6791d1c37), LL(0xa9c25da97450555e)},
			{LL(0x9562b4ccb5cee654), LL(0x05255c05be57df24)}, {LL(0x2bb57adc3c50321f), LL(0x9d8a6a9d83d5fccc)}, {LL(0x2a0febec64318dc2), LL(0xf6b830f6c4909937)}, {LL(0xf501ac5e4649a633), LL(0xc4776fc4e7ce1b9d)},
			{LL(0xb1eebdc347f4de3a), LL(0x9462e69456f77598)}, {LL(0x2296e9afe1bf3ce5), LL(0x28eba528b9fd37e3)}, {LL(0x813eb18adf56fee8), LL(0x154b1e159b5a1725)}, {LL(0x881d22f902b9f012), LL(0xa02ad1a0a172dc0a)},
			{LL(0x582a1698eeabd192), LL(0x9e285e9ee95908d0)}, {LL(0x0e83e2e3960bb5ac), LL(0x67ff8a672c30338b)}, {LL(0xc9e5a394f8228e34), LL(0xf4c5a9f488d9809e)}, {LL(0xe0e7382874b00152), LL(0xbf2b77bf8586b667)},
			{LL(0x2f187b1c9f178bed), LL(0xf242c1f25c02aba6)}, {LL(0x09239373ddef0efa), LL(0xb561cfb53a28cb2f)}, {LL(0xc76641776e293b98), LL(0x933a2393a4e9b315)}, {LL(0x9378546ca64be2df), LL(0xbc8943bcef0a427b)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x29029bbc8c928f66), LL(0x4beede4b0d5f36f9)}, {LL(0x051790f0fb26062f), LL(0x04faf10498923291)}, {LL(0x56a9f47b78a0643e), LL(0xf9d7d4f9c5693b5b)}
		}, {
			{LL(0x799ddb4148c08b51), LL(0xc618e56e42b35b04)}, {LL(0xe73081fa2725ea33), LL(0x364c8f6512f706a3)}, {LL(0xc9b34248405a98a4), LL(0x9d9a049cca192e3b)}, {LL(0x59c29714d711eb67), LL(0x4bab806b39a6896c)},
			{LL(0x4dde599db32bd70a), LL(0xb53d17c0d2076b55)}, {LL(0x111b1c3a7dd533e7), LL(0x2052c2f1a1183ba6)}, {LL(0xf7fea73189acda28), LL(0x91f45c86ce1c6f97)}, {LL(0x446c70e837d2cc1a), LL(0x808b8e42c160ecdd)},
			{LL(0x40be98aafd61c06c), LL(0xd9a5ca0af62a67d0)}, {LL(0xf1453b5226a7d065), LL(0x05cd3aea0373407d)}, {LL(0x3a9f0d3b03454efa), LL(0x55401c52334fcaa1)}, {LL(0x9baa8808760a6ee8), LL(0x2e903f511afd8438)},
			{LL(0x2ceab79302c774ac), LL(0x66c1a9dd22cb8c7f)}, {LL(0x60e1d4ff62b0a05a), LL(0x5416af0f8d3fb5b8)}, {LL(0xeb857a3cba33fea9), LL(0xdd3e43bd4b2958b4)}, {LL(0x1b157b9f4fc82d30), LL(0x5f19684535a94a5b)},
			{LL(0x51a5849080b4f38b), LL(0xf9f708fb57325c76)}, {LL(0xb4fc714bc2291f83), LL(0x02aca5babfe0fe32)}, {LL(0xf442e9e13f48dfef), LL(0xdb096fb049ca99e2)}, {LL(0x0d60c1374e4a1766), LL(0x6c98ddca242d0c85)},
			{LL(0x9a7fb2f9a5566d14), LL(0xa97a2e43670ed6aa)}, {LL(0x22363874fa69660d), LL(0x40a447218130768f)}, {LL(0xc76fcdafb8f48a05), LL(0xbbffea6069e2d4cb)}, {LL(0xe9ec0e1ddf8bf892), LL(0x10296199b10cfc53)},
			{LL(0x72468615a981967a), LL(0x3eb95ec8abf1786b)}, {LL(0xf597d310ec14dc13), LL(0x5ce37ea23439cb70)}, {LL(0x80bff39739c243d8), LL(0x718957142f54ce63)}, {LL(0x2731eac7e3866987), LL(0x9e60127bcb89af10)},
			{LL(0x94a33d1e5df87fb5), LL(0x8f1fc0bfc4f52c5a)}, {LL(0xef57927e7080f2df), LL(0x841007f57c63d3b9)}, {LL(0x15c9f478b7663f91), LL(0x797c86b99652b0ab)}, {LL(0x30916a9e3158502d), LL(0x2a0bb6e6a7febb5c)},
			{LL(0x5a7ed9c461f5eea0), LL(0x0156b35dbe707f19)}, {LL(0xd97d6483eed3a8bf), LL(0x3a22d77f16f2470f)}, {LL(0x816ac966ea9e4024), LL(0xf663460652a79cf1)}, {LL(0x957607ef8ea47c49), LL(0x08f5d1adb9067ec8)},
			{LL(0xa0e0bfc2a61323ee), LL(0xfc3a321154411c0b)}, {LL(0x64333cbda803ac2c), LL(0x0d38eb47ba753eb5)}, {LL(0x2b8411017e907d1d), LL(0x7512dea39257f107)}, {LL(0x1ac0416e9c942ecc), LL(0xd8f37957485a18c9)},
			{LL(0x490cb1df7998db7c), LL(0xec135388e54de058)}, {LL(0x96ca493f3840798e), LL(0x4208e29b3ed088bd)}, {LL(0xb695056aa79119b8), LL(0xcfbb879e45c55ad5)}, {LL(0x45b94a19e48ecfe6), LL(0x07619f50bc93be4f)},
			{LL(0xe48ccf2a91c1eff4), LL(0x7cb1bc539521f0d6)}, {LL(0x29ed65201b287b26), LL(0xb805fc87687255e0)}, {LL(0x10ce26cbae89301b), LL(0xa7b8d3e3dceb6934)}, {LL(0xae3c30255ebd314f), LL(0xda5fdcedf7bae6fb)},
			{LL(0xa289cbe3c3ab25d5), LL(0x312d1035ae64b8ec)}, {LL(0xab3be29647523ec5), LL(0x049b89b7bd033f64)}, {LL(0x2d3f8d62d19b7750), LL(0xe12bb8cf5f38deed)}, {LL(0x8e637c70c16c5179), LL(0x57ecb9e88caf3493)},
			{LL(0x5070be6153e8f077), LL(0x7e1d19e92ac10ee4)}, {LL(0x32f81ebf54e05616), LL(0xe71c94c25ddb1fbb)}, {LL(0x85b82124202d4c52), LL(0xaf4d024e65ed17fc)}, {LL(0xcedde4da3c0d9115), LL(0x8e4973e27a855343)},
			{LL(0x5817ade5044de89b), LL(0xcc4191794455dbfe)}, {LL(0xc0016b3dc4a383b4), LL(0xa82c9d1ed97ea9b3)}, {LL(0xc506b98edd4c8c3e), LL(0x76e8c84493c7702c)}, {LL(0x48d98b2eaac4d880), LL(0x6bf9429a98beb2ca)},
			{LL(0x205f4c559fd16036), LL(0x8db365057b15d268)}, {LL(0x99c3fc2913b268d3), LL(0xe3871d75e0d820df)}, {LL(0x0bdb5d54e1411d2b), LL(0xf8a1bba6e942236f)}, {LL(0x54a25623995bfc01), LL(0x27335da11d8b85e9)},
			{LL(0xf09001a3f5fbd399), LL(0x82272bf87e8012ef)}, {LL(0x47d03e388136c9dd), LL(0xca76bd7446b61aa8)}, {LL(0x4c0b636c6077d4f6), LL(0x32d706d2aff439c7)}, {LL(0xd3730326dcceb668), LL(0x45697dcb824336f2)},
			{LL(0xa1358533754f2012), LL(0x7bd0230329b24e99)}, {LL(0x0507d2b319ef0f8a), LL(0xdec4555a4ab9d99f)}, {LL(0xb1fba3f8dbc61009), LL(0xdc68f0e0f55927ad)}, {LL(0x6134ee0eb1eca3a6), LL(0xd3fcbe1df0cce72a)},
			{LL(0x971f73ceeb1c7a72), LL(0xc5e2f3894323da2f)}, {LL(0xff99b4b5de09c2c4), LL(0x23a8d416a088ba8d)}, {LL(0x56cb2202fce3fa3a), LL(0xea247f85e7ae210e)}, {LL(0xac5544043b053774), LL(0x1748fec90d9f421c)},
			{LL(0x38f6791a66fd48c1), LL(0x98573e76c96a6e46)}, {LL(0x218a76a44c8d63ca), LL(0x0a59741706e680fa)}, {LL(0xe23753493ecae5b9), LL(0xe888da3f584edf3c)}, {LL(0x3f98df881aaa4170), LL(0x8b84490879f6133e)},
			{LL(0x25589ee6863e6fbc), LL(0x5377305f31ac0bf7)}, {LL(0x88d8e0136e675b34), LL(0xc3d5df8441c01b79)}, {LL(0x7bf4af602d788d6a), LL(0x0b0fc74ab896ffe3)}, {LL(0xc1d451cc17ff8048), LL(0x2fc68c0ca48dfb21)},
			{LL(0xa78e1950da442a5f), LL(0xefe9456fe4dd6173)}, {LL(0xc2681f1ca11b858f), LL(0x653bbf3a235b0d54)}, {LL(0x87d1550545954a69), LL(0x625a206a9fc8b31b)}, {LL(0x0cb5fbc69d16149a), LL(0xeb72ccd859de5e17)},
			{LL(0x28385fd1c87478da), LL(0x3fefed9515810772)}, {LL(0x55776cd24a07fffd), LL(0xa0d94cb36078d77b)}, {LL(0xaaeed867940e3d39), LL(0x837198a5c0f06df6)}, {LL(0x9d11146bd90164a5), LL(0xbaa9593dd792abd2)},
			{LL(0x01d53af1d35c03fc), LL(0x87ea11127df35292)}, {LL(0x7ef37dd3349782e0), LL(0xd5cb9210f22f267c)}, {LL(0x76946e5763329a0c), LL(0x67971a809cbbf366)}, {LL(0x42d7ec8b98d9c657), LL(0x14b2e82e0c0fc337)},
			{LL(0xbef216eef0340154), LL(0x7de70f0e2b518fcf)}, {LL(0x6aefb35a50adbe8d), LL(0x2b5d05bb198ec445)}, {LL(0xcd61aa0a8ae994d2), LL(0xc4b440d4fd53a536)}, {LL(0x18a9354ff92c28f7), LL(0x15e45b73b27fbc2e)},
			{LL(0xf32c4f73431fd65e), LL(0xc8da18cef956e49a)}, {LL(0xc6baf75e6ba889f9), LL(0x3c15fb7214118659)}, {LL(0xdfc6f8e041d8a2f2), LL(0xae1bb113db9d68e5)}, {LL(0x82d687b65c7a45e3), LL(0xbc9e7530d5716a84)},
			{LL(0x0269742165b8063b), LL(0xcd172224fa25a4e7)}, {LL(0xfc25fa6568edc703), LL(0x6955e720275e4cf8)}, {LL(0x0edc8fe7f8ae12a1), LL(0x2665eefca3fbfaf0)}, {LL(0x7a219591fe248e96), LL(0x8ce5d658c565ad71)},
			{LL(0x17a08059d2de39aa), LL(0xb46ba49d6c77144c)}, {LL(0xcbda366925e29e9f), LL(0x508d26b8303c8adc)}, {LL(0x1fc793dd857b2146), LL(0x06372c0d02e3c156)}, {LL(0x702ff234cc399041), LL(0xf3ae7cec51d4dc8c)},
			{LL(0x5f790b77781ae12a), LL(0xdf92e607f4c9a686)}, {LL(0x362af6fd9e535a60), LL(0xbe32d08a6a9194b6)}, {LL(0xb99cb07c8c6308e5), LL(0x6e3478709bcdf2b7)}, {LL(0xd2a639d70f92b594), LL(0xc2836cd9ffb06460)},
			{LL(0x8ddf32a0778854be), LL(0x1d118ade0b79c2e6)}, {LL(0x416ba25b2e3dc390), LL(0x5e4fdb188bd93542)}, {LL(0x9816c6d8c0ee6b2f), LL(0x646d0c679d2b724d)}, {LL(0x635d9a2fd454a59d), LL(0x1eeb9c390ae943cd)},
			{LL(0x1c7bdd0d339f2481), LL(0x4cca1f3b85353723)}, {LL(0xf2f975829043d5a2), LL(0x4f3009dc84a5b608)}, {LL(0x04d2e842cab30c76), LL(0x592e4448374a8b0d)}, {LL(0x3df1aba97f12474b), LL(0x46936b2c83d3b7d9)},
			{LL(0xed3ee65f1538f4e4), LL(0x490725d18646775e)}, {LL(0x3b4a37cad0194d06), LL(0xd2aa0d404ebc9833)}, {LL(0xea5040cd696ffd55), LL(0x5ad452af36da0a26)}, {LL(0x846d1bd5f3714fae), LL(0x28a7135c181e456e)},
			{LL(0x7f264722e7cb811c), LL(0x522183028fdc74ee)}, {LL(0xf8f71227a25ecb75), LL(0x307ba3681014c7f5)}, {LL(0x344382dcfbeb5c5b), LL(0x7325f2ae90b43051)}, {LL(0x93cd9b8c21af7604), LL(0x9cccb7c174695122)},
			{LL(0x7d4f330382738727), LL(0x9f36a12675f9d009)}, {LL(0x06bb9c63af0b0a4d), LL(0x9439666ccd6f2fea)}, {LL(0x37ffcc0c4d0f599c), LL(0x39d8c1981762c624)}, {LL(0x12a752eacb313620), LL(0x6aaff1c726cecdd3)},
			{LL(0xd11a7707b976b053), LL(0x887e5fef78669215)}, {LL(0x65e6064c7b5fafd0), LL(0x8ad2fa55c7866c27)}, {LL(0x86046ff496c94995), LL(0xe5b03178e23be189)}, {LL(0x8b64aec3d8835ef3), LL(0x8928ecb2c616ed0c)},
			{LL(0x8fb6468112305285), LL(0xd006a8faf15c6601)}, {LL(0xad807ef5e8593488), LL(0x90a2efdb706c108e)}, {LL(0x53ccf0b1e50cf5b0), LL(0x34e02adfad17f891)}, {LL(0xba20feac3a870d22), LL(0x24c94b461c1b04c2)},
			{LL(0x197c0fbe2a702b0b), LL(0x920e4a61cf8ceebc)}, {LL(0xa887ac46f1b63b02), LL(0x4e66ba813ad5c911)}, {LL(0xddaf8cc12460a4c9), LL(0x630c933721b8cc02)}, {LL(0x7c9a09f2512f84db), LL(0x18dcb034080a829b)},
			{LL(0x6886c77b3515b8b6), LL(0xe64a279fe3ab60a2)}, {LL(0x248da41755626c40), LL(0xd49d214d4c5f5965)}, {LL(0xfa9e6606c7e6cd4e), LL(0xfd6c814cea316312)}, {LL(0x0a0e67a5321d1ed7), LL(0x7f4baab494b171fd)},
			{LL(0x4302d67a4b85c5ab), LL(0x9358f93c71fc91a5)}, {LL(0xa43257806ca02f98), LL(0xa5147659630b9706)}, {LL(0x890ddae2bd3b58c8), LL(0x443fce963c3349eb)}, {LL(0xd0cf4df66a2ab3af), LL(0x0f944efd0595c087)},
			{LL(0xa65b23a1091829a3), LL(0x6803547d992e33e1)}, {LL(0xb7403f9b74cd1a44), LL(0x4851968c38360847)}, {LL(0xdb1410a28b6bae84), LL(0xf735f55becd7e3e8)}, {LL(0x9f78604abcb9629e), LL(0x77be7b192db70f35)},
			{LL(0xd674d195c521b9e2), LL(0x9bad2891c8faef6d)}, {LL(0x4e62174d05cfd2cd), LL(0xffc024f655d19d20)}, {LL(0x6e3d5b189a1eb2fb), LL(0x727341f32ec44f48)}, {LL(0xe3e269b8ed96e645), LL(0x6f62cb2d25bd8dae)},
			{LL(0xee82a88fa3dcf123), LL(0x03fa16e70190812b)}, {LL(0x571e18f32fbff9c6), LL(0x6dce6e979a5d739c)}, {LL(0x392343ebb5a14b3d), LL(0x1fbd2f64b4993cd4)}, {LL(0x665a489ccdbbaa17), LL(0xc02fc96340509a52)},
			{LL(0x678f726d1ee7a9eb), LL(0x47c5d8713da3c8c0)}, {LL(0xccb490fb59b5972e), LL(0x435e51c680a0f7a4)}, {LL(0x75282087d5d69fcb), LL(0x2d6a29b61b6d0513)}, {LL(0xfb4b5cf714baceb2), LL(0x7a86905e97c23180)},
			{LL(0x5babe335b2a9ed5c), LL(0x86bca24fc3832d8b)}, {LL(0x6953fd8ae649bb4a), LL(0x61a0368d9e583230)}, {LL(0xa5e76d71bffc2c64), LL(0x22fe674b1ef8c594)}, {LL(0x6b3a89ab83f1bd71), LL(0xacb714a9647d96d7)},
			{LL(0xdc7ab630f73ca735), LL(0xe4e682255c4b9e90)}, {LL(0x03bc4ed0b6e405c7), LL(0x4afd333687d6f675)}, {LL(0x6fe861e94942b107), LL(0xf59950e153371dda)}, {LL(0x9cc42e9a0a5d6759), LL(0x3d43482faa61f940)},
			{LL(0xfe4c8e440d55c138), LL(0xa442c504dd7be81f)}, {LL(0x332d244e87bc55ea), LL(0x60f685d020284d29)}, {LL(0x74fd1a76068a9c37), LL(0xaa8038a4669e5781)}, {LL(0xca0f0c98f6be9d63), LL(0xd76737aa4dcfd84e)},
			{LL(0xecebdcaec664f718), LL(0xceed34c3fbb525cc)}, {LL(0x3596b82d28b75fa7), LL(0xf4cfe3bced4762c3)}, {LL(0xc86678b993069b58), LL(0x1a70158eb7ea7ca9)}, {LL(0x5d107f561da2e711), LL(0x1285c4230eec0261)},
			{LL(0xb02e9909089a13f5), LL(0x5b82e1f288aa753f)}, {LL(0xd41da5b4a099bfd9), LL(0x56ba0ab532df4b8a)}, {LL(0xcf08de2bef5192e9), LL(0x09a362f0077601d1)}, {LL(0xd5c89f4573c5bc25), LL(0xd1501ba74f2c1918)},
			{LL(0x9218a17df2f375f8), LL(0x1b26a6d3099a03b0)}, {LL(0x2e83c3b2677f7297), LL(0xabd68bf9d8ee2898)}, {LL(0x076ea6927c5709b1), LL(0x13d3777eb09c7d78)}, {LL(0xb8498a8d5f3f0b19), LL(0xe9de6962e63ea025)},
			{LL(0x8ab194320bdf5d0f), LL(0x0ec2fda0bbe5bf9e)}, {LL(0xf92228d67102c889), LL(0xb791b27a6de79567)}, {LL(0x1372681b186d35dc), LL(0xed45e0d55b3d9f41)}, {LL(0xe559f5db429dec08), LL(0xfb5bad41e8d2a244)},
			{LL(0x23e30285293565f1), LL(0xc74e5633fcc3241d)}, {LL(0xbf272c1f236802a8), LL(0xfa0d1e1c56a2dd5d)}, {LL(0xde13c2119284a10e), LL(0x29f1a001a66e3a77)}, {LL(0xbc9b62cf958c076f), LL(0xb0f02d2ad1742b28)},
			{LL(0x1daee7fce0c3277d), LL(0xcb200e29f8c665b1)}, {LL(0xf62b9dc05af0d9d4), LL(0x161e4d94b3ef3d05)}, {LL(0x71fac8c51f6593bd), LL(0x74446dfe2c278e1e)}, {LL(0x7393bce47add9586), LL(0xb9534fdad6022af9)},
			{LL(0x0867138457a518ec), LL(0xb25c88906e94d51a)}, {LL(0xb392d7d9be7e1632), LL(0x117fd2c40f7c834a)}, {LL(0xe18b1d99882ee07e), LL(0xa275e909df982949)}, {LL(0x5cc545a7cefee4ed), LL(0x956fd531731f50f3)},
			{LL(0xe83934ec0cd7fb6e), LL(0x97c3708bccffaec1)}, {LL(0x9071d55c974b73c3), LL(0xd63184f7f3bfa757)}, {LL(0x460504c9526aca21), LL(0x4d9cac663b45483a)}, {LL(0x9ead5abb6fe56162), LL(0xf0546a0b50445da7)},
			{LL(0xb247ed286d2215ce), LL(0x9695c3d6728fd1d8)}, {LL(0xbd4e583e46d00493), LL(0x371a3c38ac8779ba)}, {LL(0x5219ca403650f64c), LL(0xb30a3bcdd0e4aa03)}, {LL(0xbbf5c45de9db0ede), LL(0xa3235a5461e85650)},
			{LL(0x91a4efad4417703f), LL(0x51db95e58e4cf5c5)}, {LL(0xd8a85e723d8fab43), LL(0xbdc8c66d6b01159d)}, {LL(0xc3bd25ed72478673), LL(0xe2d1ae285ea85fc6)}, {LL(0x7848e1b09b9c88ad), LL(0x41f2f47c3f400996)},
			{LL(0x774154a6b06e99f0), LL(0xe07d0b92e148a1f4)}, {LL(0x4b65c5fe1c20dd47), LL(0x210471ac1f6844bf)}, {LL(0x6d8115c82cfab73c), LL(0x388e72c5a912b93d)}, {LL(0x6288a0de0708a661), LL(0x99018d2b771a115f)},
			{LL(0x1675baa801823a56), LL(0x3381b58f118446de)}, {LL(0xa35cf11210f72629), LL(0xb6c70127d397ea7e)}, {LL(0x26e4d03630da6a7b), LL(0x198a0369b67afd82)}, {LL(0x09b2297584f91b10), LL(0x35b6998213678788)},
			{LL(0xfdf0c094bbb1c4ff), LL(0xeebff6325aad1e6a)}, {LL(0x0f09b5162bf2115d), LL(0xa18fffeede08a862)}, {LL(0x4fb72dbcd693d131), LL(0x782a35e42822cfb2)}, {LL(0x3c249158ac4e44b7), LL(0xc1797a3efe20e54b)},
			{LL(0xafe90ad48de132b3), LL(0x5db5cdff8a49b469)}, {LL(0x2f56f943b423716b), LL(0x2c3c9aeba51d7a0a)}, {LL(0x6c542f39ffa6b4c0), LL(0xbf6463d7d4e1ebaf)}, {LL(0xb5294bba11751c7f), LL(0x8546b4a8c213aca0)},
			{LL(0xd7a1eb64167dba1e), LL(0x1c473983b509bdff)}, {LL(0x3144506fe20453d1), LL(0xade1a7f4da0de9ce)}, {LL(0xdac12a535837ad78), LL(0x70dfe4499124b17a)}, {LL(0xc4d3837f0e108fc2), LL(0xf102d956ee3422be)},
			{LL(0x4ab0ff0fcf7cdebb), LL(0xa6ee60be629b162d)}, {LL(0x141cce89643a3c6d), LL(0xfe9697abeba1e239)}, {LL(0x2a512bf0adcc7ee1), LL(0xf2f8cfb1efa4a395)}, {LL(0x8303bd478f26461f), LL(0x3b746422a8823816)},
			{LL(0xe05e27685b72e382), LL(0x259ff81ba26b7bdb)}, {LL(0x1e12a92c562722ba), LL(0x81dd3d1f7f1093c4)}, {LL(0x3e4de579c9f6428c), LL(0x0c6e581a040541ac)}, {LL(0xe6e5bb0bf479e9cf), LL(0xb1a69e776f045431)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xa95296b722ea38fe), LL(0xc98cab9347269b83)}, {LL(0x8c0a0851a4d45742), LL(0x9afb9bcc768a9074)}, {LL(0x5eac3186ab46e2d6), LL(0x5878f715893af414)}
		}, {
			{LL(0xc4610e8a46859da5), LL(0xe8f43dc0cab4e742)}, {LL(0x86ab96b2b17c302d), LL(0xf11ee62510bc3f12)}, {LL(0x6153b1e6f129b332), LL(0x3796c45ad0a0f8ca)}, {LL(0x7df282f05569c28f), LL(0x2fe83a11ffe7b639)},
			{LL(0x7e70345387e3de0e), LL(0x6c04012b4a1ddcd2)}, {LL(0x73437afb07491b30), LL(0x23d745d5092591a1)}, {LL(0x3b03d08f590afe38), LL(0x731004aceb74f6ce)}, {LL(0x0fcf2b6a1ce76cc0), LL(0x8cdad7d2249401c1)},
			{LL(0xb1e5dbf4261bbe54), LL(0x4d380e616aa6a2f6)}, {LL(0xda3c585e7e8845e6), LL(0x338350a7825fe503)}, {LL(0xe47a91f792df9f9e), LL(0x8564194575e6ad33)}, {LL(0x320b5460223aaa39), LL(0x79d1a50a66d7231a)},
			{LL(0xb8ed5f1b5d2bea55), LL(0x47f9afc7e7057722)}, {LL(0x0876578e35f7e17e), LL(0x8a2409b05ff5f38d)}, {LL(0x87d545d3ffbb8552), LL(0x71fb4e33c2ea194b)}, {LL(0x9302214b6e0c1591), LL(0xe3a1b9c8b258a435)},
			{LL(0xc2a6a10f2152a564), LL(0x6eef4bb463833357)}, {LL(0x1b184ff28d50fc03), LL(0x1e8020295426bcbf)}, {LL(0xaafd9406ab4b4257), LL(0x53b82e483e801e49)}, {LL(0xcf95efa7a1f8605a), LL(0x213c0f4a20bb7e24)},
			{LL(0xfce068a6cd057f1c), LL(0xd8080256943a7b67)}, {LL(0xe686f4350e923660), LL(0x466d8a69124ae181)}, {LL(0x3f381ac8a2906f07), LL(0x3602e1f425ef6e69)}, {LL(0xd8c03d9ce2c5ec18), LL(0xf08ac38be5f3a9b1)},
			{LL(0xeacb69fcc0ff4621), LL(0x895b668183248aab)}, {LL(0x6416a8c044749772), LL(0xf2618914cc6d4634)}, {LL(0xa109752b4c36bfa8), LL(0x9a701cc2d48f872f)}, {LL(0x9647386ddb5131d1), LL(0x2656f486ae951acb)},
			{LL(0xa28bc3889ebca329), LL(0xd99c27f86175edc4)}, {LL(0x39ffb54dc54757c6), LL(0xb01997808cd8ba7c)}, {LL(0xcd698a653db5c9a4), LL(0xe2359c6647173296)}, {LL(0x043bca47fb9a913f), LL(0x4512e558ce9b98a7)},
			{LL(0xec0cc679a7287ee0), LL(0x0f4010f52a135ebe)}, {LL(0xdcfbf7db195f7d27), LL(0xb59826d32b683116)}, {LL(0x6fe249eda3096a8d), LL(0x3ba9bb9e2662df52)}, {LL(0x6c60ff4e7183760c), LL(0x784580a49398b5b9)},
			{LL(0x189af9515fdae082), LL(0x5d6c1b13e1dcd654)}, {LL(0xb65ca7100f0b33ea), LL(0x4bc6d00311c750ba)}, {LL(0x9739eb0c959684ae), LL(0xa6b35c907cc33c92)}, {LL(0x5de91d8d8133c0b4), LL(0x42781e9440b5fc48)},
			{LL(0xc05ac4cdbd1f0c9a), LL(0xade6d898042f7fe5)}, {LL(0xfd9ebbc783c2ca63), LL(0x58edaa40466c5d3e)}, {LL(0x440d37bd902e9549), LL(0x9ff1ad91733f0c45)}, {LL(0xc12417acf3d8b9e5), LL(0x2d03708ed67959bc)},
			{LL(0x1755d23b433d8c42), LL(0xd1b6ccc1c548d795)}, {LL(0xc82c934388e8ede4), LL(0x27c2d1285bda8c68)}, {LL(0xbda8463de876ce15), LL(0x820ee289fbc8c9dc)}, {LL(0x46f1527f0c633cb7), LL(0x5cf83ebd149340f7)},
			{LL(0x478f811e42a489c8), LL(0xdc1d96abc6c566ae)}, {LL(0x36309e27d9a03b06), LL(0x3cc34052a84cbbbd)}, {LL(0x760663ddb2143f70), LL(0xe620089b15e82f5f)}, {LL(0xff62de051f8f639d), LL(0x9be4396c21c0118c)},
			{LL(0x0c4d9dc9ce6d7041), LL(0xcf36ece8916e6b2a)}, {LL(0x5b2eb208e6e4f875), LL(0xc46368e0e982285d)}, {LL(0xd1c8b97399f5b819), LL(0xfa4b622d68507c65)}, {LL(0x4e8705f13994ddc9), LL(0xd6dc370d4b66b37a)},
			{LL(0xb319be36ba5617aa), LL(0x8e319d4d0d0aee44)}, {LL(0x10ecaedf6a2d01fc), LL(0xd74812a3be2925d9)}, {LL(0x602d6287bfee064d), LL(0xb7736c4c02f6de93)}, {LL(0x0eb1f80b5220d9bf), LL(0x0c3f7fc4f6c22798)},
			{LL(0xb9938c7a13ec5f2a), LL(0xc71c07d13553517b)}, {LL(0x6d1e2c2f3f44c373), LL(0xf8a028b241ce93e0)}, {LL(0x2eaa6776867adb84), LL(0x61af5b4149906de9)}, {LL(0xb2676d57f491a2d5), LL(0x0ed4355bdf5cc81d)},
			{LL(0x14d7649891b790c3), LL(0x925af7fb70b2bd7e)}, {LL(0x9e316fe3eea6d0af), LL(0xac72fd36f160e946)}, {LL(0xb09b089568dc0b2b), LL(0xcddda677b8f084af)}, {LL(0x3cbaac6b701a7386), LL(0x75eedace90150482)},
			{LL(0xd671c597b0e535a7), LL(0xfcb5bc4f13318e29)}, {LL(0x70c1cc58d5c307b1), LL(0x603b7eefbcdffb4a)}, {LL(0x6bd983aa5893fbb2), LL(0x7ebb5ec6e8f947f5)}, {LL(0xc69d6b48dac8345b), LL(0x2bfdaeecad18abf0)},
			{LL(0x337587016cfd1f46), LL(0xf9340d1cb4810543)}, {LL(0x8457f3702d3199d3), LL(0x32177509771073a0)}, {LL(0xed721518e9efcb9f), LL(0x8fa5b8e3f84578e7)}, {LL(0x19e42a30111d55fd), LL(0xdd89b305338af00d)},
			{LL(0xbb6fe9b88fa1f6d4), LL(0x041594fd52ff1dc9)}, {LL(0x7778b0bcfcd38a0f), LL(0x66c5a08dc7be0906)}, {LL(0xf66a5aea64bf379c), LL(0x912598caac63c458)}, {LL(0x94bb5daf471c982f), LL(0xe55f67aac9395679)},
			{LL(0xc9524022c62f589b), LL(0xa727793e898caa31)}, {LL(0x1e5d56d4380dd843), LL(0xdb776d6748eb0241)}, {LL(0x9b7476c55bfbf4ef), LL(0x6985b078edad57b8)}, {LL(0xde0792198512d4d9), LL(0x7691b5ff4cc47da4)},
			{LL(0x374e4d4697678e79), LL(0xbc26e8447a1a9de4)}, {LL(0x4ff9d690775368b6), LL(0x56399f1b99309523)}, {LL(0x8eddc13c848bd153), LL(0x7b3aef954f49cc9f)}, {LL(0x017ed3614ec7b57f), LL(0x80e5a816d2562659)},
			{LL(0x06c7af8567d738c1), LL(0x861b7674a937d415)}, {LL(0x7c8c51911bae77f0), LL(0xaf0d92072db19060)}, {LL(0xf8dba2e1369fee23), LL(0x9d1ae70e5aa1e3c0)}, {LL(0xd334dcb105b811e7), LL(0x3942f1010ffc30d7)},
			{LL(0xceeb3cc6ef3fd525), LL(0xa1d9a75cf2ed587d)}, {LL(0xebb5ba9d8e38f35e), LL(0x09bece975172acf2)}, {LL(0x54e19962fa0394b5), LL(0x48b9bf32cd16299c)}, {LL(0xeef0a3bb3b65d71e), LL(0xcc4983d94dbf120c)},
			{LL(0xfb591442e415f2a2), LL(0xdef6dc34ef5b892b)}, {LL(0xe8370c3e5cb2efdf), LL(0x4a52f5ade488c619)}, {LL(0xdf794178cbd561a6), LL(0xf6741de99e925bfd)}, {LL(0x02fc65c29c4da9fe), LL(0xc309932c67ac4cb2)},
			{LL(0x8529201163f62cac), LL(0xb2f2dd1fa54655f9)}, {LL(0xf1d3260e4dafba22), LL(0x97db46a8d7023614)}, {LL(0x3dc47f0a3eddc6f9), LL(0xf50b72d8424322db)}, {LL(0xfe1c0d645148d6e2), LL(0x1b01917af39637d5)},
			{LL(0x5f15784f1d7e694a), LL(0x81718db82719b0fa)}, {LL(0x15a9b7f9df7025bc), LL(0x12bf5feda2e49b27)}, {LL(0x5e6bab2e53b9dc35), LL(0x019425aef54f96a3)}, {LL(0x559f4a03b4c421ca), LL(0xc85c17241f400fc5)},
			{LL(0x927cf22a20cba0ee), LL(0x634411de600e826c)}, {LL(0x3e46c9a9ec57da78), LL(0xb6e749e2f7b94830)}, {LL(0x2d28d1d554f0c705), LL(0x2243607bfc6a0702)}, {LL(0xb5de11b3dd812f6b), LL(0x082aeb39a43d3a51)},
			{LL(0x9ccd0a2172eb7951), LL(0x6f7b6e1a96cca5f4)}, {LL(0xe5044296dc182ae1), LL(0x0581b153a7b08b6a)}, {LL(0xd48da0552ca89c59), LL(0x3fbc2f63749dc29b)}, {LL(0xf25190ad9f25a6a3), LL(0xd4377d9262f85cff)},
			{LL(0x6e9c9a8cedcedff2), LL(0xbb4c1388f434f90b)}, {LL(0x7f0ee732c9246b71), LL(0xece1a93d984bfa8b)}, {LL(0xa3f510e9d07b1656), LL(0x59798feeb323cb9d)}, {LL(0x99881307c7b65d11), LL(0xaa8c23548a011b0a)},
			{LL(0xbcd6955ca6b17b6a), LL(0x02eb4a9f299eef85)}, {LL(0x4bc21cd78cc9f989), LL(0x132b7a4357ab0d84)}, {LL(0xbe2af09e3afcd294), LL(0xc1e2d9b34e32a337)}, {LL(0xcbae25e05a62f165), LL(0x642eea12ee20e683)},
			{LL(0x66eacd02d8393e8c), LL(0x31681a38abc10a86)}, {LL(0x2a91ad317de04abb), LL(0x24bdbe19870bf54e)}, {LL(0x493e791510845077), LL(0xd022e96f30074136)}, {LL(0x1f2385b576ca6d3c), LL(0x5b92c5719abd2418)},
			{LL(0x255e865b6107267b), LL(0xa86769cba39ff48f)}, {LL(0xab834767e58cf728), LL(0xd35d865eecd63810)}, {LL(0xba113ad9c16643ab), LL(0x84f03ceb80a93b90)}, {LL(0x8d5f779f5601cdd2), LL(0x38d6d4affab3a674)},
			{LL(0x7a4bfe147c794f31), LL(0x2916e47384864475)}, {LL(0xe13f88d12782bbde), LL(0x4093540b692b13cd)}, {LL(0x2bef7e503327ffc4), LL(0xa458160f555dd317)}, {LL(0xe2bd3e72f508a75f), LL(0x037f6f31dcd17926)},
			{LL(0x63afd4246d641acc), LL(0xf49f5776b70cb478)}, {LL(0x78b79bd6e034e6cf), LL(0xea1f775fe32a08c7)}, {LL(0x4036fdfa6bb40476), LL(0xdae348c9bda494e2)}, {LL(0x8fa3125dca4c642c), LL(0xfbdf47839d1feac6)},
			{LL(0x3189e2c3f0b0b6b8), LL(0x3a3d9e30d32d49f1)}, {LL(0xd70f16f6fe2280d8), LL(0x7c501459c167a870)}, {LL(0x9db3d9403c2ccc2e), LL(0xef9ec60c449a83ad)}, {LL(0x4573e4dcdee92036), LL(0x1f140587a1692a1c)},
			{LL(0xcc17590473727cdb), LL(0x62d03470954114cf)}, {LL(0xa7cedaae2be18769), LL(0x1c6b6ab67db8533a)}, {LL(0x62d1074523a3afb3), LL(0x747aff60655a9221)}, {LL(0xb4a0c2d293469a14), LL(0x88cf432f766b1c08)},
			{LL(0xb722747141cc8695), LL(0xcb237815c39176e3)}, {LL(0x07b97ce429108dbe), LL(0x06fede627b61f24c)}, {LL(0xf4963f28f8f29e62), LL(0x522c0be6cbcf88ea)}, {LL(0xe0415bb069450ea1), LL(0xc076fc1dbb7d3594)},
			{LL(0x201b9f7dd45a023b), LL(0x6d902485bf524a71)}, {LL(0xa6b009cf65263216), LL(0x9c8ec2a0afee7563)}, {LL(0xd0b66a12d7320d66), LL(0x7aaeca3bba065a3c)}, {LL(0xad44e8e2825bcfe9), LL(0x5546f02a45e1ec05)},
			{LL(0xf9a5718078585b5c), LL(0x1dff4f1888f7c599)}, {LL(0x8ae60b7b7f11406c), LL(0x3e280acd81d25438)}, {LL(0x83ee8f940421146d), LL(0x34e9ab6b0c7181ec)}, {LL(0x8c21a4fe18c678ad), LL(0xb8337cb928e5802d)},
			{LL(0x4c7b6033a5d97437), LL(0x15d5a4212ccaffc8)}, {LL(0xef8e70da75a26261), LL(0x4cac2bcf9fe93455)}, {LL(0x561dfca0664e3d4b), LL(0x8bb02c1eaaba652e)}, {LL(0x3881662c8b80e2b9), LL(0x30fc3f965e8e9c25)},
			{LL(0xf714898b2a7882e3), LL(0x11c030dc7e35e201)}, {LL(0x239929de06d01eba), LL(0x2e7c1fbf0aa8209a)}, {LL(0x7584d57e609e23f1), LL(0xa5cc33a1a01245b4)}, {LL(0xe949df5f12755aa0), LL(0xcab75dbb36dee040)},
			{LL(0x27a2e399fd4a8f85), LL(0x6b6efae7c433b83d)}, {LL(0x11927dbe24eab483), LL(0x57adbab56c7f0380)}, {LL(0xc51fddeb084228da), LL(0x681195d618e2c11b)}, {LL(0x3a7d03ee17cd4b47), LL(0xf3f5acba3922d097)},
			{LL(0x22e7fabf4817abc5), LL(0xae99b7a9d8fe06c3)}, {LL(0x79c948b7aef353b0), LL(0x6afadf49317c2e9e)}, {LL(0x685b35098a19e733), LL(0x3d5765fc5d032d1e)}, {LL(0x26dc30f8b38d3afa), LL(0xeb8b52f116659e64)},
			{LL(0xac3a3b83cc9c7a96), LL(0xd5a3583c97b7ca5c)}, {LL(0x91fe4489f241bc6f), LL(0x20a82ae4d5f4e887)}, {LL(0x98f6c0668971e86e), LL(0x2a698b4258573d53)}, {LL(0x1ddfe077ea87c4c2), LL(0x989b565dfd1168aa)},
			{LL(0x4abccfb6c20e4cf6), LL(0x93ced25585fd2bdd)}, {LL(0x95c58ece09db2d50), LL(0x65bacfbc1b6f7020)}, {LL(0x0bf4e12de77dfdff), LL(0xc9c8328aea0f9966)}, {LL(0xf0adf56f03680f5d), LL(0x173eeebe0554104d)},
			{LL(0xa801f1c43706eba9), LL(0x90b1bd64592c52fb)}, {LL(0x74fa061f2e59968e), LL(0x25299bb7724463ed)}, {LL(0xafb88d201e166617), LL(0x964f6306224da0b7)}, {LL(0xc3d8726e6f95101b), LL(0xee0ae3a2b1d5150e)},
			{LL(0xa532bf6cb7ac2e97), LL(0xdf62f99a1a141f88)}, {LL(0x136e187cb8a71d7d), LL(0x94a429990bd34f32)}, {LL(0x806c3937d6ab08ec), LL(0x77059051b98beb07)}, {LL(0xdd8524ba5798c858), LL(0x357d8ec5f93e174f)},
			{LL(0x43b44b59b93e18f7), LL(0x990f73f3085efe09)}, {LL(0xe7f827544055831f), LL(0xc688227fc01cc7d8)}, {LL(0x2fd4b417c8bd6efb), LL(0xe14af3579bc64bb0)}, {LL(0x1a669c93c397497c), LL(0x9e65883f86709ae6)},
			{LL(0x41482e9b2573b109), LL(0x5a06e0df6ff2b2bb)}, {LL(0x65687ba10ab3220d), LL(0x728421021e3b606d)}, {LL(0x2c5602b41a37727a), LL(0xa2a6c86d2e3c215b)}, {LL(0xd9beeefdac025967), LL(0x706f6b9d37a58fe8)},
			{LL(0x286dc8f3e1ade345), LL(0xe7b42d35e0a7b9fc)}, {LL(0x35b228840b2a2787), LL(0x7f2f7b681db6d156)}, {LL(0xf32f43ccd1e213dc), LL(0x54d2d584b0ae7aa6)}, {LL(0xa44c6c0df96b9be8), LL(0x5f87518cc84239d1)},
			{LL(0x723da99a498eae4f), LL(0xa332edc3db73b7f8)}, {LL(0xf5e8ec49b6352b1d), LL(0xd2c9a3f01999aeb3)}, {LL(0x7b352d7532befa4e), LL(0xa9f34c6556d0622c)}, {LL(0x2420553a2fc09304), LL(0x2882c1dd71c9d2d6)},
			{LL(0xbf5423ff743b67eb), LL(0x410771a59c64856e)}, {LL(0x34ccfbe545ed92f8), LL(0xffcad37ecfe0f70f)}, {LL(0x67941e6396fe8bf3), LL(0xb18db22e79972cdf)}, {LL(0x0d334ea880aac53e), LL(0x4fd344fe43384d73)},
			{LL(0x162b015a0dfa393d), LL(0x515364d7171ef1cc)}, {LL(0x1ca13316a44071bd), LL(0x187efe4b2f474ef3)}, {LL(0x50da53250199058a), LL(0x0dab5a6a038db13b)}, {LL(0x42ca9838f7f9ad88), LL(0x19eadbe5da08d850)},
			{LL(0xfa27c723aad247dd), LL(0x5e1374223d0daf72)}, {LL(0x6aa750cb16544ecd), LL(0xfe5ef6d03aaf61ac)}, {LL(0x5358e586d313190b), LL(0x4e476150b677dbd0)}, {LL(0x8b98d81a31d6f513), LL(0xbecda2db53847261)},
			{LL(0xd24a0fd04b7fa498), LL(0xb9a75917ddaa168e)}, {LL(0x1210cb1df660a802), LL(0x1441818fd985696b)}, {LL(0x8112ea56986cbd93), LL(0xf7e038476bddcd5e)}, {LL(0x0a8a324ca9ba4880), LL(0x492d9a9c3859bf3f)},
			{LL(0x9a0aa5a4153c4190), LL(0xe960186e3ffb71e1)}, {LL(0x9f4fbc82a06165d0), LL(0x2c9755202336cf1f)}, {LL(0xc7e3b829940f8124), LL(0xab1806fa7f4e8da9)}, {LL(0x57632fc128898834), LL(0x0b55840878ec4377)},
			{LL(0x5c97ceeccff475cb), LL(0xc29db68292e3da11)}, {LL(0x8964bdd8ad9b5ced), LL(0x7dc431f734283ed3)}, {LL(0x58ac04ab346ee4f4), LL(0x878f53da5c7842b6)}, {LL(0x71bf1f399b04b2ce), LL(0xe0ded6f96e89dd13)},
			{LL(0xdb428b3f304ff099), LL(0xb366f8b15009c35a)}, {LL(0x908097e8bc860910), LL(0xa04d82f207a2cede)}, {LL(0x21654c1c9a9db744), LL(0xed758c936d046c28)}, {LL(0x05451926b55d2440), LL(0xc5f74d4e1ccdbefe)},
			{LL(0x881a6eb9e35ce992), LL(0xfd2199e1e67e188a)}, {LL(0x29131b92af6a563a), LL(0x6751852332f19fa5)}, {LL(0x090884ef7b305401), LL(0x0ac1a1a68da3d5d4)}, {LL(0xd5f37334626f2926), LL(0xbf598775a6cbe4c2)},
			{LL(0x82905cf54ae6a112), LL(0xb40c037dde27a7b5)}, {LL(0xcad0f68114a5441a), LL(0xe4cb42043c76c0da)}, {LL(0x4d05b352eb1ec148), LL(0x95300c37fe9cd991)}, {LL(0xaec65e4150d1d368), LL(0x16aacb10f01b86ee)},
			{LL(0x51a480444f5eb0f5), LL(0x8d4ef27cd1db9762)}, {LL(0x0382b6a3d28a1c81), LL(0x43ec3b3ab5fa6aeb)}, {LL(0x59d2d7ca7aa9518b), LL(0x076afbcc8e2e64ef)}, {LL(0x30f731a2be7703c7), LL(0xbad83626017b6fa8)},
			{LL(0xa97f22a579c15ed6), LL(0x105415728b7a74a2)}, {LL(0xe3c3ed13bbcf1220), LL(0x839ac7270e875f7f)}, {LL(0x5a506169a8234d0a), LL(0x4486c0f63bd40e04)}, {LL(0x4840aa745e43e508), LL(0x50c74179e251676f)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x6925e668c4de524c), LL(0xbdb2cdea8f550b47)}, {LL(0xa077a64a02f10ad7), LL(0x1a95b4d406d9a176)}, {LL(0x522636e79dd4ac74), LL(0xcea2c9466421fd89)}
		}, {
			{LL(0x4a8c95c20416aa99), LL(0xf8ad0a2149f0eb63)}, {LL(0x97a1b595a3dae393), LL(0x38a835097fbd191b)}, {LL(0xbc21c5a63b2bfd88), LL(0xdb448a653eadb5af)}, {LL(0xe1aa1a276c2916ae), LL(0x5c57eefdcc8402c4)},
			{LL(0x78cd74e05509be8b), LL(0xfba46169375123bb)}, {LL(0x2e0e9486a62882bd), LL(0xfebfdcb1b571b810)}, {LL(0x23b213069724bd69), LL(0x6ad54767dc878ca9)}, {LL(0xb838155ddda04db1), LL(0x7eb9f6819107a540)},
			{LL(0x954cdd09d07ebb6e), LL(0x8b370b7bc9e8118d)}, {LL(0xf9fcbf787d953038), LL(0x041c25e0a8fe62e3)}, {LL(0xb2e71ef4a1d1b63e), LL(0x441f30f8bac58dcb)}, {LL(0x6a44da1638c46392), LL(0x99496c0d78e96b17)},
			{LL(0xdcba14197f9e6595), LL(0x78ab20116d86f633)}, {LL(0x3e6a52ecb8410759), LL(0x2fcdefa74c9cf82a)}, {LL(0xe03d2e69b47b3a31), LL(0xe4f9f1c4974f068f)}, {LL(0x83dca3045b38d64e), LL(0x4c277afb29fa49ce)},
			{LL(0xbb42498f765639d3), LL(0x7588d7ca7c99a99d)}, {LL(0xdbd9983032e3a1ce), LL(0xd6677dbe2fb2ea01)}, {LL(0x4e954539e29d1aa0), LL(0x5d5076c5e65afb8c)}, {LL(0xed81a9e9857705e5), LL(0x70936a12feb93236)},
			{LL(0xf059e803aa12bfd5), LL(0x358bc2d26ea246b5)}, {LL(0x5c1cebcf8f50c7b9), LL(0x3fbd7ba1a9e2b320)}, {LL(0x3c873a70cbe55fa4), LL(0x9c52d1d5fac9f0bc)}, {LL(0x17074a43531441bf), LL(0x7fbe6eb9bbd95c08)},
			{LL(0x7d4390556bd0222d), LL(0xe6f702b4c330371f)}, {LL(0xd488772c704bc6e7), LL(0xf192d81af011d62e)}, {LL(0xe998791263fcb5dc), LL(0xd56e16f6511322d9)}, {LL(0xeb75118e1058ed21), LL(0x66f12884e7462a4f)},
			{LL(0x70ff17d55adc1df9), LL(0x729d9962aac603a6)}, {LL(0xcd49e63db9a5ccee), LL(0x11770c3ecfa0b242)}, {LL(0x037a5cd2abf67462), LL(0x0b31214bed9e0cdd)}, {LL(0x1f3529765cc1e2cd), LL(0xf68796b2264e7c15)},
			{LL(0x8c8d4c181990b167), LL(0x6bd2df5ff65975e1)}, {LL(0x083263350fd5a372), LL(0x8939f80b9d97201d)}, {LL(0x73854b07f12a699b), LL(0x79acb82947580f7b)}, {LL(0xeae225c0c80ac1be), LL(0xde5f37bdbc8d2e04)},
			{LL(0x42bef6f70bc309eb), LL(0x7194f22ad467cb7e)}, {LL(0x131e9ab8b59ff186), LL(0xda43125d14734ce7)}, {LL(0x9ce98a7207f93483), LL(0xbaa0ec490fb435db)}, {LL(0x19c19111c9ee0a09), LL(0xe0e5d4243fb1646c)},
			{LL(0x55b9bcb458d74854), LL(0x0e2a9c936fbe9776)}, {LL(0x87c573ffbdb36677), LL(0xe9da061f86505921)}, {LL(0x2ce3fc1ad58cda40), LL(0x4d20e2c30324b086)}, {LL(0x222527484f7691f6), LL(0xd27b585e874c88e2)},
			{LL(0xfa86e3aad663445a), LL(0x0f2d04ab45606e3e)}, {LL(0x6bd3ee58e0964f0d), LL(0x21e7733423226f5c)}, {LL(0xb413a69334fe5efa), LL(0x527d726ea33a95b2)}, {LL(0xc2180921fb0dabc7), LL(0x3682a99a10038e6d)},
			{LL(0xb58492ddecac7265), LL(0xead36d57f8f191f9)}, {LL(0x7571f3606405815f), LL(0x6fcefabf5ea71702)}, {LL(0x46a7260ced48b9d2), LL(0xd4698ece7bcddb91)}, {LL(0x693e86c4933217f0), LL(0x92784d46957767ca)},
			{LL(0x215f7b9ae480e594), LL(0xd94a79156ad2843f)}, {LL(0xe80f4d5cbbae9943), LL(0x6dc009cf0ad82692)}, {LL(0x5ef18353fcf49f44), LL(0x8c2245d31fb7bbb6)}, {LL(0xfc725bcd434cac9e), LL(0x194f463d5c9f7647)},
			{LL(0x7bb72832feffcae9), LL(0xf0954022dacf2f66)}, {LL(0x7cd4a41bb3820eb2), LL(0x5e591d8d98fb3354)}, {LL(0xcbbd5e5a2c8a242a), LL(0x07154ea8d65faa3b)}, {LL(0xcfa48ea1ca019413), LL(0xa2e8324c79f5bad4)},
			{LL(0xab268fe5683fbc37), LL(0xa4fae4dc8574e9a7)}, {LL(0x9d7ebe3cdfab181c), LL(0x020ef370547f3190)}, {LL(0x37cf05976fc688b4), LL(0x1e5a08958ac0dc7c)}, {LL(0x0c2bb3cee95e134b), LL(0x2cc484ef323d30f2)},
			{LL(0x63e18d6def43ec7f), LL(0xa8de8b3fbeb54f41)}, {LL(0xd51f4362a819ea78), LL(0x493cc723abdad265)}, {LL(0xe2d046f5c7df62cc), LL(0x5766cfb6211a0e19)}, {LL(0xa5e054b7f2c5f781), LL(0x3ba15e41011cd1c3)},
			{LL(0xd8a3c4e29915d5ac), LL(0xdd565cf5c22ce6dc)}, {LL(0xb769fa419f082a98), LL(0x594c53254ea4996f)}, {LL(0x6cb06271adeb8b56), LL(0x8f2b2e9b6116736e)}, {LL(0xa47760f92a97db1e), LL(0x830f41785ad7d588)},
			{LL(0x1dd841ea2f65ba30), LL(0x4518a8c0901b7483)}, {LL(0x795a40ae8d5b9214), LL(0x430a7e506c9a27f0)}, {LL(0xfb11d7e40e3168c5), LL(0xb7831b921eab6a75)}, {LL(0x35226d0b1c62d049), LL(0xadc536e73c95d4ea)},
			{LL(0x45dd7ade46becdb0), LL(0xdf58af859653d74c)}, {LL(0x313bbdf0fae96070), LL(0x08384a03933fc405)}, {LL(0x20c84fd43cd2c90b), LL(0x61e4662c31198074)}, {LL(0x058ee4b53ed99ca6), LL(0x1d5363ddf46114a4)},
			{LL(0x1c4f75a4f73796af), LL(0xfdb6b7f9cbd070c8)}, {LL(0xb3702aba79839aa1), LL(0xfcb12fc1e10e8980)}, {LL(0xbdb6f1e8e379d117), LL(0x63ea955c6566b1e4)}, {LL(0xe6c9960e2154d2f5), LL(0xf29bb3528eb01ef6)},
			{LL(0x02ed689c73a458fd), LL(0xb39f3e72b6550896)}, {LL(0x8beec03154ed753c), LL(0xc51e82f0b46d69d3)}, {LL(0xa9cbe7791b9be4ca), LL(0x1765daae3321e131)}, {LL(0x779c9bfc17a1d9a2), LL(0xdc51c4cde8f21f94)},
			{LL(0xf1cedc4d7240934a), LL(0x8d25ddeb356942fe)}, {LL(0x963681db7b88cf0c), LL(0x80062a3024761d50)}, {LL(0xef6cc175f6d35d18), LL(0xc30c546048ec3aa0)}, {LL(0xb00a7668d275eec3), LL(0xf7800e8a0c90855d)},
			{LL(0x9a1d321592d6dc47), LL(0xacc2aedf164b2da2)}, {LL(0x0adf0ba97c71fb8f), LL(0x3aa6c6792bc2288b)}, {LL(0x50375801660ed4f2), LL(0x1379ff4e9bdf83d2)}, {LL(0x6276b9233711c0e0), LL(0x10709406e57e4b0a)},
			{LL(0x760bafb2cff3f53d), LL(0x64ffdbf4b3391bdf)}, {LL(0x93b8656e455153aa), LL(0x9d5549edd01709f4)}, {LL(0x91550df236f50b57), LL(0x2eca779f66420162)}, {LL(0xeefbf53b2e817187), LL(0x7ba24b5913273eeb)},
			{LL(0x0ec6db529afa4bb6), LL(0x9f5bba9d84683864)}, {LL(0xa69a0865593383e3), LL(0x30907f0aec82dd1e)}, {LL(0xd27ccf4be5642e23), LL(0xe7f09a8ce9eece57)}, {LL(0x1ea21d388493ce52), LL(0x4e29898b7d85785e)},
			{LL(0xf73a642ae76f7b8e), LL(0x9b479f7d2c965a87)}, {LL(0x147d1691f8e235dd), LL(0x748f4ff2564750d5)}, {LL(0x80a6ffd6f0cea22c), LL(0x47165bb0c4644513)}, {LL(0x27abc3fd71af0d50), LL(0xcf283b83732d9c46)},
			{LL(0xf44038f84c990fec), LL(0x9076be36c108565a)}, {LL(0x4b1ba18cdc448606), LL(0x40031518123bef28)}, {LL(0xaea86b5056e62091), LL(0xb9a987017115fd03)}, {LL(0x8a79f47f8cbf59a3), LL(0x7db09dc9efa66d98)},
			{LL(0x3be4b65986989bff), LL(0x329e8c7ab8fdec8e)}, {LL(0xc57b8508b6706f9c), LL(0x984ef4355237925f)}, {LL(0x365831d9b794a42b), LL(0xa6f417acd10bd837)}, {LL(0x3ffd66a260132bc6), LL(0x9763f09e1757fc61)},
			{LL(0x0419d0fbe68bb039), LL(0xa5fd7ce4afaa10ef)}, {LL(0x0f51ef1c42a86729), LL(0x27f5a5a4dfa33c2f)}, {LL(0x07638c294d7dc45b), LL(0xaecc5daf42341c32)}, {LL(0x534d04d3cdf8a090), LL(0x1848de0576418f0f)},
			{LL(0xc38f3d6f235f8758), LL(0x8e2cb6a34bc88a26)}, {LL(0x94dbe947082c97f1), LL(0x33991442922315c6)}, {LL(0x2d74c8540ddef6df), LL(0xf58efdfa58efb4cd)}, {LL(0xf2b4809fd9b6e728), LL(0x8614fca0d8f74e23)},
			{LL(0x3a7382175ecab760), LL(0x8a309343e336e8c5)}, {LL(0x28fa2ce133076a79), LL(0xe8dd9e27ac8ea069)}, {LL(0x7a201c7c26ade676), LL(0x483b5f1b81042b2d)}, {LL(0xc4ecb1466e224303), LL(0x20e0eb0c09fc9614)},
			{LL(0x90c239bceea727c8), LL(0x966468a63d890529)}, {LL(0x3909dec5f53cc302), LL(0x8101b2080ea8e418)}, {LL(0x3241e122511f1412), LL(0x03096b487ea1c8d8)}, {LL(0x30ac89be22bb4cef), LL(0xb096553ac8f4c04e)},
			{LL(0x67f85d9609c85c46), LL(0x0d23f7db111f5fae)}, {LL(0xda4eac7eeab18d51), LL(0x6ec962877479ee4a)}, {LL(0x5f66b71d24a6b3db), LL(0x348c5aea447cbffd)}, {LL(0x4329c2b9d3912574), LL(0xc93aed138faccf35)},
			{LL(0x52da309d15aa8c0f), LL(0xa0e6c13c2d8a8b44)}, {LL(0x8903a8ad27492dc1), LL(0x7681bc8202386145)}, {LL(0x33d6d56c894d388d), LL(0xbba77471256acc93)}, {LL(0xde577c850c3a3d68), LL(0xcb341e63dbd3fea5)},
			{LL(0xf323b4d101e4cbb7), LL(0x3ebae399833c4a68)}, {LL(0xaf3f5f1e8eb40c0e), LL(0x010798382adef948)}, {LL(0x4c782da59139425d), LL(0xeecf48b7500ff31a)}, {LL(0x5b7f67e6c22d03e2), LL(0x9171260eebd6af12)},
			{LL(0x74e6c72ebc57adc0), LL(0xd760e586056c1349)}, {LL(0x1856a55f11bc2696), LL(0x584bcb1d647a6027)}, {LL(0x2546ab61020b55ad), LL(0x7cb705f1c57894d0)}, {LL(0xfde56f839b1e8001), LL(0xa1e159040754720c)},
			{LL(0x64820144a23e2824), LL(0x0612d690fc815373)}, {LL(0x865247b165e14ae8), LL(0x51741926dd9b5d6a)}, {LL(0xce33baef1253b88c), LL(0x1a462d75223ebe9f)}, {LL(0xadd23782fd1054f3), LL(0xb298a64a9c8bf1de)},
			{LL(0xf86b8b36a5c71ca7), LL(0xbcb23ad9f33566a8)}, {LL(0x6fca3ea3061dff34), LL(0x841a0fd08c887fb3)}, {LL(0x296d18afeb5546e6), LL(0x5073811ef745a422)}, {LL(0xc8c70288877c5048), LL(0x0c246fe33bc1a6e6)},
			{LL(0x98f05a89e17284ba), LL(0x1f5d90ada01e2534)}, {LL(0xb6fece0f475a0607), LL(0xe1e24c1c156f9d24)}, {LL(0xff08071fe8bad8fc), LL(0x127e6776b1017a9a)}, {LL(0x47301242351a954d), LL(0x6cc791f72006dfda)},
			{LL(0x1289aef66dcddd19), LL(0x62ed0d644fb848ac)}, {LL(0x15ea22df20b01942), LL(0xcc2150cb0d8c549e)}, {LL(0xbeccad3a488fa575), LL(0x68dbb41788f8bd39)}, {LL(0xbad57dc1ae04154c), LL(0xcd26c8f32752add6)},
			{LL(0x5754d4282b7310a9), LL(0xbdb5a2e1d9eb9fe0)}, {LL(0x610ce5f19ce7b482), LL(0x1b41b54d08e047d7)}, {LL(0xdfc048cbd46811f7), LL(0x739a015a8018faee)}, {LL(0xe424fe9252f08a08), LL(0x41048d2038e51660)},
			{LL(0x7e39cc87c026564f), LL(0xedc623ff2eae3bc2)}, {LL(0x0b483fe7a423d710), LL(0x8208d94070092cc0)}, {LL(0x3d100e3e13b7733b), LL(0x24fcceeca102f4f7)}, {LL(0x542e88fa808564cb), LL(0xb68483aa3475933d)},
			{LL(0x16907e0d8b466d20), LL(0xc7107180e0125843)}, {LL(0xfe9f335130e8f463), LL(0xaad0784feaca7ed1)}, {LL(0xf5d70cb694cb2373), LL(0x28d8a10f9ac35211)}, {LL(0x09a5577bd7878fed), LL(0x3197e732c65c2456)},
			{LL(0xbf5b997490dd89ea), LL(0xd075ab2ed333b972)}, {LL(0x6d27563f75b9a7c9), LL(0x378531a23add7725)}, {LL(0x24d19f2fda597932), LL(0xc4191ac89eb3909b)}, {LL(0x2a17447d40a33284), LL(0x5b42a0551adba8ff)},
			{LL(0xe34772bb1f8d4e53), LL(0xefc8d08f7ad10a52)}, {LL(0x72127f4929784504), LL(0xc102a7101c930b30)}, {LL(0xa70d3c2b8161af7c), LL(0x883e6033b749d955)}, {LL(0xd10693994e925a41), LL(0xecc1bbc70470c28a)},
			{LL(0xa06eb002cc1c6b27), LL(0x26f23d9cf57dc567)}, {LL(0xa85cd337c3c9c855), LL(0xafcbc59768eae57a)}, {LL(0x263cf7b3a9fd21cf), LL(0x778624ba28e6980d)}, {LL(0xccded27361f7e071), LL(0xa9d91307946bb609)},
			{LL(0xf6ad50643f3d5711), LL(0x23e98044775d5ecc)}, {LL(0xe5b3cadc8aa2a697), LL(0xf9aa9219632e122b)}, {LL(0x666f69d8d19a70d9), LL(0xb58de8e24ad45be5)}, {LL(0x7faef8c918747ad0), LL(0x55683cc675653f89)},
			{LL(0xaab1bbabb06d90a8), LL(0x1c54fbe5debfedec)}, {LL(0x2b80703398f11e1b), LL(0xe3ecbf6c4110acb4)}, {LL(0x40539e6b78675116), LL(0xc20bcc586232c3e8)}, {LL(0xac4503cc2542786c), LL(0x0a36b973c740f595)},
			{LL(0x444a4e909eece12f), LL(0x67f6b0bccd98d307)}, {LL(0xa314ecd067ea1f45), LL(0x2dc31cd718e3c9ba)}, {LL(0xd934f0ac4147f933), LL(0x65f843cc99e7e297)}, {LL(0x609bd1bf44b5981d), LL(0xa3efaa74532b439c)},
			{LL(0xc601d9da1d861bfe), LL(0x937fd57ebfa99e82)}, {LL(0xec169da75d25297a), LL(0xc83d752ba572367d)}, {LL(0x4861fd5e77b2f264), LL(0x4b323453ffa5e3f5)}, {LL(0x8131cb98289c8eb3), LL(0xffb844899faf4158)},
			{LL(0x59920f7ab1895b1f), LL(0x22ee187c5d83a784)}, {LL(0xb9af211305f2612e), LL(0xc617e9b8cacca10b)}, {LL(0x1064c66a1e6985e4), LL(0xd1723316f9ed403a)}, {LL(0xe75ea240f906fe6a), LL(0x4a35ac6bd57b1abd)},
			{LL(0x5ae853a81a7f2f7d), LL(0x29df3937b01dab59)}, {LL(0x9b8a065b4a84f0d8), LL(0x146cb1e64d8029e9)}, {LL(0x4def19eb496b6ec2), LL(0x5661578e0bc4f751)}, {LL(0x56c3e066f3213c36), LL(0x051bbdd882209bab)},
			{LL(0x8d1a7856c1c29df8), LL(0xd37cc066ad9271aa)}, {LL(0x5d8bdf815702eb26), LL(0x87136498f229b76b)}, {LL(0x4f0271773acf363f), LL(0xe5fe69fcbd91ffc7)}, {LL(0xdd2d2057a7cc490a), LL(0xc0053f28364df278)},
			{LL(0x0197344ed8522c9f), LL(0xb8ae1f395bcb044b)}, {LL(0x1b2cf98dba4a52f4), LL(0x537aea5689e46cfa)}, {LL(0xd6651fb003ef9e1a), LL(0x420de6684644deb8)}, {LL(0xc16255f350fbdfa5), LL(0x3db388d1fd9d82b0)},
			{LL(0xc796ed94c5d43761), LL(0x2bd1ca47e4629ac9)}, {LL(0x922f51209d037f35), LL(0x25fb56d48bdc0dbf)}, {LL(0x11f3f224c63ba97b), LL(0x69dc2c2fa2264471)}, {LL(0xd091a7d796c076de), LL(0x546fa4fe5fbbc6c1)},
			{LL(0xca2a6a14f4d808b5), LL(0xbfbb51918d94ae70)}, {LL(0xa283d89ebfb833da), LL(0x956d03ee4328cdf1)}, {LL(0xd3ebfb053d3602bc), LL(0x5f5e85b5b225ca1c)}, {LL(0xc95036c65f2e7cd7), LL(0xb48a70da600aa2ad)},
			{LL(0x6e5d0aedde4fd3ab), LL(0x3cb410e9d7437bf8)}, {LL(0x2f99a0c87e7aae22), LL(0x4611c388eebabc5b)}, {LL(0x7168239b828e3166), LL(0xca33865bf10d07ed)}, {LL(0xc0f561bd88a9f33a), LL(0x851d97e8a65686fb)},
			{LL(0x8e6024846a34e99a), LL(0xd84de12d400c7d77)}, {LL(0x1abbcdc362187e6b), LL(0xebd4f56fd22f68b1)}, {LL(0x8ff710cab266c505), LL(0x60e3fe141bc7793c)}, {LL(0x68a9b28a4b603b6f), LL(0x2ad6527fcebc6381)},
			{LL(0x58053b3469db7780), LL(0x9a4007450648a3cf)}, {LL(0xb19d42260a27c25c), LL(0x4f2e11b3575b8116)}, {LL(0x49f6c910afe0defb), LL(0xf39c2b6aa46ee7be)}, {LL(0x41c4aa25a0357d89), LL(0x7aa5d36139f9c7a3)},
			{LL(0x88949ce3ff1b015e), LL(0xce2fa3bb59f3650e)}, {LL(0x85281b63ce173e8a), LL(0x5a45386d300551b7)}, {LL(0x6515350a7a6c04bb), LL(0xbebcc9a9a74a5738)}, {LL(0x51a06c4fbe5cf86d), LL(0xabd7e077c0148799)},
			{LL(0x389eea8b2d6eef9d), LL(0x39afad315563e053)}, {LL(0x99676ec73920a825), LL(0xa7f38f94fbd5217f)}, {LL(0x06f4b867952fe8c4), LL(0x1662429619ff1879)}, {LL(0x84bf2f2d16451215), LL(0xe2eb27546bce55fc)},
			{LL(0xd7f22bfedbbdb285), LL(0xfaa3f9511d8fdaf3)}, {LL(0x34b55945c430fcd6), LL(0x156b29de675ed0a1)}, {LL(0x9f93d6a0ac0f40e1), LL(0xb191cd02e22a3906)}, {LL(0x0dbc8780310c3fd4), LL(0x946a9bd669f634b9)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x824b974a836afad1), LL(0xf48965c272314d85)}, {LL(0x9e04e2ee745d6c7e), LL(0x093fd23bb9e13d4d)}, {LL(0xa1f9844c144e47b8), LL(0x9e5c22a5aeb6c12c)}
		}, {
			{LL(0xd52f8dc690a455a5), LL(0x5d1b72cb89048071)}, {LL(0x179ff9364e75902d), LL(0x15a48a485aa38762)}, {LL(0xf3d45f9d804c9f32), LL(0xe9183dae643b6cbf)}, {LL(0x157fb14b6d940b8f), LL(0xd386ace4dd6c1e81)},
			{LL(0x6d5d49b5a58a5f0e), LL(0xf572a8ce1c5532e7)}, {LL(0x66cbc620faf84130), LL(0xcec905c160a6279e)}, {LL(0x77b7e791d16dbf38), LL(0x520be5be7097c81a)}, {LL(0x5baa9e806e66c7c0), LL(0xbea2148243dd9c3d)},
			{LL(0x43a078d93960bc54), LL(0xdff97f5ea8d0ff23)}, {LL(0x63b872054c6818e6), LL(0xe29c5a0c0f7d7b0b)}, {LL(0x9c695e5506275b9e), LL(0xda48b3ccffa1c7bb)}, {LL(0xdc594a2eec37d039), LL(0xa082f96872380ceb)},
			{LL(0xe84ed566043ad355), LL(0x2d706388aa7f3bd2)}, {LL(0x83f04454c450e27e), LL(0x5164a171fcb861d3)}, {LL(0x3f8110ddb77f1d52), LL(0xb64937efa4b42240)}, {LL(0x5adaba5f9ef76b91), LL(0xddb307d4e15b31ad)},
			{LL(0x256bbef9c398fd64), LL(0x11307a9fc876d8bd)}, {LL(0x3ef1340247eeb103), LL(0xd55824b906328fd0)}, {LL(0x7d514cdb7e8e0d57), LL(0x0aa15be7aee270f3)}, {LL(0x2efd316c9ceae35a), LL(0x2a8bd790b485cdc4)},
			{LL(0xdaba92a989d7be1c), LL(0x29e4935f38aa640d)}, {LL(0xcc554f4037338260), LL(0x5f510a41c08f4eff)}, {LL(0xd7cfc5bbb345ce07), LL(0x9b3954670ecb1992)}, {LL(0x338463107d7cc118), LL(0x6785e3813053f24f)},
			{LL(0xefdd293e914b1121), LL(0xc7071ae9426bfea4)}, {LL(0x7bb2945c1b6e6372), LL(0x83c731d0e4701815)}, {LL(0x8683f07172c0bba8), LL(0x7d31febc93633d46)}, {LL(0xd2bc719e05d597d1), LL(0xb76c0baa61104507)},
			{LL(0xfea1088fbadeef29), LL(0x5bc5fa96525a1120)}, {LL(0x278bf684e07966c6), LL(0xd7125c334fb9415e)}, {LL(0x7ec12079adfe3aa4), LL(0xaf926e1d8bab4480)}, {LL(0xa078222a6228713f), LL(0xc932b1d97e5cd188)},
			{LL(0x1f991a01c277b9e0), LL(0x8b2c12bd0319a668)}, {LL(0x93fc413a1f54b027), LL(0xaeb752584e0f23c7)}, {LL(0x806028f61720d58d), LL(0xf457948bd9f155a0)}, {LL(0xf842d008df3e810c), LL(0xd2a390a118c879c6)},
			{LL(0x46d3ccfc8ff0e582), LL(0xf3ac2093c70ba3b6)}, {LL(0x9bfaa20d935699ea), LL(0x303fcaad17b502cd)}, {LL(0xfaa29875fcdf1aae), LL(0x1481b60d9f07e025)}, {LL(0x5c3962d8fb1705b4), LL(0x54d56de3abc9594b)},
			{LL(0x7557afecf28c249a), LL(0x9429c312f75851f9)}, {LL(0xf2a47b4270dd3363), LL(0x8a092ef8c6bdc12f)}, {LL(0x32f447cf8ded6d49), LL(0x0494f0d792d55fdf)}, {LL(0x5d4946070b86a9e5), LL(0x37c47eb5094ff4db)},
			{LL(0x1d79527ce1962242), LL(0x4d0e341184d63f8b)}, {LL(0xf6a7ebb836dcc6e4), LL(0xc54d62630be0302a)}, {LL(0x60281ea79f182f15), LL(0x47af6ff62a344f78)}, {LL(0x62c856dabcf9b4b7), LL(0x818d495aadfbd69b)},
			{LL(0x4ad6bf3145f339c8), LL(0x2260f4fd53ec73b9)}, {LL(0x7c2168048e1fa106), LL(0x69b048b10c64dd63)}, {LL(0xeead0de161dabd70), LL(0xa41609bfe0ed5334)}, {LL(0xa2986a5741c9ea9d), LL(0x0f109775f993486b)},
			{LL(0x2388667ea6789341), LL(0x985610a882e4b05b)}, {LL(0xac7d51e7a82bad75), LL(0x18fe65b7eabb0187)}, {LL(0x986aceaf4026ae19), LL(0x950cff5732fc36be)}, {LL(0xe138128e78a956c9), LL(0xd0e9e82b5143b748)},
			{LL(0x139c69cc087465aa), LL(0x5ae0c6d397fe7667)}, {LL(0xc52388a84ba007fc), LL(0xa2c881e23bb3c265)}, {LL(0xdbcab6767946124d), LL(0x4af580099a2cc99d)}, {LL(0x73b4776b976c4abf), LL(0x1d4fa925bdca391f)},
			{LL(0xc0503c8dfd305e2a), LL(0x8e9dde2f54689ef0)}, {LL(0xd05c39e326340c73), LL(0x714e2d06e6dfdce4)}, {LL(0x3af2a4f801ef4484), LL(0x9a1c6822cb6f7ed5)}, {LL(0x3b828027f17ee8d5), LL(0xf90d7b7469e9d345)},
			{LL(0x655baa82298876c3), LL(0x6bfa303b45ef13ed)}, {LL(0x514c35cac18575af), LL(0xe608aadb9da824d4)}, {LL(0x6bbe9132c06a312b), LL(0x7c14c2f956c75a01)}, {LL(0xafed3d457b5b9a86), LL(0xbdcd504dcff235f4)},
			{LL(0x4030147bea108ba7), LL(0x7aca4aa48d99cb50)}, {LL(0x1ee93ede32e615b1), LL(0xe83d01eba19f0bf8)}, {LL(0x20180adc7508a4b2), LL(0x3d652552a7ad8428)}, {LL(0x85139cd3a1b08c5b), LL(0xd802cb46b62a0935)},
			{LL(0xf447a3c5153d5d46), LL(0x036f44cf8c2fa9c9)}, {LL(0x47a3e8237f6149d3), LL(0x90bd33c5658d0e26)}, {LL(0x3787f3ea3b7d349f), LL(0x28c1af1afd0e034a)}, {LL(0x6ecd251776fa68fd), LL(0x50419d34391c0694)},
			{LL(0x906c2d98cc2487d4), LL(0x0b8467a26b4617b4)}, {LL(0xc6b3e40a98d0300f), LL(0x07fbb4181efaf616)}, {LL(0x0976c7e87c93859c), LL(0xfd998ba3fb3c8c9a)}, {LL(0x8280608b34c14e2f), LL(0x3275b2275e3ecc43)},
			{LL(0xdeb90253cfd64b9b), LL(0x66a0dfc4f5f79508)}, {LL(0xb697ffc3dccc4d43), LL(0xbf8728c78679fb7a)}, {LL(0xd92afe0b5aa789ef), LL(0x8cd7a6a51de3507e)}, {LL(0xc3c0502f2e4069d9), LL(0x2baeebd57121aa83)},
			{LL(0x543f81ef77152c79), LL(0xca5df516f2737841)}, {LL(0xc926fb6581a3dbb6), LL(0x7304558caf54126a)}, {LL(0x946fbd628a257253), LL(0x44c02b39a61be6b1)}, {LL(0x281ee9ebf90a8d7f), LL(0xa3edbda7fe17a522)},
			{LL(0xf044333f533ca8c1), LL(0x4c2b0854417258cc)}, {LL(0x3d6158a0949e86f0), LL(0x706b1143237bbba3)}, {LL(0x7ac2b083ebffcf23), LL(0xe0d6228646f6b585)}, {LL(0xc856dfba713277e7), LL(0x101546da0dd2bffa)},
			{LL(0x06e3d88765e06e25), LL(0x89666a374a9268e6)}, {LL(0xc7c3c0d568419c5e), LL(0x64eaa74ebc7c5b86)}, {LL(0xf7d7cf67c64d6ab5), LL(0xa65c7135a9669dba)}, {LL(0x4fa50b14f363601e), LL(0x0e35ab303c372f2c)},
			{LL(0x02e0487d23e19ba2), LL(0xc62226ac87cf99e3)}, {LL(0xbfe1382ba05fc8df), LL(0x421ea3647d4577e0)}, {LL(0xebdeb9c4d74ae4a6), LL(0x884356728f360fa1)}, {LL(0x503c11153114d9fe), LL(0x8519b98d3f2e8944)},
			{LL(0x6fbd01c8866bc4ac), LL(0x33508e629b9aab04)}, {LL(0xd12c1d3cd6a5a022), LL(0x125f3e5044597174)}, {LL(0x87f3d4ae825117f9), LL(0x1e20edea31e590d6)}, {LL(0x8a8683bcb8c367e2), LL(0xacfd2ad20784ed49)},
			{LL(0x0c0573cdca03dc4a), LL(0xd1ccd46e94e7d00f)}, {LL(0x4d454369d082fbbc), LL(0xc8178d9cbbf8b6cf)}, {LL(0x241b9a2633095135), LL(0x722169c96af0752d)}, {LL(0xdfc9268c3f47e7ca), LL(0x05b1cc9257713898)},
			{LL(0x72c453b467fde6ee), LL(0x7e5eba731f4c948f)}, {LL(0xffd12c504a4f4378), LL(0x38d4e9c0f0dcbcb0)}, {LL(0x42d05c06c9f11005), LL(0xbce86c080a5652b3)}, {LL(0xe3d85af35b48cd6b), LL(0x16cbce87d68c2eab)},
			{LL(0x017024dff091ac51), LL(0x63111356a286ad90)}, {LL(0xb477b7beff2dd6e1), LL(0x79a50e6b01b66299)}, {LL(0x100c056edb045259), LL(0xffd3f329b2b74214)}, {LL(0xa90ee5c21ebbf4a3), LL(0x34ab3a7a85605d12)},
			{LL(0xa87ec11dee2a58f2), LL(0x57ba292c27e6f082)}, {LL(0x4543a05e5c80d271), LL(0x569f1569e24297c5)}, {LL(0xd6bfe16443d46256), LL(0xf8284731ac4db402)}, {LL(0x8916ef1e6bb35011), LL(0x09ce1f2822cdd93a)},
			{LL(0x4836f74c6612a26a), LL(0xe442d251d423ea5a)}, {LL(0x695ed94fe38baa89), LL(0xba36e455d108c3e2)}, {LL(0x180ae65957067b94), LL(0x615b6bdceb0d631e)}, {LL(0x8e851346fec29265), LL(0xe3b96649cad91c4c)},
			{LL(0x2b8e85492a7aba8c), LL(0x06de885ddb5e9151)}, {LL(0x9a8a86d263c735bb), LL(0x532ed9fbb533af5d)}, {LL(0x3962c85ad29f7377), LL(0x3f2f5dd8ee264aa6)}, {LL(0x9e89162825c6c03c), LL(0x1c6a9560786e5e58)},
			{LL(0xc12018520da1f27b), LL(0xed8ccd79f6ee3360)}, {LL(0x554fa53087848028), LL(0xa94ce64050f5d5d1)}, {LL(0xb872c473352e0aab), LL(0xa869da059551b296)}, {LL(0xec4d459c423b26d2), LL(0x62342f136722cad7)},
			{LL(0xcd256b9fc7a22e31), LL(0x3c4019176209e36f)}, {LL(0x140f95949d05a7de), LL(0xb097bfb27feab311)}, {LL(0xb2946f399acdb8c4), LL(0xf0c3645c4b240a7f)}, {LL(0x6c2d6d6a551bf35f), LL(0x9663bb98bed39f77)},
			{LL(0xa3e84e88b15846cc), LL(0x6c0184235b15e5fb)}, {LL(0x9d197a8af6b6f7cf), LL(0xb959a09a5d276a2b)}, {LL(0x928c65e5efc51c76), LL(0xcda6410eec898e57)}, {LL(0xbc715489732fff2c), LL(0xe72d969e580c4393)},
			{LL(0xa47bb2d0242984b8), LL(0x8676fd42b301208d)}, {LL(0x682efd90131a06d8), LL(0xd927f703738e6e72)}, {LL(0x296ecd34099b212e), LL(0xc0fcaef15c9108b2)}, {LL(0x1aeaae2474e7e036), LL(0xa7794d706cc2fafd)},
			{LL(0x56dfc99254f4b7db), LL(0x0c7fd3ba75bce1a2)}, {LL(0x76c7c34e21fc1369), LL(0x311af6e8d211658a)}, {LL(0x8bf6a7634852cbb3), LL(0xcfec3984a50240d9)}, {LL(0xcbc6b318a2424014), LL(0xb5267320289b8b89)},
			{LL(0xb3e44be66a5c1495), LL(0x93d2770ae9a2a7ef)}, {LL(0xd85adad4aa3625be), LL(0xefc6b5f3bf65fdee)}, {LL(0x594ad6fd4d875c62), LL(0x7880322ec41205de)}, {LL(0x3c117c7f640f2aa1), LL(0x137a021581fd1633)},
			{LL(0x4946d39396830e3b), LL(0x8753c10776a547ca)}, {LL(0x5ed92aa5d8f69e16), LL(0x92f74b4f2c06c0a8)}, {LL(0xb0742744b92c2366), LL(0x36e142f0cceb939c)}, {LL(0xa50b960fd4b828e9), LL(0xe567ee1411878d1d)},
			{LL(0x52dc596812f5425c), LL(0x433b9f21b8e110a7)}, {LL(0x34179f48e80d036c), LL(0x8df29ae0d8473739)}, {LL(0x9ff932f7d5576c6d), LL(0x7f7b8636dae8f3c8)}, {LL(0xc453ac77bb31abad), LL(0xc1d992b499356ff5)},
			{LL(0xb104039b49bd8f37), LL(0x55f051a66e6d3e0c)}, {LL(0x67bbe2ff0a69ed61), LL(0xadd81697c2208a0e)}, {LL(0xa7ebde72f759b34b), LL(0x2345c8b8964814fe)}, {LL(0x0f951f6f1973ebb9), LL(0x74ffe194b1aee47c)},
			{LL(0x21682e03859908e3), LL(0x5e743604052b29b8)}, {LL(0x31642b6d5e9d5aba), LL(0xa1a7c52db79c6bac)}, {LL(0x968ff51fa9c4e9f1), LL(0x82e20d9521d47f52)}, {LL(0x97ffd1c0595545a0), LL(0xe1f31ec38352d2c2)},
			{LL(0x911c09473cb52b85), LL(0x689574f4c9c0ba24)}, {LL(0xed3d6143b2aa8a83), LL(0x01253c45c5a46747)}, {LL(0xfd31642d69aed8da), LL(0xfef6cf6c77132553)}, {LL(0x5fa90e7a28673247), LL(0xf1e658198e806d38)},
			{LL(0x197ac286a797d7c5), LL(0x024a788a498bce8e)}, {LL(0xb50793610fbc7ab0), LL(0x1ab41d3da330cf09)}, {LL(0x583af222bd16f033), LL(0x1b9121786694a84e)}, {LL(0xb902e0acc5bfa6fa), LL(0xcb78c95337d71f06)},
			{LL(0x8d157fe42db2a596), LL(0x468a53b3ef90283f)}, {LL(0x0ae6ab4aafe3b26f), LL(0x58aabe59de75b8e9)}, {LL(0xa10806f592b9dd6e), LL(0xaa23a28fdcda7c18)}, {LL(0xceb5073d14d219c2), LL(0x99732ced4740d71c)},
			{LL(0x414030a41a8127f6), LL(0x19db59f22f1f66c0)}, {LL(0xaa9e8960cdcbc350), LL(0x91980f80a0296961)}, {LL(0xfbd2bcaa0c4eb6ff), LL(0x7790a55b3d814db5)}, {LL(0xf932f4d72faf2d5d), LL(0xb1b283f7ba4ed456)},
			{LL(0x2d6d5dce4f9ad4a9), LL(0x8fb8e26a91ccf9b7)}, {LL(0xbe911cf450ce648e), LL(0x210fb032dfc3da70)}, {LL(0xf537871ae5acf117), LL(0x607e57992ea90459)}, {LL(0x0d7557123a92701b), LL(0xb2ddc73836617d9f)},
			{LL(0x26fbd25b10e8ca97), LL(0xb4034f65ed3fecce)}, {LL(0xbd01705683be537d), LL(0x843c85c8fa8aee03)}, {LL(0xe7dbca091d4938ec), LL(0x598f821c1bd1dfae)}, {LL(0xbbe2a8d1e65e3d58), LL(0x0d5aefffb01886e5)},
			{LL(0xeaae9d1b27db48f7), LL(0xeb5245242db0a231)}, {LL(0xe44ba6abce390f1f), LL(0xfcbcb7e63e98ebdd)}, {LL(0x12ec4d13f8e5c9fb), LL(0x39f1d5853578dbf7)}, {LL(0x16efdde9bee43c7c), LL(0x76b5991ef8252af2)},
			{LL(0xba928c0e16cf9109), LL(0x6e4bfca9129e2b75)}, {LL(0x53ac7db7e264ee0d), LL(0x202a8c771a67bd37)}, {LL(0x6aceb5ed30fb9d7a), LL(0x1f05d1aff441f791)}, {LL(0x1b9a8afb84764c67), LL(0xc4685e26ce44576d)},
			{LL(0xcab697c752d3ec45), LL(0xd63760768a1d2619)}, {LL(0x040390fa4601f587), LL(0x4f444c9bcd5df105)}, {LL(0x81100c29e7b179dc), LL(0x974687dd7b77f830)}, {LL(0x0ee53bb0e9e247e8), LL(0x17eef2c2132849ec)},
			{LL(0x4ed52fcb03f2cc4f), LL(0x6d24b8669eb182bc)}, {LL(0x71543f16b48dd11d), LL(0xdb6d8f893a05a0fc)}, {LL(0xe53b82743ea8a34e), LL(0x9fada4b09c1e464d)}, {LL(0xe93ef1b9f4ab7f04), LL(0x4e6170de08f99642)},
			{LL(0x30140fb2ae0cf6eb), LL(0xc2b6d67b151ac63c)}, {LL(0x2c1d7911bf0b78f8), LL(0xeca9f13c334a5427)}, {LL(0x03906ca2d37037f3), LL(0xa53335fa25493473)}, {LL(0x0b968f955f721e3e), LL(0x3bbbad0f7cf31579)},
			{LL(0x3567bb97189caf3d), LL(0xeee389b67ac19aa9)}, {LL(0xe6abeed6edd894bd), LL(0x3a9e914ab957723e)}, {LL(0x57afed4da4651b8a), LL(0x6f6ec0ecd73a4c32)}, {LL(0xc2b074f0ded1c588), LL(0x48bff883d3a70713)},
			{LL(0x2afea196daeb16dd), LL(0x65cf9b0b79d83cc1)}, {LL(0x0806e3378c0229cd), LL(0x9e8898f559ba210a)}, {LL(0x2f8d15b36c7b4f0b), LL(0x499ac4c616036054)}, {LL(0x1c0976a311078e13), LL(0x2e1f27472650921b)},
			{LL(0xe04836518838fa98), LL(0xb3f8fb7df3c51ad8)}, {LL(0x951f99bd7ab4de02), LL(0x27d1386f049d4b21)}, {LL(0xcfc523e2e443b593), LL(0xfa623fbbe5c67a8c)}, {LL(0xd3cc5541f5443b80), LL(0xd47d18fcc396e897)},
			{LL(0xf13417e0a3ad0490), LL(0x2f3a1b02e3f4f55c)}, {LL(0x7952dc21388ff8d0), LL(0x45e5177c63bf81f6)}, {LL(0xad0d753858ba0124), LL(0x7bef76e1483dac17)}, {LL(0x8ff537990e533e34), LL(0x80a8751f685fb1dc)},
			{LL(0x74278b33021d88cb), LL(0xf738d04455defc69)}, {LL(0x4c3567b6201357ed), LL(0xab069eca197e1b5f)}, {LL(0xd45fa9196035f9f4), LL(0x3e0a619d2b822de1)}, {LL(0x36f7d735cbec98ce), LL(0x4bd0bc4c5f88aeda)},
			{LL(0x4ba69beeb5629599), LL(0x4171e7abf16ade29)}, {LL(0x22f842a156e93f10), LL(0xfb4703fe20621dcb)}, {LL(0x61583a786f898344), LL(0x24be7ca088b2e2e8)}, {LL(0x8866cbc19b22fc40), LL(0x6adf0c7e804b74aa)},
			{LL(0x642b8e5dd919da92), LL(0x08eb236de769be7d)}, {LL(0xe2a87e2cabd9613a), LL(0x75daddd1740a833b)}, {LL(0xabeeadbf3d5a6f01), LL(0xf2891cd602afc4f1)}, {LL(0x3812ec85220edf26), LL(0x5c3e4e8e4ca0e736)},
			{LL(0xb7e7db1c2c5de112), LL(0xdc963b9124ff56ea)}, {LL(0xa69bfaad07c81f1a), LL(0x4054dbee34ceb96e)}, {LL(0x991aea70b0b70248), LL(0xf61dec01907a9b2e)}, {LL(0xdd296ef11ca67c68), LL(0xc393ea3ed0bea17b)},
			{LL(0x7fb104a65d6f96f5), LL(0xcc837d4b292de910)}, {LL(0x7822f8fec81e5481), LL(0x26f4042ac1392c66)}, {LL(0xfc4140f2993f748b), LL(0x9de7dc3ad59588c3)}, {LL(0x8c655b3bdd2309c7), LL(0x259b40e54d1685af)},
			{LL(0x0573b425b69059d6), LL(0x2c555fcd6fdb5c95)}, {LL(0x44338481ac117e20), LL(0x358e063f40c43a55)}, {LL(0x8463b80c5121200a), LL(0xbb13d81014aca4a5)}, {LL(0x117c21b12b95fe08), LL(0x9cc2e07f1031ef84)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x70241bc9441c7d4c), LL(0xb87c9cdf98830d6c)}, {LL(0xae9d199a8bca36d7), LL(0xdedc431b6d749864)}, {LL(0x0793fc589571c274), LL(0xea777961e814c576)}
		}, {
			{LL(0xca4bbbc9cc5ff651), LL(0xe6efa2675bea527e)}, {LL(0x10cf72f803a5ae33), LL(0x67ba66b80641dbac)}, {LL(0xd0c26f5217156aa4), LL(0x868e8b942ecb2670)}, {LL(0xfffa7ed2a5e5de67), LL(0xad6ecea889194a18)},
			{LL(0x4afcad05d43ecf0a), LL(0x587614ee6ba74557)}, {LL(0x09e69792fc9d84e7), LL(0x591e0db63b707c2c)}, {LL(0xeb76f114d6f8ba28), LL(0xa31b503e6fd9d79f)}, {LL(0x241e190d7631551a), LL(0xa778349dec0333b0)},
			{LL(0x6aa14936d2b7506c), LL(0x96c1d85d672530cc)}, {LL(0x827789d3203d5c65), LL(0x6b1fca9e40ec34dd)}, {LL(0x750bce7d656bd5fa), LL(0x142c376aca34f293)}, {LL(0x66648d7442bccde8), LL(0x2d53132f8465fab1)},
			{LL(0xe7b3355646f327ac), LL(0x18899b4c8c991de2)}, {LL(0x5f108c2dbb0d785a), LL(0xdd40b492b5d628aa)}, {LL(0xc2cd82b52ceca1a9), LL(0x34b2913b582bde28)}, {LL(0xb2e51f1825116d30), LL(0xc21260954a2f9aea)},
			{LL(0x6347dea42e2ad48b), LL(0xcfdfd5eb5c554ce0)}, {LL(0x543684a07fcc9983), LL(0x51d8c533fe077772)}, {LL(0x3e97cd96ad7bc9ef), LL(0xc7191d6e992247be)}, {LL(0x205de43306899f66), LL(0xceb7ccb30c82759b)},
			{LL(0x943b990a6b7c5d14), LL(0xb0ec281fd68d8aae)}, {LL(0x120fede73bf9cb0d), LL(0xb23c1aaf76e0f858)}, {LL(0x257eb7e36a1f8605), LL(0x2c3b0a77d4b2c3ca)}, {LL(0xe573aa497eaf4292), LL(0xcd0fe75bfc383e16)},
			{LL(0x8317273d3c138f7a), LL(0xe05cf474785dc4a7)}, {LL(0xccc8d9e884bb5913), LL(0x5aa6265ecbca37a1)}, {LL(0xd481926c67ada0d8), LL(0xef4173bace4a605b)}, {LL(0xaeefa9a2b6bf5e87), LL(0x1e3acd5faf2e8b3b)},
			{LL(0x618741bb1676b1b5), LL(0x1a59a9fc2cf46f14)}, {LL(0x8c72d28e886aa4df), LL(0x050b7dfbd30ddd54)}, {LL(0x4759c7a9581b8191), LL(0x68a7e176b0567f50)}, {LL(0xce0846f7bce73c2d), LL(0x8f205a49bb6b1455)},
			{LL(0x2a1b4250de66ada0), LL(0xc96c83f87fe2da39)}, {LL(0x2b7becbec2487ebf), LL(0x422fbd1247532a43)}, {LL(0x26de86124e6d3024), LL(0x72fe488a9ca21044)}, {LL(0x93d855c53fb62149), LL(0x87e692cc7e1c1f0b)},
			{LL(0xe13057770e1788ee), LL(0xa4c01f751cb9783d)}, {LL(0x11afdc161f8b7d2c), LL(0xecf958523ef02bd6)}, {LL(0x7ced59ef99f6511d), LL(0x4d323adcf1448ebf)}, {LL(0x40ba0b660cd1fdcc), LL(0x5fad5ba518c7eaf5)},
			{LL(0x0443fd3e70b8ca7c), LL(0x69cff82ee081462b)}, {LL(0x463969474435528e), LL(0xe3e4df9c88e78f2a)}, {LL(0x7388ac5c2d8f7ab8), LL(0xa865b3535a14974c)}, {LL(0xd6410d735ff1c5e6), LL(0x3ac70fadbeeb43af)},
			{LL(0xc52e4e7a7826ddf4), LL(0x03b82be8f0ba4b8d)}, {LL(0x5b537113cbb5b226), LL(0xb48f4cbc55576e81)}, {LL(0xfbb983ecd55d141b), LL(0xc4a1368669980c33)}, {LL(0x148c8fc6731d644f), LL(0x0e759e96e6c09d87)},
			{LL(0xc68e7f8b5c546bd5), LL(0x5d7d6915b8aa9803)}, {LL(0xa86ccb83fe5bf1c5), LL(0xa27349663f0eeee4)}, {LL(0x15ec21286f33b750), LL(0x8536a07cde716dfd)}, {LL(0x213d4add1aa74c79), LL(0x45f4f259343385e1)},
			{LL(0x9118cada07ea4477), LL(0x5260eedb0ebd3cff)}, {LL(0xe9b66e0beea4df16), LL(0x769d2c291f78f46b)}, {LL(0x6861d629eaeb3552), LL(0x4347a44a17841338)}, {LL(0x4b9c03ebc8101c15), LL(0xd3352a045316b52d)},
			{LL(0x0da56aac8c254e9b), LL(0x30d1f598dbf13a07)}, {LL(0xbe20db5ab51af0b4), LL(0x7980abe7a96f5097)}, {LL(0x02c09f1f385c653e), LL(0xd5867c1770a123f4)}, {LL(0xf61ce94059785a80), LL(0xf470c31eb2693634)},
			{LL(0x35b1c51b69ba2836), LL(0x4b816ccfd2f31866)}, {LL(0x41daa58810ff2ed3), LL(0xd4ee654f20761a8f)}, {LL(0x495c9cf4f04c792b), LL(0x06b3561323b796d9)}, {LL(0xdfa79ae1a36c4101), LL(0x63d9021b859b3f83)},
			{LL(0x70289dad09fdcc99), LL(0xf6a0f1ae120444c2)}, {LL(0xf1ff258f0db226dd), LL(0xc37a79cd1af8a391)}, {LL(0xb8a3b97bfdfe5ff6), LL(0xc5c92fde394f3548)}, {LL(0x907864341bc49768), LL(0xd923d031360ccc85)},
			{LL(0x136f430927d71812), LL(0x397f24454e510822)}, {LL(0xbce044458d46958a), LL(0xac06d7f0d9ce7363)}, {LL(0xe8d6c0e5f28a0c09), LL(0xfdde12c327c90411)}, {LL(0xad4f985392cde8a6), LL(0x40ff8fa2e73e58b5)},
			{LL(0xb4667d396df5c272), LL(0x7e5be4acda0fff35)}, {LL(0x77cb51625d37b0c4), LL(0xc1aa4b7dba95d167)}, {LL(0xf819b21df12fa23a), LL(0x9a64747b2188dfbd)}, {LL(0x3332a73a215e8774), LL(0xf7c8e8f642d37db9)},
			{LL(0x52b5e681372836c1), LL(0xed91410a6e2712ad)}, {LL(0xc7eed165407ab8ca), LL(0xd63e57ff801b6879)}, {LL(0xac2f36bd8ee33bb9), LL(0xcbbcb148df8fa8cf)}, {LL(0xc9eb8a38e82d4070), LL(0xb82ae09a13fa81f0)},
			{LL(0x8951815ee4fcbdbc), LL(0xe787bb3f0b3d6b05)}, {LL(0x483c321aec62aa34), LL(0x8df068f91b0666a3)}, {LL(0xedf593359e1c156a), LL(0x1f52d407fff9b240)}, {LL(0x4c7fcf249cda6048), LL(0xe43f90d7fb872088)},
			{LL(0x7a6e3bced112fe5f), LL(0xf17bbee56164eb60)}, {LL(0x999ef3a6e759138f), LL(0x803ddd870d7cb0a9)}, {LL(0x4fdffed5b8a8d669), LL(0xbafad22ab397f306)}, {LL(0xd202f04d2f490f9a), LL(0x5308f7835e6a0584)},
			{LL(0xa90c656de27522da), LL(0x2930778c07bf1e9e)}, {LL(0x2df88e9f8aacd1fd), LL(0xfe66392bd7734f9c)}, {LL(0x5a33dffdd79b6139), LL(0x3fcc72566de69efb)}, {LL(0x0f65f5b3b4792ba5), LL(0xe557898fab5019f3)},
			{LL(0xf25f147e29c090fc), LL(0x9dbf3b3052e8701f)}, {LL(0x5115d770135a80e0), LL(0xb35403f72637c123)}, {LL(0xcda8770698958a0c), LL(0xd1e518b4f37bc7db)}, {LL(0x4d1f61ca80f4b357), LL(0x6f7cae3dc336d0f2)},
			{LL(0xef350c2aa6407054), LL(0xcad4a8108f5891b4)}, {LL(0xe41304a76281918d), LL(0x464cd9b1c489ce6c)}, {LL(0x9e7d3f69b3936fd2), LL(0xb7376754a5ed250c)}, {LL(0x6704239a5e921ef7), LL(0xa6102dc5bcd40acb)},
			{LL(0xa5c9a12f727ebf5e), LL(0x92a2bcfee4ffd4e3)}, {LL(0xd721a39d43df16f9), LL(0xb1843147865ab3d5)}, {LL(0x427a9479348d98f2), LL(0x8a2b27b26866c901)}, {LL(0xf33fba9035ee43e3), LL(0x16fc05da6a598065)},
			{LL(0x27be28fc5243e33b), LL(0xf9bd7660a413e03e)}, {LL(0xa22a6de026b4c303), LL(0xa5a8062d4c6e4146)}, {LL(0xf5bcd8b17d0aeca1), LL(0xaab581e3fa79e5ba)}, {LL(0x1faa874bb7dc8596), LL(0x82edef37ad11c25f)},
			{LL(0x60e7ef550a5862aa), LL(0x911a971614459f6e)}, {LL(0xf77c47ae4556899f), LL(0x7f33fdf48ad8c64e)}, {LL(0xfc5a4f2381976846), LL(0xf3ab8c55c1099996)}, {LL(0xa4a90fc16e506c41), LL(0x19e18214dc4e2499)},
			{LL(0x96fb06155320382a), LL(0x656a5408a62ca95a)}, {LL(0xa7093e304a22da60), LL(0x4724c0e9945ef717)}, {LL(0x746b6093794506e5), LL(0x9f6f0980f28502e9)}, {LL(0x6227704a32040794), LL(0x449ceb0164e4bc9a)},
			{LL(0xf4dc765f61243fbe), LL(0x21f6bf09c2c815c0)}, {LL(0x98fe5d48fb77c090), LL(0x0b7ee36d35cd40d3)}, {LL(0xb385b1f6393fbe2f), LL(0x49515e7f729e6a90)}, {LL(0x8af1b0afc08e0b9d), LL(0xb942f9c2432db88b)},
			{LL(0x29bb73a1fa141b81), LL(0x97a9c10537f209b7)}, {LL(0x5796b5515bbe2fa2), LL(0x0f1d87ceb617a4fc)}, {LL(0x4ebf503ba4860576), LL(0x31b9ecc08b26037c)}, {LL(0xee55a2c4ba6ea34b), LL(0x419796fab7e961ce)},
			{LL(0xabccfa72da2947e4), LL(0xfcb60b9b771e3d6a)}, {LL(0x8754da034cab4506), LL(0x89930c5a98dc828c)}, {LL(0x309296cb052c3155), LL(0xa90daa0b0ac3ae37)}, {LL(0x9a3ec257c32ba5ae), LL(0xdef89f7a456c6327)},
			{LL(0xa34ac30e3a9a101c), LL(0x2eeb38c774dfb13c)}, {LL(0xec953ddb8232c675), LL(0x9411eaedc748423a)}, {LL(0x80b716cc1861395b), LL(0xbe99b689304d1729)}, {LL(0xfad92d02c973c704), LL(0x4fe2086c5129fc49)},
			{LL(0x84f4ebf268d9f327), LL(0xd7564ea7d0cc5102)}, {LL(0x690178c7f6c5e64d), LL(0xc8049aa02f35e342)}, {LL(0x55562a4e63e24a9c), LL(0xda9bfbd9c6b68708)}, {LL(0xdc07ab10871ef720), LL(0x3d1c40e6cd8bec0d)},
			{LL(0xb7c64cc849877453), LL(0x209ea651921f2cbb)}, {LL(0xe3f0c868364bedd0), LL(0x714663626c185bc9)}, {LL(0xbd80eaab91684695), LL(0x2745e91ae17f8319)}, {LL(0x9ddd0e9897e1d9f3), LL(0xe9f225a9edfdf682)},
			{LL(0xd3625ea33367dc85), LL(0xd84bc96966dbf5fe)}, {LL(0xc16db344089e1788), LL(0x6a77d3c6103b0da6)}, {LL(0x44f9f6587c6937b0), LL(0x3662a38bf846acde)}, {LL(0xa18a5c1102c67522), LL(0xfb6d44d0047e92c8)},
			{LL(0x955b37e477528e0b), LL(0x3baf16f5ee3c7ad4)}, {LL(0x7d8df70185d88202), LL(0xc6710436c9f57ec5)}, {LL(0x65c4bc8566ce7bc9), LL(0x739651d2cc75293f)}, {LL(0x76abff8c411963db), LL(0x4ae975978224211d)},
			{LL(0xc3ad2c5b30c272b6), LL(0xbff1afd1609a2e52)}, {LL(0x7b0e9520cd3c2d40), LL(0x7a38800f59d51b1a)}, {LL(0xcb2b1527d071254e), LL(0x6dac9c8d635ba204)}, {LL(0xbb03888ad98ce9d7), LL(0x9b0c6d23715fe6c6)},
			{LL(0xbf4075b4a93423ab), LL(0xf2c3950d91dea0ed)}, {LL(0xaf8f074caa918d98), LL(0x9579f3b5979f7b41)}, {LL(0xba632664c5a23ac8), LL(0x104f53c949ee16bc)}, {LL(0x459958b66047e4af), LL(0xbd219d61c0f75ca4)},
			{LL(0x88312fb0f8d26ea3), LL(0x6cc485d5338c9b7f)}, {LL(0x81d7b822044fea44), LL(0x35da886308fce753)}, {LL(0x0cc5c442900b9d84), LL(0xbb92cb72e340ca7d)}, {LL(0x28dbdd4fe63ac89e), LL(0x1ceaffef0f43f9cd)},
			{LL(0x2c982071968202e2), LL(0x752507c1efc2bfe6)}, {LL(0x9f1d9187afbdbccd), LL(0x3c7459be9d5cd576)}, {LL(0xaaac549cc60794fb), LL(0x77f535714fafcd10)}, {LL(0x5e7022c3a723ab45), LL(0x56038a788d67d8d0)},
			{LL(0x7e2dc6f0a1aa3423), LL(0x98b446cb81e5ad4b)}, {LL(0x0a46a663d8ef32c6), LL(0x07db4f4b7360afa2)}, {LL(0xa0eaf2ff1ee8a63d), LL(0x702e7a3a3ccf62b2)}, {LL(0x3611f4ea4dc89e17), LL(0x15442e329ae3cbe8)},
			{LL(0xc44ee09464080eeb), LL(0x88fb1502c80bbbf7)}, {LL(0x6c222b179a53ff2e), LL(0x2a885c64f7055513)}, {LL(0x18494b84e316f9cb), LL(0xb5e755e4058057fa)}, {LL(0x39740159f9b1b5b2), LL(0xf013a7bd31b3d21b)},
			{LL(0xd844562ef7a63d5c), LL(0x54d3b8c82d0aaa26)}, {LL(0x31f238251902e24a), LL(0x224e94e132725e4d)}, {LL(0x5dd0133283511d64), LL(0x08c6c885c5770b5e)}, {LL(0x164c10d94b410171), LL(0xdbf3e2819661be73)},
			{LL(0x979ba8fb4f0eeb35), LL(0xee296ae29e9d5920)}, {LL(0xd5e13c827b8373c7), LL(0x64024d50f6fb9021)}, {LL(0x58f340e2efc70407), LL(0xea4a0e411d47bd0f)}, {LL(0xfd3ae1cd9db9bb59), LL(0x78e8b2bff9b869ec)},
			{LL(0x8594451c74f72038), LL(0x5c15704de87da178)}, {LL(0x1be97a75c7644fea), LL(0xeb2217194d908474)}, {LL(0xea165ffacad66937), LL(0x28586ed4576827e5)}, {LL(0x052353d06c961963), LL(0xe28cc6c4d830b651)},
			{LL(0x5993ee0cf3e9d718), LL(0x610930ab25f64d75)}, {LL(0x72e802b231a1a9a7), LL(0x23268db962a56736)}, {LL(0x229d7b2c3ed5fa58), LL(0x1b31b0a47c23566f)}, {LL(0xb1452ee90163db11), LL(0x9cd72268023f4964)},
			{LL(0x1a89d49bdb4a9cf5), LL(0x606129f37521740e)}, {LL(0x0b26088dc4c1e1d9), LL(0x8c9871a14bd15fd8)}, {LL(0xb9c31795e1d08ce9), LL(0x4e8a113401fec532)}, {LL(0xf9791cf3ed017125), LL(0x11274a9119392fc7)},
			{LL(0x0886397ce0b357f8), LL(0xd25d335c03c18c56)}, {LL(0xc00d1daa14b0c497), LL(0xe134ed2c288afddc)}, {LL(0x9b5e6cb9df0576b1), LL(0x55bba1907ddd935d)}, {LL(0x863474ed50859619), LL(0x02d032b0a06d72f6)},
			{LL(0x6f821ae6be21490f), LL(0x744d1e99bf15869d)}, {LL(0x1eca29a5abf25689), LL(0x09aed1dd95a03225)}, {LL(0x2e58bf6eaede67dc), LL(0xa0a37bd69f639c12)}, {LL(0x37715a0451e64d08), LL(0x9e0710d8a2523b92)},
			{LL(0xe050f99912395bf1), LL(0x2f83219f24088847)}, {LL(0x1d6a18548f80e0a8), LL(0x576b9320ddb0e1ab)}, {LL(0xb02580071d4d080e), LL(0x17941c823a8eb91e)}, {LL(0xc88b24d6f403936f), LL(0x3369de702b4b718a)},
			{LL(0xdbe467dfd3d48b7d), LL(0x0a16fa35651a79a8)}, {LL(0x1929e56aff382ad4), LL(0x3ea46b0e3d31a780)}, {LL(0x56f61bbf4790fcbd), LL(0x845eb9248ea65486)}, {LL(0x7148334315d31f86), LL(0x7de3cf442ab5b4b8)},
			{LL(0x9cbda0768bcf0aec), LL(0x62b11b43d54c06f8)}, {LL(0xcf68e819a0c9ef32), LL(0x046364a383dae42f)}, {LL(0x79ce0a3ff560487e), LL(0xafbefc18297438ee)}, {LL(0x431a3a9728a34bed), LL(0x0168195850d7397b)},
			{LL(0x172cbe37576fd26e), LL(0x50b0dc6baed04e09)}, {LL(0x2f381180b2f0b4c3), LL(0x2be0453ca7d26c68)}, {LL(0x03a031f12472b621), LL(0x5ec542fd4810d38e)}, {LL(0xda84c931cffa5862), LL(0x8155c4df5dab89d2)},
			{LL(0x3d37fc6789097fce), LL(0x99dc5f93d1329430)}, {LL(0x3ad430a8ddc30393), LL(0xaed6e54079a30195)}, {LL(0xb6a6e22655a9a74c), LL(0xabdd98bbaaaedcc1)}, {LL(0x53d5486f2b06e5de), LL(0x66d27fe05696e2d7)},
			{LL(0xdd6705fe9b30243f), LL(0xb65f7e0cf53a1c77)}, {LL(0xd924f8c0eb88ee43), LL(0xdf90862215bb5a5c)}, {LL(0x6bc1e7d8ce998373), LL(0x1d82e6b75f94c0b6)}, {LL(0x3814afb7e59f66ad), LL(0x7b50995709022261)},
			{LL(0x3ff76378b1551af0), LL(0x4c5a2384a193b7c4)}, {LL(0x23fdd5c222fb2947), LL(0x90728e4e4492a615)}, {LL(0x7f4d681ebd84e73c), LL(0x13f77821b9545d31)}, {LL(0x78aea4d1e94e9b61), LL(0x24fdc2f211c5c894)},
			{LL(0x92b8fb2b2398f256), LL(0x0ca5ac2646adef71)}, {LL(0x34d16bf57594fb29), LL(0xc0c25225ea42e81c)}, {LL(0x5cb0bddc9f7fce7b), LL(0x8385f66ffdc6fb24)}, {LL(0x6ee2b408a20f9a10), LL(0xff0e207387a476e7)},
			{LL(0x5075799e0f7453ff), LL(0x38173d1d1e863159)}, {LL(0x07e3cccf54ca7c5d), LL(0x370abad3a89195a5)}, {LL(0x6d4285f9867d2c31), LL(0xa1cb628ecfb4a569)}, {LL(0x1c0ab6ba93ae33b7), LL(0xdc28adcae50111d1)},
			{LL(0xe6d39bb85addf4b3), LL(0x93caa5a6b428ed98)}, {LL(0x325209d43d70546b), LL(0x7c8bd61c7a628dc3)}, {LL(0x8d127c60944477c0), LL(0x8e484311ebbc2d2e)}, {LL(0xa66990de560c097f), LL(0xcc67fe03acef076d)},
			{LL(0xdec7340fbf42921e), LL(0xe89a3cf1bd2acff9)}, {LL(0x3c5752899527acd1), LL(0x129f6179e983644a)}, {LL(0xfe9ad03cb9cb0d78), LL(0x262df042b1a8ba62)}, {LL(0xf09f8b61119cf5c2), LL(0x48394727224953eb)},
			{LL(0xd1a2c1bc0b3bb9bb), LL(0x0dcdb57e167ad60a)}, {LL(0xb506d3d771db116d), LL(0xf518da46e2be0f4f)}, {LL(0x8eb24d91b036c1e1), LL(0xd08d01eca3acfea0)}, {LL(0x0160aeee1c2ed31f), LL(0x8b433eea38b1f07a)},
			{LL(0x8b911e41dca0d882), LL(0x3201c7287b9c48f1)}, {LL(0x0e055b5da857f8ba), LL(0x6e14b76593e1e989)}, {LL(0x3bb49e46c1edd08c), LL(0x2595dbaa4112f1ef)}, {LL(0xe29066862a653ecf), LL(0xfa055d8854a9abb3)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x8fd2e37fac1812fe), LL(0x5bce3f069b1d0eda)}, {LL(0x0683622148e4af42), LL(0xbc498439902065df)}, {LL(0x64a4126b7ae0a8d6), LL(0xf8d56f38f4c4d945)}
		}, {
			{LL(0x1cca2ad2f8e059d8), LL(0x311da87247255817)}, {LL(0xef10645c3874b669), LL(0xc0b7538ae9aaee82)}, {LL(0xa1d0914adb41d2c0), LL(0x89df013d8f5eac55)}, {LL(0xc7ff08545cf7bfba), LL(0x8edc20ac4e91a432)},
			{LL(0x684a8c77fbc6a016), LL(0xfeec75a8033c248d)}, {LL(0xf409a55bfeac6887), LL(0x6c3cd105cf17a0e0)}, {LL(0x63eb751f6a9ec558), LL(0x7e3617e50cf09071)}, {LL(0x5624d1af7ef56359), LL(0x73f0c214ba5cc506)},
			{LL(0x756a44cf8b2e0fc4), LL(0xbd41d37f12ab3b4a)}, {LL(0xb0824b4f04c99f6a), LL(0xd73eef5af09d111b)}, {LL(0xe175713544047b05), LL(0x395807b32b59c268)}, {LL(0xa8666ff69909989a), LL(0xeda67ff92c3596ca)},
			{LL(0xbee75e2678b95206), LL(0x2ed1bb63326e3df1)}, {LL(0xae5f66492f39e9a6), LL(0x02805ba11b1fc76f)}, {LL(0x8ac218fce4da020d), LL(0x51a76037d2702f56)}, {LL(0x42b2e7ab4c5586d1), LL(0x54241a0708a0e05e)},
			{LL(0x8163e19475826743), LL(0xd17d027addbc9baa)}, {LL(0x9e542ef8d67ae785), LL(0x7673b824608c0a0e)}, {LL(0xeb3e6a375d54e841), LL(0xcb326b5b72273144)}, {LL(0x1d20c8b870e8afd2), LL(0x43ada6d711971fc7)},
			{LL(0xd094dbee354f832c), LL(0x3f1bea93067848d9)}, {LL(0x2b1289b63f9bd0cd), LL(0xd878610a5d2e8303)}, {LL(0x342546da9c63500b), LL(0x7f76db54e01e12a7)}, {LL(0x7ae5b3cc7f5634a2), LL(0x361e89e386ea5070)},
			{LL(0xd283dc3ae65fac38), LL(0xdbb8f61aaadfc6ba)}, {LL(0x93ccde2ff112f3f7), LL(0x198ffe31586aef57)}, {LL(0xead4885dd55c1e4b), LL(0xb98265fe24957694)}, {LL(0x70aea8ce6606a7e6), LL(0xc474e50bdf94a35c)},
			{LL(0x45610c7e726d01e7), LL(0xc9b230fa6938f62b)}, {LL(0xa98c8d9c11016e90), LL(0x9f16715c7a87d11a)}, {LL(0xd747303b0b77041a), LL(0xa28dc06e67e05eac)}, {LL(0x57ce33c5f6fd9553), LL(0x0140ccb1ecee82d6)},
			{LL(0x4f2a177c6b3d92a3), LL(0x3bd85c1230460507)}, {LL(0x2d2b800989aba1f1), LL(0x375e45526a04d2a6)}, {LL(0x92263c45791a05fd), LL(0x6b3ff0940ed8a887)}, {LL(0x3d93b866de2b1a51), LL(0x1b0fa59043752838)},
			{LL(0x31e1aadb714bf829), LL(0x0643ed202d218ab1)}, {LL(0x8d11f329dae2853b), LL(0xcc314acab3e83923)}, {LL(0x157cd46ebaa81382), LL(0x5564d6b6e44e6288)}, {LL(0x3a4053b3e0139d67), LL(0x86998f6d22ed3e4d)},
			{LL(0x4b0419170e1dcc8b), LL(0x305d64c3abcbdac1)}, {LL(0xb546a74ee9e13748), LL(0xae0bd92e3da2890d)}, {LL(0x6e7385c84df6d12a), LL(0x11ca51f034167528)}, {LL(0x2ed665b7d2b378ef), LL(0xa14d577e90111b15)},
			{LL(0x67c57b740fbe9b70), LL(0x75b32f34977d4fb7)}, {LL(0xe55b7f5e2124252d), LL(0x32dd3f62b0d41dae)}, {LL(0x8cfb114352ea7331), LL(0xbe81446fe55a7ef3)}, {LL(0xa4147d4b36697ae2), LL(0xf0ea374942613443)},
			{LL(0xc1c601ebeac7ce86), LL(0x61fa04f479bbf597)}, {LL(0xffa85c336ff40dc9), LL(0xece6b348c0db141c)}, {LL(0xc615ea3ed4ff49b0), LL(0xfc6c2e091823e3e2)}, {LL(0x7f215fcd927e9c80), LL(0x4f2bbf974bd5c866)},
			{LL(0xf991558cd9c47cf5), LL(0x03c09710f7f145b9)}, {LL(0xa7e998f56d71a3fc), LL(0x66f92565b874fdf0)}, {LL(0xb168a9258cc16960), LL(0xa58ee1ffa62f56cb)}, {LL(0x0a4b1b0219509344), LL(0xf26a6ce8597ef32c)},
			{LL(0xbf0dbc4cf0b1a40c), LL(0x5c61b5c664dc7a21)}, {LL(0x9fbecc925e72118f), LL(0x04c3b681363e4dde)}, {LL(0xc402edea07ef66a4), LL(0x18cf3280b4846d81)}, {LL(0x33f6ad0fa25bd73d), LL(0xe2e0f1a9818604d2)},
			{LL(0xdb352286a417e662), LL(0xbfc188de09b4fc25)}, {LL(0x5841c4c60285ae35), LL(0x8a1f962d78afe9ec)}, {LL(0xce49f6e81ebff5e0), LL(0xeaa55e68edfa9ead)}, {LL(0xdadfc0ec2c1f1068), LL(0xcd71867b5f06bbf5)},
			{LL(0xc870ff57a88f84dc), LL(0x05837a30dad0cf08)}, {LL(0xdef1ce87493f4e40), LL(0xc6f4beaac48b6433)}, {LL(0x10b8386f5780bba0), LL(0x2c51e0c22971fa9e)}, {LL(0x9b90c2f93b524fa7), LL(0x0f468e50adb39218)},
			{LL(0x49131ec3dd0de39f), LL(0xd4fe784a076c54a2)}, {LL(0x5bbc2178599d772b), LL(0x1c0c840182ba205f)}, {LL(0xc5e80f808fe790ae), LL(0x6a7f3c25e2362a51)}, {LL(0xd6add251837ff210), LL(0xd03dcecb3152197c)},
			{LL(0xcdb4135645a72cfe), LL(0x7cb64c4417ef571e)}, {LL(0x25779cdf43eb1da1), LL(0x219735339fddafe9)}, {LL(0x2af86bdcb79326c7), LL(0xaac86faf0b9cc4d3)}, {LL(0x5433d67bade54c4d), LL(0x9753de9d16fb4b65)},
			{LL(0x1152da05df884daa), LL(0x5ee1ee677fc3bd4e)}, {LL(0xa3c7969e0851fdd4), LL(0x6d7c1db423f92236)}, {LL(0xb4ac452461e9c142), LL(0xdcbbd78b6b10cedd)}, {LL(0xbac9504d1d990c2e), LL(0x255483b2a9e3e237)},
			{LL(0x808903fefd8a9149), LL(0xa3cd0cdf8b0edc7a)}, {LL(0xac48619dfc29c6b2), LL(0xe6234728b7b8490c)}, {LL(0xeced81e2636c6f77), LL(0x56a441a613bf2731)}, {LL(0xe74c788af2340a39), LL(0xd67e23eb1c7393cd)},
			{LL(0x9a7a2093b35ab9ad), LL(0x7df680f5fb01d5c8)}, {LL(0x6f9967a2c5fe2720), LL(0x637a5f5562a432f8)}, {LL(0x414f0215174d5fcf), LL(0xc237082bf2b529ed)}, {LL(0x65d27ca0dcaeb464), LL(0x911033bd3bdac1d4)},
			{LL(0x9da9cb468d623e9b), LL(0xe060aa089a99c3bd)}, {LL(0xa22d74f480590bde), LL(0x1fcc1311754b65e6)}, {LL(0x875ae82bc3b2167f), LL(0x3e5b2622ea96ca0f)}, {LL(0x7b0f51a6f75ec2a8), LL(0x44ae8746d05817a0)},
			{LL(0x78f2b418ac461bb6), LL(0xd2bd956a2a4dde13)}, {LL(0xb751a09a3af1185c), LL(0x4aa8c5a79105076e)}, {LL(0xf1cd495a1384c0a5), LL(0x1509e771022838f6)}, {LL(0x854defff10a2396b), LL(0xdaf83aab4631446c)},
			{LL(0x28ef6c08648309d3), LL(0x4e6b7326a73b4ab0)}, {LL(0x18e424b99dc007f0), LL(0x3a9890a3dca887d1)}, {LL(0x829e042a2e9abe5d), LL(0x476e105627a95219)}, {LL(0xca67f8837b9fabc8), LL(0xe12066b97677416b)},
			{LL(0x40a5e07f9f45a9c5), LL(0xb087068ea4076e3d)}, {LL(0x4cd7f2c230254bbd), LL(0xadcb4e3eca53ccb4)}, {LL(0xfe42be59e7fcfbc3), LL(0x9e56bded966953cc)}, {LL(0x1af3236d4ed028e4), LL(0xde3b8c2a700f09b2)},
			{LL(0xf027ab309b8c36af), LL(0x67b9e9d4549a7f26)}, {LL(0xada283f7742130b8), LL(0x9493498de10a0edc)}, {LL(0x95f5d790472282cb), LL(0xf6a9da696f40bef2)}, {LL(0x941f35facf2a74c1), LL(0x8419d4cc39f2f922)},
			{LL(0x27609b0b90fb32b5), LL(0xc53429ba337a218a)}, {LL(0x51f73a7a40cde46f), LL(0xee66e8e9dbc4d373)}, {LL(0x61fc72cbb98eea4c), LL(0x9a950b6ca0571e12)}, {LL(0x22a4770a7dd39a97), LL(0xbc011fcefe45b99c)},
			{LL(0x1496360432a0e588), LL(0x27d4d813b2fc2558)}, {LL(0x84a70d9598aacf61), LL(0xa848340e108303bc)}, {LL(0x8374e640a6924857), LL(0x35de1ef3711b15c9)}, {LL(0xe36276e197145411), LL(0xddfb1b3a87fe4c0b)},
			{LL(0xf7f440e5a5b4b199), LL(0xfa2fc32935026953)}, {LL(0x0d98f0d727681472), LL(0x6ffc461538e6e559)}, {LL(0x20b370deaec3b583), LL(0x58a2034752e237ff)}, {LL(0x268a796118f3c4bf), LL(0xb784271f65c8665a)},
			{LL(0xe9296de38e44c755), LL(0x2f9177d2de80bf27)}, {LL(0x385754673303b273), LL(0x623a93e48e4ab02e)}, {LL(0x234e9560f5db6c9d), LL(0xceb1116ba8f7fe4c)}, {LL(0x4aeefb7d86153a81), LL(0x42ed6a66fd799d11)},
			{LL(0x59ab26ac8a8d583f), LL(0xf8af98882e1dae3c)}, {LL(0x9987c52de84260b3), LL(0xebe592d901141c7b)}, {LL(0xf230ace4489c19bb), LL(0x831af55df83df145)}, {LL(0xc99a1d3d208772d6), LL(0x773374958c6288d8)},
			{LL(0xcfa3148296b703ea), LL(0x981550cdbb48d97d)}, {LL(0x8eec169781fa5c25), LL(0x5a2258e649fdf090)}, {LL(0x7480a6a50326f9ce), LL(0xcff1ddda44197c9a)}, {LL(0xeefa8636b07c4063), LL(0xb2075d2fbf18a952)},
			{LL(0x3f84bfb20d3b3545), LL(0xffacb919efd2a65b)}, {LL(0xd3693e506e575a32), LL(0xa908f8bffc6d816a)}, {LL(0xfc55b98d34ecd4d7), LL(0x7af5a1643aceddaf)}, {LL(0x7cdcba73c966459e), LL(0xd938adbbb1c001d5)},
			{LL(0x6bb769c9a0de7908), LL(0x68ff6784f929ed3e)}, {LL(0xf5e3473176a49e8d), LL(0x1e8cdfa099a5e730)}, {LL(0x39bdb60dbb0b4479), LL(0x108a9d41d8f8f7fe)}, {LL(0x249d7eb5cbe3ebab), LL(0x53273b96c96fe839)},
			{LL(0x07d3ebd53e388736), LL(0x9d962afd61981675)}, {LL(0x2cc1626301a357fb), LL(0x45ee4bf73cb69576)}, {LL(0x71444aa4ee0e51ec), LL(0xb6c4ebae8926e48c)}, {LL(0x0ba1f9689158654e), LL(0x80da624d0fccb4fc)},
			{LL(0xb2954c9bd7d9b07e), LL(0x339df3d35c3a9f78)}, {LL(0x777d431b583e20d0), LL(0x59e2cff6be0cb529)}, {LL(0x0e6515697c70cd6c), LL(0xf9ef5439c2f32cea)}, {LL(0x47760baaa17d2ef3), LL(0x2d112c73c59f7848)},
			{LL(0xe8c38f89064c315f), LL(0x5d2179778832f8f7)}, {LL(0xf87bb7e651cc8aff), LL(0x717099b5a1430269)}, {LL(0x7ecbbda71a766a8a), LL(0x3d9bb1321d678fb6)}, {LL(0xb6bb42f0b2f9ee56), LL(0x3818cb02c7b740be)},
			{LL(0xfdbf5be7bce422dd), LL(0x0845afc16c7c9a7f)}, {LL(0x12af3fbb849094b4), LL(0xc8f2fc4b85d674fd)}, {LL(0xd4bad585506fdd04), LL(0x349ed2429df5971f)}, {LL(0x1345ddd10c9862be), LL(0xba42f2eed364332d)},
			{LL(0xe288948b1f1ca21b), LL(0xaf4b159fd14c0bdb)}, {LL(0x168131d0e1b0ca9c), LL(0xc377c49a1e5bab3b)}, {LL(0xdd0c2b391227975e), LL(0x50e7ac863e9ead80)}, {LL(0x8b28fa966cd2f407), LL(0x23176e9284c26886)},
			{LL(0xc02ce38162cf388c), LL(0x134a0a512f09b247)}, {LL(0xe09f935fcc0c8d0f), LL(0x4be809167deb85b8)}, {LL(0x3baab1d9681b6b6d), LL(0xf42981c8745f799d)}, {LL(0xcc5ef13ccdafdaf4), LL(0x0e0642e1415d10ce)},
			{LL(0xd17e3984bd477526), LL(0x4dabe43650ca0f09)}, {LL(0x520adfc41bd53d71), LL(0x7875fac521d11ac0)}, {LL(0x69a06e1d73ce561c), LL(0x8c5c7b0d558e635d)}, {LL(0x7d365819416eb394), LL(0xab88a31ee7724605)},
			{LL(0x05c4ec01ed28a822), LL(0x79353674cd3f9816)}, {LL(0xfa6cb03282dca5eb), LL(0x95d3853c0de48c0a)}, {LL(0x79185672244eedbc), LL(0xa00d9bcf7cff99c3)}, {LL(0x063909bfb630713c), LL(0xef262458372a51a5)},
			{LL(0x37d8a364c77b8915), LL(0xe965c9781a0bdb14)}, {LL(0x90313b91aa0a2ae9), LL(0x8f9cec1da27f26e4)}, {LL(0x6a5d8ba328d68f02), LL(0x1a4f6921af9baaee)}, {LL(0x601690a131861c46), LL(0xe82505c9f6e559c2)},
			{LL(0x7697a171d036d6da), LL(0x2b52c153e8bef2f9)}, {LL(0x88d51f2837ca2d19), LL(0xb5047cbe7ed7a135)}, {LL(0x435805c1c45d70db), LL(0x269414a25e12a78e)}, {LL(0x03fde5be5b18d91e), LL(0x9613122cfa15c9b3)},
			{LL(0x5d8528c7efad0617), LL(0xf32aa059b59071fa)}, {LL(0xdf1b2cedc137b84a), LL(0xb444b00f923923e3)}, {LL(0x01eae26a8808f60a), LL(0x72b00ea556b247d0)}, {LL(0x29058e62ec8bffd9), LL(0x3cdb7d83f1890d60)},
			{LL(0x215992b426cb4389), LL(0x2a120de20450702f)}, {LL(0x0c7212bdaf60e278), LL(0x1d4c48b06e54a289)}, {LL(0xd92225527707c976), LL(0x5b629457a5137246)}, {LL(0xe4b19d34a92cd327), LL(0x406d31c7e6665a7e)},
			{LL(0xbd1abb9823a18b18), LL(0xb8c2a94fc87bf442)}, {LL(0x300b48b1f9430e23), LL(0x74f3e3857b93cd61)}, {LL(0x72b9af1ab51688f2), LL(0x20d7f98273332d3f)}, {LL(0x48f9fca955051595), LL(0xa64e76ef51de1372)},
			{LL(0x9608322e1c3a5bd5), LL(0x60bac84595557741)}, {LL(0x4ec0f516e33564a9), LL(0x496852b766f442d7)}, {LL(0xab9b8a48c2114184), LL(0x7bb56dd5d6205f79)}, {LL(0xfb8652580ad453e1), LL(0xe7638b995b56cbda)},
			{LL(0x5c6fcaad67a5f01d), LL(0x819aaefce322362a)}, {LL(0xf61ea28f2dbc4793), LL(0x889fcd8c63b02e83)}, {LL(0x042e0e6b65205e28), LL(0x0b8538d19b8ddfc6)}, {LL(0x1f37cf6ca3f880c6), LL(0xa70eba5ebd3091a4)},
			{LL(0x53e03dae93ddcb7b), LL(0x0ac5f46077635d10)}, {LL(0x501dd810c8c51265), LL(0x9cd6e64c8d7694a3)}, {LL(0x86b00a414bbae075), LL(0x4ceb2887bc248ddf)}, {LL(0xd8c8c738ff0f3f7c), LL(0x29d29af2f3a13596)},
			{LL(0x91dbd9fb2202dce3), LL(0xfd2ce2b8f4cd6134)}, {LL(0x1b19c107c6d8deee), LL(0xac8b828f26bd4e62)}, {LL(0x5a56c312d1958121), LL(0x6ebc8aa4d408678f)}, {LL(0xaa7168224a19b78e), LL(0x09056370809218a9)},
			{LL(0x469ce9c02975d8f9), LL(0x5fa122d6932d3f98)}, {LL(0x35cfa4b0146ba601), LL(0x0dc6d5f1b6ac5577)}, {LL(0x3c795a0c5623ec5b), LL(0x69bfab3515c76fe8)}, {LL(0x9c43292c056ac891), LL(0x92d0a4adcc2b846d)},
			{LL(0x021707d4d3102f14), LL(0xe4a31c89aca78e63)}, {LL(0x662f991e87b66d7a), LL(0x07032191c1cf0867)}, {LL(0xa6037a9fe57955f6), LL(0x14492bc0eec6ba20)}, {LL(0xf3da4e8ec094efb1), LL(0xf1aafbf8ae8fb695)},
			{LL(0x4d3d10a8b82dbdb7), LL(0xdf7b409b9ce18b64)}, {LL(0xa03a7320534924ca), LL(0xfb6f0f98d9eceb85)}, {LL(0x09b6febc42484a5a), LL(0x64797ec4a36b3a9f)}, {LL(0x73534d703d1e7ef8), LL(0x5267f72725816aef)},
			{LL(0x1edd2d062bf076cc), LL(0xd5beb4fbeb82d674)}, {LL(0x55d9341125edba47), LL(0xe5e3d03840490cb5)}, {LL(0x176bd3ba69b83c96), LL(0xb1c7ca3f48e9eceb)}, {LL(0x64389eca54a6426e), LL(0xe3a03d186d688604)},
			{LL(0x893ffd42bfc2db13), LL(0xc7b4721b2865e6e5)}, {LL(0xbb23b2279591fa24), LL(0x57e48d17ff51a5e7)}, {LL(0xb37faef15fd14674), LL(0x412dfd760a88d8a8)}, {LL(0x5e78cd79b4b5df09), LL(0x6539b2754f85b849)},
			{LL(0x5f922f133cbd2903), LL(0x1789bcd01937ff99)}, {LL(0xb934b5f34681d530), LL(0xb347919e53f62b84)}, {LL(0x085c1cd6ca40bc50), LL(0x16c97061f5d97d4f)}, {LL(0x3e6e5dd88533c34f), LL(0x8d1cb7bcb960e18b)},
			{LL(0xd55037efd8672b0e), LL(0x462edce7cb47d0cf)}, {LL(0xed076388eb64997d), LL(0x24144f03450d60e1)}, {LL(0x986d2747604a96b9), LL(0x99559c7c57a65bab)}, {LL(0x321c4f652a532137), LL(0x9050ff0cd7344302)},
			{LL(0xdce6c9539a2f6154), LL(0x2257a223682cea50)}, {LL(0x3632410e4f737f1f), LL(0x9bd5c7dd4cb99cc4)}, {LL(0xcb8d1ae9f3975dc2), LL(0x9390681c20c506bb)}, {LL(0xe6a69ae07a3cfc33), LL(0xa4ce2d4e4ac1d41d)},
			{LL(0xb8de5799ce89233a), LL(0xc1f79f3b05446c54)}, {LL(0x2f3c87dd5abb8ee5), LL(0xd3fd59dbc6a35cc5)}, {LL(0xa5fe9f21be618ce8), LL(0x825a39ec14d37393)}, {LL(0xbcf059f2aba97d12), LL(0xca72a7ea9ec9b392)},
			{LL(0xc3d1063f39d7e192), LL(0x8559187dd51c7bf4)}, {LL(0xafb58423a7311fac), LL(0x703055044dad80bf)}, {LL(0x6d8e607616ee0834), LL(0x87d943dcce03bc9b)}, {LL(0x62019775e2963352), LL(0x0c8619405a42d7a1)},
			{LL(0x448bee14fa65f7ed), LL(0xbb023e5f3f8ab1fb)}, {LL(0x190ec6d315c8f1fa), LL(0x48289e068a1ac001)}, {LL(0xc23be455b1df1798), LL(0xf7e916d883ae3c24)}, {LL(0x97e2d0449432addf), LL(0x120ac6e0c3e73091)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x0f8ff703f4783b66), LL(0x8b5f5a9c94416b3a)}, {LL(0x8f06f4fd09f2aa2f), LL(0x289256431f4fb740)}, {LL(0x6c64821c9ee6fe3e), LL(0xf5694d7998b1fb4b)}
		}, {
			{LL(0x13dba88557b945c2), LL(0xc67b0bb0b9b03f2a)}, {LL(0x2181537c20c25995), LL(0x36576d1fc21f5664)}, {LL(0x6e420129639373a6), LL(0x9d35f49b939b3891)}, {LL(0x5e9720693d487827), LL(0x4b6ff58b488b0c08)},
			{LL(0xd85975e39466c8e0), LL(0xb586e5486648ca8c)}, {LL(0x461cd14912c49c86), LL(0x20421483c48316a5)}, {LL(0xe6a7170a155ba606), LL(0x915d12e35be3ae75)}, {LL(0xdb70c2e74896355d), LL(0x80cb5049964958d1)},
			{LL(0x9a98d31bd4217a09), LL(0xd9283f7621766644)}, {LL(0x663bef88c7562f78), LL(0x052eab2256228f4b)}, {LL(0xc90d07dfea7f9af4), LL(0x558b89477f47a871)}, {LL(0xf2887f3acc913016), LL(0x2e8762ef91efb96f)},
			{LL(0x8eb7bb2b0debec19), LL(0x66f24f7aeb7a715e)}, {LL(0xd7d45bf7bed047ec), LL(0x543cc14dd04d5566)}, {LL(0xe27a60bb47d88869), LL(0xddb1dc5ed85e1418)}, {LL(0x057b1a0ca7d3c404), LL(0x5fd71c03d30375e7)},
			{LL(0xdc840252c6e5e68f), LL(0xf96a2bf5e5f570e1)}, {LL(0x3c71b850a89d7930), LL(0x02ad90149d14392e)}, {LL(0xa6e96b4b7cbc0339), LL(0xdb85af62bc625f6a)}, {LL(0x42c1a6f84047b2e9), LL(0x6caeda3e473eacc8)},
			{LL(0x73b2ea05ebcc5303), LL(0xa9cf0990cc9057db)}, {LL(0x8c386192244bfbcf), LL(0x408428c54bc52c89)}, {LL(0x6ccddb904a336470), LL(0xbb43932433246546)}, {LL(0x230e89c509624e43), LL(0x10210aa062a00bb3)},
			{LL(0xd186f6ffc5f37e55), LL(0x3ea6684ff34fb2dc)}, {LL(0x27d3fe745be1602c), LL(0x5ccdc41de11db1de)}, {LL(0xf7f365366b42f412), LL(0x71507eec42eccc88)}, {LL(0x4ceae5519fa1d78e), LL(0x9e2f2c85a185fca8)},
			{LL(0x713d30bcc26c44d5), LL(0x8fb96e2f6c2f0a0c)}, {LL(0xa3927147db6fc73d), LL(0x8452b3616f612a8d)}, {LL(0x07f4c0b58e73d3d2), LL(0x79a17bbc73bc2830)}, {LL(0x8a6acc9a5f68c276), LL(0x2a1e81c768c7cb33)},
			{LL(0x1ed95c2854afdd18), LL(0x01b7480aaf0afd17)}, {LL(0xa964455f560a8c35), LL(0x3a3f8b670a67c080)}, {LL(0x76c9f0094c1f9707), LL(0xf61815931f93223c)}, {LL(0xf007a583e53127c0), LL(0x08f105503150e4b8)},
			{LL(0xbabfedda01b3c9f7), LL(0xfc4480d7b3d7ffaa)}, {LL(0x963c4a0b226708b8), LL(0x0ddfae7267726bf3)}, {LL(0x8f11d696f8bb0672), LL(0x75c99dc4bbc4bed4)}, {LL(0x84418f33808ea711), LL(0xd89f777c8e7c9b53)},
			{LL(0x99b1641f08d187b4), LL(0xec658a77d177f419)}, {LL(0xb049d9c28cd682ff), LL(0x4229b8d1d6d115a7)}, {LL(0xfd05512ee627bf1a), LL(0xcf3d46ea27ea2685)}, {LL(0x5a4a57d86fcb5648), LL(0x07833b36cb36b665)},
			{LL(0x61cf2f3d4925fcaa), LL(0x7c8fd09e259ea77b)}, {LL(0x4e653fe8b601c058), LL(0xb8594b3a013aa17f)}, {LL(0xc72644763599ff93), LL(0xa70a7ffc99fcf811)}, {LL(0xb83037632813de21), LL(0xda32e7681368a27d)},
			{LL(0x7bcb04a44f090fdd), LL(0x31d456290929e001)}, {LL(0x78e2b3a093f9f260), LL(0x0499e328f928725c)}, {LL(0x0f8d2e142ab68f0c), LL(0xe1ba2405b6059fea)}, {LL(0xf57cbf8f42e2e3c4), LL(0x57261953e253915f)},
			{LL(0x5dbe976de1b8859a), LL(0x7e22408ab88a9e55)}, {LL(0x4b1e25e411d2045c), LL(0xe78e5739d239d498)}, {LL(0x3721e1f5d0a8d853), LL(0xaffb7aaca8ac1ca9)}, {LL(0x6fe46c9496c399cd), LL(0x8e0e2625c325f71b)},
			{LL(0xdfadb5561a151b32), LL(0xcc279ef415f4e2bc)}, {LL(0x6d6bb62dbf638e1b), LL(0xa878419a639aaacc)}, {LL(0xadb932ee0489a25a), LL(0x76d345da89da7aed)}, {LL(0x188bf1202f8ce4a1), LL(0x6b2de1088c081aad)},
			{LL(0x4d4c88ec6af13de5), LL(0x8d14fe3bf13b3322)}, {LL(0x33fc9644822bf63c), LL(0xe317b4112b11a6c4)}, {LL(0xc25d5e7a924a3b97), LL(0xf8dd63ff4aff8df6)}, {LL(0x1c5686917d0fcace), LL(0x27c12fb50fb5a0c0)},
			{LL(0xe7017ab7e00b4c6d), LL(0x8266c05d0b5d61ff)}, {LL(0x9b3ebea621719062), LL(0xca13edc871c8a9ce)}, {LL(0x5963e0dcb33babf5), LL(0x32ce8e373b372438)}, {LL(0xea038e1ae31dd4b7), LL(0x45aa83e71de7a3c2)},
			{LL(0x3b8578e526eeaae2), LL(0x7b0ceba8eea8111e)}, {LL(0xc0d284c3bbea2c41), LL(0xdeab0440ea40d021)}, {LL(0xfca33c9313775571), LL(0xdc0694547754e90f)}, {LL(0x56eecec8998d24f9), LL(0xd374aa328d32bbd2)},
			{LL(0x31734cfdab8be1ea), LL(0xc561d3ae8baefb13)}, {LL(0x64b43531eef638ae), LL(0x2358cc9df69dd29c)}, {LL(0xdd226fef33b50ce4), LL(0xea51f94bb54bbf6b)}, {LL(0x7944de1d66a9180b), LL(0x17a23196a996bdd6)},
			{LL(0x0879eea1a4c55cde), LL(0x981b5fb9c5b9b7da)}, {LL(0xcc761dd34dac5ef0), LL(0x0a5c9544ac44dd96)}, {LL(0xe153d7bf9b2875d4), LL(0xe8fc695f285f8645)}, {LL(0x09df831c5195b6b5), LL(0x8b208d0795077850)},
			{LL(0x8d9e0c2fd11b11a4), LL(0x53bffa7b1b7be303)}, {LL(0x75e0470d90ef6aba), LL(0xc355a092ef92b061)}, {LL(0xd2af41fb190383e8), LL(0x0bebdd4e034e2081)}, {LL(0xec512312983eed0e), LL(0x2f302ae53ee54478)},
			{LL(0xbb198067f4e3239c), LL(0xef7f5269e3693020)}, {LL(0xac1f5f53f1d94831), LL(0x65e89764d964b567)}, {LL(0xf655088b9e121e79), LL(0x626bac5212520302)}, {LL(0xc3fb33c7671ad1fc), LL(0xebe6b1411a41427c)},
			{LL(0xcf5faad7915ca34d), LL(0x3f1120455c454fcb)}, {LL(0x9d6c13ae5a52a9db), LL(0xa08944ca52ca4e74)}, {LL(0xf9d8269fb4a49175), LL(0x83d18857a4579ce8)}, {LL(0x721487b81e9cb968), LL(0xbaf4db2e9c2e9851)},
			{LL(0x813a953f275d6315), LL(0x87486b7f5d7feeb4)}, {LL(0x127dc538a2e9afa9), LL(0xd540d90ee90ef0a0)}, {LL(0x906ee70359443101), LL(0x6745077044708c49)}, {LL(0x5bec3a659a9bbc23), LL(0x14b8e9889b8879ef)},
			{LL(0x7f1673151d8a21b2), LL(0x7d3898948a945a6c)}, {LL(0x94b390b20bc71f6e), LL(0x2ba9c9cdc7cd3624)}, {LL(0x2faa10d5ff243cf2), LL(0xc4d69ba424a40604)}, {LL(0x4535664dce34613b), LL(0x150fa182348284f8)},
			{LL(0xa74f06f689ece952), LL(0xc8be7ddcecdc90e0)}, {LL(0xedf74eaf6d6e0765), LL(0x3c0bf85b6e5b8bf2)}, {LL(0x29f8bddd8407054b), LL(0xae4c32a607a6e1be)}, {LL(0x36878c4825f83238), LL(0xbcc0a812f812d323)},
			{LL(0xc174e97e4ebac62a), LL(0xcd90d6febafe1fab)}, {LL(0x24fa497087119d91), LL(0x6980711c111c2383)}, {LL(0x028fdab929a017d6), LL(0x267667bfa0bf5dd7)}, {LL(0x5395d4c43e5ee0fd), LL(0x8ca3b6315e31ce35)},
			{LL(0xc68029cbc0c915f8), LL(0xb431ad42c942379b)}, {LL(0xaf36e8572d29b58c), LL(0x50a522652965273a)}, {LL(0x44930bf03b648b50), LL(0x0634733c643c4b72)}, {LL(0x10f21f818b49b87f), LL(0xf336beb149b1ad77)},
			{LL(0xde0bd8ebef45f159), LL(0xdf1c4c4a454a2d36)}, {LL(0x0af634188d654b08), LL(0xbe6d38066506ea0d)}, {LL(0x7eb01ea8e8dacbd9), LL(0x6e034a2ada2a95e6)}, {LL(0x6b391b25c440b7a2), LL(0xc2e2e89840984d76)},
			{LL(0xb532c3ce2b0546fb), LL(0x1dfea4d205d26040)}, {LL(0x1ba24624f37c191c), LL(0x5e6054097c0988f0)}, {LL(0xb2c6037ba5769529), LL(0x645fdf6e766e4870)}, {LL(0x979a27b6d737e2d3), LL(0x1ee47ccc37cca479)},
			{LL(0x04dd77b152832e6f), LL(0x4ceccebd83bdba6d)}, {LL(0x267593c9aeb18a47), LL(0x4ff616a3b1a37e54)}, {LL(0x41e811fc9cb74f54), LL(0x59e36f3fb73f3e95)}, {LL(0xc8ab6a621f2f709f), LL(0x46b05bf92ff967fb)},
			{LL(0x62e6983995d50117), LL(0x49c2659fd59f3526)}, {LL(0x483792e0cd22f9e1), LL(0xd2c3e238223846c5)}, {LL(0x6340f5846085eb7c), LL(0x5af9b7218521faac)}, {LL(0xb61b74caf7f5bb46), LL(0x28b311d3f5d3f21d)},
			{LL(0x9347500785b4ccbc), LL(0x5208b271b4711e14)}, {LL(0x6512588c1ba6d2c5), LL(0x30631e23a6231d16)}, {LL(0xcb82dd66c3df8d22), LL(0x73fdeef8dff8f5a6)}, {LL(0x709b5d01373caebe), LL(0x9c82bc913c91c586)},
			{LL(0x5233b979cb0e0a96), LL(0x9f98648f0e8f01bf)}, {LL(0x809cf882d20d897e), LL(0x9473b9c10dc1213e)}, {LL(0x8bcca127aa38281d), LL(0x39255379387904b9)}, {LL(0x0652ad087b2339b9), LL(0x6a9aa9022302e7ba)},
			{LL(0x2b776764ada7129d), LL(0x883a5519a719bc69)}, {LL(0x1706df34053a6bad), LL(0x8a97c50d3a0d8547)}, {LL(0x776f9db4b94f7d6c), LL(0xe523c72d4f2dedb6)}, {LL(0x35ae3b4cf908cf85), LL(0x898d1d130813417e)},
			{LL(0x74462ab065bf80d1), LL(0xd06e722cbf2c7feb)}, {LL(0xf87e4b2241f47b1e), LL(0x90ea5ae9f4e95362)}, {LL(0x1df0eb2c885f20a5), LL(0x34fafd0b5f0b6f4a)}, {LL(0x3efe62e9813d6ee6), LL(0x24dbf7ab3dab64f9)},
			{LL(0xc40ff372e969022e), LL(0x9247cafd69fd6a4c)}, {LL(0x38accfe1fa1e575f), LL(0x4e415ea91ea98343)}, {LL(0xe88c54a3cabdc361), LL(0x63dce458bd58fe15)}, {LL(0xd3092c46ec536983), LL(0x18d00ff053f0ef0b)},
			{LL(0x55c779cc457dd944), LL(0xe6391f337d33298f)}, {LL(0x0ca49910f64672b1), LL(0xd4f7910446040db7)}, {LL(0xa466b1f2551c14ef), LL(0xfdf3c8dd1cdd02bd)}, {LL(0x4367cb45b5175882), LL(0x7f95088017806342)},
			{LL(0xdad6af5abdc6df36), LL(0x93f082f7c6f7975b)}, {LL(0xfb57fc269d0486a3), LL(0xa5a7efe804e8c13f)}, {LL(0xf4dad232b7b209af), LL(0x441dcbedb2ed5ed5)}, {LL(0xaa4df25b8afa7188), LL(0x0f723e66fa6652dd)},
			{LL(0x3a231558d3be4089), LL(0x68373916be16de94)}, {LL(0x7c3fc411c17adc0f), LL(0x48752d957a95c831)}, {LL(0x6810ac2118b04a1f), LL(0xf7af5d99b099df2b)}, {LL(0xb3606ec650267f42), LL(0x77640dd026d087fa)},
			{LL(0x2ad10ad958f7f8f6), LL(0x9b0187a7f7a773e3)}, {LL(0x981709a2fd816ddf), LL(0xff5e58c981c93b93)}, {LL(0xd55b814e9770503a), LL(0x724aa6f270f208b1)}, {LL(0x60694280bc7516c1), LL(0x6fb40220752068f1)},
			{LL(0x22a8e478fc32a428), LL(0x031ad81e321ec439)}, {LL(0x5c18fad014e86ff1), LL(0x6d199234e83451df)}, {LL(0x89437b9e83983fcb), LL(0x1f5334c698c6596e)}, {LL(0x5748a3756cddce92), LL(0xc04f788cdd8c7458)},
			{LL(0xd672364a4b80ad87), LL(0x470713f380f39aec)}, {LL(0xae9085ead8795fe7), LL(0x439ef0db79dbe8b0)}, {LL(0xd0209b4230a3943e), LL(0x2d9dbaf1a3f17d56)}, {LL(0x255c24cd724177fa), LL(0x7abba3a241a2ec09)},
			{LL(0x9fe3c91773f2be0d), LL(0x86ff2375f27513a3)}, {LL(0xd4fdecf36220ba51), LL(0x6171744c204cc73b)}, {LL(0x7a6d6919ba59e5b6), LL(0x22ef849759972f8b)}, {LL(0x1589058d2c9a7c7b), LL(0xace1a2b29ab2d890)},
			{LL(0x69b6c19cede0a074), LL(0xe4948f27e02710a1)}, {LL(0x404e7c4169e7a53f), LL(0x4ad8bd81e781f11f)}, {LL(0x54611471b02d332f), LL(0xf502cd8d2d8de605)}, {LL(0xf32e128739c1da7d), LL(0x3dbcb051c15176e5)},
			{LL(0xe58ea00ec9ab5bbb), LL(0xa410a7e2abe23c28)}, {LL(0xca24b0db368f6749), LL(0x60c63c468f463a2c)}, {LL(0x511a0e7d17fef72b), LL(0xaad5d18efe8e93e2)}, {LL(0x2e0c7d680a74d699), LL(0xd7ed491a741ac98e)},
			{LL(0xe3dc0d06b2886202), LL(0xce8a0ee088e0db92)}, {LL(0x4ab84859e482ee37), LL(0xf4b5858782871b12)}, {LL(0xef78941644ce10b3), LL(0x1a7d9fe4cee4d625)}, {LL(0x1f7f3195a1ff3773), LL(0x128c9ab4ffb4329d)},
			{LL(0x7d99a9ac342a3664), LL(0x5b4eff2b2a2b07bb)}, {LL(0xeba5e3a7164d3edc), LL(0x569151594d596c48)}, {LL(0xeedef9abb19efad8), LL(0x09464d5a9e5a19af)}, {LL(0x6a9f769831105dc9), LL(0xd1d93a26102682fc)},
			{LL(0xf1a1c83e1061cdab), LL(0x1bcad7ee61ee2b32)}, {LL(0x4fc3525543512a33), LL(0xab62998451846ef5)}, {LL(0x01a66dbdf550ea6b), LL(0x133bd2be50becf8a)}, {LL(0xff8a8b97cf87a8cc), LL(0xe94b215587557b52)},
			{LL(0xb494ae73de55ac90), LL(0x0ec5766c556cafca)}, {LL(0xe428cdb33cfbb1d0), LL(0xb72b755cfb5cf3a2)}, {LL(0x876838375c7e5aac), LL(0xedd2c27d7e7d090e)}, {LL(0xe0f5ba026e789fbf), LL(0xfbc7bbe178e149cf)},
			{LL(0x0d02f4ad031698da), LL(0xc7cc43ba16bac23d)}, {LL(0xfe2ce62a3ad742a7), LL(0xfa70f3ebd7ebb4d8)}, {LL(0xa8c228e2a35a665e), LL(0x290459d95ad90f0a)}, {LL(0xbe629a6b5330e798), LL(0xb0a84e6a306a45c7)},
			{LL(0x85e7e28e75de4d7a), LL(0xcba4a5c2dec254d9)}, {LL(0x679d82353206c513), LL(0x1615799c069c40c1)}, {LL(0x91c88abeac14db6a), LL(0x747ed5ce14ce43c3)}, {LL(0x50bc63c0e2ae1d40), LL(0xb9ee0330ae305c68)},
			{LL(0x8213223bfbad9ea8), LL(0xb205de7ead7e7ce9)}, {LL(0x3dd7d5ed5dcd935b), LL(0x119642aacdaaf6a4)}, {LL(0xa11dabfef2cfd0eb), LL(0xa224d4decfde775a)}, {LL(0x9e45a4aa86a25466), LL(0x95c4f1cba2cbdc29)},
			{LL(0xa2341cfa2e3f2d56), LL(0x976961df3fdfe507)}, {LL(0x30d521405edb0b81), LL(0xd65a0110db103499)}, {LL(0x1a042b99062cf377), LL(0x4d5b86b72cb7477a)}, {LL(0x325afbf9777b1c57), LL(0xf02c66af7baf694e)},
			{LL(0xbced40d27a90f04e), LL(0x96de29d590d51810)}, {LL(0x3f580f54746d848d), LL(0x37e025156d15ab73)}, {LL(0x9cca7e13af0243b0), LL(0xb3b29674027481fe)}, {LL(0xbfc4f7d6a6600df3), LL(0xa3939cd460d48a4d)},
			{LL(0xb1efb47f79866894), LL(0x51126a6f866fda2d)}, {LL(0x285ed0607157ef20), LL(0xbd77e01857182e34)}, {LL(0x2d25ca6cd6842b24), LL(0xe2a0fc1b841b5bd3)}, {LL(0x92e13dba70e426d7), LL(0x413360cfe4cfd19e)},
			{LL(0x1154723c7e195214), LL(0xe00d6c0f190f62fd)}, {LL(0x58c58d61466b419e), LL(0x21f55c896b89ebb2)}, {LL(0x9515fd0ffe97f505), LL(0x38921b739773f9ae)}, {LL(0x16a0b289f06a81c6), LL(0x99ac17b36ab34acd)},
			{LL(0x47babcf4e79476ed), LL(0x3379c63d943dd92f)}, {LL(0xfaf1919b68546cc8), LL(0xb69c3d5654560eb5)}, {LL(0xcdd0706eb8fcb49b), LL(0x196747fafcfa121c)}, {LL(0x0329b704dcf0fdbd), LL(0x354db501f001925d)},
			{LL(0xa5c0dc4fa04cfe84), LL(0xeec81a634c63cd37)}, {LL(0x83b54f860efd74c3), LL(0xa13e0cc0fdc0b363)}, {LL(0x192d9c9ddadc0eca), LL(0x781633b6dcb6d527)}, {LL(0x4991ff5d3872138a), LL(0xc1f830867286894f)},
			{LL(0x390aa25c0f4ebd34), LL(0x5d7a8c174e174cc9)}, {LL(0xcef9c76a640c4926), LL(0x2c2af2fb0cfb8041)}, {LL(0x142f6830d9ca9610), LL(0xbfda700cca0c171a)}, {LL(0xbd4b2d6f8fc01a25), LL(0x85e5fb6bc06bd79a)},
			{LL(0xabeb9fe67faa9be3), LL(0x1c49ecd8aad89d57)}, {LL(0x0b5059a57835a163), LL(0xad56eab835b82587)}, {LL(0xe92a391e3fed290a), LL(0x70e736e6ede6319f)}, {LL(0x2c83a7d123d4c14f), LL(0xf19b2ea5d4a59459)},
			{LL(0xd9ff185e6136228b), LL(0xa6bd37f636f60506)}, {LL(0x86ce558aa92eb0c7), LL(0xfee910c32ec3c684)}, {LL(0x0e2b43a9dfe66567), LL(0xf281f6bbe6bb5060)}, {LL(0xb7bd197702a5512d), LL(0x3b88c36da56d3d97)},
			{LL(0x20273ec1d592b3fe), LL(0x256cbfa192a199ee)}, {LL(0xc5a99ecf1c39e845), LL(0x817c18433943a5c6)}, {LL(0x88e5162376c8d5a0), LL(0x0c68e678c87896e4)}, {LL(0xa0bbc643079f3a80), LL(0xb11f06609f60b8d0)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xb9965adedd43344a), LL(0xc90935d643d66df7)}, {LL(0x340856f10c5825ee), LL(0x9ab6cfad58ad8ef4)}, {LL(0x5f314dd4c818924c), LL(0x585427351835c382)}
		}, {
			{LL(0x223b6375937fdaab), LL(0xda0922c284a640b7)}, {LL(0xe1f51bc1a6f4d9bb), LL(0xd9dde19524c5a254)}, {LL(0xe703af84020e3c83), LL(0x3c08e7a657b03622)}, {LL(0xd060c4ed40038c0d), LL(0x8cc3d02772a20fca)},
			{LL(0x269fbbb2ead3dd3a), LL(0xdd2e26e067411952)}, {LL(0x2ab0103861e4d44a), LL(0xd4472a8681abf2be)}, {LL(0x9839a98d2ecaf2e8), LL(0xf2b898065fc7648b)}, {LL(0xa88540e04716d6eb), LL(0xd6dfa85d41e94ebd)},
			{LL(0x27b68df365f8ac8f), LL(0xac5727092f089efa)}, {LL(0xb1f2e3761d53b5be), LL(0xb574b17806b7dc0e)}, {LL(0xf009cb1a0e2ab40f), LL(0xb438f0f4669682ee)}, {LL(0x1f8117d3febf866d), LL(0x867e1f16342b06c5)},
			{LL(0xa00e33adb58dd80a), LL(0xd891a01944e4fcb4)}, {LL(0xd5ed2a6bb684fa29), LL(0xfa9dd5ecd90cd187)}, {LL(0xb3a08ff4c0055717), LL(0x5786b3699625119d)}, {LL(0x512ecef6348c1db0), LL(0x1dd051046a3bf9f2)},
			{LL(0x0d069dcb041c78c5), LL(0x78100d8faea36c44)}, {LL(0x4a0b01e2b39f9c4c), LL(0x9c894a30bdf7a6d2)}, {LL(0x6dbd8c11d66730c3), LL(0x30de6d3992ff3828)}, {LL(0x012936418f2b71b5), LL(0x717901e9484987a8)},
			{LL(0x4cfdb5a717657974), LL(0x795c4c03ce8232a4)}, {LL(0x54a32070c20b6b94), LL(0x6b8e54cfc19527bf)}, {LL(0x13aebc5975888f1d), LL(0x8f171370d2c1ed29)}, {LL(0x1558081cd1726a25), LL(0x6ac21543a1b4795f)},
			{LL(0x0ad91fcf2fcdec48), LL(0xecbc0a55959f7f9a)}, {LL(0x3ec12e653fbdcfda), LL(0xcffc3e2c68560c49)}, {LL(0x4eafd925ca339bdd), LL(0x9bae4e125e10ff37)}, {LL(0x88ec4f17093feee9), LL(0xee24888e55ddc399)},
			{LL(0xb850a67a60e3caea), LL(0xca43b8d54bf3e9af)}, {LL(0x3c9342e7e2eb2d73), LL(0x2d0e3c3df8c4c1da)}, {LL(0xa583dd2b430aae2e), LL(0xaecfa5d2ef4a22f9)}, {LL(0x8b9715d45b427df5), LL(0x7daf8b768d0689a2)},
			{LL(0x25e4e171b8ae4e26), LL(0x4ea52518bf9a5369)}, {LL(0x9ecf1dc88a3017d0), LL(0x176d9e352cb2f0fd)}, {LL(0x1dd37b5123e964c4), LL(0x648c1d07a4b9cb56)}, {LL(0xeb2c040e893935f3), LL(0x3561ebc0b15addce)},
			{LL(0xbcf47ebd194fcd7b), LL(0xcd64bcf7a814b04a)}, {LL(0x5adee778946a804d), LL(0x80155ab8b7ed01c0)}, {LL(0xdab9db226fce6045), LL(0x607fda72e73d7050)}, {LL(0x02526c82dd56e2a9), LL(0xe2f202119092cd93)},
			{LL(0xa9ac76a1c83da75e), LL(0xa7a6a9b409a0c915)}, {LL(0x1ea821927194f7d8), LL(0xf7071eff7c62816d)}, {LL(0xecf3860aa2e8a17e), LL(0xa1cdec1a8a66ce10)}, {LL(0xfbf9e294aecc29f2), LL(0x29fdfb48bb407adc)},
			{LL(0x14713e5d5e591b90), LL(0x1bbb14aae9fdfef7)}, {LL(0x7c415cca7eb95d77), LL(0x5d3b7c58d0ac1892)}, {LL(0x79ccb24c883e2b53), LL(0x2b6579937b02c6df)}, {LL(0x48596d606ec97ee5), LL(0x7e7b48212d656b41)},
			{LL(0x1a0cf9550838f049), LL(0xf0201add9f85d888)}, {LL(0x94160207a5fdfb98), LL(0xfbd19460b92d8f67)}, {LL(0xf37291d95c572713), LL(0x27b3f30cbe4dc8d5)}, {LL(0xba02caf8bdb52843), LL(0x28b1bac4db61243c)},
			{LL(0x5e7a3fbfedc687dc), LL(0x87325e9a540a5825)}, {LL(0x2d6f923c4a3540c7), LL(0x40eb2d5cba97e160)}, {LL(0x92e0b64201071ea0), LL(0x1e049253ca581b11)}, {LL(0x9db4470bd84d84cc), LL(0x84e69dcdf469bac6)},
			{LL(0x831c6699a9d97314), LL(0x73e18332880b3bab)}, {LL(0x691954d6afcb3752), LL(0x37f9691b711861cd)}, {LL(0xb5563bb164ffb22f), LL(0xb253b55ae55085eb)}, {LL(0xfad0d4d521e75847), LL(0x5884faa1f309fd74)},
			{LL(0xf25ba798d37c56a6), LL(0x56caf2e5f6044f7d)}, {LL(0xb979903befc8bb5f), LL(0xbb3ab93c03ba6e07)}, {LL(0x28e27cbabcb236e3), LL(0x36b5289711393f2d)}, {LL(0xd149f2accf28fdb8), LL(0xfdbad1ce3aeb8862)},
			{LL(0xe28e4102f4894aa7), LL(0x4a56e26dfc1ee86f)}, {LL(0x5d01657cbfbb14c0), LL(0x14b95d628cd1121e)}, {LL(0x75e319c603092223), LL(0x220c75f59de82d33)}, {LL(0xe551c306df58de2a), LL(0xdefae5b7c722fbb1)},
			{LL(0xef88dcc9f0953262), LL(0x3246efe252bd842b)}, {LL(0xdc4f6f67cb34857d), LL(0x85aadc419448e426)}, {LL(0x96446e8578ab1931), LL(0x1923967129bf42f4)}, {LL(0x8691881f5f5e0530), LL(0x05bf86f923a5e5e6)},
			{LL(0x4dd483e6984e08c1), LL(0x08254dea86cbb50c)}, {LL(0x455ff0ab6ad50620), LL(0x066b45ae83c60705)}, {LL(0x77b17544de5fc08a), LL(0xc0fe77e40d7ae0a0)}, {LL(0xeea1ea887fbe43d7), LL(0x433fee0b1af40383)},
			{LL(0x56f14cf21f5d893d), LL(0x897c56de5107ea2c)}, {LL(0xa12705ec3aa6a9bf), LL(0xa9e8a1f00cad7b1c)}, {LL(0x3dba74a66dc05cc6), LL(0x5c773dd4b08d4672)}, {LL(0x2c46a47dc51e3172), LL(0x31922cb5f2de66c8)},
			{LL(0x2e14c8ff1848d3db), LL(0xd3602ea4624cab5b)}, {LL(0x93c980038e2c6f15), LL(0x6f7d93ba82119cb9)}, {LL(0x84c3e49d8208e799), LL(0xe74d84e8b3372875)}, {LL(0x3a65f6a24611c84b), LL(0xc8db3a0e8bb155ac)},
			{LL(0xc6439632c30c7534), LL(0x758ac69c0bcd3cae)}, {LL(0xcfe1d33ebebc0a60), LL(0x0abdcf314689090f)}, {LL(0x341831aa10702392), LL(0x23403479fdc973d3)}, {LL(0x5255943566f18eac), LL(0x8e5b52fcb2e0b3c9)},
			{LL(0x2f3dfebe9763a26e), LL(0xa2192f4d2a052cf3)}, {LL(0x823550d826f202a1), LL(0x029882dbc042bc03)}, {LL(0xc76aa0734c270481), LL(0x04f3c7754384bb06)}, {LL(0x364a5d28cd26c13b), LL(0xc1b236686d5bbe40)},
			{LL(0x537ca274e9daff19), LL(0xff225315faa93461)}, {LL(0x588c8bfa493c62e4), LL(0x62e758a9277fcc53)}, {LL(0x85ead2dc0d23962c), LL(0x96348501fb7eafdd)}, {LL(0x814e0a1b748f91bd), LL(0x911381231899f638)},
			{LL(0x3195df2ce6f755b6), LL(0x551e31b25667ad9e)}, {LL(0xae73f4a5e3ec33d3), LL(0x330aae6e329cdacb)}, {LL(0x6830629720e046e7), LL(0x468068f23951e665)}, {LL(0xa4aaeb6acc21df9b), LL(0xdfb6a43ba703a551)},
			{LL(0x170a649e0c24888c), LL(0x883017523126b4cc)}, {LL(0x40d21e2d9c527004), LL(0x703540652868d948)}, {LL(0xb7045733b9a95086), LL(0x50a1b74b75c24878)}, {LL(0xe8575ecddb44a6ef), LL(0xa6eae838698197f5)},
			{LL(0xa6f887e811773d32), LL(0x3d44a62a379168c2)}, {LL(0xb0dbd5379278c40b), LL(0xc40db0914efe5ba6)}, {LL(0xf4ad13dd7786b39e), LL(0xb31ff4d68571db0b)}, {LL(0xd7bf46e96bd21880), LL(0x186fd7fd499e1c14)},
			{LL(0x037b5ac3527d931c), LL(0x938b03f8d8db4a3b)}, {LL(0x41fb286c137901b1), LL(0x014c418c60215ee0)}, {LL(0xde1d03e5166267d4), LL(0x6758de5004da29b5)}, {LL(0xac2198273ebad17a), LL(0xd1f8ac7fa20e1758)},
			{LL(0xf9ab8e16739acb5b), LL(0xcb0ff9592bd2b74f)}, {LL(0xa25c5f2f68db3aa3), LL(0x3a63a208d4763127)}, {LL(0x4b2237a33cb4edf9), LL(0xedf04bd9f5be217a)}, {LL(0xb62d617236822133), LL(0x21d8b6a23d8bcfd0)},
			{LL(0x4f86ef644518ea68), LL(0xead74ffb1659789f)}, {LL(0x74ca2f878c225396), LL(0x5375741cd5a1aa9b)}, {LL(0xea05324f06124446), LL(0x4418ea29f9135a66)}, {LL(0x20690ff74e293802), LL(0x38fb20d314348d24)},
			{LL(0x2b992679eecfa5ff), LL(0xa53e2b6fc9e27516)}, {LL(0x4476c6eae5fe7795), LL(0x77124447cb8f80ad)}, {LL(0x8f33cd1322ee7a64), LL(0x7a888f546ee1d047)}, {LL(0x8abe2395d4690c40), LL(0x0cd68a9fc54f0e0a)},
			{LL(0x9a6bc50ff39c1041), LL(0x104a9a17cf55a918)}, {LL(0xa375696ee7f04b16), LL(0x4b1aa3e19c3fb68f)}, {LL(0xe0dc2d8029dfa80e), LL(0xa8a4e07c6c8c25fc)}, {LL(0xc19c1436e8dde1b9), LL(0xe126c14630f12f70)},
			{LL(0x0bf0298ea0e69dfd), LL(0x9dc50bbcddd6f832)}, {LL(0x3fe81824b096be6f), LL(0xbe853fc5201f8be1)}, {LL(0x04a4d8c779ac0791), LL(0x07270422e3e759e5)}, {LL(0xc2e74ef5baa072a5), LL(0x72adc2bee82a654b)},
			{LL(0xad08ae66b191a0cf), LL(0xa081ad96ea4790f0)}, {LL(0x29cb4afb33994756), LL(0x47cc297e5970b885)}, {LL(0xf120fd5b8101c5ba), LL(0xc541f11d2edf0546)}, {LL(0xdf3435a499491661), LL(0x1621dfb94c93ae1d)},
			{LL(0x43a944eece2fe318), LL(0xe3be439df0b39373)}, {LL(0x09a2450c7db07f54), LL(0x7f3709ad4d4435a1)}, {LL(0x676493def9aadc8b), LL(0xdc62676c076047b2)}, {LL(0x664da59f7681ad3e), LL(0xad1b66854f29c01a)},
			{LL(0xe97e688c546fd75a), LL(0xd793e9d121c8105d)}, {LL(0xbddd48fc9664bcce), LL(0xbc1dbd1ee05d37e2)}, {LL(0xabfe1a23156b45f7), LL(0x4554aba599320486)}, {LL(0xbea6123fc4192fd2), LL(0x2f96bee638867dd9)},
			{LL(0xf7d6491e25fb2082), LL(0x2094f72e5daa9130)}, {LL(0x6192279b5d5039b3), LL(0x39b7615f7415d3c4)}, {LL(0x11fcd0dba8de6db4), LL(0x6de51161425320ba)}, {LL(0xfe740c12584b5fd6), LL(0x5fa3fe8310eea491)},
			{LL(0x088b734df29b0ee1), LL(0x0e4e0844050db209)}, {LL(0x7d686a8bf1922cc2), LL(0x2c427db198e59f3a)}, {LL(0x99109fcca1e1835d), LL(0x83c199ef178ee323)}, {LL(0x7b9edece5568c9fa), LL(0xc9977b82eb900b4c)},
			{LL(0xd232a86f9d556ea4), LL(0x6e31d236e230c259)}, {LL(0x33c7b3ae3ba1b71f), LL(0xb7ec33a3c6f5600d)}, {LL(0xc0b5227767f6900c), LL(0x905fc0af78b8a8d8)}, {LL(0x10d5e69a27f51c01), LL(0x1c9c10880a1aa712)},
			{LL(0x953f34462ad68a2d), LL(0x8aa89589f16408cf)}, {LL(0xbf8f247e4b325e67), LL(0x5eefbf0f70cffa71)}, {LL(0x38379a209b472ae2), LL(0x2a29381f1b23983f)}, {LL(0x90b2dac0dc51fc09), LL(0xfcf690425acad682)},
			{LL(0x391eac61146c5b57), LL(0x5b5039f6536a1f97)}, {LL(0xd31b9e2e127e1f11), LL(0x1f48d3dfaa7945f1)}, {LL(0x214039b6c10249b7), LL(0x4982213a5c7d0a8c)}, {LL(0x6ec6d6d2841aa3df), LL(0xa3556ec14a247213)},
			{LL(0x6fefe0930b31d26a), LL(0xd22c6f28026df5bb)}, {LL(0x24cdd73037853f93), LL(0x3fdc24f1f7d3d4c1)}, {LL(0x058dee86f6877624), LL(0x765e05cbabaede4d)}, {LL(0xfc266090851dbd7f), LL(0xbd51fc92807c6902)},
			{LL(0xaf5ac2e46cc74266), LL(0x4273af877ad55d63)}, {LL(0x3b4cc0e3c93ab9fe), LL(0xb9a23be7c3f8d204)}, {LL(0x706ef740f58e5407), LL(0x5452703e3646f37e)}, {LL(0xca6c3db8483b7c44), LL(0x7ce3cafaed27d742)},
			{LL(0x769843055174b13f), LL(0xb187760d45336708)}, {LL(0x5bf7d1391b41f1f8), LL(0xf16c5b51ffa48668)}, {LL(0x60bb11dad27b4806), LL(0x48ce60b63c5c546c)}, {LL(0xfd0f56d10a36ccca), LL(0xcc28fd7bc835eeaa)},
			{LL(0x428072af410492ad), LL(0x92c74274b8fa14db)}, {LL(0xf584259cf8adc22b), LL(0xc266f53fcd385ca3)}, {LL(0x723c9bc228d8b6ae), LL(0xb6a0722fa6d43eed)}, {LL(0x6536ff5c24fc3e22), LL(0x3e90657d97f28a21)},
			{LL(0x162352df830ff939), LL(0xf94916bb796f3364)}, {LL(0x7e133048a3efbfde), LL(0xbfc97e49403ed501)}, {LL(0x231255341c54ab1e), LL(0xab70232bccefc71f)}, {LL(0x12878a18faa3fea8), LL(0xfe6e12999a886a81)},
			{LL(0xc917677b1a46ef58), LL(0xef68c90235fc9d79)}, {LL(0x57d87ab39076f888), LL(0xf8055737194e6d84)}, {LL(0xb47f0df0ebd4c39a), LL(0xc32ab4b3ad190243)}, {LL(0x5f5309fe62edf669), LL(0xf64b5f731c43df8d)},
			{LL(0xc538ccf19171e628), LL(0xe601c564d3167695)}, {LL(0x9fe62b89051b6665), LL(0x66149fdc64fb7755)}, {LL(0xcec8e57f31977bd5), LL(0x7bc4ced80ec08ea7)}, {LL(0xcc9a89fdecc1997c), LL(0x9936ccc99e524334)},
			{LL(0x919bec81537a8dbc), LL(0x8d8f91ab1283512a)}, {LL(0x06f6b445a4fae538), LL(0xe5d5063373759476)}, {LL(0x7ab7e88fda43b84f), LL(0xb8ee7a6ba3d98ce4)}, {LL(0x185e95d7d56e12e0), LL(0x12d218cc0f17151b)},
			{LL(0x353107eb9f5b5227), LL(0x52393590b580f47b)}, {LL(0x6c94ba50594c4176), LL(0x41a76cd0dab6bf80)}, {LL(0x8c4897d07093e978), LL(0xe9038cacb63a9a7c)}, {LL(0x470d9c29b783e489), LL(0xe49947bf1354ca96)},
			{LL(0x07df82042bd1948d), LL(0x94ac07da3b3c13de)}, {LL(0x62e97d580f2daaaf), LL(0xaa3c62a7acce99ff)}, {LL(0xe478f5475073af9f), LL(0xaf83e45e8f6b7c19)}, {LL(0x976d58c4f7806884), LL(0x685a979861f6c55c)},
			{LL(0x78e5840d07155ae6), LL(0x5a1c787a334b4177)}, {LL(0xcb450bf9c7100df1), LL(0x0d9acb13a56e50ea)}, {LL(0xff5d3a53d7602e63), LL(0x2edaff6a58a72339)}, {LL(0x59a5bdbbc6171351), LL(0x139e59406f364bfb)},
			{LL(0xdd665926441ff4c8), LL(0xf4d3dda8dc01638e)}, {LL(0x30bce96d69dc2403), LL(0x2467305b1e2e2a36)}, {LL(0xc83e513a956d9eed), LL(0x9e11c8eb7db51ad1)}, {LL(0x0c2fab8a8b370970), LL(0x09690c66e6eaebec)},
			{LL(0x4624aa6838a8953c), LL(0x95e046565b1d4d3e)}, {LL(0x37636b69420db08e), LL(0xb0cb3781251239e8)}, {LL(0x0e7dc7085661ebd9), LL(0xeb9b0e777678267f)}, {LL(0xc3ce78b4358b0310), LL(0x03d4c357a063e2e3)},
			{LL(0x63c04b198006db1a), LL(0xdb45634ee4871e57)}, {LL(0xc411fab01e5a979d), LL(0x9778c48d9b5ff13d)}, {LL(0xf882b857fcb1baee), LL(0xba76f8b0639b30e7)}, {LL(0xeddab04b2dc3d0cb), LL(0xd0b4edf3c22f49b8)},
			{LL(0x641fc91dabd74f97), LL(0x4fe96494dfbb0d89)}, {LL(0xcdb3bfbc63eae8c9), LL(0xe84fcd20d61bc49c)}, {LL(0x9c9d714a5766f579), LL(0xf59f9c24bc203d6e)}, {LL(0x7147c1017aa525b2), LL(0x252b71d77e0f74d6)},
			{LL(0xd69670a8e4f96935), LL(0x6916d61401d79bbc)}, {LL(0x0f54f149d94a9a6c), LL(0x9ae20f9e3e31a1d7)}, {LL(0xd4c41c2a39af8b9c), LL(0x8be4d4059145562f)}, {LL(0x7315ad83a7f3c71b), LL(0xc7d973c6ee9db945)},
			{LL(0x5007f8b7bba76c05), LL(0x6ca950ed22727e5a)}, {LL(0x49705b21e1e20f50), LL(0x0f0249c8652cece9)}, {LL(0xdb90ed63e0e511f0), LL(0x1106db9baf74f7f8)}, {LL(0x8e1afb52adc50bd1), LL(0x0bf18ebd26a857ef)},
			{LL(0xe3a777437ba23b12), LL(0x3b2fe384b4576fc7)}, {LL(0xa7d1b1a99e5c4c87), LL(0x4c3da7c37fd8ef6a)}, {LL(0x80673c5afba4e008), LL(0xe06a80ca50d07190)}, {LL(0xd9c281e13db3f359), LL(0xf3f4d98a3fe63a6b)},
			{LL(0x1b25cf14871381fc), LL(0x81591b34d7cc5f20)}, {LL(0x558a16314d201a21), LL(0x1af7552689dca017)}, {LL(0x87b8be5ed0757485), LL(0x74c687106bec624e)}, {LL(0x1977a3965a456355), LL(0x63ab1925475e92b3)},
			{LL(0x6a620e15fdb6a44e), LL(0xa4726ae3a9c32bf6)}, {LL(0xd8ebb7a0b29882ec), LL(0x828dd86377afbdc3)}, {LL(0x6b4b3854729dd5fb), LL(0xd50b6b0ae18aac5e)}, {LL(0xe62a99c58d254d36), LL(0x4d71e64f1ff9b18a)},
			{LL(0x5c28533d30906575), LL(0x65c05c8bc49895b6)}, {LL(0xf6ff7f5faad05137), LL(0x51edf6c715e31698)}, {LL(0x89c5795686149f5c), LL(0x9f5d89671d944431)}, {LL(0xbb2bfcb9329e59f6), LL(0x59c8bb2d9328a394)},
			{LL(0x9b42f34e7cb761f4), LL(0x61339bfe871c2eb0)}, {LL(0x8d61a191ffb898cd), LL(0x987a8d45fe731dd4)}, {LL(0x7f3a06092cc4ce6b), LL(0xceb07fa0087752a9)}, {LL(0xb289b9b54f2e26a2), LL(0x26ffb280de6c9635)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x32ee85efb48ac6aa), LL(0xc695324a8ebce7a5)}, {LL(0x1cfa4d10acc21571), LL(0x15f51ceeecf04cfe)}, {LL(0xaad72c629a403442), LL(0x342daa4cd17b832e)}
		}, {
			{LL(0x4a428169d2d95247), LL(0x7c4730a95d53e74e)}, {LL(0x9712df2e5c31dbe9), LL(0x1ce9980b15833f34)}, {LL(0xbcca12254abe268f), LL(0x8c8ff77fe958f887)}, {LL(0xe139052a54a14a4e), LL(0x2e4e953bd351b68d)},
			{LL(0x78d2b6da77924503), LL(0x9c037af1f5c1dc2d)}, {LL(0x2ea1efcc5b4f7ccf), LL(0x7fcfa419ceb49188)}, {LL(0x23ce9dee1f0dd70c), LL(0x350c2b425282f6b4)}, {LL(0xb8c13ab6afff33ba), LL(0x3fbad564be950165)},
			{LL(0x95f6cb86cff03012), LL(0xa41289e7df04a245)}, {LL(0xf903f5c64fe434f0), LL(0x02f05961e2bae584)}, {LL(0xb2337efb35bcf22b), LL(0x222b80beda4bad13)}, {LL(0x6a1a027bf694fa2c), LL(0xad2ce371a0f42352)},
			{LL(0xdc22541326691d32), LL(0x3c3241d42d7277a3)}, {LL(0x3e8d4fc54988281b), LL(0xf61b2c755106f386)}, {LL(0xe04b0f7efc20ded2), LL(0x72d27c4db6f31954)}, {LL(0x833557b4abb79a08), LL(0x2608327cddfca4d8)},
			{LL(0xbb57244a94bf4cdd), LL(0xdbdd2dfe11b033cd)}, {LL(0xdbbf627cf8687760), LL(0x6b609b55d59abce9)}, {LL(0x4e49a9fa37984772), LL(0xcf7212b20a9e1eac)}, {LL(0xed247d5cb8627511), LL(0x3811f3162ac57e68)},
			{LL(0xf067af77eee78a06), LL(0xfb06f42129417b5a)}, {LL(0x5c811d5bb69ef85d), LL(0xfe5d8b325fabe1d3)}, {LL(0x3c695b6dda49c3e0), LL(0x4ee03d999b816ef7)}, {LL(0x17b19666ccc63e86), LL(0xde8652ed675aa944)},
			{LL(0x7dab941d3a52c4aa), LL(0x73aab19cc7ae8a16)}, {LL(0xd43404f62feb3758), LL(0x995805e2832b46a4)}, {LL(0xe92f55cf5d236024), LL(0x8b24d10d7d08878a)}, {LL(0xebcb4167cee28bdf), LL(0x33dfc0e1b78f1afb)},
			{LL(0x70c4e63f7e106f69), LL(0x39693ec75b98ed2a)}, {LL(0xcd7cfe4e9c2fdd7a), LL(0xe97a20ced762ba74)}, {LL(0x03961efc3b407f67), LL(0xe467f89aaf2532a8)}, {LL(0x1fa7c683c54414ec), LL(0x7bec16dbc9039843)},
			{LL(0x8cbe313e7c34da30), LL(0xd430accb8b4d5e95)}, {LL(0x081650e509822a6a), LL(0xa56a4436ae593107)}, {LL(0x7352f8c34550100e), LL(0xdd0ec65df4bddf82)}, {LL(0xeab94b3366631f43), LL(0x6f432997d22db522)},
			{LL(0x4254d18cdb5b782d), LL(0xd92d749ff30ad649)}, {LL(0x13babef529872bb3), LL(0x6db370f6309750a6)}, {LL(0x9c9291376ef38ee4), LL(0x5de424a714ff3c9b)}, {LL(0x1948fab8b3c4ea22), LL(0x7022252c5449fcd0)},
			{LL(0x55e547ea179d46ab), LL(0x07ab267294507f0d)}, {LL(0x873e7f274ef68f3d), LL(0x953d10678a315d3a)}, {LL(0x2c45fb64c88e9734), LL(0xc734b5f504330cf9)}, {LL(0x22bc97bab78c4390), LL(0x6990c2343720596d)},
			{LL(0xfa95eb3a74a44b97), LL(0xe697a1fb4d9fd72c)}, {LL(0x6b68082f5e156eb0), LL(0xf1b00a07c5568c8b)}, {LL(0xb4dc42c0433c0ce5), LL(0x29e5b3494701c980)}, {LL(0xc2f798c44bac9d42), LL(0x1b42be7981d34039)},
			{LL(0xb5ae4894ebbd9879), LL(0x75795a3f22a36659)}, {LL(0x75bdc4f833d0eec0), LL(0xd6c0f5aa69f7bb11)}, {LL(0x465ff91f3e1a6d18), LL(0x6a185684a4c72fab)}, {LL(0x698c1c87cdd4854b), LL(0x494b1beb0fd111fa)},
			{LL(0x212a89468ccc3cf7), LL(0x8df73aae98056bc5)}, {LL(0xe85d5f9bf5a2f4b8), LL(0xd7b8387b18aa2853)}, {LL(0x5e6509f3255f13a6), LL(0x46a69ade952c7ca2)}, {LL(0xfc7ad7010224b559), LL(0xed59920cd0d5b3bf)},
			{LL(0x7b44a8264cd23a64), LL(0x7864826b5ae4ee85)}, {LL(0x7cd99e4992d35036), LL(0x2f3658eaa20c25cf)}, {LL(0xcb93c275eaaf23b4), LL(0xe2b413394a28dee7)}, {LL(0xcf98eae60fee3681), LL(0x518131221de52705)},
			{LL(0xab7b844386781809), LL(0x5209a5928e0251c3)}, {LL(0x9de09b63c6721a78), LL(0x0178cdd1715d9342)}, {LL(0x37e91574e88b96ed), LL(0x0fed81359afd6d58)}, {LL(0x0c1d7876ecc33f5f), LL(0x165f662df994c8e5)},
			{LL(0x637e58ca579744da), LL(0x54da4e316b0fbd8c)}, {LL(0xd5460ea2876aa3c4), LL(0xc5c4ec94e689e97d)}, {LL(0xe2af1bd66fe13529), LL(0xca296da17c748425)}, {LL(0xa582e89df97accad), LL(0xfcadd253bd110457)},
			{LL(0xd8297c80c3280807), LL(0x8f0763cf7abf8e41)}, {LL(0xb74a5c3c787c7382), LL(0xcd824bd3e824fb28)}, {LL(0x6cf53e40801404e2), LL(0xa6e2d0863dbe47c1)}, {LL(0xa4f0e2c951fb5831), LL(0xa0313b25d8b3ab8e)},
			{LL(0x1d43d22b5685ff17), LL(0xc317073703840532)}, {LL(0x79a0bc8edf13d19f), LL(0xc09f9387906373f4)}, {LL(0xfbe7e16edc25df0b), LL(0xba0b488d283d78f5)}, {LL(0x350d01dc7b4a7d16), LL(0xb71690d9507af029)},
			{LL(0x45c9e7e3055a127f), LL(0x8e7fae1e0be21d03)}, {LL(0x3106294f9e0b6823), LL(0x0423b2c207b709cb)}, {LL(0x20588312244da86b), LL(0xd16bd3d8fda7c41c)}, {LL(0x057922c74dc081a9), LL(0xefa9cb6d326f563b)},
			{LL(0x1c31d87ffe046b8b), LL(0x9f8bee416626aaeb)}, {LL(0xb34174af9d3d66b7), LL(0x7eb769c8bfe902ca)}, {LL(0xbdb81871e23fb213), LL(0xd0131e098cfa575e)}, {LL(0xe6a433458aa0201c), LL(0x791c4fba2bb97dc7)},
			{LL(0x02e414a893c1ebfb), LL(0xb8fb11ecca879d71)}, {LL(0x8b230751a235b062), LL(0x8362764a73a595df)}, {LL(0xa99f90eb15b9f3f2), LL(0xeaf2b47e4485ccb2)}, {LL(0x7759d050a011053b), LL(0x6e3be446a3702660)},
			{LL(0xf115a52346661e9a), LL(0xa79a1d574ce3d483)}, {LL(0x9660d57af4b04f75), LL(0x4075717d702190ed)}, {LL(0xefc069f42ba39eea), LL(0x80eae2fae042e319)}, {LL(0xb0d76a53a67d19d0), LL(0x9ad0915210cc3062)},
			{LL(0x9a7dad0c1873702a), LL(0x562a175089b55808)}, {LL(0x0af2444d9a43c191), LL(0x1d9155da64deac76)}, {LL(0x509c652d5a5dc702), LL(0xe802ed1fa63f2936)}, {LL(0x620c529eff16d046), LL(0x0846a7470ead1255)},
			{LL(0x762bda04089091a7), LL(0x32a70d30c6d289b9)}, {LL(0x9319f7bdb970cedc), LL(0xafdcba10424ec6d6)}, {LL(0x91fde3152ab12527), LL(0x1727abfc88c95ba7)}, {LL(0xeeb263a083220a76), LL(0xdc760b8c85e04cc0)},
			{LL(0x0ef96cde7f02d4a4), LL(0xaea477c133135594)}, {LL(0xa614f661c23ab3ca), LL(0x18ca2ac9123436ff)}, {LL(0xd2db38cd596bc996), LL(0x929636151e612237)}, {LL(0x1ed5ccd76dc58070), LL(0x2770ffadaca1379a)},
			{LL(0xf7fa991830e6e054), LL(0xac542ea0d1a9b010)}, {LL(0x1427889af78641e1), LL(0x3ae1aa77c87f9bec)}, {LL(0x80a3494890f7e56f), LL(0xc26fcae672d99670)}, {LL(0x27c5b57dfa4cc239), LL(0x86390959054f0f56)},
			{LL(0xf46c87e40ba69f33), LL(0x4833d63a7e8c82b8)}, {LL(0x4b308b3d7a58c6db), LL(0x20dbd9df38f14897)}, {LL(0xae02a684cbb899a0), LL(0xbda06effbc6d07f8)}, {LL(0x8a510d050ab424fe), LL(0xdffe9f3c16073a06)},
			{LL(0x3bf46d020448a9b2), LL(0x19b2e7186369a5bd)}, {LL(0xc56aaeab95adf710), LL(0x4c1064f8793b8b73)}, {LL(0x369b1f20400a0271), LL(0x53716843ff5fc281)}, {LL(0x3fff4591e109bc87), LL(0xaa87c50334a45c5f)},
			{LL(0x040b2893e5411535), LL(0xb335221b57cdf9e2)}, {LL(0x0f8b668ad7834038), LL(0xf2389eb756b1fa4d)}, {LL(0x079d366fde016a52), LL(0x5752da81f8e8cb4a)}, {LL(0x530a7bd1611db865), LL(0x0c651585091a1b9e)},
			{LL(0xc3859290e32d09de), LL(0x47de570fe471efe0)}, {LL(0x9484c1d26771a48e), LL(0xf88e6091baa60d9c)}, {LL(0x2d37f130600f03a8), LL(0x9ba85c836191a320)}, {LL(0xf283bbdf7d2661fd), LL(0x43fde5cde3c6e62b)},
			{LL(0x3a866756acc93d2e), LL(0x452e0e6e06cb0a64)}, {LL(0x284ed3f72dcf8201), LL(0x740197ee53fef51b)}, {LL(0x7a36a272e453aef8), LL(0x24f86b1d3f46415c)}, {LL(0xc418a4ff3d2c638c), LL(0x108c8d8e1c9924aa)},
			{LL(0x908fe9418230b1bb), LL(0x4bbb428aed6bf47e)}, {LL(0x391079aa97894249), LL(0xa149f6f4a9ee38cc)}, {LL(0x329037b3a54b1744), LL(0xe0444a58a8923b63)}, {LL(0x3074231b368afcbf), LL(0x58bf5bb46215a612)},
			{LL(0x67757059b2d651ef), LL(0xe7ef6c2a3cc2446e)}, {LL(0xdacd682850e9e3fc), LL(0x37fc7223b0381330)}, {LL(0x5f1703a78dde873a), LL(0x1a3a73a8f08ed37b)}, {LL(0x4326dbd873daecb1), LL(0x85b19de996a87990)},
			{LL(0x52787185c99c2cf9), LL(0x50f9fcf36cb8b447)}, {LL(0x89c713f931f45b99), LL(0x3b9967a6b92208ae)}, {LL(0x33e23de70dca83d8), LL(0xbcd8a32ecd3094ba)}, {LL(0xdec640bbb5a8f6c9), LL(0x84c95038e7f5ead2)},
			{LL(0xf3f1b18bd5a7f561), LL(0x1f610cbb866449f2)}, {LL(0xaf70acd063390d3c), LL(0xe13c8789d9cfa821)}, {LL(0x4cadbd52a459ac89), LL(0x7789035ec01983dd)}, {LL(0x5b1c2b34689f920f), LL(0xa90f51b3a7432a99)},
			{LL(0x74cfceac9b517a5c), LL(0x8a5c1cdc0c5514c8)}, {LL(0x183af0ec1b457ebe), LL(0x2cbecc5a31eb5309)}, {LL(0x2521a1d5698d29c2), LL(0x3ec218b5cfc89227)}, {LL(0xfd08dd55aaa521c5), LL(0xb1c57b7ab5771c66)},
			{LL(0x64e36ea589962e88), LL(0x038894b093e776c6)}, {LL(0x864c7573e6771ba1), LL(0xc9a1f911ef93f2e3)}, {LL(0xceeae0b2a76fa21d), LL(0x0d1dd854784788dc)}, {LL(0xad94b878f0f8e6c7), LL(0x59c7966513483550)},
			{LL(0xf871ff92e765a06c), LL(0x5e6cb01787184a5d)}, {LL(0x6f6320bcbb547b85), LL(0x4285281c929b7569)}, {LL(0x293cd9a3854e169d), LL(0x289d7e98365c5ac2)}, {LL(0xc805dc89d1ef5cd3), LL(0x06d3eba3e50dec4f)},
			{LL(0x9899b9a48bb29bd1), LL(0xeed106bc4332c579)}, {LL(0xb6385668d0fde71e), LL(0x911ea2a58d8654f1)}, {LL(0xffecc9fd3964ca3e), LL(0x093e6a967ff08117)}, {LL(0x472df34b969bf984), LL(0x3684bff2c1658072)},
			{LL(0x12c8b4a18106bf2f), LL(0x312f99805535ff7f)}, {LL(0x155582ce5f07d57d), LL(0x667d4301addd3435)}, {LL(0xbe2e068dd97fcd74), LL(0x3474e69323df65f6)}, {LL(0xba252e1e3c3ed841), LL(0x8741c48874129c14)},
			{LL(0x57015342845cad50), LL(0xbf50379e5ed7e27c)}, {LL(0x619a4c62c456af21), LL(0xec215fdda18820fd)}, {LL(0xdfb44aef1d296255), LL(0xd855b94e8257450b)}, {LL(0xe44027ed1961cbe7), LL(0xc1e75e56e13ee0b6)},
			{LL(0x7e3d8ae10112bbcd), LL(0x97cd4906688bb8be)}, {LL(0x0b804e1932c2550d), LL(0x410dbcac017c03af)}, {LL(0x3d1b513972c8577c), LL(0x127cd4effe23c12e)}, {LL(0x54974dbebf1cd237), LL(0x5b37cf04f1f2d0d4)},
			{LL(0x16c39c326447aa1a), LL(0x821abb9b02f8069d)}, {LL(0xfe9ec3a991e55ea2), LL(0x55a283e01a522ece)}, {LL(0xf51e8db0a3270baf), LL(0x14af3f4c1b2e2d61)}, {LL(0x09645ab1a103bef6), LL(0xf9f6ad40cbfb9ede)},
			{LL(0xbf5c0cd971fe59e8), LL(0x68e80fe5467dca2f)}, {LL(0x6d8734142895907e), LL(0xfa7e39f0581ce818)}, {LL(0x2453ab81c10cbd5e), LL(0x625ef1c3aa6a3dfe)}, {LL(0x2aaac75fbe0e69fa), LL(0xccfa86029979686a)},
			{LL(0xe3dd1182c760a1b5), LL(0x96b584d719d62bfc)}, {LL(0x7220f297edd18492), LL(0x81922f2b911f705b)}, {LL(0xa766fc356abb2756), LL(0x4456c3bf77969926)}, {LL(0xd14d2631622bb6f1), LL(0x76f1ce8fb144109f)},
			{LL(0xa0fbca5ab4ba4d04), LL(0x1304193e8f7e526c)}, {LL(0xa8ed9abfbd38676e), LL(0xb66e5d082127636b)}, {LL(0x26b7bf2952cd56a5), LL(0xdaa5e02f60eda08f)}, {LL(0xcc0ef41a34ae49e6), LL(0xb5e6c9b8b2c015ad)},
			{LL(0xf688934c986774c8), LL(0xf0c8c7d6b40b1fc9)}, {LL(0xe5322db9b1e05f7b), LL(0x9d7bb720849c4f6f)}, {LL(0x66077a0d1a57c573), LL(0xbb73855c5960ebb7)}, {LL(0x7f4f80b5a9932f51), LL(0xcb51a0700d291767)},
			{LL(0xaa098e172ef98c95), LL(0x0e954ce4eba0fe1a)}, {LL(0x2bd8cd0b168ffd66), LL(0x90666f74fcdbc7b3)}, {LL(0x40b0c524489a93d6), LL(0x61d66573398d4b38)}, {LL(0xace6b22c5879725b), LL(0x055b7f1376ea9a89)},
			{LL(0x44bbedb7addb86e3), LL(0xd2e347686e40b2da)}, {LL(0xa36dd4a68ffa3263), LL(0xf763e1a4205b60c4)}, {LL(0xd95b76d46ba99c9b), LL(0xd39b8ab91f1d2198)}, {LL(0x60e846366cd73bbd), LL(0xb0bdb6abc42a8f24)},
			{LL(0xc6fcb057aeed8877), LL(0xa8779c62d61eb9db)}, {LL(0xec56770810e3e18d), LL(0x648d1a604f67d1b1)}, {LL(0x48a695c14118b9bc), LL(0xc4bc214597d47a3f)}, {LL(0x81d1431c387671f3), LL(0x9ef32390177b39a9)},
			{LL(0x59f83f9cfb5e79f4), LL(0x11f4405f6dc4b7e8)}, {LL(0xb9b330e2077ea726), LL(0x63263c12db37aebc)}, {LL(0x102ca00912c754d4), LL(0x89d4886c9fb2620e)}, {LL(0xe7d639112221b480), LL(0x2580a6cc4e1bd21e)},
			{LL(0x5a6e2160c01e0693), LL(0xf593b8c5c2e18540)}, {LL(0x9b0fa758b0f2e4b6), LL(0x0ab6fe26ec17f7d1)}, {LL(0x4ddfb7060cd83815), LL(0x2b15ea28a5bb2c04)}, {LL(0x567359162cdd39cc), LL(0xe3ccdee83b754da5)},
			{LL(0x8dcc3b6ad4b54eac), LL(0x88ac45bdeeeff14c)}, {LL(0x5df3170f1e1f6cc1), LL(0xa2c162443a094e0a)}, {LL(0x4f3ba3ae9f19d3ee), LL(0x93eefbc46f3cb175)}, {LL(0xdd505e478ee889ae), LL(0x60aea8a248d0d87a)},
			{LL(0x01720a54a881949c), LL(0x5c9ce97665a2afd9)}, {LL(0x1bacee10200501d9), LL(0xc8d934c09ece61a1)}, {LL(0xd6d0105ebc2adca3), LL(0x21a3140e49acdbd5)}, {LL(0xc161863870ece225), LL(0xff2546e32ef67291)},
			{LL(0xc78eba03066c1ceb), LL(0xf4eb7514b3bc1602)}, {LL(0x926bfde911f15a40), LL(0xf340536627ec690f)}, {LL(0x115eaa5dba46c048), LL(0xd548611afa10cdd7)}, {LL(0xd03f2c65caaa226d), LL(0x2a6d27f9d4e6bf46)},
			{LL(0xcae1c821422eb728), LL(0xbe28fa4f2f8a713e)}, {LL(0xa21fdef2277ba6ff), LL(0xabff08d245f9cf1d)}, {LL(0xd3a93299f1ea5d0a), LL(0xce0adf637bc38dee)}, {LL(0xc977d6dd796ec84f), LL(0x5a4f02d580af4396)},
			{LL(0x6e112ae813d5ef19), LL(0x1e19c16af739dab0)}, {LL(0x2fd3e598f3cee853), LL(0x23534d6fab163e51)}, {LL(0x71b6ec6bd691fbf5), LL(0x65f5d7b13e3a42f3)}, {LL(0xc0138c6cd86d76b9), LL(0xa3b9af954b54dd48)},
			{LL(0x8e5a2596eff531cb), LL(0x6ccbbd2741cac3e4)}, {LL(0x1adee44488849545), LL(0x9445ddb6fb6cce78)}, {LL(0x8f282fc24774a557), LL(0x3057545124686c3d)}, {LL(0x68fe16d3655511d7), LL(0x15d7f29d6a73be23)},
			{LL(0x588a35c853dfed68), LL(0x4d68a92908661831)}, {LL(0xb1a560070efc8d4c), LL(0xc64c7824756e9fbb)}, {LL(0x49d49f95e9992d20), LL(0x9820c833f276d5e6)}, {LL(0x41c2cf70e01b074a), LL(0x3d4a8c055c2fe4e1)},
			{LL(0x88b519ad9975cf05), LL(0x67058ed0dc80a777)}, {LL(0x85da6b8fdd3764c6), LL(0x2dc6018b40b6c04b)}, {LL(0x659164f12117ba14), LL(0x5f147dc6f645d91f)}, {LL(0x51ee6f79f2dc539e), LL(0xb49e0469c39d86ef)},
			{LL(0x386273fe3f08d6d5), LL(0xfdd51f82cc4c9715)}, {LL(0x99ebb3f023330f4d), LL(0xb24defca26906aa0)}, {LL(0x06ef3c3b7680fece), LL(0x0bce33f79d4a6493)}, {LL(0x84a861db75b6f05a), LL(0x715ae8fd25146f92)},
			{LL(0xd7a21a0a14ab483f), LL(0x7d3ffd782c0e740c)}, {LL(0x347f0b88d3cbe98a), LL(0xeb8a79af35d85ff0)}, {LL(0x9f048fcb55b3f183), LL(0xb983dc3dbbda0e33)}, {LL(0x0d6f72224442abc3), LL(0x4ac38f5b9c36673c)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0x82475de003360e94), LL(0x7a94db0ab85e0b01)}, {LL(0x9e76859ffd32651f), LL(0xe51f354bde78a1ea)}, {LL(0xa189c00e1c3bd998), LL(0x4f98f048eadcfdb5)}
		}, {
			{LL(0x3b59ba4fc2860ecc), LL(0xcdf011538279efe3)}, {LL(0xf5b62a6c95949603), LL(0x5bbd918337e7ba9c)}, {LL(0x03d211f9a6abb117), LL(0x69ad925890c98ec3)}, {LL(0x60bf6596274482a5), LL(0xbe84685128596eda)},
			{LL(0x9fa029a9e0ac34d4), LL(0x505113c1f94d7689)}, {LL(0xb0685f4086d27afc), LL(0x347115b474111e37)}, {LL(0x39c5a4e106f5d0d6), LL(0x83874c8262f71b61)}, {LL(0x8563bfc35dce2b76), LL(0xd0075495134478dc)},
			{LL(0xb60f7d710947dbd2), LL(0xe6e8f2049740c172)}, {LL(0xf29f070a78d95820), LL(0xaefeb9baa4f11f98)}, {LL(0x097b77aaf4d79165), LL(0xdcc5784b763a2c0c)}, {LL(0x8198835c16285442), LL(0x4ce9eef4109b531b)},
			{LL(0x0e525acc199a5f46), LL(0x29865072e52c8908)}, {LL(0xede9a2a8ec8557bb), LL(0x959c8b063d60404b)}, {LL(0xa002af7969cc452c), LL(0x014fb8f378ebb2ad)}, {LL(0x2e8679be04a62125), LL(0x43fac9fcfd1b12ff)},
			{LL(0x066722318f95a12e), LL(0xd299e7b0e351df45)}, {LL(0x0be7690430a44f7f), LL(0x92b2259a96b4d88e)}, {LL(0xbde8147539e394ad), LL(0x745ad79e01f419fc)}, {LL(0x29af54d8e9ebef06), LL(0xb6b9e1c56e0db7fb)},
			{LL(0xfd835291039b686b), LL(0xa0a22641319aecd1)}, {LL(0xa3d0be80cf67f43b), LL(0x68e22aabe8223c6e)}, {LL(0xae50f5b570561a6a), LL(0x28c9e8819dc73ba5)}, {LL(0x5834ce2043693d7e), LL(0x1ad9eb5a3ae90ffa)},
			{LL(0xd9ac4d7c5541693c), LL(0x563005ae2a725ce1)}, {LL(0xc1f3c5b82c50a884), LL(0x98111f2b20f5a636)}, {LL(0xaf1efae2128e7567), LL(0x0f132708ed8041e4)}, {LL(0xeca7adff8e5d38b6), LL(0xb246448f4d273a0a)},
			{LL(0x5001b6ddd566c316), LL(0xe1c65c983c9459b7)}, {LL(0x936e6dcb3d45b588), LL(0x37a01e62fcef0b03)}, {LL(0x83049df2d25b8a58), LL(0x029eb325f015a799)}, {LL(0x9795515476a3cabc), LL(0xab4ea403ff3020c4)},
			{LL(0xe492d5021852c6de), LL(0x4959f34d4b5a6c47)}, {LL(0xcfa19f7435caf7c2), LL(0xb1974f59c5d92f3e)}, {LL(0xd3052b2f073d494e), LL(0xe358efbdcc81fe2e)}, {LL(0x2c1a6710c0d5ff3f), LL(0x0d8d942d1d95e67d)},
			{LL(0xf4f8253bf74cf90e), LL(0x7c675e0a47a0c0dd)}, {LL(0xde85601ab80ca71f), LL(0xa3732d97b964f9e5)}, {LL(0xb91328ea7205eb99), LL(0xe8b46dff022b323b)}, {LL(0x529da87311151d0c), LL(0xafb10149dc1aad35)},
			{LL(0xaccceb1bb425c470), LL(0x66beb5507d49cf27)}, {LL(0xa837d784ffc3bb44), LL(0xfa500f317e96e4e0)}, {LL(0xf3d1085d1a01372d), LL(0x89247633d4b665d9)}, {LL(0xf9786e0e487d175f), LL(0x3c4c9c203245c716)},
			{LL(0x719b9af8aa82d278), LL(0xac600a9f54e4b801)}, {LL(0x412549b358a093cb), LL(0xf3223e5640298f6c)}, {LL(0xcc738e8d936146d5), LL(0xd83add015510a1fd)}, {LL(0x597ac17721b15273), LL(0x3d0324d34aae75bb)},
			{LL(0x0cce4462dde9815c), LL(0x67f10da305a27d8a)}, {LL(0x160dd208608b9efe), LL(0xe7a74af7efab73df)}, {LL(0x72498b010c29636f), LL(0xc5cd98c7c42d36c2)}, {LL(0x029c1eaec473de1a), LL(0x4e775dd1e08ef482)},
			{LL(0x7a7cf3fc9a269d07), LL(0x3ed22f05c250608f)}, {LL(0x6fa3300d5c06b2ee), LL(0xb0d8f7aabd329d93)}, {LL(0xe069e99d53b4b9ea), LL(0xd5b7492c48854780)}, {LL(0xb49363dfcd3405c8), LL(0xa89fafd577ce35f0)},
			{LL(0x1ca4b45b32f7be8c), LL(0x52cfa0e40958d110)}, {LL(0x191187931bc9aeb5), LL(0xe9fbd50c7ac08096)}, {LL(0x566694ec5af36238), LL(0x335fbb28dfc586f2)}, {LL(0xd0d73ad6a196f859), LL(0x8af57de55c4870ed)},
			{LL(0x5be6dfd9e5c28c69), LL(0x73747902aa208139)}, {LL(0x79aee2053c8d2c10), LL(0x577fbd5d5299ee4c)}, {LL(0xe2f5f73397c767f0), LL(0x9bc014fda80bb302)}, {LL(0x4910314eceaf6da3), LL(0x083d89944654d921)},
			{LL(0x8e84d6c76d6a6409), LL(0x42b5710f85f0a052)}, {LL(0x014e0f5762d86f0d), LL(0x27dacf8970477a41)}, {LL(0xe3bbf864f51f08fd), LL(0xbc1adb74d84cc943)}, {LL(0x514fb98ab7beac1b), LL(0xc61c93114cd323f6)},
			{LL(0x88e3f4f6e2ffc527), LL(0x902c96bf66a17f17)}, {LL(0x4f77137f413acc8d), LL(0xdaa46e24a5050664)}, {LL(0x44907a7b719e83f2), LL(0x48164bbe33b1deea)}, {LL(0x91f27365f9366b92), LL(0x79d743b31c61ff81)},
			{LL(0xd42c0649ea70876d), LL(0x161bc7845f975b2a)}, {LL(0x5f1de346ae24f35d), LL(0xef9ac363a9ffaafe)}, {LL(0xb1265017e40a15f1), LL(0x13abda3d04566476)}, {LL(0xa14ca02e0b142a21), LL(0x2695777a08acc8ec)},
			{LL(0xf14d16f3de72e937), LL(0xc7532be23438915b)}, {LL(0x27fd0e14f071b040), LL(0x9f3fb1b78b213ef3)}, {LL(0xbac13913d4ae5a8e), LL(0x8119ffa792e2bcf8)}, {LL(0x460c64d5b5ed5de8), LL(0x0661166fd33f2a68)},
			{LL(0x1491cca6a4f840e4), LL(0xa9d017260f25875d)}, {LL(0xc9c6bd45ba5f56ec), LL(0x630ea8e92688f07b)}, {LL(0xc36fdb16e823769e), LL(0xd66642fac07b52b4)}, {LL(0x650a565e0e7a929c), LL(0x05b01db95bc13f5c)},
			{LL(0x43b9571d9cd34dd1), LL(0xbd556387a0a77bee)}, {LL(0xe127e6ca316cd6e7), LL(0xf26d86a538c23dc1)}, {LL(0x185f88c47911c1b8), LL(0xce211a850a87fad7)}, {LL(0x55b48515fc58d32f), LL(0x5af229704f0c0831)},
			{LL(0x3d3e987e4d13afe2), LL(0x1f69f6e3612830a6)}, {LL(0x350be083db1c518a), LL(0xe4764121675566eb)}, {LL(0x6a1603c57538a2d7), LL(0x0bec8242ceaacc15)}, {LL(0x4ac220b76804dcb4), LL(0x61901bccd69d57e2)},
			{LL(0x7c1bd1cd15b33c29), LL(0xec4bc8b52101bfca)}, {LL(0x8c18c869a919ba13), LL(0x0cc22cde657e54d0)}, {LL(0xeac08fce01c89998), LL(0x60dfa33fae76e54f)}, {LL(0x4e391c2823e2a380), LL(0xfd7ea1add5427c25)},
			{LL(0x95094ffab2d014a6), LL(0xe539f9d21fbed446)}, {LL(0x730784566ef10c62), LL(0xe217574eb46a4c83)}, {LL(0x30bed34bf22241b3), LL(0x5f4234c914cd376d)}, {LL(0xaaabc92a3bb0655e), LL(0xb42752e09e181062)},
			{LL(0x0aa96653527c2072), LL(0xb568ea13e6f3a2cf)}, {LL(0xd24b247865e52643), LL(0xc4822034bcc6846f)}, {LL(0x04fb3c9f4be67f34), LL(0x9ceeba6103df2bc7)}, {LL(0x57289bbb382b0d35), LL(0x148574a1af82fcb3)},
			{LL(0xf83661592aa57852), LL(0x1b9653a94202bd57)}, {LL(0xdb3053d29132b726), LL(0x1847587fcafca863)}, {LL(0xad82e44cd6fdab7d), LL(0x41647ad90d0eb566)}, {LL(0xbf740adbfd904ab7), LL(0x3a2d8a4fe17aed7e)},
			{LL(0x7b32fcabf8fef20a), LL(0x1908e08cb2171ace)}, {LL(0xfbe470a08c0ec945), LL(0x723bc1f1d2cb3394)}, {LL(0x1deabb0c502fd181), LL(0x75156f6d791fab51)}, {LL(0x219a2c257fe4116e), LL(0x4da656076870e1b6)},
			{LL(0xabe5c67d59680a53), LL(0x93fd9d69ee5f6a23)}, {LL(0x5ccff2bf088f424a), LL(0x8637513b3936243d)}, {LL(0x22483ddcd94fa079), LL(0x240bc45ff8b96f75)}, {LL(0x2d546847a20d9032), LL(0x2a575ba46dd29c3c)},
			{LL(0x86b1ae3afb659a61), LL(0xb9aac6cd838df61f)}, {LL(0xca14acbc1cf4e7fb), LL(0x0aa33ab1b6417eb8)}, {LL(0x05b533c8293e1039), LL(0xbb3475e873985186)}, {LL(0x69c4123cd39313c0), LL(0x6241101a5e6342d6)},
			{LL(0x99c70b986f3995fa), LL(0x82c8f4711a1ca9cc)}, {LL(0x76b2b79e47cf1c5b), LL(0x592322a6c7f21d05)}, {LL(0x336cc2b25489f0a4), LL(0x36efa6918404b9ae)}, {LL(0xbe3a058c9f4825ba), LL(0x1df745c6913d973f)},
			{LL(0x6b580c9217e0cdda), LL(0x2c364dcbbeedb654)}, {LL(0x7560a667e164ad4c), LL(0x308eb0fe573b93c6)}, {LL(0xdc197eb47c7f7905), LL(0xed04704659ea0d67)}, {LL(0x9c723850460785c3), LL(0x39fc81996984f84a)},
			{LL(0xf00319a4bcaa863a), LL(0xe089e46b447feb1a)}, {LL(0xe85c9160c5bb4782), LL(0x2ea8feee4ef811cd)}, {LL(0xa4f993e6222a3a18), LL(0x9da102927b34996a)}, {LL(0xe740c4fbbef977c9), LL(0x20f46115db93e284)},
			{LL(0x083578fd960ffe68), LL(0xfb1fb7c2067d564d)}, {LL(0xcb5aa3eb7e2c88f6), LL(0x2d79f538c60604f9)}, {LL(0x20d423721d3c7e63), LL(0x6a7c998e18379bf7)}, {LL(0x3445efd4b9c43e87), LL(0xc3ac8ea817121caa)},
			{LL(0xa979d8d39d1bd449), LL(0xdd8ac0b80ed19ea1)}, {LL(0xa29eb1d7adbf9b36), LL(0x4f38e5229865462f)}, {LL(0x644459096ca2fd91), LL(0x226ad2302b86451d)}, {LL(0x4deb0dd185491297), LL(0x94d333f5458bf2e6)},
			{LL(0x7e87cf63d1c0e233), LL(0xa23c9564c18f4b48)}, {LL(0xdd5771e31ea71608), LL(0xcadebfcf29ad7726)}, {LL(0xfe514368a530d97c), LL(0xc90fb419a1536212)}, {LL(0xa6658d48e659e402), LL(0xd3d65f439bba6de8)},
			{LL(0xd6b018e72e035977), LL(0x586c9a55bf19afa8)}, {LL(0x9220629c5f9dda85), LL(0x107ad1eb8ca87142)}, {LL(0xfccd5dc661430766), LL(0x8778e9c841dd9690)}, {LL(0x742ea93083bcc241), LL(0x17547f77277ce987)},
			{LL(0x8b31e50f44547430), LL(0xf98104e7f668f1d4)}, {LL(0x688a1d6bb14b7ccd), LL(0x459bdf932e243897)}, {LL(0x106af039ef1e3fd0), LL(0x353ead470cfaac9a)}, {LL(0x9eee26fe82745bd9), LL(0x778bdc48890a0cc8)},
			{LL(0x3222cde536519fa9), LL(0x11356918f443c3ef)}, {LL(0xc794e789a3c509aa), LL(0x4a88f89bc3a47973)}, {LL(0xb5dd6c88afec6ac5), LL(0x8f45605c07894fb1)}, {LL(0xd562091e88a8e860), LL(0x31c1080d2fd0216b)},
			{LL(0x3fa286d0896071f8), LL(0x511eab3281a6c424)}, {LL(0x8fcad9900fb20b04), LL(0x656fbe86f5b7da13)}, {LL(0x3797fe2d1f6f8f90), LL(0xaa011cf087db9269)}, {LL(0xb2f441ee42a1a4e6), LL(0x7a064865949feab5)},
			{LL(0x1e38aaf5f6846096), LL(0x1cb8fd35e9d62592)}, {LL(0x1b8d993ddfba70af), LL(0xa78c88dd9a4e7414)}, {LL(0x406b46e43a78fcc6), LL(0xd4f8f1df306ef52d)}, {LL(0xc6dae8dec11d66a7), LL(0x6d523712b3e30332)},
			{LL(0xef75bc0628f689a1), LL(0xdbebd6d7ddeeb4c9)}, {LL(0xcd3d81daf1b929d8), LL(0xffe012882557dbbc)}, {LL(0x8d56c73ecbc1d51e), LL(0x2b18e35715392e91)}, {LL(0x26b3014392a9df4d), LL(0xb8e57e3efb6644b2)},
			{LL(0x5aa8d08e871ae364), LL(0x54aeb68bda67fb78)}, {LL(0x4ca50286e7917d9a), LL(0xb309fc7c35cc88a7)}, {LL(0x6eed3f5a3ededde3), LL(0x97023823cd75e7d2)}, {LL(0x6c7121f4faad03f9), LL(0xd97565f22dfb1350)},
			{LL(0x988904cf0de1faf7), LL(0xa5123bf86a5bd38d)}, {LL(0xf72a34c251e74819), LL(0x15cacc52d7694e1e)}, {LL(0xbb8f3644b6763583), LL(0xa6c3302ee2a5c6b9)}, {LL(0x0f1c559b7b42304b), LL(0x0e5c9ffb956bf349)},
			{LL(0x80d68c0b74f03b4f), LL(0x6b33217d60dc295a)}, {LL(0x842db0943f16447b), LL(0xf7dd9b1c6303029d)}, {LL(0x3c7097292fcbc0ef), LL(0x38b3396a116f4ae7)}, {LL(0x36d9f17a7db7e09d), LL(0x8ddbd379f79ce828)},
			{LL(0x2306328bbb97cf74), LL(0x03d10bd688fe1534)}, {LL(0x13b8e1c049b58ec7), LL(0x5c933f1f9c332259)}, {LL(0x12f6ee972b6de1ca), LL(0x7b49f096ec745818)}, {LL(0x87ffa16d99bdf56c), LL(0x9e700944f3ca8c5e)},
			{LL(0x1743dd5f0253f1f3), LL(0xc07d857e9fec099e)}, {LL(0xd8e2422b37990631), LL(0x71eaca275a3526a0)}, {LL(0x7fc9c034b3188d3e), LL(0x85e65aedb1c83109)}, {LL(0x53d3a72473cd7201), LL(0x886bcec0ac5dd774)},
			{LL(0x388babb6642dbfdb), LL(0xa45d830b12b06120)}, {LL(0xe60ecbacdc2118c4), LL(0x072eae9cabd498c5)}, {LL(0xc888b212d88739e1), LL(0x44d4676056cf8a3a)}, {LL(0x9a151a61c99224ed), LL(0xeb6566298ad5270f)},
			{LL(0x9b5b1536ab4a4be0), LL(0xccbfa9a0fa925d4e)}, {LL(0xf6643b95333f2714), LL(0x321003dba72e345f)}, {LL(0xb74172266b9fb4df), LL(0xc1323d8de707bb33)}, {LL(0x5e53ec11ccfc9c50), LL(0xc8400cead9b8d0bf)},
			{LL(0x31f0dc1c90fa2ebe), LL(0x7898fb40648a4d2c)}, {LL(0x944740add0087bab), LL(0xc2e3365b6ff9ae07)}, {LL(0x485e3e19ac7702ae), LL(0x2fe7461d3613a360)}, {LL(0x0d804b35bf31ee51), LL(0x402bc22a75e507cb)},
			{LL(0xdfcb6f4ddad4c812), LL(0x84a9e21ec92383a4)}, {LL(0xe9129e37a763288f), LL(0x097231673ebf6b8c)}, {LL(0x78e0ed525e55431d), LL(0x70a572d422de940d)}, {LL(0x6d3f2ea398756cf4), LL(0xfeafaa7b5dbc6911)},
			{LL(0xe5dcda557a8aa9d3), LL(0x6e833cc43b1d1606)}, {LL(0x45de752c1346ecff), LL(0x6fcc843743f6a4ab)}, {LL(0x5d81fde86a572d47), LL(0xa1ed9eb249715e7c)}, {LL(0xa5b79cb140f25515), LL(0xba7bcd1b0b73e32b)},
			{LL(0x66d847a7a8d1238b), LL(0x6c1d8fe1cb08b19f)}, {LL(0xbca61b225b3bfba0), LL(0x5380181771b363bd)}, {LL(0x3eec8987ebb81ef5), LL(0x76c464bbf1e1be65)}, {LL(0x2fc876e9667e4e28), LL(0x642006758d5c68be)},
			{LL(0x242f1fed56da0157), LL(0xf69223ef1be8b030)}, {LL(0x636d746f81ef33b2), LL(0xd729fa09b890e019)}, {LL(0x7d55de9a776b5324), LL(0xcb91073c5146c58b)}, {LL(0xceef9023571298cf), LL(0x964d80d0b59e557f)},
			{LL(0xc0bdcaef4e88c789), LL(0xbfcbd0a250b2dc77)}, {LL(0x1124ff6e8dc650dd), LL(0x12e462ce7cbdd6db)}, {LL(0x824a92a5b083e555), LL(0x25447cac8052ddd8)}, {LL(0xda7e5c85f3ead82b), LL(0x3f9d97f6babbd222)},
			{LL(0x1f76a5a2945c0f9b), LL(0x3b6232bc99915fd3)}, {LL(0xb3ba4eb92079cbeb), LL(0x5ddc87ece4d890f4)}, {LL(0x9d3c370724dfeace), LL(0x1e264e1019c3820b)}, {LL(0x47426b82d73532e5), LL(0x21bbd9e6a3785029)},
			{LL(0x96db5e03147ba5b1), LL(0x8c946b8a8f775a85)}, {LL(0x54fa8a429e80bc22), LL(0x7d28e6f93f4b7270)}, {LL(0xc446f670056eb8bd), LL(0x23256ac3536df7b0)}, {LL(0x15dfc3f1c6202fe9), LL(0x8e0ad8af7f62fd1c)},
			{LL(0x07292d66ed4dce23), LL(0xf54328399316a504)}, {LL(0x70d595afc85abd75), LL(0x8bbac51624a3c240)}, {LL(0x90bc7c329bee049f), LL(0x5e0d8c3a6c2685c0)}, {LL(0x1ac3966abd621fa2), LL(0x80564754ea090e55)},
			{LL(0xa72b821f84818b0f), LL(0xf40c90caebfd17a9)}, {LL(0xd1993581c34e9754), LL(0xad2fb26c2c0f0aac)}, {LL(0x679648f0ca094c86), LL(0x4bc74068bb4fcbde)}, {LL(0xc221d4418afb1993), LL(0xf1bc8d73b03c28f5)},
			{LL(0x256110ba34026e5a), LL(0xd148ec666bafca71)}, {LL(0x8a7fea58268c1b3d), LL(0xde5bcb6e862f8b95)}, {LL(0xb85d27bd10dd8494), LL(0xcf6ea276726c487a)}, {LL(0x77fcb8c925177356), LL(0x7ef9ed2fb7b56744)},
			{LL(0x62237b38e3375cbf), LL(0xf0f33580c8d79a58)}, {LL(0xeb8e80996310f695), LL(0x47056cb6de319f0e)}, {LL(0x4b8c2fe00adcb3b9), LL(0x464ad445a6da2da3)}, {LL(0x2a7d45214f405e11), LL(0xdf14739dfec43938)},
			{LL(0x28e15b8f8b33800b), LL(0x91632e4c1e4acdba)}, {LL(0xff1f4c3fc7e8b671), LL(0xeed57b90d1141853)}, {LL(0xc508f92767b6d7b0), LL(0x04ffa54a232a8df1)}, {LL(0x2b334a762d98311c), LL(0xf8cebc148e834379)},
			{LL(0x42f7584afe0b22dc), LL(0x9a8fac0ed0e001af)}, {LL(0x61f16ac1459ceda8), LL(0x995ea7d8581e149b)}, {LL(0x3a17b518a05e61c1), LL(0xea2adedaf23e95a2)}, {LL(0x89adfba18027aa2a), LL(0xb7f6593616e60556)},
			{LL(0x0000000000000000), LL(0x0000000000000000)}, {LL(0xee3bb3514a2ee6ac), LL(0xfc31195eada9ce88)}, {LL(0xfaaa7ff7eed6a648), LL(0x55e10e78a28c49d5)}, {LL(0xd7fe17b04cdb367a), LL(0x7fb655dccf5ed5e9)}
		}
	};

	static const uint64 C[32][2] = {
		{LL(0xb87a486c7276a26e), LL(0x019484dd10bd275d)},	{LL(0xb3f490d8e4ec87dc), LL(0x02ebcb7920b94eba)},	{LL(0x0b8ed8b4969a25b2), LL(0x037f4fa4300469e7)},	{LL(0xa52be3730b1bcd7b), LL(0x041555f240b19cb7)},
		{LL(0x1d51ab1f796d6f15), LL(0x0581d12f500cbbea)},	{LL(0x16df73abeff74aa7), LL(0x06fe9e8b6008d20d)},	{LL(0xaea53bc79d81e8c9), LL(0x076a1a5670b5f550)},	{LL(0x895605e6163659f6), LL(0x082aaa2780a1fbad)},
		{LL(0x312c4d8a6440fb98), LL(0x09be2efa901cdcf0)},	{LL(0x3aa2953ef2dade2a), LL(0x0ac1615ea018b517)},	{LL(0x82d8dd5280ac7c44), LL(0x0b55e583b0a5924a)},	{LL(0x2c7de6951d2d948d), LL(0x0c3fffd5c010671a)},
		{LL(0x9407aef96f5b36e3), LL(0x0dab7b08d0ad4047)},	{LL(0x9f89764df9c11351), LL(0x0ed434ace0a929a0)},	{LL(0x27f33e218bb7b13f), LL(0x0f40b071f0140efd)},	{LL(0xd1ac0a0f2c6cb22f), LL(0x1054974ec3813599)},
		{LL(0x69d642635e1a1041), LL(0x11c01393d33c12c4)},	{LL(0x62589ad7c88035f3), LL(0x12bf5c37e3387b23)},	{LL(0xda22d2bbbaf6979d), LL(0x132bd8eaf3855c7e)},	{LL(0x7487e97c27777f54), LL(0x1441c2bc8330a92e)},
		{LL(0xccfda1105501dd3a), LL(0x15d54661938d8e73)},	{LL(0xc77379a4c39bf888), LL(0x16aa09c5a389e794)},	{LL(0x7f0931c8b1ed5ae6), LL(0x173e8d18b334c0c9)},	{LL(0x58fa0fe93a5aebd9), LL(0x187e3d694320ce34)},
		{LL(0xe0804785482c49b7), LL(0x19eab9b4539de969)},	{LL(0xeb0e9f31deb66c05), LL(0x1a95f6106399808e)},	{LL(0x5374d75dacc0ce6b), LL(0x1b0172cd7324a7d3)},	{LL(0xfdd1ec9a314126a2), LL(0x1c6b689b03915283)},
		{LL(0x45aba4f6433784cc), LL(0x1dffec46132c75de)},	{LL(0x4e257c42d5ada17e), LL(0x1e80a3e223281c39)},	{LL(0xf65f342ea7db0310), LL(0x1f14273f33953b64)},	{LL(0x619b141e58d8a75e), LL(0x20a8ed9c45c16af1)}
	};

	static inline void LS(uint64 x1, uint64 x2, uint64* t1, uint64* t2)
	{
		*t1 = T[0][(byte)(x1)][0] ^ T[1][(byte)(x1 >> 8)][0] ^ T[2][(byte)(x1 >> 16)][0] ^ T[3][(byte)(x1 >> 24)][0] ^ T[4][(byte)(x1 >> 32)][0] ^ T[5][(byte)(x1 >> 40)][0] ^
			T[6][(byte)(x1 >> 48)][0] ^ T[7][(byte)(x1 >> 56)][0] ^ T[8][(byte)(x2)][0] ^ T[9][(byte)(x2 >> 8)][0] ^ T[10][(byte)(x2 >> 16)][0] ^ T[11][(byte)(x2 >> 24)][0] ^
			T[12][(byte)(x2 >> 32)][0] ^ T[13][(byte)(x2 >> 40)][0] ^ T[14][(byte)(x2 >> 48)][0] ^ T[15][(byte)(x2 >> 56)][0];
		*t2 = T[0][(byte)(x1)][1] ^ T[1][(byte)(x1 >> 8)][1] ^ T[2][(byte)(x1 >> 16)][1] ^ T[3][(byte)(x1 >> 24)][1] ^ T[4][(byte)(x1 >> 32)][1] ^ T[5][(byte)(x1 >> 40)][1] ^
			T[6][(byte)(x1 >> 48)][1] ^ T[7][(byte)(x1 >> 56)][1] ^ T[8][(byte)(x2)][1] ^ T[9][(byte)(x2 >> 8)][1] ^ T[10][(byte)(x2 >> 16)][1] ^ T[11][(byte)(x2 >> 24)][1] ^
			T[12][(byte)(x2 >> 32)][1] ^ T[13][(byte)(x2 >> 40)][1] ^ T[14][(byte)(x2 >> 48)][1] ^ T[15][(byte)(x2 >> 56)][1];
	}

	static inline void ILS(uint64 x1, uint64 x2, uint64* t1, uint64* t2)
	{
		*t1 = IT[0][(byte)(x1)][0] ^ IT[1][(byte)(x1 >> 8)][0] ^ IT[2][(byte)(x1 >> 16)][0] ^ IT[3][(byte)(x1 >> 24)][0] ^ IT[4][(byte)(x1 >> 32)][0] ^ IT[5][(byte)(x1 >> 40)][0] ^
			IT[6][(byte)(x1 >> 48)][0] ^ IT[7][(byte)(x1 >> 56)][0] ^ IT[8][(byte)(x2)][0] ^ IT[9][(byte)(x2 >> 8)][0] ^ IT[10][(byte)(x2 >> 16)][0] ^ IT[11][(byte)(x2 >> 24)][0] ^
			IT[12][(byte)(x2 >> 32)][0] ^ IT[13][(byte)(x2 >> 40)][0] ^ IT[14][(byte)(x2 >> 48)][0] ^ IT[15][(byte)(x2 >> 56)][0];
		*t2 = IT[0][(byte)(x1)][1] ^ IT[1][(byte)(x1 >> 8)][1] ^ IT[2][(byte)(x1 >> 16)][1] ^ IT[3][(byte)(x1 >> 24)][1] ^ IT[4][(byte)(x1 >> 32)][1] ^ IT[5][(byte)(x1 >> 40)][1] ^
			IT[6][(byte)(x1 >> 48)][1] ^ IT[7][(byte)(x1 >> 56)][1] ^ IT[8][(byte)(x2)][1] ^ IT[9][(byte)(x2 >> 8)][1] ^ IT[10][(byte)(x2 >> 16)][1] ^ IT[11][(byte)(x2 >> 24)][1] ^
			IT[12][(byte)(x2 >> 32)][1] ^ IT[13][(byte)(x2 >> 40)][1] ^ IT[14][(byte)(x2 >> 48)][1] ^ IT[15][(byte)(x2 >> 56)][1];
	}

	static inline void ILSS(uint64 x1, uint64 x2, uint64* t1, uint64* t2)
	{
		*t1 = IT[0][S[(byte)(x1)]][0] ^ IT[1][S[(byte)(x1 >> 8)]][0] ^ IT[2][S[(byte)(x1 >> 16)]][0] ^ IT[3][S[(byte)(x1 >> 24)]][0] ^ IT[4][S[(byte)(x1 >> 32)]][0] ^ IT[5][S[(byte)(x1 >> 40)]][0] ^
			IT[6][S[(byte)(x1 >> 48)]][0] ^ IT[7][S[(byte)(x1 >> 56)]][0] ^ IT[8][S[(byte)(x2)]][0] ^ IT[9][S[(byte)(x2 >> 8)]][0] ^ IT[10][S[(byte)(x2 >> 16)]][0] ^ IT[11][S[(byte)(x2 >> 24)]][0] ^
			IT[12][S[(byte)(x2 >> 32)]][0] ^ IT[13][S[(byte)(x2 >> 40)]][0] ^ IT[14][S[(byte)(x2 >> 48)]][0] ^ IT[15][S[(byte)(x2 >> 56)]][0];
		*t2 = IT[0][S[(byte)(x1)]][1] ^ IT[1][S[(byte)(x1 >> 8)]][1] ^ IT[2][S[(byte)(x1 >> 16)]][1] ^ IT[3][S[(byte)(x1 >> 24)]][1] ^ IT[4][S[(byte)(x1 >> 32)]][1] ^ IT[5][S[(byte)(x1 >> 40)]][1] ^
			IT[6][S[(byte)(x1 >> 48)]][1] ^ IT[7][S[(byte)(x1 >> 56)]][1] ^ IT[8][S[(byte)(x2)]][1] ^ IT[9][S[(byte)(x2 >> 8)]][1] ^ IT[10][S[(byte)(x2 >> 16)]][1] ^ IT[11][S[(byte)(x2 >> 24)]][1] ^
			IT[12][S[(byte)(x2 >> 32)]][1] ^ IT[13][S[(byte)(x2 >> 40)]][1] ^ IT[14][S[(byte)(x2 >> 48)]][1] ^ IT[15][S[(byte)(x2 >> 56)]][1];
	}

	static inline void ISI(byte* val)
	{
		val[0] = IS[val[0]];
		val[1] = IS[val[1]];
		val[2] = IS[val[2]];
		val[3] = IS[val[3]];
		val[4] = IS[val[4]];
		val[5] = IS[val[5]];
		val[6] = IS[val[6]];
		val[7] = IS[val[7]];
	}

	static inline void F(uint64 k00, uint64 k01, uint64 k10, uint64 k11, int i, uint64* o00, uint64* o01, uint64* o10, uint64* o11)
	{
		*o10 = k00;
		*o11 = k01;
		k00 ^= C[i][0];
		k01 ^= C[i][1];
		LS(k00, k01, o00, o01);
		*o00 ^= k10;
		*o01 ^= k11;
	}

	static inline void FK(uint64* k00, uint64* k01, uint64* k10, uint64* k11, int ist)
	{
		uint64 t00, t01, t10, t11;
		int i;
		for (i = 0; i < 8; i += 2)
		{
			F(*k00, *k01, *k10, *k11, i + ist, &t00, &t01, &t10, &t11);
			F(t00, t01, t10, t11, i + 1 + ist, k00, k01, k10, k11);
		}
	}

	void kuznyechik_set_key(const byte* key, kuznyechik_kds* kds)
	{
		int i;
		uint64 k00 = *(const uint64*)key;
		uint64 k01 = *(((const uint64*)key) + 1);
		uint64 k10 = *(((const uint64*)key) + 2);
		uint64 k11 = *(((const uint64*)key) + 3);

		kds->rke[0][0] = k00;
		kds->rke[0][1] = k01;
		kds->rke[1][0] = k10;
		kds->rke[1][1] = k11;
		FK(&k00, &k01, &k10, &k11, 0);
		kds->rke[2][0] = k00;
		kds->rke[2][1] = k01;
		kds->rke[3][0] = k10;
		kds->rke[3][1] = k11;
		FK(&k00, &k01, &k10, &k11, 8);
		kds->rke[4][0] = k00;
		kds->rke[4][1] = k01;
		kds->rke[5][0] = k10;
		kds->rke[5][1] = k11;
		FK(&k00, &k01, &k10, &k11, 16);
		kds->rke[6][0] = k00;
		kds->rke[6][1] = k01;
		kds->rke[7][0] = k10;
		kds->rke[7][1] = k11;
		FK(&k00, &k01, &k10, &k11, 24);
		kds->rke[8][0] = k00;
		kds->rke[8][1] = k01;
		kds->rke[9][0] = k10;
		kds->rke[9][1] = k11;

		kds->rkd[0][0] = kds->rke[0][0];
		kds->rkd[0][1] = kds->rke[0][1];

		for (i = 1; i < 10; i++)
		{
			uint64 t1 = kds->rke[i][0], t2 = kds->rke[i][1];
			kds->rkd[i][0] = t1; kds->rkd[i][1] = t2;
			ILSS(t1, t2, &kds->rkd[i][0], &kds->rkd[i][1]);
		}

#ifdef CPPCRYPTO_DEBUG
		for(int i = 0; i < 10; i++)
			printf("key[%d]: { 0x%016I64X, 0x%016I64X }\n", i, kds->rke[i][0], kds->rke[i][1]);
#endif

	}

	void kuznyechik_encrypt_block(byte* out, const byte* in, kuznyechik_kds* kds)
	{
		uint64 x1 = *(const uint64*)in;
		uint64 x2 = *(((const uint64*)in)+1);
		uint64 t1, t2;
		x1 ^= kds->rke[0][0];
		x2 ^= kds->rke[0][1];
		LS(x1, x2, &t1, &t2);
		t1 ^= kds->rke[1][0];
		t2 ^= kds->rke[1][1];
		LS(t1, t2, &x1, &x2);
		x1 ^= kds->rke[2][0];
		x2 ^= kds->rke[2][1];
		LS(x1, x2, &t1, &t2);
		t1 ^= kds->rke[3][0];
		t2 ^= kds->rke[3][1];
		LS(t1, t2, &x1, &x2);
		x1 ^= kds->rke[4][0];
		x2 ^= kds->rke[4][1];
		LS(x1, x2, &t1, &t2);
		t1 ^= kds->rke[5][0];
		t2 ^= kds->rke[5][1];
		LS(t1, t2, &x1, &x2);
		x1 ^= kds->rke[6][0];
		x2 ^= kds->rke[6][1];
		LS(x1, x2, &t1, &t2);
		t1 ^= kds->rke[7][0];
		t2 ^= kds->rke[7][1];
		LS(t1, t2, &x1, &x2);
		x1 ^= kds->rke[8][0];
		x2 ^= kds->rke[8][1];
		LS(x1, x2, &t1, &t2);
		t1 ^= kds->rke[9][0];
		t2 ^= kds->rke[9][1];
		*(uint64*)out = t1;
		*(((uint64*)out) + 1) = t2;
	}

	void kuznyechik_decrypt_block(byte* out, const byte* in, kuznyechik_kds* kds)
	{
		uint64 x1 = *(const uint64*)in;
		uint64 x2 = *(((const uint64*)in) + 1);
		uint64 t1, t2;

		ILSS(x1, x2, &t1, &t2);
		t1 ^= kds->rkd[9][0];
		t2 ^= kds->rkd[9][1];
		ILS(t1, t2, &x1, &x2);
		x1 ^= kds->rkd[8][0];
		x2 ^= kds->rkd[8][1];
		ILS(x1, x2, &t1, &t2);
		t1 ^= kds->rkd[7][0];
		t2 ^= kds->rkd[7][1];
		ILS(t1, t2, &x1, &x2);
		x1 ^= kds->rkd[6][0];
		x2 ^= kds->rkd[6][1];
		ILS(x1, x2, &t1, &t2);
		t1 ^= kds->rkd[5][0];
		t2 ^= kds->rkd[5][1];
		ILS(t1, t2, &x1, &x2);
		x1 ^= kds->rkd[4][0];
		x2 ^= kds->rkd[4][1];
		ILS(x1, x2, &t1, &t2);
		t1 ^= kds->rkd[3][0];
		t2 ^= kds->rkd[3][1];
		ILS(t1, t2, &x1, &x2);
		x1 ^= kds->rkd[2][0];
		x2 ^= kds->rkd[2][1];
		ILS(x1, x2, &t1, &t2);
		t1 ^= kds->rkd[1][0];
		t2 ^= kds->rkd[1][1];
		ISI((byte*)&t1);
		ISI((byte*)&t2);
		t1 ^= kds->rkd[0][0];
		t2 ^= kds->rkd[0][1];
		*(uint64*)out = t1;
		*(((uint64*)out) + 1) = t2;
	}


#if 0
	static inline uint8_t mul_gf(uint8_t x, uint8_t y, uint16_t p) {
		uint8_t r = 0;
		uint8_t hbit = 0;
		while (y) {
			if (y & 1)
				r ^= x;
			hbit = x & 0x80;
			x <<= 1;
			if (hbit == 0x80)
				x ^= p;
			y >>= 1;
		}
		return r;
	}

	static inline uint8_t l(uint8_t* a)
	{
		return a[15] ^ mul_gf(a[14], 148, 0x1c3) ^ mul_gf(a[13], 32, 0x1c3) ^ mul_gf(a[12], 133, 0x1c3) ^ mul_gf(a[11], 16, 0x1c3)
			^ mul_gf(a[10], 194, 0x1c3) ^ mul_gf(a[9], 192, 0x1c3) ^ a[8] ^ mul_gf(a[7], 251, 0x1c3) ^ a[6] ^ mul_gf(a[5], 192, 0x1c3)
			^ mul_gf(a[4], 194, 0x1c3) ^ mul_gf(a[3], 16, 0x1c3) ^ mul_gf(a[2], 133, 0x1c3) ^ mul_gf(a[1], 32, 0x1c3) ^ mul_gf(a[0], 148, 0x1c3);
	}

	static inline void R(uint8_t* val)
	{
		uint8_t x = l(val);
		memmove(val + 1, val, 15);
		val[0] = x;
	}

	static inline void L(uint8_t* val)
	{
		for (int i = 0; i < 16; i++)
			R(val);
	}

	static inline void IR(uint8_t* val)
	{
		uint8_t x = val[0];
		memmove(val, val + 1, 15);
		val[15] = x;
		x = l(val);
		val[15] = x;
	}

	static inline void IL(uint8_t* val)
	{
		for (int i = 0; i < 16; i++)
			IR(val);
	}

	void generate_tables()
	{
		printf("static const uint64_t T[16][256][2] = {\n");
		union
		{
			uint64_t ll[2];
			uint8_t cc[16];
		} v;
		for (int i = 0; i < 16; i++)
		{
			printf("\t{\n\t\t");
			for (int j = 0; j < 256; j++)
			{
				uint8_t s = S[j];
				v.ll[0] = v.ll[1] = 0;
				v.cc[i] = s;
				L(v.cc);
				printf("{ 0x%016I64x, 0x%016I64x }", v.ll[0], v.ll[1]);
				if (j == 255)
					printf("\n\t}");
				else
				{
					printf(", ");
					if ((j + 1) % 4 == 0)
					{
						printf("\n\t\t");
					}
				}
			}
			if (i != 15)
				printf(",");
		}
		printf("\n};");
		printf("static const uint64_t IT[16][256][2] = {\n");
		for (int i = 0; i < 16; i++)
		{
			printf("\t{\n\t\t");
			for (int j = 0; j < 256; j++)
			{
				uint8_t s = IS[j];
				v.ll[0] = v.ll[1] = 0;
				v.cc[i] = s;
				IL(v.cc);
				printf("{ 0x%016I64x, 0x%016I64x }", v.ll[0], v.ll[1]);
				if (j == 255)
					printf("\n\t}");
				else
				{
					printf(", ");
					if ((j + 1) % 4 == 0)
					{
						printf("\n\t\t");
					}
				}
			}
			if (i != 15)
				printf(",");
		}
		printf("\n};");
		printf("static const uint64_t C[32][2] = {\n");
		for (int i = 0; i <= 32; i++)
		{
			v.ll[0] = v.ll[1] = 0;
			v.cc[15] = i;
			L(v.cc);
			printf("{ 0x%016I64x, 0x%016I64x },\n", v.ll[0], v.ll[1]);
		}
		printf("};");
	}
#endif

