# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AsyncOperationResult(_serialization.Model):
    """Result of a long running operation.

    :ivar status: current status of a long running operation.
    :vartype status: str
    :ivar error: Error message containing code, description and details.
    :vartype error: ~azure.mgmt.iothubprovisioningservices.models.ErrorMessage
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorMessage"},
    }

    def __init__(
        self, *, status: Optional[str] = None, error: Optional["_models.ErrorMessage"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: current status of a long running operation.
        :paramtype status: str
        :keyword error: Error message containing code, description and details.
        :paramtype error: ~azure.mgmt.iothubprovisioningservices.models.ErrorMessage
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class CertificateBodyDescription(_serialization.Model):
    """The JSON-serialized X509 Certificate.

    :ivar certificate: Base-64 representation of the X509 leaf certificate .cer file or just .pem
     file content.
    :vartype certificate: str
    :ivar is_verified: True indicates that the certificate will be created in verified state and
     proof of possession will not be required.
    :vartype is_verified: bool
    """

    _attribute_map = {
        "certificate": {"key": "certificate", "type": "str"},
        "is_verified": {"key": "isVerified", "type": "bool"},
    }

    def __init__(self, *, certificate: Optional[str] = None, is_verified: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword certificate: Base-64 representation of the X509 leaf certificate .cer file or just
         .pem file content.
        :paramtype certificate: str
        :keyword is_verified: True indicates that the certificate will be created in verified state and
         proof of possession will not be required.
        :paramtype is_verified: bool
        """
        super().__init__(**kwargs)
        self.certificate = certificate
        self.is_verified = is_verified


class CertificateListDescription(_serialization.Model):
    """The JSON-serialized array of Certificate objects.

    :ivar value: The array of Certificate objects.
    :vartype value: list[~azure.mgmt.iothubprovisioningservices.models.CertificateResponse]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateResponse]"},
    }

    def __init__(self, *, value: Optional[List["_models.CertificateResponse"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The array of Certificate objects.
        :paramtype value: list[~azure.mgmt.iothubprovisioningservices.models.CertificateResponse]
        """
        super().__init__(**kwargs)
        self.value = value


class CertificateProperties(_serialization.Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: bytes
    :ivar created: The certificate's creation date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "subject": {"readonly": True},
        "expiry": {"readonly": True},
        "thumbprint": {"readonly": True},
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "subject": {"key": "subject", "type": "str"},
        "expiry": {"key": "expiry", "type": "rfc-1123"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "certificate": {"key": "certificate", "type": "bytearray"},
        "created": {"key": "created", "type": "rfc-1123"},
        "updated": {"key": "updated", "type": "rfc-1123"},
    }

    def __init__(
        self, *, is_verified: Optional[bool] = None, certificate: Optional[bytes] = None, **kwargs: Any
    ) -> None:
        """
        :keyword is_verified: Determines whether certificate has been verified.
        :paramtype is_verified: bool
        :keyword certificate: base-64 representation of X509 certificate .cer file or just .pem file
         content.
        :paramtype certificate: bytes
        """
        super().__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = is_verified
        self.certificate = certificate
        self.created = None
        self.updated = None


class CertificateResponse(_serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: properties of a certificate.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "CertificateProperties"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: Optional["_models.CertificateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: properties of a certificate.
        :paramtype properties: ~azure.mgmt.iothubprovisioningservices.models.CertificateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.etag = None
        self.type = None
        self.system_data = None


class ErrorDetails(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: int
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        "code": {"readonly": True},
        "http_status_code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "http_status_code": {"key": "httpStatusCode", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class ErrorMessage(_serialization.Model):
    """Error response containing message and code.

    :ivar code: standard error code.
    :vartype code: str
    :ivar message: standard error description.
    :vartype message: str
    :ivar details: detailed summary of error.
    :vartype details: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, details: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: standard error code.
        :paramtype code: str
        :keyword message: standard error description.
        :paramtype message: str
        :keyword details: detailed summary of error.
        :paramtype details: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class GroupIdInformation(_serialization.Model):
    """The group information for creating a private endpoint on a provisioning service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: The properties for a group information object. Required.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.GroupIdInformationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "GroupIdInformationProperties"},
    }

    def __init__(self, *, properties: "_models.GroupIdInformationProperties", **kwargs: Any) -> None:
        """
        :keyword properties: The properties for a group information object. Required.
        :paramtype properties:
         ~azure.mgmt.iothubprovisioningservices.models.GroupIdInformationProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class GroupIdInformationProperties(_serialization.Model):
    """The properties for a group information object.

    :ivar group_id: The group id.
    :vartype group_id: str
    :ivar required_members: The required members for a specific group id.
    :vartype required_members: list[str]
    :ivar required_zone_names: The required DNS zones for a specific group id.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_id: The group id.
        :paramtype group_id: str
        :keyword required_members: The required members for a specific group id.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The required DNS zones for a specific group id.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class IotDpsPropertiesDescription(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """the service specific properties of a provisioning service, including keys, linked iot hubs,
    current state, and system generated properties such as hostname and idScope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: Current state of the provisioning service. Known values are: "Activating",
     "Active", "Deleting", "Deleted", "ActivationFailed", "DeletionFailed", "Transitioning",
     "Suspending", "Suspended", "Resuming", "FailingOver", and "FailoverFailed".
    :vartype state: str or ~azure.mgmt.iothubprovisioningservices.models.State
    :ivar public_network_access: Whether requests from Public Network are allowed. Known values
     are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.iothubprovisioningservices.models.PublicNetworkAccess
    :ivar ip_filter_rules: The IP filter rules.
    :vartype ip_filter_rules: list[~azure.mgmt.iothubprovisioningservices.models.IpFilterRule]
    :ivar private_endpoint_connections: Private endpoint connections created on this IotHub.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
    :ivar provisioning_state: The ARM provisioning state of the provisioning service.
    :vartype provisioning_state: str
    :ivar iot_hubs: List of IoT hubs associated with this provisioning service.
    :vartype iot_hubs:
     list[~azure.mgmt.iothubprovisioningservices.models.IotHubDefinitionDescription]
    :ivar allocation_policy: Allocation policy to be used by this provisioning service. Known
     values are: "Hashed", "GeoLatency", and "Static".
    :vartype allocation_policy: str or
     ~azure.mgmt.iothubprovisioningservices.models.AllocationPolicy
    :ivar service_operations_host_name: Service endpoint for provisioning service.
    :vartype service_operations_host_name: str
    :ivar device_provisioning_host_name: Device endpoint for this provisioning service.
    :vartype device_provisioning_host_name: str
    :ivar id_scope: Unique identifier of this provisioning service.
    :vartype id_scope: str
    :ivar authorization_policies: List of authorization keys for a provisioning service.
    :vartype authorization_policies:
     list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
    :ivar enable_data_residency: Optional.
     Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster
     recovery.
    :vartype enable_data_residency: bool
    :ivar portal_operations_host_name: Portal endpoint to enable CORS for this provisioning
     service.
    :vartype portal_operations_host_name: str
    """

    _validation = {
        "service_operations_host_name": {"readonly": True},
        "device_provisioning_host_name": {"readonly": True},
        "id_scope": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "ip_filter_rules": {"key": "ipFilterRules", "type": "[IpFilterRule]"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "iot_hubs": {"key": "iotHubs", "type": "[IotHubDefinitionDescription]"},
        "allocation_policy": {"key": "allocationPolicy", "type": "str"},
        "service_operations_host_name": {"key": "serviceOperationsHostName", "type": "str"},
        "device_provisioning_host_name": {"key": "deviceProvisioningHostName", "type": "str"},
        "id_scope": {"key": "idScope", "type": "str"},
        "authorization_policies": {
            "key": "authorizationPolicies",
            "type": "[SharedAccessSignatureAuthorizationRuleAccessRightsDescription]",
        },
        "enable_data_residency": {"key": "enableDataResidency", "type": "bool"},
        "portal_operations_host_name": {"key": "portalOperationsHostName", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.State"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        ip_filter_rules: Optional[List["_models.IpFilterRule"]] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        provisioning_state: Optional[str] = None,
        iot_hubs: Optional[List["_models.IotHubDefinitionDescription"]] = None,
        allocation_policy: Optional[Union[str, "_models.AllocationPolicy"]] = None,
        authorization_policies: Optional[
            List["_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription"]
        ] = None,
        enable_data_residency: Optional[bool] = None,
        portal_operations_host_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Current state of the provisioning service. Known values are: "Activating",
         "Active", "Deleting", "Deleted", "ActivationFailed", "DeletionFailed", "Transitioning",
         "Suspending", "Suspended", "Resuming", "FailingOver", and "FailoverFailed".
        :paramtype state: str or ~azure.mgmt.iothubprovisioningservices.models.State
        :keyword public_network_access: Whether requests from Public Network are allowed. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.iothubprovisioningservices.models.PublicNetworkAccess
        :keyword ip_filter_rules: The IP filter rules.
        :paramtype ip_filter_rules: list[~azure.mgmt.iothubprovisioningservices.models.IpFilterRule]
        :keyword private_endpoint_connections: Private endpoint connections created on this IotHub.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
        :keyword provisioning_state: The ARM provisioning state of the provisioning service.
        :paramtype provisioning_state: str
        :keyword iot_hubs: List of IoT hubs associated with this provisioning service.
        :paramtype iot_hubs:
         list[~azure.mgmt.iothubprovisioningservices.models.IotHubDefinitionDescription]
        :keyword allocation_policy: Allocation policy to be used by this provisioning service. Known
         values are: "Hashed", "GeoLatency", and "Static".
        :paramtype allocation_policy: str or
         ~azure.mgmt.iothubprovisioningservices.models.AllocationPolicy
        :keyword authorization_policies: List of authorization keys for a provisioning service.
        :paramtype authorization_policies:
         list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
        :keyword enable_data_residency: Optional.
         Indicates if the DPS instance has Data Residency enabled, removing the cross geo-pair disaster
         recovery.
        :paramtype enable_data_residency: bool
        :keyword portal_operations_host_name: Portal endpoint to enable CORS for this provisioning
         service.
        :paramtype portal_operations_host_name: str
        """
        super().__init__(**kwargs)
        self.state = state
        self.public_network_access = public_network_access
        self.ip_filter_rules = ip_filter_rules
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = provisioning_state
        self.iot_hubs = iot_hubs
        self.allocation_policy = allocation_policy
        self.service_operations_host_name = None
        self.device_provisioning_host_name = None
        self.id_scope = None
        self.authorization_policies = authorization_policies
        self.enable_data_residency = enable_data_residency
        self.portal_operations_host_name = portal_operations_host_name


class IotDpsSkuDefinition(_serialization.Model):
    """Available SKUs of tier and units.

    :ivar name: Sku name. "S1"
    :vartype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.IotDpsSku"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: Sku name. "S1"
        :paramtype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
        """
        super().__init__(**kwargs)
        self.name = name


class IotDpsSkuDefinitionListResult(_serialization.Model):
    """List of available SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of SKUs.
    :vartype value: list[~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuDefinition]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IotDpsSkuDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.IotDpsSkuDefinition"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of SKUs.
        :paramtype value: list[~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotDpsSkuInfo(_serialization.Model):
    """List of possible provisioning service SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Sku name. "S1"
    :vartype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    :ivar tier: Pricing tier name of the provisioning service.
    :vartype tier: str
    :ivar capacity: The number of units to provision.
    :vartype capacity: int
    """

    _validation = {
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.IotDpsSku"]] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Sku name. "S1"
        :paramtype name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
        :keyword capacity: The number of units to provision.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None
        self.capacity = capacity


class IotHubDefinitionDescription(_serialization.Model):
    """Description of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar apply_allocation_policy: flag for applying allocationPolicy or not for a given iot hub.
    :vartype apply_allocation_policy: bool
    :ivar allocation_weight: weight to apply for a given iot h.
    :vartype allocation_weight: int
    :ivar name: Host name of the IoT hub.
    :vartype name: str
    :ivar connection_string: Connection string of the IoT hub. Required.
    :vartype connection_string: str
    :ivar location: ARM region of the IoT hub. Required.
    :vartype location: str
    """

    _validation = {
        "name": {"readonly": True},
        "connection_string": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "apply_allocation_policy": {"key": "applyAllocationPolicy", "type": "bool"},
        "allocation_weight": {"key": "allocationWeight", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        location: str,
        apply_allocation_policy: Optional[bool] = None,
        allocation_weight: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword apply_allocation_policy: flag for applying allocationPolicy or not for a given iot
         hub.
        :paramtype apply_allocation_policy: bool
        :keyword allocation_weight: weight to apply for a given iot h.
        :paramtype allocation_weight: int
        :keyword connection_string: Connection string of the IoT hub. Required.
        :paramtype connection_string: str
        :keyword location: ARM region of the IoT hub. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.apply_allocation_policy = apply_allocation_policy
        self.allocation_weight = allocation_weight
        self.name = None
        self.connection_string = connection_string
        self.location = location


class IpFilterRule(_serialization.Model):
    """The IP filter rules for a provisioning Service.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_name: The name of the IP filter rule. Required.
    :vartype filter_name: str
    :ivar action: The desired action for requests captured by this rule. Required. Known values
     are: "Accept" and "Reject".
    :vartype action: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterActionType
    :ivar ip_mask: A string that contains the IP address range in CIDR notation for the rule.
     Required.
    :vartype ip_mask: str
    :ivar target: Target for requests captured by this rule. Known values are: "all", "serviceApi",
     and "deviceApi".
    :vartype target: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterTargetType
    """

    _validation = {
        "filter_name": {"required": True},
        "action": {"required": True},
        "ip_mask": {"required": True},
    }

    _attribute_map = {
        "filter_name": {"key": "filterName", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "ip_mask": {"key": "ipMask", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        filter_name: str,
        action: Union[str, "_models.IpFilterActionType"],
        ip_mask: str,
        target: Optional[Union[str, "_models.IpFilterTargetType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filter_name: The name of the IP filter rule. Required.
        :paramtype filter_name: str
        :keyword action: The desired action for requests captured by this rule. Required. Known values
         are: "Accept" and "Reject".
        :paramtype action: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterActionType
        :keyword ip_mask: A string that contains the IP address range in CIDR notation for the rule.
         Required.
        :paramtype ip_mask: str
        :keyword target: Target for requests captured by this rule. Known values are: "all",
         "serviceApi", and "deviceApi".
        :paramtype target: str or ~azure.mgmt.iothubprovisioningservices.models.IpFilterTargetType
        """
        super().__init__(**kwargs)
        self.filter_name = filter_name
        self.action = action
        self.ip_mask = ip_mask
        self.target = target


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.iothubprovisioningservices.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or
         ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.iothubprovisioningservices.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NameAvailabilityInfo(_serialization.Model):
    """Description of name availability.

    :ivar name_available: specifies if a name is available or not.
    :vartype name_available: bool
    :ivar reason: specifies the reason a name is unavailable. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.iothubprovisioningservices.models.NameUnavailabilityReason
    :ivar message: message containing a detailed reason name is unavailable.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.NameUnavailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: specifies if a name is available or not.
        :paramtype name_available: bool
        :keyword reason: specifies the reason a name is unavailable. Known values are: "Invalid" and
         "AlreadyExists".
        :paramtype reason: str or
         ~azure.mgmt.iothubprovisioningservices.models.NameUnavailabilityReason
        :keyword message: message containing a detailed reason name is unavailable.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class Operation(_serialization.Model):
    """Provisioning Service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.iothubprovisioningservices.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.iothubprovisioningservices.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: ProvisioningServices.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationInputs(_serialization.Model):
    """Input values for operation results call.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the Provisioning Service to check. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the Provisioning Service to check. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class OperationListResult(_serialization.Model):
    """Result of the request to list provisioning service operations. It contains a list of operations
    and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Provisioning service operations supported by the Microsoft.Devices resource
     provider.
    :vartype value: list[~azure.mgmt.iothubprovisioningservices.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(_serialization.Model):
    """The private endpoint connection of a provisioning service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties: The properties of a private endpoint connection. Required.
    :vartype properties:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnectionProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "properties": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: "_models.PrivateEndpointConnectionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a private endpoint connection. Required.
        :paramtype properties:
         ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class PrivateEndpointConnectionProperties(_serialization.Model):
    """The properties of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :ivar private_endpoint: The private endpoint property of a private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: The current state of a private endpoint
     connection. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "private_link_service_connection_state": {"required": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint property of a private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpoint
        :keyword private_link_service_connection_state: The current state of a private endpoint
         connection. Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResources(_serialization.Model):
    """The available private link resources for a provisioning service.

    :ivar value: The list of available private link resources for a provisioning service.
    :vartype value: list[~azure.mgmt.iothubprovisioningservices.models.GroupIdInformation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GroupIdInformation]"},
    }

    def __init__(self, *, value: Optional[List["_models.GroupIdInformation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of available private link resources for a provisioning service.
        :paramtype value: list[~azure.mgmt.iothubprovisioningservices.models.GroupIdInformation]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The status of a private endpoint connection. Required. Known values are:
     "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionStatus
    :ivar description: The description for the current state of a private endpoint connection.
     Required.
    :vartype description: str
    :ivar actions_required: Actions required for a private endpoint connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of a private endpoint connection. Required. Known values are:
         "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionStatus
        :keyword description: The description for the current state of a private endpoint connection.
         Required.
        :paramtype description: str
        :keyword actions_required: Actions required for a private endpoint connection.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Resource(_serialization.Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar resourcegroup: The resource group of the resource.
    :vartype resourcegroup: str
    :ivar subscriptionid: The subscription id of the resource.
    :vartype subscriptionid: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "resourcegroup": {"key": "resourcegroup", "type": "str"},
        "subscriptionid": {"key": "subscriptionid", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        resourcegroup: Optional[str] = None,
        subscriptionid: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword resourcegroup: The resource group of the resource.
        :paramtype resourcegroup: str
        :keyword subscriptionid: The subscription id of the resource.
        :paramtype subscriptionid: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.resourcegroup = resourcegroup
        self.subscriptionid = subscriptionid
        self.tags = tags


class ProvisioningServiceDescription(Resource):  # pylint: disable=too-many-instance-attributes
    """The description of the provisioning service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: The resource location. Required.
    :vartype location: str
    :ivar resourcegroup: The resource group of the resource.
    :vartype resourcegroup: str
    :ivar subscriptionid: The subscription id of the resource.
    :vartype subscriptionid: str
    :ivar tags: The resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :vartype etag: str
    :ivar properties: Service specific properties for a provisioning service. Required.
    :vartype properties: ~azure.mgmt.iothubprovisioningservices.models.IotDpsPropertiesDescription
    :ivar sku: Sku info for a provisioning Service. Required.
    :vartype sku: ~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuInfo
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.iothubprovisioningservices.models.SystemData
    :ivar identity: The managed identities for a provisioning service.
    :vartype identity: ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True, "pattern": r"^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$"},
        "type": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
        "sku": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "resourcegroup": {"key": "resourcegroup", "type": "str"},
        "subscriptionid": {"key": "subscriptionid", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "IotDpsPropertiesDescription"},
        "sku": {"key": "sku", "type": "IotDpsSkuInfo"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.IotDpsPropertiesDescription",
        sku: "_models.IotDpsSkuInfo",
        resourcegroup: Optional[str] = None,
        subscriptionid: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The resource location. Required.
        :paramtype location: str
        :keyword resourcegroup: The resource group of the resource.
        :paramtype resourcegroup: str
        :keyword subscriptionid: The subscription id of the resource.
        :paramtype subscriptionid: str
        :keyword tags: The resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: The Etag field is *not* required. If it is provided in the response body, it
         must also be provided as a header per the normal ETag convention.
        :paramtype etag: str
        :keyword properties: Service specific properties for a provisioning service. Required.
        :paramtype properties:
         ~azure.mgmt.iothubprovisioningservices.models.IotDpsPropertiesDescription
        :keyword sku: Sku info for a provisioning Service. Required.
        :paramtype sku: ~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuInfo
        :keyword identity: The managed identities for a provisioning service.
        :paramtype identity: ~azure.mgmt.iothubprovisioningservices.models.ManagedServiceIdentity
        """
        super().__init__(
            location=location, resourcegroup=resourcegroup, subscriptionid=subscriptionid, tags=tags, **kwargs
        )
        self.etag = etag
        self.properties = properties
        self.sku = sku
        self.system_data = None
        self.identity = identity


class ProvisioningServiceDescriptionListResult(_serialization.Model):
    """List of provisioning service descriptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of provisioning service descriptions.
    :vartype value:
     list[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
    :ivar next_link: the next link.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProvisioningServiceDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProvisioningServiceDescription"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of provisioning service descriptions.
        :paramtype value:
         list[~azure.mgmt.iothubprovisioningservices.models.ProvisioningServiceDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SharedAccessSignatureAuthorizationRuleAccessRightsDescription(_serialization.Model):
    """Description of the shared access key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Name of the key. Required.
    :vartype key_name: str
    :ivar primary_key: Primary SAS key value.
    :vartype primary_key: str
    :ivar secondary_key: Secondary SAS key value.
    :vartype secondary_key: str
    :ivar rights: Rights that this key has. Required. Known values are: "ServiceConfig",
     "EnrollmentRead", "EnrollmentWrite", "DeviceConnect", "RegistrationStatusRead", and
     "RegistrationStatusWrite".
    :vartype rights: str or ~azure.mgmt.iothubprovisioningservices.models.AccessRightsDescription
    """

    _validation = {
        "key_name": {"required": True},
        "rights": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "rights": {"key": "rights", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: str,
        rights: Union[str, "_models.AccessRightsDescription"],
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: Name of the key. Required.
        :paramtype key_name: str
        :keyword primary_key: Primary SAS key value.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary SAS key value.
        :paramtype secondary_key: str
        :keyword rights: Rights that this key has. Required. Known values are: "ServiceConfig",
         "EnrollmentRead", "EnrollmentWrite", "DeviceConnect", "RegistrationStatusRead", and
         "RegistrationStatusWrite".
        :paramtype rights: str or ~azure.mgmt.iothubprovisioningservices.models.AccessRightsDescription
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.rights = rights


class SharedAccessSignatureAuthorizationRuleListResult(_serialization.Model):
    """List of shared access keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shared access policies.
    :vartype value:
     list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedAccessSignatureAuthorizationRuleAccessRightsDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of shared access policies.
        :paramtype value:
         list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.iothubprovisioningservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a
    Provisioning Service instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VerificationCodeRequest(_serialization.Model):
    """The JSON-serialized leaf certificate.

    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: str
    """

    _attribute_map = {
        "certificate": {"key": "certificate", "type": "str"},
    }

    def __init__(self, *, certificate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword certificate: base-64 representation of X509 certificate .cer file or just .pem file
         content.
        :paramtype certificate: str
        """
        super().__init__(**kwargs)
        self.certificate = certificate


class VerificationCodeResponse(_serialization.Model):
    """Description of the response of the verification code.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of certificate.
    :vartype name: str
    :ivar etag: Request etag.
    :vartype etag: str
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponseProperties
    """

    _validation = {
        "name": {"readonly": True},
        "etag": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "VerificationCodeResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.VerificationCodeResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponseProperties
        """
        super().__init__(**kwargs)
        self.name = None
        self.etag = None
        self.id = None
        self.type = None
        self.properties = properties


class VerificationCodeResponseProperties(_serialization.Model):
    """VerificationCodeResponseProperties.

    :ivar verification_code: Verification code.
    :vartype verification_code: str
    :ivar subject: Certificate subject.
    :vartype subject: str
    :ivar expiry: Code expiry.
    :vartype expiry: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Indicate if the certificate is verified by owner of private key.
    :vartype is_verified: bool
    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: bytes
    :ivar created: Certificate created time.
    :vartype created: str
    :ivar updated: Certificate updated time.
    :vartype updated: str
    """

    _attribute_map = {
        "verification_code": {"key": "verificationCode", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "expiry": {"key": "expiry", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "is_verified": {"key": "isVerified", "type": "bool"},
        "certificate": {"key": "certificate", "type": "bytearray"},
        "created": {"key": "created", "type": "str"},
        "updated": {"key": "updated", "type": "str"},
    }

    def __init__(
        self,
        *,
        verification_code: Optional[str] = None,
        subject: Optional[str] = None,
        expiry: Optional[str] = None,
        thumbprint: Optional[str] = None,
        is_verified: Optional[bool] = None,
        certificate: Optional[bytes] = None,
        created: Optional[str] = None,
        updated: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword verification_code: Verification code.
        :paramtype verification_code: str
        :keyword subject: Certificate subject.
        :paramtype subject: str
        :keyword expiry: Code expiry.
        :paramtype expiry: str
        :keyword thumbprint: Certificate thumbprint.
        :paramtype thumbprint: str
        :keyword is_verified: Indicate if the certificate is verified by owner of private key.
        :paramtype is_verified: bool
        :keyword certificate: base-64 representation of X509 certificate .cer file or just .pem file
         content.
        :paramtype certificate: bytes
        :keyword created: Certificate created time.
        :paramtype created: str
        :keyword updated: Certificate updated time.
        :paramtype updated: str
        """
        super().__init__(**kwargs)
        self.verification_code = verification_code
        self.subject = subject
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.is_verified = is_verified
        self.certificate = certificate
        self.created = created
        self.updated = updated
