% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Results-class.R
\docType{class}
\name{RLum.Results-class}
\alias{RLum.Results-class}
\title{Class \code{"RLum.Results"}}
\description{
Object class contains results data from functions (e.g., \link{analyse_SAR.CWOSL}).
}
\section{Slots}{

\describe{
\item{\code{data}}{Object of class \link{list} containing output data}
}}

\note{
The class is intended to store results from functions to be used by
other functions. The data in the object should always be accessed by the
method \code{get_RLum}.
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{new("RLum.Results", ...)}.
}

\section{Class version}{
 0.5.2
}

\examples{

showClass("RLum.Results")

##create an empty object from this class
set_RLum(class = "RLum.Results")

##use another function to show how it works

##Basic calculation of the dose rate for a specific date
 dose.rate <-  calc_SourceDoseRate(
   measurement.date = "2012-01-27",
   calib.date = "2014-12-19",
   calib.dose.rate = 0.0438,
   calib.error = 0.0019)

##show object
dose.rate

##get results
get_RLum(dose.rate)

##get parameters used for the calcualtion from the same object
get_RLum(dose.rate, data.object = "parameters")

##alternatively objects can be accessed using S3 generics, such as
dose.rate$parameters

}
\seealso{
\linkS4class{RLum}, \link{plot_RLum}, \link{merge_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
\keyword{methods}
