// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 4>, 2383> hypergeometric_1F1_big = {{
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7183779146807201355480824984892132235960e-303) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5361996854293809244896531977363790923005e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613200886724554310382028215474902e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885327874863869424680507532e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580490644e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950309e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611464321313317477012823766e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739307536377053237113957031793278e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9427265531428195368467688302986839087070e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.4344740319146998786059365435241788270263e+302) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.7355294125240463700963297602819475658243e-273) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9951457445898342315093964000398654244912e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999995422661377551679511532637609393e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998892298564409e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000110770105857e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000457733688396162733887274883634e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0004856611588072199743182877998224950270e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.0889904945622204539981795208905638705257e+280) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9927404853401060452253718538570738021733e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999993153789197646762190948811399195e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998343238689613e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000165676074649e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000684620820229755745096755095999e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0007264786742716772618787371272944909893e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9215321391933553114412688842084361158008e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999925734404774919422813503386276852e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999982027961385444e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001797203249755e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000007426556707058694021282093761226e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0079088926137324761328829498026828704710e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.9998117541687286664272909666416178234200e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999995116626275467696724155639930307403e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999998818239009467894e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000118176058830539e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000488337212127525404244395189345121e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.6917446896910904323205164624667509881679e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.7243402644277887526870971660149662928095e+07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3599493898768427435547004338219380315698e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999998451098534762550169493e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000154890093805001367396e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0640049771627091095794948499640174555599e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-4.5950273775682656730291772960903005536036e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.8290613374563599457053407788957871065839e+14) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.7893586006614775556160000949347550397558e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999983569950864277282093333831061e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000001643004354355583435350384120e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7893697063646394168501132782926169309826e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-4.8742128427029132904910580410079419166896e+11) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.5582036131197014425108664027593120084039e+32) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-2.8055609310398110739892777481442607830150e+24) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-6.7893553536143344671176095155420900325921e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7893730427713310657647817330657815119202e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.8055572556624400917171976667898419540690e+24) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-2.0141638973219641225256880082443388391236e+30) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.5582057568925927548206194871759798891917e+32) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.8055617267957574271665117771654634081188e+24) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7893772793176019775048899265889779277747e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-6.7893549684739431396435548304850505742027e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-2.8055580514173439783538891938640074049972e+24) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.0141644686098233492407586903414212024575e+30) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.8290613374486009454079229500387425981018e+14) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7893786006614775469635418473169292639814e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000001643004913572271790666616894e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999983569956456444165646496158802e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.7893497063646394255025609284765510112248e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.8742128427056948310046232769031011241206e+11) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7242631060607458979358784130576958516793e+07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0640050770335244012958752974918705090146e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000154890185296637908674e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999998451098674221189038064e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3599500681437271362439272929559256881521e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.5950563432277220682991259517280192738673e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.6678317078398129975190469879869479775161e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000488337591962571938993892891950544e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000118176146386850e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999998818238938358374e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999995116626161896445685430155787315621e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.9159763000477379127492731625240050745479e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0079088481547127934570589580048833745377e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000007426562423203485535324671239478e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001797204562080e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999982027960496204e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999925734404032777287661495647611863e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9215316406134633998427502106424391617899e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0007264788537338090332529878010867946117e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000684621080282194325983043101172e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000165676131039e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998343239253512e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999993153791798171147643737431372971e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9927404871321226955822674865932639293072e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9976990618127286269329812204620520231089e-430) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3236571724099524262453202262396985329438e+272) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0004856614798787227470718859242077657990e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000457734038238893827099919544759e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000110770186144e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998892298515579e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999995422661356517463376107220551127e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9951457440659591725401683993784690641683e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.6663821351010967474987857978389794525458e-282) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6586733183136545362278797726710332278080e+301) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9423652945198700381078599394368086514806e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739331789233981168137781468840031e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611467212519406493733744809e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950936e+00) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580496914e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885356786924759547877139636e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613443411377567520463511081490478e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5359672900058277225815544067207713318427e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.8451190975320878112717756382751849224523e-303) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.3912404849519973822063976591261065618658e-06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.3864420120700820282469891300407306639301e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999986574246688684361294565685633973458e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999998734320705136626910529639210e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999693709623e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000030629027e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000126567881409672719042608133e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000001342575108072921854925845914780219e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1923980852682234376004456537074089383969e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0544663390562772037186245972154728561478e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.7503613873251530631170624916672459764249e-305) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5327693001671953656558063474540121001979e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613283390405424236105944729322481e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885335660189070988875070838e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580492528e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950120e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611463542781092903809712554e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739299270104924268378559407071348e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9373833366510160733698523286691469120598e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.8325814604729919943735895657589571902149e+299) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.1167895022127982467949315979483554606337e-453) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3370764186234538729659937069822022027938e-07) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9998792414314142843370370013487008823617e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999886157201769836589132763027239e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999972450403732e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000002754958689e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000011384275498725165878037034534e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000120759990590873628097794901203905847e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4786053141559663842469797862255535657254e+06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9986901260298676733901671575648524046974e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999998765068237082208742783500691576e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999701150428349e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000029884946993e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000123493129384580165212899984965e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0001310045300494425505501464487404879579e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.0188990171809678341920164266162274058116e+80) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9142531461089158220197050586164080262013e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999918796402897390188865057522113953e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999980348986924175e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001965100638736e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000008120356632711593835137288872003e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0086529846846158127651806224412549260854e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.0366263852747652322824697084403584229962e+39) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.2240547183447689732593934298078908652012e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9893568688957382991290952368687376183281e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999974243960335126504001e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000002575603089849240513e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0010643126896867233374698964788972328937e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0389604732658028068835783642690222300525e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1692689363280157254888119771730693019005e+08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.2985267034297537155526176525122316940690e+11) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.1288754120939602791285058345623136205725e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999726791531460897985952128325e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000027320837554927967999330616e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1290749657927585605454027760800223367346e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1019777710859352316059495519159529481248e+11) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.3620451329624362945056488595937872151464e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-5.3658830465135706556651745268326810610173e+29) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-4.6652487065833925333782255008267362427645e+22) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.1288753885034976469627212659003000966097e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1290750042430047060745574703121962645517e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.6652468623394154193433678996674106978418e+22) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.5536867465173755006140092059368548511431e+29) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3892930297779240364649610024704567763467e+34) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.3658845684670931964613260689557904733072e+29) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.6652500298123263296212607692592688719219e+22) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1290757087207022524892537719796714191866e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.1288753244601003217841791078681880766252e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-4.6652481855678261230040250576332070300113e+22) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-4.5536880381034060445485406941112801979807e+29) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.3892934238303851473575572618821448867273e+34) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2985267034494733059397742129019224190551e+11) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1290754120939602791045826782771477414651e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000027320846853910201404787167e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999726791624450720320006693841e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.1288749657927585605693259140058406011239e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1019777710661935578519138152285284277492e+11) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.3620451330053014421276920656617754814466e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2242522206849531663276048043258443576215e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0010643133768502270166794871316529967234e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000002575604611225695148e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999974243962654126333831e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9893568704388884659158717239704711092323e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0387633165814482974662090950480045324813e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.1696983812096429666492462842285543499586e+08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0086490509256403296456114732009636608112e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000008120362969359349517309491664979e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001965102094674e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999980348985741725e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999918796401214147937752289695497175e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9142144193259289908823498573202411341929e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.8930808604692803006588698313613774179639e-31) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.8193290480763755117213968205432385626762e+69) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0001310046067776208424543204273922637235e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000123493224436051615582925477264e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000029884968815e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999701150413563e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999998765068224742155216394999509639e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9986901257757293643800546205565255494000e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2890051984880088441393378855041079272050e-82) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.3423047822497212722592648811019008840792e+06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000120760026758880494213266846728622765e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000011384279823029300312869577593e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000002754959627e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999972450413109e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999886157245012877933382637566903e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9998792414675814177534904790340379391985e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3125945956780727239703390503654688648031e-07) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.2104285852052173963472814914663032104081e-494) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5840317735952400758899093359838760423376e+290) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9157968661769287504733862612502385994997e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739354531303320646818570537745285e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611469360170698659707635275e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951455e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580491716e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885335310419988738456540449e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613215205851003873154667761399586e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5188196855826373027688548772851609986457e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.0608209144933997347141623298634322556944e-317) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.2343317897792542635461828215065285137457e+80) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8098268885085115867434262880158967991736e+54) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0543510298793990042406027085846792680548e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1923980550588449444012375579285094795502e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000001342575511369135142202138516220046e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000126567929486338910772868827e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000030629038e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999693709727e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999998734321185903288827820077125e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999986574250721645411336402892178224397e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.3864417995887243556032851145401575375711e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.3902100093256341679084821936108045705280e-06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.7049930520989122486679540079019462413933e-55) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(7.8012545160270820686601239049258009976713e-83) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.3529549360123035259252024319818387569611e-04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8900558626047745944698190463886930468093e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999991023612918714112968195281711619862e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999153773590556329356578768395e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999795215892e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000020478404e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000084622608800565812074785126e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000897638519053512763773000006997070e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1248506180869678598023190228949587603666e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.2822728216820675911204889092632802199390e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1613235648793942217617606693300245633203e-205) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.4450719903822390270284711524552477077689e-04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999460184835827062530870986865311327983e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999949110142378327115388942697705e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999987684815786e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001231518002e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000005088983829125142851440144311e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000053981791585803814997855400003927904e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1805007115237541311167969713057527189284e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5293254980936643316038977555982111294446e+199) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9523470999113219905564003810558977056870e-307) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5310331890588272722427669722472018417865e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613051226580074889157131230533573e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885313777098065790874882765e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580487233e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950650e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611465731089362129862812056e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739322478904175007549631399065254e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9347060326876783745669517849137775948306e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.8433075054521871816027466319525972075539e+298) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9991242062420120203118599458023330635585e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999174331226018190190366853713450e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999800190774229e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000019980915776e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000082566846035940365230256231612e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000875870255883949817760906292701227440e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2398155123593010540228345003016557362693e+52) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9425838200308214209623784177596224058587e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999945707709133988648382562631995670e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999986861437723937e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001313855780419e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000005429227027426038509229172819593e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0057766172421447884776224590911489719319e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.6550543581433669804454726773754252612261e+37) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.9688845502202116331289741471129783756115e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9928840594666712004543779273739532782277e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999982779649587735905712e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000001722034455110856741e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0007115937756764699853960273541247791425e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.1427851401535107978516991704894848289773e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-8.2673736600178288321400685370014010669177e+08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-8.4540880174357709252281250923528078189541e+10) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-7.5472692239264530476367374218256324254565e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999817334278675701241726111847e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000018266565915180072665670903e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(7.5492662786734437246775322647298212231928e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.5756902277864693133620615328843263595890e+10) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-8.7683616632192212067497806904863880764138e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.4934705190785459926326587326465921567307e+29) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.1191603339307571623819119663733119226261e+22) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-7.5472690855483702891036448346909514485504e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(7.5492665164032594217927103400623491191122e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1191591168681316071033531984916773044471e+22) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.1304914755089510811846165699187270552456e+29) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.6233373614176146960230908581443484969477e+34) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.4934715099498930412083113795246360286101e+29) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1191612186345452331823355792940220809582e+22) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(7.5492712265034794952994550043317230756527e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-7.5472686573576399278999221326825402785844e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.1191600015715744760542011890787309134120e+22) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.1304923634266502062978455116462839298737e+29) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.6233383891237746627852091093642538040418e+34) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.4540880176345343055949810586488003989167e+10) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(7.5492692239264530475298003262716298529453e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000018266572132429875827388815e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999817334340848199273343290971e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-7.5472662786734437247844692784911729190276e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.5756902275876399441564963488702385236839e+10) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.7683616629748896239678939479462267368035e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.9708741790845543525277713125241991481492e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0007115942314626325056835735436243760552e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000001722035472295020094e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999982779651138206793133e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9928840604619363309371777054080785115537e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.1407986342310717570046356528789572031395e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.2649324134091302856468575101244689955172e+08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.1034239166715679942823966631018064929220e+293) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0057748652567598635929561397912065729278e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000005429231264151764068766584881119e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001313856753851e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999986861436933357e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999945707708009351047435804377876747e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9425664571300686843840821797160350565918e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0008586326878083146271815997588382867373e-29) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.4941559656654765660285035240155581901376e+47) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000875870799221668376739843241623945924e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000082566909586846242698722227305e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000019980930367e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999800190764342e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999174331217767699078028670561481e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9991242061024433038314490440358857792219e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3445252049586890842215844949565895982398e-53) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.1063560581682428326808938705240748738657e+284) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9024877706976939335817647641429338821589e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739346684325351328292629025061803e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611468622295986226802858224e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951277e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580493502e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885342689164306716267554589e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613293276883656866966429337329678e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5102118510711627198591354686704636420835e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.7672002543415946774599185120508295309149e-325) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9013299462729703767518438764433217777799e+194) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1776043644130176554151214883100982663285e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000053981828540154532287798187124549329e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000005088987718600729969937270832e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001231518895e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999987684815244e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999949110142144473377709137616541e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999460184790310189164115741041604558183e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.4242414308945562046090825966826450175360e-04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.2639421720710576462899827383013629163773e-211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.3626573279168033322188090204453516228094e+54) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8922339238461702964853981453330649169978e+36) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2821612582800602365960054287995281228422e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1248506053482628048331049205165109068266e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000897638788695225381263129037915351e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000084622640944367780362201427e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000020478411e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999795215961e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999153773911994349039447491828e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999991023615615130755114956742958971349e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8900557619214645860439715945548569795739e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.3527414241456196745253935675827398152586e-04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.4146524774548987864566560491721291307695e-37) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2722354287717275224559738645518528455739e-55) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.8994117202325295622444723801913549615655e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8921282329608074899889969202316178796537e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999172507742478755735988585946998058e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999921990243173296859626493841e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999981121886e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000001887811e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000007800972719479681004799238e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000082749201579003478106736363707384e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0109046664923019902015398557186352513520e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0398193829367991890799775609586122455529e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.9504197209922887158650573532402593729615e-20) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.2075416613707210009444199324381214345665e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999950236777762397825914066076122192760e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999995308695907253640130927870237e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999998864719282e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000113528033e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000469130231076071814514112585e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000004976323202456933524544209930270091e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9193539465797778673707213221154762982680e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5178496240283659763796481151302213590937e+18) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2299238788655278893349147073093397894672e-29) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.7679141864178291032244915779647943726663e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999925570403289961035339910733476493596e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999992983333896309147662152474855e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999998301989047e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000169801037e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000701666343841969580431126592e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000007442962968752197159474815095214662e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.6511507165330341568410183886404937893292e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.8913958698450750557516442907340282541206e+26) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.5335466030321958915071408147086258604202e-20) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.4803197654581554515018112580177251113714e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613518231938993914986323155300819e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885357914663464455862394454e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580497914e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841949582e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611461317334496715064575345e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739275541181184476285945617477882e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.8553379674708260615056876672222732073978e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.8707793500064447037516041687614432809253e+294) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.4924832817426666836463314650051731014810e+119) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9946924509800127887801503579249389388828e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999994995041088462197319923839775670e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998788815810083e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000121118377768e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000500495701067461802354110463695e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0005310518617743630864660642477760823927e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.7782118361136774903187442935784086658508e+27) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.1194497306367986215940159610392767806425e+268) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-8.8792051476307721619203357888690835894786e+101) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-6.9836060541890359734351711930993719313378e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9993440138693409587026062022236585245065e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999998412534360615750878e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000158746509907102766e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000655985880858906803861650826022816697e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.9333191368349163326713615425586547318679e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.4995383286303002547617861972534373417106e+07) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-5.8049919151838976658149699053077738889516e+232) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.4179423280175702443488306267950224870476e+108) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.4185017741390719532763251416185520942138e+09) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.9484054253756707545259742293844975704934e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999983160879473791286170358450e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000001683911479480941143294271e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.9684027756084474670894836566348306602066e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.3439456633623847145165868760936390035836e+09) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.8359176395701265589765170724063738380465e+14) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.1570049087556410010436819285681201807038e+239) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-3.8917626365886009074033888061853596912478e+127) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.0655367194457137763257987614380872492230e+28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-2.8754117727335380084765629786978226771498e+21) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-6.9484053304748962409406930236037117587921e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.9684029620970825181186139535942910878025e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.8754106777740748736063883661869058970065e+21) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.0347280051926967932265089139067962585231e+28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4115677745564160602911332477664794892922e+33) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-2.5442502005805443363226195885284811081178e+258) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.8917637404296280608262017028927915512353e+127) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.0655375889399551146625833664274740255512e+28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.8754125883016445684051605832742712229716e+21) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.9684073041238580579353340025687618285555e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-6.9484049357453725797050477137364359075001e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-2.8754114933418708644415161070998330515094e+21) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.0347288659485010885125744040933910127781e+28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.4115684585620191486296292978006262730975e+33) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5442509222195590954366952205954630617020e+258) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.4179423278820904419823331192809498098719e+108) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.4185017761389695519159745063951287687401e+09) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.9684054253756707545168964293623387763715e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000001683912052620871382964155e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999983160885205190588567057288e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.9484027756084474670985614497562925267289e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.3439456613624866005812600582343231052399e+09) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.8359176399952730674140640933524962995113e+14) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.1570049086294991561663024411964153072236e+239) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8778525721239555691402329854344285445107e+101) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.0036067808505070458929364305885674840223e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000655986294868832362288287790877570881e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000158746603676675950e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999998412534503546597215e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9993440139549313465068945184661244586155e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-6.9133218887763134738741830583943177857168e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.5037911709343759023990049597223454862810e+07) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8037319497098739225068211202337805288499e+232) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.5786630613011072876762898633457632782969e+73) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0005310374057747856234738700443684221166e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000500496091644887734662512602139e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000121118467504e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998788815737203e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999994995040984916844020923627438056e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9946923023241520373158212483690639105051e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.9227375258595918887250588743507054147640e-20) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.4578726544631825139009873622112698648888e+187) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7025637275883494153297736617187567375443e+199) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.5337747201392119935413726899183385655994e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739330750369285213894034727252524e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611467175802983163940003376e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950927e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580497002e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885357154088737952810998050e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613440812261435675903517772894148e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2631585363668215828114657097535656237773e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.2052257586392351245870137585714129676550e-302) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.4306482268702429311992348055444325838652e+290) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.6643443608925111705652248541970867285615e+217) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.0793386452881136487275054666496594031608e+26) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.6509656854399826147903679147720223455593e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000007442965204138525167000177337520197e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000701666610369134408426433909e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000169801095e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999998301989625e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999992983336561580795941731969609e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999925570425643791079495318720359034347e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7676499816010745215446476095187505805498e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.6243528765636964074057020803906536275153e-30) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-8.1246115571126440739080070766311748778502e-648) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-5.4575377493260605990942184279650521381536e-616) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.9773498132225742287026970133494669534898e+218) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.5833442886579233777253887327021906320471e+159) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3986700214087845095592946653750271823853e+18) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9193143592031795554771028470617226956687e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000004976326610293487111813142901124567e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000469130589629103671401818503e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000113528115e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999998864719232e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999995308695885695729723513447432e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999950236773578384486038250844286711324e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2074313022312556079753853079516066505659e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.1903964764020676627319284575642563512100e-20) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(6.7127192544398003237253224677560336463242e-310) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.7505718513777285967463973692142705747144e-695) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(6.0717657794260080962405148584373354615906e+219) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.7865657315482002319488143352312095740876e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.2095905864940557199638755709697414735549e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.0398185364724770586501877741620193211071e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0109046663951184170488572939548716281535e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000082749226436047824684236636701519e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000007800975682670320115584800e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000001887811e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999981121893e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999921990272805203250734303282e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999172507991049195092888533327415126e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.8921282320097758566849837048918178921618e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.8994096801648667115810425881090050234624e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.2124903389404806448223830107973948342315e-04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.7032437448974823386230178281490931400616e-06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1870406354696270172853082040083486866504e-653) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.8920830556306569944567764244489010936788e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9983507260420975958788963555349698613897e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999987415621827619706157749536298439e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999998813639320344385716271367e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999712904e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000118636022901802695309684e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000001258437439361717904087567955437e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0001649524586281924418688673795476353664e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0109000615750788415966320456268937989755e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1192919690453296900556668041200833438353e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9012613749012563294882232761425367542658e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999243208195693822227958687806476769e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999928655351095303803085300050e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999982734821e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000001726517e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000007134462180452257518994407e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000075679158225002235629795746800160e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0099645073057748323100205025586408837330e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.8889931663933984604387236510535869991736e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.6240307405169565948290536664833969409070e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8526528109058615533045854102656456881089e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999998868085443478253548540586529822889e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999893291594458066232537106932e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999974176904e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000002582309e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000010670836500888245949143285e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000113191422831009065352894866678842e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0149375015415765885359823332377454030479e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5597269554990430867298442047087924395114e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.3055049864001498361101090078912029755298e-10) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.5048229863774320249078798111947364679409e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999987721338647130336098971475610836806e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999998842459941046405679973148283e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999719878975e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000028012093e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000115753961926349525513270217e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000001227865905452115661588402755466612e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1734299650263900450635164708748353089047e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.1596667698576007453136734462456613810635e+25) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-8.2933554023200968647139129756587213667866e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613193173586437176785926769588119e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885335660188269198106402664e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580492528e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950120e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611463542781012724793757440e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739290248279913227400426765881807e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.0171116918525156715825578180288192220631e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.5802287145738117799037907252021157092633e+34) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.1326028142592725572819526676716448747863e+14) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-9.5829869217735839644575131949937352923831e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999900238613334377883472073319716539054e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999975858060690362699e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000002414193109263488e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000009976134877005444796652730964306497e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1581484419560801978269446223660831606566e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.6173669941690237991678192463652892158272e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-8.0404068398198794867355319185571023687544e+41) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.2620821133482007142866163872005770909342e+21) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1225955769425571198981560237871093175553e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5822385836062805682854175358575696579244e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999743913181056892552324902e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000025608673178084661825084e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1582234563815141646813731419291034017989e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1224362205862760887619329672619437147419e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.8369186682853933504208293944081851014844e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-3.3225256465190837813493420501584041781699e+60) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.3475690793579491272687068572950991953726e+39) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-4.6388854477232117997827221005411456587051e+26) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-4.3728830881586373339516961067651563515448e+19) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-9.5822384442501608543736257876719387070951e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1582234842456709541252748424673224871270e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.3728814270661803420050732479307812343056e+19) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.6382268591197452463773095730932981581271e+26) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5855243314100633166608727012159323363260e+34) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3225265889044409757100442031819495735812e+60) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.3475717306579428470028065546985862060360e+39) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.6388867634745963576058215964462213887190e+26) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.3728843284623789534075036238637115888429e+19) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1582241445745895476780201125765367494636e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-9.5822378439514225681114573036612213352535e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-4.3728826673694508167041606246234093929828e+19) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-4.6382281746843308679838610668714652962877e+26) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.5855247811206366456063641519840845546237e+34) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.0404068397523112931174687526693192870890e+41) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.2620821133318161587001078933368148813020e+21) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1225955969425569019972339875000106896118e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1582238583606280568285223886987694021079e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000025608681894310744767510e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999743913268219153381749158e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5822345638151416468139250680137939488118e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1224362005862763066486078320503998572961e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.8369186682436663390033255705188058111124e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.5795549300742876443176114751785057420481e+34) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.1324395025268603051762435455789447977843e+14) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1582989549170851559326082365190756885589e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000009976141163840216167735436611757146e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000002414194535297091e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999975858062864033569e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999900238626257174954366416036006525558e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-9.5814870901607206957435813232646201727935e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.6169506295201580816450852534396840755106e+08) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.6495749385918046574694746601794837532078e+20) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1580837176693411445881969102950620501435e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739315225413284701527697030354289e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611469482643665658970021686e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951485e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580491420e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885334085683566629674837117e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192612796170192941040834245997465894e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4252627509990739507772055270713845531828e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.1753084997327842495197000119656394930337e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1734082404907237681264686160295072349028e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000001227866752853147243222594437767206e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000115754051021059513689654003e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000028012113e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999719878962e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999998842459929479700025087754462e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999987721337547680682280381618133691983e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.5046562479838949975649816505195620694999e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2885876803521887298015580607011190030946e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.9018977839323515072975271782196890924933e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.1995322462596572347552440704647623923940e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.5595845151826246626374190399252768708520e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0149374864303718455749535010061039805983e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000113191456832510481374390549377675e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000010670840554193387236291033e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000002582310e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999974176913e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999893291634991117645408504718e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999998868085783493260617550207199651724e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.8526526635245253380418175639026722025931e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.6237563668732291213337625382868500026364e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1417033452309873002865258869367585677192e-10) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.9117682734252312273564145330959723567015e+117) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2003535411716800222156081491649897101273e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.7681177832979200681581348857961302444874e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.8889606598056782612273517849300750943084e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0099645066563913198932633737633277655024e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000075679210052668980166828086921206e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000007134467633272979836083604e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000001726519e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999982734820e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999928655350767454335651905477e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999243208132082194228904953107045861e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9012612928835101819987562931399454463086e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.1191809096180357625718084894754073352398e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.2007755819523960781726920254607396124085e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1970431964071816841169126020544487038116e-10) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(2.2019879325345487694172207571690129538571e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1909598038499407018363295946091753558598e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1242423697797865399100381527406037642625e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0109000614855919109906372334534928974194e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0001649524586076813561739742904399559757e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000001258437817383924857651235583172e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000118636067965561429669481e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999712905e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999998813639770981973059869320e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999987415625607841774816875354398780e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9983507260418925420194387457585892317863e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8920830547519929902052610135966721547836e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8851887176688548548245780593380737256317e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.3761374686215299212436618416303631857488e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.3117309942821119381887157261890760390560e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999172154119493528784315415668970055e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999987415543123600289379206726816156e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999990398532412209551906560852e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999094845732034198445e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000090515392414411015e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000960146470350990750790302e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000001258429342266003942805204880068e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000082713914056025515235260166592402e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999948913211884411430306234513655799720e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999242912640795284152573545099786798e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999422592685370931811231318015e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999945566374071539864445e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000005443360525191691978e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000057740714083752677047934547e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000075649619880797684286581397741463e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000004852735704210260013536821777018124e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999922555861195437680980968436907119012e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999998867423952338202915862148569898267e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999136386332439244772131559249e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999918584988224537954838e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000008141498085007390872e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000086361340736995418032550397e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000113125356331362505491099135656586e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000007170905212713127409221378872801378e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999987642809258665302369502696161802797e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999990631783738350104022396906138e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999116834919876654252735e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000088316474465421842904e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000936821335687589996660524791e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000001220144543351701388867802529464508e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9983814162087987902895739446716208136864e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9994716825323415095893176528063820151853e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999383987736325685746010306977714e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999941927008823326673191869e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000005807296911771820401095e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000061601166526917549896749462682e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.7504270713282771271250368610152477836080e+08) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3335764265905801697255189436968793485520e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3334399311887469521620865755605103614166e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192614913179756845823202510072087882e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885335660203555517443952248e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580492528e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950120e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611463542782541355566216810e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739462251135309422148008410499009e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2194514506352461111865570967995027320267e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.0722144640005407479529941768310075405909e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.0719221779699644834063334671279738174062e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-8.4643773647280682155012379965939145571448e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999192609921858274746488078849868758820e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999804614160675463995e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000019538577282259124e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000080738977145655816533395404865836541e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.6644785135371881340185474747804763965825e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.5362945089419560380909207823162511014090e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.9224413298118738235650454350465351929362e+25) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.9223205488627301740281316486582481671824e+25) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.5390452259171440352762941220555261481490e+20) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.3363662993976251100125803436628226208719e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999192609932484836477159505168435709497e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000080738979271014252924729402827755746e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.3363650320871611578759259498532784158108e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.5390870234927035652187831657443528122237e+20) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2877549431377950571705353558135761610527e+32) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.9224421587192200647241560883089668713733e+25) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9223213777358186817607869235745737590654e+25) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.5390462297150839690515921549867466179985e+20) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.3363672457088791971893205557880429452720e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000080739029651943861928740266585177228e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999192609978285660318693718564476405061e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.3363659783976557910890899933929752532150e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.5390880273024987643046415690149977545823e+20) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.2877555920257160641309603464941087193530e+32) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0722164641463959306416572748992606917032e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0719241780334115399951360574901217161647e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.6643773647280683576054615634334311746154e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000080739007814172525351192241306212188e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000019538583932453600e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999804614227177408765e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999192610228543441834666047214271555851e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-8.4644785135371879919126882776431952710952e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.5362945088920850375302186519095927237751e+13) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6667883794192125454665309938014269446307e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6667196208263984016085987923214869802932e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738528907110785326552846638838203e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611468339320814914438752939e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951208e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580494187e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885345518770121700688477551e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192605175519605302163780472401841387e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2189540471266861503312571423948200424120e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000392133049906114821900670697044210709e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000059249196770999916527343230558314785e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000061601211766559437682305819873e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000005807301443692339760619e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999941927007622033579720249e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999383987695253942945113864474743e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9998521601283346304079485518294282667651e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000058734726385336764605309467766631654e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000001220157130735012019681722832745965e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000936821982318528805118877420e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000088316542441761907842e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999116834911051637409477e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999990631782900424380763384618983e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999987642931857439806763894991227154893e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9998273335462681250838305751553247033078e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000078414500141891472264140450587305115e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000058727478379911436071819137599726753e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000007170941505163206133406213470454444e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000113125366041478409803754810600305e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000086361366679096887273153482e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000008141501177546203832e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999918585019149926084438e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999136386591860259927010056051e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999998867424049894189340892428573917679e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999922556354972877685673487622021719721e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9998264924950213221360038799282813197594e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.8455187628445527180968894520517389323019e+148) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000058727228360071262228846187424564357e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000042908188683182710441200820762962517e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000004852748902425680466536852420999097e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000075649651856851735406410341298341e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000057740753626582873999246185e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000005443364685514967941e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999945566373821401479226e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999422592636837561737428505858e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999242912378758115888818190659569641e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999948913331479941039142238316875087107e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999210847695768946037820522210213625836e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9998264630395418310995139431460281080082e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.0000058726744459497620556618961247912404e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000001333358124651589386183320118178064e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000893506067250660795283764401370211e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000082713914113757436208101043964517e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000001258429342279378568385645962788e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000960146758769529861032383e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000090515426796580156e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999094846075855889845e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999990398535296394943066145572e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999987415543123734042583939899480730e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999172154120072823668669601219989697e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999990981775142232535863643844187605996e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9999986480360165240742907414342859071906e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.9998264047012053757835289504669737132732e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999921956891430612817927284778e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999998813631675394331450047148e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999094845560118867708e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999914668836099e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000008533113149e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000090515416797276890e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000118635291526222306241073e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000007797648177589913983329772e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999995183919075752428830900074995e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999928627474821904093216303250e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999945566363717047305156e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999994868405508067e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000513159254270e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000005443361989918772265e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000007131679446429841830479117e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000457479459493848634327419620e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999992699143897878241546955777268e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999893229213713798477688140993e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999918584972725556025718e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999992324802567136e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000767519451745e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000008141500274560362957e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000010664611116060714360389587e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000676018984026243536532857534e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999998835056552203955057058543855e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999116834747868911646904e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999916741812008180e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000008325815636630e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000088316497829067277814e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000115026080459328898663106356e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999998474190240644502488463103887222e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999501932933627862395737474931682e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999941926978309348208578684e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999994525313414838045e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000547468450560891e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000005807296527712038600224e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.4357630392741550056705756668573589052279e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999993715853550552210455731043392351496e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999993715465932401529097197135546879249e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999923885782115684006464694738856e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999992824479618632600538413e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000717551765576334942298e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000007611511684677355383824041422e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4920662994762574735030690098518398890301e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3333312230853075392279751428802439324163e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3333320746018119421710374001665439383419e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192614657585879082774616645853939294e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885311566818893917930589111e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580486698e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950703e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611465952120092292033746806e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739487806087978603000489726491459e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2193703139959074013885782718330516013923e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.7548578610189796244379932112712483883720e+18) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.7548575091319999589946690085926764625358e+18) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.3363467300191921002285980025616400954118e+13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.1452752209080153143658023081430994523531e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999923885312568611530220486326873e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000007611466152482964638816908963e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1452760261824552236534622848419198704090e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.3363861340340691567193698011442551480427e+13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1567924048964758525236759155790590433583e+25) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.7548586423937485754643799218375652552060e+18) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.7548582905066691024733332552901260011510e+18) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.3363476763248956220683980478292577746436e+13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1452781130191892403498575732788850420093e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000007611470902019606195415066385e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999923885316886370109450208066342e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.1452749182932902833672526737093175147956e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.3363870803505490456957888550136215769822e+13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.1567930166388059717428995260935040989477e+25) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6666668777052189223826200864431326110478e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6666667925458000652649420185468250522271e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738534241412093062203484915899098e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611468843318110608206952995e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951330e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580492967e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885340478799077079662651005e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192605121939120227366800794999966580e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2193683139490798069309493562750293116767e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000628552299033012279363002664936892e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000628513376679826588414993231089917e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000007611423695101259109171974012e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000717552217758032646128e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999992824480548024406102575e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999923884864113098276276079387235e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.0798040494753816770413076457256520719177e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000036966644003638695983598065324e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000005585554377853169804785669342e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000005807300792568470266656e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000547468877796409e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999994525313301589131e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999941926974437430797144456e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999860626770068580336898450742101e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000005537053770048040683585564086e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000115027267114456321848158594e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000088316558788588302978e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000008325822044930e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999916741811176224e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999116834668875551399685e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999998835068110015868049781850483e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999837221604789027055597957316252e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000007392302690647466140780731201e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000005536370479776344543741973574e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000676022405437266850102042770e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000010664612031466562359838103e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000008141502720187358005e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000767519743286e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999992324805482550e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999918584997181826019798e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999893229222910735299301073344e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999992699190448003472797425628857e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999836428703462300389808066316543e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.7399633509698604771659660697063703745632e+141) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000005536346909694128446432106218e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000004045053927129474987589561521e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000457480703732520258393496221e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000007131682460895316126584720e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000005443365717720589121e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000513159646474e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999994868405484486e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999945566359141684736589e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999928627450119029205491857119e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999995183930350456490812183170676e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999925604338759072458416737446869e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999836400934293804520582644517543e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.0000000000005536301290998440891144070426e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000125699007467734420166750002e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000000084233055031035626789110850e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000007797648183032499711068345e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000118635291527483177967914e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000090515443987216223e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000008533116390e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999914668868512e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999094845832018261043e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999998813631675406940822418031e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999921956891485224929715504415e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999999149829277317124010464137876e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999998725469545425477462145421369e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.9999999999836345935792657743486993034066e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999999981113816e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999999712903e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000028709e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000001887006e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998834523707e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999982728076e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000001725844e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000110708577e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998233216003e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999974161809e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000002580802e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000163594448e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999960165385523e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999718087384e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000027835946e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999630758882640e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999879469351292e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999144356570452199064075312e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999998479256511252882e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999998479162708885180e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999981580600933e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000001841961661e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000001190784821753398171429e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999983866873225054034509179e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999983866875285634275300191e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999804615310564177476e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999981580487061e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000001841950594e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000019538699703206273e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000012630708026229415860720990057e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3333314424322735967434145588848010051622e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3333322939616973328835765921992699480529e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192614684153274785579198678479165657e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885314071408636064561242931e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580487304e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950643e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611465701661213213605854273e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739485149317030380328573563291378e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2193701422422924599460215980572251176617e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6666670448469858792196060022917091976723e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6666669596940193532303932428528634442291e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738554484965257025261538750327492e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611470751739852986385884793e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841951792e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580488349e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885321394588902391672577854e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192604919501197695002523737135767322e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2193696226393086859501144392403938830817e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000001613312677527870329192e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000001613312471451046928024e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000019538468943582253e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000001841951294e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999981580494058e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999804613002967937272e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999873692919738839054311023280995e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000152107660727016e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000152098241641714e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000001841940368e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999981580378779e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999988093282014693337734856e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000008945810481e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000001351686426e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999966272120869e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000001339949432e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000027836233e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999718090183e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999960608145213e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000000000000000000001788913780e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000000000000000000000001339784079e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000163595276e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000002580802e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999974161811e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998233227272e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999999999999999999999960416265623e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-4.2106560659765593878592113660258229253870e+122) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000000000000000000001339778374e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000000000000000000000000978890207e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000110708878e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000001725844e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999982728073e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998834526439e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999999999999999999999981996486204e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999999999999999999999960409545569e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.0000000000000000000000000000001339767335e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000000000000000000000030418760e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0000000000000000000000000000000020384132e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000001887006e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999999712904e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999999981113820e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.9999999999999999999999999999999794261385e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999999999999999999999999691567679e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.9999999999999999999999999999960396236108e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000001888618e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999999712906e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999999981129947e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000116547580e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000001727192e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999982741570e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998892914704e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000176678324e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000002583818e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999974191991e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998364056218e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000003983459753e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000028191250e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999721640656e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000036924096027e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000012053059743e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000085564306551206395932674e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000152074284174282e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000152083664407061e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000001841939123e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999999999981580391224e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999988092156848691214412550e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000001613311991106494631654e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000001613311785048558220478e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000019538460630889493e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000001841950510e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999981580501895e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999804613086095846634e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999873692973475383781544437837944e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6666665721216136798371707279411899552422e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6666664869687075347653979762639237313077e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738497234252904046292010074354878e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611465354539898507185506099e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950486e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580501410e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885375366567946050276147255e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192605492015082835896763277906577848e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2193659216480277985116591745413352769228e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3333323878825353019509849942721134188288e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3333332394118382763179211595920092013623e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192614798654641033600185772372198293e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885324865803034014248068254e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580489916e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950381e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611464622222183441095841759e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739473699045173425180886067099769e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2193694020444141857298635965903506725741e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999983866880088602316023925e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999983866882149369673276369e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999804615393691105065e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999981580494898e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000001841949811e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000019538691390415336e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000012630702652348300601945738304e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999998478924039875866e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999998479018230688810e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999981580604156e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000001841961338e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000001190671291956232639810e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999910541933247e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999986483141494e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000003372786478e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999986600511382e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999721637786e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000028190970e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000003939183803e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999999999999999999999982110869809e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999999999999999999999986602164912e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998364047935e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999974191988e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000002583818e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000176677198e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000000000000000000000003958371754e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.2106542745419135998999510668078297315395e+122) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999999999999999999999986602221961e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999999999999999999999990211102097e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999998892911696e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999982741566e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000001727192e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000116547307e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000000000000000000000001800350614e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000000000000000000003959043759e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(9.9999999999999999999999999999986602332347e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999999999999999999999999695812524e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999999999999999999999999796158768e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999999999999999999999981129952e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999999999999999999999999712905e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000000000000000000000001888617e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000000000000000000000000020573853e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000000000000000000000030843219e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0000000000000000000000000000003960374704e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000007804307151367552085675819e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000118636776130516146338924e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000000090515401010401804e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000008533112339e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999999914668909028e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999999094846261804216252e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999998813647648030967529433844e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999922023555248177521200755270e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000481607863752051059943611051e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000007137249128964934968196241e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000005443361043727367125e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000513159205540e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999994868409893833e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999945566405946483521755e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999928683239397686695152083593e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999995425207577223657626741315549e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000730085263559688006254483300e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000010677073559027794117079591e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000008141498861770879505e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000000767519378860e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999992324809126815e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999918585035911119903097e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999893353939476119567713904304e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999993239813369549246509383163784e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000116494289466831457130438645e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000000088316483279467818347e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000008325814845993e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999999916741883165569e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999999116835441045607369116e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999998849739741562990472336106339e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000152580903487136868930608693593e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000049806682988619403816234595077e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000005807299411695322858968e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000000547468398572157e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999994525318093830485e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999999941927062296551391145947e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.6357613604822841840599744467850212284722e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000628414346558070341124535652461425e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000628453108359615884752454659487554e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000007611418174446242229836327286e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000717551697435274330182e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999992824485751250012590514e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999923884919293506852808855010111e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.0793393415919838213931743702134026497053e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6666665611416615139060254040926740674746e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6666664759952304470356451836408438516646e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738495905883117678037192823139913e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611465229310411399853962494e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950456e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580501713e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885376618862341442415500779e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192605505298937564729724355119368333e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2193658358141455992406750321371439472525e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.7548565529448043280525880202951711568070e+18) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.7548562010793926112629131531105735579512e+18) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.3363451458858932967425498789598117589130e+13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1452757274968600578704752661860493367230e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000007611465129131195335795869644e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999923885374615234569319164357740e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.1452725327718672357710060953743566940853e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.3363845498816609748550586855674235219938e+13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.1567913808410238891504806489762663065428e+25) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.7548573343192022591470987006188264475382e+18) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.7548569824536907409271316495131543439188e+18) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.3363460921907475024981603236998328350091e+13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.1452746196076103998239726646766180923299e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999923885327119890705066659322637e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000007611464697355542424669239252e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1452754248822787116151359864176083379236e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.3363854961980915424406491233892425939651e+13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1567919925830635501564185117550234984717e+25) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3333343884458881631713826079646855826649e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3333352399878829632228585817725258116896e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192615040941168809822982937606167821e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885347706895886001460255996e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580495444e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841949829e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611462338113765855758438016e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739449470106242187347631353946181e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2193678357673180270170121867194386661268e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999993714479994190568484547309465306830e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999993714869217488790857441105454594850e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999923885799188850033218884615509e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999992824481229435182559802e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999998264e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000174e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000717551604496137902293e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000007611509974661227661809100377e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4920193614391814606983507148706091076082e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999630333735486597657934158005168e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999944144482742314657509124763081e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999941927019648007324477509e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999994525313821477332e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000547468409897043e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000005807299798886880159211e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000013937316375566794626230953652e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999944629488590080184412945840703e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999998849727875017350586737154013e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999116834831450686559865e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999916741819082598e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000008325814929189e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000088316491178800092379e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000116493133686188933041873643e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000016277831792229440117625957047e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999926077008193032386567217005241e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999944636321489552814656521119525e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999993239779155455258545265603240e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999893353930322065434148653100e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999918585011454861564718e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999992324806211403e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000767519087318e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000008141496416145041307e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000010677072639334548634608021e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000730080608549375122298503122e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000016357121887254694434113270285e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7399625248440741799483317254142411540005e+141) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999944636557190263062490408035470e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999959549479935074994407947132014e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999995425195134842849147358888874e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999928683209253046265194053737e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999945566368668483053206e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999994868405971793e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000513159207898e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000005443361501263406738e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000007137251599251250820935137e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000481606736282180194438451441e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000007439562591711858648064715381e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000016359898802785785334375551415e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(9.9999999999944637013377003335873024651839e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999999999998743010522155149169599283576e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999999999999157669849637303082683717341e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999999999922023555193751689765255678e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999999999998813647648018358818152164e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999999999999094845989904952023e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999999999914668876615e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000000000008533109097e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000000000090515373820475381e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000000000000118636776129255209700540e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000000000007804307145906343499885983e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000000000085017031901263235451755299e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000000000000127452984941369919574330799e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0000000000016365398650289102796223678813e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000000082784557651392253257330374521973e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000001258445215267625660251179773906e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000000960146398255871018102681e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000000090515392809162445e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999999094846415729937851e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999990398538901720749236779686e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999987415711304169370508631838089118e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999999172861176861804555419060115441368e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000005108679503308665179857560040445266e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000075708708065991439959846545303522e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000057740709781980170015751219e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000005443360548931017616e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999945566415187225275828e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999422593075971681129874661275e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999999243504090970086154467666810741933e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999951472684729438411744108137971335216e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0000007744416970599437856236526192772746e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000000113257563522179164120679434291647e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000086361334328456470834077259e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000008141498120513706237e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999918585049720239461969e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999999136386916906153558446769839e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999998868746874256306930097608163773910e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.9999928291026224058707642440289480257003e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000001235718762959996581542780322694893e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000000936821274400200927301096378e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000000088316474850583536378e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999999116835586963165989968e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999990631790160772652701958151568e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9999987798560637900431232824623316462915e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0001618435122956811557334036545184591991e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0000528336222894279456529014822458814454e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000000061601203237337086596051610781e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000005807296937098695183328e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999999941927052687959888171621e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999999383988566039553117824441935275e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7507255219726239159609128193537836191816e+08) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6665448783833506285524805361933424416954e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6666134594961437489581282728556954480299e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080738478356243996655569961146706774e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611463575968604286150389343e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950056e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580505714e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885393152274130295678983436e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192605680560552755647265595864301377e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2197786570619713087718590883999314344262e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0711823993292399663958372364435224727038e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0714728483004351211818499111611987272996e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.6643741479058901713590010927478084312172e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000080738977497678626817293602587170386e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000019538576595958187e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999804614300542337934e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999192610531708265645674406699049714930e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-8.4644752986868966788761400780579040032806e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.5366436995577353743123019232616304280786e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.9220140247688539111365837583066366443392e+25) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9221340465585646654458009729455199245807e+25) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.5390438966343851136872792888604608089046e+20) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.3363650466337486457186415695324479043802e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000080738976435022853657450738167504748e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999192610510454689271148968986983019003e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.3363637793233606267964939428495829741900e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.5390856950247844762647397396194466249963e+20) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.2878992386691317233650280229501059439672e+32) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.9220148535550013841178909002431217446899e+25) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.9221348753787545474860643398070653059676e+25) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.5390449004319480159890077839285513936507e+20) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.3363659929442474048566303173372017820136e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999192610006645582355237500153234811346e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000080738971854942189268037019992863657e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.3363647256338999321058979533083325823005e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.5390866988342028750743196261198953556134e+20) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2878998875979800279018370314919457062820e+32) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.0711803994750853839083146225492182724767e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.0714708483638810139918633881927581467483e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-8.4643741479058903134659249226239140845549e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999192610225023213731827062711173417168e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999804614234040418135e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000019538569945766207e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000080738946829173435432559203799636555e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.6644752986868965367675805701290543976535e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.5366436995082612186498020802304992047523e+13) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3330910932795764833645177684409751545065e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.3332292773301276800735433617828437541300e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192615014186768547135055592490735483e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885345186909406795913187159e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580494834e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841949890e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611462590112318013139178455e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739452140841028114825387231952701e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2192852220847980380868891238549343426035e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9996078824247148513525976118996929472380e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999407511661861585935868671625971733734e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999383988113642904578379463429174e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999941927007368771711371095e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999985947e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000001405e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000005807297057227959423072e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000061601207344469870799301803571e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000147841669433862042774175420419527497e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999412656404885279088652751798014611168e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999987798434761797776090716867711745401e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999990631783694465691235990628686e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999116834907200020583300e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999786e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000021e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000088316475733084889336e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000936821358192741650008751585e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000001235706502837158788012980704098316e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000172669352710517331076263008096896045e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999215861441587244690696432009755280601e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999412728885467038972920803292904825160e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999928290663293182121366722540709868255e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999998868746777153304962982099091263836e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999136386657485236274313926946e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999918585018794862944468e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999980e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000002e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000008141495027976054487e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000086361308386364696172667582e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000113257553766394924274039194501118e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000007744367591840677468324873654119851e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000173510448647987669633909903271853347e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.8458289018772963897493563981348248092194e+148) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999412731385682444461258790953847365091e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999570920115327669176980631090305912797e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999951472552745256977795814854539690586e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999243503771209107755859857067550073e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999422592680543527638450444873e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999945566373584008137700e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999999987e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000001e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000005443360573944846745e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000057740714635315354995553864e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000075708734269642368671880440484336e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000005108667543477149845585829699042013e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000078915823484253976834768582664155019e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000173539905705303799920256351960020710e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(9.9999412736224723381450047847033853372842e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.9999986666425537919351217077756627815142e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.9999991064943480849541168783165899707456e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.9999999172861176284474384993569983238587e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9999999987415711304035621711408226358505e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999999999990398536017536441110123615e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999999999999094846071908375551e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000000000090515358427006215e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000000000000960146109837440199720575e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0000000001258445215254250085616005275049e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0000000082784557593461663083800730882870e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0000000901822228481886048820873823565156e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0000001351963658610685357675762521074858e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0000173598247175938703710640083883111602e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0109094224272151303988014814553997673490e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0001649545517887159366603374690573662205e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000001258437439360448462253282858406e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000000118636032327170916454700e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999999712905e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999998813640127365742822263119e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999987415629388324826727898729549580e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9983507479575979047631004765789420062773e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8921747199685163253134378367687957729556e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.9534401800175702356342135988942057258383e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0099723297916363082957671740298043975052e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000075679158269279938128905491713381e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000007134462747269413999539078e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000001726517e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999982734832e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999928655399627471442616884218e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999243208650818521205969126476000905e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9013381220732331476082859205612887000225e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.2939266706399734744405244904557238966320e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.7595844584332953201311826806114373837590e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0149550897320107535265123228411694134864e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000113191422930675286918703601062810e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000010670837348662479218573038e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000002582309e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999974176921e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999893291667046414567367837864e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999998868086124531282741911067419944369e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.8528236378874398409588890746838788919491e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.9069037823424334283037780008208944027355e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9591990407537692912591730290884063419410e+10) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1758283308299310671553612055460739844683e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000001227865917320723669164669723322633e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000115753971122744516184302754e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000028012094e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999719879155e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999998842460728462548639086520081e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999987721346142858479669080711409689875e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.5221978047974009153823615460163717164199e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.5839484262392993786018375143563573885567e-20) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.9322611050966779790413152599694965642572e+05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739344426519310534585946838727201e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611464147495347885594549957e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950194e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580504331e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885387437161728273730270030e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192614220023471509990236918960494335e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0787583831074693524844541778913000641814e+26) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.7924876824195627916346624706072656119101e-25) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.6204841884449402746438079169891540639916e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1581356267611274419427822665056438169193e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000009976135669575787764792903319886743e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000002414193205737519e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999975858076159624763e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999900238681196905618035955585624644467e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-9.5831087346278540583863766335901968852984e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.6696454742010688987042281351917518047910e+21) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.9621061085051740344921081003853356964516e-18) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.9008557690708718707458665866787772471921e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1224226270022028400048966105144234348187e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1582235404538065180659611849299589624318e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000025608674201437729573606e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999743913345147857350060045e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5822313850549833784561814493442389563525e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1226084981039119467296725461990202676127e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.7709885857000861565690415431586940122984e+28) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2240268072640055208667818797641205204558e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0251735150946513671288678539398371774957e+27) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.6381706865496111932757807000841053918523e+26) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.3728817744768935954177984561217577012314e+19) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1582235265335412172785185225084181500875e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-9.5822316635430428419296295498116109280910e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-4.3728801135117345992739897142357927816187e+19) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-4.6389388416507077667023254358073459267248e+26) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.3182304240310386111955507651517747898838e+46) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.2240271544411420427344974863051131515943e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.0251740895052261666062322383860948408425e+27) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-4.6381720020982642945041179041689040983672e+26) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-4.3728830147802626080377128600547733030863e+19) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-9.5822382668302451429459561414629040599967e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1582234665036854216849422305946158923176e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.3728813538146325040433816070868273371248e+19) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.6389401574172367239337524395381547857181e+26) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.3182324997390769845016771999523614205344e+46) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.9621061084978097608591966332143939545730e-18) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.9008557690056829214279051418730328139537e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1224226070022030951382602129533404682026e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5822354045380651806598386041308891553926e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999743913257985622704263944e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000025608665485214264993996e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1582231385054983378455954694685202555390e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1226085181039116915737526359066229725027e+08) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7709885856819610463623444887413017869459e+28) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.7924147387040917476889618880784154841040e-25) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.6198334554931051753419375761576962370697e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-9.5813589419037828268278825695988511038409e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999900238618331469537371822271286679248e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999975858061899293020e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000002414192988370497e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000009976134377585743610819063369239573e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1583111358330114214873359960183975415535e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6694646410303768492536142117425727732807e+21) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4583382907829220424377155917402641453194e-25) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1908794925218832108914299974680062129210e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613283913306040085565426868053927e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885328038546942633717315300e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580490684e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950305e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611464304945160864977384326e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739315491905871077389893903647989e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2455986372531774679444427520570163704985e+05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.4763564499865138029208419952564276956993e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.5220119081590914260902608766421068213348e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999987721337666445381193188342477397787e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999998842459837515716377325608015e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999719878950e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000028012095e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000115753972279414732068365451e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000001227866027024942029478689172502233e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1758014997632850899549421069941902589220e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0203018787965531027348538555423647310315e+09) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4334630699108261465135076995468442216671e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.5352964352206162032924250956951450875493e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.9066492098309929784010961745516991521875e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8528234661115999741465744050341684783044e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999998868085784514492439140581574785848e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999893291626513375330647858748e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999974176912e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000002582308e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000010670833295358555546565795e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000113191388928995426286182377852958e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0149550719542229523618701366796286889354e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.7593398153135405972574806049760015073008e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(6.5191545777443431219182761591640935980843e+09) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(5.4846578690815681686391793280694712361528e+189) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.5372895490856658475291577333281474334585e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.6089009335450208783286975549563454638970e-03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.2938172553569010865788299865129376146993e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9013380327136000106000043536586119422379e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999243208132541453624782536184929331e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999928655345099280599767687473e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999982734820e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000001726517e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000007134462780054350893747656e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000075679164630384556297255514625855e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0099723283628552871533764735064185901690e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9533916775519527519998468758691821061572e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.0852528855979222614303050241200761407873e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(6.8553544429880638930361953209086397601245e+09) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(4.5412376469189542524685465484616389852634e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.3965892435303328102575550026414897522046e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8948793511162720094596511475996135984004e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.8921747189431365437995998734778332297365e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9983507479573578076339204664646620926830e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999987415625608103891134351602561043e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999998813639676728290850635853e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999999712905e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000000028710e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000000118635987263425719291972e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000001258437061338354800262767511448e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0001649545517646970542498659624543083975e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0109094223220700619973170755754662519475e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1254684449921297261409553600113801838951e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1938676083828717938039887343812382784766e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(7.5983571014458888968443891692681849365294e+09) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.0410622213285824781808596290591935466625e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0109048089007092721705736201528674968157e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000082749226436868428632721047035423e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000007800975682670320122877756e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000001887811e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999981121893e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999921990272805203250807232782e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999999172507991057401127307544261936065e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.8921296264870448993700877197846879767030e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.9023968682392296442246715477852218163045e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3908956691115386406053484837381636959356e+19) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9203321506341361694945215474243447848370e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000004976324700261603008752893438135254e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000469130409274657996324361339e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000113528072e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999998864719668e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999995308697689239501948863152830e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999950236792740429612909728010529748149e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2101953585695571199341969902712471748912e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.1504853514279591724903298508288224329034e-19) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1600426748146864988271497068270571330398e+29) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.6541746026162066424211605643755607584325e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000007442965211180645754699880468999907e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000701666610369134471011843817e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000169801095e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999998301989625e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999992983336561580796567585593223e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999925570425714212138236320045936547361e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7722106110102309277834538761765912986411e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.6454529668653225251256038274393408602072e-27) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.4194224783124451525975099792436334363761e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739300575876448027364415663592422e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611464208539451622300736011e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950209e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580504183e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885386826713013484176235892e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613768574845780405036766448103547e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.8303232124344350585889156010596822650056e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.8949135427204602830272223645087641948118e+20) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0005310523778076892376262640077373931980e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000500495891180217823657692653069e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000121118418992e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998788816222325e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999994995042989589757332114230166063e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9946924561343323687189045720461215321889e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.7615485073657634460338655945172417378877e+127) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0242275139736275273158596965976428396539e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.9332373579947582975663653453483425884085e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000655986130033650503197519691848922570e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000158746563938424912e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999998412534900928972343e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9993440141185157028770490539911319947891e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-6.9836886429884393495973266396368730264088e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.9515902682404798623506784218735084712842e+108) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.4541812625943478575324272967153520665431e+07) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.3438589173416181579357063612104170364684e+09) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.9684054187419032886218282378571239007324e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000001683912052620871382964155e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999983160885205190588567057288e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.9484027822422098933459800825493182781071e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.4185893793090710865419198142708946945795e+09) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.3733564859936224056427111097857564097043e+115) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0802805023771564769877790194036265831472e+26) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.0346921592604606546705396021332247118803e+28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.8754117699922759084793286180102915751050e+21) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.9684053304748962409406930219983610835264e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-6.9484029620970825181186139551996406702671e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-2.8754106805153348910773403225017146608820e+21) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.0655729204029401047061806138656409930467e+28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.0468813971249919057990937215319190592879e+134) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-3.0802813760532542168847561734335942136433e+26) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.0346930200060977803849542768063016409810e+28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-2.8754125855603816908853942053489897773666e+21) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-6.9484073041238580579353340009634106979558e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.9684049357453725797050477153417859452984e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.8754114960831316594344094028117059963108e+21) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.0655737899074493102127048503226138889923e+28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.0468822613279264314381326516187659483564e+134) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.4541812631970900218483746717464485919543e+07) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.3438589153417202871534259840367671610618e+09) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.9484054187419032886309278069565149799828e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999983160879473791286170358450e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000001683911479480941143294271e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.9684027822422098933368805203584973585914e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.4185893813089684384358137141427396145969e+09) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.3733564858847650222699443903869630414501e+115) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.0302566947327271920626121952084687960013e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-6.9132401123472149108973610921097977955230e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9993440137057565404110876088976717769186e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999998412533963233240497e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000158746549645340278e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000655986045694025791388085658388597818e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.0036893672031266083152692334112974868193e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.9505034344267708153286745338885759607384e+108) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.2392144198276182790797972797452209333184e-27) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9946923039357798670430614079617897147635e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999994995039083789124173914763429702e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998788815324962e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000121118426280e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000500495901532115731880717561357e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0005310375670848589387991660319340308809e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.9672818563060282037562310703234605584812e+79) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2650166658145156441980438804801659643263e-256) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5937022709362793716542216415300517293373e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613206082831382421408787991527554e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885328242028056575501060102e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580490733e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950300e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611464284596915021811257544e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739307277047532821745363266010646e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.0316121788149278848166693987619078470513e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7221708686305837282768235052231724607882e-223) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2668246588671299530348286037446633690556e-27) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.7719467067564824489600454218138357442881e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999925570403352227555884744118723407674e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999992983333896309148215534295624e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999998301989047e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000169801037e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000701666343841969635769266628e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000007442962974978854742055966579734767e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.6539880465330031019575427128144552875324e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.1274062177887042545147150859519087406363e+28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.2081493863678056872775789031891763875564e-222) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.6952530936397890598449060099124968323977e-162) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.5875399540252281415084291277152344305379e-19) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.2100850247706591568121541177613897640449e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999950236758659660799606750137487694909e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999995308694103709183358662416661e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999998864718845e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000113528077e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000469130411430449034899996564e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000004976325118419633732599697959533093e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9202923219499470631313863249985771525677e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2576730662090780106918475893613022390492e+19) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.0771450808972125547568401728133014322665e+284) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4638310240136882585673741309747551987515e-220) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0217000053338731895982315508475043558835e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.5255077097759286349037378700579986793855e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.9023948290119817423087792520223005836764e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8921296255337820317634027208426794267336e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999999172507742486950569191467906972804e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999921990243173296859699323804e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999981121886e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000001887811e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000007800972719479681012082229e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000082749201579822960948257663915896e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0109048088032875721406860121951913401126e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0410613694119538416426798247241222942213e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.3737742473658323781006082903962515848858e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1488674582057379158759495971724163501831e+05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2973950674201518839521689024030222128853e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1248522799451155287860373514195742914059e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000000897638401595341833627145577220081e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000084622604450655894796105813e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000020478402e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999795216050e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999999153774276931329275797138789e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999991023619486306963091427112161833112e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8900698989141590803863631919490770699037e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.3818259407652752422176289076006656363595e-04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2121218749615875016016180430387958443136e+210) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1870441101546576350149515179774376466780e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000053981784553774826637361443485171843e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000005088983567532862524031255183e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001231517890e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999987684825289e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999949110183655136292614782734619e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999460185231099310020458295622741489424e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.4918686419497797253187001856924967766130e-04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0117585116998517864773832720643123877382e-195) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9837153767732087415698734638097525132071e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739311985099935563920722717834177e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611465339832336561103691485e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580501445e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885375513788356247064198793e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613642662337125569468188468848335e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5624835348725691808150812666068898864051e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.5518837326510358368412134000940923401640e+52) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000875870149736646423008532755473517344e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000082566841791704207366649704523e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000019980913960e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999800190928404e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999174331895718874292218727535347e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9991242068912263144091127211580664659628e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-3.2723735180558318512565375900098558500702e+30) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0057766203733954149084240214266298610411e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000005429226748344363200766066841892e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001313855661003e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999986861447861840e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999945707753170517901758345065166108e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9425839003089835794941778795310953411203e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0555810992607735674211889848448427787921e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.1426977639581600474244550589798156432632e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0007115937390971491436240662314123348380e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000001722034298594769123e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999982779662875205308003e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9928840652384088566511489105422145458280e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.9689749289043178316731972136484771551235e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1195457863257832666169295308263733446373e+09) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.5755975443480636762723672530643220963570e+10) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(7.5492658906564832683587433989910897223998e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000018266564254927908268830860e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999817334419623192136893639102e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-7.5472631015270996967699361070150846623052e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-8.4541838855551960691065726771152360165829e+10) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.6262828008419667501959664426780832490578e+27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.1304531760662430194019392440878742365844e+29) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1191589565284463039654203831420648719242e+22) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(7.5492658303396676391570816797485389211529e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-7.5472632611956647216858366310565927561382e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.1191578039805599804098066416715139477827e+22) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.4935101345223686827444444360103891257384e+29) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.6262841130187965426648127126209363912993e+27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.1304540639730790729134199198400802204373e+29) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.1191598412318436949312405879892161507937e+22) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-7.5472679712938535534531881215534460231067e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(7.5492654021491219362075983138748580307022e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1191586886836304681803586499952556841342e+22) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.4935111254049520672130560115940786898033e+29) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1195457862942791157224254781443942712094e+09) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.5755975441492345510967806893537744837947e+10) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-7.5472658906564832684657040161888603479668e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999817334357450720917311691404e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000018266558037680786310636090e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(7.5492631015270996966629755705218121156047e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.4541838857539591632433517083871222189262e+10) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0552663219500381119902417579917525519279e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.1407112604541486430381544552212860625388e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9928840608277296306860879608004680824451e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999982779652703368061113e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000001722034143547747246e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0007115936542887223814793173760205880057e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.9709645549289834768585101909685932608956e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.1840376852681404505761290203750025373419e-36) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9425664992346826732969055161372119126419e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999945707710800175441741308046898237e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999986861438127524e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001313855740061e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000005429226860497722764110252000722e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0057748645172470029861143127075400563284e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1157744193838374835525149244289984989871e+300) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.1533915170421212878970301946306427914121e-53) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9991242062255078487038531647625015109924e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999174331260210078707018315256371e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999800190782503e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000019980914949e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000082566842616751874231877896202e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000875870166832144621629762362461408034e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2028619149750373021628732063394243731135e+48) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.4192138716940028104555696502787422355483e-299) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5414967539100306288668912686077246127203e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613399652575718023915109131609531e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885346601734575189892103159e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580495176e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841949855e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611462448626958450984734926e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739287683731341055233682021435681e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9509364734387000939617098114466170029316e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0032429667847095919011682828648696483657e+306) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.5347822769482913979848151259572882034817e-200) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.4709832978686350417885298087215300689668e-04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999460184861273162524410371094879592355e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999949110144760397192375066295458e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999987684816363e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001231517945e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000005088983590918225952158660371e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000053981789076830094429415135260978335e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1841219586674944205990228986919786374600e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.6050347972430570278329285877095894167278e+204) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(7.2475294111071723113456400331460892905096e-55) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.2551344625929703982485534992019439618619e-37) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.3816116986594017350276049358711490823832e-04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8900697982137754953463446289123537871953e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999991023616789890165179137476941950731e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999999153773955493448213814703279e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999795215980e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000020478395e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000084622572306867788597318184e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000000897638131953613628913698259923895e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1248522672029276038866648007569769698268e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.2972823557081306757710045612855780917209e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.1169901043565987597176755436359498671186e+36) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(7.7562480692818616388370799738689280416912e+54) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0649353629891894639698322819216101559729e+05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1924007501170835875599208882182710821759e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000001342575124273725249334971476884738e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000000126567892992627025246531927e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000000030629029e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999999693709816e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999998734321550840269064567310931e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999986574254592866355813689903572591072e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.3864616056378495624756679908407221221591e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.4845389687978936289930630688319167685280e-06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9700878848467001873788112795830971311425e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739300291706765947776044103729473e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611464239349870785659560532e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950216e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580504109e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885386518608830282963132498e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613759196791147852107139934037426e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5537785029049291640736593934471838891041e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.3306053493577640525344428888701227291210e-291) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.6184845556353527376396905783430868010146e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000120759992154541483051576286519618579e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000011384276540565651490440147581e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000002754958832e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999972450421053e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999886157277837501991346125172059e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9998792415026148461957014504256881628712e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3619800381906088234694546507472374261283e-07) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.5690504365426362969921815078969222133578e+81) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0001310045328968838300476331389063811273e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000123493140686146353360194735938e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000029884948548e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999701150616235e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999998765069062240916298332532694565e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9986901268136447934857024453025831075767e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-3.5365868948162564439520200377755512905874e+32) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0086529906254297505166056279893767234302e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000008120357375852616942758976570457e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001965100740979e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999980348999278670e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999918796457156146397165432725479759e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9142532536085028421059095470644863476625e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.0520314013762178177545098568834521192694e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0389479031387567425814221933329748872204e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0010643127870868790371259856444998460761e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000002575603223855709294e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999974243976527821470285e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9893568760072707898995442014416657093126e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.2240687659249351829998772396852957608649e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2985180496113789579829578876308484948646e+08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1019644374470399531194010421535686814745e+11) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1290750691104569538114669109151895789186e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000027320838976408233846229212e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999726791703225713183557041972e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.1288746577346231691331000291869960483711e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.2985416042342921655232448218489744140594e+11) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.7762703736935116589964038009583389151648e+27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.5536316481149268658612979637151235038109e+29) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.6652472892776406747241574200232823873979e+22) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1290750629826273819680649480692149515922e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.1288746787222452360638701017484629297858e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-4.6652455893552544783965341934436199692687e+22) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-5.3659446208918567315838112170677757523391e+29) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.7762708775063843574061061105785696814184e+27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-4.5536329396853295612262346524235653388558e+29) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-4.6652486125061724731105479185426837534892e+22) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.1288753831997396583046270813649991588431e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1290749989392485226149467283242628161793e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.6652469125833041188903384731119917877069e+22) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.3659461428628439359066197686364180027373e+29) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.2985180496689958858337575734969348044766e+08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1019644374272983143835205366241480998264e+11) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.1288750691104569538353935851706579313182e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999726791610235917661537707883e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000027320829677428681644295803e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1290746577346231691091733729234852954530e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2985416042540117114493432904690246866273e+11) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.0526085850575074140600543783883531800484e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0387507468014372109458234481254229351396e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9893568694648866647486311845061363718800e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999974243961314061310569e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000002575602991955793176e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0010643126656967998851196883212381483327e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2242662678240252014501461735480378163472e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.9152947795400589592336084401309910776723e-38) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9142144699264605929785588351130732194881e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999918796393782744503671689613690156e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999980348984719299e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001965100859224e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000008120357543482522742078217649456e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0086490510570723147764181494502154526545e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1241579445168166472351530857161350070467e-81) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9986901257725917362933945881402493679500e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999998765068111726451530923338630311e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999701150398014e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000029884950027e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000123493141920148915029787654416e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0001310045309129375459675227293050606650e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.8353667415886512095706895256479043826228e+70) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1491752344241788695634022364406739873951e-452) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3371538145639919503254618210291063963214e-07) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9998792414662330658605209222160792212065e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999886157234594473096414981884591e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999972450411676e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000002754957895e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000011384272216262761987479281912e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000120759955771882384940185807637529840e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4789699466716286697615583448624789490557e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.6074572034901746037075361346252544487228e-300) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5397548629941407512467698540051393014167e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613205952331508978077364941932950e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885328344729540565237524952e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580490758e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841950297e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611464274326768355580558401e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739307046113469421223122352245722e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9482509594803086641470108720855284398445e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.7102652364620518559286929269741242896961e+304) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0530121007571345005149269415531280401824e-81) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.4560987451966735814436156101526713161187e-55) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.4835016524173429262872140666663667438951e-06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.3864613931357885620152070597832484045665e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999986574250559903518800203011939341170e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999998734321070073745768148663978e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999999693709711e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000000030629018e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000000126567844915974695603450150e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000001342574720977333248890311679466576e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1924007199016251569607374570651490549967e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0648184933050320855696903149348760677539e+05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.7883887829085401061724444178285709821694e+54) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2443223081280172645489838898055283465009e+82) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.6001459967723875162267062845450706603947e+302) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9432557229710071725463169407891939440692e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0000080739307015403637284027035863598503e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000007611464876921845822500007077e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000001841950370e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999999981580502566e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999999923885380142891494724218323014e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9999192613691172276708124080431383647553e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5365565406098395042746041464064191377146e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0355605840343245776475332458764247583323e-302) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0352272956684766365309976068364634901172e+281) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0004856611559574302884436032578980629440e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000457733721809016088533589714007e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000110770109569e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998892299281329e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999995422664520815059652070683328703e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9951457475397209192352623487095928663268e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5647599186952743947442978288756817247217e-273) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0007264786702230002468708818219169549317e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000000684620870204524172156299657844e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000000165676080201e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999998343239761893e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999993153793898947121061462426144668e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9927404897532598271934942384826832396695e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0079088926392567824927902809469582335866e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000007426557249169662626362463966652e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000001797203309979e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999999982027973017208e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999999925734455773183990813611413333039e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.9215321874111206900443371625259488586984e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.6917453107914077488155825343234409674085e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0000000488337247774353719586734955324562e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000000000118176062790582e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999999999998818239774320771e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.9999995116629628885934597967804066982194e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.9998155583788585565633452230680350325599e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-4.5949718245361151114184587545041911292080e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0640049818347586528987246971838808005634e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000000000000154890098995320003496e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999999999998451099537234074352819e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3599498293997622378642385139617218819917e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.7243575592037553943420004366954694387066e+07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-4.8741539146475216029723665507661894229232e+11) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7893702019546127143763928390314544715586e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.0000000000001643004409412145866918907357e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.9999999999983569961498043708913718435510e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.7893539384003036095886632151054235349660e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.8290796824608032482258266745747887295678e+14) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-2.0141395465671777444950784377655180190826e+30) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.8055574604543653324734158977256621025108e+24) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7893732702807647711518075801686201999067e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-6.7893509594384704576963840755113911337243e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-2.8055590044603941525998569974989072297741e+24) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.5582794199152563791540640987991712663453e+32) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.0141401178481302390465148361310468208133e+30) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-2.8055582562093273053168522016478830029429e+24) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-6.7893551959834413747232776054001247483155e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7893728851404916249604691026578576800515e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.8055598002157940599629312776448652137109e+24) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.5582815637096491700699021924404217275460e+32) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.8741539146503031621683817187922115128395e+11) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.7893502019546127230288629926305868496325e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999983569955905878541330810926432e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000001643003850195629108628156449e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7893739384003036009361956105538269892648e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.8290796824530441508362119089713695205582e+14) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.5950007903684897096829443288669639798311e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3599500214232199852350645542771384571553e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999998451098622317989684385e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000154890085049460395962e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0640050330812214485669225932069526430923e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7242803998701197650668664301258321474812e+07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.9159782685389816916590913648432099656137e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999995116625805428641692798398880675938e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999998818238898757930e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000118176069901532e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000488337256620639695747634027005406e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.6678316937861867696400884793170285016543e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9215316418737149226523245135972225469657e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999925734398611665631682676581261943e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999982027959893966e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000001797203398903e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000007426557323375046576473056304090e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0079088434099102584941115483587237061025e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.3454325098384925826197781329328162278603e-430) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9927404871854877360854293883769165356657e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999993153791298423464592157746054003e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998343239197994e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000165676023811e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000684620610152158489618339138857e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0007264784130725688212246595368628008928e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6440079570631358173132305943598176997699e-281) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9951457441002139080866428718275237747073e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999995422661022388801920803935631325e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999998892298478461e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000110770114452e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000457733723912434994779303043302e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0004856611851823525195328509863604944085e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1135857820542275762062982236299021203795e+272) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9726839879958746145355313362044604125177e-303) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5363241241342035331594199304277749557031e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.9999192613448637029913157605341084793554e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.9999999999923885351230839476243681814012e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.9999999999999999999999999999981580496296e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.0000000000000000000000000000001841949743e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0000000000007611461985716643970045090242e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0000080739282761487313229375421023837981e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9428943964254881723168603560241682102422e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.7483740769510674849517097791174324335485e+302) }
   }};
//#undef SC_

