#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# Copyright 2024 by Wilson Snyder. This program is free software; you
# can redistribute it and/or modify it under the terms of either the GNU
# Lesser General Public License Version 3 or the Perl Artistic License
# Version 2.0.
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.scenarios('simulator')
test.top_filename = test.obj_dir + "/t_gate_chained.v"


def gen(filename):
    with open(filename, 'w', encoding="utf8") as fh:
        fh.write("// Generated by t_gate_chained.py\n")
        fh.write("module t (clk,i,sel,o);\n")
        fh.write("  input clk;\n")
        fh.write("  input [63:0] i;\n")
        fh.write("  input [15:0] sel;\n")
        fh.write("  output [63:0] o;\n")
        fh.write("\n")
        prev = "i"
        n = 9000
        for i in range(1, n):
            fh.write(
                ("  wire [63:0] ass%04x = (sel == 16'h%04x) ? 64'h0 : " + prev + ";\n") % (i, i))
            prev = "ass%04x" % i

        fh.write("\n")
        fh.write("  wire [63:0] o = " + prev + ";\n")

        fh.write("\n")
        fh.write("  always @ (posedge clk) begin\n")
        fh.write('    $write("*-* All Finished *-*\\n");' + "\n")
        fh.write('    $finish;' + "\n")
        fh.write("  end\n")
        fh.write("endmodule\n")


gen(test.top_filename)

test.compile(
    verilator_flags2=["--stats --x-assign fast --x-initial fast", "-Wno-UNOPTTHREADS -fno-dfg"])

test.execute()

# Must be <<9000 above to prove this worked
test.file_grep(test.stats, r'Optimizations, Gate sigs deleted\s+(\d+)', 8575)

test.passes()
