/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.gdevice.SGraphicsDeviceReceiver;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusMinGui;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.SplusWinSessionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SplusExecCL {
    private static SplusWinSessionImpl g_session;
    private static BufferedReader g_inputReader;
    private static boolean g_quitRequested;
    private static boolean m_sigintReceived;

    private synchronized native int JavaMain(String[] var1);

    public static void main(String[] stringArray) {
        if (!SGraphicsDeviceReceiver.checkServerDisplay()) {
            System.out.println(SGraphicsDeviceReceiver.BAD_DISPLAY_MSG);
            return;
        }
        new SplusMinGui();
        if (SplusGui.getSplusUsePipes()) {
            new SplusExecCL().JavaMain(stringArray);
        } else {
            try {
                System.setProperty("splus.interactive.commandline", "F");
                System.setProperty("splus.print.startup", "T");
                g_session = new ExecCLSessionImpl(stringArray);
                g_session.startPollOutput(new LocalOutputHandler());
                g_session.addListener(new LocalWinSessionListener());
                SplusSystem.setEngineQueryHandler(new LocalEngineQueryHandler());
                g_inputReader = new BufferedReader(new InputStreamReader(System.in));
                Signal.handle(new Signal("INT"), new ExecCLSigintHandler());
                while (true) {
                    String string = SplusExecCL.readInputLine();
                    if (g_quitRequested) {
                        System.exit(0);
                    }
                    g_session.writeSplusIn(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static String readInputLine() {
        m_sigintReceived = false;
        int n = 0;
        while (true) {
            try {
                if (g_quitRequested || m_sigintReceived) {
                    return "\n";
                }
                String string = g_inputReader.readLine();
                if (string == null) {
                    string = "";
                    g_quitRequested = true;
                }
                return string + "\n";
            }
            catch (Exception exception) {
                if (++n > 100) {
                    System.out.println("SplusExecCL.readLine: too many errors (" + exception + ") -- exiting");
                    g_quitRequested = true;
                    return "\n";
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception2) {
                }
                continue;
            }
            break;
        }
    }

    static {
        g_quitRequested = false;
        m_sigintReceived = false;
        String string = System.getProperty("os.name", "unknown").toLowerCase();
        if (string.indexOf("windows") < 0 && !string.startsWith("mac")) {
            try {
                if (SplusGui.getSplusUsePipes()) {
                    System.loadLibrary("SplusExecCL");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class LocalEngineQueryHandler
    implements SplusEngineQueryHandler {
        private LocalEngineQueryHandler() {
        }

        public SplusDataResult processDataQuery(String string) {
            SplusDataResult splusDataResult = null;
            String string2 = "";
            try {
                splusDataResult = g_session.evalDataQuery(string);
            }
            catch (Exception exception) {
                string2 = exception.getLocalizedMessage();
                splusDataResult = new SplusDataResult("", "Java Error: " + string2, string, new String[0]);
            }
            return splusDataResult;
        }

        public SplusDataResult processDataQuery(String string, int n) {
            SplusDataResult splusDataResult = null;
            String string2 = "";
            try {
                splusDataResult = g_session.evalDataQuery(string, n);
            }
            catch (Exception exception) {
                string2 = exception.getLocalizedMessage();
                splusDataResult = new SplusDataResult("", "Java Error: " + string2, string, new String[0]);
            }
            return splusDataResult;
        }

        public void processDialogCommand(String string) {
            String string2 = "";
            try {
                g_session.evalDataQuery(string);
            }
            catch (Exception exception) {
                string2 = exception.getLocalizedMessage();
                System.out.println(string2);
            }
        }

        public void writeEngineOutput(String string, boolean bl) {
        }
    }

    private static class LocalWinSessionListener
    implements SplusWinSessionListener {
        private LocalWinSessionListener() {
        }

        public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
            if (splusWinSessionEvent.getType() == 32) {
                g_quitRequested = true;
            }
        }
    }

    private static class LocalOutputHandler
    implements SplusOutputHandler {
        private LocalOutputHandler() {
        }

        public void write(String string, boolean bl) {
            System.out.print(string);
        }
    }

    private static class ExecCLSigintHandler
    implements SignalHandler {
        public void handle(Signal signal) {
            try {
                m_sigintReceived = true;
                g_session.Interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class ExecCLSessionImpl
    extends SplusWinSessionImpl {
        public ExecCLSessionImpl(String[] stringArray) throws RemoteException, SplusLicenseException {
            super(stringArray);
        }

        public String getPendingInputString() {
            return SplusExecCL.readInputLine();
        }
    }
}

