/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.InlineCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class Inline
extends InlineLevel {
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int verticalAlign;
    private Length width;
    private int wrapOption;
    private boolean blockOrInlineItemFound = false;
    private boolean canHaveBlockLevelChildren = true;

    public Inline(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.dominantBaseline = pList.get(82).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.verticalAlign = pList.get(234).getEnum();
        this.width = pList.get(241).getLength();
        this.wrapOption = pList.get(243).getEnum();
    }

    protected void startOfNode() throws FOPException {
        int lvlLeader = this.findAncestor(19);
        int lvlFootnote = this.findAncestor(12);
        int lvlInCntr = this.findAncestor(16);
        if (lvlLeader > 0) {
            if (lvlInCntr < 0 || lvlInCntr > 0 && lvlInCntr > lvlLeader) {
                this.canHaveBlockLevelChildren = false;
            }
        } else if (lvlFootnote > 0 && (lvlInCntr < 0 || lvlInCntr > lvlFootnote)) {
            this.canHaveBlockLevelChildren = false;
        }
        this.checkId(this.id);
        this.getFOEventHandler().startInline(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endInline(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("marker")) {
            if (this.blockOrInlineItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(#PCDATA|%inline;|%block;)");
            }
        } else if (!this.isBlockOrInlineItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else if (!this.canHaveBlockLevelChildren && this.isBlockItem(nsURI, localName)) {
            String ruleViolated = " An fo:inline that is a descendant of an fo:leader or fo:footnote may not have block-level children, unless it has a nearer ancestor that is an fo:inline-container.";
            this.invalidChildError(loc, nsURI, localName, ruleViolated);
        } else {
            this.blockOrInlineItemFound = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public CharIterator charIterator() {
        return new InlineCharIterator((FObj)this, this.commonBorderPaddingBackground);
    }

    public String getName() {
        return "fo:inline";
    }

    public int getNameId() {
        return 15;
    }
}

