/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class InlineLayoutManager
extends InlineStackingLayoutManager
implements InlineLevelLayoutManager {
    private InlineLevel fobj;
    private CommonMarginInline inlineProps = null;
    private CommonBorderPaddingBackground borderProps = null;
    private boolean bAreaCreated = false;
    private LayoutManager lastChildLM = null;

    public InlineLayoutManager(InlineLevel node) {
        super(node);
        this.fobj = node;
        this.initialize();
    }

    private Inline getInlineFO() {
        return (Inline)this.fobj;
    }

    private void initialize() {
        this.inlineProps = this.fobj.getCommonMarginInline();
        this.borderProps = this.fobj.getCommonBorderPaddingBackground();
        int iPad = this.borderProps.getPadding(0, false);
        iPad += this.borderProps.getBorderWidth(0, false);
        iPad += this.borderProps.getPadding(1, false);
        this.extraBPD = new MinOptMax(iPad += this.borderProps.getBorderWidth(1, false));
    }

    protected MinOptMax getExtraIPD(boolean bNotFirst, boolean bNotLast) {
        int iBP = this.borderProps.getPadding(2, bNotFirst);
        iBP += this.borderProps.getBorderWidth(2, bNotFirst);
        iBP += this.borderProps.getPadding(3, bNotLast);
        return new MinOptMax(iBP += this.borderProps.getBorderWidth(3, bNotLast));
    }

    protected boolean hasLeadingFence(boolean bNotFirst) {
        int iBP = this.borderProps.getPadding(2, bNotFirst);
        return (iBP += this.borderProps.getBorderWidth(2, bNotFirst)) > 0;
    }

    protected boolean hasTrailingFence(boolean bNotLast) {
        int iBP = this.borderProps.getPadding(3, bNotLast);
        return (iBP += this.borderProps.getBorderWidth(3, bNotLast)) > 0;
    }

    protected SpaceProperty getSpaceStart() {
        return this.inlineProps.spaceStart;
    }

    protected SpaceProperty getSpaceEnd() {
        return this.inlineProps.spaceEnd;
    }

    protected InlineArea createArea(boolean bInlineParent) {
        InlineArea area;
        if (bInlineParent) {
            area = new InlineParent();
            area.setOffset(0);
        } else {
            area = new InlineBlockParent();
        }
        TraitSetter.setProducerID(area, this.getInlineFO().getId());
        return area;
    }

    protected void setTraits(boolean bNotFirst, boolean bNotLast) {
        TraitSetter.setBorderPaddingTraits(this.getCurrentArea(), this.borderProps, bNotFirst, bNotLast);
        if (this.borderProps != null) {
            TraitSetter.addBorders(this.getCurrentArea(), this.borderProps);
            TraitSetter.addBackground(this.getCurrentArea(), this.borderProps);
        }
    }

    public LinkedList getNextKnuthElements(LayoutContext lc, int alignment) {
        LayoutManager curLM;
        LayoutManager lastLM = null;
        LinkedList<KnuthSequence> returnList = new LinkedList<KnuthSequence>();
        KnuthSequence lastSequence = null;
        SpaceSpecifier leadingSpace = lc.getLeadingSpace();
        if (lc.startsNewArea()) {
            this.childLC = new LayoutContext(lc);
            if (this.getSpaceStart() != null) {
                lc.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart()));
            }
            if (this.hasLeadingFence(!lc.isFirstArea())) {
                leadingSpace = new SpaceSpecifier(false);
            }
            this.clearPrevIPD();
        }
        StringBuffer trace = new StringBuffer("InlineLM:");
        while ((curLM = this.getChildLM()) != null) {
            LinkedList returnedList = curLM.getNextKnuthElements(lc, alignment);
            if (returnedList == null) continue;
            if (curLM instanceof InlineLevelLayoutManager) {
                if (lastSequence != null && !lastSequence.isInlineSequence()) {
                    lastSequence = null;
                    if (log.isTraceEnabled()) {
                        trace.append(" ]");
                    }
                }
                ListIterator seqIter = returnedList.listIterator();
                while (seqIter.hasNext()) {
                    KnuthElement lastElement;
                    KnuthSequence sequence = (KnuthSequence)seqIter.next();
                    ListIterator listIter = sequence.listIterator();
                    while (listIter.hasNext()) {
                        KnuthElement returnedElement = (KnuthElement)listIter.next();
                        returnedElement.setPosition(new NonLeafPosition(this, returnedElement.getPosition()));
                    }
                    if (!sequence.isInlineSequence()) {
                        if (lastSequence != null && lastSequence.isInlineSequence()) {
                            lastSequence.add(new KnuthPenalty(0, -1000, false, null, false));
                            lastSequence = null;
                            if (log.isTraceEnabled()) {
                                trace.append(" ]");
                            }
                        }
                        returnList.add(sequence);
                        if (!log.isTraceEnabled()) continue;
                        trace.append(" B");
                        continue;
                    }
                    if (lastSequence == null) {
                        lastSequence = new KnuthSequence(true);
                        returnList.add(lastSequence);
                        if (log.isTraceEnabled()) {
                            trace.append(" [");
                        }
                    } else if (log.isTraceEnabled()) {
                        trace.append(" +");
                    }
                    lastSequence.addAll(sequence);
                    if (log.isTraceEnabled()) {
                        trace.append(" I");
                    }
                    if (!(lastElement = sequence.getLast()).isPenalty() || ((KnuthPenalty)lastElement).getP() != -1000) continue;
                    lastSequence = null;
                    if (!log.isTraceEnabled()) continue;
                    trace.append(" ]");
                }
                continue;
            }
            if (lastSequence != null && lastSequence.isInlineSequence()) {
                lastSequence.add(new KnuthPenalty(0, -1000, false, null, false));
                lastSequence = null;
                if (log.isTraceEnabled()) {
                    trace.append(" ]");
                }
            }
            if (curLM != lastLM) {
                if (lastSequence != null && !lastSequence.isInlineSequence()) {
                    lastSequence = null;
                    if (log.isTraceEnabled()) {
                        trace.append(" ]");
                    }
                }
                lastLM = curLM;
            }
            if (lastSequence == null) {
                lastSequence = new KnuthSequence(false);
                returnList.add(lastSequence);
                if (log.isTraceEnabled()) {
                    trace.append(" [");
                }
            } else if (log.isTraceEnabled()) {
                trace.append(" +");
            }
            ListIterator iter = returnedList.listIterator();
            while (iter.hasNext()) {
                KnuthElement element = (KnuthElement)iter.next();
                element.setPosition(new NonLeafPosition(this, element.getPosition()));
            }
            lastSequence.addAll(returnedList);
            if (!log.isTraceEnabled()) continue;
            trace.append(" L");
        }
        this.setFinished(true);
        log.trace(trace);
        return returnList.size() == 0 ? null : returnList;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        boolean bIsLast;
        LayoutManager childLM;
        this.addId();
        this.setChildContext(new LayoutContext(context));
        if (this.hasLeadingFence(this.bAreaCreated)) {
            this.getContext().setLeadingSpace(new SpaceSpecifier(false));
            this.getContext().setFlags(256, true);
        } else {
            this.getContext().setFlags(256, false);
        }
        if (this.getSpaceStart() != null) {
            context.getLeadingSpace().addSpace(new SpaceVal(this.getSpaceStart()));
        }
        LinkedList<Position> positionList = new LinkedList<Position>();
        NonLeafPosition pos = null;
        LayoutManager lastLM = null;
        while (parentIter.hasNext()) {
            pos = (NonLeafPosition)parentIter.next();
            positionList.add(pos.getPosition());
        }
        if (pos != null) {
            lastLM = pos.getPosition().getLM();
        }
        InlineArea parent = this.createArea(lastLM == null || lastLM instanceof InlineLevelLayoutManager);
        parent.setBPD(context.getLineHeight());
        this.setCurrentArea(parent);
        InlineStackingLayoutManager.StackingIter childPosIter = new InlineStackingLayoutManager.StackingIter(positionList.listIterator());
        LayoutManager prevLM = null;
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            this.getContext().setFlags(128, context.isLastArea() && childLM == lastLM);
            childLM.addAreas(childPosIter, this.getContext());
            this.getContext().setLeadingSpace(this.getContext().getTrailingSpace());
            this.getContext().setFlags(256, true);
            prevLM = childLM;
        }
        boolean bl = bIsLast = this.getContext().isLastArea() && prevLM == this.lastChildLM;
        if (this.hasTrailingFence(bIsLast)) {
            this.addSpace(this.getCurrentArea(), this.getContext().getTrailingSpace().resolve(false), this.getContext().getSpaceAdjust());
            context.setTrailingSpace(new SpaceSpecifier(false));
        } else {
            context.setTrailingSpace(this.getContext().getTrailingSpace());
        }
        if (context.getTrailingSpace() != null && this.getSpaceEnd() != null) {
            context.getTrailingSpace().addSpace(new SpaceVal(this.getSpaceEnd()));
        }
        this.setTraits(this.bAreaCreated, !bIsLast);
        this.parentLM.addChildArea(this.getCurrentArea());
        context.setFlags(128, bIsLast);
        this.bAreaCreated = true;
    }

    public void addChildArea(Area childArea) {
        Area parent = this.getCurrentArea();
        if (this.getContext().resolveLeadingSpace()) {
            this.addSpace(parent, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
        }
        parent.addChildArea(childArea);
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.getInlineFO().getId());
    }
}

