/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;

public class GridUnit {
    public static final int IN_FIRST_COLUMN = 0;
    public static final int IN_LAST_COLUMN = 1;
    public static final int FIRST_IN_TABLE = 2;
    public static final int FIRST_IN_BODY = 3;
    public static final int LAST_IN_BODY = 4;
    public static final int LAST_IN_TABLE = 5;
    public static final int KEEP_WITH_NEXT_PENDING = 6;
    public static final int KEEP_WITH_PREVIOUS_PENDING = 7;
    private PrimaryGridUnit primary;
    private TableCell cell;
    private TableRow row;
    private TableColumn column;
    private int startCol;
    private int colSpanIndex;
    private int rowSpanIndex;
    private CommonBorderPaddingBackground effBorders;
    private byte flags = 0;

    public GridUnit(TableCell cell, TableColumn column, int startCol, int colSpanIndex) {
        this(null, cell, column, startCol, colSpanIndex);
    }

    public GridUnit(PrimaryGridUnit primary, TableColumn column, int startCol, int colSpanIndex) {
        this(primary, primary.getCell(), column, startCol, colSpanIndex);
    }

    protected GridUnit(PrimaryGridUnit primary, TableCell cell, TableColumn column, int startCol, int colSpanIndex) {
        this.primary = primary;
        this.cell = cell;
        this.column = column;
        this.startCol = startCol;
        this.colSpanIndex = colSpanIndex;
    }

    public TableCell getCell() {
        return this.cell;
    }

    public TableColumn getColumn() {
        return this.column;
    }

    public TableRow getRow() {
        if (this.row != null) {
            return this.row;
        }
        if (this.getCell().getParent() instanceof TableRow) {
            return (TableRow)this.getCell().getParent();
        }
        return null;
    }

    public void setRow(TableRow rowFO) {
        this.row = rowFO;
    }

    public TableBody getBody() {
        FONode node;
        for (node = this.getCell(); node != null && !(node instanceof TableBody); node = node.getParent()) {
        }
        return (TableBody)node;
    }

    public Table getTable() {
        FONode node;
        for (node = this.getBody(); node != null && !(node instanceof Table); node = node.getParent()) {
        }
        if (node == null && this.getColumn() != null) {
            node = this.getColumn().getParent();
        }
        return (Table)node;
    }

    public PrimaryGridUnit getPrimary() {
        return this.isPrimary() ? (PrimaryGridUnit)this : this.primary;
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean isEmpty() {
        return this.cell == null;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public boolean isLastGridUnitColSpan() {
        if (this.cell != null) {
            return this.colSpanIndex == this.cell.getNumberColumnsSpanned() - 1;
        }
        return true;
    }

    public boolean isLastGridUnitRowSpan() {
        if (this.cell != null) {
            return this.rowSpanIndex == this.cell.getNumberRowsSpanned() - 1;
        }
        return true;
    }

    public int getRowSpanIndex() {
        return this.rowSpanIndex;
    }

    public int getColSpanIndex() {
        return this.colSpanIndex;
    }

    public CommonBorderPaddingBackground.BorderInfo getOriginalBorderInfoForCell(int side) {
        if (this.cell != null) {
            return this.cell.getCommonBorderPaddingBackground().getBorderInfo(side);
        }
        return null;
    }

    public CommonBorderPaddingBackground getBorders() {
        return this.effBorders;
    }

    public boolean hasBorders() {
        return this.getBorders() != null && this.getBorders().hasBorder();
    }

    public void assignBorderForSeparateBorderModel() {
        if (this.cell != null) {
            this.effBorders = this.cell.getCommonBorderPaddingBackground();
        }
    }

    public void resolveBorder(GridUnit other, int side) {
        this.resolveBorder(other, side, 0);
    }

    public void resolveBorder(GridUnit other, int side, int resFlags) {
        CollapsingBorderModel borderModel = CollapsingBorderModel.getBorderModelFor(this.getTable().getBorderCollapse());
        if (this.effBorders == null) {
            this.effBorders = new CommonBorderPaddingBackground();
        }
        this.effBorders.setBorderInfo(borderModel.determineWinner(this, other, side, resFlags), side);
    }

    public boolean getFlag(int which) {
        return (this.flags & 1 << which) != 0;
    }

    public void setFlag(int which, boolean value) {
        this.flags = value ? (byte)(this.flags | 1 << which) : (byte)(this.flags & ~(1 << which));
    }

    public GridUnit createNextRowSpanningGridUnit() {
        if (this.isLastGridUnitRowSpan()) {
            return null;
        }
        GridUnit gu = new GridUnit(this.getPrimary(), this.getColumn(), this.startCol, this.colSpanIndex);
        gu.rowSpanIndex = this.rowSpanIndex + 1;
        return gu;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isEmpty()) {
            sb.append("EMPTY");
        } else if (this.isPrimary()) {
            sb.append("Primary");
        }
        sb.append("GridUnit:");
        if (this.colSpanIndex > 0) {
            sb.append(" colSpan=").append(this.colSpanIndex);
        }
        if (this.rowSpanIndex > 0) {
            sb.append(" rowSpan=").append(this.rowSpanIndex);
        }
        sb.append(" startCol=").append(this.startCol);
        sb.append(" flags=").append(Integer.toBinaryString(this.flags));
        return sb.toString();
    }
}

