/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBackingFileBuf;
import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKMemoryBuf;
import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKPipeline;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcCount;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.BDLManager;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.EngineStringConverter;
import com.insightful.miner.ExtensionManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ReadNativeSybaseDatabaseEngineNode;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.WriteNativeSybaseDatabaseEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeNetwork;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.util.StringUtilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class EngineNetworkManager {
    public static final int DEFAULT_MAX_BUFFER_MB = 10;
    public static final int DEFAULT_ROWS_PER_CHUNK = 10000;
    public static final int DEFAULT_STATUS_FREQ = 0;
    public static final boolean DEFAULT_USE_CACHE = true;
    public static final boolean DEFAULT_MINIMIZE_CACHING = true;
    public static final int DEFAULT_MAX_STRING_SIZE = 33;
    public static final int MINIMUM_MAX_STRING_SIZE = 4;
    public static final long STATUS_PRINT_MSECS = 2000L;
    public static final long STORAGE_UPDATE_MSECS = 30000L;
    public static final int MINIMUM_MAX_FACTOR_LEVELS = 500;
    public static final int MAXIMUM_MAX_FACTOR_LEVELS = 65534;
    public static final int DEFAULT_MAX_FACTOR_LEVELS = 500;
    private DateFormat m_localDataFormat = DateFormat.getDateTimeInstance();
    private String m_worksheetID = null;
    protected String m_worksheetDirPath = null;
    private boolean m_hasTempWorksheet = false;
    private Hashtable m_nodeIDToInfoHash = new Hashtable();
    private HashSet m_links = new HashSet();
    private RunThread m_runThread = null;
    protected boolean m_interruptRequested = false;
    private boolean m_isRunning = false;
    private Object[] m_runRequest = null;
    private WorksheetPropertiesManager m_worksheetPropertiesManager = new WorksheetPropertiesManager();
    private long m_totalDCFBytes = 0L;
    private long m_maxTotalDCFBytes = 0L;
    private int m_totalWarningsPrinted = 0;
    private int m_totalErrorsPrinted = 0;
    private Hashtable m_nodeIDToPhaseHash = new Hashtable();
    private XTProps m_worksheetParameters = null;
    private static NumberFormat m_longFormat = NumberFormat.getNumberInstance();
    private long m_minStorage = -1L;
    private long m_maxStorage = -1L;
    private long m_lastStorage = -1L;
    public static boolean g_splusWorkingChapterSetup;
    public static boolean g_splusWorkingChapterSplusAvailable;
    public static String g_splusWorkingChapter;
    public static long m_statPipelines;
    public static long m_statErrors;
    public static long m_statNodes;
    public static long m_statProcBlocks;
    public static long m_statSplusNodes;
    public static long m_statSorts;
    public static long m_statSortWriteBytes;
    public static long m_statDataCacheProcs;
    public static long m_statInputBytes;
    public static long m_statOutputBytes;
    public static long m_statOutputSummaryBytes;
    public static long m_statSmallToBigBytes;
    public static long m_statBigToSmallBytes;
    public static long m_statCacheCopyBytes;
    public static long m_statMilliseconds;

    public EngineNetworkManager(String worksheetID, String worksheetDirPath, String imwPath, boolean imwIsReadOnly) throws Exception {
        this(worksheetID, worksheetDirPath, imwPath, imwIsReadOnly, false);
    }

    public EngineNetworkManager(String worksheetID, String worksheetDirPath, String imwPath, boolean imwIsReadOnly, boolean errorOnTemp) throws Exception {
        this.m_worksheetID = worksheetID;
        this.m_worksheetDirPath = worksheetDirPath == null ? "" : worksheetDirPath;
        this.m_hasTempWorksheet = false;
        File wsdFile = new File(this.m_worksheetDirPath);
        String initTempDirContentsDir = null;
        if (this.m_worksheetDirPath.equals("")) {
            this.m_hasTempWorksheet = true;
        }
        if (imwIsReadOnly) {
            if (errorOnTemp) {
                throw new Exception("error on temp");
            }
            this.printlnWarning("Creating temp document: Worksheet file is read-only: " + imwPath);
            this.m_hasTempWorksheet = true;
            if (!this.m_worksheetDirPath.equals("")) {
                initTempDirContentsDir = this.m_worksheetDirPath;
            }
        }
        if (!this.m_hasTempWorksheet) {
            if (!wsdFile.exists()) {
                if (errorOnTemp) {
                    throw new Exception("directory doesn't exist: " + wsdFile.getPath());
                }
                this.printlnDebug("Creating worksheet directory: " + this.m_worksheetDirPath);
                if (!wsdFile.mkdirs()) {
                    this.printlnWarning("Creating temp document: Can't create worksheet directory " + this.m_worksheetDirPath + " (may be write-protected or out of space)");
                    this.m_hasTempWorksheet = true;
                }
            } else if (!wsdFile.isDirectory()) {
                if (errorOnTemp) {
                    throw new Exception("wsd file name is not a directory: " + wsdFile.getPath());
                }
                this.printlnWarning("Creating temp document: Worksheet directory name is existing file: " + this.m_worksheetDirPath);
                this.m_hasTempWorksheet = true;
            }
        }
        if (!this.m_hasTempWorksheet) {
            File readOnlyTestFile = new File(wsdFile, "imtestwt.xyz");
            readOnlyTestFile.delete();
            boolean isReadOnly = true;
            try {
                FileOutputStream ro = new FileOutputStream(readOnlyTestFile);
                isReadOnly = false;
                ro.close();
            }
            catch (Exception ex) {
                this.printlnDebug("EngineNetworkManager test for read-only directory---tried opening " + readOnlyTestFile.getPath() + ", got exception: " + ex);
            }
            readOnlyTestFile.delete();
            if (isReadOnly) {
                if (errorOnTemp) {
                    throw new Exception("wsd directory is read-only: " + wsdFile.getPath());
                }
                this.printlnWarning("Creating temp document: Worksheet directory is read-only: " + this.m_worksheetDirPath);
                initTempDirContentsDir = this.m_worksheetDirPath;
                this.m_hasTempWorksheet = true;
            }
        }
        if (this.m_hasTempWorksheet) {
            File initDirFile;
            if (errorOnTemp) {
                throw new Exception("error on temp");
            }
            this.m_worksheetDirPath = this.getTempWorksheetDirPath();
            if (initTempDirContentsDir != null && (initDirFile = new File(initTempDirContentsDir)).isDirectory()) {
                this.printlnWarning("Copying files to temp directory from: " + initTempDirContentsDir);
                try {
                    File[] filesToCopy = initDirFile.listFiles();
                    this.copyDirFiles(filesToCopy, this.m_worksheetDirPath);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((!this.m_hasTempWorksheet || initTempDirContentsDir != null) && new File(this.getGuiNetworkFileName()).exists() && new File(this.getEngineStateFileName()).exists()) {
            this.openWorksheetDirectory();
        } else {
            this.initNewWorksheetDirectory();
        }
    }

    private String getTempWorksheetDirPath() throws Exception {
        File tempFile = File.createTempFile("temp", ".wsd", new File(MinerApp.getTempDir()));
        tempFile.delete();
        tempFile.mkdir();
        return tempFile.getPath();
    }

    public long getTotalWorksheetDirBytes() throws Exception {
        File[] files = new File(this.m_worksheetDirPath).listFiles();
        long total = 0L;
        for (int i = 0; i < files.length; ++i) {
            total += files[i].length();
        }
        return total;
    }

    public boolean isTempWorksheetDir() {
        return this.m_hasTempWorksheet;
    }

    private void checkDirPath(String dirPath) throws Exception {
        File dir = new File(dirPath);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Exception("worksheet directory name is existing file: " + dirPath);
            }
        } else {
            this.printlnDebug("Creating worksheet directory: " + dirPath);
            if (!dir.mkdirs()) {
                throw new Exception("Can't create " + dirPath + " (may be write-protected or out of space)");
            }
        }
    }

    private void clearTempWorksheetDirectory(String dirPath) {
        this.printlnDebug("deleting temp worksheet directory " + dirPath);
        this.deleteDirectory(new File(dirPath));
    }

    private void deleteDirectory(File dir) {
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            dir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copyDirFiles(File[] filesToCopy, String toDir) throws Exception {
        this.closeDataViewerFiles();
        byte[] buf = new byte[32768];
        for (int i = 0; i < filesToCopy.length; ++i) {
            File fromFile = filesToCopy[i];
            File toFile = new File(toDir, fromFile.getName());
            if (!fromFile.exists()) continue;
            this.printlnDebug("Copying file " + fromFile + " to " + toFile);
            try {
                int len;
                DataInputStream in = new DataInputStream(new FileInputStream(fromFile));
                DataOutputStream out = new DataOutputStream(new FileOutputStream(toFile));
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void copyFile(String fromFileName, String toFileName) {
        FilterInputStream in = null;
        FilterOutputStream out = null;
        File fromFile = null;
        File toFile = null;
        try {
            int len;
            byte[] buf = new byte[32768];
            fromFile = new File(fromFileName);
            toFile = new File(toFileName);
            if (!fromFile.exists()) {
                return;
            }
            in = new DataInputStream(new FileInputStream(fromFile));
            out = new DataOutputStream(new FileOutputStream(toFile));
            while ((len = ((DataInputStream)in).read(buf)) >= 0) {
                ((DataOutputStream)out).write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (Exception ex) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
            try {
                if (toFile != null) {
                    toFile.delete();
                }
            }
            catch (Exception ex4) {
                // empty catch block
            }
            this.printlnDebug("Error copying " + fromFileName + " to " + toFileName + ": " + ex);
            ex.printStackTrace();
        }
    }

    public void changeWorksheetDir(String newWorksheetDir, boolean copyWSD) throws Exception {
        if (newWorksheetDir == null || newWorksheetDir.equals("")) {
            throw new Exception("can't change worksheet dir to " + newWorksheetDir);
        }
        if (newWorksheetDir.equals(this.m_worksheetDirPath)) {
            return;
        }
        if (this.isRunning()) {
            throw new Exception("can't change worksheet directory while network is running");
        }
        this.checkDirPath(newWorksheetDir);
        this.carefullyClearWorksheetDirectory(newWorksheetDir);
        String oldDir = this.m_worksheetDirPath;
        boolean oldDirIsTemp = this.m_hasTempWorksheet;
        File[] filesToCopy = copyWSD ? this.getFilesToCopy() : null;
        this.m_worksheetDirPath = newWorksheetDir;
        this.m_hasTempWorksheet = false;
        if (copyWSD) {
            this.copyDirFiles(filesToCopy, this.m_worksheetDirPath);
        } else {
            this.clearEngineState();
            this.initNewWorksheetDirectory();
        }
        if (oldDirIsTemp) {
            this.clearTempWorksheetDirectory(oldDir);
        }
    }

    public File[] getFilesToCopy() {
        if (this.isTempWorksheetDir()) {
            return new File(this.getWorksheetDirPath()).listFiles();
        }
        Vector<File> vec = new Vector<File>();
        vec.add(new File(this.getGuiNetworkFileName()));
        vec.add(new File(this.getEngineStateFileName()));
        Set engineNodes = this.getEngineNodes();
        for (String nodeID : engineNodes) {
            int output;
            int numOutputs = this.getNumOutputs(nodeID);
            for (output = 0; output < numOutputs; ++output) {
                if (!this.hasOutputDCF(nodeID, output)) continue;
                vec.add(new File(this.getOutputDataCacheFileName(nodeID, output)));
            }
            for (output = 0; output < numOutputs; ++output) {
                if (!this.hasOutputDCF(nodeID, output)) continue;
                vec.add(new File(this.getOutputDataBlobFileName(nodeID, output)));
            }
            for (output = 0; output < numOutputs; ++output) {
                if (!this.hasOutputMD(nodeID, output)) continue;
                vec.add(new File(this.getOutputMetaDataFileName(nodeID, output)));
            }
            Set cacheNames = this.getNodeCacheNames(nodeID);
            for (String cacheName : cacheNames) {
                vec.add(new File(this.getNodeCacheFileName(nodeID, cacheName)));
            }
            Set tempFileTags = this.getNodeTempFileTags(nodeID);
            for (String tempFileTag : tempFileTags) {
                vec.add(new File(this.getNodeTempFileFullPath(nodeID, tempFileTag)));
            }
        }
        File[] files = new File[vec.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)vec.get(i);
        }
        return files;
    }

    private void carefullyClearWorksheetDirectory(String dirPath) throws Exception {
        if (dirPath == null || dirPath.equals("")) {
            return;
        }
        EngineNetworkManager dummyMgr = new EngineNetworkManager("dummy", dirPath, "", false, true);
        dummyMgr.saveGuiNetwork(new XTNetwork());
        dummyMgr.saveEngineState();
        new File(dummyMgr.getGuiNetworkFileName()).delete();
        new File(dummyMgr.getEngineStateFileName()).delete();
    }

    protected void clearEngineState() {
        this.m_nodeIDToInfoHash.clear();
        this.m_links.clear();
    }

    public String getWorksheetID() {
        return this.m_worksheetID;
    }

    public String getWorksheetDirPath() {
        return this.m_worksheetDirPath;
    }

    public EngineNode getNode(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? null : info.m_node;
    }

    public void closeWorksheet() throws Exception {
        if (this.m_hasTempWorksheet) {
            this.clearTempWorksheetDirectory(this.m_worksheetDirPath);
        } else {
            this.saveEngineState();
        }
        this.clearEngineState();
        this.m_worksheetDirPath = null;
    }

    public void saveGuiNetwork(XTNetwork net) throws Exception {
        if (this.isRunning()) {
            this.printlnDebug("can't save new network while network is running");
            throw new Exception("can't save new network while network is running");
        }
        this.closeDataViewerFiles();
        this.writeXML(this.getGuiNetworkFileName(), net);
        this.storeWorksheetProperties(net.getWorksheetProperties());
        this.checkSplusWorkingChapter();
        XTNetwork.paramaterize(net);
        this.m_worksheetParameters = net.getWorksheetParameters();
        Vector guiNodes = net.getFlatNodes();
        Set engineNodes = this.getEngineNodes();
        for (String nodeID : engineNodes) {
            if (guiNodes.contains(nodeID)) continue;
            this.removeNode(nodeID);
        }
        for (String nodeID : guiNodes) {
            if (engineNodes.contains(nodeID)) {
                boolean classChanged;
                EngineNode eNode = this.getNode(nodeID);
                NodeInfo eInfo = this.getNodeInfo(nodeID);
                String guiNodeClassName = net.getEngineNodeClassName(nodeID);
                String engineNodeClassName = eNode.getClass().getName();
                boolean bl = classChanged = !engineNodeClassName.equals(guiNodeClassName);
                if (eInfo.m_isDummyNode) {
                    this.invalidateNodeInternal(nodeID);
                } else if (classChanged || this.getNumInputs(nodeID) != net.getNodeNumInputs(nodeID) || this.getNumOutputs(nodeID) != net.getNodeNumOutputs(nodeID)) {
                    this.removeNode(nodeID);
                    this.createNode(nodeID, net);
                } else {
                    XTProps guiNodeProperties = net.getNodeProperties(nodeID);
                    if (guiNodeProperties == null) {
                        guiNodeProperties = new XTProps();
                    }
                    if (eNode.propertiesChanged(guiNodeProperties)) {
                        this.printlnDebug("Props changed for " + this.getNodeName(nodeID));
                        this.invalidateNodeInternal(nodeID);
                        eInfo.setNodeProperties(guiNodeProperties);
                    }
                    XMLTree eModel = new XTNetwork.ModelInfo(eInfo.m_nodeModel).getXMLTree();
                    XMLTree guiModel = net.getModelProperties(nodeID);
                    String eParent = eInfo.m_nodeModelParent;
                    String guiParent = net.getModelParent(nodeID);
                    boolean sameModel = XTMetaData.nullCognizantCompare(eModel, guiModel);
                    boolean sameParent = XTMetaData.nullCognizantCompare(eParent, guiParent);
                    if (sameParent) {
                        NodeInfo parentInfo;
                        if (eModel == null && guiModel == null) {
                            parentInfo = this.getNodeInfo(guiParent);
                            if (parentInfo != null && !parentInfo.m_valid) {
                                eInfo.setModel(null);
                                sameModel = false;
                            }
                        } else if (eModel == null) {
                            eInfo.setModel(guiModel);
                            sameModel = true;
                        } else if (guiModel == null) {
                            parentInfo = this.getNodeInfo(guiParent);
                            if (parentInfo != null && parentInfo.m_valid && XTMetaData.nullCognizantCompare(eModel, parentInfo.getModel())) {
                                eInfo.setModel(null);
                                sameModel = true;
                            } else {
                                sameModel = false;
                            }
                        }
                    } else {
                        this.printlnDebug("Model parent changed for " + this.getNodeName(nodeID));
                        this.invalidateNodeInternal(nodeID);
                        eInfo.m_nodeModelParent = guiParent;
                    }
                    if (!sameModel) {
                        this.printlnDebug("Model changed for " + this.getNodeName(nodeID));
                        this.invalidateNodeInternal(nodeID);
                        eInfo.setModel(guiModel);
                    }
                    eInfo.m_executeAfter = net.getExecuteAfter(nodeID);
                    guiNodeProperties = null;
                    guiModel = null;
                    eModel = null;
                }
                eInfo.setNodeName(net.getNodeName(nodeID));
                eNode = null;
                eInfo = null;
                continue;
            }
            this.createNode(nodeID, net);
        }
        Vector guiLinks = net.getFlatLinks();
        Set engineLinks = this.getEngineLinks();
        for (XMLTreeNetwork.Link engineLink : engineLinks) {
            if (guiLinks.contains(engineLink)) continue;
            this.removeLink(engineLink);
        }
        for (XMLTreeNetwork.Link guiLink : guiLinks) {
            if (engineLinks.contains(guiLink)) continue;
            this.addLink(guiLink);
        }
        this.saveEngineState();
        guiLinks = null;
        guiNodes = null;
        engineLinks = null;
        engineNodes = null;
        Iterator guiLinkIter = null;
        Iterator engineLinkIter = null;
        Iterator guiNodeIter = null;
        Iterator engineNodeIter = null;
    }

    public XTNetwork getGuiNetwork() throws Exception {
        String file = this.getGuiNetworkFileName();
        XTNetwork xtn = XTNetwork.readXTNetworkFromFile(file);
        if (xtn != null) {
            XTNetwork.paramaterize(xtn);
            this.m_worksheetParameters = xtn.getWorksheetParameters();
        }
        return xtn;
    }

    public void runToHere(String nodeID) throws Exception {
        if (this.getNode(nodeID) == null) {
            throw new Exception("nodeID not found: " + nodeID);
        }
        Vector<String> v = new Vector<String>();
        v.add(nodeID);
        this.runToHere(v);
    }

    public void runToHere(Vector nodeIDs) throws Exception {
        this.runToHere(nodeIDs, null);
    }

    public void runToHere(Vector nodeIDs, Vector unrunnableNodeIDs) throws Exception {
        this.checkSplusWorkingChapter();
        this.getRunThread().requestRunNetwork(new Object[]{nodeIDs, unrunnableNodeIDs});
    }

    public void runToHereInThisThread(String nodeID) {
        Vector<String> v = new Vector<String>();
        v.add(nodeID);
        this.runToHereInThisThread(v);
    }

    public void runToHereInThisThread(Vector nodeIDs) {
        this.runNetworkWithNoExceptions(nodeIDs, null);
    }

    public boolean runHadErrors() {
        return this.m_totalErrorsPrinted > 0;
    }

    public void interrupt() {
        this.getRunThread().requestInterrupt();
    }

    public boolean isRunning() {
        return this.m_isRunning || this.m_runRequest != null;
    }

    public boolean isInterruptRequested() {
        return this.m_interruptRequested;
    }

    public XMLTree getNodeCache(String nodeID, String cacheName) {
        String cacheFileName = null;
        try {
            NodeInfo info = this.getNodeInfo(nodeID);
            if (info == null || cacheName == null || !info.hasNodeCacheName(cacheName)) {
                return null;
            }
            cacheFileName = this.getNodeCacheFileName(nodeID, cacheName);
            XMLTree cacheVal = this.readXML(cacheFileName);
            return cacheVal;
        }
        catch (Exception ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": error reading cache file " + cacheFileName + ": " + EngineNetworkManager.getExceptionMessage(ex));
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": out of memory reading cache file " + cacheFileName);
        }
        return null;
    }

    public XTMetaData getNodeCacheXTMetaData(String nodeID, String cacheName) {
        XTMetaData cacheVal = null;
        String cacheFileName = null;
        try {
            NodeInfo info = this.getNodeInfo(nodeID);
            if (info == null || cacheName == null || !info.hasNodeCacheName(cacheName)) {
                return null;
            }
            cacheFileName = this.getNodeCacheFileName(nodeID, cacheName);
            cacheVal = XTMetaData.readXTMetaDataFromFile(cacheFileName);
        }
        catch (Exception ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": error reading cache file " + cacheFileName + ": " + EngineNetworkManager.getExceptionMessage(ex));
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": out of memory reading cache file " + cacheFileName);
        }
        return cacheVal;
    }

    public XTProps getNodeCacheXTProps(String nodeID, String cacheName) {
        XTProps cacheVal = null;
        String cacheFileName = null;
        try {
            NodeInfo info = this.getNodeInfo(nodeID);
            if (info == null || cacheName == null || !info.hasNodeCacheName(cacheName)) {
                return null;
            }
            cacheFileName = this.getNodeCacheFileName(nodeID, cacheName);
            cacheVal = XTProps.readXTPropsFromFile(cacheFileName);
        }
        catch (Exception ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": error reading cache file " + cacheFileName + ": " + EngineNetworkManager.getExceptionMessage(ex));
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": out of memory reading cache file " + cacheFileName);
        }
        return cacheVal;
    }

    public void setNodeCache(String nodeID, String cacheName, XMLTree cacheVal) {
        String cacheFileName = null;
        try {
            NodeInfo info = this.getNodeInfo(nodeID);
            if (info == null || cacheName == null) {
                return;
            }
            cacheFileName = this.getNodeCacheFileName(nodeID, cacheName);
            if (cacheVal == null) {
                if (info.hasNodeCacheName(cacheName)) {
                    info.removeNodeCacheName(cacheName);
                    this.deleteFile(cacheFileName);
                }
            } else {
                info.addNodeCacheName(cacheName);
                this.writeXML(cacheFileName, cacheVal);
            }
        }
        catch (Exception ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": error writing cache file " + cacheFileName + ": " + EngineNetworkManager.getExceptionMessage(ex));
        }
        catch (OutOfMemoryError ex) {
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", cache=" + cacheName + ": out of memory writing cache file " + cacheFileName);
        }
    }

    public Set getNodeCacheNames(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? new HashSet() : info.getNodeCacheNames();
    }

    public XTProps getNodeProperties(String nodeID) {
        XTProps props;
        NodeInfo info = this.getNodeInfo(nodeID);
        XTProps xTProps = props = info == null ? null : info.getNodeProperties();
        if (props == null) {
            try {
                props = new XTProps();
                if (info != null) {
                    info.setNodeProperties(props);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return props;
    }

    public void setNodeProperties(String nodeID, XTProps arg) throws Exception {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.setNodeProperties(arg);
            this.invalidateNode(nodeID);
        }
    }

    public XMLTree getModel(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? null : info.getModel();
    }

    public void setModel(String nodeID, XMLTree arg) throws Exception {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.setModel(arg);
            this.invalidateNode(nodeID);
        }
    }

    public XTMetaData getInputMetaData(String nodeID, int inputNum) {
        XTMetaData md = null;
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeInputBufID(nodeID, inputNum);
            if (buf != null) {
                md = this.getOutputMetaData(buf.getNodeID(), buf.getOutputNum());
            }
        } else {
            XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
            if (link != null) {
                md = this.getOutputMetaData(link.getFromNodeID(), link.getFromOutputPort());
            }
        }
        return md == null ? this.createEmptyXTMetaData() : md;
    }

    public XTMetaData getOutputMetaData(String nodeID, int outputNum) {
        NodeInfo info;
        String storeNodeID = nodeID;
        int storeOutputNum = outputNum;
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            storeNodeID = buf.getNodeID();
            storeOutputNum = buf.getOutputNum();
        }
        if ((info = this.getNodeInfo(storeNodeID)) == null) {
            return null;
        }
        XTMetaData md = info.getOutputMetaData(storeOutputNum);
        if (md == null) {
            info.setOutputMetaData(storeOutputNum, this.createEmptyXTMetaData());
            this.checkSplusWorkingChapter();
            md = this.getNode(nodeID).calculateOutputMetaData(outputNum);
            info.setOutputMetaData(storeOutputNum, md);
        }
        return md == null ? this.createEmptyXTMetaData() : md;
    }

    public void setOutputMetaData(String nodeID, int outputNum, XTMetaData md) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            if (buf != null) {
                this.setOutputMetaData(buf.getNodeID(), buf.getOutputNum(), md);
            }
            return;
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info == null) {
            return;
        }
        info.setOutputMetaData(outputNum, md);
    }

    public void clearOutputMetaData(String nodeID) {
        int numOutputs = this.getNumOutputs(nodeID);
        for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
            this.setOutputMetaData(nodeID, outputNum, null);
        }
    }

    public int getNumInputs(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? 0 : info.m_numInputs;
    }

    public int getNumOutputs(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? 0 : info.m_numOutputs;
    }

    public boolean isValid(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info != null && info.m_valid;
    }

    public void invalidateNode(String nodeID) throws Exception {
        this.closeDataViewerFiles();
        this.initMaxTotalDCFBytes();
        this.invalidateNodeInternal(nodeID);
        this.saveEngineState();
        this.printlnInformation(MinerApp.getText("MinerFrame_info_invalidate") + " " + this.getNodeName(nodeID) + ", " + this.getDCFByteString());
        this.printlnInformation("");
    }

    private void invalidateNodeInternal(String nodeID) {
        this.invalidateNodeInternalRecurse(nodeID, new HashSet());
    }

    private void invalidateNodeInternalRecurse(String nodeID, HashSet invalidatedNodes) {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null && !invalidatedNodes.contains(nodeID)) {
            invalidatedNodes.add(nodeID);
            boolean currentlyValid = info.m_valid;
            info.m_valid = false;
            this.getNode(nodeID).closeDataViewerFiles();
            if (currentlyValid) {
                this.getNode(nodeID).invalidateNodeState();
            }
            for (int outNum = 0; outNum < info.m_numOutputs; ++outNum) {
                List links = info.getDownstreamLinks(outNum);
                for (XMLTreeNetwork.Link link : links) {
                    this.invalidateNodeInternalRecurse(link.getToNodeID(), invalidatedNodes);
                }
                if (info.getOutputMetaData(outNum) == null) continue;
                this.deleteFile(this.getOutputMetaDataFileName(nodeID, outNum));
                info.setOutputMetaData(outNum, null);
                if (this.hasOutputDCF(nodeID, outNum)) {
                    String dcfFile = this.getOutputDataCacheFileName(nodeID, outNum);
                    this.removeDCFBytes(dcfFile);
                    this.deleteFile(dcfFile);
                    String blobFile = this.getOutputDataBlobFileName(nodeID, outNum);
                    this.deleteFile(blobFile);
                }
                info.setHasOutputSummary(outNum, false);
                info.setHasOutputDCF(outNum, false);
            }
        }
    }

    protected Set getEngineNodes() {
        return new HashSet(this.m_nodeIDToInfoHash.keySet());
    }

    protected void removeNode(String nodeID) {
        int i;
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info == null) {
            return;
        }
        this.invalidateNodeInternal(nodeID);
        Set cacheNames = info.getNodeCacheNames();
        for (String cacheName : cacheNames) {
            this.setNodeCache(nodeID, cacheName, null);
        }
        Set tempFileTags = info.getNodeTempFileTags();
        for (String tempFileTag : tempFileTags) {
            String tempFilePath = this.getNodeTempFileFullPath(nodeID, tempFileTag);
            this.deleteFile(tempFilePath);
        }
        for (i = 0; i < info.m_numInputs; ++i) {
            XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, i);
            this.removeLink(link);
        }
        for (i = 0; i < info.m_numOutputs; ++i) {
            List links = info.getDownstreamLinks(i);
            for (XMLTreeNetwork.Link link : links) {
                this.removeLink(link);
            }
        }
        this.m_nodeIDToInfoHash.remove(nodeID);
    }

    protected void createNode(String nodeID, XTNetwork net) throws Exception {
        String engineNodeClassName = net.getEngineNodeClassName(nodeID);
        int numInputs = net.getNodeNumInputs(nodeID);
        int numOutputs = net.getNodeNumOutputs(nodeID);
        XTProps nodeProperties = net.getNodeProperties(nodeID);
        String nodeModel = net.getModelString(nodeID);
        String executeAfter = net.getExecuteAfter(nodeID);
        String nodeModelParent = net.getModelParent(nodeID);
        String nodeName = net.getNodeName(nodeID);
        this.createNode(nodeID, engineNodeClassName, numInputs, numOutputs, nodeProperties, nodeName, nodeModel, executeAfter, nodeModelParent);
    }

    protected void createNode(String nodeID, String engineNodeClassName, int numInputs, int numOutputs, XTProps nodeProperties, String nodeName, String nodeModel, String executeAfter, String nodeModelParent) throws Exception {
        boolean isDummyNode = true;
        EngineNode node = null;
        String badNodeMsg = null;
        try {
            node = (EngineNode)ExtensionManager.getClassForName(engineNodeClassName).newInstance();
            isDummyNode = false;
        }
        catch (ClassNotFoundException ex) {
            badNodeMsg = "Class " + engineNodeClassName + " not found";
        }
        catch (Exception ex) {
            badNodeMsg = ex.toString();
            ex.printStackTrace();
        }
        if (node == null) {
            node = new UnknownNode(badNodeMsg);
        }
        node.setNodeID(nodeID);
        node.setNetworkManager(this);
        NodeInfo info = new NodeInfo();
        info.m_node = node;
        info.m_isDummyNode = isDummyNode;
        info.m_engineNodeClassName = engineNodeClassName;
        info.m_numInputs = numInputs;
        info.m_numOutputs = numOutputs;
        info.m_inputLinks = new XMLTreeNetwork.Link[numInputs];
        info.m_valid = false;
        info.m_nodeProperties = nodeProperties;
        info.m_nodeModel = nodeModel;
        info.m_executeAfter = executeAfter;
        info.m_nodeModelParent = nodeModelParent;
        info.m_outputInfo = new OutputInfo[info.m_numOutputs];
        for (int i = 0; i < info.m_numOutputs; ++i) {
            info.m_outputInfo[i] = new OutputInfo();
        }
        info.m_nodeName = nodeName;
        this.m_nodeIDToInfoHash.put(nodeID, info);
        if (badNodeMsg != null) {
            this.printlnError("Error creating engine node " + this.getNodeName(nodeID) + ": " + badNodeMsg);
        }
    }

    protected Set getEngineLinks() {
        return new HashSet(this.m_links);
    }

    protected void addLink(XMLTreeNetwork.Link link) throws Exception {
        if (link != null && !this.m_links.contains(link)) {
            NodeInfo fromInfo = this.getNodeInfo(link.getFromNodeID());
            NodeInfo toInfo = this.getNodeInfo(link.getToNodeID());
            if (fromInfo == null) {
                throw new Exception("addLink bad link: " + link + " (from node doesn't exist - " + link.getFromNodeID() + ")");
            }
            if (toInfo == null) {
                throw new Exception("addLink bad link: " + link + " (to node doesn't exist - " + link.getToNodeID() + ")");
            }
            if (link.getFromOutputPort() < 0) {
                throw new Exception("addLink bad link: " + link + " (from port doesn't exist - [" + link.getFromOutputPort() + "])");
            }
            if (link.getFromOutputPort() >= fromInfo.m_numOutputs) {
                throw new Exception("addLink bad link: " + link + " (not enough from ports exist - [have " + fromInfo.m_numOutputs + ", need #" + link.getFromOutputPort() + "])");
            }
            if (link.getToInputPort() < 0) {
                throw new Exception("addLink bad link: " + link + " (to port doesn't exist - [" + link.getToInputPort() + "])");
            }
            if (link.getToInputPort() >= toInfo.m_numInputs) {
                throw new Exception("addLink bad link: " + link + " (not enough to ports exist - [have " + toInfo.m_numInputs + ", need #" + link.getToInputPort() + "])");
            }
            if (fromInfo == null || toInfo == null || link.getFromOutputPort() < 0 || link.getFromOutputPort() >= fromInfo.m_numOutputs || link.getToInputPort() < 0 || link.getToInputPort() >= toInfo.m_numInputs) {
                throw new Exception("addLink bad link: " + link);
            }
            if (toInfo.getUpstreamLink(link.getToInputPort()) != null) {
                throw new Exception("addLink can't add link: input already linked.");
            }
            this.invalidateNodeInternal(link.getToNodeID());
            this.m_links.add(link);
            fromInfo.addDownstreamLink(link, link.getFromOutputPort());
            toInfo.setUpstreamLink(link, link.getToInputPort());
        }
    }

    private void removeLink(XMLTreeNetwork.Link link) {
        if (link != null && this.m_links.contains(link)) {
            NodeInfo fromInfo = this.getNodeInfo(link.getFromNodeID());
            NodeInfo toInfo = this.getNodeInfo(link.getToNodeID());
            this.invalidateNodeInternal(link.getToNodeID());
            this.m_links.remove(link);
            fromInfo.removeDownstreamLink(link, link.getFromOutputPort());
            toInfo.setUpstreamLink(null, link.getToInputPort());
        }
    }

    public void saveEngineState() throws Exception {
        XTProps engineState = new XTProps();
        Set engineNodes = this.getEngineNodes();
        for (String nodeID : engineNodes) {
            NodeInfo info = this.getNodeInfo(nodeID);
            if (info == null) continue;
            EngineNetworkManager.setBooleanProp(engineState, new String[]{"node." + nodeID, "is.valid"}, info.m_valid);
            Set nodeCacheNames = info.getNodeCacheNames();
            for (String cacheName : nodeCacheNames) {
                EngineNetworkManager.setBooleanProp(engineState, new String[]{"node." + nodeID, "node.caches", cacheName}, true);
            }
            Set nodeTempFileTags = info.getNodeTempFileTags();
            for (String tempFileTag : nodeTempFileTags) {
                EngineNetworkManager.setBooleanProp(engineState, new String[]{"node." + nodeID, "node.temp.files", tempFileTag}, true);
            }
            int numOutputs = info.m_numOutputs;
            for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
                boolean hasOutputMD;
                XTMetaData md = info.getOutputMetaData(outputNum);
                boolean bl = hasOutputMD = md != null;
                if (info.getOutputMetaDataChanged(outputNum)) {
                    String outputMetaDataFileName = this.getOutputMetaDataFileName(nodeID, outputNum);
                    if (md == null) {
                        this.deleteFile(outputMetaDataFileName);
                    } else {
                        this.writeXML(outputMetaDataFileName, md);
                    }
                    info.clearOutputMetaDataChanged(outputNum);
                }
                String[] path = new String[]{"node." + nodeID, "out." + outputNum, "dummy"};
                path[2] = "has.md";
                EngineNetworkManager.setBooleanProp(engineState, path, hasOutputMD);
                path[2] = "has.summary";
                EngineNetworkManager.setBooleanProp(engineState, path, this.hasOutputSummary(nodeID, outputNum));
                path[2] = "has.dcf";
                EngineNetworkManager.setBooleanProp(engineState, path, this.hasOutputDCF(nodeID, outputNum));
            }
        }
        this.writeXML(this.getEngineStateFileName(), engineState);
    }

    private static void setBooleanProp(XTProps props, String[] path, boolean val) {
        props.set(path, val ? "true" : "false");
    }

    private String getGuiNetworkFileName() {
        return this.m_worksheetDirPath + File.separator + "network.xml";
    }

    public String getInputDataCacheFileName(String nodeID, int inputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeInputBufID(nodeID, inputNum);
            return buf == null ? null : this.getOutputDataCacheFileName(buf.getNodeID(), buf.getOutputNum());
        }
        XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
        return link == null ? null : this.getOutputDataCacheFileName(link.getFromNodeID(), link.getFromOutputPort());
    }

    public String getOutputFileName(String nodeID, int outputNum, String ext) {
        return this.m_worksheetDirPath + File.separator + nodeID + "-" + outputNum + "." + ext;
    }

    public String getOutputDataCacheFileName(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? null : this.getOutputDataCacheFileName(buf.getNodeID(), buf.getOutputNum());
        }
        return this.getOutputFileName(nodeID, outputNum, "dcf");
    }

    public String getOutputDataCacheFileName(BufID bi) {
        return this.getOutputDataCacheFileName(bi.getNodeID(), bi.getOutputNum());
    }

    public String getInputDataBlobFileName(String nodeID, int inputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeInputBufID(nodeID, inputNum);
            return buf == null ? null : this.getOutputDataBlobFileName(buf.getNodeID(), buf.getOutputNum());
        }
        XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
        return link == null ? null : this.getOutputDataBlobFileName(link.getFromNodeID(), link.getFromOutputPort());
    }

    public String getOutputDataBlobFileName(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? null : this.getOutputDataBlobFileName(buf.getNodeID(), buf.getOutputNum());
        }
        return this.getOutputFileName(nodeID, outputNum, "dbf");
    }

    public String getOutputDataBlobFileName(BufID bi) {
        return this.getOutputDataBlobFileName(bi.getNodeID(), bi.getOutputNum());
    }

    public String getInputMetaDataFileName(String nodeID, int inputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeInputBufID(nodeID, inputNum);
            return buf == null ? null : this.getOutputMetaDataFileName(buf.getNodeID(), buf.getOutputNum());
        }
        XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
        return link == null ? null : this.getOutputMetaDataFileName(link.getFromNodeID(), link.getFromOutputPort());
    }

    public String getOutputMetaDataFileName(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? null : this.getOutputMetaDataFileName(buf.getNodeID(), buf.getOutputNum());
        }
        return this.getOutputFileName(nodeID, outputNum, "mdf");
    }

    public String getNodeCacheFileName(String nodeID, String cacheName) {
        return this.m_worksheetDirPath + File.separator + nodeID + "-" + cacheName + ".ncf";
    }

    public String getNodeTempFileFullPath(String nodeID, String tagName) {
        return this.m_worksheetDirPath + File.separator + nodeID + "-tmp-" + tagName + ".tmp";
    }

    public String getNodeTempFileName(String nodeID, String tagName) {
        tagName = tagName == null ? "null" : tagName;
        String filePath = this.getNodeTempFileFullPath(nodeID, tagName);
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.addNodeTempFileTag(tagName);
        }
        return filePath;
    }

    public void deleteNodeTempFile(String nodeID, String tagName) {
        tagName = tagName == null ? "null" : tagName;
        String filePath = this.getNodeTempFileFullPath(nodeID, tagName);
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.removeNodeTempFileTag(tagName);
        }
        this.deleteFile(filePath);
    }

    public Set getNodeTempFileTags(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? new HashSet() : info.getNodeTempFileTags();
    }

    private String getEngineStateFileName() {
        return this.m_worksheetDirPath + File.separator + "state.xml";
    }

    private void deleteFile(String filename) {
        File fl = new File(filename);
        String msg = "";
        try {
            if (fl.exists()) {
                fl.delete();
                if (fl.exists()) {
                    msg = " (failed to delete)";
                }
            } else {
                msg = " (non-existant)";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            msg = " (exception " + EngineNetworkManager.getExceptionMessage(ex) + ")";
        }
        this.printlnDebug("deleting file " + filename + msg);
    }

    private void openWorksheetDirectory() throws Exception {
        NodeInfo info;
        this.printlnDebug("opening worksheet files in: " + this.m_worksheetDirPath);
        XTNetwork net = this.getGuiNetwork();
        if (net == null) {
            throw new Exception("Network is null!!");
        }
        Vector guiNodes = net.getFlatNodes();
        for (String nodeID : guiNodes) {
            this.createNode(nodeID, net);
        }
        Vector guiLinks = net.getFlatLinks();
        for (XMLTreeNetwork.Link guiLink : guiLinks) {
            this.addLink(guiLink);
        }
        XTProps engineState = XTProps.readXTPropsFromFile(this.getEngineStateFileName());
        for (String nodeID : guiNodes) {
            info = this.getNodeInfo(nodeID);
            boolean nodeIsValid = engineState.getBoolean(new String[]{"node." + nodeID, "is.valid"}, false);
            this.setNodeValid(nodeID, nodeIsValid);
            for (int outputNum = 0; outputNum < info.m_numOutputs; ++outputNum) {
                XTMetaData md;
                long mdFileBytes;
                long dcfFileBytes;
                String outDCF;
                boolean dcfFileExists;
                String[] path = new String[]{"node." + nodeID, "out." + outputNum, "dummy"};
                path[2] = "has.md";
                boolean hasOutputMD = engineState.getBoolean(path, false);
                path[2] = "has.summary";
                boolean hasOutputSummary = engineState.getBoolean(path, false);
                path[2] = "has.dcf";
                boolean hasOutputDCF = engineState.getBoolean(path, false);
                String outMDF = this.getOutputMetaDataFileName(nodeID, outputNum);
                boolean mdFileExists = new File(outMDF).exists();
                if (hasOutputMD && !mdFileExists) {
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected MDF file doesn't exist: " + outMDF);
                    hasOutputMD = false;
                } else if (!hasOutputMD && mdFileExists) {
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": unexpected MDF file: " + outMDF);
                    this.deleteFile(outMDF);
                } else if (hasOutputMD && mdFileExists) {
                    try {
                        XTMetaData md2 = XTMetaData.readXTMetaDataFromFile(outMDF);
                        info.setOutputMetaData(outputNum, md2);
                        info.clearOutputMetaDataChanged(outputNum);
                    }
                    catch (Exception ex) {
                        this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": exception reading meta-data file " + outMDF + ": " + EngineNetworkManager.getExceptionMessage(ex));
                        info.setOutputMetaData(outputNum, null);
                        hasOutputMD = false;
                        this.deleteFile(outMDF);
                    }
                }
                if (!nodeIsValid) {
                    if (hasOutputSummary) {
                        hasOutputSummary = false;
                        this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected MD summary, but node not valid");
                    }
                    if (hasOutputDCF) {
                        hasOutputDCF = false;
                        this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected DCF, but node not valid");
                    }
                }
                if (!hasOutputMD && hasOutputSummary) {
                    hasOutputSummary = false;
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected MD summary, but no MD");
                }
                this.setHasOutputSummary(nodeID, outputNum, hasOutputSummary);
                if (!hasOutputSummary && hasOutputDCF) {
                    hasOutputDCF = false;
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected DCF, but no MD summary");
                }
                if ((dcfFileExists = new File(outDCF = this.getOutputDataCacheFileName(nodeID, outputNum)).exists()) && hasOutputSummary && (dcfFileBytes = EngineNetworkManager.getFileBytes(outDCF)) != (mdFileBytes = DataCacheRowBuf.getDCFFileBytes(md = this.getOutputMetaData(nodeID, outputNum)))) {
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": bad DCF file (size=" + dcfFileBytes + ", expected=" + mdFileBytes + ")");
                    this.deleteFile(outDCF);
                    this.deleteFile(this.getOutputDataBlobFileName(nodeID, outputNum));
                    dcfFileExists = false;
                    hasOutputDCF = false;
                }
                if (hasOutputDCF && !dcfFileExists) {
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": expected DCF file doesn't exist: " + outDCF);
                    hasOutputDCF = false;
                } else if (!hasOutputDCF && dcfFileExists) {
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": unexpected DCF file: " + outDCF);
                    this.deleteFile(outDCF);
                    this.deleteFile(this.getOutputDataBlobFileName(nodeID, outputNum));
                } else if (hasOutputDCF && dcfFileExists) {
                    this.addDCFBytes(outDCF);
                }
                this.setHasOutputDCF(nodeID, outputNum, hasOutputDCF);
            }
            info.clearNodeCacheNames();
            Vector nodeCacheNames = engineState.getSubProperties(new String[]{"node." + nodeID, "node.caches"});
            info.addNodeCacheNames(nodeCacheNames);
            info.clearNodeTempFileTags();
            Vector nodeTempFileTags = engineState.getSubProperties(new String[]{"node." + nodeID, "node.temp.files"});
            info.addNodeTempFileTags(nodeTempFileTags);
        }
        for (String nodeID : guiNodes) {
            if (!this.getNodeValid(nodeID)) {
                this.invalidateNodeInternal(nodeID);
                continue;
            }
            info = this.getNodeInfo(nodeID);
            for (int outputNum = 0; outputNum < info.m_numOutputs; ++outputNum) {
                if (this.hasOutputSummary(nodeID, outputNum)) continue;
                this.printlnDebug("invalidating valid node " + this.getNodeName(nodeID) + " with invalid summary on output " + outputNum);
                this.invalidateNodeInternal(nodeID);
            }
        }
        this.saveEngineState();
    }

    private void initNewWorksheetDirectory() throws Exception {
        this.printlnDebug("initializing worksheet files in: " + this.m_worksheetDirPath);
        XTNetwork net = new XTNetwork();
        this.saveGuiNetwork(net);
    }

    protected NodeInfo getNodeInfo(String nodeID) {
        if (nodeID == null) {
            return null;
        }
        NodeInfo info = (NodeInfo)this.m_nodeIDToInfoHash.get(nodeID);
        return info;
    }

    private RunThread getRunThread() {
        if (this.m_runThread == null) {
            this.m_runThread = new RunThread();
        }
        return this.m_runThread;
    }

    public void printDebug(String msg) {
        this.outputText(msg, 0, false);
    }

    public void printlnDebug(String msg) {
        this.outputText(msg, 0, true);
    }

    public void printVerbose(String msg) {
        this.outputText(msg, 1, false);
    }

    public void printlnVerbose(String msg) {
        this.outputText(msg, 1, true);
    }

    public void printInformation(String msg) {
        this.outputText(msg, 2, false);
    }

    public void printlnInformation(String msg) {
        this.outputText(msg, 2, true);
    }

    public void printWarning(String msg) {
        this.outputText(msg, 3, false);
    }

    public void printlnWarning(String msg) {
        ++this.m_totalWarningsPrinted;
        this.outputText(msg, 3, true);
    }

    public void printError(String msg) {
        this.outputText(msg, 4, false);
    }

    public void printlnError(String msg) {
        ++this.m_totalErrorsPrinted;
        this.outputText(msg, 4, true);
    }

    public void outputText(String msg, int severity, boolean addNewLine) {
        EngineNetworkManager.sendMessageOutputText(this.getWorksheetID(), msg, severity, addNewLine);
    }

    public static void sendMessageOutputText(String worksheetID, String msg, int severity, boolean addNewLine) {
        EngineMessageHandler.sendMessageToGui(worksheetID, null, "outputText", new Object[]{msg, new Integer(severity), new Boolean(addNewLine)});
    }

    public static void globalPrintlnDebug(String msg) {
        EngineNetworkManager.sendMessageOutputText("", msg, 0, true);
    }

    private SubgraphPlan createExecutePlanCatchingExceptions(List runToNodes) {
        IncrementalExecutionPlan plan = null;
        try {
            plan = new IncrementalExecutionPlan(runToNodes);
            if (plan.anyNodesToExecute()) {
                plan.execute();
            }
        }
        catch (Exception ex) {
            this.printlnError("Uncaught exception while executing network: " + ex);
            ex.printStackTrace();
        }
        catch (OutOfMemoryError ex) {
            this.printlnError("Out of memory while executing network");
            ex.printStackTrace();
        }
        catch (UnsatisfiedLinkError ex) {
            this.printlnError("Unsatisfied link error while executing network: " + EngineNetworkManager.getExceptionMessage(ex));
            ex.printStackTrace();
        }
        catch (Error ex) {
            this.printlnError("Serious error while executing network: " + ex);
            ex.printStackTrace();
        }
        return plan;
    }

    private void runNetwork(List initRunToNodes, List initUnrunnableNodes) throws Exception {
        String msg;
        int i;
        Vector badNodes;
        this.printlnDebug("");
        this.printlnInformation(MinerApp.getText("MinerFrame_info_execute_worksheet") + " " + this.m_worksheetDirPath);
        this.printlnInformation(MinerApp.getText("MinerFrame_info_execute_start_time") + " " + this.m_localDataFormat.format(new Date()));
        this.printlnDebug("");
        this.m_totalErrorsPrinted = 0;
        this.m_totalWarningsPrinted = 0;
        if (!CNKObj.getInitialLibrariesLoaded()) {
            this.printlnError("Serious error: " + CNKObj.getInitialLibrariesStatus());
            return;
        }
        this.initMaxTotalDCFBytes();
        this.closeDataViewerFiles();
        int numberNodesToExecute = 0;
        int numberNodesExecuted = 0;
        List unexecutedNodes = null;
        List runToNodes = initRunToNodes;
        Vector unrunnableNodes = initUnrunnableNodes == null ? new Vector() : new Vector(initUnrunnableNodes);
        long beforeTotal = System.currentTimeMillis();
        SubgraphPlan plan = this.createExecutePlanCatchingExceptions(runToNodes);
        if (plan != null) {
            List possibleExecuted;
            numberNodesToExecute = plan.getNumberNodesToBeExecuted();
            unexecutedNodes = plan.getUnexecutedNodes();
            for (numberNodesExecuted = plan.getNumberNodesExecuted(); numberNodesExecuted > 0 && unrunnableNodes.size() > 0 && !this.isInterruptRequested(); numberNodesExecuted += possibleExecuted.size()) {
                SubgraphPlan possiblePlan;
                Vector<String> possibleNodes = new Vector<String>();
                for (int i2 = 0; i2 < unrunnableNodes.size(); ++i2) {
                    String nodeID = (String)unrunnableNodes.get(i2);
                    Object ok = EngineMessageHandler.sendMessageToApp("runNetworkIsNodeRunnable", new String[]{nodeID});
                    if (ok == null || !(ok instanceof Boolean) || !((Boolean)ok).booleanValue()) continue;
                    possibleNodes.add(nodeID);
                }
                if (possibleNodes.size() < 1 || (possiblePlan = this.createExecutePlanCatchingExceptions(possibleNodes)) == null) break;
                possibleExecuted = possiblePlan.getExecutedNodes();
                numberNodesToExecute += possibleExecuted.size();
                if (possibleExecuted.size() < 1) break;
                unrunnableNodes = new Vector(unrunnableNodes);
                unrunnableNodes.removeAll(possibleExecuted);
            }
        }
        if (this.isInterruptRequested()) {
            this.printlnError("  << interrupt >>");
        }
        long afterTotal = System.currentTimeMillis();
        long execTimeMsecs = afterTotal - beforeTotal;
        this.printlnInformation(MinerApp.getText("MinerFrame_info_execute_end_time") + " " + this.m_localDataFormat.format(new Date()));
        if (numberNodesToExecute < 1) {
            this.printlnWarning(MinerApp.getText("MinerFrame_warn_no_nodes_ready"));
        } else {
            this.printlnInformation(MinerApp.getText("MinerFrame_info_execute_total_time") + this.getNiceTimeString(execTimeMsecs) + ", " + this.getDCFByteString());
            this.printlnInformation("   " + this.m_totalErrorsPrinted + " error(s), " + this.m_totalWarningsPrinted + " warning(s)");
        }
        if (numberNodesExecuted > 0) {
            this.printlnInformation("   " + numberNodesExecuted + " " + MinerApp.getText("MinerFrame_info_execute_success"));
        }
        if (numberNodesToExecute > numberNodesExecuted) {
            this.printlnInformation("   " + (numberNodesToExecute - numberNodesExecuted) + " " + MinerApp.getText("MinerFrame_info_not_execute_dueto_error") + (this.isInterruptRequested() ? " " + MinerApp.getText("MinerFrame_info_not_execute_dueto_interrrupt") : ""));
            if (unexecutedNodes != null) {
                badNodes = new Vector(unexecutedNodes);
                Collections.sort(badNodes);
                for (i = 0; i < badNodes.size(); ++i) {
                    msg = "        " + this.getNodeName((String)badNodes.get(i));
                    if (MinerApp.isInteractive()) {
                        this.printlnDebug(msg);
                        continue;
                    }
                    this.printlnInformation(msg);
                }
            }
        }
        if (unrunnableNodes.size() > 0) {
            this.printlnInformation("   " + unrunnableNodes.size() + " " + MinerApp.getText("MinerFrame_info_not_execute_dueto_unset"));
            badNodes = new Vector(unrunnableNodes);
            Collections.sort(badNodes);
            for (i = 0; i < badNodes.size(); ++i) {
                msg = "        " + this.getNodeName((String)badNodes.get(i));
                if (MinerApp.isInteractive()) {
                    this.printlnDebug(msg);
                    continue;
                }
                this.printlnInformation(msg);
            }
        }
        this.printlnInformation("");
        EngineMessageHandler.sendMessageToGui(this.getWorksheetID(), null, this.isInterruptRequested() ? "runNetworkInterrupted" : "runNetworkDone", null);
        this.clearPhaseNodes();
    }

    private void runNetworkWithNoExceptions(List runToNodes, List unrunnableNodes) {
        try {
            this.runNetwork(runToNodes, unrunnableNodes);
        }
        catch (Exception ex) {
            this.printlnError("Uncaught exception while executing network: " + ex);
            ex.printStackTrace();
        }
        catch (OutOfMemoryError ex) {
            this.printlnError("Out of memory while executing network.");
            ex.printStackTrace();
        }
        catch (Error ex) {
            this.printlnError("Serious error while executing network: " + ex);
            ex.printStackTrace();
        }
    }

    private String getDCFByteString() {
        String totalString = this.getNiceBytesString(this.m_totalDCFBytes);
        String maxString = this.getNiceBytesString(this.m_maxTotalDCFBytes);
        String sizeMsg = totalString;
        if (!totalString.equals(maxString)) {
            sizeMsg = sizeMsg + "; max=" + maxString;
        }
        return "data cache size=" + sizeMsg;
    }

    private String getNiceBytesString(long bytes) {
        if (bytes < 1000L) {
            return bytes + " bytes";
        }
        if (bytes < 1000000L) {
            return m_longFormat.format(bytes / 1000L) + "KB";
        }
        if (bytes < 100000000L) {
            return m_longFormat.format((double)bytes / 1000000.0) + "MB";
        }
        return m_longFormat.format(bytes / 1000000L) + "MB";
    }

    private String getNiceTimeString(long msecs) {
        if (msecs < 1000L) {
            return m_longFormat.format((double)msecs / 1000.0) + " seconds";
        }
        return m_longFormat.format(msecs / 1000L) + " seconds";
    }

    private boolean executeDataCacheProc(String nodeID) throws Exception {
        boolean dcfFileExists;
        String outDCF;
        int outputNum;
        EngineNode node = this.getNode(nodeID);
        ++m_statDataCacheProcs;
        for (int inputNum = 0; inputNum < this.getNumInputs(nodeID); ++inputNum) {
            m_statInputBytes += EngineNetworkManager.getFileBytes(this.getInputDataCacheFileName(nodeID, inputNum));
        }
        long saveTotalDCFBytes = this.m_totalDCFBytes;
        for (int outputNum2 = 0; outputNum2 < this.getNumOutputs(nodeID); ++outputNum2) {
            this.setOutputMetaData(nodeID, outputNum2, null);
            this.getOutputMetaData(nodeID, outputNum2);
        }
        int numErrorsBefore = this.m_totalErrorsPrinted;
        boolean ok = node.executeDataCacheProc();
        node.resetProgressIndicator();
        if (this.isInterruptRequested()) {
            return false;
        }
        if (!ok && numErrorsBefore == this.m_totalErrorsPrinted) {
            this.printlnError(this.getNodeName(nodeID) + ": unknown error");
        }
        this.m_totalDCFBytes = saveTotalDCFBytes;
        for (outputNum = 0; outputNum < this.getNumOutputs(nodeID) && ok; ++outputNum) {
            outDCF = this.getOutputDataCacheFileName(nodeID, outputNum);
            dcfFileExists = new File(outDCF).exists();
            if (!dcfFileExists) {
                ok = false;
                this.printlnError(this.getNodeName(nodeID) + ": expected data cache proc output file doesn't exist:" + outDCF);
                break;
            }
            boolean hasSummary = node.isDataCacheProcOutputMetaDataComplete(outputNum);
            if (hasSummary || (ok = this.updateOutputDCFSummary(nodeID, outputNum))) continue;
            this.printlnError(this.getNodeName(nodeID) + ": error calculating summary info for data cache proc output file " + outDCF);
        }
        for (outputNum = 0; outputNum < this.getNumOutputs(nodeID); ++outputNum) {
            this.setHasOutputDCF(nodeID, outputNum, ok);
            this.setHasOutputSummary(nodeID, outputNum, ok);
            outDCF = this.getOutputDataCacheFileName(nodeID, outputNum);
            if (ok) {
                this.addDCFBytes(outDCF);
                m_statOutputBytes += EngineNetworkManager.getFileBytes(outDCF);
                continue;
            }
            dcfFileExists = new File(outDCF).exists();
            if (!dcfFileExists) continue;
            this.addRemoveDCFBytes(outDCF);
            this.deleteFile(outDCF);
            this.deleteFile(this.getOutputDataBlobFileName(nodeID, outputNum));
        }
        return ok;
    }

    private boolean updateOutputDCFSummary(String nodeID, int outputNum) throws Exception {
        XTMetaData md = this.getOutputMetaData(nodeID, outputNum);
        String cacheFile = this.getOutputDataCacheFileName(nodeID, outputNum);
        int bytesPerRow = DataCacheRowBuf.getDCFBytesPerRow(md);
        int summaryRowsPerChunk = this.limitRowsPerChunk(nodeID, bytesPerRow);
        if (summaryRowsPerChunk < 1) {
            summaryRowsPerChunk = 1;
        }
        this.printlnDebug("updating output DCF summary for node=" + this.getNodeName(nodeID) + ", output=" + outputNum + ", data cache=" + cacheFile);
        this.printlnDebug("    DCF summary buf: " + summaryRowsPerChunk + " rows, " + md.getNumColumns() + " cols, " + summaryRowsPerChunk * bytesPerRow + " bytes");
        CNKBackingFileBuf buf = new CNKBackingFileBuf();
        buf.createCheck();
        buf.setNumRows(summaryRowsPerChunk);
        EngineNetworkManager.setBufColumnDescription(buf, md, this.getMaxCategoricalLevels());
        buf.setFileName(cacheFile);
        buf.setBackingFileRows(md.getNumRows());
        CNKProcCount proc = new CNKProcCount();
        proc.setNumRows(summaryRowsPerChunk);
        proc.setInbuf(buf);
        m_statOutputSummaryBytes += md.getNumRows() * (long)bytesPerRow;
        CNKPipeline pip = new CNKPipeline();
        pip.add(proc);
        pip.add(buf);
        pip.init();
        boolean ok = true;
        while (pip.anyProcReady()) {
            if (this.isInterruptRequested()) {
                ok = false;
                break;
            }
            try {
                pip.execute(1L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ok = false;
                break;
            }
        }
        if (this.anyPipelineProblems(pip)) {
            this.printlnError(this.getNodeName(nodeID) + ": problem scanning output DCF");
            ok = false;
        }
        if (ok) {
            this.updateMetaDataFromBuf(nodeID, outputNum, buf, proc, false);
        }
        pip.destroyPipeline(true);
        return ok;
    }

    public boolean isSplusLicensed() {
        return MinerApp.isSplusLicensed();
    }

    public boolean isProductionEdition() {
        return MinerApp.getLicenseInfo().isProductionEdition();
    }

    public boolean executeCNKProc(String nodeID) throws Exception {
        EngineNode node = this.getNode(nodeID);
        CNKProc proc = node.procCreate();
        if (proc == null) {
            throw new Exception("no proc defined");
        }
        proc.createCheck();
        if (!this.isSplusLicensed() && !MinerApp.isInBDL() && proc instanceof CNKProcSplusTransform) {
            throw new Exception("S-PLUS Library not installed.  Cannot execute component.");
        }
        node.procSetProperties(proc);
        boolean ok = this.executeCNKProc(nodeID, proc);
        this.printDebug("destroying proc...");
        System.out.flush();
        proc.setCallback(null);
        node.procDelete(proc);
        this.printlnDebug("done");
        System.out.flush();
        return ok;
    }

    public boolean executeCNKProc(String nodeID, CNKProc proc) throws Exception {
        EngineNode node = this.getNode(nodeID);
        int numInputs = node.getNumInputs();
        int maxLevels = this.getMaxCategoricalLevels();
        CNKBackingFileBuf[] inBufs = new CNKBackingFileBuf[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            XTMetaData upMD = this.getInputMetaData(nodeID, i);
            String inputFile = this.getInputDataCacheFileName(nodeID, i);
            if (inputFile == null) {
                throw new Exception("unlinked input " + i + " for node " + nodeID);
            }
            CNKBackingFileBuf buf = new CNKBackingFileBuf();
            buf.createCheck();
            EngineNetworkManager.setBufColumnDescription(buf, upMD, maxLevels);
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", input=" + i + ", data cache=" + inputFile + ", rows=" + upMD.getNumRows());
            buf.setFileName(inputFile);
            buf.setBlobFileName(this.getInputDataBlobFileName(nodeID, i));
            buf.setBackingFileRows(upMD.getNumRows());
            inBufs[i] = buf;
        }
        return this.executeCNKProcBase(nodeID, proc, inBufs, true);
    }

    public boolean executeCNKProc(String nodeID, CNKProc proc, String[] inBufDCFArray, XTMetaData[] inBufMDArray) throws Exception {
        EngineNode node = this.getNode(nodeID);
        int numInputs = node.getNumInputs();
        int maxLevels = this.getMaxCategoricalLevels();
        CNKBackingFileBuf[] inBufs = new CNKBackingFileBuf[numInputs];
        if (inBufDCFArray == null || inBufDCFArray.length != numInputs || inBufMDArray == null || inBufMDArray.length != numInputs) {
            throw new Exception("bad arguments to executeCNKProc for node " + nodeID);
        }
        for (int i = 0; i < numInputs; ++i) {
            XTMetaData upMD = inBufMDArray[i];
            String inputFile = inBufDCFArray[i];
            if (inputFile == null || upMD == null) {
                throw new Exception("unlinked input " + i + " for node " + nodeID);
            }
            CNKBackingFileBuf buf = new CNKBackingFileBuf();
            buf.createCheck();
            EngineNetworkManager.setBufColumnDescription(buf, upMD, maxLevels);
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", input=" + i + ", data cache=" + inputFile + ", rows=" + upMD.getNumRows());
            buf.setFileName(inputFile);
            buf.setBlobFileName(this.getInputDataBlobFileName(nodeID, i));
            buf.setBackingFileRows(upMD.getNumRows());
            inBufs[i] = buf;
        }
        return this.executeCNKProcBase(nodeID, proc, inBufs, true);
    }

    public boolean executeCNKProcBase(String nodeID, CNKProc proc, CNKBackingFileBuf[] inBufs, boolean bValidate) throws Exception {
        if (bValidate && inBufs.length != this.getNode(nodeID).getNumInputs()) {
            throw new Exception("Internal error: input buffers error for node " + nodeID);
        }
        EngineNode node = this.getNode(nodeID);
        int numOutputs = node.getNumOutputs();
        int maxLevels = this.getMaxCategoricalLevels();
        CNKBackingFileBuf[] outBufs = new CNKBackingFileBuf[numOutputs];
        for (int i = 0; i < numOutputs; ++i) {
            CNKBackingFileBuf buf = new CNKBackingFileBuf();
            buf.createCheck();
            String outputFile = this.getOutputDataCacheFileName(nodeID, i);
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ", output=" + i + ", data cache=" + outputFile);
            buf.setFileName(outputFile);
            buf.setBlobFileName(this.getOutputDataBlobFileName(nodeID, i));
            buf.setBackingFileRows(0L);
            EngineNetworkManager.setBufColumnDescription(buf, this.getOutputMetaData(nodeID, i), maxLevels);
            outBufs[i] = buf;
        }
        return this.executeCNKProcBase(nodeID, proc, inBufs, outBufs, -1, true);
    }

    public boolean executeCNKProcBase(String nodeID, CNKProc proc, CNKBackingFileBuf[] inBufs, CNKBackingFileBuf[] outBufs, int rowsPerChunk, boolean outputStats) throws Exception {
        int i;
        int i2;
        long lastStatusTime;
        EngineStringConverter bufConverter = this.getEngineStringConverter(null, null);
        long lastStorageTime = lastStatusTime = System.currentTimeMillis();
        boolean ok = true;
        EngineNode node = this.getNode(nodeID);
        int numInputs = inBufs.length;
        int numOutputs = outBufs.length;
        long firstInputNumRows = -1L;
        if (numInputs > 0) {
            firstInputNumRows = inBufs[0].getBackingFileRows();
        }
        CNKProcCount[] outSummaryProcs = null;
        if (outputStats) {
            outSummaryProcs = new CNKProcCount[numOutputs];
            for (int i3 = 0; i3 < numOutputs; ++i3) {
                outSummaryProcs[i3] = new CNKProcCount();
                outSummaryProcs[i3].createCheck();
                outSummaryProcs[i3].setNumRows(0);
            }
        }
        if (rowsPerChunk < 0) {
            int bytesPerRow = 0;
            for (i2 = 0; i2 < numInputs; ++i2) {
                bytesPerRow += inBufs[i2].calcBytesPerRow();
            }
            for (i2 = 0; i2 < numOutputs; ++i2) {
                bytesPerRow += outBufs[i2].calcBytesPerRow();
            }
            rowsPerChunk = this.limitRowsPerChunk(nodeID, bytesPerRow);
        }
        proc.setNumRows(rowsPerChunk);
        CNKPipeline pip = new CNKPipeline();
        pip.createCheck();
        pip.add(proc);
        ++m_statNodes;
        for (i2 = 0; i2 < numInputs; ++i2) {
            inBufs[i2].setConverter(bufConverter);
            proc.setInbuf(i2, inBufs[i2]);
            pip.add(inBufs[i2]);
        }
        for (i2 = 0; i2 < numOutputs; ++i2) {
            outBufs[i2].setConverter(bufConverter);
            proc.setOutbuf(i2, outBufs[i2]);
            if (outputStats) {
                outSummaryProcs[i2].setInbuf(0, outBufs[i2]);
            }
            pip.add(outBufs[i2]);
            if (!outputStats) continue;
            pip.add(outSummaryProcs[i2]);
        }
        for (i2 = 0; i2 < numInputs; ++i2) {
            inBufs[i2].setNumRows(inBufs[i2].getMinRowsToAvoidDeadlock());
        }
        for (i2 = 0; i2 < numOutputs; ++i2) {
            outBufs[i2].setNumRows(outBufs[i2].getMinRowsToAvoidDeadlock());
        }
        pip.init();
        int numTicksPrinted = 0;
        long progressTotalRows = node.procGetEstimatedNumRows(proc);
        if (progressTotalRows < 0L) {
            progressTotalRows = firstInputNumRows;
        }
        this.initNodeMessages(nodeID);
        String baseText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        while (pip.anyProcReady()) {
            if (this.m_interruptRequested) {
                ok = false;
                break;
            }
            try {
                pip.execute(1L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ok = false;
            }
            if (this.hasUnprintedMessages(nodeID, proc)) {
                if (numTicksPrinted > 0) {
                    this.printlnInformation("");
                    numTicksPrinted = 0;
                }
                this.printNodeMessages(nodeID, proc);
            }
            if (!ok) break;
            long newStatusTime = System.currentTimeMillis();
            if (newStatusTime - lastStatusTime > 2000L) {
                lastStatusTime = newStatusTime;
            }
            long progressRowsDone = proc.getRowsDone();
            int exeDone = proc.getDataPassCount();
            int percentDone = progressTotalRows < 1L ? 0 : (int)(100.0 * (double)progressRowsDone / (double)progressTotalRows);
            node.updateProgressIndicator(percentDone, exeDone, baseText, this);
            if (newStatusTime - lastStorageTime <= 30000L) continue;
            this.updateStorageInfo();
            lastStorageTime = System.currentTimeMillis();
        }
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{baseText});
        node.resetProgressIndicator();
        this.printPipeline(pip);
        ++m_statPipelines;
        boolean weHavePipelineProblems = this.anyPipelineProblems(pip);
        if (weHavePipelineProblems) {
            ok = false;
            ++m_statErrors;
        }
        if (weHavePipelineProblems && !this.isInterruptRequested() && !proc.hasError() && !proc.done()) {
            this.printlnError(this.getNodeName(nodeID) + ": unfinished proc");
        }
        try {
            m_statProcBlocks += proc.getExecuteCount();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (ok) {
            try {
                node.procExtractResults(proc);
            }
            catch (Exception ex) {
                this.printlnError(this.getNodeName(nodeID) + ": error extracting result from proc: " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace();
                ok = false;
            }
        }
        if (ok && outputStats) {
            for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
                this.updateMetaDataFromBuf(nodeID, outputNum, outBufs[outputNum], outSummaryProcs[outputNum]);
            }
        }
        pip.destroyPipeline(false);
        for (i = 0; i < numInputs; ++i) {
            this.printBufferErrors(inBufs[i]);
            EngineNetworkManager.updateBufStats(inBufs[i]);
            inBufs[i].destroyCNKObj();
        }
        for (i = 0; i < numOutputs; ++i) {
            this.printBufferErrors(outBufs[i]);
            EngineNetworkManager.updateBufStats(outBufs[i]);
            outBufs[i].destroyCNKObj();
            if (!outputStats) continue;
            outSummaryProcs[i].destroyCNKObj();
        }
        if (outputStats) {
            for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
                String outDCF = this.getOutputDataCacheFileName(nodeID, outputNum);
                if (ok) {
                    this.addDCFBytes(outDCF);
                } else {
                    this.addRemoveDCFBytes(outDCF);
                    this.printlnDebug("node=" + this.getNodeName(nodeID) + ", out=" + outputNum + ": deleting incomplete DCF file: " + outDCF);
                    this.deleteFile(outDCF);
                    this.deleteFile(this.getOutputDataBlobFileName(nodeID, outputNum));
                }
                this.setHasOutputDCF(nodeID, outputNum, ok);
                this.setHasOutputSummary(nodeID, outputNum, ok);
            }
        }
        return ok;
    }

    public int limitRowsPerChunk(String nodeID, int bytesPerRow) {
        int rowsPerChunk = this.getMaxRowsPerBlock(nodeID);
        long maxBufBytes = (long)this.getMaxBufferMB() * 1000000L;
        long totalBytesPerRow = bytesPerRow > 0 ? bytesPerRow : 1000;
        long estimatedBufBytes = (long)rowsPerChunk * totalBytesPerRow;
        if (rowsPerChunk < 1 || estimatedBufBytes <= maxBufBytes) {
            return rowsPerChunk;
        }
        int okRowsPerChunk = (int)(maxBufBytes / totalBytesPerRow);
        if (okRowsPerChunk < 1) {
            okRowsPerChunk = 1;
        }
        if (okRowsPerChunk != rowsPerChunk) {
            long okBufBytes = (long)okRowsPerChunk * totalBytesPerRow;
            this.printlnDebug("node=" + this.getNodeName(nodeID) + ": reducing chunk size " + rowsPerChunk + " -> " + okRowsPerChunk + ", buf size: " + estimatedBufBytes + " -> " + okBufBytes + ", bytesPerRow=" + bytesPerRow);
        }
        return okRowsPerChunk;
    }

    public int getMaxBufferMB() {
        int val = this.getWorksheetPropertiesManager().getMaxMBPerBlock();
        return val;
    }

    private void printBufferErrors(CNKBuf buf) {
        if (buf.hasError()) {
            int numMessages = buf.getNumMessages();
            for (int i = 0; i < numMessages; ++i) {
                if (buf.getMessageSeverity(i) != 4) continue;
                this.printlnError("Buf error: " + buf.getMessage(i));
            }
        }
    }

    private void printPipeline(CNKPipeline pip) {
        this.printlnVerbose("pipeline: " + pip);
        CNKProc[] procs = pip.getProcs();
        for (int i = 0; i < procs.length; ++i) {
            this.printlnVerbose("p" + i + ": " + String.valueOf(procs[i]));
        }
        CNKBuf[] bufs = pip.getBufs();
        for (int i = 0; i < bufs.length; ++i) {
            this.printlnVerbose("b" + i + ": " + String.valueOf(bufs[i]));
        }
    }

    private boolean anyPipelineProblems(CNKPipeline pip) {
        if (pip.hasError()) {
            return true;
        }
        CNKProc[] procs = pip.getProcs();
        for (int i = 0; i < procs.length; ++i) {
            if (procs[i] == null || procs[i].done() && !procs[i].hasError()) continue;
            return true;
        }
        CNKBuf[] bufs = pip.getBufs();
        for (int i = 0; i < bufs.length; ++i) {
            if (bufs[i] == null || !bufs[i].hasError()) continue;
            return true;
        }
        return false;
    }

    private List getSortedRunNodes(List runToNodes) throws Exception {
        return this.getSortedUpstreamNodes(runToNodes, false);
    }

    public List getSortedRunNodesFromVector(Vector runToNodes) throws Exception {
        return this.getSortedRunNodes(runToNodes);
    }

    private String getCycleNode(List execNodes) {
        for (int i = 0; i < execNodes.size(); ++i) {
            String nodeID = (String)execNodes.get(i);
            int nodeInputs = this.getNumInputs(nodeID);
            for (int input = 0; input < nodeInputs; ++input) {
                String upNode = this.getUpstreamNode(nodeID, input);
                if (execNodes.indexOf(upNode) <= i) continue;
                return nodeID;
            }
        }
        return null;
    }

    public List getSortedValidNodes() {
        List sortedAllNodes = this.getSortedNodes();
        Vector<String> sortedValidNodes = new Vector<String>();
        for (String nodeID : sortedAllNodes) {
            if (!this.getNodeValid(nodeID)) continue;
            sortedValidNodes.add(nodeID);
        }
        return sortedValidNodes;
    }

    public List getValidNodes() {
        Set allNodes = this.getEngineNodes();
        Vector<String> validNodes = new Vector<String>();
        for (String nodeID : allNodes) {
            if (!this.getNodeValid(nodeID)) continue;
            validNodes.add(nodeID);
        }
        return validNodes;
    }

    public List getSortedNodes() {
        List sortedAllNodes = this.getSortedUpstreamNodes(this.getEngineNodes(), true);
        return sortedAllNodes;
    }

    private List getSortedUpstreamNodes(Collection nodeList, boolean collectValid) {
        Vector sortedNodes = new Vector();
        HashSet processedNodes = new HashSet();
        for (String nodeID : nodeList) {
            this.getSortedUpstreamNodesAddNode(sortedNodes, processedNodes, nodeID, collectValid);
        }
        return sortedNodes;
    }

    private void getSortedUpstreamNodesAddNode(Vector sortedNodes, HashSet processedNodes, String nodeID, boolean collectValid) {
        if (processedNodes.contains(nodeID)) {
            return;
        }
        processedNodes.add(nodeID);
        if (!collectValid && this.getNodeValid(nodeID) && this.hasAllOutputDCF(nodeID)) {
            return;
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        int numInputs = this.getNumInputs(nodeID);
        if (numInputs == 0 && info != null && info.m_executeAfter != null && this.getNodeInfo(info.m_executeAfter) != null) {
            this.getSortedUpstreamNodesAddNode(sortedNodes, processedNodes, info.m_executeAfter, collectValid);
        }
        for (int input = 0; input < numInputs; ++input) {
            String upNode;
            if (input == 0 && info != null && info.m_executeAfter != null && this.getNodeInfo(info.m_executeAfter) != null) {
                this.getSortedUpstreamNodesAddNode(sortedNodes, processedNodes, info.m_executeAfter, collectValid);
            }
            if ((upNode = this.getUpstreamNode(nodeID, input)) == null) continue;
            this.getSortedUpstreamNodesAddNode(sortedNodes, processedNodes, upNode, collectValid);
        }
        sortedNodes.add(nodeID);
    }

    public int getMaxRowsPerBlock(String nodeID) {
        int val = this.getWorksheetPropertiesManager().getMaxRowsPerBlock();
        XTProps nodeProps = this.getNodeProperties(nodeID);
        if (nodeProps != null) {
            val = nodeProps.getInt("rowsToChunk", val);
        }
        return val;
    }

    public boolean getUseCache(String nodeID) {
        String globalCacheString;
        boolean globalVal = this.getWorksheetPropertiesManager().getUseCache();
        String cachingPropName = "useCache";
        String cacheString = globalCacheString = "global";
        XTProps nodeProps = this.getNodeProperties(nodeID);
        if (nodeProps != null) {
            cacheString = nodeProps.getValue(cachingPropName, globalCacheString);
        }
        if (cacheString.equals(globalCacheString)) {
            return globalVal;
        }
        if (cacheString.equals("yes") || cacheString.equals("useCache")) {
            return true;
        }
        if (cacheString.equals("no")) {
            return false;
        }
        return globalVal;
    }

    public int getDefaultStringSize() {
        int globalVal = this.getWorksheetPropertiesManager().getDefaultStringSize();
        return globalVal;
    }

    public int getMaxCategoricalLevels() {
        int globalVal = this.getWorksheetPropertiesManager().getMaxCategoricalLevels();
        return globalVal;
    }

    protected XMLTreeNetwork.Link getUpstreamLink(String nodeID, int inputNum) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? null : info.getUpstreamLink(inputNum);
    }

    protected String getUpstreamNode(String nodeID, int inputNum) {
        XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
        return link == null ? null : link.getFromNodeID();
    }

    protected void setNodeValid(String nodeID, boolean val) {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.m_valid = val;
        }
    }

    private boolean getNodeValid(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? false : info.m_valid;
    }

    public String getInputNodeName(String nodeID, int inputNum) {
        String upNodeID = this.getUpstreamNode(nodeID, inputNum);
        return upNodeID == null ? "" : this.getNodeName(upNodeID);
    }

    public String getInputNodeID(String nodeID, int inputNum) {
        return this.getUpstreamNode(nodeID, inputNum);
    }

    public boolean hasInputNode(String nodeID, int inputNum) {
        String upNodeID = this.getUpstreamNode(nodeID, inputNum);
        return upNodeID != null;
    }

    public String getNodeName(String nodeID) {
        String idString;
        String nam;
        NodeInfo info = this.getNodeInfo(nodeID);
        String string = nam = info == null ? "node-without-info" : info.getNodeName();
        if (nam.indexOf(10) >= 0) {
            nam = nam.replaceAll("\n", "");
        }
        if (!nam.endsWith(idString = " (" + nodeID + ")")) {
            nam = nam + idString;
        }
        return nam;
    }

    private String getNodeName(Collection c) {
        if (c == null) {
            return "{}";
        }
        String val = "";
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            String nodeID = (String)iter.next();
            val = val + this.getNodeName(nodeID);
            if (!iter.hasNext()) continue;
            val = val + ";";
        }
        return "{" + val + "}";
    }

    public static void setBufColumnDescription(CNKBuf buf, XTMetaData md, int maxLevels) throws Exception {
        int numColumns = md.getNumColumns();
        Vector columnNames = md.getColumnNames();
        buf.setNumColumns(numColumns);
        buf.setDefaultMaxAutoLevels(maxLevels);
        for (int colNum = 0; colNum < numColumns; ++colNum) {
            String colName = (String)columnNames.get(colNum);
            buf.setColumnName(colNum, colName);
            if (md.isCategoricalColumn(colNum)) {
                buf.setColumnType(colNum, "factor");
                Vector levels = md.getCategoricalDataFieldLevels(colName);
                String[] levelStrings = new String[levels.size()];
                for (int lev = 0; lev < levelStrings.length; ++lev) {
                    levelStrings[lev] = (String)levels.get(lev);
                }
                buf.setColumnLevelStrings(colNum, levelStrings);
                continue;
            }
            if (md.isStringColumn(colNum)) {
                buf.setColumnType(colNum, "string");
                int stringSize = md.getStringDataFieldWidth(colNum);
                buf.setColumnStringBytes(colNum, stringSize);
                continue;
            }
            if (md.isBlobColumn(colNum)) {
                buf.setColumnType(colNum, "blob");
                String blobClassName = md.getBlobDataFieldClassName(colNum);
                buf.setColumnBlobClassName(colNum, blobClassName);
                continue;
            }
            if (md.isDateTimeColumn(colNum)) {
                buf.setColumnType(colNum, "timeDate");
                continue;
            }
            buf.setColumnType(colNum, "double");
        }
    }

    private void updateMetaDataFromBuf(String nodeID, int outputNum, CNKBuf buf, CNKProcCount countProc) throws Exception {
        boolean isDynamicBuf = this.getNode(nodeID).hasDynamicOutputs();
        this.updateMetaDataFromBuf(nodeID, outputNum, buf, countProc, isDynamicBuf);
    }

    private static boolean nullCognizantCompare(Object v1, Object v2) {
        boolean emdNull;
        boolean thisNull = v1 == null;
        boolean bl = emdNull = v2 == null;
        if (thisNull != emdNull) {
            return false;
        }
        if (!thisNull) {
            return v1.equals(v2);
        }
        return true;
    }

    private void updateMetaDataFromBuf(String nodeID, int outputNum, CNKBuf buf, CNKProcCount countProc, boolean isDynamicBuf) throws Exception {
        String colType;
        String colName;
        int colNum;
        XTMetaData oldMD = this.getOutputMetaData(nodeID, outputNum);
        XTMetaData md = (XTMetaData)oldMD.clone();
        int numColumns = buf.getNumColumns();
        String columnsWithBadNamesOrTypes = "";
        if (isDynamicBuf) {
            md = new XTMetaData();
            for (colNum = 0; colNum < numColumns; ++colNum) {
                colName = buf.getColumnName(colNum);
                colType = buf.getColumnType(colNum);
                if (colType.equals("factor")) {
                    md.appendCategoricalDataField(colName, new String[0]);
                    continue;
                }
                if (colType.equals("double")) {
                    md.appendContinousDataField(colName);
                    continue;
                }
                if (colType.equals("string")) {
                    md.appendStringDataField(colName, buf.getColumnStringBytes(colNum));
                    continue;
                }
                if (colType.equals("blob")) {
                    md.appendBlobDataField(colName, buf.getColumnBlobClassName(colNum));
                    continue;
                }
                if (!colType.equals("timeDate")) continue;
                md.appendDateTimeDataField(colName);
            }
            this.getNode(nodeID).procModifyDynamicOutputsMetaData(buf.getWriter(0), outputNum, md);
        } else {
            for (colNum = 0; colNum < numColumns; ++colNum) {
                boolean typeEqual;
                colName = buf.getColumnName(colNum);
                colType = buf.getColumnType(colNum);
                boolean nameEqual = colName.equals(md.ordinalToName(colNum));
                boolean bl = typeEqual = colType.equals("factor") && md.isCategoricalColumn(colNum) || colType.equals("double") && md.isContinuousColumn(colNum) || colType.equals("string") && md.isStringColumn(colNum) || colType.equals("blob") && md.isBlobColumn(colNum) && EngineNetworkManager.nullCognizantCompare(buf.getColumnBlobClassName(colNum), md.getBlobDataFieldClassName(colNum)) || colType.equals("timeDate") && md.isDateTimeColumn(colNum);
                if (nameEqual && typeEqual || columnsWithBadNamesOrTypes.length() >= 100) continue;
                if (columnsWithBadNamesOrTypes.length() > 0) {
                    columnsWithBadNamesOrTypes = columnsWithBadNamesOrTypes + ",";
                }
                columnsWithBadNamesOrTypes = columnsWithBadNamesOrTypes + colName;
            }
        }
        if (columnsWithBadNamesOrTypes.length() > 0) {
            this.printlnWarning(this.getNodeName(nodeID) + ": output " + (outputNum + 1) + " has columns with bad names or types: " + columnsWithBadNamesOrTypes);
        }
        for (colNum = 0; colNum < numColumns; ++colNum) {
            int i;
            colName = buf.getColumnName(colNum);
            if (!md.isCategoricalColumn(colNum) || !buf.getColumnType(colNum).equals("factor")) continue;
            String[] levelStrings = buf.getColumnLevelStrings(colNum);
            md.setCategoricalLevels(colName, levelStrings);
            long[] levelCounts = new long[levelStrings.length];
            for (i = 0; i < levelCounts.length; ++i) {
                levelCounts[i] = 0L;
            }
            if (countProc != null) {
                int countProcLevels = countProc.getColumnNumLevels(colNum);
                for (int levelNum = 0; levelNum < countProcLevels; ++levelNum) {
                    long levelCount = countProc.getColumnLevelCount(colNum, levelNum);
                    int levelInt = countProc.getColumnLevelInt(colNum, levelNum);
                    if (levelInt < 0 || levelInt >= levelCounts.length) continue;
                    levelCounts[levelInt] = levelCount;
                }
            }
            for (i = 0; i < levelCounts.length; ++i) {
                md.appendCountsCategory(colName, levelStrings[i], levelCounts[i]);
            }
        }
        if (countProc != null) {
            long numRows = buf.getTotalNumRows();
            md.setNumRows(numRows);
            String columnsWithBadLevelsCounts = "";
            String columnsWithZeroLevelsCounts = "";
            for (int colNum2 = 0; colNum2 < numColumns; ++colNum2) {
                String colName2 = buf.getColumnName(colNum2);
                md.replaceNumericInfo(colName2, countProc.getColumnMean(colNum2), countProc.getColumnMin(colNum2), countProc.getColumnMax(colNum2), countProc.getColumnStdDev(colNum2), Double.NaN, Double.NaN);
                long totalOK = countProc.getColumnCountOK(colNum2);
                long totalNA = countProc.getColumnCountNA(colNum2);
                md.appendCounts(colName2, totalOK, totalNA);
                if (!buf.getColumnType(colNum2).equals("factor")) continue;
                boolean columnHasZeroLevelsCount = false;
                long mdTotalLevelOK = 0L;
                Vector levels = md.getCategoricalDataFieldLevels(colName2);
                long mdTotalNA = (long)md.getColumnMissingCount(colName2);
                long mdTotalOK = (long)md.getColumnRowCount(colName2);
                int mdNumLevels = levels.size();
                for (int levelNum = 0; levelNum < mdNumLevels; ++levelNum) {
                    String levelName = (String)levels.get(levelNum);
                    long levelCount = 0L;
                    try {
                        levelCount = Long.parseLong(md.getLevelCount(colName2, levelName));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    mdTotalLevelOK += levelCount;
                    if (levelCount >= 1L) continue;
                    columnHasZeroLevelsCount = true;
                }
                if (columnHasZeroLevelsCount && columnsWithZeroLevelsCounts.length() < 100) {
                    if (columnsWithZeroLevelsCounts.length() > 0) {
                        columnsWithZeroLevelsCounts = columnsWithZeroLevelsCounts + ",";
                    }
                    columnsWithZeroLevelsCounts = columnsWithZeroLevelsCounts + colName2;
                }
                if (mdTotalLevelOK == mdTotalOK && mdTotalNA + mdTotalOK == numRows && totalOK == mdTotalOK && totalNA == mdTotalNA || columnsWithBadLevelsCounts.length() >= 100) continue;
                if (columnsWithBadLevelsCounts.length() > 0) {
                    columnsWithBadLevelsCounts = columnsWithBadLevelsCounts + ",";
                }
                columnsWithBadLevelsCounts = columnsWithBadLevelsCounts + colName2;
            }
            if (columnsWithZeroLevelsCounts.length() > 0) {
                this.printlnDebug(this.getNodeName(nodeID) + ": output " + (outputNum + 1) + " has columns with zero level counts: " + columnsWithZeroLevelsCounts);
            }
            if (columnsWithBadLevelsCounts.length() > 0) {
                this.printlnWarning(this.getNodeName(nodeID) + ": output " + (outputNum + 1) + " has columns with bad level counts: " + columnsWithBadLevelsCounts);
            }
        }
        String columnsWithNullLevels = "";
        block10: for (int colNum3 = 0; colNum3 < numColumns; ++colNum3) {
            String colName3 = buf.getColumnName(colNum3);
            if (!md.isCategoricalColumn(colNum3)) continue;
            Vector levels = md.getCategoricalDataFieldLevels(colName3);
            int numLevels = levels.size();
            for (int i = 0; i < numLevels; ++i) {
                String level = (String)levels.get(i);
                if (level != null && level.length() >= 1) continue;
                if (columnsWithNullLevels.length() >= 100) continue block10;
                if (columnsWithNullLevels.length() > 0) {
                    columnsWithNullLevels = columnsWithNullLevels + ",";
                }
                columnsWithNullLevels = columnsWithNullLevels + colName3;
                continue block10;
            }
        }
        if (columnsWithNullLevels.length() > 0) {
            this.printlnWarning(this.getNodeName(nodeID) + ": output " + (outputNum + 1) + "columns with empty levels: " + columnsWithNullLevels);
        }
        this.setOutputMetaData(nodeID, outputNum, md);
    }

    private XMLTree readXML(String fileName) throws Exception {
        this.printlnDebug("reading XML from " + fileName);
        return XMLTree.readFromFile(fileName);
    }

    public void writeXML(String fileName, XMLTree xml) throws Exception {
        this.printlnDebug("writing XML to " + fileName);
        xml.saveToFile(fileName);
    }

    private XTMetaData createEmptyXTMetaData() {
        XTMetaData md = null;
        try {
            md = new XTMetaData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    public WorksheetPropertiesManager getWorksheetPropertiesManager() {
        return this.m_worksheetPropertiesManager;
    }

    public void storeWorksheetProperties(XTProps val) {
        this.m_worksheetPropertiesManager.setWorksheetProperties(val);
    }

    public void storeGuiGlobalOptions(XTProps val) {
        this.m_worksheetPropertiesManager.setGlobalProperties(val);
    }

    public String getAbsolutePath(String origFilePath) {
        File file;
        if (origFilePath == null || origFilePath.length() == 0) {
            return origFilePath;
        }
        String filePath = origFilePath;
        if (this.m_worksheetParameters != null && filePath.indexOf("%") > -1) {
            filePath = this.substituteParaeters(filePath);
        }
        if (!(file = new File(filePath)).isAbsolute()) {
            String defaultFileDir = this.m_worksheetPropertiesManager.getDefaultFileDirectory();
            if (defaultFileDir != null && defaultFileDir.length() > 0) {
                file = new File(defaultFileDir, filePath);
                filePath = file.getAbsolutePath();
            } else {
                File newParent;
                File parentDir;
                String cwd = System.getProperty("user.dir");
                File wsd = new File(this.getWorksheetDirPath());
                if (!wsd.isAbsolute()) {
                    wsd = new File(cwd, this.getWorksheetDirPath());
                }
                if ((parentDir = wsd.getParentFile()) == null) {
                    parentDir = new File(cwd);
                }
                if (parentDir.getAbsolutePath().equals(MinerApp.getTempDir()) && (newParent = parentDir.getParentFile()) != null) {
                    parentDir = newParent;
                }
                file = new File(parentDir, filePath);
                filePath = file.getAbsolutePath();
            }
        }
        return filePath;
    }

    public boolean doesFileExist(String filename) {
        String filePath = this.getAbsolutePath(filename);
        File fl = new File(filePath);
        return fl.exists() && fl.isFile();
    }

    public boolean doesDirectoryExist(String filename) {
        String filePath = this.getAbsolutePath(filename);
        File fl = new File(filePath);
        return fl.exists() && fl.isDirectory();
    }

    public XTProps getWorksheetParameters() {
        return this.m_worksheetParameters;
    }

    public String substituteParaeters(String possibleParam) {
        String string = possibleParam;
        if (this.m_worksheetParameters != null) {
            Vector params = this.m_worksheetParameters.getSubProperties(new String[0]);
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                int index = string.indexOf(param);
                if (index <= -1) continue;
                String paramVal = this.m_worksheetParameters.getValue(param, param);
                string = string.replaceAll(param, paramVal);
            }
        }
        return string;
    }

    private BufID getUpstreamBufID(String nodeID, int inputNum) {
        XMLTreeNetwork.Link link = this.getUpstreamLink(nodeID, inputNum);
        return link == null ? null : new BufID(link);
    }

    private boolean hasOutputDCF(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? false : this.hasOutputDCF(buf.getNodeID(), buf.getOutputNum());
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? false : info.hasOutputDCF(outputNum);
    }

    private boolean hasOutputDCF(BufID bi) {
        return this.hasOutputDCF(bi.getNodeID(), bi.getOutputNum());
    }

    protected void setHasOutputDCF(String nodeID, int outputNum, boolean val) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            if (buf != null) {
                this.setHasOutputDCF(buf.getNodeID(), buf.getOutputNum(), val);
            }
            return;
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.setHasOutputDCF(outputNum, val);
        }
    }

    protected void setHasOutputDCF(BufID bi, boolean val) {
        this.setHasOutputDCF(bi.getNodeID(), bi.getOutputNum(), val);
    }

    private boolean hasAllOutputDCF(String nodeID) {
        for (int outputNum = 0; outputNum < this.getNumOutputs(nodeID); ++outputNum) {
            if (this.hasOutputDCF(nodeID, outputNum)) continue;
            return false;
        }
        return true;
    }

    private boolean hasOutputSummary(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? false : this.hasOutputSummary(buf.getNodeID(), buf.getOutputNum());
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? false : info.hasOutputSummary(outputNum);
    }

    private boolean hasOutputSummary(BufID bi) {
        return this.hasOutputSummary(bi.getNodeID(), bi.getOutputNum());
    }

    protected void setHasOutputSummary(String nodeID, int outputNum, boolean val) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            if (buf != null) {
                this.setHasOutputSummary(buf.getNodeID(), buf.getOutputNum(), val);
            }
            return;
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info != null) {
            info.setHasOutputSummary(outputNum, val);
        }
    }

    protected void setHasOutputSummary(BufID bi, boolean val) {
        this.setHasOutputSummary(bi.getNodeID(), bi.getOutputNum(), val);
    }

    private boolean hasOutputMD(String nodeID, int outputNum) {
        if (this.isPhaseNode(nodeID)) {
            BufID buf = this.getPhaseNodeOutputBufID(nodeID, outputNum);
            return buf == null ? false : this.hasOutputMD(buf.getNodeID(), buf.getOutputNum());
        }
        NodeInfo info = this.getNodeInfo(nodeID);
        return info == null ? false : info.hasOutputMD(outputNum);
    }

    public static long getFileBytes(String filename) {
        try {
            File fl = new File(filename);
            long len = fl.length();
            return len;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private void addDCFBytes(String filename) {
        this.addDCFBytes(EngineNetworkManager.getFileBytes(filename));
    }

    private void removeDCFBytes(String filename) {
        this.addDCFBytes(-EngineNetworkManager.getFileBytes(filename));
    }

    private void removeDCFBytes(long len) {
        this.addDCFBytes(-len);
    }

    private void addRemoveDCFBytes(String filename) {
        long len = EngineNetworkManager.getFileBytes(filename);
        this.addDCFBytes(len);
        this.addDCFBytes(-len);
    }

    private void addDCFBytes(long len) {
        this.m_totalDCFBytes += len;
        if (this.m_totalDCFBytes < 0L) {
            this.m_totalDCFBytes = 0L;
        }
        if (this.m_totalDCFBytes > this.m_maxTotalDCFBytes) {
            this.m_maxTotalDCFBytes = this.m_totalDCFBytes;
        }
    }

    private void initMaxTotalDCFBytes() {
        this.m_maxTotalDCFBytes = this.m_totalDCFBytes;
    }

    private void initNodeMessages(String nodeID) {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info == null) {
            return;
        }
        info.m_numMessages = 0;
        info.m_errorsOverflowed = false;
        info.m_warningsOverflowed = false;
    }

    private boolean hasUnprintedMessages(String nodeID, CNKObj obj) {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info == null || obj == null) {
            return false;
        }
        int printedMessages = info.m_numMessages;
        int currentMessages = obj.getNumMessages();
        return currentMessages > printedMessages;
    }

    private void printNodeMessages(String nodeID, CNKObj obj) {
        NodeInfo info = this.getNodeInfo(nodeID);
        if (info == null || obj == null) {
            return;
        }
        int printedMessages = info.m_numMessages;
        int currentMessages = obj.getNumMessages();
        if (currentMessages < printedMessages) {
            return;
        }
        block6: for (int i = printedMessages; i < currentMessages; ++i) {
            String msg = this.getNodeName(nodeID) + ": " + obj.getMessage(i);
            int severity = obj.getMessageSeverity(i);
            switch (severity) {
                case 4: {
                    this.printlnError(msg);
                    continue block6;
                }
                case 3: {
                    this.printlnWarning(msg);
                    continue block6;
                }
                case 2: {
                    this.printlnInformation(msg);
                    continue block6;
                }
                case 1: {
                    this.printlnVerbose(msg);
                    continue block6;
                }
                default: {
                    this.printlnDebug(msg);
                }
            }
        }
        info.m_numMessages = currentMessages;
        int maxMessages = obj.getMaxMessages();
        if (currentMessages >= maxMessages) {
            if (!info.m_errorsOverflowed && obj.getNumMessagesAtLevel("error") >= maxMessages) {
                info.m_errorsOverflowed = true;
                this.printlnError(this.getNodeName(nodeID) + ": more than " + maxMessages + " errors -- some skipped");
            }
            if (!info.m_warningsOverflowed && obj.getNumMessagesAtLevel("warning") >= maxMessages) {
                info.m_warningsOverflowed = true;
                this.printlnWarning(this.getNodeName(nodeID) + ": more than " + maxMessages + " warnings -- some skipped");
            }
        }
    }

    private boolean isErrorProc(CNKProc proc) {
        return proc != null && proc instanceof ErrorProcJavaTransform;
    }

    private CNKProc createErrorProc(String badClassName, String msg) {
        ErrorProcJavaTransform xform = new ErrorProcJavaTransform(new ErrorProc(msg));
        xform.setName("ErrorProc:" + badClassName);
        return xform;
    }

    public void initStorageInfo() {
        this.m_minStorage = -1L;
        this.m_maxStorage = -1L;
        this.m_lastStorage = -1L;
    }

    public void updateStorageInfo() {
        long before = System.currentTimeMillis();
        long st = CNKObj.getDataStorage();
        long after = System.currentTimeMillis();
        long msecs = after - before;
        if (st >= 0L) {
            if (this.m_minStorage < 0L) {
                this.m_minStorage = st;
                this.m_maxStorage = st;
            } else if (st < this.m_minStorage) {
                this.m_minStorage = st;
            } else if (st > this.m_maxStorage) {
                this.m_maxStorage = st;
            }
        }
        if (this.m_lastStorage != st) {
            this.printlnDebug("storage=" + st + " [" + this.m_minStorage + "," + this.m_maxStorage + "]=" + this.getNiceStorageString() + ", time=" + msecs);
        }
        this.m_lastStorage = st;
    }

    public String getNiceStorageString() {
        if (this.m_minStorage < 0L) {
            return null;
        }
        return this.getNiceBytesString(this.m_maxStorage - this.m_minStorage);
    }

    private void addPhaseNode(String phaseNodeID, EngineNode.Phase ph, int phaseNum) {
        NodeInfo info = new NodeInfo();
        info.m_node = ph.m_node;
        info.m_isDummyNode = false;
        info.m_engineNodeClassName = "phaseNodeClass";
        info.m_numInputs = ph.getNumInputs();
        info.m_numOutputs = ph.getNumOutputs();
        info.m_valid = false;
        info.m_nodeProperties = ph.m_props;
        info.m_executeAfter = ph.m_executeAfter;
        info.m_nodeModelParent = ph.m_modelParent;
        info.m_nodeModel = ph.m_modelString;
        info.m_inputLinks = null;
        info.m_outputInfo = null;
        info.m_nodeName = this.getNodeName(ph.m_parentNode.getNodeID()) + "-phase" + phaseNum;
        this.m_nodeIDToInfoHash.put(phaseNodeID, info);
        this.m_nodeIDToPhaseHash.put(phaseNodeID, ph);
    }

    private void removePhaseNode(String nodeID) {
        this.m_nodeIDToInfoHash.remove(nodeID);
        this.m_nodeIDToPhaseHash.remove(nodeID);
    }

    private void clearPhaseNodes() {
        HashSet phaseNodes = new HashSet(this.m_nodeIDToPhaseHash.keySet());
        for (String nodeID : phaseNodes) {
            this.printlnDebug("clearing phase nodeID " + nodeID);
            this.removePhaseNode(nodeID);
        }
    }

    private boolean isPhaseNode(String nodeID) {
        return this.m_nodeIDToPhaseHash.containsKey(nodeID);
    }

    private BufID getPhaseNodeInputBufID(String nodeID, int inputNum) {
        EngineNode.Phase ph = (EngineNode.Phase)this.m_nodeIDToPhaseHash.get(nodeID);
        if (ph == null) {
            return this.getUpstreamBufID(nodeID, inputNum);
        }
        if (inputNum < 0 || inputNum >= ph.getNumInputs()) {
            return null;
        }
        EngineNode.PortSpec port = ph.getInputPortSpec(inputNum);
        int portNum = port.getPortNum();
        if (port.isOutput()) {
            return this.getPhaseNodeOutputBufID(ph.m_parentNode.getNodeID(), portNum);
        }
        if (port.isTemp()) {
            return new BufID(ph.m_parentNode.getNodeID() + "-t" + portNum, 0);
        }
        return this.getPhaseNodeInputBufID(ph.m_parentNode.getNodeID(), portNum);
    }

    private BufID getPhaseNodeOutputBufID(String nodeID, int outputNum) {
        EngineNode.Phase ph = (EngineNode.Phase)this.m_nodeIDToPhaseHash.get(nodeID);
        if (ph == null) {
            return new BufID(nodeID, outputNum);
        }
        if (outputNum < 0 || outputNum >= ph.getNumOutputs()) {
            return null;
        }
        EngineNode.PortSpec port = ph.getOutputPortSpec(outputNum);
        int portNum = port.getPortNum();
        if (port.isOutput()) {
            return this.getPhaseNodeOutputBufID(ph.m_parentNode.getNodeID(), portNum);
        }
        if (port.isTemp()) {
            return new BufID(ph.m_parentNode.getNodeID() + "-t" + portNum, 0);
        }
        throw new RuntimeException("shouldn't happen");
    }

    public boolean executeMultiPhaseNode(String nodeID) {
        this.clearOutputMetaData(nodeID);
        EngineNode node = this.getNode(nodeID);
        if (node == null) {
            this.printlnDebug("no such MultiPhase node " + this.getNodeName(nodeID));
            return false;
        }
        this.printlnDebug("executing MultiPhase node " + this.getNodeName(nodeID));
        boolean ok = true;
        String baseText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        HashSet<Integer> tempPortsWritten = new HashSet<Integer>();
        HashSet<Integer> outputPortsWritten = new HashSet<Integer>();
        int phaseNum = 1;
        while (true) {
            Integer portInt;
            EngineNode.PortSpec port;
            this.printlnDebug("fetching MultiPhase node " + this.getNodeName(nodeID) + " phase " + phaseNum);
            EngineNode.Phase ph = null;
            try {
                ph = node.getPhase(phaseNum);
            }
            catch (Exception ex) {
                this.printlnError(this.getNodeName(nodeID) + ": " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace(System.out);
                ok = false;
            }
            catch (OutOfMemoryError ex) {
                this.printlnError(this.getNodeName(nodeID) + ": out of memory error");
                ex.printStackTrace(System.out);
                ok = false;
            }
            if (ph == null || !ok) break;
            String newStatus = baseText + ": " + (ph.m_statusLabel == null ? "phase " + phaseNum : ph.m_statusLabel) + "...";
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{newStatus});
            EngineNode phaseNode = ph.m_node;
            if (phaseNode == null) {
                this.printlnError(this.getNodeName(nodeID) + ": bad phase " + phaseNum);
                ok = false;
                break;
            }
            for (int in = 0; in < ph.getNumInputs(); ++in) {
                port = ph.getInputPortSpec(in);
                portInt = new Integer(port.getPortNum());
                if (port.isTemp() && !tempPortsWritten.contains(portInt)) {
                    this.printlnError(this.getNodeName(nodeID) + ": phase " + phaseNum + " tried to read unset temp " + port.getPortNum());
                    ok = false;
                    break;
                }
                if (!port.isOutput() || outputPortsWritten.contains(portInt)) continue;
                this.printlnError(this.getNodeName(nodeID) + ": phase " + phaseNum + " tried to read unset output " + port.getPortNum());
                ok = false;
                break;
            }
            if (!ok) break;
            for (int out = 0; out < ph.getNumOutputs(); ++out) {
                port = ph.getOutputPortSpec(out);
                portInt = new Integer(port.getPortNum());
                if (port.isTemp()) {
                    if (tempPortsWritten.contains(portInt)) continue;
                    String tempNodeID = nodeID + "-t" + port.getPortNum();
                    this.printlnDebug("creating temp node :" + tempNodeID);
                    NodeInfo tempInfo = new NodeInfo();
                    tempInfo.m_numInputs = 0;
                    tempInfo.m_inputLinks = new XMLTreeNetwork.Link[0];
                    tempInfo.m_numOutputs = 1;
                    tempInfo.m_outputInfo = new OutputInfo[]{new OutputInfo()};
                    this.m_nodeIDToInfoHash.put(tempNodeID, tempInfo);
                    tempPortsWritten.add(portInt);
                    continue;
                }
                if (port.isOutput()) {
                    outputPortsWritten.add(portInt);
                    continue;
                }
                this.printlnError(this.getNodeName(nodeID) + ": phase " + phaseNum + " tried to write to input " + port.getPortNum());
                ok = false;
                break;
            }
            if (!ok) break;
            String phaseNodeID = nodeID + "-p" + phaseNum;
            phaseNode.setNodeID(phaseNodeID);
            phaseNode.setNetworkManager(this);
            this.addPhaseNode(phaseNodeID, ph, phaseNum);
            for (int out = 0; out < ph.getNumOutputs(); ++out) {
                this.setOutputMetaData(phaseNodeID, out, null);
            }
            int execType = phaseNode.getExecutionType();
            try {
                ok = execType == 1 ? this.executeDataCacheProc(phaseNodeID) : (execType == 2 ? this.executeMultiPhaseNode(phaseNodeID) : this.executeCNKProc(phaseNodeID));
            }
            catch (Exception ex) {
                this.printlnError(this.getNodeName(nodeID) + ": error executing phase " + phaseNum + ": " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace();
                ok = false;
            }
            this.removePhaseNode(phaseNodeID);
            if (!ok) break;
            ++phaseNum;
        }
        for (Integer tempInt : tempPortsWritten) {
            String tempNodeID = nodeID + "-t" + tempInt;
            this.removeNode(tempNodeID);
        }
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{baseText});
        return ok;
    }

    public static String getExceptionMessage(Throwable ex) {
        if (ex == null) {
            return "null exception";
        }
        String msg = ex.getMessage();
        if (msg == null) {
            msg = ex.toString();
        }
        return msg;
    }

    public void closeDataViewerFiles() {
        Set engineNodes = this.getEngineNodes();
        for (String nodeID : engineNodes) {
            EngineNode node = this.getNode(nodeID);
            if (node == null) continue;
            node.closeDataViewerFiles();
        }
    }

    public void clearNodeDataCaches(Vector nodeIDs) {
        if (this.isRunning()) {
            this.printlnError("Can't clear data caches while network is running.");
            this.printlnInformation("");
            return;
        }
        if (nodeIDs == null) {
            nodeIDs = new Vector();
        }
        int numDeleted = 0;
        long totalBytesDeleted = 0L;
        try {
            this.closeDataViewerFiles();
            for (int i = 0; i < nodeIDs.size(); ++i) {
                String nodeID = (String)nodeIDs.get(i);
                int numOutputs = this.getNumOutputs(nodeID);
                for (int outNum = 0; outNum < numOutputs; ++outNum) {
                    if (this.hasOutputDCF(nodeID, outNum)) {
                        String dcfFile = this.getOutputDataCacheFileName(nodeID, outNum);
                        long fileBytes = EngineNetworkManager.getFileBytes(dcfFile);
                        totalBytesDeleted += fileBytes;
                        this.removeDCFBytes(fileBytes);
                        this.deleteFile(dcfFile);
                        this.deleteFile(this.getOutputDataBlobFileName(nodeID, outNum));
                        ++numDeleted;
                    }
                    this.setHasOutputDCF(nodeID, outNum, false);
                }
            }
            this.saveEngineState();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initMaxTotalDCFBytes();
        this.printlnInformation(MinerApp.getText("MinerFrame_info_deleted") + " " + numDeleted + " " + MinerApp.getText("MinerFrame_info_datacache_withsize") + " " + this.getNiceBytesString(totalBytesDeleted));
        this.printlnInformation("");
    }

    public void displayNodeCacheInfo(Vector nodeIDs) {
        if (nodeIDs == null) {
            nodeIDs = new Vector();
        }
        long totalDataCacheBytes = 0L;
        long totalOtherBytes = 0L;
        this.printlnInformation("Cache information for " + nodeIDs.size() + " valid node(s):");
        for (int i = 0; i < nodeIDs.size(); ++i) {
            String nodeID = (String)nodeIDs.get(i);
            long dataCacheBytes = this.getNodeDataCacheBytes(nodeID);
            long otherBytes = this.getNodeOtherCacheBytes(nodeID);
            totalDataCacheBytes += dataCacheBytes;
            totalOtherBytes += otherBytes;
            this.printlnInformation("  " + this.getNodeName(nodeID) + ": data cache=" + this.getNiceBytesString(dataCacheBytes) + ", other caches=" + this.getNiceBytesString(otherBytes));
        }
        this.printlnInformation("Totals: data cache=" + this.getNiceBytesString(totalDataCacheBytes) + ", other caches=" + this.getNiceBytesString(totalOtherBytes));
        this.printlnInformation("");
    }

    public String getTotalCacheSizeString() {
        List nodeIDs = this.getValidNodes();
        long totalDataCacheBytes = 0L;
        long totalOtherBytes = 0L;
        for (int i = 0; i < nodeIDs.size(); ++i) {
            String nodeID = (String)nodeIDs.get(i);
            long dataCacheBytes = this.getNodeDataCacheBytes(nodeID);
            long otherBytes = this.getNodeOtherCacheBytes(nodeID);
            totalDataCacheBytes += dataCacheBytes;
            totalOtherBytes += otherBytes;
        }
        return this.getNiceBytesString(totalDataCacheBytes + totalOtherBytes);
    }

    public boolean hasNodeDataCache(String nodeID, int outputNum) {
        return this.hasOutputDCF(nodeID, outputNum);
    }

    public long getNodeDataCacheBytes(String nodeID) {
        long totalBytes = 0L;
        int numOutputs = this.getNumOutputs(nodeID);
        for (int outNum = 0; outNum < numOutputs; ++outNum) {
            if (!this.hasOutputDCF(nodeID, outNum)) continue;
            String filename = this.getOutputDataCacheFileName(nodeID, outNum);
            totalBytes += EngineNetworkManager.getFileBytes(filename);
        }
        return totalBytes;
    }

    public long getNodeOtherCacheBytes(String nodeID) {
        long totalBytes = 0L;
        int numOutputs = this.getNumOutputs(nodeID);
        for (int outNum = 0; outNum < numOutputs; ++outNum) {
            if (!this.hasOutputMD(nodeID, outNum)) continue;
            String filename = this.getOutputMetaDataFileName(nodeID, outNum);
            totalBytes += EngineNetworkManager.getFileBytes(filename);
        }
        Set cacheNames = this.getNodeCacheNames(nodeID);
        for (String cacheName : cacheNames) {
            String filename = this.getNodeCacheFileName(nodeID, cacheName);
            totalBytes += EngineNetworkManager.getFileBytes(filename);
        }
        return totalBytes;
    }

    public void nodeCloseDataViewerFiles(String nodeID) {
        EngineNode node = this.getNode(nodeID);
        if (node == null) {
            return;
        }
        node.closeDataViewerFiles();
    }

    public long getNodeDataViewerNumRows(String nodeID, int portIndex, boolean isInput) {
        EngineNode node = this.getNode(nodeID);
        return node == null ? 0L : node.getDataViewerNumRows(portIndex, isInput);
    }

    public int getNodeDataViewerNumColumns(String nodeID, int portIndex, boolean isInput) {
        EngineNode node = this.getNode(nodeID);
        return node == null ? 0 : node.getDataViewerNumColumns(portIndex, isInput);
    }

    public String[] getNodeDataViewerColumnNames(String nodeID, int portIndex, boolean isInput) {
        EngineNode node = this.getNode(nodeID);
        return node == null ? null : node.getDataViewerColumnNames(portIndex, isInput);
    }

    public String[] getNodeDataViewerDataArray(String nodeID, long fromRow, long toRow, int fromCol, int toCol, int portIndex, boolean isInput) {
        EngineNode node = this.getNode(nodeID);
        return node == null ? new String[]{} : node.getDataViewerDataArray(fromRow, toRow, fromCol, toCol, portIndex, isInput);
    }

    public void getNodeDataViewerChartStats(String nodeID, Vector displayColumns, int portIndex, boolean isInput, int viewerID, long updateTime, String title, ChartBuilder cBuilder) {
        EngineNode node = this.getNode(nodeID);
        if (node == null) {
            return;
        }
        node.getDataViewerChartStats(displayColumns, portIndex, isInput, viewerID, updateTime, title, cBuilder);
    }

    public void nodeExecContinue(String nodeID) {
        EngineNode node = this.getNode(nodeID);
        if (node == null) {
            return;
        }
        node.execContinue();
    }

    public static void checkSplusWorkingChapter(String chapterString) {
        if (!g_splusWorkingChapterSetup) {
            g_splusWorkingChapterSplusAvailable = MinerApp.isSplusLicensed();
            g_splusWorkingChapterSetup = true;
        }
        if (!g_splusWorkingChapterSplusAvailable) {
            return;
        }
        if (chapterString == null) {
            chapterString = "";
        }
        if (chapterString.equals(g_splusWorkingChapter)) {
            return;
        }
        try {
            String defaultDirectory = MinerApp.getDefaultWorkingChapter();
            String newDirectory = chapterString.equals("") ? defaultDirectory : chapterString;
            EngineNetworkManager.globalPrintlnDebug("changing working chapter \"" + g_splusWorkingChapter + "\" -> \"" + chapterString + "\"");
            String splusExpr = "{{function(newchap,defchap){\nif (!isChapter(newchap)) {\ncat(\"Can't change working chapter to\",newchap,\"\\n  (using\",defchap,\")\\n\")\nnewchap <- defchap}\noldSP <- searchPaths()\nattach(newchap, pos=1)\nnewSP <- searchPaths()\nif (oldSP[1]!=newSP[1]) {detach(2)}\nNULL}}(\"" + StringUtilities.escapeSpecialCharacters((String)newDirectory) + "\",\n" + "\"" + StringUtilities.escapeSpecialCharacters((String)defaultDirectory) + "\")}";
            SplusDataResult result = MinerApp.eval(splusExpr);
            if (result.hasError()) {
                EngineNetworkManager.globalPrintlnDebug("error switching working chapter: " + result.getError());
            }
            g_splusWorkingChapter = chapterString;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkSplusWorkingChapter() {
        if (this.isRunning()) {
            return;
        }
        EngineNetworkManager.checkSplusWorkingChapter(this.getWorksheetPropertiesManager().getSplusWorkingChapter());
    }

    public void setStatusExecuting(List subgraph) {
        String msg = MinerApp.getText("MinerFrame_info_execute") + " " + this.getNodeName(subgraph);
        EngineMessageHandler.sendMessageToApp("setStatusText", new String[]{msg});
    }

    public void setStatusExecuting(String nodeID) {
        String msg = MinerApp.getText("MinerFrame_info_execute") + " {" + this.getNodeName(nodeID) + "}";
        EngineMessageHandler.sendMessageToApp("setStatusText", new String[]{msg});
    }

    public EngineStringConverter getEngineStringConverter(String parserString, String formatterString) {
        return new EngineStringConverter(this.getWorksheetPropertiesManager(), parserString, formatterString);
    }

    public CNKProcSplusTransform createSplusProc() throws Exception {
        if (!this.isSplusLicensed() && !MinerApp.isInBDL()) {
            throw new Exception("S-PLUS Library not installed.  Cannot execute script.");
        }
        CNKProcSplusTransform proc = new CNKProcSplusTransform();
        proc.setMangleColumnNames(true);
        return proc;
    }

    public void incrementCopyCacheBytes(long bytes) {
        m_statCacheCopyBytes += bytes;
    }

    public static double[] getStats() {
        long ms = System.currentTimeMillis();
        if (m_statMilliseconds == 0L) {
            m_statMilliseconds = ms;
        }
        return new double[]{ms - m_statMilliseconds, m_statPipelines, m_statErrors, m_statNodes, m_statDataCacheProcs, m_statSplusNodes, m_statSorts, m_statProcBlocks, m_statInputBytes, m_statOutputBytes, m_statOutputSummaryBytes, m_statSortWriteBytes, m_statSmallToBigBytes, m_statBigToSmallBytes, m_statCacheCopyBytes};
    }

    public static void resetStats() {
        long ms = System.currentTimeMillis();
        if (m_statMilliseconds == 0L) {
            m_statMilliseconds = System.currentTimeMillis();
        }
        m_statPipelines = 0L;
        m_statErrors = 0L;
        m_statNodes = 0L;
        m_statProcBlocks = 0L;
        m_statSplusNodes = 0L;
        m_statSorts = 0L;
        m_statSortWriteBytes = 0L;
        m_statDataCacheProcs = 0L;
        m_statInputBytes = 0L;
        m_statOutputBytes = 0L;
        m_statOutputSummaryBytes = 0L;
        m_statSmallToBigBytes = 0L;
        m_statBigToSmallBytes = 0L;
        m_statCacheCopyBytes = 0L;
    }

    public static void updateBufStats(CNKBuf buf) {
        if (buf != null && buf instanceof CNKBackingFileBuf) {
            CNKBackingFileBuf bfb = (CNKBackingFileBuf)buf;
            boolean isWritten = bfb.getNumWriters() > 0;
            long bytes = EngineNetworkManager.getFileBytes(bfb.getFileName());
            if (isWritten) {
                m_statOutputBytes += bytes;
            } else {
                m_statInputBytes += bytes;
            }
        }
    }

    static /* synthetic */ Object[] access$002(EngineNetworkManager x0, Object[] x1) {
        x0.m_runRequest = x1;
        return x1;
    }

    static {
        m_longFormat.setGroupingUsed(true);
        m_longFormat.setMaximumFractionDigits(1);
        g_splusWorkingChapterSetup = false;
        g_splusWorkingChapterSplusAvailable = false;
        g_splusWorkingChapter = "";
        m_statPipelines = 0L;
        m_statErrors = 0L;
        m_statNodes = 0L;
        m_statProcBlocks = 0L;
        m_statSplusNodes = 0L;
        m_statSorts = 0L;
        m_statSortWriteBytes = 0L;
        m_statDataCacheProcs = 0L;
        m_statInputBytes = 0L;
        m_statOutputBytes = 0L;
        m_statOutputSummaryBytes = 0L;
        m_statSmallToBigBytes = 0L;
        m_statBigToSmallBytes = 0L;
        m_statCacheCopyBytes = 0L;
        m_statMilliseconds = 0L;
    }

    private static class UnknownNode
    extends EngineNode {
        String m_msg = null;

        public UnknownNode(String msg) {
            this.m_msg = msg;
        }

        public CNKProc procCreate() throws Exception {
            throw new Exception(this.m_msg == null ? "unknown node" : this.m_msg);
        }
    }

    private static class ErrorProcJavaTransform
    extends CNKProcJavaTransform {
        public ErrorProcJavaTransform(ErrorProc proc) {
            super(proc);
        }
    }

    private static class ErrorProc
    implements CNKProcJavaTransformExec {
        String m_msg;

        ErrorProc(String msg) {
            this.m_msg = msg != null ? msg : "unknown error";
        }

        public void execute(CNKProcJavaTransform proc) {
            proc.setError(this.m_msg);
        }
    }

    private class BufID {
        String m_nodeID;
        int m_outputNum;

        BufID(String nodeID, int outputNum) {
            this.m_nodeID = nodeID;
            this.m_outputNum = outputNum;
        }

        BufID(XMLTreeNetwork.Link link) {
            this(link.getFromNodeID(), link.getFromOutputPort());
        }

        String getNodeID() {
            return this.m_nodeID;
        }

        int getOutputNum() {
            return this.m_outputNum;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BufID)) {
                return false;
            }
            BufID b = (BufID)obj;
            return this.m_outputNum == b.m_outputNum && this.m_nodeID.equals(b.m_nodeID);
        }

        public int hashCode() {
            return this.m_nodeID.hashCode() + this.m_outputNum;
        }

        public String toString() {
            return EngineNetworkManager.this.getNodeName(this.m_nodeID) + "/" + this.m_outputNum;
        }
    }

    private class IncrementalExecutionPlan
    implements SubgraphPlan {
        List m_runToNodes = new Vector();
        Set m_execNodes = null;
        List m_orderedExecNodes = null;
        int m_nextExecNodeIndex = 0;
        Set m_dcfBufs = null;
        Set m_permBufs = null;
        Set m_outsideBufs = null;
        Set m_badNodes = null;
        Set m_processedNodes = null;
        List m_subgraphExecNodes = null;
        CNKPipeline m_pip = null;
        Hashtable m_bufID2BufHash = null;
        Hashtable m_auxLink2BufHash = null;
        Hashtable m_bufID2SummaryProcHash = null;
        Hashtable m_nodeID2ProcHash = null;
        Vector m_progressNodes = null;
        Vector m_progressNodeTotalEstimatedRows = null;

        IncrementalExecutionPlan(List runToNodes) throws Exception {
            for (int i = 0; i < runToNodes.size(); ++i) {
                String nodeID = (String)runToNodes.get(i);
                if (EngineNetworkManager.this.isValid(nodeID) && (!EngineNetworkManager.this.getUseCache(nodeID) || EngineNetworkManager.this.hasAllOutputDCF(nodeID))) continue;
                this.m_runToNodes.add(nodeID);
            }
            EngineNetworkManager.this.printlnDebug("non-valid runTo nodes: " + EngineNetworkManager.this.getNodeName(this.m_runToNodes));
            this.m_orderedExecNodes = EngineNetworkManager.this.getSortedRunNodes(this.m_runToNodes);
            String cycleNode = EngineNetworkManager.this.getCycleNode(this.m_orderedExecNodes);
            if (cycleNode != null) {
                throw new Exception("cycle in network at " + EngineNetworkManager.this.getNodeName(cycleNode));
            }
            EngineNetworkManager.this.printlnDebug("execNodes: " + EngineNetworkManager.this.getNodeName(this.m_orderedExecNodes));
            this.m_execNodes = new HashSet(this.m_orderedExecNodes);
        }

        public boolean anyNodesToExecute() {
            return this.m_orderedExecNodes.size() > 0;
        }

        public int getNumberNodesToBeExecuted() {
            return this.m_orderedExecNodes.size();
        }

        public int getNumberNodesExecuted() {
            int numExecuted = 0;
            int numNodes = this.m_orderedExecNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                if (!EngineNetworkManager.this.isValid((String)this.m_orderedExecNodes.get(i))) continue;
                ++numExecuted;
            }
            return numExecuted;
        }

        public List getExecutedNodes() {
            Vector<String> executedNodes = new Vector<String>();
            int numNodes = this.m_orderedExecNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                String nodeID = (String)this.m_orderedExecNodes.get(i);
                if (!EngineNetworkManager.this.isValid(nodeID)) continue;
                executedNodes.add(nodeID);
            }
            return executedNodes;
        }

        public List getUnexecutedNodes() {
            Vector<String> nodes = new Vector<String>();
            int numNodes = this.m_orderedExecNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                String nodeID = (String)this.m_orderedExecNodes.get(i);
                if (EngineNetworkManager.this.isValid(nodeID)) continue;
                nodes.add(nodeID);
            }
            return nodes;
        }

        private void addDCF(BufID bi, String msg) {
            if (this.m_dcfBufs.contains(bi)) {
                return;
            }
            this.m_dcfBufs.add(bi);
            EngineNetworkManager.this.printlnDebug("adding DCF " + bi + ": " + msg);
        }

        private void addDCF(String nodeID, String msg) {
            int numOutputs = EngineNetworkManager.this.getNumOutputs(nodeID);
            for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
                this.addDCF(new BufID(nodeID, outputNum), msg);
            }
        }

        private void addPermDCF(BufID bi, String msg) {
            if (this.m_permBufs.contains(bi)) {
                return;
            }
            this.m_dcfBufs.add(bi);
            this.m_permBufs.add(bi);
            EngineNetworkManager.this.printlnDebug("adding perm DCF " + bi + ": " + msg);
        }

        private void addOutsideDCF(BufID bi, String msg) {
            if (this.m_outsideBufs.contains(bi)) {
                return;
            }
            this.m_dcfBufs.add(bi);
            this.m_permBufs.add(bi);
            this.m_outsideBufs.add(bi);
            EngineNetworkManager.this.printlnDebug("adding outside DCF " + bi + ": " + msg);
        }

        private boolean isDCF(BufID bi) {
            return this.m_dcfBufs.contains(bi);
        }

        public void execute() throws Exception {
            String nodeID;
            int i;
            for (i = 0; i < this.m_orderedExecNodes.size(); ++i) {
                nodeID = (String)this.m_orderedExecNodes.get(i);
                EngineNetworkManager.this.getNode(nodeID).closeDataViewerFiles();
                EngineNetworkManager.this.getNode(nodeID).invalidateNodeState();
            }
            this.m_badNodes = new HashSet();
            this.m_processedNodes = new HashSet();
            this.m_dcfBufs = new HashSet();
            this.m_permBufs = new HashSet();
            this.m_outsideBufs = new HashSet();
            for (i = 0; i < this.m_orderedExecNodes.size(); ++i) {
                XMLTreeNetwork.Link upstreamLink;
                int inputNum;
                nodeID = (String)this.m_orderedExecNodes.get(i);
                EngineNode node = EngineNetworkManager.this.getNode(nodeID);
                NodeInfo info = EngineNetworkManager.this.getNodeInfo(nodeID);
                if (info == null || node == null) {
                    this.addBadNode(nodeID, "unknown node");
                    continue;
                }
                int numInputsFromExecNodes = 0;
                for (inputNum = 0; inputNum < EngineNetworkManager.this.getNumInputs(nodeID); ++inputNum) {
                    upstreamLink = EngineNetworkManager.this.getUpstreamLink(nodeID, inputNum);
                    if (upstreamLink == null) {
                        this.addBadNode(nodeID, "unconnected input " + inputNum);
                        break;
                    }
                    if (this.m_execNodes.contains(upstreamLink.getFromNodeID())) {
                        ++numInputsFromExecNodes;
                        continue;
                    }
                    BufID upBufID = new BufID(upstreamLink);
                    this.addOutsideDCF(upBufID, "input to " + EngineNetworkManager.this.getNodeName(nodeID));
                    if (EngineNetworkManager.this.hasOutputDCF(upBufID)) continue;
                    this.addBadNode(nodeID, "outside buf without DCF: " + upBufID);
                    break;
                }
                if (numInputsFromExecNodes <= true) continue;
                for (inputNum = 0; inputNum < EngineNetworkManager.this.getNumInputs(nodeID); ++inputNum) {
                    upstreamLink = EngineNetworkManager.this.getUpstreamLink(nodeID, inputNum);
                    this.addDCF(new BufID(upstreamLink), "multi-inputs for node " + EngineNetworkManager.this.getNodeName(nodeID));
                }
            }
            this.m_nextExecNodeIndex = 0;
            while (!EngineNetworkManager.this.isInterruptRequested()) {
                EngineNetworkManager.this.initStorageInfo();
                EngineNetworkManager.this.updateStorageInfo();
                long before = System.currentTimeMillis();
                boolean somethingExecuted = this.extractAndExecuteNext();
                if (!somethingExecuted) break;
                this.deleteUnneededDCFFiles();
                EngineNetworkManager.this.saveEngineState();
                long after = System.currentTimeMillis();
                long execTimeMsecs = after - before;
                EngineNetworkManager.this.updateStorageInfo();
                String storageString = EngineNetworkManager.this.getNiceStorageString();
                storageString = storageString == null ? "" : ", mem=" + storageString;
                EngineNetworkManager.this.printlnInformation("      " + MinerApp.getText("MinerFrame_info_execute_time") + EngineNetworkManager.this.getNiceTimeString(execTimeMsecs) + ", " + EngineNetworkManager.this.getDCFByteString() + storageString);
                EngineNetworkManager.this.printlnInformation("");
            }
        }

        private boolean extractAndExecuteNext() {
            String nodeID;
            EngineNode node;
            int execType;
            while (this.m_nextExecNodeIndex < this.m_orderedExecNodes.size() && this.m_processedNodes.contains(this.m_orderedExecNodes.get(this.m_nextExecNodeIndex))) {
                ++this.m_nextExecNodeIndex;
            }
            if (this.m_nextExecNodeIndex >= this.m_orderedExecNodes.size()) {
                return false;
            }
            if ((execType = (node = EngineNetworkManager.this.getNode(nodeID = (String)this.m_orderedExecNodes.get(this.m_nextExecNodeIndex++))).getExecutionType()) == 1) {
                this.updateNodeAllDCF(nodeID);
                this.executeDataCacheProc(nodeID);
                return true;
            }
            if (execType == 2) {
                this.updateNodeAllDCF(nodeID);
                this.executeMultiPhaseNode(nodeID);
                return true;
            }
            List subgraph = this.extractSubgraph(nodeID);
            if (MinerApp.isSolarisOS() && MinerApp.isInteractive()) {
                boolean useMainThread = false;
                for (int i = 0; i < subgraph.size(); ++i) {
                    Object obj = subgraph.get(i);
                    if (obj == null || !(obj instanceof ReadNativeSybaseDatabaseEngineNode) && !(obj instanceof WriteNativeSybaseDatabaseEngineNode)) continue;
                    useMainThread = true;
                }
                if (useMainThread) {
                    final List thisSubgraph = subgraph;
                    MinerApp.runInMainThread(new Runnable(){

                        public void run() {
                            IncrementalExecutionPlan.this.executeSubgraphPipeline(thisSubgraph);
                        }
                    });
                    return true;
                }
            }
            this.executeSubgraphPipeline(subgraph);
            return true;
        }

        private List extractSubgraph(String nodeID) {
            Vector subgraph = new Vector();
            this.extractSubgraphAddNode(nodeID, subgraph);
            return subgraph;
        }

        private void extractSubgraphAddNode(String nodeID, List subgraph) {
            this.updateNodeAllDCF(nodeID);
            subgraph.add(nodeID);
            NodeInfo info = EngineNetworkManager.this.getNodeInfo(nodeID);
            for (int outNum = 0; outNum < info.m_numOutputs; ++outNum) {
                XMLTreeNetwork.Link link;
                int i;
                BufID bi = new BufID(nodeID, outNum);
                if (this.isDCF(bi)) continue;
                List links = info.getDownstreamLinks(outNum);
                for (i = 0; i < links.size(); ++i) {
                    link = (XMLTreeNetwork.Link)links.get(i);
                    if (this.m_processedNodes.contains(link.getToNodeID()) || !this.m_execNodes.contains(link.getToNodeID())) continue;
                    this.updateNodeInputDCF(link.getToNodeID(), link.getToInputPort());
                    if (this.isDCF(bi)) break;
                }
                if (this.isDCF(bi)) continue;
                for (i = 0; i < links.size(); ++i) {
                    link = (XMLTreeNetwork.Link)links.get(i);
                    if (this.m_processedNodes.contains(link.getToNodeID()) || !this.m_execNodes.contains(link.getToNodeID())) continue;
                    this.extractSubgraphAddNode(link.getToNodeID(), subgraph);
                }
            }
        }

        private void updateNodeAllDCF(String nodeID) {
            this.updateNodeInputDCF(nodeID);
            this.updateNodeOutputDCF(nodeID);
        }

        private void updateNodeOutputDCF(String nodeID) {
            int numOutputs = EngineNetworkManager.this.getNumOutputs(nodeID);
            for (int outputNum = 0; outputNum < numOutputs; ++outputNum) {
                this.updateNodeOutputDCF(nodeID, outputNum);
            }
        }

        private void updateNodeOutputDCF(String nodeID, int outputNum) {
            BufID bi = new BufID(nodeID, outputNum);
            if (EngineNetworkManager.this.getUseCache(nodeID)) {
                this.addPermDCF(bi, "use-cache set for node " + EngineNetworkManager.this.getNodeName(nodeID));
                return;
            }
            EngineNode node = EngineNetworkManager.this.getNode(nodeID);
            int execType = node.getExecutionType();
            if (execType == 1) {
                this.addDCF(bi, "output of data cache proc " + EngineNetworkManager.this.getNodeName(nodeID));
                return;
            }
            if (execType == 2) {
                this.addDCF(bi, "output of multi-phase node " + EngineNetworkManager.this.getNodeName(nodeID));
                return;
            }
            if (node.hasDynamicOutputs()) {
                this.addDCF(bi, "dynamic output of node " + EngineNetworkManager.this.getNodeName(nodeID));
                return;
            }
            if (this.nodeOutputsBlobs(nodeID, outputNum)) {
                this.addDCF(bi, "blobs output by node " + EngineNetworkManager.this.getNodeName(nodeID));
                return;
            }
        }

        private boolean nodeOutputsBlobs(String nodeID, int outputNum) {
            XTMetaData md = EngineNetworkManager.this.getOutputMetaData(nodeID, outputNum);
            int numCols = md.getNumColumns();
            for (int col = 0; col < numCols; ++col) {
                if (!md.isBlobColumn(col)) continue;
                return true;
            }
            return false;
        }

        private void updateNodeInputDCF(String nodeID) {
            int numInputs = EngineNetworkManager.this.getNumInputs(nodeID);
            for (int inputNum = 0; inputNum < numInputs; ++inputNum) {
                this.updateNodeInputDCF(nodeID, inputNum);
            }
        }

        private void updateNodeInputDCF(String nodeID, int inputNum) {
            XMLTreeNetwork.Link link = EngineNetworkManager.this.getUpstreamLink(nodeID, inputNum);
            if (link == null) {
                return;
            }
            BufID bi = new BufID(link);
            EngineNode node = EngineNetworkManager.this.getNode(nodeID);
            int execType = node.getExecutionType();
            if (execType == 1) {
                this.addDCF(bi, "input of data cache proc " + EngineNetworkManager.this.getNodeName(nodeID));
            } else if (execType == 2) {
                this.addDCF(bi, "input of multi-phase node " + EngineNetworkManager.this.getNodeName(nodeID));
            }
            EngineNode.InputRequirements reqs = node.getInputRequirements(inputNum);
            if (reqs.needsPermanentInputCacheFile()) {
                this.addPermDCF(bi, "needsPermanentInputCacheFile for node " + EngineNetworkManager.this.getNodeName(nodeID));
            } else if (reqs.needsMultiPass()) {
                this.addDCF(bi, "needsMultiPass for node " + EngineNetworkManager.this.getNodeName(nodeID));
            } else if (reqs.needsRandomAccess()) {
                this.addDCF(bi, "needsRandomAccess for node " + EngineNetworkManager.this.getNodeName(nodeID));
            } else if (reqs.needsFactorLevels() || reqs.needsTotalRows() || reqs.needsDataSummary()) {
                this.addDCF(bi, "needs meta-data summary for node " + EngineNetworkManager.this.getNodeName(nodeID));
            }
        }

        private void executeSubgraphPipeline(List subgraph) {
            String nodeID;
            int subgraphNodeNum;
            EngineNetworkManager.this.printlnInformation(MinerApp.getText("MinerFrame_info_execute") + " " + EngineNetworkManager.this.getNodeName(subgraph));
            EngineNetworkManager.this.setStatusExecuting(subgraph);
            this.m_subgraphExecNodes = subgraph;
            boolean ok = false;
            try {
                this.constructSubgraphPipeline();
                this.initSubgraphPercentDone();
                EngineNetworkManager.this.updateStorageInfo();
                this.executeSubgraphPipeline();
                EngineNetworkManager.this.updateStorageInfo();
                this.collectPipelineResults();
                EngineNetworkManager.this.updateStorageInfo();
                for (subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                    nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                    if (!EngineNetworkManager.this.isValid(nodeID)) continue;
                    EngineMessageHandler.sendMessageToApp("runNetworkNodeExecuted", new Object[]{nodeID});
                }
                ok = true;
            }
            catch (Exception ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(subgraph) + ": " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace(System.out);
            }
            catch (OutOfMemoryError ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(subgraph) + ": out of memory error");
                ex.printStackTrace(System.out);
            }
            if (!ok) {
                for (subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                    nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                    this.addBadNode(nodeID, "subgraph exec not ok");
                }
            }
            this.destroyPipeline();
            this.m_processedNodes.addAll(this.m_subgraphExecNodes);
        }

        private void executeDataCacheProc(String nodeID) {
            EngineNetworkManager.this.printlnInformation(MinerApp.getText("MinerFrame_info_execute") + " {" + EngineNetworkManager.this.getNodeName(nodeID) + "}");
            EngineNetworkManager.this.setStatusExecuting(nodeID);
            ++m_statPipelines;
            EngineNetworkManager.this.clearOutputMetaData(nodeID);
            EngineNetworkManager.this.printlnDebug("executing DataCacheProc for " + EngineNetworkManager.this.getNodeName(nodeID));
            boolean ok = false;
            try {
                ok = EngineNetworkManager.this.executeDataCacheProc(nodeID);
            }
            catch (Exception ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(nodeID) + ": " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace(System.out);
                ok = false;
            }
            catch (OutOfMemoryError ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(nodeID) + ": out of memory error");
                ex.printStackTrace(System.out);
                ok = false;
            }
            EngineNetworkManager.this.setNodeValid(nodeID, ok);
            this.m_processedNodes.add(nodeID);
            if (!ok) {
                this.addBadNode(nodeID, "error in data cache proc");
                ++m_statErrors;
            }
            if (ok) {
                EngineMessageHandler.sendMessageToApp("runNetworkNodeExecuted", new Object[]{nodeID});
            }
        }

        private void executeMultiPhaseNode(String nodeID) {
            EngineNetworkManager.this.printlnInformation(MinerApp.getText("MinerFrame_info_execute") + " {" + EngineNetworkManager.this.getNodeName(nodeID) + "}");
            EngineNetworkManager.this.setStatusExecuting(nodeID);
            EngineNetworkManager.this.clearOutputMetaData(nodeID);
            boolean ok = false;
            try {
                ok = EngineNetworkManager.this.executeMultiPhaseNode(nodeID);
            }
            catch (Exception ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(nodeID) + ": " + EngineNetworkManager.getExceptionMessage(ex));
                ex.printStackTrace(System.out);
                ok = false;
            }
            catch (OutOfMemoryError ex) {
                EngineNetworkManager.this.printlnError(EngineNetworkManager.this.getNodeName(nodeID) + ": out of memory error");
                ex.printStackTrace(System.out);
                ok = false;
            }
            EngineNetworkManager.this.setNodeValid(nodeID, ok);
            this.m_processedNodes.add(nodeID);
            if (!ok) {
                this.addBadNode(nodeID, "error in multi-phase node");
            }
            if (ok) {
                EngineMessageHandler.sendMessageToApp("runNetworkNodeExecuted", new Object[]{nodeID});
            }
        }

        private void addBadNode(String nodeID, String msg) {
            if (this.m_badNodes.contains(nodeID) || !this.m_execNodes.contains(nodeID)) {
                return;
            }
            this.m_badNodes.add(nodeID);
            this.m_processedNodes.add(nodeID);
            EngineNetworkManager.this.printlnDebug("adding bad node " + EngineNetworkManager.this.getNodeName(nodeID) + ": " + msg);
            NodeInfo info = EngineNetworkManager.this.getNodeInfo(nodeID);
            if (info == null) {
                return;
            }
            String downstreamMarker = " (downstream)";
            if (!msg.endsWith(downstreamMarker)) {
                msg = msg + downstreamMarker;
            }
            for (int outNum = 0; outNum < info.m_numOutputs; ++outNum) {
                List links = info.getDownstreamLinks(outNum);
                for (int i = 0; i < links.size(); ++i) {
                    XMLTreeNetwork.Link link = (XMLTreeNetwork.Link)links.get(i);
                    this.addBadNode(link.getToNodeID(), msg);
                }
            }
        }

        void constructSubgraphPipeline() throws Exception {
            CNKProc proc;
            String nodeID;
            int subgraphNodeNum;
            EngineStringConverter bufConverter = EngineNetworkManager.this.getEngineStringConverter(null, null);
            this.m_pip = new CNKPipeline();
            this.m_pip.createCheck();
            this.m_bufID2BufHash = new Hashtable();
            this.m_bufID2SummaryProcHash = new Hashtable();
            this.m_nodeID2ProcHash = new Hashtable();
            this.m_auxLink2BufHash = new Hashtable();
            int maxLevels = EngineNetworkManager.this.getMaxCategoricalLevels();
            for (subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                EngineNetworkManager.this.clearOutputMetaData(nodeID);
            }
            for (subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                NodeInfo info = EngineNetworkManager.this.getNodeInfo(nodeID);
                for (int in = 0; in < info.m_numInputs; ++in) {
                    BufID upBufID = EngineNetworkManager.this.getUpstreamBufID(nodeID, in);
                    if (this.m_subgraphExecNodes.contains(upBufID.getNodeID())) continue;
                    XTMetaData upMD = EngineNetworkManager.this.getInputMetaData(nodeID, in);
                    String inputFile = EngineNetworkManager.this.getOutputDataCacheFileName(upBufID);
                    CNKBackingFileBuf buf = new CNKBackingFileBuf();
                    EngineNetworkManager.setBufColumnDescription(buf, upMD, maxLevels);
                    buf.setFileName(inputFile);
                    buf.setBlobFileName(EngineNetworkManager.this.getOutputDataBlobFileName(upBufID));
                    buf.setBackingFileRows(upMD.getNumRows());
                    buf.setConverter(bufConverter);
                    this.m_pip.add(buf);
                    EngineNetworkManager.this.printlnDebug("prepare input DCF: " + inputFile + " (" + buf.getBackingFileRows() + " rows)");
                    XMLTreeNetwork.Link upLink = EngineNetworkManager.this.getUpstreamLink(nodeID, in);
                    this.m_auxLink2BufHash.put(upLink, buf);
                }
                for (int out = 0; out < info.m_numOutputs; ++out) {
                    BufID downBufID = new BufID(nodeID, out);
                    CNKBuf buf = null;
                    if (this.m_dcfBufs.contains(downBufID)) {
                        String outputFile = EngineNetworkManager.this.getOutputDataCacheFileName(downBufID);
                        CNKBackingFileBuf fbuf = new CNKBackingFileBuf();
                        fbuf.setFileName(outputFile);
                        fbuf.setBlobFileName(EngineNetworkManager.this.getOutputDataBlobFileName(downBufID));
                        fbuf.setBackingFileRows(0L);
                        buf = fbuf;
                        EngineNetworkManager.this.printlnDebug("prepare output DCF: " + outputFile);
                    } else {
                        buf = new CNKMemoryBuf();
                    }
                    XTMetaData downMD = EngineNetworkManager.this.getOutputMetaData(nodeID, out);
                    EngineNetworkManager.setBufColumnDescription(buf, downMD, maxLevels);
                    this.m_bufID2BufHash.put(downBufID, buf);
                    buf.setConverter(bufConverter);
                    this.m_pip.add(buf);
                    CNKProcCount summaryProc = new CNKProcCount();
                    summaryProc.setNumRows(0);
                    summaryProc.setInbuf(0, buf);
                    this.m_bufID2SummaryProcHash.put(downBufID, summaryProc);
                    this.m_pip.add(summaryProc);
                }
            }
            for (subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                EngineNode node = EngineNetworkManager.this.getNode(nodeID);
                NodeInfo info = EngineNetworkManager.this.getNodeInfo(nodeID);
                proc = null;
                try {
                    proc = node.procCreate();
                    if (proc == null) {
                        throw new Exception("null proc");
                    }
                    proc.createCheck();
                    if (!EngineNetworkManager.this.isSplusLicensed() && !MinerApp.isInBDL() && proc instanceof CNKProcSplusTransform) {
                        throw new Exception("S-PLUS Library not installed.  Cannot execute component.");
                    }
                }
                catch (Exception ex) {
                    String msg = EngineNetworkManager.getExceptionMessage(ex);
                    proc = EngineNetworkManager.this.createErrorProc(node.getClass().getName(), msg);
                }
                int bytesPerRow = 0;
                for (int in = 0; in < info.m_numInputs; ++in) {
                    bytesPerRow += DataCacheRowBuf.getDCFBytesPerRow(EngineNetworkManager.this.getInputMetaData(nodeID, in));
                }
                for (int out = 0; out < info.m_numOutputs; ++out) {
                    bytesPerRow += DataCacheRowBuf.getDCFBytesPerRow(EngineNetworkManager.this.getOutputMetaData(nodeID, out));
                }
                int rowsPerChunk = EngineNetworkManager.this.limitRowsPerChunk(nodeID, bytesPerRow);
                proc.setNumRows(rowsPerChunk);
                this.m_nodeID2ProcHash.put(nodeID, proc);
                this.m_pip.add(proc);
                ++m_statNodes;
                for (int in = 0; in < info.m_numInputs; ++in) {
                    CNKBuf buf = this.getCurrentPipelineNodeInputBuf(nodeID, in);
                    if (buf == null) {
                        throw new Exception("no buf found for node " + nodeID + ", in=" + in);
                    }
                    proc.setInbuf(in, buf);
                }
                for (int out = 0; out < info.m_numOutputs; ++out) {
                    BufID downBufID = new BufID(nodeID, out);
                    CNKBuf buf = (CNKBuf)this.m_bufID2BufHash.get(downBufID);
                    if (buf == null) {
                        throw new Exception("no buf found for node " + nodeID + ", out=" + out);
                    }
                    proc.setOutbuf(out, buf);
                }
            }
            Enumeration bufEnum = this.m_bufID2BufHash.elements();
            while (bufEnum.hasMoreElements()) {
                CNKBuf buf = (CNKBuf)bufEnum.nextElement();
                buf.setNumRows(buf.getMinRowsToAvoidDeadlock());
            }
            Enumeration auxBufEnum = this.m_auxLink2BufHash.elements();
            while (auxBufEnum.hasMoreElements()) {
                CNKBuf buf = (CNKBuf)auxBufEnum.nextElement();
                buf.setNumRows(buf.getMinRowsToAvoidDeadlock());
            }
            for (int subgraphNodeNum2 = 0; subgraphNodeNum2 < this.m_subgraphExecNodes.size(); ++subgraphNodeNum2) {
                String nodeID2 = (String)this.m_subgraphExecNodes.get(subgraphNodeNum2);
                proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID2);
                if (EngineNetworkManager.this.isErrorProc(proc)) continue;
                EngineNetworkManager.this.getNode(nodeID2).procSetProperties(proc);
            }
            this.m_pip.init();
        }

        CNKBuf getCurrentPipelineNodeInputBuf(String nodeID, int inputNum) {
            CNKBuf buf = null;
            XMLTreeNetwork.Link upLink = EngineNetworkManager.this.getUpstreamLink(nodeID, inputNum);
            buf = (CNKBuf)this.m_auxLink2BufHash.get(upLink);
            if (buf != null) {
                return buf;
            }
            BufID upBufID = EngineNetworkManager.this.getUpstreamBufID(nodeID, inputNum);
            buf = (CNKBuf)this.m_bufID2BufHash.get(upBufID);
            if (buf != null) {
                return buf;
            }
            return null;
        }

        void initSubgraphPercentDone() {
            this.m_progressNodes = new Vector();
            this.m_progressNodeTotalEstimatedRows = new Vector();
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                String nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                int numDCFInputs = 0;
                int numOtherInputs = 0;
                long totalDCFRows = 0L;
                long totalRows = -1L;
                for (int inputNum = 0; inputNum < EngineNetworkManager.this.getNumInputs(nodeID); ++inputNum) {
                    CNKBuf buf = this.getCurrentPipelineNodeInputBuf(nodeID, inputNum);
                    if (buf != null && buf instanceof CNKBackingFileBuf) {
                        CNKBackingFileBuf fileBuf = (CNKBackingFileBuf)buf;
                        totalDCFRows += fileBuf.getBackingFileRows();
                        ++numDCFInputs;
                        continue;
                    }
                    ++numOtherInputs;
                }
                if (numOtherInputs > 0) continue;
                if (numDCFInputs < 1) {
                    EngineNode node = EngineNetworkManager.this.getNode(nodeID);
                    CNKProc proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID);
                    totalRows = EngineNetworkManager.this.isErrorProc(proc) ? -1L : node.procGetEstimatedNumRows(proc);
                } else {
                    totalRows = totalDCFRows;
                }
                if (totalRows <= 0L) continue;
                this.m_progressNodes.add(nodeID);
                this.m_progressNodeTotalEstimatedRows.add(new Long(totalRows));
            }
        }

        int getSubgraphPercentDone(String baseText) {
            EngineNode node;
            int smallestPercentDone = -1;
            String smallestNodeDone = "";
            for (int i = 0; i < this.m_progressNodes.size(); ++i) {
                String nodeID = (String)this.m_progressNodes.get(i);
                long progressTotalRows = (Long)this.m_progressNodeTotalEstimatedRows.get(i);
                CNKProc proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID);
                long progressRowsDone = proc.getRowsDone();
                int percentDone = (int)(100.0 * (double)progressRowsDone / (double)progressTotalRows);
                if (smallestPercentDone < 0 || percentDone < smallestPercentDone) {
                    smallestPercentDone = percentDone;
                }
                smallestNodeDone = nodeID;
            }
            if (smallestPercentDone > 99) {
                smallestPercentDone = 99;
            }
            if ((node = EngineNetworkManager.this.getNode(smallestNodeDone)) != null) {
                node.updateProgressIndicator(smallestPercentDone, this.getSubgraphDataPassCount(), baseText, this);
            }
            return smallestPercentDone;
        }

        int getSubgraphDataPassCount() {
            int maxExeCount = 0;
            for (int i = 0; i < this.m_progressNodes.size(); ++i) {
                String nodeID = (String)this.m_progressNodes.get(i);
                CNKProc proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID);
                int exeCount = proc.getDataPassCount();
                if (maxExeCount >= exeCount) continue;
                maxExeCount = exeCount;
            }
            return maxExeCount;
        }

        void executeSubgraphPipeline() throws Exception {
            CNKProc proc;
            String nodeID;
            long lastStorageTime = System.currentTimeMillis();
            boolean ok = true;
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                String nodeID2 = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                EngineNetworkManager.this.initNodeMessages(nodeID2);
            }
            String baseText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                if (!EngineNetworkManager.this.hasUnprintedMessages(nodeID, proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID))) continue;
                EngineNetworkManager.this.printNodeMessages(nodeID, proc);
            }
            while (this.m_pip.anyProcReady() && !EngineNetworkManager.this.isInterruptRequested()) {
                try {
                    this.m_pip.execute(1L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ok = false;
                }
                for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                    nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                    if (!EngineNetworkManager.this.hasUnprintedMessages(nodeID, proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID))) continue;
                    EngineNetworkManager.this.printNodeMessages(nodeID, proc);
                }
                if (!ok) break;
                this.getSubgraphPercentDone(baseText);
                long newStorageTime = System.currentTimeMillis();
                if (newStorageTime - lastStorageTime <= 30000L) continue;
                EngineNetworkManager.this.updateStorageInfo();
                lastStorageTime = System.currentTimeMillis();
            }
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{baseText});
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                EngineNode node = EngineNetworkManager.this.getNode(nodeID);
                if (!node.hasUpdatedProgress()) continue;
                node.resetProgressIndicator();
            }
            EngineNetworkManager.this.printPipeline(this.m_pip);
            ++m_statPipelines;
            boolean weHavePipelineProblems = EngineNetworkManager.this.anyPipelineProblems(this.m_pip);
            if (weHavePipelineProblems) {
                ++m_statErrors;
            }
        }

        void collectPipelineResults() {
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                String nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                CNKProc proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID);
                try {
                    m_statProcBlocks += proc.getExecuteCount();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (proc.hasError()) {
                    EngineNetworkManager.this.setNodeValid(nodeID, false);
                    this.addBadNode(nodeID, "proc has error");
                    continue;
                }
                if (proc.done() && !EngineNetworkManager.this.isErrorProc(proc)) {
                    try {
                        EngineNetworkManager.this.getNode(nodeID).procExtractResults(proc);
                        EngineNetworkManager.this.setNodeValid(nodeID, true);
                    }
                    catch (Exception ex) {
                        EngineNetworkManager.this.setNodeValid(nodeID, false);
                        this.addBadNode(nodeID, "error extracting result from proc: " + EngineNetworkManager.getExceptionMessage(ex));
                        ex.printStackTrace();
                    }
                    continue;
                }
                EngineNetworkManager.this.setNodeValid(nodeID, false);
                this.addBadNode(nodeID, "proc not done");
            }
            Enumeration auxLinkEnum = this.m_auxLink2BufHash.elements();
            while (auxLinkEnum.hasMoreElements()) {
                CNKBuf buf = (CNKBuf)auxLinkEnum.nextElement();
                EngineNetworkManager.this.printBufferErrors(buf);
            }
            Enumeration bufEnum = this.m_bufID2BufHash.keys();
            while (bufEnum.hasMoreElements()) {
                BufID bi = (BufID)bufEnum.nextElement();
                String nodeID = bi.getNodeID();
                int outputNum = bi.getOutputNum();
                CNKBuf buf = (CNKBuf)this.m_bufID2BufHash.get(bi);
                EngineNetworkManager.this.printBufferErrors(buf);
                if (buf.anyOverflowCounts()) {
                    for (int colNum = 0; colNum < buf.getNumColumns(); ++colNum) {
                        long overflowCount = buf.getOverflowCount(colNum);
                        if (overflowCount <= 0L) continue;
                        String outputID = "";
                        if (EngineNetworkManager.this.getNumOutputs(nodeID) > 1) {
                            outputID = outputID + " " + (outputNum + 1) + ",";
                        }
                        String colType = buf.getColumnType(colNum);
                        String colName = buf.getColumnName(colNum);
                        if (colType.equals("factor") && !CNKObj.getErrorOnLevelOverflow()) {
                            int maxLevels = buf.getColumnMaxAutoLevels(colNum);
                            if (maxLevels < 0) {
                                maxLevels = buf.getDefaultMaxAutoLevels();
                            }
                            EngineNetworkManager.this.printlnWarning(EngineNetworkManager.this.getNodeName(nodeID) + ": output" + outputID + " column " + colName + " has " + overflowCount + " NA values due to categorical level overflow" + " (more than the maximum of " + maxLevels + " levels set by " + (EngineNetworkManager.this instanceof BDLManager ? "bd.options()$max.levels" : "the worksheet properties") + ")" + " -- you may want to change this column type from categorical to string");
                            continue;
                        }
                        if (colType.equals("string") && !CNKObj.getErrorOnStringTruncation()) {
                            int stringBytes = buf.getColumnStringBytes(colNum);
                            int overflowStringBytes = buf.getOverflowStringBytes(colNum);
                            EngineNetworkManager.this.printlnWarning(EngineNetworkManager.this.getNodeName(nodeID) + ": output" + outputID + " column " + colName + " has " + overflowCount + " string values truncated because they were longer than" + " the column string width of " + (stringBytes - 1) + " characters" + " -- maximum string size before truncation was " + (overflowStringBytes - 1) + " characters");
                            continue;
                        }
                        EngineNetworkManager.this.printlnDebug("shouldn't happen: overflow count for non factor, non-string");
                    }
                }
                boolean goodBuf = !buf.hasError() && buf.getEOF();
                CNKProcCount summaryProc = (CNKProcCount)this.m_bufID2SummaryProcHash.get(bi);
                if (summaryProc != null) {
                    boolean goodSummary;
                    boolean bl = goodSummary = !summaryProc.hasError() && summaryProc.done();
                    if (goodBuf && goodSummary) {
                        try {
                            EngineNetworkManager.this.updateMetaDataFromBuf(nodeID, outputNum, buf, summaryProc);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            goodBuf = false;
                            goodSummary = false;
                        }
                    }
                    EngineNetworkManager.this.setHasOutputSummary(bi, goodSummary);
                }
                if (!this.m_dcfBufs.contains(bi)) continue;
                if (buf instanceof CNKBackingFileBuf) {
                    ((CNKBackingFileBuf)buf).closeBackingFile();
                }
                if (this.m_outsideBufs.contains(bi) || EngineNetworkManager.this.hasOutputDCF(bi)) continue;
                String outDCF = EngineNetworkManager.this.getOutputDataCacheFileName(bi);
                if (goodBuf && EngineNetworkManager.this.hasOutputSummary(bi)) {
                    EngineNetworkManager.this.addDCFBytes(outDCF);
                    EngineNetworkManager.this.setHasOutputDCF(bi, true);
                    continue;
                }
                EngineNetworkManager.this.addRemoveDCFBytes(outDCF);
                EngineNetworkManager.this.setHasOutputDCF(bi, false);
                EngineNetworkManager.this.printlnDebug("deleting incomplete DCF for " + bi);
                EngineNetworkManager.this.deleteFile(outDCF);
                EngineNetworkManager.this.deleteFile(EngineNetworkManager.this.getOutputDataBlobFileName(bi));
            }
        }

        void destroyPipeline() {
            this.m_pip.destroyPipeline(false);
            Enumeration bufEnum = this.m_bufID2BufHash.elements();
            while (bufEnum.hasMoreElements()) {
                CNKBuf buf = (CNKBuf)bufEnum.nextElement();
                EngineNetworkManager.updateBufStats(buf);
                buf.destroyCNKObj();
            }
            Enumeration auxBufEnum = this.m_auxLink2BufHash.elements();
            while (auxBufEnum.hasMoreElements()) {
                CNKBuf buf = (CNKBuf)auxBufEnum.nextElement();
                EngineNetworkManager.updateBufStats(buf);
                buf.destroyCNKObj();
            }
            Enumeration summaryProcEnum = this.m_bufID2SummaryProcHash.elements();
            while (summaryProcEnum.hasMoreElements()) {
                CNKProc proc = (CNKProc)summaryProcEnum.nextElement();
                proc.destroyCNKObj();
            }
            for (int subgraphNodeNum = 0; subgraphNodeNum < this.m_subgraphExecNodes.size(); ++subgraphNodeNum) {
                String nodeID = (String)this.m_subgraphExecNodes.get(subgraphNodeNum);
                CNKProc proc = (CNKProc)this.m_nodeID2ProcHash.get(nodeID);
                if (EngineNetworkManager.this.isErrorProc(proc)) {
                    proc.destroyCNKObj();
                    continue;
                }
                proc.setCallback(null);
                EngineNetworkManager.this.getNode(nodeID).procDelete(proc);
            }
        }

        void deleteUnneededDCFFiles() {
            for (BufID bi : this.m_dcfBufs) {
                if (!EngineNetworkManager.this.hasOutputDCF(bi) || this.m_outsideBufs.contains(bi) || this.m_permBufs.contains(bi)) continue;
                boolean activeReader = false;
                NodeInfo info = EngineNetworkManager.this.getNodeInfo(bi.getNodeID());
                List outNodes = info.getDownstreamNodes(bi.getOutputNum());
                for (int i = 0; i < outNodes.size(); ++i) {
                    String outNodeID = (String)outNodes.get(i);
                    if (this.m_processedNodes.contains(outNodeID) || this.m_badNodes.contains(outNodeID) || !this.m_execNodes.contains(outNodeID)) continue;
                    activeReader = true;
                    break;
                }
                if (activeReader) continue;
                String outDCF = EngineNetworkManager.this.getOutputDataCacheFileName(bi);
                EngineNetworkManager.this.removeDCFBytes(outDCF);
                EngineNetworkManager.this.setHasOutputDCF(bi, false);
                EngineNetworkManager.this.printlnDebug("deleting temp DCF for " + bi);
                EngineNetworkManager.this.deleteFile(outDCF);
                EngineNetworkManager.this.deleteFile(EngineNetworkManager.this.getOutputDataBlobFileName(bi));
            }
        }
    }

    private static interface SubgraphPlan {
        public boolean anyNodesToExecute();

        public void execute() throws Exception;

        public int getNumberNodesToBeExecuted();

        public int getNumberNodesExecuted();

        public List getExecutedNodes();

        public List getUnexecutedNodes();
    }

    private class RunThread
    extends Thread {
        RunThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestRunNetwork(Object[] nodeIDs) {
            RunThread runThread = this;
            synchronized (runThread) {
                this.requestInterrupt();
                EngineNetworkManager.access$002(EngineNetworkManager.this, nodeIDs);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestInterrupt() {
            RunThread runThread = this;
            synchronized (runThread) {
                EngineNetworkManager.this.m_interruptRequested = true;
                EngineNetworkManager.access$002(EngineNetworkManager.this, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunThread runThread = this;
            synchronized (runThread) {
                this.setPriority(1);
            }
            while (true) {
                try {
                    runThread = this;
                    synchronized (runThread) {
                        if (EngineNetworkManager.this.m_runRequest == null) {
                            EngineNetworkManager.this.m_isRunning = false;
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                Object[] runRequest = null;
                RunThread runThread2 = this;
                synchronized (runThread2) {
                    runRequest = EngineNetworkManager.this.m_runRequest;
                    EngineNetworkManager.access$002(EngineNetworkManager.this, null);
                    if (runRequest != null) {
                        EngineNetworkManager.this.m_isRunning = true;
                        EngineNetworkManager.this.m_interruptRequested = false;
                    }
                }
                this.runRequestSafely(runRequest);
            }
        }

        void runRequestSafely(Object[] runRequest) {
            if (runRequest != null && runRequest.length > 1) {
                EngineNetworkManager.this.runNetworkWithNoExceptions((List)runRequest[0], (List)runRequest[1]);
            }
        }
    }

    private static class OutputInfo {
        Vector m_outputLinks = new Vector();
        XTMetaData m_metaData = null;
        boolean m_metaDataChanged = false;
        boolean m_hasDCF = false;
        boolean m_hasSummary = false;

        OutputInfo() {
        }
    }

    protected class NodeInfo {
        EngineNode m_node = null;
        boolean m_valid = false;
        int m_numInputs = 0;
        int m_numOutputs = 0;
        XMLTreeNetwork.Link[] m_inputLinks = null;
        OutputInfo[] m_outputInfo = null;
        XTProps m_nodeProperties = null;
        String m_executeAfter = null;
        String m_nodeModelParent = null;
        String m_nodeModel = null;
        Set m_nodeCacheNames = new HashSet();
        Set m_nodeTempFileTags = new HashSet();
        boolean m_isDummyNode = false;
        String m_engineNodeClassName = null;
        String m_nodeName = "no-node-name";
        int m_numMessages = 0;
        boolean m_errorsOverflowed = false;
        boolean m_warningsOverflowed = false;

        NodeInfo() {
        }

        XMLTreeNetwork.Link getUpstreamLink(int inputNum) {
            return this.m_inputLinks[inputNum];
        }

        void setUpstreamLink(XMLTreeNetwork.Link link, int inputNum) {
            this.m_inputLinks[inputNum] = link;
        }

        List getDownstreamLinks(int outputNum) {
            return new Vector(this.m_outputInfo[outputNum].m_outputLinks);
        }

        void addDownstreamLink(XMLTreeNetwork.Link link, int outputNum) {
            this.m_outputInfo[outputNum].m_outputLinks.add(link);
        }

        void removeDownstreamLink(XMLTreeNetwork.Link link, int outputNum) {
            this.m_outputInfo[outputNum].m_outputLinks.remove(link);
        }

        XTProps getNodeProperties() {
            return this.m_nodeProperties;
        }

        void setNodeProperties(XTProps arg) {
            this.m_nodeProperties = arg;
        }

        XMLTree getModel() {
            if (this.m_nodeModel != null) {
                return new XTNetwork.ModelInfo(this.m_nodeModel).getXMLTree();
            }
            if (this.m_nodeModelParent != null) {
                NodeInfo info = EngineNetworkManager.this.getNodeInfo(this.m_nodeModelParent);
                if (info == null) {
                    return null;
                }
                return info.getModel();
            }
            return this.m_node.getNodeCache("model");
        }

        void setModel(XMLTree arg) {
            this.m_nodeModel = arg == null ? null : arg.writeToString();
        }

        boolean hasNodeCacheName(String cachename) {
            return cachename != null && this.m_nodeCacheNames.contains(cachename);
        }

        void addNodeCacheName(String cachename) {
            if (cachename != null) {
                this.m_nodeCacheNames.add(cachename);
            }
        }

        void removeNodeCacheName(String cachename) {
            if (cachename != null) {
                this.m_nodeCacheNames.remove(cachename);
            }
        }

        Set getNodeCacheNames() {
            return new HashSet(this.m_nodeCacheNames);
        }

        void clearNodeCacheNames() {
            this.m_nodeCacheNames.clear();
        }

        void addNodeCacheNames(Collection names) {
            this.m_nodeCacheNames.addAll(names);
        }

        void addNodeTempFileTag(String tagName) {
            if (tagName != null) {
                this.m_nodeTempFileTags.add(tagName);
            }
        }

        void removeNodeTempFileTag(String tagName) {
            if (tagName != null) {
                this.m_nodeTempFileTags.remove(tagName);
            }
        }

        Set getNodeTempFileTags() {
            return new HashSet(this.m_nodeTempFileTags);
        }

        void clearNodeTempFileTags() {
            this.m_nodeTempFileTags.clear();
        }

        void addNodeTempFileTags(Collection tags) {
            this.m_nodeTempFileTags.addAll(tags);
        }

        XTMetaData getOutputMetaData(int outputNum) {
            return this.m_outputInfo[outputNum].m_metaData;
        }

        void setOutputMetaData(int outputNum, XTMetaData md) {
            this.m_outputInfo[outputNum].m_metaData = md;
            this.m_outputInfo[outputNum].m_metaDataChanged = true;
        }

        boolean getOutputMetaDataChanged(int outputNum) {
            return this.m_outputInfo[outputNum].m_metaDataChanged;
        }

        void clearOutputMetaDataChanged(int outputNum) {
            this.m_outputInfo[outputNum].m_metaDataChanged = false;
        }

        boolean hasOutputDCF(int outputNum) {
            if (outputNum < this.m_outputInfo.length) {
                return this.m_outputInfo[outputNum].m_hasDCF;
            }
            return false;
        }

        void setHasOutputDCF(int outputNum, boolean val) {
            this.m_outputInfo[outputNum].m_hasDCF = val;
        }

        boolean hasOutputSummary(int outputNum) {
            return this.m_outputInfo[outputNum].m_hasSummary;
        }

        void setHasOutputSummary(int outputNum, boolean val) {
            this.m_outputInfo[outputNum].m_hasSummary = val;
        }

        boolean hasOutputMD(int outputNum) {
            XTMetaData md = this.getOutputMetaData(outputNum);
            return md != null;
        }

        List getDownstreamNodes(int outputNum) {
            Vector outLinks = this.m_outputInfo[outputNum].m_outputLinks;
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < outLinks.size(); ++i) {
                XMLTreeNetwork.Link link = (XMLTreeNetwork.Link)outLinks.get(i);
                v.add(link.getToNodeID());
            }
            return v;
        }

        void setNodeName(String val) {
            this.m_nodeName = val;
        }

        String getNodeName() {
            return this.m_nodeName;
        }
    }
}

