/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NeuralNetViewer;
import com.insightful.miner.NeuralNetworkExecViewer;
import com.insightful.miner.tree.gui.ColorBroker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NeuralNetPanel
extends JPanel {
    private int numInputs = -1;
    private int totalNumInputs = -1;
    private int numHiddenUnits = -1;
    private int numHiddenLayers = -1;
    private int numOutputs = -1;
    private Dimension m_textDim = new JLabel("G").getPreferredSize();
    private Point[] inputArray = null;
    private Point[] hiddenArray1 = null;
    private Point[] hiddenArray2 = null;
    private Point[] hiddenArray3 = null;
    private Point[] outputArray = null;
    private Vector inputNames = null;
    private Vector outputNames = null;
    private double maxval = 0.0;
    private double[] weightArray = null;
    private int INPUT_UNITS_XCOORD = 0;
    private int HIDDEN1_UNITS_XCOORD = 0;
    private int HIDDEN2_UNITS_XCOORD = 0;
    private int HIDDEN3_UNITS_XCOORD = 0;
    private int OUTPUT_UNITS_XCOORD = 0;
    private int NETWORK_TOP_YCOORD = 0;
    private int NETWORK_BOTTOM_YCOORD = 0;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private int HIDDEN1_BIAS_UNIT_XCOORD = 0;
    private int HIDDEN1_BIAS_UNIT_YCOORD = 0;
    private int HIDDEN2_BIAS_UNIT_XCOORD = 0;
    private int HIDDEN2_BIAS_UNIT_YCOORD = 0;
    private int HIDDEN3_BIAS_UNIT_XCOORD = 0;
    private int HIDDEN3_BIAS_UNIT_YCOORD = 0;
    private int OUTPUT_BIAS_UNIT_XCOORD = 0;
    private int OUTPUT_BIAS_UNIT_YCOORD = 0;
    private int DEFAULT_NODE_SPACING = 20;
    private int NETWORK_SPACING_BUFFER = 80;
    private int LEGEND_Y_LOCATION = 20;
    private int NUM_LEGEND_BOXES = 11;
    private boolean panelChanged = true;
    private boolean sizeInitialized = false;
    private boolean isExpanded = false;
    private double[] currentWeights = null;
    private double[] collapsedWeights = null;
    private Vector numInputsPerVariable = null;
    boolean myPrintBegun = false;
    Dimension myPrintDocSize = null;
    Point myPrintDocTopLeft = null;
    Rectangle2D.Double myPrintPageRect = null;
    int myPrintNumPagesAcross = 1;
    int myPrintNumPagesDown = 1;
    double myPrintHorizScale = 1.0;
    double myPrintVertScale = 1.0;
    private ColorBroker colorBroker = null;
    private NeuralNetViewer parent = null;

    public NeuralNetPanel(NeuralNetViewer parent) {
        this.parent = parent;
        this.colorBroker = ColorBroker.getInstance();
    }

    public double[] getCurrentWeights() {
        return this.currentWeights;
    }

    public void releaseMemory() {
        this.inputArray = null;
        this.hiddenArray1 = null;
        this.hiddenArray2 = null;
        this.hiddenArray3 = null;
        this.outputArray = null;
        this.inputNames.removeAllElements();
        this.inputNames = null;
        this.outputNames.removeAllElements();
        this.outputNames = null;
        this.weightArray = null;
        this.currentWeights = null;
        this.collapsedWeights = null;
        this.numInputsPerVariable.removeAllElements();
        this.numInputsPerVariable = null;
    }

    public void setWeights(double[] array) {
        this.currentWeights = array;
        this.collapsedWeights = this.getCurrentWeightsByInputVar(this.currentWeights);
        this.setMaxVals();
    }

    public void updateDisplay(Hashtable h) {
        this.setWeights((double[])h.get(NeuralNetworkExecViewer.CURRENT_WEIGHTS_TAG));
        this.repaint();
    }

    private double[] getCurrentWeightsByInputVar(double[] weights) {
        int i;
        if (weights == null) {
            return null;
        }
        double[] newInputWeights = new double[(this.numInputsPerVariable.size() + 1) * this.numHiddenUnits];
        double maxVal = 0.0;
        int offset = 0;
        int levs = 0;
        for (int h = 0; h < this.numHiddenUnits; ++h) {
            for (int i2 = 0; i2 < this.numInputsPerVariable.size(); ++i2) {
                levs = (Integer)this.numInputsPerVariable.elementAt(i2);
                maxVal = 0.0;
                for (int a = 0; a < levs; ++a) {
                    if (!(Math.abs(maxVal) < Math.abs(weights[offset + a]))) continue;
                    maxVal = weights[offset + a];
                }
                offset += levs;
                newInputWeights[h * (this.numInputsPerVariable.size() + 1) + i2] = maxVal;
            }
            newInputWeights[(this.numInputsPerVariable.size() + 1) * h + this.numInputsPerVariable.size()] = weights[offset];
            ++offset;
        }
        int inps = (this.totalNumInputs + 1) * this.numHiddenUnits;
        double[] newWeights = new double[weights.length - inps + newInputWeights.length];
        for (i = 0; i < newInputWeights.length; ++i) {
            newWeights[i] = newInputWeights[i];
        }
        for (i = 0; i < weights.length - inps; ++i) {
            newWeights[newInputWeights.length + i] = weights[inps + i];
        }
        return newWeights;
    }

    public void setInputs(Vector names, Vector numLevelsPerVar, int totalNumInps, boolean isExpanded) {
        this.numInputs = names.size();
        this.inputNames = names;
        this.numInputsPerVariable = numLevelsPerVar;
        this.totalNumInputs = totalNumInps;
        this.isExpanded = isExpanded;
    }

    public void setHiddenLayer(int numLayers, int numNodes) {
        this.numHiddenLayers = numLayers;
        this.numHiddenUnits = numNodes;
    }

    public void setOutputs(Vector names) {
        this.numOutputs = names.size();
        this.outputNames = names;
    }

    public void setNetworkLocation() {
        int layercount = 2 + this.numHiddenLayers;
        this.panelWidth = this.parent.getNetworkScrollPane().getWidth() - 5;
        this.panelHeight = Math.max(this.numHiddenUnits, this.numInputs) * this.DEFAULT_NODE_SPACING + this.NETWORK_SPACING_BUFFER;
        if (this.panelHeight < this.parent.getNetworkScrollPane().getHeight()) {
            this.panelHeight = this.parent.getNetworkScrollPane().getHeight() - 10;
        }
        int xincrement = this.panelWidth / (layercount + 2);
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
        if (!this.sizeInitialized) {
            this.setSize(new Dimension(this.panelWidth, this.panelHeight));
            this.sizeInitialized = true;
        }
        this.NETWORK_TOP_YCOORD = (int)((double)this.panelHeight * 0.15);
        this.NETWORK_BOTTOM_YCOORD = this.panelHeight - (int)((double)this.panelHeight * 0.1);
        this.INPUT_UNITS_XCOORD = xincrement + xincrement / 2;
        this.HIDDEN1_UNITS_XCOORD = this.INPUT_UNITS_XCOORD + xincrement;
        if (this.numHiddenLayers == 1) {
            this.OUTPUT_UNITS_XCOORD = this.HIDDEN1_UNITS_XCOORD + xincrement;
        } else if (this.numHiddenLayers == 2) {
            this.HIDDEN2_UNITS_XCOORD = this.HIDDEN1_UNITS_XCOORD + xincrement;
            this.OUTPUT_UNITS_XCOORD = this.HIDDEN2_UNITS_XCOORD + xincrement;
        } else {
            this.HIDDEN2_UNITS_XCOORD = this.HIDDEN1_UNITS_XCOORD + xincrement;
            this.HIDDEN3_UNITS_XCOORD = this.HIDDEN2_UNITS_XCOORD + xincrement;
            this.OUTPUT_UNITS_XCOORD = this.HIDDEN3_UNITS_XCOORD + xincrement;
        }
        this.inputArray = new Point[this.numInputs];
        this.hiddenArray1 = new Point[this.numHiddenUnits];
        if (this.numHiddenLayers > 1) {
            this.hiddenArray2 = new Point[this.numHiddenUnits];
        }
        if (this.numHiddenLayers > 2) {
            this.hiddenArray3 = new Point[this.numHiddenUnits];
        }
        this.outputArray = new Point[this.numOutputs];
        this.computeNodePosition();
        int biasYOffset = this.DEFAULT_NODE_SPACING / 2;
        this.HIDDEN1_BIAS_UNIT_XCOORD = (this.HIDDEN1_UNITS_XCOORD + this.INPUT_UNITS_XCOORD) / 2;
        this.HIDDEN1_BIAS_UNIT_YCOORD = (this.inputArray[this.inputArray.length - 1].y + this.hiddenArray1[this.hiddenArray1.length - 1].y) / 2 + biasYOffset;
        if (this.numHiddenLayers == 2) {
            this.HIDDEN2_BIAS_UNIT_XCOORD = (this.HIDDEN2_UNITS_XCOORD + this.HIDDEN1_UNITS_XCOORD) / 2;
            this.HIDDEN2_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
            this.OUTPUT_BIAS_UNIT_XCOORD = (this.HIDDEN2_UNITS_XCOORD + this.OUTPUT_UNITS_XCOORD) / 2;
            this.OUTPUT_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
        } else if (this.numHiddenLayers > 2) {
            this.HIDDEN2_BIAS_UNIT_XCOORD = (this.HIDDEN2_UNITS_XCOORD + this.HIDDEN1_UNITS_XCOORD) / 2;
            this.HIDDEN2_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
            this.HIDDEN3_BIAS_UNIT_XCOORD = (this.HIDDEN3_UNITS_XCOORD + this.HIDDEN2_UNITS_XCOORD) / 2;
            this.HIDDEN3_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
            this.OUTPUT_BIAS_UNIT_XCOORD = (this.HIDDEN3_UNITS_XCOORD + this.OUTPUT_UNITS_XCOORD) / 2;
            this.OUTPUT_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
        } else {
            this.OUTPUT_BIAS_UNIT_XCOORD = (this.HIDDEN1_UNITS_XCOORD + this.OUTPUT_UNITS_XCOORD) / 2;
            this.OUTPUT_BIAS_UNIT_YCOORD = this.HIDDEN1_BIAS_UNIT_YCOORD;
        }
    }

    private void computeNodePosition() {
        int i;
        int networkHeight = this.NETWORK_BOTTOM_YCOORD - this.NETWORK_TOP_YCOORD;
        int ycoord = this.NETWORK_TOP_YCOORD;
        int inputSpacing = networkHeight / this.numInputs < this.DEFAULT_NODE_SPACING ? this.DEFAULT_NODE_SPACING : networkHeight / this.numInputs;
        int hiddenSpacing = networkHeight / this.numHiddenUnits < this.DEFAULT_NODE_SPACING ? this.DEFAULT_NODE_SPACING : networkHeight / this.numHiddenUnits;
        int outputSpacing = networkHeight / this.numOutputs < this.DEFAULT_NODE_SPACING ? this.DEFAULT_NODE_SPACING : networkHeight / this.numOutputs;
        int spacing = Math.min(Math.min(inputSpacing, hiddenSpacing), outputSpacing);
        int offset = 0;
        offset = (networkHeight - this.numInputs * spacing) / 2;
        for (i = 0; i < this.numInputs; ++i) {
            this.inputArray[i] = new Point(this.INPUT_UNITS_XCOORD, offset + ycoord);
            ycoord += spacing;
        }
        ycoord = this.NETWORK_TOP_YCOORD;
        offset = (networkHeight - this.numHiddenUnits * spacing) / 2;
        for (i = 0; i < this.numHiddenUnits; ++i) {
            this.hiddenArray1[i] = new Point(this.HIDDEN1_UNITS_XCOORD, offset + ycoord);
            ycoord += spacing;
        }
        if (this.numHiddenLayers > 1) {
            ycoord = this.NETWORK_TOP_YCOORD;
            for (i = 0; i < this.numHiddenUnits; ++i) {
                this.hiddenArray2[i] = new Point(this.HIDDEN2_UNITS_XCOORD, offset + ycoord);
                ycoord += spacing;
            }
            if (this.numHiddenLayers > 2) {
                ycoord = this.NETWORK_TOP_YCOORD;
                for (i = 0; i < this.numHiddenUnits; ++i) {
                    this.hiddenArray3[i] = new Point(this.HIDDEN3_UNITS_XCOORD, offset + ycoord);
                    ycoord += spacing;
                }
            }
        }
        ycoord = this.NETWORK_TOP_YCOORD;
        offset = (networkHeight - this.numOutputs * spacing) / 2;
        for (i = 0; i < this.numOutputs; ++i) {
            this.outputArray[i] = new Point(this.OUTPUT_UNITS_XCOORD, offset + ycoord);
            ycoord += spacing;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.setNetworkLocation();
        int nodeSize = 10;
        int sizeOffset = nodeSize / 2;
        this.paintColorLegend(nodeSize, g);
        this.paintText(g);
        this.paintLines(sizeOffset, g);
        this.paintNodes(sizeOffset, nodeSize, g);
    }

    private void paintColorLegend(int nodeSize, Graphics g) {
        int i;
        int legendLocation = (int)((double)this.panelWidth * 0.66) - 11 * nodeSize / 2;
        int boxPosition = 0;
        int textHeight = 9;
        g.setColor(ColorBroker.getColor("neuralNetworkTextColor"));
        String maxweight = MinerApp.formatDouble(this.maxval * -1.0);
        g.drawString(maxweight, legendLocation - maxweight.length() * 6, this.LEGEND_Y_LOCATION + textHeight);
        g.setColor(Color.black);
        for (i = 0; i < 5; ++i) {
            g.setColor(ColorBroker.getNeuralNetLegendColor(i, 5, true));
            g.fillRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
            g.setColor(Color.black);
            g.drawRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
            boxPosition += nodeSize;
        }
        g.setColor(ColorBroker.getNeuralNetLegendMiddleColor());
        g.fillRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
        g.setColor(Color.black);
        g.drawRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
        boxPosition += nodeSize;
        for (i = 0; i < 5; ++i) {
            g.setColor(ColorBroker.getNeuralNetLegendColor(i, 5, false));
            g.fillRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
            g.setColor(Color.black);
            g.drawRect(legendLocation + boxPosition, this.LEGEND_Y_LOCATION, nodeSize, nodeSize);
            boxPosition += nodeSize;
        }
        g.setColor(ColorBroker.getColor("neuralNetworkTextColor"));
        maxweight = MinerApp.formatDouble(this.maxval);
        g.drawString(maxweight, legendLocation + boxPosition + 4, this.LEGEND_Y_LOCATION + textHeight);
    }

    private void paintText(Graphics g) {
        int i;
        boolean longNameExists = true;
        g.setColor(ColorBroker.getColor("neuralNetworkTextColor"));
        String s = "";
        int maxNameLength = 0;
        for (int i2 = 0; i2 < this.numInputs; ++i2) {
            s = (String)this.inputNames.elementAt(i2);
            if (maxNameLength >= s.length()) continue;
            maxNameLength = s.length();
        }
        int maxLabelWidth = maxNameLength * this.m_textDim.width;
        int textXPosition = 5;
        if (maxLabelWidth < this.inputArray[0].x) {
            textXPosition = this.inputArray[0].x - maxLabelWidth;
            longNameExists = false;
        }
        int textHeight = this.m_textDim.height;
        String heading = "";
        heading = this.isExpanded ? NeuralNetViewer.getText("nnvis_inputHeadingExpanded") : NeuralNetViewer.getText("nnvis_inputHeading");
        g.drawString(heading, textXPosition, this.LEGEND_Y_LOCATION + textHeight);
        g.drawLine(textXPosition, this.LEGEND_Y_LOCATION + textHeight + 2, this.inputArray[0].x, this.LEGEND_Y_LOCATION + textHeight + 2);
        for (i = 0; i < this.numInputs; ++i) {
            s = (String)this.inputNames.elementAt(i);
            g.drawString(s, textXPosition, this.inputArray[i].y + textHeight);
            g.setColor(Color.white);
            if (longNameExists) {
                g.fillRect(this.inputArray[i].x - 10, this.inputArray[i].y - 2, this.panelWidth - (this.inputArray[i].x - 10), textHeight + this.DEFAULT_NODE_SPACING / 2);
            }
            g.setColor(ColorBroker.getColor("neuralNetworkTextColor"));
        }
        for (i = 0; i < this.numOutputs; ++i) {
            s = (String)this.outputNames.elementAt(i);
            g.drawString(s, this.outputArray[i].x + 20, this.outputArray[i].y + textHeight);
        }
    }

    private void paintLines(int sizeOffset, Graphics g) {
        block19: {
            int j;
            int i;
            int weightIndex;
            int numOutputsWithLines;
            block20: {
                block18: {
                    if (this.numInputs < 0 || this.numOutputs < 0 || this.numHiddenLayers < 0 || this.numHiddenUnits < 0) {
                        return;
                    }
                    numOutputsWithLines = 0;
                    numOutputsWithLines = this.numOutputs != 1 ? this.numOutputs - 1 : this.numOutputs;
                    weightIndex = 0;
                    if (this.inputArray != null && this.hiddenArray1 != null) {
                        for (i = 0; i < this.numHiddenUnits; ++i) {
                            for (j = 0; j < this.numInputs; ++j) {
                                g.setColor(this.getLineColor(weightIndex));
                                g.drawLine(this.inputArray[j].x + sizeOffset, this.inputArray[j].y + sizeOffset, this.hiddenArray1[i].x + sizeOffset, this.hiddenArray1[i].y + sizeOffset);
                                ++weightIndex;
                            }
                            g.setColor(this.getLineColor(weightIndex));
                            g.drawLine(this.HIDDEN1_BIAS_UNIT_XCOORD + sizeOffset, this.HIDDEN1_BIAS_UNIT_YCOORD + sizeOffset, this.hiddenArray1[i].x + sizeOffset, this.hiddenArray1[i].y + sizeOffset);
                            ++weightIndex;
                        }
                    }
                    if (this.numHiddenLayers != 1) break block18;
                    if (this.hiddenArray1 == null || this.outputArray == null) break block19;
                    for (i = 0; i < numOutputsWithLines; ++i) {
                        for (j = 0; j < this.numHiddenUnits; ++j) {
                            g.setColor(this.getLineColor(weightIndex));
                            g.drawLine(this.hiddenArray1[j].x + sizeOffset, this.hiddenArray1[j].y + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                            ++weightIndex;
                        }
                        g.setColor(this.getLineColor(weightIndex));
                        g.drawLine(this.OUTPUT_BIAS_UNIT_XCOORD + sizeOffset, this.OUTPUT_BIAS_UNIT_YCOORD + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                        ++weightIndex;
                    }
                    break block19;
                }
                if (this.hiddenArray1 != null && this.hiddenArray2 != null) {
                    for (i = 0; i < this.numHiddenUnits; ++i) {
                        for (j = 0; j < this.numHiddenUnits; ++j) {
                            g.setColor(this.getLineColor(weightIndex));
                            g.drawLine(this.hiddenArray1[j].x + sizeOffset, this.hiddenArray1[j].y + sizeOffset, this.hiddenArray2[i].x + sizeOffset, this.hiddenArray2[i].y + sizeOffset);
                            ++weightIndex;
                        }
                        g.setColor(this.getLineColor(weightIndex));
                        g.drawLine(this.HIDDEN2_BIAS_UNIT_XCOORD + sizeOffset, this.HIDDEN2_BIAS_UNIT_YCOORD + sizeOffset, this.hiddenArray2[i].x + sizeOffset, this.hiddenArray2[i].y + sizeOffset);
                        ++weightIndex;
                    }
                }
                if (this.numHiddenLayers != 2) break block20;
                if (this.hiddenArray2 == null || this.outputArray == null) break block19;
                for (i = 0; i < numOutputsWithLines; ++i) {
                    for (j = 0; j < this.numHiddenUnits; ++j) {
                        g.setColor(this.getLineColor(weightIndex));
                        g.drawLine(this.hiddenArray2[j].x + sizeOffset, this.hiddenArray2[j].y + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                        ++weightIndex;
                    }
                    g.setColor(this.getLineColor(weightIndex));
                    g.drawLine(this.OUTPUT_BIAS_UNIT_XCOORD + sizeOffset, this.OUTPUT_BIAS_UNIT_YCOORD + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                    ++weightIndex;
                }
                break block19;
            }
            if (this.numHiddenLayers == 3) {
                if (this.hiddenArray2 != null && this.hiddenArray3 != null) {
                    for (i = 0; i < this.numHiddenUnits; ++i) {
                        for (j = 0; j < this.numHiddenUnits; ++j) {
                            g.setColor(this.getLineColor(weightIndex));
                            g.drawLine(this.hiddenArray2[j].x + sizeOffset, this.hiddenArray2[j].y + sizeOffset, this.hiddenArray3[i].x + sizeOffset, this.hiddenArray3[i].y + sizeOffset);
                            ++weightIndex;
                        }
                        g.setColor(this.getLineColor(weightIndex));
                        g.drawLine(this.HIDDEN3_BIAS_UNIT_XCOORD + sizeOffset, this.HIDDEN3_BIAS_UNIT_YCOORD + sizeOffset, this.hiddenArray3[i].x + sizeOffset, this.hiddenArray3[i].y + sizeOffset);
                        ++weightIndex;
                    }
                }
                if (this.hiddenArray3 != null && this.outputArray != null) {
                    for (i = 0; i < numOutputsWithLines; ++i) {
                        for (j = 0; j < this.numHiddenUnits; ++j) {
                            g.setColor(this.getLineColor(weightIndex));
                            g.drawLine(this.hiddenArray3[j].x + sizeOffset, this.hiddenArray3[j].y + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                            ++weightIndex;
                        }
                        g.setColor(this.getLineColor(weightIndex));
                        g.drawLine(this.OUTPUT_BIAS_UNIT_XCOORD + sizeOffset, this.OUTPUT_BIAS_UNIT_YCOORD + sizeOffset, this.outputArray[i].x + sizeOffset, this.outputArray[i].y + sizeOffset);
                        ++weightIndex;
                    }
                }
            }
        }
    }

    private void paintNodes(int sizeOffset, int nodeSize, Graphics g) {
        int i;
        g.setColor(ColorBroker.getColor("neuralNetworkRepresentationColor"));
        for (i = 0; i < this.numInputs; ++i) {
            if (this.inputArray == null) continue;
            g.fillRect(this.inputArray[i].x, this.inputArray[i].y, nodeSize, nodeSize);
        }
        for (i = 0; i < this.numHiddenUnits; ++i) {
            if (this.hiddenArray1 == null) continue;
            g.fillArc(this.hiddenArray1[i].x, this.hiddenArray1[i].y, nodeSize, nodeSize, 0, 360);
        }
        if (this.numHiddenLayers > 1) {
            for (i = 0; i < this.numHiddenUnits; ++i) {
                if (this.hiddenArray2 == null) continue;
                g.fillArc(this.hiddenArray2[i].x, this.hiddenArray2[i].y, nodeSize, nodeSize, 0, 360);
            }
            if (this.numHiddenLayers == 3) {
                for (i = 0; i < this.numHiddenUnits; ++i) {
                    if (this.hiddenArray3 == null) continue;
                    g.fillArc(this.hiddenArray3[i].x, this.hiddenArray3[i].y, nodeSize, nodeSize, 0, 360);
                }
            }
        }
        for (i = 0; i < this.numOutputs; ++i) {
            if (this.outputArray == null) continue;
            if (this.numOutputs > 1 && i == this.numOutputs - 1) {
                g.drawArc(this.outputArray[i].x, this.outputArray[i].y, nodeSize, nodeSize, 0, 360);
                continue;
            }
            g.fillArc(this.outputArray[i].x, this.outputArray[i].y, nodeSize, nodeSize, 0, 360);
        }
        g.setColor(ColorBroker.getColor("neuralNetworkRepresentationBiasNodeColor"));
        g.fillArc(this.HIDDEN1_BIAS_UNIT_XCOORD, this.HIDDEN1_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        if (this.numHiddenLayers > 1) {
            g.fillArc(this.HIDDEN2_BIAS_UNIT_XCOORD, this.HIDDEN2_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        }
        if (this.numHiddenLayers == 3) {
            g.fillArc(this.HIDDEN3_BIAS_UNIT_XCOORD, this.HIDDEN3_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        }
        g.fillArc(this.OUTPUT_BIAS_UNIT_XCOORD, this.OUTPUT_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        g.setColor(Color.black);
        g.drawArc(this.HIDDEN1_BIAS_UNIT_XCOORD, this.HIDDEN1_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        if (this.numHiddenLayers > 1) {
            g.drawArc(this.HIDDEN2_BIAS_UNIT_XCOORD, this.HIDDEN2_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        }
        if (this.numHiddenLayers == 3) {
            g.drawArc(this.HIDDEN3_BIAS_UNIT_XCOORD, this.HIDDEN3_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
        }
        g.drawArc(this.OUTPUT_BIAS_UNIT_XCOORD, this.OUTPUT_BIAS_UNIT_YCOORD, nodeSize, nodeSize, 0, 360);
    }

    private Color getLineColor(int weightIndex) {
        double[] weights = this.isExpanded ? this.currentWeights : this.collapsedWeights;
        if (weights == null) {
            return Color.gray;
        }
        if (weightIndex >= weights.length || weightIndex < 0) {
            System.out.println("over limit: " + weightIndex + ", " + weights.length);
            return Color.gray;
        }
        double weight = weights[weightIndex];
        return ColorBroker.getNeuralNetLineColor(weight, this.maxval);
    }

    public void setMaxVals() {
        if (this.currentWeights == null) {
            return;
        }
        this.maxval = 0.0;
        for (int i = 0; i < this.currentWeights.length; ++i) {
            if (!(Math.abs(this.currentWeights[i]) > this.maxval)) continue;
            this.maxval = Math.abs(this.currentWeights[i]);
        }
        if (this.collapsedWeights == null) {
            this.collapsedWeights = this.getCurrentWeightsByInputVar(this.currentWeights);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics2D g2, PageFormat pf, int pnum, Rectangle2D.Double rect) {
        Point myOrigin = new Point();
        if (!this.myPrintBegun) {
            this.myPrintBegun = true;
            this.myPrintDocTopLeft = new Point((int)this.getAlignmentX(), (int)this.getAlignmentY());
            this.myPrintDocSize = this.getSize();
            int docWidth = this.myPrintDocSize.width;
            int docHeight = this.myPrintDocSize.height;
            this.myPrintPageRect = rect;
            double pageWidth = this.myPrintPageRect.width;
            double pageHeight = this.myPrintPageRect.height;
            this.myPrintVertScale = this.myPrintHorizScale = this.myPrintPageRect.width / (double)this.myPrintDocSize.width;
            this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
            this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        }
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        if (pnum >= this.myPrintNumPagesAcross * this.myPrintNumPagesDown) {
            this.myPrintBegun = false;
            return 1;
        }
        int hpnum = pnum % this.myPrintNumPagesAcross;
        int vpnum = pnum / this.myPrintNumPagesAcross;
        try {
            myOrigin = new Point((int)(((double)this.myPrintDocTopLeft.x + (double)hpnum * pageWidth) / this.myPrintHorizScale), (int)(((double)this.myPrintDocTopLeft.y + (double)vpnum * pageHeight) / this.myPrintVertScale));
            g2.clip(this.myPrintPageRect);
            Rectangle clipRect = new Rectangle();
            g2.getClipBounds(clipRect);
            clipRect.x -= (int)pageX;
            clipRect.y -= (int)pageY;
            clipRect.x = (int)((double)clipRect.x / this.myPrintHorizScale) + myOrigin.x;
            clipRect.y = (int)((double)clipRect.y / this.myPrintVertScale) + myOrigin.y;
            clipRect.width = (int)Math.ceil((double)clipRect.width / this.myPrintHorizScale);
            clipRect.height = (int)Math.ceil((double)clipRect.height / this.myPrintVertScale);
            g2.translate(pageX, pageY);
            g2.scale(this.myPrintHorizScale, this.myPrintVertScale);
            g2.translate(-myOrigin.x, -myOrigin.y);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.paint(g2);
            Object var18_15 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            throw throwable;
        }
        return 0;
    }
}

