/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictorPort;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoLabeledLink;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PredictorLink
extends JGoLabeledLink {
    private static Color DYNAMIC_COLOR = Color.BLUE;
    private static Color STATIC_COLOR = Color.RED;
    private Color CURRENT_COLOR = STATIC_COLOR;

    public PredictorLink() {
        this.setPen(JGoPen.make((int)1, (int)2, (Color)this.CURRENT_COLOR));
    }

    public PredictorLink(JGoPort from, JGoPort to) {
        super(from, to);
        this.setPen(JGoPen.make((int)1, (int)2, (Color)this.CURRENT_COLOR));
    }

    public WorksheetDocument getDoc() {
        return (WorksheetDocument)this.getDocument();
    }

    public BaseNodeArea getFromNode() {
        try {
            return (BaseNodeArea)super.getFromPort().getParent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BaseNodeArea getToNode() {
        try {
            return (BaseNodeArea)super.getToPort().getParent();
        }
        catch (Exception e) {
            return null;
        }
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        PredictorPort toPort;
        PredictorLink obj = (PredictorLink)super.copyObject(env);
        ActivityNodeArea outputArea = (ActivityNodeArea)env.get((Object)this.getToNode());
        ActivityNodeArea inputArea = (ActivityNodeArea)env.get((Object)this.getFromNode());
        PredictorPort fromPort = inputArea != null ? inputArea.getModelLinkOutputPort() : null;
        PredictorPort predictorPort = toPort = outputArea != null ? outputArea.getModelLinkInputPort() : null;
        if (fromPort != null && toPort != null) {
            obj.setToPort(toPort);
            obj.setFromPort(fromPort);
            env.removeDelayed((Object)this);
        }
        return obj;
    }

    public static PredictorLink newPredictionLink(int fromID, int toID, WorksheetDocument doc) {
        BaseNodeArea toBNA = doc.findFlatNodeByID(toID);
        BaseNodeArea fromBNA = doc.findFlatNodeByID(fromID);
        if (fromBNA != null && toBNA != null) {
            PredictorPort from = ((ActivityNodeArea)fromBNA).getModelLinkOutputPort();
            PredictorPort to = ((ActivityNodeArea)toBNA).getModelLinkInputPort();
            PredictorLink pl = new PredictorLink(from, to);
            doc.addObjectAtHead((JGoObject)pl);
            return pl;
        }
        return null;
    }

    public XTNetwork.ModelLinkInfo createLinkInfo(XTNetwork net) {
        XTNetwork.ModelLinkInfo info = new XTNetwork.ModelLinkInfo();
        info.setFromInfo(Integer.toString(this.getFromNode().getID()), 0);
        info.setToInfo(Integer.toString(this.getToNode().getID()), 0);
        info.isOrthog = this.isOrthogonal();
        return info;
    }

    public Element createXMLElement(Document document) {
        Element flow = document.createElement(XTNetwork.MODEL_LINK_NODE_TAG);
        flow.setAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG, Integer.toString(this.getFromNode().getID()));
        flow.setAttribute(XTNetwork.FROM_PORT_ATTRIBUTE_TAG, "0");
        flow.setAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG, Integer.toString(this.getToNode().getID()));
        flow.setAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG, "0");
        return flow;
    }

    public static PredictorLink buildLinkFromXML(Element link, WorksheetDocument doc) {
        boolean portsExist;
        PredictorLink blink = null;
        int fromNode = Integer.parseInt(link.getAttribute(XTNetwork.FROM_NODE_ATTRIBUTE_TAG));
        int toNode = Integer.parseInt(link.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG));
        ActivityNodeArea from = (ActivityNodeArea)doc.findFlatNodeByID(fromNode);
        ActivityNodeArea to = (ActivityNodeArea)doc.findFlatNodeByID(toNode);
        boolean isOrthog = link.getAttribute(XTNetwork.ORTHOGONAL_LINK_ATTRIBUTE_TAG).compareToIgnoreCase("true") == 0;
        boolean nodesExist = false;
        if (from != null && to != null) {
            nodesExist = true;
        }
        boolean bl = portsExist = from.getModelLinkOutputPort() != null && to.getModelLinkInputPort() != null;
        if (nodesExist && portsExist) {
            blink = PredictorLink.newPredictionLink(fromNode, toNode, doc);
            blink.setOrthogonal(isOrthog);
        }
        return blink;
    }

    public static PredictorLink buildLinkFromInfo(XTNetwork.ModelLinkInfo info, WorksheetDocument doc) {
        boolean portsExist;
        PredictorLink plink = null;
        int fromNode = Integer.parseInt(info.getFromNodeID());
        int toNode = Integer.parseInt(info.getToNodeID());
        ActivityNodeArea from = (ActivityNodeArea)doc.findFlatNodeByID(fromNode);
        ActivityNodeArea to = (ActivityNodeArea)doc.findFlatNodeByID(toNode);
        boolean nodesExist = false;
        if (from != null && to != null) {
            nodesExist = true;
        }
        boolean bl = portsExist = nodesExist && from.getModelLinkOutputPort() != null && to.getModelLinkInputPort() != null;
        if (nodesExist && portsExist) {
            plink = PredictorLink.newPredictionLink(fromNode, toNode, doc);
            plink.setOrthogonal(info.isOrthog);
        }
        return plink;
    }

    public void ownerChange(Object oldOwner, Object newOwner) {
        this.ownerChange(oldOwner, newOwner, false);
    }

    public void ownerChange(Object oldOwner, Object newOwner, boolean forceStateChange) {
        boolean delete;
        boolean create = oldOwner == null && newOwner != null;
        boolean bl = delete = oldOwner != null && newOwner == null;
        if (create || delete) {
            BaseNodeArea outputArea = this.getToNode();
            BaseNodeArea inputArea = this.getFromNode();
            if (outputArea != null && inputArea != null) {
                WorksheetDocument doc = (WorksheetDocument)((Object)(delete ? oldOwner : newOwner));
                if (outputArea instanceof ActivityNodeArea && inputArea instanceof ActivityNodeArea) {
                    PMMLImportable outputModel = (PMMLImportable)((Object)((ActivityNodeArea)outputArea).getNodeModel());
                    PMMLExportable inputModel = (PMMLExportable)((Object)((ActivityNodeArea)inputArea).getNodeModel());
                    ActivityNodeModel aOutputModel = (ActivityNodeModel)((Object)outputModel);
                    ActivityNodeModel aInputModel = (ActivityNodeModel)((Object)inputModel);
                    if (create) {
                        aInputModel.addModelChangeListener(outputModel);
                        aOutputModel.addModelParentModel(inputModel);
                    } else {
                        aInputModel.removeModelChangeListener(outputModel);
                        aOutputModel.removeModelParentModel(inputModel);
                    }
                    if (doc.isCollapsing()) {
                        return;
                    }
                    XTNetwork.NodeInfo oldNI = aOutputModel.getNodeInfo().copy();
                    if (create) {
                        outputModel.setPredictNodeProperties(inputModel, false);
                    }
                    outputModel.setPredictNodeModel(inputModel, delete);
                    if (!oldNI.equals(aOutputModel.getNodeInfo())) {
                        XMLTree oldFitM = oldNI.model == null ? null : oldNI.model.getXMLTree();
                        XMLTree newFitM = inputModel.getFittedModel();
                        boolean inputComputed = aInputModel.getState() instanceof ActivityNodeComputed;
                        if (!inputComputed || create && !XTMetaData.nullCognizantCompare(oldFitM, newFitM)) {
                            aOutputModel.getState().changeState(aOutputModel);
                        } else {
                            aOutputModel.firePortsChangedEvent();
                        }
                        doc.setEngineNetworkDirty();
                    }
                }
            }
        }
        super.ownerChange(oldOwner, newOwner);
    }

    public int getSegmentNearPoint(Point pnt) {
        return BaseLink.getSegmentNearPoint((JGoLink)this, pnt);
    }

    protected void calculateStroke() {
        super.calculateStroke();
        JGoPort fromPort = this.getFromPort();
        JGoPort toPort = this.getToPort();
        if (fromPort == null) {
            return;
        }
        if (toPort == null) {
            return;
        }
        boolean orth = this.isOrthogonal();
        if (fromPort != toPort && fromPort.getFromSpot() == -1 && toPort.getToSpot() == -1) {
            this.foredate(110);
            this.setSuspendUpdates(true);
            this.removeAllPoints();
            Point p = new Point();
            p = fromPort.getLinkPointFromPoint(toPort.getLeft() + toPort.getWidth() / 2, toPort.getTop() + toPort.getHeight() / 2, p);
            this.addPoint(p);
            p = toPort.getLinkPointFromPoint(fromPort.getLeft() + fromPort.getWidth() / 2, fromPort.getTop() + fromPort.getHeight() / 2, p);
            this.addPoint(p);
            this.setSuspendUpdates(false);
            this.update(110, 0, null);
        } else {
            Point fromPoint = new Point();
            int bx = 0;
            int by = 0;
            double fromDir = -1.0;
            if (fromPort.getFromSpot() != -1) {
                fromPoint = fromPort.getFromLinkPoint(fromPoint);
                int fromSeg = fromPort.getEndSegmentLength();
                fromDir = fromPort.getFromLinkDir();
                if (fromPort == toPort) {
                    fromDir += 1.0;
                }
                if (orth) {
                    bx = (int)((double)fromSeg * Math.cos(fromDir));
                    by = (int)((double)fromSeg * Math.sin(fromDir));
                    if (fromPort == toPort) {
                        bx *= 4;
                        by *= 4;
                    }
                }
            }
            Point toPoint = new Point();
            int cx = 0;
            int cy = 0;
            double toDir = -1.0;
            if (toPort.getToSpot() != -1) {
                toPoint = toPort.getToLinkPoint(toPoint);
                int toSeg = toPort.getEndSegmentLength();
                toDir = toPort.getToLinkDir();
                if (fromPort == toPort) {
                    toDir -= 1.0;
                }
                if (orth) {
                    cx = (int)((double)toSeg * Math.cos(toDir));
                    cy = (int)((double)toSeg * Math.sin(toDir));
                    if (fromPort == toPort) {
                        cx *= 4;
                        cy *= 4;
                    }
                }
            }
            if (fromPort.getFromSpot() == -1) {
                fromPoint = fromPort.getLinkPointFromPoint(toPoint.x + cx, toPoint.y + cy, fromPoint);
            }
            if (toPort.getToSpot() == -1) {
                toPoint = toPort.getLinkPointFromPoint(fromPoint.x + bx, fromPoint.y + by, toPoint);
            }
            this.foredate(110);
            this.setSuspendUpdates(true);
            this.removeAllPoints();
            this.addPoint(fromPoint);
            if (orth) {
                this.addPoint(fromPoint.x + bx, fromPoint.y + by);
                this.addOrthoPoints(fromPoint.x + bx, fromPoint.y + by, fromDir, toPoint.x + cx, toPoint.y + cy, toDir);
                this.addPoint(toPoint.x + cx, toPoint.y + cy);
            }
            this.addPoint(toPoint);
            this.setSuspendUpdates(false);
            this.update(110, 0, null);
        }
    }
}

