/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.SurvivalViewer;
import com.insightful.miner.XMLTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class SurvivalStatsPanel
extends JPanel
implements Printable {
    private SurvivalViewer m_viewer = null;
    private JTextPane m_coefPane = null;
    private JViewport m_statsView = null;
    private int m_nPages = -1;
    protected StyleSheet m_imDefaultStyles = null;

    public SurvivalStatsPanel() {
        super(new BorderLayout());
    }

    public SurvivalStatsPanel(SurvivalViewer viewer) {
        super(new BorderLayout());
        this.m_viewer = viewer;
    }

    public void setViewer(SurvivalViewer viewer) {
        this.m_viewer = viewer;
    }

    public void createDocument() {
        XMLTree model = this.m_viewer.getModel();
        String htmlString = model.getHtmlStringNoCSS(XMLTree.SURVIVAL_XSL_FILE, this.m_viewer.getTitle());
        try {
            this.m_coefPane = new JTextPane();
            this.m_coefPane.setBackground(Color.white);
            this.m_coefPane.setVisible(true);
            HTMLEditorKit kit = new HTMLEditorKit();
            if (this.m_imDefaultStyles == null) {
                try {
                    File file = new File(XMLTree.CSS_FILE);
                    FileReader in = new FileReader(file);
                    StyleSheet ss = new StyleSheet();
                    ss.loadRules(in, new URL("file:" + XMLTree.CSS_FILE));
                    ss.addStyleSheet(kit.getStyleSheet());
                    in.close();
                    kit.setStyleSheet(ss);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            this.m_coefPane.setEditorKit(kit);
            this.m_coefPane.setText(htmlString);
            this.m_statsView = new JViewport();
            this.m_statsView.add(this.m_coefPane);
            this.add(this.m_statsView);
            this.setPreferredSize(this.m_coefPane.getPreferredSize());
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi != 0) {
            return 1;
        }
        if (!(g instanceof Graphics2D)) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        g2.translate(x, y);
        TextUI ui = this.m_coefPane.getUI();
        Dimension min = ui.getMinimumSize(this.m_coefPane);
        double w = pf.getImageableWidth() / 1.45;
        double h = pf.getImageableHeight() / 1.45;
        double wScale = 1.0;
        double hScale = 1.0;
        if (pf.getOrientation() == 1) {
            if ((double)min.width > w) {
                wScale = w / (double)min.width;
            }
            if ((double)min.height > h) {
                hScale = h / (double)min.height;
            }
        } else {
            if ((double)min.height > w) {
                wScale = w / (double)min.height;
            }
            if ((double)min.width > h) {
                hScale = h / (double)min.width;
            }
        }
        double scale = Math.min(wScale, hScale);
        g2.scale(scale, scale);
        this.m_coefPane.paint(g2);
        return 0;
    }

    public View getView() {
        BasicTextUI ui = (BasicTextUI)this.m_coefPane.getUI();
        return ui.getRootView(this.m_coefPane).getView(0);
    }

    public void releaseMemory() {
        this.removeAll();
    }
}

