/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.dndtree.DefaultTransferInfo;
import com.insightful.miner.dndtree.DefaultTransferable;
import com.insightful.miner.dndtree.DragOverData;
import com.insightful.miner.dndtree.Instrumenter;
import com.insightful.miner.dndtree.SubTreeNode;
import com.insightful.miner.dndtree.VetoException;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeDropTargetListener
implements DropTargetListener {
    protected JTree m_tree;
    protected Instrumenter m_instrument;
    protected DefaultMutableTreeNode m_dragOverNode;
    protected Timer m_timerScroll = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            TreeDropTargetListener.this.maybeScrollList();
        }
    });
    protected Timer m_timerExpand = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            if (TreeDropTargetListener.this.m_pathToExpand != null) {
                if (TreeDropTargetListener.this.m_bExpandActionIsExpand) {
                    TreeDropTargetListener.this.m_tree.expandPath(TreeDropTargetListener.this.m_pathToExpand);
                } else {
                    TreeDropTargetListener.this.m_tree.collapsePath(TreeDropTargetListener.this.m_pathToExpand);
                }
                TreeDropTargetListener.this.m_bAllowExpand = false;
            }
        }
    });
    protected TreePath m_pathToExpand;
    protected boolean m_bExpandActionIsExpand;
    protected boolean m_bAllowExpand = true;
    protected TreePath m_lastPath;
    protected Point m_lastMouseLocation;
    protected int m_nLastDropEffect = 1;
    protected static DataFlavor m_textPlainMimeType = null;

    public TreeDropTargetListener(JTree tree, Instrumenter instrument) {
        this.m_tree = tree;
        this.m_instrument = instrument;
        this.m_timerScroll.setInitialDelay(0);
    }

    protected boolean checkFlavourSupported(DataFlavor[] flavours) {
        for (int i = 0; i < flavours.length; ++i) {
            if (!flavours[i].equals(DefaultTransferable.DEFAULT_NODE_INFO_FLAVOUR) && !flavours[i].equals(DataFlavor.stringFlavor) && !flavours[i].equals(DataFlavor.javaFileListFlavor) && !flavours[i].equals(DataFlavor.getTextPlainUnicodeFlavor()) && !flavours[i].isMimeTypeEqual("text/plain")) continue;
            return true;
        }
        return false;
    }

    public void dragEnter(DropTargetDragEvent dropDragEvent) {
        DataFlavor[] flavours = dropDragEvent.getCurrentDataFlavors();
        if (this.checkFlavourSupported(flavours)) {
            dropDragEvent.acceptDrag(3);
        } else {
            dropDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropEvent) {
        this.checkDragOver(null);
    }

    public void dragOver(DropTargetDragEvent dropDragEvent) {
        this.checkDragOver(dropDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropDragEvent) {
    }

    public synchronized void drop(DropTargetDropEvent dropDropEvent) {
        try {
            int parentindex;
            DefaultMutableTreeNode parentnode;
            Point loc = dropDropEvent.getLocation();
            TreePath targetpath = this.m_tree.getClosestPathForLocation(loc.x, loc.y);
            if (targetpath != null) {
                parentnode = (DefaultMutableTreeNode)targetpath.getLastPathComponent();
                parentindex = parentnode.getParent() != null ? parentnode.getParent().getIndex(parentnode) : 0;
                if (this.m_nLastDropEffect != 1) {
                    parentnode = (DefaultMutableTreeNode)parentnode.getParent();
                    if (this.m_nLastDropEffect == 3) {
                        ++parentindex;
                    }
                } else {
                    parentindex = 0;
                }
            } else {
                parentnode = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
                parentindex = 0;
            }
            if (parentnode != null) {
                if (dropDropEvent.getTransferable().isDataFlavorSupported(DefaultTransferable.DEFAULT_NODE_INFO_FLAVOUR)) {
                    int accept_action = dropDropEvent.isLocalTransfer() ? 2 : 1;
                    dropDropEvent.acceptDrop(accept_action);
                    DefaultTransferInfo info = (DefaultTransferInfo)dropDropEvent.getTransferable().getTransferData(DefaultTransferable.DEFAULT_NODE_INFO_FLAVOUR);
                    boolean is_same_tree = dropDropEvent.isLocalTransfer() && this.m_instrument.getMyInstrumentId() == info.getDndId().getInstrumentId();
                    SubTreeNode[] nodes = info.getNodes();
                    boolean drop_failed = false;
                    boolean added_undo = false;
                    if (is_same_tree) {
                        DefaultMutableTreeNode iter = parentnode;
                        do {
                            if (!this.m_tree.isPathSelected(new TreePath(iter.getPath()))) continue;
                            return;
                        } while ((iter = (DefaultMutableTreeNode)iter.getParent()) != null);
                        for (int i = nodes.length - 1; i >= 0; --i) {
                            try {
                                this.m_instrument.doDndCompoundAdd(this.m_instrument.getMyInstrumentId(), parentnode, nodes[i].createNode(), parentindex);
                                added_undo = true;
                                continue;
                            }
                            catch (VetoException ex) {
                                drop_failed = true;
                            }
                        }
                        this.m_instrument.finishDndOperation(this.m_instrument.getMyInstrumentId(), drop_failed);
                    } else {
                        DefaultMutableTreeNode[] newnodes = new DefaultMutableTreeNode[nodes.length];
                        for (int i = 0; i < nodes.length; ++i) {
                            newnodes[i] = nodes[i].createNode();
                        }
                        this.m_instrument.addNodes(parentnode, newnodes, parentindex);
                    }
                    dropDropEvent.getDropTargetContext().dropComplete(!drop_failed);
                    if (drop_failed && added_undo) {
                        this.m_instrument.getUndoManager().undo();
                    }
                } else if (dropDropEvent.getTransferable().isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    dropDropEvent.acceptDrop(1);
                    String info = (String)dropDropEvent.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    BufferedReader br = new BufferedReader(new StringReader(info));
                    Vector<TreeNode> newnodes = new Vector<TreeNode>();
                    while (br.ready()) {
                        newnodes.addElement(this.m_instrument.getNodeFactory().createNode(br.readLine(), ""));
                    }
                    Object[] arr_newnodes = new DefaultMutableTreeNode[newnodes.size()];
                    newnodes.copyInto(arr_newnodes);
                    this.m_instrument.addNodes(parentnode, (DefaultMutableTreeNode[])arr_newnodes, parentindex);
                    dropDropEvent.getDropTargetContext().dropComplete(true);
                } else if (dropDropEvent.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropDropEvent.acceptDrop(1);
                    List info = (List)dropDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    DefaultMutableTreeNode[] newnodes = new DefaultMutableTreeNode[info.size()];
                    Iterator iter = info.iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        File file = (File)iter.next();
                        DefaultMutableTreeNode node = this.makeFileNode(file);
                        newnodes[i++] = node;
                    }
                    this.m_instrument.addNodes(parentnode, newnodes, parentindex);
                    dropDropEvent.getDropTargetContext().dropComplete(true);
                } else if (this.checkForMimeType(dropDropEvent.getTransferable().getTransferDataFlavors(), "text/plain") != null) {
                    dropDropEvent.acceptDrop(1);
                    DataFlavor flavour = this.checkForMimeType(dropDropEvent.getTransferable().getTransferDataFlavors(), "text/plain");
                    Reader info = flavour.getReaderForText(dropDropEvent.getTransferable());
                    BufferedReader br = new BufferedReader(info);
                    Vector<TreeNode> newnodes = new Vector<TreeNode>();
                    while (br.ready()) {
                        TreeNode ob = this.m_instrument.getNodeFactory().createNode(br.readLine(), "");
                        if (!br.ready()) continue;
                        newnodes.addElement(ob);
                    }
                    Object[] arr_newnodes = new DefaultMutableTreeNode[newnodes.size()];
                    newnodes.copyInto(arr_newnodes);
                    this.m_instrument.addNodes(parentnode, (DefaultMutableTreeNode[])arr_newnodes, parentindex);
                    dropDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    dropDropEvent.rejectDrop();
                }
            } else {
                dropDropEvent.rejectDrop();
            }
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            dropDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ex2) {
            ex2.printStackTrace();
            dropDropEvent.rejectDrop();
        }
    }

    protected void checkDragOver(DropTargetDragEvent ev) {
        boolean clear_old_node = false;
        DefaultMutableTreeNode new_node = null;
        int new_effect = 0;
        if (ev == null) {
            if (this.m_dragOverNode != null) {
                clear_old_node = true;
            }
            this.m_timerScroll.stop();
            this.m_timerExpand.stop();
        } else {
            Point loc;
            int old_row = -1;
            int old_effect = 0;
            this.m_lastMouseLocation = loc = ev.getLocation();
            TreePath path = this.m_tree.getPathForLocation(loc.x, loc.y);
            if (path == null || !path.equals(this.m_lastPath)) {
                this.m_lastPath = path;
                this.m_bAllowExpand = true;
            }
            if (this.locIsOnUppermostRow(loc) && !this.checkScrollBarAtTop() || this.locIsOnLowermostRow(loc) && !this.checkScrollBarAtBottom()) {
                this.m_timerExpand.stop();
                if (!this.m_timerScroll.isRunning()) {
                    this.m_timerScroll.start();
                }
            } else {
                this.m_timerScroll.stop();
                if (path != null && !this.m_tree.getModel().isLeaf(path.getLastPathComponent())) {
                    boolean expand;
                    boolean bl = expand = !this.m_tree.isExpanded(path);
                    if (!(!this.m_bAllowExpand || this.m_timerExpand.isRunning() && path.equals(this.m_pathToExpand) && this.m_bExpandActionIsExpand == expand)) {
                        this.m_timerExpand.stop();
                        this.m_bExpandActionIsExpand = expand;
                        this.m_pathToExpand = path;
                        this.m_timerExpand.start();
                    }
                } else {
                    this.m_timerExpand.stop();
                }
            }
            int row = this.m_tree.getClosestRowForLocation(loc.x, loc.y);
            if (this.m_dragOverNode != null) {
                old_row = this.m_tree.getRowForPath(new TreePath(this.m_dragOverNode.getPath()));
                if (this.m_dragOverNode.getUserObject() instanceof DragOverData) {
                    old_effect = ((DragOverData)this.m_dragOverNode.getUserObject()).getCurrentEffect();
                }
                if (old_row != row) {
                    clear_old_node = true;
                }
            }
            if (row != -1) {
                new_node = (DefaultMutableTreeNode)this.m_tree.getPathForRow(row).getLastPathComponent();
                new_effect = this.determineEffect(loc, row);
                if (row == old_row && new_effect == old_effect) {
                    new_node = null;
                }
            }
        }
        if (clear_old_node) {
            this.activateNewDragOverEffect(this.m_dragOverNode, 0);
            this.m_dragOverNode = null;
        }
        if (new_node != null) {
            this.activateNewDragOverEffect(new_node, new_effect);
            this.m_dragOverNode = new_node;
            this.m_nLastDropEffect = new_effect;
        }
    }

    protected int determineEffect(Point loc, int row) {
        Rectangle bounds = this.m_tree.getRowBounds(row);
        Point t_loc = new Point(loc);
        t_loc.translate(-bounds.x, -bounds.y);
        if ((double)t_loc.y < 0.25 * (double)bounds.height) {
            return 2;
        }
        if ((double)t_loc.y > 0.75 * (double)bounds.height) {
            return 3;
        }
        return 1;
    }

    protected void activateNewDragOverEffect(DefaultMutableTreeNode node, int effect) {
        if (!((DragAndDropTree)this.m_tree).isDropable()) {
            return;
        }
        if (node.getUserObject() instanceof DragOverData) {
            DragOverData dod = (DragOverData)node.getUserObject();
            dod.setCurrentEffect(effect);
            this.m_tree.getModel().valueForPathChanged(new TreePath(node.getPath()), dod);
        }
    }

    protected boolean locIsOnUppermostRow(Point loc) {
        int top_row;
        if (loc == null) {
            return false;
        }
        int height = this.m_tree.getRowHeight();
        if (height <= 0) {
            height = 10;
        }
        if ((top_row = this.m_tree.getClosestRowForLocation(0, this.m_tree.getVisibleRect().y + height)) != -1) {
            Rectangle bounds = this.m_tree.getRowBounds(top_row);
            return loc.y <= bounds.y + bounds.height;
        }
        return false;
    }

    protected boolean locIsOnLowermostRow(Point loc) {
        int bot_row;
        if (loc == null) {
            return false;
        }
        int height = this.m_tree.getRowHeight();
        if (height <= 0) {
            height = 10;
        }
        if ((bot_row = this.m_tree.getClosestRowForLocation(0, this.m_tree.getVisibleRect().y + this.m_tree.getVisibleRect().height - height)) != -1) {
            Rectangle bounds = this.m_tree.getRowBounds(bot_row);
            return loc.y >= bounds.y;
        }
        return false;
    }

    protected JScrollBar fetchScrollBar() {
        Container parent = this.m_tree.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return null;
        }
        if ((parent = parent.getParent()) == null || !(parent instanceof JScrollPane)) {
            return null;
        }
        JScrollPane pane = (JScrollPane)parent;
        return pane.getVerticalScrollBar();
    }

    protected boolean checkScrollBarAtTop() {
        JScrollBar bar = this.fetchScrollBar();
        if (bar == null) {
            return true;
        }
        return bar.getValue() == bar.getMinimum();
    }

    protected boolean checkScrollBarAtBottom() {
        JScrollBar bar = this.fetchScrollBar();
        if (bar == null) {
            return true;
        }
        return bar.getValue() >= bar.getMaximum() - bar.getVisibleAmount();
    }

    protected void maybeScrollList() {
        JScrollBar bar = this.fetchScrollBar();
        if (bar == null) {
            return;
        }
        if (this.locIsOnLowermostRow(this.m_lastMouseLocation)) {
            bar.setValue(bar.getValue() + bar.getBlockIncrement());
        } else if (this.locIsOnUppermostRow(this.m_lastMouseLocation)) {
            bar.setValue(bar.getValue() - bar.getBlockIncrement());
        }
    }

    protected DefaultMutableTreeNode makeFileNode(File file) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_instrument.getNodeFactory().createNode(file.getName(), "");
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                node.add(this.makeFileNode(children[i]));
            }
        }
        return node;
    }

    protected DataFlavor checkForMimeType(DataFlavor[] flavours, String mimetype) {
        DataFlavor found = null;
        for (int i = 0; i < flavours.length; ++i) {
            if (!flavours[i].isMimeTypeEqual(mimetype) || found != null && !flavours[i].getParameter("charset").equalsIgnoreCase("unicode")) continue;
            found = flavours[i];
        }
        return found;
    }

    static {
        try {
            m_textPlainMimeType = new DataFlavor("text/plain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

