/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Column;
import com.insightful.miner.sql.DITypeInfo;
import com.insightful.miner.sql.Function;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Like;
import com.insightful.miner.sql.NumberSequence;
import com.insightful.miner.sql.Record;
import com.insightful.miner.sql.Result;
import com.insightful.miner.sql.Select;
import com.insightful.miner.sql.SetFunction;
import com.insightful.miner.sql.TableFilter;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.Types;
import com.insightful.miner.sql.lib.HashSet;
import com.insightful.miner.sql.lib.HsqlArrayList;
import com.insightful.miner.sql.lib.ValuePool;
import java.util.Vector;

public class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int FALSE = -4;
    static final int VALUELIST = 5;
    static final int ASTERIX = 6;
    static final int FUNCTION = 7;
    static final int LIMIT = 8;
    static final int PARAM = 9;
    static final int NEGATE = 10;
    static final int ADD = 11;
    static final int SUBTRACT = 12;
    static final int MULTIPLY = 13;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int VARIANCE = 45;
    static final int STDDEV = 46;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int EXTRACT = 63;
    static final int POSITION = 64;
    static final int TRIM = 65;
    static final int SUBSTRING = 66;
    static final int NULLIF = 67;
    static final int CASE = 68;
    static final int COALESCE = 69;
    static final int ALTERNATIVE = 70;
    static final int SEQUENCE = 71;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int STRINGCONCAT = 105;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    static final int IS = 109;
    static final int WHEN = 110;
    static final int THEN = 111;
    static final int ELSE = 112;
    static final int ENDWHEN = 113;
    static final int AS = 122;
    static final int FOR = 123;
    static final int FROM = 124;
    static final int BOTH = 125;
    static final int LEADING = 126;
    static final int TRAILING = 127;
    static final int YEAR = 128;
    static final int MONTH = 129;
    static final int DAY = 130;
    static final int HOUR = 131;
    static final int MINUTE = 132;
    static final int SECOND = 133;
    static final int TIMEZONE_HOUR = 134;
    static final int T_TIMEZONE_MINUTE = 135;
    static final HashSet SQL_EXTRACT_FIELD_NAMES = new HashSet();
    static final HashSet SQL_TRIM_SPECIFICATION = new HashSet();
    private static final int AGGREGATE_SELF = -1;
    private static final int AGGREGATE_NONE = 0;
    private static final int AGGREGATE_LEFT = 1;
    private static final int AGGREGATE_RIGHT = 2;
    private static final int AGGREGATE_BOTH = 3;
    private static final int AGGREGATE_FUNCTION = 4;
    int exprType;
    private int aggregateSpec = 0;
    private Expression eArg;
    private Expression eArg2;
    Vector valueData = new Vector(1);
    private HashSet hList;
    private int dataType;
    Expression[] valueList;
    private boolean isFixedConstantValueList;
    Select subSelect;
    boolean isCorrelated;
    Function function;
    private Like likeObject;
    private String catalog;
    private String schema;
    private String tableName;
    private String columnName;
    private TableFilter tableFilter;
    TableFilter outerFilter;
    private int columnIndex;
    private boolean columnQuoted;
    private int columnSize;
    private int columnScale;
    private String columnAlias;
    private boolean aliasQuoted;
    private boolean isDescending;
    int orderColumnIndex = -1;
    private boolean isDistinctAggregate;
    private boolean isParam;
    boolean isInJoin;
    static final Integer INTEGER_0;
    static final Integer INTEGER_1;
    int oldIType = -1;
    static final int PARAM_UNKNOWN = 0;
    public static final int PARAM_IN = 1;
    public static final int PARAM_IN_OUT = 2;
    public static final int PARAM_OUT = 4;
    static final int NO_NULLS = 0;
    static final int NULLABLE = 1;
    static final int NULLABLE_UNKNOWN = 2;
    boolean isIdentity;
    int nullability = 2;
    boolean isWritable;
    int paramMode = 0;
    String valueClassName;

    Expression(boolean b) {
        this.exprType = b ? 4 : -4;
    }

    Expression(Function f) {
        this.exprType = 7;
        this.function = f;
        if (f.hasAggregate) {
            this.aggregateSpec = 4;
        }
    }

    Expression(NumberSequence sequence) {
        this.exprType = 71;
        this.valueData.add(sequence);
        this.dataType = sequence.getType();
    }

    Expression(Expression e) {
        this.exprType = e.exprType;
        this.dataType = e.dataType;
        this.eArg = e.eArg;
        this.eArg2 = e.eArg2;
        this.isInJoin = e.isInJoin;
        this.likeObject = e.likeObject;
        this.subSelect = e.subSelect;
        this.function = e.function;
        this.checkAggregate();
    }

    Expression(Select s, boolean correlated) {
        this.exprType = 3;
        this.subSelect = s;
        this.isCorrelated = correlated;
    }

    Expression(Expression[] valueList) {
        this.exprType = 5;
        this.valueList = valueList;
    }

    Expression(int type, Expression e, Expression e2) {
        this.exprType = type;
        this.eArg = e;
        this.eArg2 = e2;
        this.checkAggregate();
    }

    Expression(Expression e, Expression e2, Character escape) {
        this.exprType = 27;
        this.eArg = e;
        this.eArg2 = e2;
        this.likeObject = new Like(escape);
        this.checkAggregate();
    }

    Expression(String table, String column) {
        this.tableName = table;
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column;
        }
    }

    Expression(String table, String column, boolean isquoted) {
        this.tableName = table;
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column;
            this.columnQuoted = isquoted;
        }
    }

    Expression(String table, Column column) {
        this.tableName = table;
        if (column == null) {
            this.exprType = 6;
        } else {
            this.exprType = 2;
            this.columnName = column.columnName.name;
            this.columnQuoted = column.columnName.isNameQuoted;
            this.dataType = column.getType();
        }
    }

    Expression(int datatype, Object o) {
        this.exprType = 1;
        this.dataType = datatype;
        this.valueData.add(o);
    }

    Expression(int datatype, Object o, boolean isParam) {
        this(datatype, o);
        this.isParam = isParam;
        if (isParam) {
            this.paramMode = 1;
        }
    }

    private void checkAggregate() {
        if (Expression.isAggregate(this.exprType)) {
            this.aggregateSpec = -1;
        } else {
            this.aggregateSpec = 0;
            if (this.eArg != null && this.eArg.isAggregate()) {
                ++this.aggregateSpec;
            }
            if (this.eArg2 != null && this.eArg2.isAggregate()) {
                this.aggregateSpec += 2;
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    static String getContextDDL(Expression expression) throws HsqlException {
        String ddl = expression.getDDL();
        if (expression.exprType != 1 && expression.exprType != 2 && expression.exprType != 7 && expression.exprType != 70 && expression.exprType != 62 && expression.exprType != 61) {
            StringBuffer temp = new StringBuffer();
            ddl = temp.append('(').append(ddl).append(')').toString();
        }
        return ddl;
    }

    String getDDL() throws HsqlException {
        StringBuffer buf = new StringBuffer(64);
        String left = null;
        String right = null;
        if (this.eArg != null) {
            left = Expression.getContextDDL(this.eArg);
        }
        if (this.eArg2 != null) {
            right = Expression.getContextDDL(this.eArg2);
        }
        switch (this.exprType) {
            case 7: {
                return this.function.getDLL();
            }
            case 1: {
                try {
                    Object v = this.valueData.size() == 0 ? null : this.valueData.get(0);
                    return Column.createSQLString(v, this.dataType);
                }
                catch (HsqlException e) {
                    return buf.toString();
                }
            }
            case 2: {
                if (this.tableName != null) {
                    buf.append(this.tableFilter.getName());
                }
                buf.append(this.getAlias());
                return buf.toString();
            }
            case 4: {
                return "TRUE";
            }
            case -4: {
                return "FALSE";
            }
            case 5: {
                for (int i = 0; i < this.valueList.length; ++i) {
                    buf.append(this.valueList[i].getDDL());
                    if (i >= this.valueList.length - 1) continue;
                    buf.append(',');
                }
                return buf.toString();
            }
            case 6: {
                buf.append('*');
                return buf.toString();
            }
            case 10: {
                buf.append('-').append(left);
                return buf.toString();
            }
            case 11: {
                buf.append(left).append('+').append(right);
                return buf.toString();
            }
            case 12: {
                buf.append(left).append('-').append(right);
                return buf.toString();
            }
            case 13: {
                buf.append(left).append('*').append(right);
                return buf.toString();
            }
            case 14: {
                buf.append(left).append('/').append(right);
                return buf.toString();
            }
            case 15: {
                buf.append(left).append("||").append(right);
                return buf.toString();
            }
            case 20: {
                buf.append("NOT").append(' ').append(left);
                return buf.toString();
            }
            case 21: {
                if ("NULL".equals(right)) {
                    buf.append(left).append(" IS ").append(right);
                } else {
                    buf.append(left).append('=').append(right);
                }
                return buf.toString();
            }
            case 22: {
                buf.append(left).append(">=").append(right);
                return buf.toString();
            }
            case 23: {
                buf.append(left).append('>').append(right);
                return buf.toString();
            }
            case 24: {
                buf.append(left).append('<').append(right);
                return buf.toString();
            }
            case 25: {
                buf.append(left).append("<=").append(right);
                return buf.toString();
            }
            case 26: {
                if ("NULL".equals(right)) {
                    buf.append(left).append(" IS NOT ").append(right);
                } else {
                    buf.append(left).append("!=").append(right);
                }
                return buf.toString();
            }
            case 27: {
                buf.append(left).append(' ').append("LIKE").append(' ');
                buf.append(right);
                if (this.likeObject.escapeChar != null) {
                    buf.append(' ').append("ESCAPE").append(' ').append('\'');
                    buf.append(this.likeObject.escapeChar.toString()).append('\'');
                    buf.append(' ');
                }
                return buf.toString();
            }
            case 28: {
                buf.append(left).append(' ').append("AND").append(' ').append(right);
                return buf.toString();
            }
            case 29: {
                buf.append(left).append(' ').append("OR").append(' ').append(right);
                return buf.toString();
            }
            case 30: {
                buf.append(left).append(' ').append("IN").append(' ').append(right);
                return buf.toString();
            }
            case 61: {
                buf.append(' ').append("CONVERT").append('(');
                buf.append(left).append(',');
                buf.append(Types.getTypeString(this.dataType));
                buf.append(')');
                return buf.toString();
            }
            case 62: {
                buf.append(' ').append("CASEWHEN").append('(');
                buf.append(left).append(',').append(right).append(')');
                return buf.toString();
            }
            case 70: {
                buf.append(left).append(',').append(right);
                return buf.toString();
            }
            case 3: {
                break;
            }
            case 31: {
                buf.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 40: {
                buf.append(' ').append("COUNT").append('(');
                break;
            }
            case 46: {
                buf.append(' ').append("STDDEV").append('(');
                break;
            }
            case 45: {
                buf.append(' ').append("VARIANCE").append('(');
                break;
            }
            case 41: {
                buf.append(' ').append("SUM").append('(');
                buf.append(left).append(')');
                break;
            }
            case 42: {
                buf.append(' ').append("MIN").append('(');
                buf.append(left).append(')');
                break;
            }
            case 43: {
                buf.append(' ').append("MAX").append('(');
                buf.append(left).append(')');
                break;
            }
            case 44: {
                buf.append(' ').append("AVG").append('(');
                buf.append(left).append(')');
            }
        }
        throw Trace.error(20, "check constraint expression");
    }

    private String toString(int blanks) {
        StringBuffer buf = new StringBuffer(64);
        buf.append('\n');
        for (int i = 0; i < blanks; ++i) {
            buf.append(' ');
        }
        if (this.oldIType != -1) {
            buf.append("SET TRUE, WAS: ");
        }
        int lIType = this.oldIType == -1 ? this.exprType : this.oldIType;
        switch (lIType) {
            case 7: {
                buf.append("FUNCTION ");
                buf.append(this.function);
                return buf.toString();
            }
            case 1: {
                if (this.isParam) {
                    buf.append("PARAM ");
                }
                Object v = this.valueData.size() == 0 ? null : this.valueData.get(0);
                buf.append("VALUE = ").append((Object)v);
                buf.append(", TYPE = ").append(Types.getTypeString(this.dataType));
                return buf.toString();
            }
            case 2: {
                buf.append("COLUMN ");
                if (this.tableName != null) {
                    buf.append(this.tableName);
                    buf.append('.');
                }
                buf.append(this.columnName);
                return buf.toString();
            }
            case 3: {
                buf.append("QUERY ");
                buf.append(this.subSelect);
                return buf.toString();
            }
            case 4: {
                buf.append("TRUE ");
                break;
            }
            case -4: {
                buf.append("FALSE ");
                break;
            }
            case 5: {
                buf.append("VALUELIST ");
                buf.append(" TYPE = ").append(Types.getTypeString(this.dataType));
                if (this.valueList == null) break;
                for (int i = 0; i < this.valueList.length; ++i) {
                    buf.append(this.valueList[i].toString(blanks + blanks));
                    buf.append(' ');
                }
                break;
            }
            case 6: {
                buf.append("* ");
                break;
            }
            case 10: {
                buf.append("NEGATE ");
                break;
            }
            case 11: {
                buf.append("ADD ");
                break;
            }
            case 12: {
                buf.append("SUBTRACT ");
                break;
            }
            case 13: {
                buf.append("MULTIPLY ");
                break;
            }
            case 14: {
                buf.append("DIVIDE ");
                break;
            }
            case 15: {
                buf.append("CONCAT ");
                break;
            }
            case 20: {
                buf.append("NOT ");
                break;
            }
            case 21: {
                buf.append("EQUAL ");
                break;
            }
            case 22: {
                buf.append("BIGGER_EQUAL ");
                break;
            }
            case 23: {
                buf.append("BIGGER ");
                break;
            }
            case 24: {
                buf.append("SMALLER ");
                break;
            }
            case 25: {
                buf.append("SMALLER_EQUAL ");
                break;
            }
            case 26: {
                buf.append("NOT_EQUAL ");
                break;
            }
            case 27: {
                buf.append("LIKE ");
                break;
            }
            case 28: {
                buf.append("AND ");
                break;
            }
            case 29: {
                buf.append("OR ");
                break;
            }
            case 30: {
                buf.append("IN ");
                break;
            }
            case 31: {
                buf.append("EXISTS ");
                break;
            }
            case 40: {
                buf.append("COUNT ");
                break;
            }
            case 46: {
                buf.append("STDDEV ");
                break;
            }
            case 45: {
                buf.append("VARIANCE ");
                break;
            }
            case 41: {
                buf.append("SUM ");
                break;
            }
            case 42: {
                buf.append("MIN ");
                break;
            }
            case 43: {
                buf.append("MAX ");
                break;
            }
            case 44: {
                buf.append("AVG ");
                break;
            }
            case 61: {
                buf.append("CONVERT ");
                buf.append(Types.getTypeString(this.dataType));
                buf.append(' ');
                break;
            }
            case 62: {
                buf.append("CASEWHEN ");
            }
        }
        if (this.isInJoin) {
            buf.append(" join");
        }
        if (this.eArg != null) {
            buf.append(" arg1=[");
            buf.append(this.eArg.toString(blanks + 1));
            buf.append(']');
        }
        if (this.eArg2 != null) {
            buf.append(" arg2=[");
            buf.append(this.eArg2.toString(blanks + 1));
            buf.append(']');
        }
        return buf.toString();
    }

    void setDataType(int type) {
        this.dataType = type;
    }

    void setTrue() {
        if (this.oldIType == -1) {
            this.oldIType = this.exprType;
        }
        this.exprType = 4;
    }

    public boolean similarTo(Expression exp) {
        if (exp == null) {
            return false;
        }
        if (exp == this) {
            return true;
        }
        return this.exprType == exp.exprType && Expression.similarTo(this.eArg, exp.eArg) && Expression.similarTo(this.eArg2, exp.eArg2) && (this.valueData.size() == 0 && exp.valueData.size() == 0 || Expression.equals(this.valueData.get(0), exp.valueData.get(0))) && Expression.equals(this.valueList, exp.valueList) && this.dataType == exp.dataType && Expression.equals(this.subSelect, exp.subSelect) && Expression.equals(this.function, exp.function) && Expression.equals(this.tableName, exp.tableName) && Expression.equals(this.columnName, exp.columnName) && this.dataType == exp.dataType;
    }

    static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static boolean equals(Expression[] ae1, Expression[] ae2) {
        if (ae1 == ae2) {
            return true;
        }
        if (ae1.length != ae2.length) {
            return false;
        }
        int len = ae1.length;
        boolean equals = true;
        for (int i = 0; i < len; ++i) {
            Expression e1 = ae1[i];
            Expression e2 = ae2[i];
            equals = e1 == null ? e2 == null : e1.equals(e2);
        }
        return equals;
    }

    static boolean similarTo(Expression e1, Expression e2) {
        return e1 == null ? e2 == null : e1.similarTo(e2);
    }

    boolean canBeInGroupBy() {
        if (this.exprType == 7) {
            return true;
        }
        return this.isColumn() && !this.isAggregate();
    }

    boolean canBeInOrderBy() {
        return this.exprType == 7 || this.orderColumnIndex != -1 || this.isColumn() || this.isAggregate();
    }

    private boolean isColumn() {
        switch (this.exprType) {
            case 2: {
                return true;
            }
            case 10: {
                return this.eArg.isColumn();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isColumn() || this.eArg2.isColumn();
            }
        }
        return false;
    }

    boolean collectColumnName(HashSet columnNames) {
        boolean result;
        boolean bl = result = this.exprType == 2;
        if (result) {
            columnNames.add(this.columnName);
        }
        return result;
    }

    void collectAllColumnNames(HashSet columnNames) {
        if (!this.collectColumnName(columnNames)) {
            if (this.eArg != null) {
                this.eArg.collectAllColumnNames(columnNames);
            }
            if (this.eArg2 != null) {
                this.eArg2.collectAllColumnNames(columnNames);
            }
        }
    }

    boolean isConstant() {
        switch (this.exprType) {
            case 1: {
                return true;
            }
            case 10: {
                return this.eArg.isConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isConstant() && this.eArg2.isConstant();
            }
        }
        return false;
    }

    boolean canBeInAggregate() {
        return this.isAggregate() || this.isConstant();
    }

    boolean isAggregate() {
        return this.aggregateSpec != 0;
    }

    boolean isSelfAggregate() {
        return this.aggregateSpec == -1;
    }

    static boolean isAggregate(int type) {
        switch (type) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    boolean isConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                return true;
            }
            case 20: {
                return this.eArg.isConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isConditional() && this.eArg2.isConditional();
            }
        }
        return false;
    }

    void collectInGroupByExpressions(HsqlArrayList colExps) {
        if (!this.isConstant() && !this.isSelfAggregate()) {
            if (this.isColumn()) {
                colExps.add(this);
            } else {
                if (this.eArg != null) {
                    this.eArg.collectInGroupByExpressions(colExps);
                }
                if (this.eArg2 != null) {
                    this.eArg2.collectInGroupByExpressions(colExps);
                }
            }
        }
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setAlias(String s, boolean isquoted) {
        this.columnAlias = s;
        this.aliasQuoted = isquoted;
    }

    void setColumnName(String newname, boolean isquoted) {
        this.columnName = newname;
        this.columnQuoted = isquoted;
    }

    void setTableName(String newname) {
        this.tableName = newname;
    }

    String getDefinedAlias() {
        return this.columnAlias;
    }

    String getAlias() {
        String name;
        if (this.columnAlias != null) {
            return this.columnAlias;
        }
        if (this.exprType == 1) {
            return "";
        }
        if (this.exprType == 2) {
            return this.columnName;
        }
        if (this.eArg != null && (name = this.eArg.getColumnName()).length() > 0) {
            return name;
        }
        return this.eArg2 == null ? "" : this.eArg2.getAlias();
    }

    boolean isAliasQuoted() {
        String name;
        if (this.columnAlias != null) {
            return this.aliasQuoted;
        }
        if (this.exprType == 2) {
            return this.columnQuoted;
        }
        if (this.eArg != null && (name = this.eArg.getColumnName()).length() > 0) {
            return this.eArg.columnQuoted;
        }
        return this.eArg2 == null ? false : this.eArg2.columnQuoted;
    }

    int getType() {
        return this.exprType;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tableFilter;
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        if (this.eArg != null) {
            boolean bl = result = result && this.eArg.checkResolved(check);
        }
        if (this.eArg2 != null) {
            boolean bl = result = result && this.eArg2.checkResolved(check);
        }
        if (this.subSelect != null) {
            boolean bl = result = result && this.subSelect.checkResolved(check);
        }
        if (this.function != null) {
            boolean bl = result = result && this.function.checkResolved(check);
        }
        if (this.valueList != null) {
            for (int i = 0; i < this.valueList.length; ++i) {
                result = result && this.valueList[i].checkResolved(check);
            }
        }
        if (this.exprType == 2 && this.tableFilter == null) {
            boolean bl = result = this.orderColumnIndex != -1;
            if (!result && check) {
                String err = this.tableName == null ? this.columnName : this.tableName + "." + this.columnName;
                throw Trace.error(28, err);
            }
        }
        return result;
    }

    void checkTables(HsqlArrayList filters) throws HsqlException {
        if (filters == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.checkTables(filters);
        }
        if (this.eArg2 != null) {
            this.eArg2.checkTables(filters);
        }
        switch (this.exprType) {
            case 2: 
            case 3: {
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.checkTables(filters);
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] vl = this.eArg2.valueList;
                for (int i = 0; i < vl.length; ++i) {
                    vl[i].checkTables(filters);
                }
                break;
            }
        }
    }

    void setLikeOptimised() throws HsqlException {
        if (this.eArg != null) {
            this.eArg.setLikeOptimised();
        }
        if (this.eArg2 != null) {
            this.eArg2.setLikeOptimised();
        }
        if (this.exprType == 27) {
            this.likeObject.optimised = true;
        }
    }

    void getEquiJoinColumns(boolean[] columns, Expression[] elist) {
        if (this.eArg != null) {
            this.eArg.getEquiJoinColumns(columns, elist);
        }
        if (this.eArg2 != null) {
            this.eArg2.getEquiJoinColumns(columns, elist);
        }
        if (this.exprType == 21) {
            if (this.eArg2.exprType == 2 || this.eArg2.exprType == 1) {
                columns[this.eArg.columnIndex] = true;
                elist[this.eArg.columnIndex] = this.eArg2;
                return;
            }
            if (this.eArg.exprType == 2 || this.eArg.exprType == 1) {
                columns[this.eArg2.columnIndex] = true;
                elist[this.eArg2.columnIndex] = this.eArg;
            }
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        if (this.isParam || f == null || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTables(f);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTables(f);
        }
        switch (this.exprType) {
            case 2: {
                if (this.tableFilter != null) break;
                String filterName = f.getName();
                if (this.tableName != null && !this.tableName.equals(filterName)) break;
                this.tableFilter = f;
                this.tableName = filterName;
                this.setTableColumnAttributes(0);
                return;
            }
            case 3: {
                if (this.subSelect == null) break;
                this.subSelect.resolveTables(f);
                break;
            }
            case 7: {
                if (this.function == null) break;
                this.function.resolveTables(f);
                break;
            }
            case 30: {
                if (this.eArg2.exprType == 3) break;
                Expression[] vl = this.eArg2.valueList;
                for (int i = 0; i < vl.length; ++i) {
                    vl[i].resolveTables(f);
                }
                break;
            }
        }
    }

    void resolveTypes() throws HsqlException {
        if (this.isParam || this.exprType == 1) {
            return;
        }
        if (this.eArg != null) {
            this.eArg.resolveTypes();
        }
        if (this.eArg2 != null) {
            this.eArg2.resolveTypes();
        }
        switch (this.exprType) {
            case 7: {
                this.function.resolveType();
                this.dataType = this.function.getReturnType();
                break;
            }
            case 3: {
                this.subSelect.resolveTypes();
                this.dataType = this.subSelect.exprColumns[0].dataType;
                break;
            }
            case 10: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 212);
                }
                this.dataType = this.eArg.dataType;
                if (!this.isFixedConstant()) break;
                if (this.valueData.size() == 1) {
                    this.valueData.set(0, this.getValue(this.dataType));
                } else {
                    this.valueData.add(this.getValue(this.dataType));
                }
                this.eArg = null;
                this.exprType = 1;
                break;
            }
            case 11: {
                if (Types.isCharacterType(this.eArg.dataType) || Types.isCharacterType(this.eArg2.dataType)) {
                    this.exprType = 15;
                    this.dataType = 12;
                    if (this.isFixedConstant()) {
                        if (this.valueData.size() == 1) {
                            this.valueData.set(0, this.getValue(this.dataType));
                        } else {
                            this.valueData.add(this.getValue(this.dataType));
                        }
                        this.eArg = null;
                        this.eArg2 = null;
                        this.exprType = 1;
                        break;
                    }
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 12;
                    }
                    if (!this.eArg2.isParam) break;
                    this.eArg2.dataType = 12;
                    break;
                }
            }
            case 12: 
            case 13: 
            case 14: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 213);
                }
                if (this.isFixedConstant()) {
                    this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                    if (this.valueData.size() == 1) {
                        this.valueData.set(0, this.getValue(this.dataType));
                    } else {
                        this.valueData.add(this.getValue(this.dataType));
                    }
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = this.eArg2.dataType;
                } else if (this.eArg2.isParam) {
                    this.eArg2.dataType = this.eArg.dataType;
                }
                this.dataType = Column.getCombinedNumberType(this.eArg.dataType, this.eArg2.dataType, this.exprType);
                break;
            }
            case 15: {
                this.dataType = 12;
                if (this.isFixedConstant()) {
                    if (this.valueData.size() == 1) {
                        this.valueData.set(0, this.getValue(this.dataType));
                    } else {
                        this.valueData.add(this.getValue(this.dataType));
                    }
                    this.eArg = null;
                    this.eArg2 = null;
                    this.exprType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.dataType = 12;
                }
                if (!this.eArg2.isParam) break;
                this.eArg2.dataType = 12;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (this.eArg.isParam && this.eArg2.isParam) {
                    throw Trace.error(216, 214);
                }
                if (this.isFixedConditional()) {
                    this.exprType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (this.eArg.isParam) {
                    int n = this.eArg.dataType = this.eArg2.dataType == 0 ? 12 : this.eArg2.dataType;
                    if (this.eArg2.exprType == 2) {
                        this.eArg.setTableColumnAttributes(this.eArg2);
                    }
                } else if (this.eArg2.isParam) {
                    int n = this.eArg2.dataType = this.eArg.dataType == 0 ? 12 : this.eArg.dataType;
                    if (this.eArg.exprType == 2) {
                        this.eArg2.setTableColumnAttributes(this.eArg);
                    }
                }
                this.dataType = 16;
                break;
            }
            case 27: {
                this.resolveTypeForLike();
                this.dataType = 16;
                break;
            }
            case 28: {
                boolean eArgFixed = this.eArg.isFixedConditional();
                boolean eArg2Fixed = this.eArg2.isFixedConditional();
                if (eArgFixed && eArg2Fixed) {
                    this.exprType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (eArgFixed && !this.eArg.test() || eArg2Fixed && !this.eArg2.test()) {
                    this.exprType = -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 29: {
                boolean eArgFixed = this.eArg.isFixedConditional();
                boolean eArg2Fixed = this.eArg2.isFixedConditional();
                if (eArgFixed && eArg2Fixed) {
                    this.exprType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (eArgFixed && this.eArg.test() || eArg2Fixed && this.eArg2.test()) {
                    this.exprType = 4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.dataType = 16;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.dataType = 16;
                    }
                }
                this.dataType = 16;
                break;
            }
            case 20: {
                if (this.isFixedConditional()) {
                    this.exprType = this.test() ? 4 : -4;
                    this.eArg = null;
                } else if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = 16;
                break;
            }
            case 30: {
                this.resolveTypeForIn();
                this.dataType = 16;
                break;
            }
            case 31: {
                this.dataType = 16;
                break;
            }
            case 40: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (this.eArg.isParam) {
                    throw Trace.error(216, 215);
                }
                this.dataType = SetFunction.getType(this.exprType, this.eArg.dataType);
                break;
            }
            case 61: {
                if (!this.eArg.isFixedConstant() && !this.eArg.isFixedConditional()) break;
                if (this.valueData.size() == 1) {
                    this.valueData.set(0, this.getValue());
                } else {
                    this.valueData.add(this.getValue());
                }
                this.exprType = 1;
                this.eArg = null;
                break;
            }
            case 62: {
                if (this.eArg.isParam) {
                    this.eArg.dataType = 16;
                }
                this.dataType = this.eArg2.dataType;
                break;
            }
            case 70: {
                Expression case1 = this.eArg;
                Expression case2 = this.eArg2;
                if (case1.isParam && case2.isParam) {
                    throw Trace.error(216, 217);
                }
                if (case1.isParam || case1.dataType == 0) {
                    case1.dataType = case2.dataType;
                } else if (case2.isParam || case2.dataType == 0) {
                    case2.dataType = case1.dataType;
                }
                if (case1.dataType == 0 && case2.dataType == 0) {
                    this.dataType = 0;
                }
                if (Types.isNumberType(case1.dataType) && Types.isNumberType(case2.dataType)) {
                    this.dataType = Column.getCombinedNumberType(case1.dataType, case2.dataType, 70);
                    break;
                }
                if (Types.isCharacterType(case1.dataType) && Types.isCharacterType(case2.dataType)) {
                    this.dataType = -1;
                    break;
                }
                if (case1.dataType == case2.dataType) break;
                throw Trace.error(216, 218, new String[]{Types.getTypeString(case1.dataType), Types.getTypeString(case2.dataType)});
            }
        }
    }

    void resolveTypeForLike() throws HsqlException {
        if (this.eArg.isParam && this.eArg2.isParam) {
            throw Trace.error(216, 219);
        }
        if (this.isFixedConditional()) {
            this.exprType = this.test() ? 4 : -4;
            this.eArg = null;
            this.eArg2 = null;
        } else if (this.eArg.isParam) {
            this.eArg.dataType = 12;
        } else if (this.eArg2.isParam) {
            this.eArg2.dataType = 12;
        }
        if (this.likeObject.optimised) {
            return;
        }
        boolean isRightArgFixedConstant = this.eArg2.isFixedConstant();
        String likeStr = isRightArgFixedConstant ? (String)this.eArg2.getValue(12) : null;
        boolean ignoreCase = this.eArg.dataType == 100 || this.eArg2.dataType == 100;
        this.likeObject.setParams(likeStr, ignoreCase);
        if (!isRightArgFixedConstant) {
            return;
        }
        if (this.likeObject.isEquivalentToFalsePredicate()) {
            this.exprType = -4;
            this.eArg = null;
            this.eArg2 = null;
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.exprType = 21;
            this.eArg2 = new Expression(12, (Object)this.likeObject.getRangeLow());
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToNotNullPredicate()) {
            this.exprType = 26;
            this.eArg2 = new Expression(0, null);
            this.likeObject = null;
        } else {
            if (this.eArg.exprType != 2) {
                return;
            }
            if (!Types.isCharacterType(this.eArg.dataType)) {
                return;
            }
            boolean between = false;
            boolean like = false;
            boolean larger = false;
            if (this.likeObject.isEquivalentToBetweenPredicate()) {
                larger = Column.sql_compare_in_locale;
                between = !larger;
                like = larger;
            } else if (this.likeObject.isEquivalentToBetweenPredicateAugmentedWithLike()) {
                larger = Column.sql_compare_in_locale;
                between = !larger;
                like = true;
            }
            if (!between && !larger) {
                return;
            }
            Expression eFirst = new Expression(12, (Object)this.likeObject.getRangeLow());
            Expression eLast = new Expression(12, (Object)this.likeObject.getRangeHigh());
            if (between && !like) {
                Expression eArgOld = this.eArg;
                this.eArg = new Expression(22, eArgOld, eFirst);
                this.eArg2 = new Expression(25, eArgOld, eLast);
                this.exprType = 28;
                this.likeObject = null;
            } else if (between && like) {
                Expression gte = new Expression(22, this.eArg, eFirst);
                Expression lte = new Expression(25, this.eArg, eLast);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = new Expression(28, gte, lte);
                this.exprType = 28;
                this.likeObject = null;
            } else if (larger) {
                Expression gte = new Expression(22, this.eArg, eFirst);
                this.eArg2 = new Expression(this.eArg, this.eArg2, this.likeObject.escapeChar);
                this.eArg2.likeObject = this.likeObject;
                this.eArg = gte;
                this.exprType = 28;
                this.likeObject = null;
            }
        }
    }

    void resolveTypeForIn() throws HsqlException {
        if (this.eArg2.exprType == 3) {
            if (this.eArg.isParam) {
                this.eArg.dataType = this.eArg2.dataType;
            }
        } else {
            int i;
            Expression[] vl = this.eArg2.valueList;
            int len = vl.length;
            if (this.eArg.isParam) {
                if (len <= 0) {
                    throw Trace.error(216, 220);
                }
                if (vl[0].isParam) {
                    throw Trace.error(216, 221);
                }
                Expression e = vl[0];
                int dt = e.dataType;
                if (dt != 0) {
                    if (this.eArg.dataType == 0) {
                        this.eArg.dataType = dt;
                    }
                    if (this.eArg2.dataType == 0) {
                        this.eArg2.dataType = dt;
                    }
                }
                for (int i2 = 1; i2 < len; ++i2) {
                    e = vl[i2];
                    if (e.isParam) {
                        if (e.dataType != 0 || dt == 0) continue;
                        e.dataType = dt;
                        continue;
                    }
                    e.resolveTypes();
                }
            } else {
                int dt = this.eArg.dataType;
                if (this.eArg2.dataType == 0 && dt != 0) {
                    this.eArg2.dataType = dt;
                }
                for (int i3 = 0; i3 < len; ++i3) {
                    Expression e = vl[i3];
                    if (e.isParam) {
                        if (e.dataType != 0 || dt == 0) continue;
                        e.dataType = dt;
                        continue;
                    }
                    e.resolveTypes();
                }
            }
            this.eArg2.isFixedConstantValueList = true;
            for (i = 0; i < len; ++i) {
                if (vl[i].isFixedConstant()) continue;
                this.eArg2.isFixedConstantValueList = false;
                break;
            }
            if (this.eArg2.isFixedConstantValueList) {
                this.eArg2.hList = new HashSet();
                for (i = 0; i < len; ++i) {
                    try {
                        Object value = this.eArg2.valueList[i].getValue();
                        value = Column.convertObject(value, this.eArg2.dataType);
                        this.eArg2.hList.add(value);
                        continue;
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    boolean isResolved() {
        switch (this.exprType) {
            case 1: 
            case 10: {
                return true;
            }
            case 2: {
                return this.tableFilter != null && this.tableFilter.isAssigned;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    static boolean isCompare(int i) {
        switch (i) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.exprType == 6) {
            return this.tableName;
        }
        if (this.exprType == 2) {
            if (this.tableFilter == null) {
                return this.tableName;
            }
            return this.tableFilter.getName();
        }
        return "";
    }

    String getColumnName() {
        if (this.exprType == 2 && this.tableFilter == null) {
            return this.columnName;
        }
        return this.getAlias();
    }

    int getColumnNr() {
        return this.columnIndex;
    }

    int getColumnSize() {
        return this.columnSize;
    }

    int getColumnScale() {
        return this.columnScale;
    }

    void setDistinctAggregate(boolean distinct) {
        boolean bl = this.isDistinctAggregate = distinct && this.eArg.exprType != 6;
        if (this.exprType == 40) {
            this.dataType = distinct ? this.dataType : 4;
        }
    }

    void swapCondition() throws HsqlException {
        int i = 21;
        switch (this.exprType) {
            case 22: {
                i = 25;
                break;
            }
            case 25: {
                i = 22;
                break;
            }
            case 24: {
                i = 23;
                break;
            }
            case 23: {
                i = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.doAssert(false, "Expression.swapCondition");
            }
        }
        this.exprType = i;
        Expression e = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = e;
    }

    int getDataType() {
        return this.dataType;
    }

    Object getValue(int type) throws HsqlException {
        Object o = this.getValue();
        if (o == null || this.dataType == type) {
            return o;
        }
        return Column.convertObject(o, type);
    }

    Object getAggregatedValue(Object currValue) throws HsqlException {
        if (!this.isAggregate()) {
            return currValue;
        }
        switch (this.exprType) {
            case 40: {
                if (currValue == null) {
                    return INTEGER_0;
                }
                return ((SetFunction)currValue).getValue();
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (currValue == null) {
                    return null;
                }
                return ((SetFunction)currValue).getValue();
            }
            case 10: {
                return Column.negate(this.eArg.getAggregatedValue(currValue), this.dataType);
            }
            case 61: {
                return Column.convertObject(this.eArg.getAggregatedValue(currValue), this.dataType);
            }
        }
        Object leftValue = null;
        Object rightValue = null;
        switch (this.aggregateSpec) {
            case 1: {
                leftValue = this.eArg.getAggregatedValue(currValue);
                rightValue = this.eArg2 == null ? null : this.eArg2.getValue();
                break;
            }
            case 2: {
                leftValue = this.eArg == null ? null : this.eArg.getValue();
                rightValue = this.eArg2.getAggregatedValue(currValue);
                break;
            }
            case 3: {
                if (currValue == null) {
                    currValue = new Object[2];
                }
                leftValue = this.eArg.getAggregatedValue(currValue[0]);
                rightValue = this.eArg2.getAggregatedValue(currValue[1]);
            }
        }
        switch (this.exprType) {
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                Trace.doAssert(this.eArg2 == null, "Expression.getAggregatedValue.NOT");
                return (Boolean)leftValue != false ? Boolean.FALSE : Boolean.TRUE;
            }
            case 28: {
                return (Boolean)leftValue != false && (Boolean)rightValue != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                return (Boolean)leftValue != false || (Boolean)rightValue != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String c;
                String s = (String)Column.convertObject(rightValue, 12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(s);
                }
                return this.likeObject.compare(c = (String)Column.convertObject(leftValue, 12)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 30: {
                return this.eArg2.testValueList(leftValue) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 31: {
                if (this.eArg.isCorrelated) {
                    Result r = this.eArg.subSelect.getResult(1);
                    return r.rRoot == null ? Boolean.FALSE : Boolean.TRUE;
                }
                return Boolean.TRUE;
            }
            case 62: {
                Object result;
                leftValue = leftValue instanceof SetFunction ? Column.convertObject(((SetFunction)leftValue).getValue(), 16) : Column.convertObject(leftValue, 16);
                boolean test = (Boolean)leftValue;
                Object object = result = test ? ((Object[])rightValue)[0] : ((Object[])rightValue)[1];
                if (result instanceof SetFunction) {
                    return Column.convertObject(((SetFunction)result).getValue(), this.dataType);
                }
                return Column.convertObject(result, this.dataType);
            }
            case 70: {
                leftValue = leftValue instanceof SetFunction ? Column.convertObject(((SetFunction)leftValue).getValue(), this.dataType) : Column.convertObject(leftValue, this.dataType);
                rightValue = rightValue instanceof SetFunction ? Column.convertObject(((SetFunction)rightValue).getValue(), this.dataType) : Column.convertObject(rightValue, this.dataType);
                Object[] objectPair = new Object[]{leftValue, rightValue};
                return objectPair;
            }
            case 7: {
                return this.function.getAggregatedValue(currValue);
            }
        }
        if (Expression.isCompare(this.exprType)) {
            int valueType = this.eArg.isColumn() ? this.eArg.dataType : this.eArg2.dataType;
            return Expression.compareValues(leftValue, rightValue, valueType, this.exprType) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (leftValue != null) {
            leftValue = Column.convertObject(leftValue, this.dataType);
        }
        if (rightValue != null) {
            rightValue = Column.convertObject(rightValue, this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(leftValue, rightValue, this.dataType);
            }
            case 12: {
                return Column.subtract(leftValue, rightValue, this.dataType);
            }
            case 13: {
                return Column.multiply(leftValue, rightValue, this.dataType);
            }
            case 14: {
                return Column.divide(leftValue, rightValue, this.dataType);
            }
            case 15: {
                return Column.concat(leftValue, rightValue);
            }
        }
        throw Trace.error(14, this.toString());
    }

    Object updateAggregatingValue(Object currValue) throws HsqlException {
        if (!this.isAggregate()) {
            return this.getValue();
        }
        switch (this.aggregateSpec) {
            case -1: {
                if (currValue == null) {
                    currValue = new SetFunction(this.exprType, this.eArg.dataType, this.isDistinctAggregate);
                }
                Integer newValue = this.eArg.exprType == 6 ? INTEGER_1 : this.eArg.getValue();
                ((SetFunction)currValue).add(newValue);
                return currValue;
            }
            case 3: {
                Object[] valuePair = (Object[])currValue;
                if (valuePair == null) {
                    valuePair = new Object[]{this.eArg.updateAggregatingValue(valuePair[0]), this.eArg2.updateAggregatingValue(valuePair[1])};
                }
                return valuePair;
            }
            case 1: {
                return this.eArg.updateAggregatingValue(currValue);
            }
            case 2: {
                return this.eArg2.updateAggregatingValue(currValue);
            }
            case 4: {
                return this.function.updateAggregatingValue(currValue);
            }
        }
        return currValue;
    }

    int getNumValues() throws HsqlException {
        return this.valueData.size();
    }

    Object getValue() throws HsqlException {
        return this.getValueAt(0);
    }

    Object getValueAt(int i) throws HsqlException {
        switch (this.exprType) {
            case 1: {
                if (this.valueData == null || i >= this.getNumValues()) {
                    return null;
                }
                return this.valueData.get(i);
            }
            case 7: {
                return this.function.getValue();
            }
            case 3: {
                return this.subSelect.getValue(this.dataType);
            }
            case 10: {
                return Column.negate(this.eArg.getValue(this.dataType), this.dataType);
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.test() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 61: {
                return this.eArg.getValue(this.dataType);
            }
            case 62: {
                if (this.eArg.test()) {
                    return this.eArg2.eArg.getValue(this.dataType);
                }
                return this.eArg2.eArg2.getValue(this.dataType);
            }
            case 70: {
                return new Object[]{this.eArg.getValue(this.dataType), this.eArg2.getValue(this.dataType)};
            }
        }
        Object a = null;
        Object b = null;
        if (this.eArg != null) {
            a = this.eArg.getValue(this.dataType);
        }
        if (this.eArg2 != null) {
            b = this.eArg2.getValue(this.dataType);
        }
        switch (this.exprType) {
            case 11: {
                return Column.add(a, b, this.dataType);
            }
            case 12: {
                return Column.subtract(a, b, this.dataType);
            }
            case 13: {
                return Column.multiply(a, b, this.dataType);
            }
            case 14: {
                return Column.divide(a, b, this.dataType);
            }
            case 15: {
                return Column.concat(a, b);
            }
            case 71: {
                if (this.valueData == null || i >= this.getNumValues()) {
                    return null;
                }
                return ((NumberSequence)this.valueData.get(i)).getValueObject();
            }
        }
        return this.test() ? Boolean.TRUE : Boolean.FALSE;
    }

    boolean test() throws HsqlException {
        switch (this.exprType) {
            case 4: {
                return true;
            }
            case -4: {
                return false;
            }
            case 20: {
                Trace.doAssert(this.eArg2 == null, "Expression.test");
                return !this.eArg.test();
            }
            case 28: {
                return this.eArg.test() && this.eArg2.test();
            }
            case 29: {
                return this.eArg.test() || this.eArg2.test();
            }
            case 27: {
                String s = (String)this.eArg2.getValue(12);
                if (this.eArg2.isParam || this.eArg2.exprType != 1) {
                    this.likeObject.resetPattern(s);
                }
                String c = (String)this.eArg.getValue(12);
                return this.likeObject.compare(c);
            }
            case 30: {
                return this.eArg2.testValueList(this.eArg.getValue());
            }
            case 31: {
                Result r = this.eArg.subSelect.getResult(1);
                return r.rRoot != null;
            }
            case 7: {
                Object value = Column.convertObject(this.function.getValue(), 16);
                if (value == null || !(value instanceof Boolean)) break;
                return (Boolean)value;
            }
        }
        if (this.eArg == null || this.eArg2 == null) {
            throw Trace.error(106);
        }
        int type = this.eArg.dataType;
        Object o = this.eArg.getValue(type);
        Object o2 = this.eArg2.getValue(type);
        if (o == null || o2 == null) {
            if (this.eArg.tableFilter != null && this.eArg2.tableFilter != null && !this.eArg.tableFilter.isOuterJoin) {
                return false;
            }
            if (this.eArg.tableFilter != null && this.eArg.tableFilter.isOuterJoin) {
                if (this.isInJoin) {
                    if (this.eArg.tableFilter.isCurrentOuter || o == null) {
                        return true;
                    }
                } else {
                    this.eArg.tableFilter.nonJoinIsNull = o2 == null;
                }
            }
            return this.testNull(o, o2, this.exprType);
        }
        return Expression.compareValues(o, o2, type, this.exprType);
    }

    private static boolean compareValues(Object o, Object o2, int valueType, int exprType) throws HsqlException {
        int result = Column.compare(o, o2, valueType);
        switch (exprType) {
            case 21: {
                return result == 0;
            }
            case 23: {
                return result > 0;
            }
            case 22: {
                return result >= 0;
            }
            case 25: {
                return result <= 0;
            }
            case 24: {
                return result < 0;
            }
            case 26: {
                return result != 0;
            }
        }
        throw Trace.error(40, 167);
    }

    boolean testNull(Object a, Object b, int logicalOperation) throws HsqlException {
        switch (logicalOperation) {
            case 26: {
                return a != null || b != null;
            }
            case 21: 
            case 22: 
            case 25: {
                return a == null && b == null;
            }
        }
        return false;
    }

    private boolean testValueList(Object o) throws HsqlException {
        if (o == null) {
            return false;
        }
        if (this.exprType == 5) {
            try {
                o = Column.convertObject(o, this.dataType);
            }
            catch (HsqlException e) {
                return false;
            }
            if (this.isFixedConstantValueList) {
                return this.hList.contains(o);
            }
            int len = this.valueList.length;
            for (int i = 0; i < len; ++i) {
                Object o2 = this.valueList[i].getValue(this.dataType);
                if (Column.compare(o, o2, this.dataType) != 0) continue;
                return true;
            }
            return false;
        }
        if (this.exprType == 3) {
            Result r = this.subSelect.getResult(0);
            r.removeDuplicates();
            Record n = r.rRoot;
            int type = r.metaData.colType[0];
            try {
                o = Column.convertObject(o, type);
            }
            catch (HsqlException e) {
                return false;
            }
            while (n != null) {
                Object o2 = n.data[0];
                if (o2 != null && Column.compare(o2, o, type) == 0) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }
        throw Trace.error(16);
    }

    boolean setForJoin(TableFilter tf, boolean outer) {
        this.isInJoin = outer;
        if (outer) {
            this.outerFilter = tf;
        }
        if (this.eArg != null && !this.eArg.setForJoin(tf, outer)) {
            return false;
        }
        if (this.eArg2 != null && !this.eArg2.setForJoin(tf, outer)) {
            return false;
        }
        return !outer || this.exprType == 28 || this.exprType == 29 || this.exprType == 2 || this.exprType == 1 || this.exprType == 21 || this.exprType == 26 || this.exprType == 23 || this.exprType == 22 || this.exprType == 24 || this.exprType == 25;
    }

    static Select getCheckSelect(Expression e) throws HsqlException {
        Expression condition;
        Select s = new Select();
        s.exprColumns = new Expression[1];
        s.exprColumns[0] = new Expression(1, Boolean.TRUE);
        s.tFilter = new TableFilter[1];
        s.tFilter[0] = new TableFilter(null, false);
        s.queryCondition = condition = new Expression(20, e, null);
        s.resolveAll(true);
        return s;
    }

    void setLeftExpression(Expression e) {
        this.eArg = e;
    }

    void setRightExpression(Expression e) {
        this.eArg2 = e;
    }

    Expression getRightExpression() {
        return this.eArg2;
    }

    void bind(Object o) throws HsqlException {
        if (this.valueData.size() == 1) {
            this.valueData.set(0, o);
        } else {
            this.valueData.add(o);
        }
    }

    boolean isParam() {
        return this.isParam;
    }

    boolean isFixedConstant() {
        switch (this.exprType) {
            case 1: {
                return !this.isParam;
            }
            case 10: {
                return this.eArg.isFixedConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
        }
        return false;
    }

    boolean isFixedConditional() {
        switch (this.exprType) {
            case -4: 
            case 4: {
                return true;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
            case 20: {
                return this.eArg.isFixedConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isFixedConditional() && this.eArg2.isFixedConditional();
            }
        }
        return false;
    }

    void setTableColumnAttributes(Expression e) {
        this.columnSize = e.columnSize;
        this.columnScale = e.columnScale;
        this.isIdentity = e.isIdentity;
        this.nullability = e.nullability;
        this.isWritable = e.isWritable;
        this.catalog = e.catalog;
        this.schema = e.schema;
    }

    void setTableColumnAttributes(int i) {
        this.dataType = 1;
        this.columnSize = 1;
        this.columnScale = 1;
        this.isIdentity = false;
        this.nullability = 1;
        this.isWritable = true;
    }

    String getValueClassName() {
        int ditypesub;
        int ditype;
        if (this.valueClassName != null) {
            return this.valueClassName;
        }
        if (this.function != null) {
            this.valueClassName = this.function.getReturnClass().getName();
            return this.valueClassName;
        }
        if (this.dataType == 100) {
            ditype = 12;
            ditypesub = 4;
        } else {
            ditype = this.dataType;
            ditypesub = 1;
        }
        DITypeInfo ti = new DITypeInfo();
        ti.setTypeCode(ditype);
        ti.setTypeSub(ditypesub);
        this.valueClassName = ti.getColStClsName();
        return this.valueClassName;
    }

    static {
        SQL_EXTRACT_FIELD_NAMES.addAll(new Object[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE"});
        SQL_TRIM_SPECIFICATION.addAll(new Object[]{"LEADING", "TRAILING", "BOTH"});
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
    }

    static class Collector
    extends HashSet {
        Collector() {
        }

        void addAll(Expression e, int type) {
            int i;
            Expression[] list;
            if (e == null) {
                return;
            }
            this.addAll(e.getArg(), type);
            this.addAll(e.getArg2(), type);
            if (e.exprType == type) {
                this.add(e);
            }
            this.addAll(e.subSelect, type);
            Function function = e.function;
            if (function != null && (list = function.eArg) != null) {
                for (i = 0; i < list.length; ++i) {
                    this.addAll(list[i], type);
                }
            }
            if ((list = e.valueList) != null) {
                for (i = 0; i < list.length; ++i) {
                    this.addAll(list[i], type);
                }
            }
        }

        void addAll(Select select, int type) {
            while (select != null) {
                Expression[] list = select.exprColumns;
                for (int i = 0; i < list.length; ++i) {
                    this.addAll(list[i], type);
                }
                this.addAll(select.queryCondition, type);
                this.addAll(select.havingCondition, type);
                select = select.sUnion;
            }
        }
    }
}

