/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.lib.StringUtil;

class Like {
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    Character escapeChar;
    boolean optimised;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;

    Like(Character escape) {
        this.escapeChar = escape;
    }

    void setParams(String s, boolean ignorecase) {
        this.isIgnoreCase = ignorecase;
        this.normalize(s, true);
        this.optimised = true;
    }

    void resetPattern(String s) {
        this.normalize(s, true);
    }

    private String getStartsWith() {
        int i;
        if (this.iLen == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (i = 0; i < this.iLen && this.wildCardType[i] == 0; ++i) {
            s.append(this.cLike[i]);
        }
        if (i == 0) {
            return null;
        }
        return s.toString();
    }

    boolean compare(Object o) {
        if (o == null) {
            return this.iLen == 0;
        }
        String s = o.toString();
        if (this.isIgnoreCase) {
            s = s.toUpperCase();
        }
        return this.compareAt(s, 0, 0, s.length());
    }

    private boolean compareAt(String s, int i, int j, int jLen) {
        while (i < this.iLen) {
            switch (this.wildCardType[i]) {
                case 0: {
                    if (j < jLen && this.cLike[i] == s.charAt(j++)) break;
                    return false;
                }
                case 1: {
                    if (j++ < jLen) break;
                    return false;
                }
                case 2: {
                    if (++i >= this.iLen) {
                        return true;
                    }
                    while (j < jLen) {
                        if (this.cLike[i] == s.charAt(j) && this.compareAt(s, i, j, jLen)) {
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
            }
            ++i;
        }
        return j == jLen;
    }

    private void normalize(String pattern, boolean b) {
        int i;
        boolean bl = this.isNull = pattern == null;
        if (!this.isNull && this.isIgnoreCase) {
            pattern = pattern.toUpperCase();
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int l = pattern == null ? 0 : pattern.length();
        this.cLike = new char[l];
        this.wildCardType = new int[l];
        boolean bEscaping = false;
        boolean bPercent = false;
        for (i = 0; i < l; ++i) {
            char c = pattern.charAt(i);
            if (!bEscaping) {
                if (b && this.escapeChar != null && this.escapeChar.charValue() == c) {
                    bEscaping = true;
                    continue;
                }
                if (c == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c == '%') {
                    if (bPercent) continue;
                    bPercent = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bPercent = false;
                }
            } else {
                bPercent = false;
                bEscaping = false;
            }
            this.cLike[this.iLen++] = c;
        }
        for (i = 0; i < this.iLen - 1; ++i) {
            if (this.wildCardType[i] != 2 || this.wildCardType[i + 1] != 1) continue;
            this.wildCardType[i] = 1;
            this.wildCardType[i + 1] = 2;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        for (int i = 0; i < this.wildCardType.length; ++i) {
            if (this.wildCardType[i] == 2) continue;
            return false;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }

    String getRangeLow() {
        return this.getStartsWith();
    }

    String getRangeHigh() {
        String s = this.getStartsWith();
        return s == null ? null : s.concat("\uffff");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        sb.append("escapeChar=").append(this.escapeChar).append('\n');
        sb.append("isNull=").append(this.isNull).append('\n');
        sb.append("optimised=").append(this.optimised).append('\n');
        sb.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        sb.append("iLen=").append(this.iLen).append('\n');
        sb.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        sb.append("cLike=");
        sb.append(StringUtil.arrayToString(this.cLike));
        sb.append('\n');
        sb.append("wildCardType=");
        sb.append(StringUtil.arrayToString(this.wildCardType));
        sb.append(']');
        return sb.toString();
    }
}

