/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.Expression;
import com.insightful.miner.sql.HsqlException;

class TableFilter {
    private String tableAlias;
    boolean isOuterJoin;
    boolean isCrossJoin;
    boolean isLeftSpecified;
    boolean isFullSpecified;
    static final int CONDITION_NONE = -1;
    static final int CONDITION_UNORDERED = 0;
    static final int CONDITION_START_END = 1;
    static final int CONDITION_START = 2;
    static final int CONDITION_END = 3;
    static final int CONDITION_OUTER = 4;
    boolean isAssigned;
    boolean isMultiFindFirst;
    Expression[] findFirstExpressions;
    Expression eAnd;
    Expression eStart;
    Expression eEnd;
    private Object[] emptyData;
    boolean nonJoinIsNull;
    boolean isCurrentOuter;

    TableFilter(String alias, boolean outerjoin) {
        this.tableAlias = alias;
        this.isOuterJoin = outerjoin;
    }

    String getName() {
        return this.tableAlias;
    }

    void setLeftFull(boolean isLeft, boolean isFull) {
        this.isLeftSpecified = isLeft;
        this.isFullSpecified = isFull;
    }

    static final int toConditionType(int exprType) {
        switch (exprType) {
            case 26: 
            case 27: 
            case 30: {
                return 0;
            }
            case 21: {
                return 1;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 24: 
            case 25: {
                return 3;
            }
        }
        return -1;
    }

    void setConditions(Expression condition) throws HsqlException {
        this.setCondition(condition);
    }

    private void setCondition(Expression e) throws HsqlException {
        int type = e.getType();
        Expression e1 = e.getArg();
        Expression e2 = e.getArg2();
        this.isAssigned = true;
        if (type == 28) {
            this.setCondition(e1);
            this.setCondition(e2);
            return;
        }
        int conditionType = TableFilter.toConditionType(type);
        if (conditionType == -1) {
            return;
        }
        if (e1.getFilter() == this && e2.getFilter() == this) {
            conditionType = 0;
        } else if (e1.getFilter() != this) {
            if (e2.getFilter() == this && conditionType != 0) {
                e.swapCondition();
                this.setCondition(e);
                return;
            }
            if (e1.outerFilter == this) {
                conditionType = 4;
            } else {
                return;
            }
        }
        if (!e2.isResolved()) {
            return;
        }
        if (e1.outerFilter != null && e1.outerFilter != this) {
            return;
        }
        if (conditionType == 0) {
            if (!this.isOuterJoin) {
                this.addAndCondition(e);
            }
            return;
        }
        if (conditionType == 4) {
            this.addAndCondition(e);
            e.setTrue();
            return;
        }
        int i = e1.getColumnNr();
        this.addAndCondition(e);
    }

    boolean findFirst() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = false;
        return false;
    }

    boolean next() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = false;
        return false;
    }

    boolean nextOuter() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = true;
        return this.eAnd == null || this.eAnd.getFilter() != this && this.eAnd.isInJoin || this.eAnd.test();
    }

    private void addAndCondition(Expression e) {
        Expression and;
        Expression e2 = new Expression(e);
        this.eAnd = this.eAnd == null ? e2 : (and = new Expression(28, this.eAnd, e2));
        e.setTrue();
    }

    void setAsCheckFilter() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean hidden = false;
        boolean fullScan = this.eStart == null && this.eEnd == null;
        sb.append(super.toString()).append('\n');
        sb.append("table=[").append(this.getName()).append("]\n");
        sb.append("alias=[").append(this.tableAlias).append("]\n");
        sb.append("access=[").append(fullScan ? "FULL SCAN" : "INDEX PRED").append("]\n");
        sb.append("isOuterJoin=[").append(this.isOuterJoin).append("]\n");
        sb.append("eStart=[").append(this.eStart).append("]\n");
        sb.append("eEnd=[").append(this.eEnd).append("]\n");
        sb.append("eAnd=[").append(this.eAnd).append("]");
        return sb.toString();
    }
}

