/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.batik.ext.awt.image.codec.FileCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.MemoryCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.SeekableStream;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public abstract class BatikImage
extends AbstractFopImage {
    private byte[] softMask = null;

    public BatikImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
    }

    protected boolean loadDimensions() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    protected boolean loadBitmap() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    public boolean hasSoftMask() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.softMask != null;
    }

    public byte[] getSoftMask() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.softMask;
    }

    protected abstract CachableRed decodeImage(SeekableStream var1) throws IOException;

    protected void loadImage() {
        try {
            FileCacheSeekableStream seekableInput;
            try {
                seekableInput = new FileCacheSeekableStream(this.inputStream);
            }
            catch (IOException ioe) {
                seekableInput = new MemoryCacheSeekableStream(this.inputStream);
            }
            CachableRed cr = this.decodeImage((SeekableStream)seekableInput);
            ColorModel cm = cr.getColorModel();
            this.height = cr.getHeight();
            this.width = cr.getWidth();
            this.isTransparent = false;
            this.softMask = null;
            this.bitmapsSize = this.width * this.height * 3;
            this.bitmaps = new byte[this.bitmapsSize];
            this.bitsPerPixel = 8;
            int transparencyType = cm.getTransparency();
            if (cm instanceof IndexColorModel) {
                if (transparencyType == 2) {
                    IndexColorModel icm = (IndexColorModel)cm;
                    int numColor = icm.getMapSize();
                    byte[] alpha = new byte[numColor];
                    icm.getAlphas(alpha);
                    for (int i = 0; i < numColor; ++i) {
                        if ((alpha[i] & 0xFF) != 0) continue;
                        this.isTransparent = true;
                        int red = icm.getRed(i) & 0xFF;
                        int grn = icm.getGreen(i) & 0xFF;
                        int blu = icm.getBlue(i) & 0xFF;
                        this.transparentColor = new Color(red, grn, blu);
                        break;
                    }
                }
            } else {
                cr = new Any2sRGBRed(cr);
            }
            cm = cr.getColorModel();
            if (!this.isTransparent && cm.hasAlpha()) {
                this.softMask = new byte[this.width * this.height];
            }
            this.colorSpace = cm.getColorSpace();
            WritableRaster wr = (WritableRaster)cr.getData();
            BufferedImage bi = new BufferedImage(cm, wr.createWritableTranslatedChild(0, 0), cm.isAlphaPremultiplied(), null);
            int[] tmpMap = new int[this.width];
            int idx = 0;
            int sfIdx = 0;
            for (int y = 0; y < this.height; ++y) {
                int pix;
                int x;
                tmpMap = bi.getRGB(0, y, this.width, 1, tmpMap, 0, this.width);
                if (this.softMask != null) {
                    for (x = 0; x < this.width; ++x) {
                        pix = tmpMap[x];
                        this.softMask[sfIdx++] = (byte)(pix >>> 24);
                        this.bitmaps[idx++] = (byte)(pix >>> 16 & 0xFF);
                        this.bitmaps[idx++] = (byte)(pix >>> 8 & 0xFF);
                        this.bitmaps[idx++] = (byte)(pix & 0xFF);
                    }
                    continue;
                }
                for (x = 0; x < this.width; ++x) {
                    pix = tmpMap[x];
                    this.bitmaps[idx++] = (byte)(pix >> 16 & 0xFF);
                    this.bitmaps[idx++] = (byte)(pix >> 8 & 0xFF);
                    this.bitmaps[idx++] = (byte)(pix & 0xFF);
                }
            }
        }
        catch (Exception ex) {
            log.error("Error loading an image", ex);
        }
    }
}

