/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class BlockContainerLayoutManager
extends BlockStackingLayoutManager {
    private BlockViewport viewportBlockArea;
    private Block referenceArea;
    private CommonAbsolutePosition abProps;
    private FODimension relDims;
    private CTM absoluteCTM;
    private boolean clip = false;
    private Length width;
    private Length height;
    private int vpContentIPD;
    private int vpContentBPD;
    private boolean autoHeight = true;
    private MinOptMax foBlockSpaceBefore;
    private MinOptMax foBlockSpaceAfter;

    public BlockContainerLayoutManager(BlockContainer node) {
        super(node);
        this.initialize();
    }

    private void initialize() {
        boolean rotated;
        this.abProps = this.getBlockContainerFO().getCommonAbsolutePosition();
        this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore).getSpace();
        this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter).getSpace();
        boolean bl = rotated = this.getBlockContainerFO().getReferenceOrientation() % 180 != 0;
        if (rotated) {
            this.height = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum().getLength();
            this.width = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum().getLength();
        } else {
            this.height = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum().getLength();
            this.width = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum().getLength();
        }
        this.bpUnit = 0;
        if (this.bpUnit == 0) {
            this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum().getLength().getValue();
            this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum().getLength().getValue();
        } else {
            this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getMinimum().getLength().getValue();
            this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getMinimum().getLength().getValue();
        }
    }

    protected int getRotatedIPD() {
        return this.getBlockContainerFO().getInlineProgressionDimension().getOptimum().getLength().getValue();
    }

    private int getSpaceBefore() {
        return this.foBlockSpaceBefore.opt;
    }

    private int getBPIndents() {
        int indents = 0;
        indents += this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getOptimum().getLength().getValue();
        indents += this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getOptimum().getLength().getValue();
        return indents += this.getBlockContainerFO().getCommonBorderPaddingBackground().getBPPaddingAndBorder(false);
    }

    private int getIPIndents() {
        int iIndents = 0;
        iIndents += this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue();
        return iIndents += this.getBlockContainerFO().getCommonMarginBlock().endIndent.getValue();
    }

    private boolean isAbsoluteOrFixed() {
        return this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51;
    }

    private boolean isFixed() {
        return this.abProps.absolutePosition == 51;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        int allocIPD;
        int allocBPD;
        if (this.isAbsoluteOrFixed()) {
            return this.getNextKnuthElementsAbsolute(context, alignment);
        }
        this.autoHeight = false;
        this.referenceIPD = context.getRefIPD();
        int maxbpd = context.getStackLimit().opt;
        if (this.height.getEnum() != 9) {
            allocBPD = this.height.getValue();
            allocBPD += this.getBPIndents();
        } else {
            allocBPD = maxbpd;
            this.autoHeight = true;
        }
        if (this.width.getEnum() != 9) {
            allocIPD = this.width.getValue();
            allocIPD += this.getIPIndents();
        } else {
            allocIPD = this.referenceIPD;
        }
        this.vpContentBPD = allocBPD - this.getBPIndents();
        this.vpContentIPD = allocIPD - this.getIPIndents();
        double contentRectOffsetX = 0.0;
        double contentRectOffsetY = 0.0;
        contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        Rectangle2D.Double rect = new Rectangle2D.Double(contentRectOffsetX += (double)this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(), contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getPaddingBefore(false), this.vpContentIPD, this.vpContentBPD);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims(this.getBlockContainerFO().getReferenceOrientation(), this.getBlockContainerFO().getWritingMode(), rect, this.relDims);
        MinOptMax stackLimit = new MinOptMax(this.relDims.bpd);
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        if (!this.bBreakBeforeServed) {
            try {
                if (this.addKnuthElementsForBreakBefore(returnList)) {
                    LinkedList<KnuthBox> linkedList = returnList;
                    return linkedList;
                }
            }
            finally {
                this.bBreakBeforeServed = true;
            }
        }
        if (!this.bSpaceBeforeServed) {
            this.addKnuthElementsForSpaceBefore(returnList, alignment);
            this.bSpaceBeforeServed = true;
        }
        this.addKnuthElementsForBorderPaddingBefore(returnList);
        if (this.autoHeight) {
            BlockLevelLayoutManager curLM;
            BlockLevelLayoutManager prevLM = null;
            while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
                LayoutContext childLC = new LayoutContext(0);
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackLimit));
                childLC.setRefIPD(this.relDims.ipd);
                returnedList = curLM.getNextKnuthElements(childLC, alignment);
                if (returnedList.size() == 1 && ((KnuthElement)returnedList.getFirst()).isPenalty() && ((KnuthPenalty)returnedList.getFirst()).getP() == -1000) {
                    if (returnList.size() == 0) {
                        this.bSpaceBeforeServed = false;
                    }
                    contentList.addAll(returnedList);
                    returnedList = new LinkedList();
                    this.wrapPositionElements(contentList, returnList);
                    return returnList;
                }
                if (prevLM != null) {
                    if (this.mustKeepTogether() || prevLM.mustKeepWithNext() || curLM.mustKeepWithPrevious()) {
                        contentList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                    } else if (!((KnuthElement)contentList.getLast()).isGlue()) {
                        contentList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                    }
                }
                contentList.addAll(returnedList);
                if (returnedList.size() == 0) continue;
                if (((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
                    if (curLM.isFinished()) {
                        this.setFinished(true);
                    }
                    returnedList = new LinkedList();
                    this.wrapPositionElements(contentList, returnList);
                    return returnList;
                }
                prevLM = curLM;
            }
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
        } else {
            MinOptMax range = new MinOptMax(this.relDims.ipd);
            BlockContainerBreaker breaker = new BlockContainerBreaker(this, range);
            breaker.doLayout(this.relDims.bpd);
            boolean contentOverflows = false;
            if (!breaker.isEmpty()) {
                contentOverflows = breaker.deferredAlg.getPageBreaks().size() > 1;
            }
            BlockContainerPosition bcPosition = new BlockContainerPosition(this, breaker);
            returnList.add(new KnuthBox(this.vpContentBPD, this.notifyPos(bcPosition), false));
            if (contentOverflows) {
                log.warn("Contents overflow block-container viewport: clipping");
                if (this.getBlockContainerFO().getOverflow() == 57) {
                    this.clip = true;
                } else if (this.getBlockContainerFO().getOverflow() == 42) {
                    this.clip = true;
                }
            }
        }
        this.addKnuthElementsForBorderPaddingAfter(returnList);
        this.addKnuthElementsForSpaceAfter(returnList, alignment);
        this.addKnuthElementsForBreakAfter(returnList);
        this.setFinished(true);
        return returnList;
    }

    private LinkedList getNextKnuthElementsAbsolute(LayoutContext context, int alignment) {
        int allocIPD;
        int allocBPD;
        this.autoHeight = false;
        Point offset = this.getAbsOffset();
        if (this.height.getEnum() != 9) {
            allocBPD = this.height.getValue();
            allocBPD += this.getBPIndents();
        } else {
            allocBPD = 0;
            if (this.abProps.bottom.getEnum() != 9) {
                allocBPD = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getHeight() : context.getStackLimit().opt;
                allocBPD -= offset.y;
                if (this.abProps.bottom.getEnum() != 9) {
                    allocBPD -= this.abProps.bottom.getValue();
                }
            } else {
                this.autoHeight = true;
            }
        }
        if (this.width.getEnum() != 9) {
            allocIPD = this.width.getValue();
            allocIPD += this.getIPIndents();
        } else {
            allocIPD = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getWidth() : context.getRefIPD();
            if (this.abProps.left.getEnum() != 9) {
                allocIPD -= this.abProps.left.getValue();
            }
            if (this.abProps.right.getEnum() != 9) {
                allocIPD -= this.abProps.right.getValue();
            }
        }
        this.vpContentBPD = allocBPD - this.getBPIndents();
        this.vpContentIPD = allocIPD - this.getIPIndents();
        double contentRectOffsetX = offset.getX();
        double contentRectOffsetY = offset.getY();
        contentRectOffsetY += (double)this.getSpaceBefore();
        contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        Rectangle2D.Double rect = new Rectangle2D.Double(contentRectOffsetX += (double)this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(), contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getPaddingBefore(false), this.vpContentIPD, this.vpContentBPD);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims(this.getBlockContainerFO().getReferenceOrientation(), this.getBlockContainerFO().getWritingMode(), rect, this.relDims);
        MinOptMax range = new MinOptMax(this.relDims.ipd);
        BlockContainerBreaker breaker = new BlockContainerBreaker(this, range);
        breaker.doLayout(this.relDims.bpd);
        boolean contentOverflows = breaker.isOverflow();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        if (!breaker.isEmpty()) {
            BlockContainerPosition bcPosition = new BlockContainerPosition(this, breaker);
            returnList.add(new KnuthBox(0, this.notifyPos(bcPosition), false));
            if (!this.autoHeight & contentOverflows) {
                log.warn("Contents overflow block-container viewport: clipping");
                if (this.getBlockContainerFO().getOverflow() == 57) {
                    this.clip = true;
                } else if (this.getBlockContainerFO().getOverflow() == 42) {
                    this.clip = true;
                }
            }
        }
        this.setFinished(true);
        return returnList;
    }

    private Point getAbsOffset() {
        int x = 0;
        int y = 0;
        if (this.abProps.left.getEnum() != 9) {
            x = this.abProps.left.getValue();
        }
        if (this.abProps.top.getEnum() != 9) {
            y = this.abProps.top.getValue();
        }
        return new Point(x, y);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, new MinOptMax(layoutContext.getSpaceBefore()));
        }
        LayoutManager childLM = null;
        LayoutManager lastLM = null;
        LayoutContext lc = new LayoutContext(0);
        if (layoutContext.getSpaceAfter() > 0) {
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        BlockContainerPosition bcpos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        boolean bSpaceBefore = false;
        boolean bSpaceAfter = false;
        Position firstPos = null;
        Position lastPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            Position innerPosition = null;
            if (pos instanceof NonLeafPosition) {
                innerPosition = ((NonLeafPosition)pos).getPosition();
            }
            if (pos instanceof BlockContainerPosition) {
                if (bcpos != null) {
                    throw new IllegalStateException("Only one BlockContainerPosition allowed");
                }
                bcpos = (BlockContainerPosition)pos;
                continue;
            }
            if (innerPosition == null) {
                if (!(pos instanceof NonLeafPosition)) continue;
                if (positionList.size() == 0 && bcpos == null) {
                    bSpaceBefore = true;
                    continue;
                }
                bSpaceAfter = true;
                continue;
            }
            if (innerPosition.getLM() == this && !(innerPosition instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            positionList.add(innerPosition);
            lastLM = innerPosition.getLM();
        }
        this.getPSLM().addIDToPage(this.getBlockContainerFO().getId());
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, true, this.isFirst(firstPos), this.isLast(lastPos));
        }
        if (bcpos == null) {
            PositionIterator childPosIter;
            if (this.bpUnit == 0) {
                childPosIter = new BlockStackingLayoutManager.StackingIter(positionList.listIterator());
            } else {
                LinkedList<KnuthElement> splitList = new LinkedList<KnuthElement>();
                int splitLength = 0;
                int iFirst = ((BlockStackingLayoutManager.MappingPosition)positionList.getFirst()).getFirstIndex();
                int iLast = ((BlockStackingLayoutManager.MappingPosition)positionList.getLast()).getLastIndex();
                ListIterator storedListIterator = this.storedList.listIterator(iFirst);
                while (storedListIterator.nextIndex() <= iLast) {
                    KnuthElement element = (KnuthElement)storedListIterator.next();
                    if (element.getLayoutManager() == this) continue;
                    splitList.add(element);
                    splitLength += element.getW();
                    lastLM = element.getLayoutManager();
                }
                if (bSpaceBefore && bSpaceAfter) {
                    this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore).getSpace();
                    this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter).getSpace();
                    this.adjustedSpaceBefore = (this.neededUnits(splitLength + this.foBlockSpaceBefore.min + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength) / 2;
                    this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foBlockSpaceBefore.min + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength - this.adjustedSpaceBefore;
                } else if (bSpaceBefore) {
                    this.adjustedSpaceBefore = this.neededUnits(splitLength + this.foBlockSpaceBefore.min) * this.bpUnit - splitLength;
                } else {
                    this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength;
                }
                childPosIter = new KnuthPossPosIter(splitList, 0, splitList.size());
            }
            if (bSpaceBefore) {
                this.addBlockSpacing(0.0, new MinOptMax(this.adjustedSpaceBefore));
            }
            while ((childLM = childPosIter.getNextChildLM()) != null) {
                lc.setFlags(128, layoutContext.isLastArea() && childLM == lastLM);
                lc.setStackLimit(layoutContext.getStackLimit());
                childLM.addAreas(childPosIter, lc);
            }
        } else {
            if (bSpaceBefore) {
                this.addBlockSpacing(0.0, new MinOptMax(this.adjustedSpaceBefore));
            }
            bcpos.getBreaker().addContainedAreas();
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, false, this.isFirst(firstPos), this.isLast(lastPos));
        }
        this.flush();
        if (bSpaceAfter) {
            this.addBlockSpacing(0.0, new MinOptMax(this.adjustedSpaceAfter));
        }
        this.viewportBlockArea = null;
        this.referenceArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.referenceArea == null) {
            this.viewportBlockArea = new BlockViewport();
            this.viewportBlockArea.addTrait(Trait.IS_VIEWPORT_AREA, Boolean.TRUE);
            this.viewportBlockArea.setIPD(this.vpContentIPD);
            if (this.autoHeight) {
                this.viewportBlockArea.setBPD(0);
            } else {
                this.viewportBlockArea.setBPD(this.vpContentBPD);
            }
            TraitSetter.setProducerID(this.viewportBlockArea, this.getBlockContainerFO().getId());
            TraitSetter.addBorders(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground());
            TraitSetter.addBackground(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground());
            TraitSetter.addMargins(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.getBlockContainerFO().getCommonMarginBlock());
            this.viewportBlockArea.setCTM(this.absoluteCTM);
            this.viewportBlockArea.setClip(this.clip);
            if (this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51) {
                Point offset = this.getAbsOffset();
                this.viewportBlockArea.setXOffset(offset.x);
                this.viewportBlockArea.setYOffset(offset.y);
            }
            this.referenceArea = new Block();
            this.referenceArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.referenceArea, this.getBlockContainerFO().getId());
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setPositioning(2);
            } else if (this.abProps.absolutePosition == 51) {
                this.viewportBlockArea.setPositioning(3);
            }
            this.parentLM.getParentArea(this.referenceArea);
            this.referenceArea.setIPD(this.relDims.ipd);
            this.setCurrentArea(this.viewportBlockArea);
        }
        return this.referenceArea;
    }

    public void addChildArea(Area childArea) {
        if (this.referenceArea != null) {
            this.referenceArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    protected void flush() {
        this.viewportBlockArea.addBlock(this.referenceArea, this.autoHeight);
        int saveBPD = this.viewportBlockArea.getBPD();
        if (this.viewportBlockArea.getPositioning() == 2) {
            this.viewportBlockArea.setBPD(0);
        }
        super.flush();
        if (this.viewportBlockArea.getPositioning() == 2) {
            this.viewportBlockArea.setBPD(saveBPD);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getBlockContainerFO().getKeepTogether().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getBlockContainerFO().getKeepWithPrevious().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getBlockContainerFO().getKeepWithNext().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepWithNext().getWithinColumn().isAuto();
    }

    protected BlockContainer getBlockContainerFO() {
        return (BlockContainer)this.fobj;
    }

    private class BlockContainerBreaker
    extends AbstractBreaker {
        private BlockContainerLayoutManager bclm;
        private MinOptMax ipd;
        private PageBreakingAlgorithm deferredAlg;
        private AbstractBreaker.BlockSequence deferredOriginalList;
        private AbstractBreaker.BlockSequence deferredEffectiveList;

        public BlockContainerBreaker(BlockContainerLayoutManager bclm, MinOptMax ipd) {
            this.bclm = bclm;
            this.ipd = ipd;
        }

        protected void observeElementList(List elementList) {
            ElementListObserver.observe(elementList, "block-container", this.bclm.getBlockContainerFO().getId());
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        public int getDifferenceOfFirstPart() {
            AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)this.deferredAlg.getPageBreaks().getFirst();
            return pbp.difference;
        }

        public boolean isOverflow() {
            if (this.isEmpty()) {
                return false;
            }
            return this.deferredAlg.getPageBreaks().size() > 1;
        }

        protected LayoutManager getTopLevelLM() {
            return this.bclm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext lc = super.createLayoutContext();
            lc.setRefIPD(this.ipd.opt);
            return lc;
        }

        protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
            LayoutManager curLM;
            LinkedList returnList = new LinkedList();
            while ((curLM = BlockContainerLayoutManager.this.getChildLM()) != null) {
                LayoutContext childLC = new LayoutContext(0);
                childLC.setStackLimit(context.getStackLimit());
                childLC.setRefIPD(context.getRefIPD());
                LinkedList returnedList = null;
                if (!curLM.isFinished()) {
                    returnedList = curLM.getNextKnuthElements(childLC, alignment);
                }
                if (returnedList == null) continue;
                this.bclm.wrapPositionElements(returnedList, returnList);
            }
            BlockContainerLayoutManager.this.setFinished(true);
            return returnList;
        }

        protected int getCurrentDisplayAlign() {
            return BlockContainerLayoutManager.this.getBlockContainerFO().getDisplayAlign();
        }

        protected boolean hasMoreContent() {
            return !BlockContainerLayoutManager.this.isFinished();
        }

        protected void addAreas(PositionIterator posIter, LayoutContext context) {
            AreaAdditionUtil.addAreas(this.bclm, posIter, context);
        }

        protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            this.deferredAlg = alg;
            this.deferredOriginalList = originalList;
            this.deferredEffectiveList = effectiveList;
        }

        protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        }

        protected LayoutManager getCurrentChildLM() {
            return BlockContainerLayoutManager.this.curChildLM;
        }

        public void addContainedAreas() {
            if (this.isEmpty()) {
                return;
            }
            this.addAreas(this.deferredAlg, this.deferredAlg.getPageBreaks().size(), this.deferredOriginalList, this.deferredEffectiveList);
        }
    }

    private class BlockContainerPosition
    extends NonLeafPosition {
        private BlockContainerBreaker breaker;

        public BlockContainerPosition(LayoutManager lm, BlockContainerBreaker breaker) {
            super(lm, null);
            this.breaker = breaker;
        }

        public BlockContainerBreaker getBreaker() {
            return this.breaker;
        }
    }
}

