/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;

public abstract class LeafNodeLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager {
    protected InlineArea curArea = null;
    protected int verticalAlignment;
    private int lead;
    private MinOptMax ipd;
    protected boolean bSomethingChanged = false;
    protected AreaInfo areaInfo = null;

    public LeafNodeLayoutManager(FObj node) {
        super(node);
    }

    public LeafNodeLayoutManager() {
    }

    public InlineArea get(LayoutContext context) {
        return this.curArea;
    }

    public boolean resolved() {
        return false;
    }

    public void setCurrentArea(InlineArea ia) {
        this.curArea = ia;
    }

    public void setAlignment(int al) {
        this.verticalAlignment = al;
    }

    public void setLead(int l) {
        this.lead = l;
    }

    public int getLead() {
        return this.lead;
    }

    public void addChildArea(Area childArea) {
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    protected MinOptMax getAllocationIPD(int refIPD) {
        return new MinOptMax(this.curArea.getIPD());
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        this.addId();
        InlineArea area = this.getEffectiveArea();
        if (area.getAllocIPD() > 0 || area.getAllocBPD() > 0) {
            this.offsetArea(area, context);
            this.widthAdjustArea(area, context);
            this.parentLM.addChildArea(area);
        }
        while (posIter.hasNext()) {
            posIter.next();
        }
    }

    protected InlineArea getEffectiveArea() {
        return this.curArea;
    }

    protected void addId() {
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        int bpd = area.getBPD();
        switch (this.verticalAlignment) {
            case 84: {
                area.setOffset(context.getMiddleBaseline() - bpd / 2);
                break;
            }
            case 145: {
                area.setOffset(context.getTopBaseline());
                break;
            }
            case 20: {
                area.setOffset(context.getBottomBaseline() - bpd);
                break;
            }
            default: {
                area.setOffset(context.getBaseline() - bpd);
            }
        }
    }

    protected void widthAdjustArea(InlineArea area, LayoutContext context) {
        double dAdjust = context.getIPDAdjust();
        int width = this.areaInfo.ipdArea.opt;
        if (dAdjust < 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.areaInfo.ipdArea.opt - this.areaInfo.ipdArea.min));
        } else if (dAdjust > 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.areaInfo.ipdArea.max - this.areaInfo.ipdArea.opt));
        }
        area.setIPD(width);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        MinOptMax ipd = this.getAllocationIPD(context.getRefIPD());
        int bpd = this.curArea.getBPD();
        int lead = 0;
        int total = 0;
        int middle = 0;
        switch (this.verticalAlignment) {
            case 84: {
                middle = bpd / 2;
                lead = bpd / 2;
                break;
            }
            case 145: {
                total = bpd;
                break;
            }
            case 20: {
                total = bpd;
                break;
            }
            default: {
                lead = this.getLead();
                total = bpd;
            }
        }
        this.areaInfo = new AreaInfo(0, ipd, false, lead, total, middle);
        LinkedList<KnuthInlineBox> returnList = new LinkedList<KnuthInlineBox>();
        returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), false));
        this.setFinished(true);
        return returnList;
    }

    public List addALetterSpaceTo(List oldList) {
        return oldList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
    }

    public void hyphenate(Position pos, HyphContext hc) {
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthInlineBox> returnList = new LinkedList<KnuthInlineBox>();
        returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.lead, this.areaInfo.total, this.areaInfo.middle, new LeafPosition(this, 0), true));
        this.setFinished(true);
        return returnList;
    }

    protected class AreaInfo {
        protected short iLScount;
        protected MinOptMax ipdArea;
        protected boolean bHyphenated;
        protected int lead;
        protected int total;
        protected int middle;

        public AreaInfo(short iLS, MinOptMax ipd, boolean bHyph, int l, int t, int m) {
            this.iLScount = iLS;
            this.ipdArea = ipd;
            this.bHyphenated = bHyph;
            this.lead = l;
            this.total = t;
            this.middle = m;
        }
    }
}

