/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public class PageNumberCitationLayoutManager
extends LeafNodeLayoutManager {
    private PageNumberCitation fobj;
    private Font font;
    private boolean resolved = false;

    public PageNumberCitationLayoutManager(PageNumberCitation node) {
        super(node);
        this.fobj = node;
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo());
    }

    public InlineArea get(LayoutContext context) {
        this.curArea = this.getPageNumberCitationInlineArea(this.parentLM);
        return this.curArea;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        super.addAreas(posIter, context);
        if (!this.resolved) {
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)this.curArea));
        }
    }

    public int getLead() {
        return this.font.getAscender();
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        area.setOffset(context.getBaseline());
    }

    private InlineArea getPageNumberCitationInlineArea(LayoutManager parentLM) {
        PageViewport page = this.getPSLM().getFirstPVWithID(this.fobj.getRefId());
        TextArea inline = null;
        if (page != null) {
            TextArea text;
            String str = page.getPageNumberString();
            inline = text = new TextArea();
            int width = this.getStringWidth(str);
            text.setTextArea(str);
            inline.setIPD(width);
            this.resolved = true;
        } else {
            this.resolved = false;
            inline = new UnresolvedPageNumber(this.fobj.getRefId());
            String str = "MMM";
            int width = this.getStringWidth(str);
            inline.setIPD(width);
        }
        TraitSetter.setProducerID(inline, this.fobj.getId());
        inline.setBPD(this.font.getAscender() - this.font.getDescender());
        inline.setOffset(this.font.getAscender());
        inline.addTrait(Trait.FONT_NAME, this.font.getFontName());
        inline.addTrait(Trait.FONT_SIZE, new Integer(this.font.getFontSize()));
        inline.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addTextDecoration(inline, this.fobj.getTextDecoration());
        return inline;
    }

    private int getStringWidth(String str) {
        int width = 0;
        for (int count = 0; count < str.length(); ++count) {
            width += this.font.getCharWidth(str.charAt(count));
        }
        return width;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

