/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.xml.XMLXMLHandler;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLRenderer
extends PrintRenderer {
    public static final String XML_MIME_TYPE = "application/x-fop-areatree";
    public static final String NS = "";
    public static final String CDATA = "CDATA";
    public static final Attributes EMPTY_ATTS = new AttributesImpl();
    private boolean startedSequence = false;
    private RendererContext context;
    protected TransformerHandler handler;
    protected AttributesImpl atts = new AttributesImpl();
    protected OutputStream out;

    public XMLRenderer() {
        this.context = new RendererContext(this, XML_MIME_TYPE);
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        XMLXMLHandler handler = new XMLXMLHandler();
        this.userAgent.getXMLHandlerRegistry().addXMLHandler(handler);
    }

    public void setTransformerHandler(TransformerHandler handler) {
        this.handler = handler;
    }

    private boolean isCoarseXml() {
        return (Boolean)this.userAgent.getRendererOptions().get("fineDetail");
    }

    protected void handleSAXException(SAXException saxe) {
        throw new RuntimeException(saxe.getMessage());
    }

    protected void comment(String comment) {
        try {
            this.handler.comment(comment.toCharArray(), 0, comment.length());
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void startElement(String tagName) {
        this.startElement(tagName, EMPTY_ATTS);
    }

    protected void startElement(String tagName, Attributes atts) {
        try {
            this.handler.startElement(NS, tagName, tagName, atts);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void endElement(String tagName) {
        try {
            this.handler.endElement(NS, tagName, tagName);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void characters(String text) {
        try {
            char[] ca = text.toCharArray();
            this.handler.characters(ca, 0, ca.length);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void addAttribute(String name, String value) {
        this.atts.addAttribute(NS, name, name, CDATA, value);
    }

    protected void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    protected void addAttribute(String name, Rectangle2D rect) {
        this.addAttribute(name, this.createString(rect));
    }

    protected void addAreaAttributes(Area area) {
        this.addAttribute("ipd", area.getIPD());
        this.addAttribute("bpd", area.getBPD());
        if (area.getIPD() != 0) {
            this.addAttribute("ipda", area.getAllocIPD());
        }
        if (area.getBPD() != 0) {
            this.addAttribute("bpda", area.getAllocBPD());
        }
        this.addAttribute("bap", area.getBorderAndPaddingWidthStart() + " " + area.getBorderAndPaddingWidthEnd() + " " + area.getBorderAndPaddingWidthBefore() + " " + area.getBorderAndPaddingWidthAfter());
    }

    protected void addTraitAttributes(Area area) {
        Map traitMap = area.getTraits();
        if (traitMap != null) {
            Iterator iter = traitMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry traitEntry = iter.next();
                String name = Trait.getTraitName(traitEntry.getKey());
                if ("break-before".equals(name) || "break-after".equals(name)) continue;
                String value = traitEntry.getValue().toString();
                this.addAttribute(name, value);
                if (!"font-family".equals(name)) continue;
                this.addAttribute("font-name", this.fontInfo.getMetricsFor(value).getFontName());
                this.addAttribute("font-style", this.fontInfo.getFontStyleFor(value));
                this.addAttribute("font-weight", this.fontInfo.getFontWeightFor(value));
            }
        }
    }

    private String createString(Rectangle2D rect) {
        return NS + (int)rect.getX() + " " + (int)rect.getY() + " " + (int)rect.getWidth() + " " + (int)rect.getHeight();
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug("Rendering areas to Area Tree XML");
        if (this.handler == null) {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            try {
                this.handler = factory.newTransformerHandler();
                StreamResult res = new StreamResult(outputStream);
                this.handler.setResult(res);
            }
            catch (TransformerConfigurationException tce) {
                throw new RuntimeException(tce.getMessage());
            }
            this.out = outputStream;
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
        this.comment("Produced by " + (this.userAgent.getProducer() != null ? this.userAgent.getProducer() : NS));
        this.startElement("areaTree");
    }

    public void stopRenderer() throws IOException {
        if (this.startedSequence) {
            this.endElement("pageSequence");
        }
        this.endElement("areaTree");
        try {
            this.handler.endDocument();
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
        if (this.out != null) {
            this.out.flush();
        }
        log.debug("Written out Area Tree XML");
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.atts.clear();
        this.addAttribute("bounds", page.getViewArea());
        this.addAttribute("nr", page.getPageNumberString());
        this.startElement("pageViewport", this.atts);
        this.startElement("page");
        super.renderPage(page);
        this.endElement("page");
        this.endElement("pageViewport");
    }

    public void startPageSequence(LineArea seqTitle) {
        if (this.startedSequence) {
            this.endElement("pageSequence");
        }
        this.startedSequence = true;
        this.startElement("pageSequence");
        if (seqTitle != null) {
            this.startElement("title");
            List children = seqTitle.getInlineAreas();
            for (int count = 0; count < children.size(); ++count) {
                InlineArea inline = (InlineArea)children.get(count);
                this.renderInlineArea(inline);
            }
            this.endElement("title");
        }
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.atts.clear();
            this.addAreaAttributes(port);
            this.addTraitAttributes(port);
            this.addAttribute("rect", port.getViewArea());
            this.startElement("regionViewport", this.atts);
            RegionReference region = port.getRegionReference();
            this.atts.clear();
            this.addAreaAttributes(region);
            this.addTraitAttributes(region);
            if (region.getRegionClass() == 35) {
                this.startElement("regionBefore", this.atts);
                this.renderRegion(region);
                this.endElement("regionBefore");
            } else if (region.getRegionClass() == 38) {
                this.startElement("regionStart", this.atts);
                this.renderRegion(region);
                this.endElement("regionStart");
            } else if (region.getRegionClass() == 36) {
                this.startElement("regionBody", this.atts);
                this.renderBodyRegion((BodyRegion)region);
                this.endElement("regionBody");
            } else if (region.getRegionClass() == 37) {
                this.startElement("regionEnd", this.atts);
                this.renderRegion(region);
                this.endElement("regionEnd");
            } else if (region.getRegionClass() == 34) {
                this.startElement("regionAfter", this.atts);
                this.renderRegion(region);
                this.endElement("regionAfter");
            }
            this.endElement("regionViewport");
        }
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        this.startElement("beforeFloat");
        super.renderBeforeFloat(bf);
        this.endElement("beforeFloat");
    }

    protected void renderFootnote(Footnote footnote) {
        this.startElement("footnote");
        super.renderFootnote(footnote);
        this.endElement("footnote");
    }

    protected void renderMainReference(MainReference mr) {
        this.atts.clear();
        this.addAreaAttributes(mr);
        this.addTraitAttributes(mr);
        this.addAttribute("columnGap", mr.getColumnGap());
        this.addAttribute("width", mr.getWidth());
        this.startElement("mainReference", this.atts);
        Span span = null;
        List spans = mr.getSpans();
        for (int count = 0; count < spans.size(); ++count) {
            span = (Span)spans.get(count);
            this.atts.clear();
            this.addAreaAttributes(span);
            this.addTraitAttributes(span);
            this.startElement("span", this.atts);
            for (int c = 0; c < span.getColumnCount(); ++c) {
                NormalFlow flow = span.getNormalFlow(c);
                this.renderFlow(flow);
            }
            this.endElement("span");
        }
        this.endElement("mainReference");
    }

    protected void renderFlow(NormalFlow flow) {
        this.atts.clear();
        this.addAreaAttributes(flow);
        this.addTraitAttributes(flow);
        this.startElement("flow", this.atts);
        super.renderFlow(flow);
        this.endElement("flow");
    }

    protected void renderBlock(Block block) {
        this.atts.clear();
        this.addAreaAttributes(block);
        this.addTraitAttributes(block);
        if (block instanceof BlockViewport) {
            BlockViewport bvp = (BlockViewport)block;
            boolean abspos = false;
            if (bvp.getPositioning() == 2) {
                this.addAttribute("positioning", "absolute");
                abspos = true;
            } else if (bvp.getPositioning() == 3) {
                this.addAttribute("positioning", "fixed");
                abspos = true;
            }
            if (abspos) {
                this.addAttribute("left-position", bvp.getXOffset());
                this.addAttribute("top-position", bvp.getYOffset());
            }
            this.addAttribute("ctm", bvp.getCTM().toString());
            if (bvp.getClip()) {
                this.addAttribute("clipped", "true");
            }
        } else {
            if (block.getPositioning() == 1) {
                this.addAttribute("positioning", "relative");
            }
            if (block.getXOffset() != 0) {
                this.addAttribute("left-offset", block.getXOffset());
            }
            if (block.getYOffset() != 0) {
                this.addAttribute("top-offset", block.getYOffset());
            }
        }
        this.startElement("block", this.atts);
        super.renderBlock(block);
        this.endElement("block");
    }

    protected void renderLineArea(LineArea line) {
        this.atts.clear();
        this.addAreaAttributes(line);
        this.addTraitAttributes(line);
        this.addAttribute("vpos", this.currentBPPosition);
        this.startElement("lineArea", this.atts);
        super.renderLineArea(line);
        this.endElement("lineArea");
    }

    protected void renderViewport(Viewport viewport) {
        this.atts.clear();
        this.addAreaAttributes(viewport);
        this.addTraitAttributes(viewport);
        this.startElement("viewport", this.atts);
        super.renderViewport(viewport);
        this.endElement("viewport");
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.atts.clear();
        this.addAreaAttributes(image);
        this.addTraitAttributes(image);
        this.addAttribute("url", image.getURL());
        this.addAttribute("pos", pos);
        this.startElement("image", this.atts);
        this.endElement("image");
    }

    public void renderContainer(Container cont) {
        this.startElement("container");
        super.renderContainer(cont);
        this.endElement("container");
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        this.atts.clear();
        this.addAreaAttributes(fo);
        this.addTraitAttributes(fo);
        this.addAttribute("pos", pos);
        this.startElement("foreignObject", this.atts);
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.context.setProperty("handler", this.handler);
        this.renderXML(this.context, doc, ns);
        this.endElement("foreignObject");
    }

    protected void renderCharacter(Character ch) {
        this.atts.clear();
        this.addTraitAttributes(ch);
        this.addAttribute("vpos", ch.getOffset());
        this.startElement("char", this.atts);
        this.characters(ch.getChar());
        this.endElement("char");
    }

    protected void renderInlineSpace(Space space) {
        this.atts.clear();
        this.addAreaAttributes(space);
        this.startElement("space", this.atts);
        this.endElement("space");
    }

    protected void renderText(TextArea text) {
        this.atts.clear();
        if (text.getTextWordSpaceAdjust() != 0) {
            this.addAttribute("twsadjust", text.getTextWordSpaceAdjust());
        }
        if (text.getTextLetterSpaceAdjust() != 0) {
            this.addAttribute("tlsadjust", text.getTextLetterSpaceAdjust());
        }
        this.addAttribute("vpos", text.getOffset());
        this.addAreaAttributes(text);
        this.addTraitAttributes(text);
        this.startElement("text", this.atts);
        this.characters(text.getTextArea());
        this.endElement("text");
        super.renderText(text);
    }

    protected void renderInlineParent(InlineParent ip) {
        this.atts.clear();
        this.addAreaAttributes(ip);
        this.addTraitAttributes(ip);
        this.startElement("inlineparent", this.atts);
        super.renderInlineParent(ip);
        this.endElement("inlineparent");
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        this.atts.clear();
        this.addAreaAttributes(ibp);
        this.addTraitAttributes(ibp);
        this.startElement("inlineblockparent", this.atts);
        super.renderInlineBlockParent(ibp);
        this.endElement("inlineblockparent");
    }

    protected void renderLeader(Leader area) {
        String style = "solid";
        switch (area.getRuleStyle()) {
            case 36: {
                style = "dotted";
                break;
            }
            case 31: {
                style = "dashed";
                break;
            }
            case 133: {
                break;
            }
            case 37: {
                style = "double";
                break;
            }
            case 55: {
                style = "groove";
                break;
            }
            case 119: {
                style = "ridge";
                break;
            }
            default: {
                style = "--NYI--";
            }
        }
        this.atts.clear();
        this.addAreaAttributes(area);
        this.addAttribute("ruleStyle", style);
        this.addAttribute("ruleThickness", area.getRuleThickness());
        this.startElement("leader", this.atts);
        this.endElement("leader");
        super.renderLeader(area);
    }

    public String getMimeType() {
        return XML_MIME_TYPE;
    }
}

