/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.combination;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalSymbolicAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinableAxis;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedHorizontalDateAxis;
import com.jrefinery.chart.combination.CombinedHorizontalNumberAxis;
import com.jrefinery.chart.combination.CombinedHorizontalSymbolicAxis;
import com.jrefinery.chart.combination.CombinedVerticalNumberAxis;
import com.jrefinery.chart.combination.CombinedVerticalSymbolicAxis;
import com.jrefinery.chart.combination.OverlaidHorizontalDateAxis;
import com.jrefinery.chart.combination.OverlaidHorizontalNumberAxis;
import com.jrefinery.chart.combination.OverlaidHorizontalSymbolicAxis;
import com.jrefinery.chart.combination.OverlaidPlot;
import com.jrefinery.chart.combination.OverlaidVerticalNumberAxis;
import com.jrefinery.chart.combination.OverlaidVerticalSymbolicAxis;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.data.CombinationDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.SeriesDataset;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int OVERLAID = 3;
    private int type;
    protected List charts = new ArrayList();
    protected int weights = 0;
    protected boolean isAdjusted = false;
    protected boolean[] axisRangeSet = new boolean[]{false, false};
    private Rectangle2D plotArea;
    private boolean inReadjustPlotsMinMax = false;

    public CombinedPlot(Axis axis, int n) {
        super(n == 1 ? axis : null, n == 0 ? axis : null);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid type (" + n + ")");
        }
        this.type = n;
        this.setInsets(new Insets(0, 0, 0, 0));
    }

    public CombinedPlot(Axis axis, Axis axis2) {
        super(axis, axis2);
        this.type = 3;
        this.setInsets(new Insets(0, 0, 0, 0));
    }

    public void add(CombinedChart combinedChart) throws AxisNotCompatibleException {
        this.add(combinedChart, 1);
    }

    public void add(CombinedChart combinedChart, int n) throws AxisNotCompatibleException, IllegalArgumentException {
        Plot plot = combinedChart.getPlot();
        if (this.getHorizontalAxis() != plot.getHorizontalAxis() && this.type != 0) {
            throw new AxisNotCompatibleException("Can't combine with different horizontal axis");
        }
        if (this.getVerticalAxis() != plot.getVerticalAxis() && this.type != 1) {
            throw new AxisNotCompatibleException("Can't combine with different vertical axis");
        }
        if (!this.isCompatibleHorizontalAxis((Axis)((Object)plot.getHorizontalAxis()))) {
            throw new AxisNotCompatibleException("Incompatible horizontal axis");
        }
        if (!this.isCompatibleVerticalAxis((Axis)((Object)plot.getVerticalAxis()))) {
            throw new AxisNotCompatibleException("Incompatible vertical axis");
        }
        if (n <= 0 && this.type != 3) {
            throw new IllegalArgumentException("weight must be positive");
        }
        if (n != 1 && this.type == 3) {
            throw new IllegalArgumentException("CombinedPlot.add(...) : weight must be 1 for overlaid charts.");
        }
        if (this.charts.size() > 0 && this.type == 3) {
            plot.setBackgroundPaint(null);
            plot.setOutlineStroke(null);
            plot.setOutlinePaint(null);
        }
        ChartInfo chartInfo = new ChartInfo(combinedChart, n);
        this.charts.add(chartInfo);
        this.weights += n;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalNumberAxis || axis instanceof HorizontalDateAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public String getPlotType() {
        switch (this.type) {
            case 3: {
                return "Overlaid Plot";
            }
            case 0: {
                return "Horizontal Combined Plot";
            }
            case 1: {
                return "Vertical Combined Plot";
            }
        }
        return "Unknown Combined Plot";
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo) {
        Object object;
        int n = this.charts.size();
        int n2 = 0;
        int n3 = 0;
        this.adjustPlots();
        rectangle2D = this.adjustForInsets(rectangle2D, this.insets);
        if (this.insets != null && this.type != 3) {
            n2 = Math.max(this.insets.top, this.insets.bottom);
            n3 = Math.max(this.insets.right, this.insets.left);
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.type != 0) {
            d = this.getHorizontalAxis().reserveHeight(graphics2D, this, rectangle2D);
        }
        if (this.type != 1) {
            d2 = this.getVerticalAxis().reserveWidth(graphics2D, this, rectangle2D);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        this.plotArea = double_;
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n];
        double d3 = ((RectangularShape)double_).getX();
        double d4 = ((RectangularShape)double_).getY();
        double d5 = ((RectangularShape)double_).getWidth() - (double)(n3 * (this.charts.size() - 1));
        double d6 = ((RectangularShape)double_).getHeight() - (double)(n2 * (this.charts.size() - 1));
        double d7 = Double.MIN_VALUE;
        double d8 = Double.MIN_VALUE;
        int n4 = 0;
        while (n4 < n) {
            ChartInfo chartInfo = (ChartInfo)this.charts.get(n4);
            object = chartInfo.plot;
            double d9 = d6;
            if (this.type == 1) {
                d9 *= (double)chartInfo.weight / (double)this.weights;
            }
            if (n4 == n - 1) {
                d9 += d;
            }
            double d10 = d5;
            if (this.type == 0) {
                d10 *= (double)chartInfo.weight / (double)this.weights;
            }
            if (n4 == 0) {
                d10 += d2;
            }
            rectangle2DArray[n4] = new Rectangle2D.Double(d3, d4, d10, d9);
            if (this.type != 3) {
                Rectangle2D rectangle2D2 = this.adjustForInsets(rectangle2DArray[n4], ((Plot)object).getInsets());
                if (this.type == 1) {
                    d7 = Math.max(d7, ((Plot)object).getVerticalAxis().reserveWidth(graphics2D, (Plot)object, rectangle2D2));
                } else if (this.type == 0) {
                    d8 = Math.max(d8, ((Plot)object).getHorizontalAxis().reserveHeight(graphics2D, (Plot)object, rectangle2D2));
                }
            }
            if (this.type == 1) {
                d4 += d9 + (double)n2;
            } else if (this.type == 0) {
                d3 += d10 + (double)n3;
            }
            if (this.type == 3 && n4 == 0) {
                d3 += d2;
            }
            ++n4;
        }
        if (this.type == 1) {
            this.setVerticalAxisWidth(d7);
        } else if (this.type == 0) {
            this.setHorizontalAxisHeight(d8);
        }
        int n5 = 0;
        while (n5 < n) {
            object = (ChartInfo)this.charts.get(n5);
            ((ChartInfo)object).chart.draw(graphics2D, rectangle2DArray[n5], null);
            ++n5;
        }
    }

    protected Rectangle2D adjustForInsets(Rectangle2D rectangle2D, Insets insets) {
        if (insets != null) {
            return new Rectangle2D.Double(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        return rectangle2D;
    }

    protected void setHorizontalAxisHeight(double d) {
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot = chartInfo.plot;
            CombinableAxis combinableAxis = (CombinableAxis)((Object)plot.getHorizontalAxis());
            combinableAxis.setReserveDimension(d);
            if (!(plot instanceof CombinedPlot)) continue;
            ((CombinedPlot)plot).setHorizontalAxisHeight(d);
        }
    }

    protected void setVerticalAxisWidth(double d) {
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot = chartInfo.plot;
            CombinableAxis combinableAxis = (CombinableAxis)((Object)plot.getVerticalAxis());
            combinableAxis.setReserveDimension(d);
            if (!(plot instanceof CombinedPlot)) continue;
            ((CombinedPlot)plot).setVerticalAxisWidth(d);
        }
    }

    public Number getMinimumHorizontalDataValue() {
        if (this.charts != null) {
            if (this.charts.size() == 0) {
                return null;
            }
            Number number = new Double(Double.MAX_VALUE);
            Iterator iterator = this.charts.iterator();
            while (iterator.hasNext()) {
                ChartInfo chartInfo = (ChartInfo)iterator.next();
                HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)chartInfo.plot);
                Number number2 = horizontalValuePlot.getMinimumHorizontalDataValue();
                if (number2 == null || !(number2.doubleValue() < number)) continue;
                number = number2;
            }
            return number;
        }
        return null;
    }

    public Number getMaximumHorizontalDataValue() {
        if (this.charts != null) {
            if (this.charts.size() == 0) {
                return null;
            }
            Number number = new Double(Double.MIN_VALUE);
            Iterator iterator = this.charts.iterator();
            while (iterator.hasNext()) {
                ChartInfo chartInfo = (ChartInfo)iterator.next();
                HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)chartInfo.plot);
                Number number2 = horizontalValuePlot.getMaximumHorizontalDataValue();
                if (number2 == null || !(number2.doubleValue() > number)) continue;
                number = number2;
            }
            return number;
        }
        return null;
    }

    public Number getMinimumVerticalDataValue() {
        if (this.chart != null) {
            if (this.charts.size() == 0) {
                return null;
            }
            Number number = new Double(Double.MAX_VALUE);
            Iterator iterator = this.charts.iterator();
            while (iterator.hasNext()) {
                ChartInfo chartInfo = (ChartInfo)iterator.next();
                VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)chartInfo.plot);
                Number number2 = verticalValuePlot.getMinimumVerticalDataValue();
                if (number2 == null || !(number2.doubleValue() < number)) continue;
                number = number2;
            }
            return number;
        }
        return null;
    }

    public Number getMaximumVerticalDataValue() {
        if (this.charts != null) {
            if (this.charts.size() == 0) {
                return null;
            }
            Number number = new Double(Double.MIN_VALUE);
            Iterator iterator = this.charts.iterator();
            while (iterator.hasNext()) {
                ChartInfo chartInfo = (ChartInfo)iterator.next();
                VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)chartInfo.plot);
                Number number2 = verticalValuePlot.getMaximumVerticalDataValue();
                if (number2 == null || !(number2.doubleValue() > number)) continue;
                number = number2;
            }
            return number;
        }
        return null;
    }

    public void adjustPlots() {
        this.adjustPlotsAxis();
        this.adjustPlotsMinMax();
        this.adjustSeriesPaintAndStroke();
    }

    public List getHorizontalAxes() {
        return this.getHorizontalAxes(false);
    }

    public List getHorizontalAxes(boolean bl) {
        ArrayList<HorizontalAxis> arrayList = new ArrayList<HorizontalAxis>();
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            arrayList.add(chartInfo.plot.getHorizontalAxis());
            if (!bl || !(chartInfo.plot instanceof CombinedPlot)) continue;
            CombinedPlot combinedPlot = (CombinedPlot)chartInfo.plot;
            List list = combinedPlot.getHorizontalAxes(true);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List getVerticalAxes() {
        return this.getVerticalAxes(false);
    }

    public List getVerticalAxes(boolean bl) {
        ArrayList<VerticalAxis> arrayList = new ArrayList<VerticalAxis>();
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            arrayList.add(chartInfo.plot.getVerticalAxis());
            if (!bl || !(chartInfo.plot instanceof CombinedPlot)) continue;
            CombinedPlot combinedPlot = (CombinedPlot)chartInfo.plot;
            List list = combinedPlot.getVerticalAxes(true);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public AxisRange getRange(List list) {
        AxisRange axisRange = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CombinableAxis combinableAxis = (CombinableAxis)iterator.next();
            if (axisRange == null) {
                axisRange = combinableAxis.getRange();
                continue;
            }
            axisRange.combine(combinableAxis.getRange());
        }
        return axisRange;
    }

    public void setRange(AxisRange axisRange, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CombinableAxis combinableAxis = (CombinableAxis)iterator.next();
            combinableAxis.setRange(axisRange);
        }
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public void zoom(double d) {
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.readjustPlotsMinMax(this.axisRangeSet[0], this.axisRangeSet[1]);
    }

    private void readjustPlotsMinMax(boolean bl, boolean bl2) {
        if (this.inReadjustPlotsMinMax) {
            return;
        }
        if ((bl &= this.axisRangeSet[0]) || (bl2 &= this.axisRangeSet[1])) {
            if (bl) {
                this.setAxisRangeSet(0, false);
            }
            if (bl2) {
                this.setAxisRangeSet(1, false);
            }
            this.adjustPlotsMinMax(bl, bl2);
        }
        this.inReadjustPlotsMinMax = true;
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot = chartInfo.plot;
            if (!(plot instanceof CombinedPlot)) continue;
            ((CombinedPlot)plot).readjustPlotsMinMax(!bl, !bl2);
        }
        this.inReadjustPlotsMinMax = false;
    }

    protected void adjustPlotsAxis() {
        if (!this.isAdjusted) {
            this.adjustPlotsAxis(true, true);
        }
    }

    protected void adjustPlotsAxis(boolean bl, boolean bl2) {
        Iterator iterator = this.charts.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            boolean bl4;
            boolean bl5;
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot = chartInfo.plot;
            if (plot instanceof CombinedPlot) {
                boolean bl6 = bl && this.horizontalAxisVisible(bl3, !iterator.hasNext(), plot) ? true : (bl5 = false);
                bl4 = bl2 && this.verticalAxisVisible(bl3, !iterator.hasNext(), plot);
                ((CombinedPlot)plot).adjustPlotsAxis(bl5, bl4);
            }
            bl5 = bl && this.horizontalAxisVisible(bl3, !iterator.hasNext(), plot);
            Axis axis = this.createCombinedAxis(plot, (Axis)((Object)plot.getHorizontalAxis()), bl5);
            bl4 = bl2 && this.verticalAxisVisible(bl3, !iterator.hasNext(), plot);
            Axis axis2 = this.createCombinedAxis(plot, (Axis)((Object)plot.getVerticalAxis()), bl4);
            plot.setHorizontalAxis(axis);
            plot.setVerticalAxis(axis2);
            bl3 = false;
        }
        this.isAdjusted = true;
    }

    protected boolean horizontalAxisVisible(boolean bl, boolean bl2, Plot plot) {
        if (this.type == 0) {
            return true;
        }
        return bl2;
    }

    protected boolean verticalAxisVisible(boolean bl, boolean bl2, Plot plot) {
        if (this.type == 1) {
            return true;
        }
        return bl;
    }

    protected void adjustPlotsMinMax() {
        this.adjustPlotsMinMax(this.type != 0, this.type != 1);
    }

    protected void adjustPlotsMinMax(boolean bl, boolean bl2) {
        AxisRange axisRange;
        List list;
        if (bl && !this.axisRangeSet[0]) {
            list = this.getHorizontalAxes(true);
            axisRange = this.getRange(list);
            this.setRange(axisRange, list);
            this.setAxisRangeSet(0, true);
        }
        if (bl2 && !this.axisRangeSet[1]) {
            list = this.getVerticalAxes(true);
            axisRange = this.getRange(list);
            this.setRange(axisRange, list);
            this.setAxisRangeSet(1, true);
        }
    }

    private void setAxisRangeSet(int n, boolean bl) {
        this.axisRangeSet[n] = bl;
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot = chartInfo.plot;
            if (!(plot instanceof CombinedPlot)) continue;
            ((CombinedPlot)plot).setAxisRangeSet(n, bl);
        }
    }

    private void adjustSeriesPaintAndStroke() {
        if (this.chart != null) {
            SeriesDataset seriesDataset = (SeriesDataset)this.chart.getDataset();
            this.adjustSeriesPaintAndStroke(this, (Dataset)seriesDataset);
        }
    }

    private void adjustSeriesPaintAndStroke(Plot plot, Dataset dataset) {
        Iterator iterator = this.charts.iterator();
        while (iterator.hasNext()) {
            CombinationDataset combinationDataset;
            ChartInfo chartInfo = (ChartInfo)iterator.next();
            Plot plot2 = chartInfo.plot;
            Dataset dataset2 = chartInfo.chart.getDataset();
            if (dataset2 instanceof CombinationDataset && (combinationDataset = (CombinationDataset)dataset2).getParent() == dataset) {
                int[] nArray = combinationDataset.getMap();
                Stroke[] strokeArray = new Stroke[nArray.length];
                Paint[] paintArray = new Paint[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    strokeArray[n] = plot.getSeriesStroke(nArray[n]);
                    paintArray[n] = plot.getSeriesPaint(nArray[n]);
                    ++n;
                }
                plot2.setSeriesStroke(strokeArray);
                plot2.setSeriesPaint(paintArray);
            }
            if (!(plot2 instanceof CombinedPlot)) continue;
            ((CombinedPlot)plot2).adjustSeriesPaintAndStroke(plot, dataset);
        }
    }

    protected Axis createCombinedAxis(Plot plot, Axis axis, boolean bl) throws AxisNotCompatibleException {
        if (axis instanceof HorizontalSymbolicAxis) {
            if (plot instanceof CombinedPlot) {
                axis = new OverlaidHorizontalSymbolicAxis((CombinedPlot)plot);
            } else {
                boolean bl2 = true;
                if (this instanceof OverlaidPlot) {
                    bl2 = false;
                }
                axis = new CombinedHorizontalSymbolicAxis((HorizontalSymbolicAxis)axis, bl, bl2);
            }
        } else if (axis instanceof HorizontalNumberAxis) {
            axis = plot instanceof CombinedPlot ? new OverlaidHorizontalNumberAxis((CombinedPlot)plot) : new CombinedHorizontalNumberAxis((HorizontalNumberAxis)axis, bl);
        } else if (axis instanceof HorizontalDateAxis) {
            axis = plot instanceof CombinedPlot ? new OverlaidHorizontalDateAxis((CombinedPlot)plot) : new CombinedHorizontalDateAxis((HorizontalDateAxis)axis, bl);
        } else if (axis instanceof VerticalSymbolicAxis) {
            if (plot instanceof CombinedPlot) {
                axis = new OverlaidVerticalSymbolicAxis((CombinedPlot)plot);
            } else {
                boolean bl3 = true;
                if (this instanceof OverlaidPlot) {
                    bl3 = false;
                }
                axis = new CombinedVerticalSymbolicAxis((VerticalSymbolicAxis)axis, bl, bl3);
            }
        } else if (axis instanceof VerticalNumberAxis) {
            axis = plot instanceof CombinedPlot ? new OverlaidVerticalNumberAxis((CombinedPlot)plot) : new CombinedVerticalNumberAxis((VerticalNumberAxis)axis, bl);
        } else {
            throw new AxisNotCompatibleException("Invalid axis type: " + axis.getClass());
        }
        return axis;
    }

    class ChartInfo {
        public JFreeChart chart;
        public Plot plot;
        public int weight;

        ChartInfo(JFreeChart jFreeChart, int n) {
            this.chart = jFreeChart;
            this.plot = jFreeChart.getPlot();
            this.weight = n;
        }
    }
}

