/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusLabelBox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SplusRadioButtonGroup
extends SplusLabelBox
implements SplusControlMethods {
    int listSize;
    JRadioButton[] buttonList;
    ButtonGroup buttonGroup;
    JPanel buttonPanel;

    public SplusRadioButtonGroup(String string, char c, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(c);
    }

    public SplusRadioButtonGroup(String string, int n, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(n);
    }

    public SplusRadioButtonGroup(String string, String[] stringArray) {
        super(string);
        int n;
        this.listSize = stringArray.length;
        this.buttonList = new JRadioButton[this.listSize];
        this.buttonGroup = new ButtonGroup();
        for (n = 0; n < this.listSize; ++n) {
            this.buttonList[n] = new JRadioButton(stringArray[n], n == 0);
            this.buttonList[n].setPreferredSize(labelDimension);
            this.buttonGroup.add(this.buttonList[n]);
        }
        n = SplusRadioButtonGroup.labelDimension.height * this.listSize;
        if (!string.endsWith(":")) {
            string = string + ":";
        }
        this.buttonPanel = new JPanel();
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonPanel.add(this.buttonList[i]);
        }
        this.buttonPanel.setLayout(new GridLayout(this.listSize, 1));
        this.buttonPanel.setPreferredSize(new Dimension(SplusRadioButtonGroup.labelDimension.width, n));
        this.setActionControl(this.buttonPanel);
        this.setLabelFor(this.buttonList[0]);
    }

    public String getValue() {
        String string = "";
        for (int i = 0; i < this.listSize; ++i) {
            if (!this.buttonList[i].isSelected()) continue;
            return this.buttonList[i].getText();
        }
        return "";
    }

    public void setValue(String string) {
        for (int i = 0; i < this.listSize; ++i) {
            if (!this.buttonList[i].getText().equals(string)) continue;
            this.buttonList[i].setSelected(true);
        }
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] stringArray) {
        if (stringArray.length == this.listSize) {
            for (int i = 0; i < this.listSize; ++i) {
                this.buttonList[i].setText(stringArray[i]);
            }
        }
    }

    public boolean isEnabled() {
        return this.buttonList[0].isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.setLabelEnabled(bl);
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].setEnabled(bl);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].addActionListener(actionListener);
        }
    }

    public String getActionCommand() {
        return this.buttonList[0].getActionCommand();
    }

    public void setActionCommand(String string) {
        for (int i = 0; i < this.listSize; ++i) {
            this.buttonList[i].setActionCommand(string);
        }
    }
}

