/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusDataResult;

public class SplusFifo {
    static int count = 0;
    static int processID = -1;
    static String base_name = System.getProperty("splus.tmpdir", "/tmp") + "/SplusJava.FIFO.";
    private int id = 0;
    private int fd;
    private char mode;
    private String name;

    private native int mkFifo(String var1);

    private native int unlinkFifo(String var1);

    private native int openFifo(String var1, char var2);

    private native int closeFifo(int var1);

    private native void writeFifo(int var1, String var2);

    private native int readFifo(int var1);

    private native String readFifoString(int var1);

    private native Object readDataResult(int var1);

    private native int getProcessID();

    private native void flushDataReadPipe(int var1);

    public SplusFifo(char c) {
        this.id = ++count;
        if (processID == -1) {
            processID = this.getProcessID();
        }
        this.name = new String(base_name + String.valueOf(processID) + "." + String.valueOf(this.id));
        this.mode = c;
        int n = this.mkFifo(this.name);
        if (n != 0) {
            System.out.println("\nError: Couldn't create fifo " + this.name + "\n");
        }
    }

    public SplusFifo(String string, char c) {
        this.id = 0;
        this.name = new String(string);
        this.mode = c;
    }

    public String getName() {
        return this.name;
    }

    public void open() {
        this.fd = this.openFifo(this.name, this.mode);
        if (this.fd == -1) {
            System.out.println("\nError: Couldn't open fifo " + this.name + "for mode (" + this.mode + ")\n");
        }
    }

    public void close() {
        int n = this.closeFifo(this.fd);
        if (n == -1) {
            System.out.println("\nError: Couldn't close fifo " + this.name + "in mode (" + this.mode + ")\n");
        }
    }

    public int read() {
        if (this.mode == 'r') {
            return this.readFifo(this.fd);
        }
        System.out.println("\nError: Attempt to read from write-pipe: " + this.name + "\n");
        return -1;
    }

    public String readString() {
        if (this.mode == 'r') {
            return this.readFifoString(this.fd);
        }
        System.out.println("\nError: Attempt to read from write-pipe: " + this.name + "\n");
        return "";
    }

    public void write(String string) {
        if (this.mode == 'w') {
            this.writeFifo(this.fd, string);
        } else {
            System.out.println("\nError: Attempt to write to read-pipe: " + this.name + "\n");
        }
    }

    public SplusDataResult readData() {
        if (this.mode == 'r') {
            return (SplusDataResult)this.readDataResult(this.fd);
        }
        System.out.println("\nError: Attempt to read from write-pipe: " + this.name + "\n");
        return null;
    }

    public void flushDataChan() {
        if (this.mode == 'r') {
            this.flushDataReadPipe(this.fd);
        } else {
            System.out.println("\nError: Attempt to flush from write-pipe: " + this.name + "\n");
        }
    }

    protected void finalize() {
        this.unlink();
    }

    public void unlink() {
        int n = this.unlinkFifo(this.name);
        if (n != 0) {
            System.out.println("\nError: Couldn't unlink " + this.name + "\n");
        }
    }
}

