/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.controls.SplusWin32Tools;
import com.insightful.gdevice.SCanvas;
import com.insightful.gdevice.SGraphicsDeviceReceiver;
import com.insightful.splus.PrintCommand;
import com.insightful.splus.PrintSetupCommand;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.graph.CanvasTabbedPane;
import com.insightful.splus.graph.GraphColorsDialog;
import com.insightful.splus.graph.GraphOptionsDialog;
import com.insightful.splus.graph.GraphWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class GraphFrame
extends JFrame
implements SplusPrintable,
SaveAsable,
WindowListener {
    CanvasTabbedPane paneTabs;
    static int graphNameCounter = 0;
    private int m_hwnd = 0;
    public static final int WINDOW_INIT = 50;
    public static final int WINDOW_OFFSET = 25;
    public static final int WINDOW_MAX = 5;
    private static int g_winCount = 0;

    public GraphFrame(SCanvas sCanvas) {
        this(sCanvas, null, null, null);
    }

    public GraphFrame(SCanvas sCanvas, String string, Image image, Point point) {
        if (string == null) {
            string = "Graph Window " + ++graphNameCounter;
        }
        this.setTitle(string);
        if (point == null) {
            point = GraphFrame.getNextWindowLocation();
        }
        this.setDefaultCloseOperation(2);
        this.paneTabs = new CanvasTabbedPane();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)this.paneTabs, "Center");
        this.paneTabs.setActiveCanvas(sCanvas);
        this.paneTabs.addCanvasTab(sCanvas);
        this.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        jMenu.add(this.newMenuItem("Save As...", 'A', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.saveAs(GraphFrame.this, SplusSystem.getCwd());
            }
        }));
        jMenu.add(this.newMenuItem("Print...", 'P', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PrintCommand(GraphFrame.this, GraphFrame.this).doExecute();
            }
        }));
        jMenu.add(this.newMenuItem("Print Setup...", 'U', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PrintSetupCommand().doExecute();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(this.newMenuItem("Close", 'C', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.dispose();
            }
        }));
        jMenu = new JMenu("View");
        jMenu.setMnemonic(86);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Zoom Graph");
        jMenu2.add(this.newMenuItem("Zoom In", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.paneTabs.zoom(1.5);
            }
        }));
        jMenu2.add(this.newMenuItem("Zoom Out", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.paneTabs.zoom(0.6666666865348816);
            }
        }));
        jMenu2.add(this.newMenuItem("Zoom to Rectangle", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.paneTabs.zoomToRect();
            }
        }));
        jMenu2.add(this.newMenuItem("Fit in Window", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.paneTabs.zoomToFrame();
            }
        }));
        jMenu.add(jMenu2);
        jMenu = new JMenu("Options");
        jMenu.setMnemonic(80);
        jMenuBar.add(jMenu);
        jMenu.add(this.newMenuItem("Set Graph Colors...", 'C', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GraphFrame.isLegacyGraphicsMode()) {
                    JOptionPane.showMessageDialog(GraphFrame.this, GraphFrame.getColorSetErrorMsg(), GraphFrame.getColorSetErrorTitle(), 0);
                    return;
                }
                SCanvas sCanvas = GraphFrame.this.paneTabs.getCanvas();
                GraphColorsDialog graphColorsDialog = new GraphColorsDialog((Frame)GraphFrame.this, sCanvas, false);
                graphColorsDialog.show();
            }
        }));
        jMenu.add(this.newMenuItem("Graph Options...", 'G', new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphOptionsDialog graphOptionsDialog = new GraphOptionsDialog(GraphFrame.this);
                graphOptionsDialog.show();
            }
        }));
        this.setJMenuBar(jMenuBar);
        Dimension dimension = null;
        if (sCanvas != null) {
            dimension = new Dimension(sCanvas.getUserSize());
        }
        if (dimension == null || dimension.width < 1 || dimension.height < 1) {
            dimension = new Dimension(520, 390);
        }
        dimension.width = Math.min(1000, Math.max(100, dimension.width));
        dimension.height = Math.min(1000, Math.max(100, dimension.height));
        this.setSize(dimension.width + 10, dimension.height + 60);
        if (image != null) {
            this.setIconImage(image);
        }
        if (point != null) {
            this.setLocation(point);
        }
        this.show();
        if (System.getProperty("splus.use.win32") == null) {
            Dimension dimension2 = this.paneTabs.getCanvasComponent().getSize();
            this.setSize(this.getWidth() + dimension.width - dimension2.width, this.getHeight() + dimension.height - dimension2.height);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            // empty if block
        }
    }

    public void windowCloseBase(WindowEvent windowEvent) {
        int n;
        boolean bl = true;
        if (System.getProperty("splus.use.win32") != null) {
            boolean bl2 = bl = !SplusWinSessionImpl.isWindowsGUIClosing();
        }
        if ((n = this.paneTabs.getDeviceNumber()) > 0) {
            this.paneTabs.unlinkCanvases();
            if (bl) {
                if (SplusSystem.getEngineQueryHandler() != null) {
                    String string = "{dev.off(" + n + ");vector(\"missing\",0)}\n";
                    SplusSystem.getEngineQueryHandler().processDataQuery(string, 5);
                } else {
                    String string = "Closing this window does not close the S-PLUS device.\nExecute dev.off(" + n + ") to close the device.";
                    JOptionPane.showMessageDialog(this, string, "Warning", 2);
                }
            }
        }
        if (System.getProperty("splus.use.win32") != null) {
            SplusWinSessionImpl.setDialogRegister(this.m_hwnd, false);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.windowCloseBase(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (System.getProperty("splus.use.win32") != null) {
            // empty if block
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void show() {
        super.show();
        if (System.getProperty("splus.use.win32") != null) {
            this.m_hwnd = SplusWin32Tools.getHwnd(this);
            SplusWinSessionImpl.setDialogRegister(this.m_hwnd, true);
        }
    }

    public int getNumberOfPages() {
        return this.paneTabs.getTabCount();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return GraphWindow.doPrint(graphics, pageFormat, n, this.paneTabs);
    }

    public File saveAs(Frame frame, File file) {
        return GraphWindow.doSaveAs(frame, file, this.paneTabs);
    }

    public void save() {
    }

    JMenuItem newMenuItem(String string, char c, ActionListener actionListener) {
        JMenuItem jMenuItem = this.newMenuItem(string, actionListener);
        jMenuItem.setMnemonic(c);
        return jMenuItem;
    }

    JMenuItem newMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static Point getNextWindowLocation() {
        int n = 50 + g_winCount % 5 * 25;
        ++g_winCount;
        return new Point(n, n);
    }

    public static void resetNextWindowLocation() {
        g_winCount = 0;
    }

    public static boolean isLegacyGraphicsMode() {
        return SGraphicsDeviceReceiver.isLegacyGraphicsMode();
    }

    public static String getColorSetErrorMsg() {
        return "Either use palette() to change graph colors or call use.legacy.graphics(T)";
    }

    public static String getColorSetErrorTitle() {
        return "Change Colors Error";
    }
}

