/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.connection;

import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.rmi.RemoteException;
import java.util.StringTokenizer;

public class ConsoleOutputHandler
implements SplusOutputHandler {
    public static final String MENU_PROMPT = "Selection: ";
    public static final String INITIAL_PROMPT = ConsoleHistoryDocument.PREFIX[0];
    public static final String CONTINUE_PROMPT = ConsoleHistoryDocument.PREFIX[1];
    public static final String CONTINUE_STRING_PROMPT = ConsoleHistoryDocument.PREFIX[2];
    String m_unfinishedBusiness = "";

    public ConsoleOutputHandler(ConsoleHistoryDocument consoleHistoryDocument) throws RemoteException {
    }

    public void pollPreexistingEngineOutput(DefaultConnection defaultConnection) {
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        consoleHistoryDocument.pollForOutput(defaultConnection);
    }

    public void reset() {
        this.m_unfinishedBusiness = "";
    }

    public static void staticWrite(String string, boolean bl) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            ((DefaultConnection)noConnection).getOutputHandler().write(string, bl);
        }
    }

    public void write(String string, boolean bl) {
        try {
            if (string.equals(CONTINUE_STRING_PROMPT)) {
                return;
            }
            ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
            if (consoleHistoryDocument.sendToOutput()) {
                if (string.equals(INITIAL_PROMPT)) {
                    this.m_unfinishedBusiness = string;
                } else {
                    String string2 = this.m_unfinishedBusiness + string;
                    String string3 = string2.replaceAll("\r", "").replaceAll("\n", ConsoleHistoryDocument.g_lineDelimiter);
                    consoleHistoryDocument.storeSplusOutput(string3);
                    this.m_unfinishedBusiness = "";
                }
                return;
            }
            if (string.equals(INITIAL_PROMPT) || string.equals(CONTINUE_PROMPT)) {
                return;
            }
            String string4 = this.m_unfinishedBusiness + string;
            if (string4.equals(MENU_PROMPT)) {
                string4 = MENU_PROMPT + ConsoleHistoryDocument.g_lineDelimiter;
            }
            this.m_unfinishedBusiness = "";
            String string5 = string4.replaceAll("\r", "");
            boolean bl2 = string5.endsWith("\n");
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "\n", true);
            boolean bl3 = false;
            boolean bl4 = true;
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl5;
                String string6 = stringTokenizer.nextToken();
                boolean bl6 = bl5 = !stringTokenizer.hasMoreTokens();
                if (string6.equals("\n")) {
                    if (bl3 || bl4) {
                        consoleHistoryDocument.storeSplusOutput(ConsoleHistoryDocument.g_lineDelimiter);
                    }
                    bl3 = true;
                } else {
                    if (bl5 && !bl2) {
                        this.m_unfinishedBusiness = string6;
                    } else {
                        consoleHistoryDocument.storeSplusOutput(string6 + ConsoleHistoryDocument.g_lineDelimiter);
                    }
                    bl3 = false;
                }
                bl4 = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String stripTrailingPrompts() {
        String string = this.m_unfinishedBusiness;
        if (string == null) {
            return "";
        }
        int n = string.length();
        while (string.endsWith(INITIAL_PROMPT) || string.endsWith(CONTINUE_PROMPT)) {
            string = string.substring(0, n -= 2);
        }
        return string;
    }

    public void flush() {
        String string = this.stripTrailingPrompts();
        if (string.length() > 0) {
            ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
            consoleHistoryDocument.storeSplusOutput(string + "\n");
        }
        this.m_unfinishedBusiness = "";
    }
}

