/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.preferences.SplusOutlinePreferencePage;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastSplusPartitionParser {
    private static final String SPLUS_IDENTIFIER = "__java_identifier";
    private static final String SPLUS_WORD = "__java_word";
    private static final String SPLUS_SCOPE = "__java_scope";
    private static final String SPLUS_FUNCTION = "__java_function";
    private static final String SPLUS_WATCH = "__java_watch";
    private static final String SPLUS_VARIABLE = "__java_variable";
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");
    public static final String ANONYMOUS_FXN_STR = "anonymousFunction";
    private static final int SPLUS = 0;
    private static final int IDENTIFIER = 1;
    private static final int WORD = 2;
    private static final int SCOPE = 3;
    private static final int FUNCTION = 4;
    private static final int VARIABLE = 5;
    private static final int WATCH = 6;
    private int lineNum = -1;
    private int colNum = 1;
    private int chNum = 1;
    private int ch_index = 0;
    private int anonymousFunctionNum = 0;
    private String fContents;
    private static final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__java_identifier"), new Token((Object)"__java_word"), new Token((Object)"__java_function"), new Token((Object)"__java_scope"), new Token((Object)"__java_variable"), new Token((Object)"__java_watch")};
    public static String[] defaultWatchFunctions = new String[]{"setMethod", "setClass", "setReplaceMethod", "setAs", "setIs", "setValidity", "setGeneric", "setGroup", "setGroupGeneric", "setClassPrototype"};
    private String[] watchFunctions = SplusOutlinePreferencePage.getWatchFunctions();

    public FastSplusPartitionParser(IDocument iDocument) {
        try {
            this.init(iDocument.get(0, iDocument.getLength()), 0);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public FastSplusPartitionParser(String string) {
        this.init(string, 0);
    }

    protected void init(String string, int n) {
        this.fContents = string.substring(n);
    }

    public Vector getSplusOutline() {
        FileDescription fileDescription = new FileDescription(this.fContents);
        this.handleScope(fileDescription, false, false, false);
        return fileDescription.fWordsVec;
    }

    public boolean isWatchedMethod(String string) {
        for (int i = 0; i < this.watchFunctions.length; ++i) {
            if (!this.watchFunctions[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String handleWatchMethod() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (this.ch_index < this.fContents.length()) {
                char c = this.fContents.charAt(this.ch_index++);
                stringBuffer.append(c);
                if (c == '(') {
                    ++n;
                }
                if (c != ')' || --n != 0) continue;
                break;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void handleScope(WordDescription wordDescription, boolean bl, boolean bl2, boolean bl3) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            Object var7_8 = null;
            boolean bl4 = true;
            int n = -1;
            int n2 = -1;
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            int n6 = 1;
            boolean bl5 = wordDescription.isFunction();
            HashMap hashMap = bl5 ? ((FunctionDescription)wordDescription).fWordsMap : ((FileDescription)wordDescription).fWordsMap;
            Vector vector = bl5 ? ((FunctionDescription)wordDescription).fWordsVec : ((FileDescription)wordDescription).fWordsVec;
            HashMap<String, WordDescription> hashMap2 = bl5 ? ((FunctionDescription)wordDescription).fArgsMap : new HashMap<String, WordDescription>();
            Vector<WordDescription> vector2 = bl5 ? ((FunctionDescription)wordDescription).fArgsVec : new Vector<WordDescription>();
            Stack<ScopeDescription> stack = new Stack<ScopeDescription>();
            ScopeDescription scopeDescription = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = true;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = bl3;
            boolean bl12 = bl3 && bl2;
            boolean bl13 = false;
            int n7 = bl2 ? 1 : 0;
            int n8 = bl ? 1 : 0;
            boolean bl14 = false;
            boolean bl15 = false;
            int n9 = -1;
            int n10 = 0;
            int n11 = 0;
            while (bl4 && this.ch_index < this.fContents.length()) {
                boolean bl16;
                boolean bl17;
                char c = this.fContents.charAt(this.ch_index++);
                if (n9 != -1) {
                    ++n9;
                }
                boolean bl18 = bl17 = !bl14 && (bl10 || bl9);
                if (!bl17 || c == '\'' || c == '\"') {
                    switch (c) {
                        case '#': {
                            bl14 = true;
                            break;
                        }
                        case '\n': {
                            if (n10 == 13) {
                                --this.lineNum;
                            }
                        }
                        case '\r': {
                            bl14 = false;
                            this.colNum = 0;
                            ++this.lineNum;
                            break;
                        }
                        case '_': {
                            n9 = 0;
                            break;
                        }
                        case '=': {
                            n9 = n10 != 61 && n10 != 33 && n10 != 60 && n10 != 62 ? 0 : -1;
                            break;
                        }
                        case '-': {
                            if (n10 != 60) break;
                            n9 = 0;
                            break;
                        }
                        case '{': {
                            bl8 = false;
                            if (bl14) break;
                            if (++n8 > 1 || n8 == 1 && wordDescription.isFile()) {
                                if (bl7 && scopeDescription != null) {
                                    stack.push(scopeDescription);
                                } else {
                                    ScopeDescription scopeDescription2 = stack.size() == 0 ? (ScopeDescription)wordDescription : (ScopeDescription)stack.peek();
                                    stack.push(new ScopeDescription(this.fContents, this.lineNum, this.colNum, this.chNum, bl6, bl7));
                                    scopeDescription2.addScope((ScopeDescription)stack.peek());
                                }
                            }
                            bl7 = false;
                            bl6 = false;
                            break;
                        }
                        case '}': {
                            if (bl14) break;
                            if (--n8 == 0 && bl5) {
                                ++this.chNum;
                                if (wordDescription.isFunction()) {
                                    ((FunctionDescription)wordDescription).setCodeEnd(this.chNum);
                                }
                                return;
                            }
                            if (n8 <= 0) break;
                            ScopeDescription scopeDescription3 = (ScopeDescription)stack.pop();
                            scopeDescription3.setCodeEnd(this.chNum - 1);
                            scopeDescription = scopeDescription3;
                            break;
                        }
                        case '(': {
                            if (bl14) break;
                            bl12 = true;
                            ++n7;
                            break;
                        }
                        case ')': {
                            if (bl14 || n10 != 40 || --n7 != n11) break;
                            bl11 = false;
                            bl12 = false;
                            break;
                        }
                        case '\uffffffff': {
                            bl4 = false;
                            break;
                        }
                        case ',': {
                            bl13 = false;
                            break;
                        }
                        case '\"': {
                            if (bl14 || bl10) break;
                            if (!bl9) {
                                bl9 = true;
                                break;
                            }
                            bl9 = n10 == 92;
                            break;
                        }
                        case '\'': {
                            if (bl14 || bl9) break;
                            if (!bl10) {
                                bl10 = true;
                                break;
                            }
                            bl10 = n10 == 92;
                            break;
                        }
                        case '\t': 
                        case ' ': 
                        case '!': 
                        case '$': 
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '/': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '@': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '|': {
                            if (!bl9 && !bl10) break;
                        }
                        default: {
                            bl17 = !bl14;
                        }
                    }
                }
                boolean bl19 = bl16 = c == '\"' && n10 == 34;
                if (bl5 && bl8 && !bl11 && bl17) {
                    if (!bl16) {
                        --this.ch_index;
                    } else {
                        ++this.chNum;
                    }
                    return;
                }
                if (bl17) {
                    if (stringBuffer.length() == 0) {
                        n6 = this.chNum;
                        n4 = this.colNum;
                        n2 = this.lineNum;
                    }
                    stringBuffer.append(c);
                } else if (stringBuffer.length() != 0 || bl16) {
                    boolean bl20;
                    String string = stringBuffer2.toString();
                    String string2 = stringBuffer.toString();
                    WordDescription wordDescription2 = null;
                    if (!(!string2.equals("function") || string2.startsWith("\"") || string2.endsWith("\"") || bl9 || bl10)) {
                        boolean bl21 = false;
                        if (n9 <= 0) {
                            string = ANONYMOUS_FXN_STR + Integer.toString(++this.anonymousFunctionNum);
                            n = n2;
                            n3 = n4;
                            n5 = n6;
                            bl21 = true;
                        }
                        wordDescription2 = new FunctionDescription(this.fContents, string, fTokens[4], n, n3, n5, bl21);
                        bl11 = true;
                    } else if (bl11 && bl5) {
                        if (!bl13) {
                            FunctionDescription functionDescription = (FunctionDescription)wordDescription;
                            wordDescription2 = null;
                            if (n9 == 0) {
                                wordDescription2 = null;
                            } else if (n9 > 0) {
                                if (!hashMap2.containsKey(string)) {
                                    wordDescription2 = new WordDescription(this.fContents, string, fTokens[5], n, n3, n5);
                                    hashMap2.put(string, wordDescription2);
                                }
                            } else if (!hashMap2.containsKey(string2)) {
                                wordDescription2 = new WordDescription(this.fContents, string2, fTokens[5], n2, n4, n6);
                                hashMap2.put(string2, wordDescription2);
                                boolean bl22 = bl13 = c != ',';
                            }
                            if (wordDescription2 != null) {
                                vector2.add(wordDescription2);
                            }
                            wordDescription2 = null;
                        }
                    } else if (!(string.length() == 0 || n9 <= 0 || bl11 || bl12 && (c != '(' || n7 != n11 + 1) || hashMap2.containsKey(string))) {
                        wordDescription2 = new WordDescription(this.fContents, string, fTokens[5], n, n3, n5);
                        bl15 = false;
                        n9 = -1;
                    }
                    if (wordDescription2 != null && !hashMap.containsKey(string)) {
                        hashMap.put(string, wordDescription2);
                        vector.add(wordDescription2);
                    }
                    if (wordDescription2 != null && wordDescription2 instanceof FunctionDescription) {
                        --this.ch_index;
                        if (c == '(') {
                            --n7;
                        } else if (c == '{') {
                            --n8;
                        }
                        this.handleScope(wordDescription2, false, false, true);
                        bl11 = false;
                        --this.chNum;
                    }
                    if (n7 == n11) {
                        bl12 = false;
                        if (bl11) {
                            bl11 = false;
                        }
                    }
                    if (!(bl12 && (n7 != n11 + 1 || c != '(') || bl16 || c == ')' || (bl20 = string2.equals("if")) && bl7)) {
                        bl7 = string2.equals("else");
                        bl6 = bl20;
                    }
                    if (this.isWatchedMethod(string2) && c == '(') {
                        --this.ch_index;
                        String string3 = this.handleWatchMethod();
                        String string4 = string2 + string3;
                        WatchDescription watchDescription = new WatchDescription(this.fContents, string4, fTokens[6], n2, n4, n6, false);
                        hashMap.put(string4, watchDescription);
                        vector.add(watchDescription);
                        this.ch_index -= string3.length() - 1;
                    }
                    if (stringBuffer.length() != 0 || bl16) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(bl16 ? "" : stringBuffer.toString());
                        n = n2;
                        n3 = n4;
                        n5 = n6;
                        stringBuffer.setLength(0);
                        if (n9 != 0) {
                            n9 = -1;
                        }
                    }
                }
                n10 = c;
                ++this.chNum;
                ++this.colNum;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class WatchDescription
    extends FunctionDescription {
        public WatchDescription(String string, String string2, IToken iToken, int n, int n2, int n3, boolean bl) {
            super(string, string2, iToken, n, n2, n3, bl);
        }

        public int getLength() {
            return this.fWord.length();
        }

        public boolean isFunction() {
            return true;
        }
    }

    public static class FunctionDescription
    extends ScopeDescription {
        public Vector fArgsVec = new Vector();
        public HashMap fArgsMap = new HashMap();
        public Vector fWordsVec = new Vector();
        public HashMap fWordsMap = new HashMap();
        public boolean fAnon;

        public FunctionDescription(String string, String string2, IToken iToken, int n, int n2, int n3, boolean bl) {
            super(string, string2, iToken, n, n2, n3);
            this.fAnon = bl;
        }

        public int getLength() {
            if (this.fAnon) {
                return "function".length();
            }
            return this.fWord.length();
        }
    }

    public static class FileDescription
    extends ScopeDescription {
        public Vector fWordsVec = new Vector();
        public HashMap fWordsMap = new HashMap();

        public FileDescription(String string) {
            super(string, "", fTokens[0], 0, 0, 0);
        }

        public ScopeDescription addScope(ScopeDescription scopeDescription) {
            ScopeDescription scopeDescription2 = super.addScope(scopeDescription);
            if (!this.fWordsMap.containsKey(scopeDescription2.fWord)) {
                this.fWordsVec.add(scopeDescription2);
                this.fWordsMap.put(scopeDescription2.fWord, scopeDescription2);
            }
            return scopeDescription2;
        }
    }

    public static class ScopeDescription
    extends WordDescription {
        public Vector fInnerScope = new Vector();
        public boolean fIf;
        public boolean fElse;
        private static int scopeNum = 0;

        public ScopeDescription(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
            this(string, "scope" + Integer.toString(++scopeNum), fTokens[3], n, n2, n3);
            this.fIf = bl;
            this.fElse = bl2;
        }

        protected ScopeDescription(String string, String string2, IToken iToken, int n, int n2, int n3) {
            super(string, string2, iToken, n, n2, n3);
        }

        public ScopeDescription addScope(ScopeDescription scopeDescription) {
            this.fInnerScope.add(scopeDescription);
            return scopeDescription;
        }

        public int getCodeLength() {
            if (this.fCodeEnd == 0) {
                return 0;
            }
            return this.fCodeEnd - this.fChNum;
        }
    }

    public static class WordDescription {
        public String fCode;
        public int fChNum;
        public int fCodeEnd;
        public int fColNum;
        public int fLineNum;
        public IToken fType;
        public String fWord;

        public WordDescription(String string, String string2, IToken iToken, int n, int n2, int n3) {
            this.fType = iToken;
            this.fLineNum = n;
            this.fColNum = n2;
            this.fChNum = n3;
            this.fCode = string;
            String string3 = string2;
            while (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            while (string3.startsWith("\"")) {
                string3 = string3.substring(1);
                ++this.fChNum;
            }
            this.fWord = string3;
        }

        public void setCodeEnd(int n) {
            this.fCodeEnd = n;
        }

        public boolean isWatch() {
            return this.fType == fTokens[6];
        }

        public boolean isFunction() {
            return this.fType == fTokens[4];
        }

        public boolean isFile() {
            return this.fType == fTokens[0];
        }

        public boolean isScope() {
            return this.fType == fTokens[3];
        }

        public boolean isVariable() {
            return this.fType == fTokens[5];
        }

        public String toString() {
            return this.fWord;
        }

        public Position getPosition() {
            return new Position(this.fChNum);
        }

        public int getLength() {
            return this.fWord.length();
        }

        public int getCodeLength() {
            return this.getLength();
        }
    }
}

