/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExternalFileEditorInput
extends Resource
implements IPathEditorInput,
ILocationProvider,
IResource {
    public static final String FXN_MARKER = "com.insightful.splus.eclipse.editors.spluseditor.util.JavaEditorInput.function";
    private String fFxnPrefix;
    private File fFile;
    private WorkbenchAdapter fWorkbenchAdapter;
    private IWorkspaceRoot fWorkspaceRoot;

    public ExternalFileEditorInput(File file) {
        super((IPath)new Path(file.getAbsolutePath()), (Workspace)ResourcesPlugin.getWorkspace());
        this.fFile = file;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        HashMap hashMap = new HashMap();
        String string = SplusParseTreeBuilder.toString(file);
        PObject pObject = SplusParseTreeBuilder.getInstance().getParseTree(string);
        SplusParseTreeBuilder.getFunctionsDefined(pObject, hashMap);
        Object[] objectArray = hashMap.keySet().toArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        this.fFxnPrefix = stringBuffer.toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFile.getAbsolutePath();
    }

    public Object getAdapter(Class clazz) {
        if (IResource.class.equals((Object)clazz)) {
            return this;
        }
        if (ILocationProvider.class.equals((Object)clazz)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals((Object)clazz)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    public IPath getPath(Object object) {
        if (object instanceof ExternalFileEditorInput) {
            return ((ExternalFileEditorInput)((Object)object)).getPath();
        }
        return null;
    }

    public IPath getPath() {
        return new Path(this.fFile.getAbsolutePath());
    }

    public int hashCode() {
        return this.fFile.hashCode();
    }

    public int getType() {
        return 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ExternalFileEditorInput) {
            ExternalFileEditorInput externalFileEditorInput = (ExternalFileEditorInput)((Object)object);
            return this.fFile.equals(externalFileEditorInput.fFile);
        }
        if (object instanceof IPathEditorInput) {
            IPathEditorInput iPathEditorInput = (IPathEditorInput)object;
            return this.getPath().equals(iPathEditorInput.getPath());
        }
        return false;
    }

    public boolean exists() {
        return this.fFile.exists();
    }

    public IMarker createMarker(String string) throws CoreException {
        IMarker iMarker = this.fWorkspaceRoot.createMarker(string);
        iMarker.setAttribute(FXN_MARKER, (Object)this.fFxnPrefix);
        return iMarker;
    }

    public boolean isMarkerApplicable(IMarker iMarker) {
        return iMarker.getAttribute(FXN_MARKER, "").equals(this.fFxnPrefix);
    }

    public IMarker[] filterMarkers(IMarker[] iMarkerArray) {
        Vector<IMarker> vector = new Vector<IMarker>();
        for (int i = 0; i < iMarkerArray.length; ++i) {
            if (!this.isMarkerApplicable(iMarkerArray[i])) continue;
            vector.add(iMarkerArray[i]);
        }
        IMarker[] iMarkerArray2 = new IMarker[vector.size()];
        vector.toArray(iMarkerArray2);
        return iMarkerArray2;
    }

    public IMarker[] findMarkers(String string, boolean bl, int n) throws CoreException {
        return this.filterMarkers(this.fWorkspaceRoot.findMarkers(string, bl, n));
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object object) {
            return ((ExternalFileEditorInput)((Object)object)).getName();
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

