/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.core.ParseException;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreeMarkerView
extends AbstractTemplateView {
    private String encoding;
    private Configuration configuration;
    private ServletContextHashModel servletContextHashModel;
    private TaglibFactory taglibFactory;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getConfiguration() != null) {
            this.taglibFactory = new TaglibFactory(this.getServletContext());
        } else {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
            this.taglibFactory = config.getTaglibFactory();
        }
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)new GenericServletAdapter(this.getServletContext()), ObjectWrapper.DEFAULT_WRAPPER);
        this.checkTemplate();
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors(this.getApplicationContext(), class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig == null ? (class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig = FreeMarkerView.class$("org.springframework.web.servlet.view.freemarker.FreeMarkerConfig")) : class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig, true, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", ex);
        }
    }

    protected void checkTemplate() throws ApplicationContextException {
        try {
            this.getTemplate(this.getConfiguration().getLocale());
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", ex);
        }
    }

    protected void renderMergedTemplateModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeHelpers(model, request);
        this.doRender(model, request, response);
    }

    protected void exposeHelpers(Map model, HttpServletRequest request) throws Exception {
    }

    protected void doRender(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        model.put("Application", this.servletContextHashModel);
        model.put("JspTaglibs", this.taglibFactory);
        model.put("Request", new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering FreeMarker template [" + this.getUrl() + "] in FreeMarkerView '" + this.getBeanName() + "'"));
        }
        Locale locale = RequestContextUtils.getLocale(request);
        this.processTemplate(this.getTemplate(locale), model, response);
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.getTemplate(this.getUrl(), locale);
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        return this.getEncoding() != null ? this.getConfiguration().getTemplate(name, locale, this.getEncoding()) : this.getConfiguration().getTemplate(name, locale);
    }

    protected void processTemplate(Template template, Map model, HttpServletResponse response) throws IOException, TemplateException {
        template.process((Object)model, (Writer)response.getWriter());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class GenericServletAdapter
    extends GenericServlet {
        private final ServletContext servletContext;

        public GenericServletAdapter(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }
    }
}

