/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ChartDialog;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.TwoDimChartEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;

public class ChartNodeModel
extends ActivityNodeModel {
    private boolean m_boxPlotCalculated = false;

    public ChartNodeModel(Element elt) {
        super(elt);
    }

    public ChartNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        ChartDialog dialog = ChartDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public boolean postDialogEqualityCheck(XTProps oldProps, XTProps newProps) {
        String[] removeProperty = new String[]{ChartEngineNode.m_chartTypes[ChartEngineNode.BARCHART_POS]};
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.m_chartTypes[ChartEngineNode.PIECHART_POS];
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.m_chartTypes[ChartEngineNode.DOTCHART_POS];
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.m_chartTypes[ChartEngineNode.COLUMNCHART_POS];
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.m_chartTypes[ChartEngineNode.DOTCHART_POS];
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.SHOW_STATISTICS_TAG;
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.SHOW_PERCENTS_TAG;
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        removeProperty[0] = ChartEngineNode.RELATIVE_TAG;
        oldProps.removeProperty(removeProperty);
        newProps.removeProperty(removeProperty);
        return oldProps.equals(newProps);
    }

    public boolean isPropertiesValid() {
        XTProps props = this.getXTProps();
        Vector display = props.getSubProperties(ChartEngineNode.DISPLAY_ATTRIBUTE_TAG);
        Vector groupby = props.getSubProperties(ChartEngineNode.GROUPBY_ATTRIBUTE_TAG);
        try {
            if (this.isInputValid()) {
                int i;
                XTMetaData md = this.getInputMetaData(0);
                for (i = display.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)display.get(i)) != -1) continue;
                    return false;
                }
                for (i = groupby.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)groupby.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return display != null && display.size() != 0;
    }

    public void showView(Frame frame) throws OutOfMemoryError {
        int numBins;
        XTProps dialogProps = this.getXTProps();
        XTMetaData metaData = null;
        XTProps chartStats = null;
        try {
            metaData = this.getInputMetaData(0);
            Object obj = this.sendMessageToEngine("getNodeCacheXTProps", new Object[]{TwoDimChartEngineNode.BIN_COUNT_CACHE_FILENAME});
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            if (obj instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)obj;
            }
            chartStats = (XTProps)obj;
            obj = this.sendMessageToEngine("getBinCount", new Object[0]);
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            if (obj instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)obj;
            }
            numBins = (Integer)obj;
        }
        catch (Exception e) {
            Throwable obj = e.getCause();
            if (obj instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)obj;
            }
            return;
        }
        numBins = dialogProps.getInt(ChartEngineNode.NUM_BARS_ATTRIBUTE_TAG, ChartEngineNode.NUM_BARS_DEFAULT);
        Vector displayColumns = this.getColumns(dialogProps, metaData, ChartEngineNode.DISPLAY_ATTRIBUTE_TAG);
        Vector byColumns = this.getColumns(dialogProps, metaData, ChartEngineNode.GROUPBY_ATTRIBUTE_TAG);
        if (displayColumns.size() == 0) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("ChartNodeModel_message_validDisplayColumns"));
            return;
        }
        ChartBuilder chartBuilder = new ChartBuilder(metaData, chartStats);
        int catChartType = 0;
        int contChartType = 0;
        boolean[] executeChartType = new boolean[ChartEngineNode.m_chartTypes.length];
        for (int i = 0; i < executeChartType.length; ++i) {
            executeChartType[i] = dialogProps.getBoolean(ChartEngineNode.m_chartTypes[i], false);
        }
        contChartType = this.getContinuousChartType(executeChartType);
        catChartType = this.getCategoricalChartType(executeChartType);
        boolean showPercents = dialogProps.getBoolean(ChartEngineNode.SHOW_PERCENTS_TAG, false);
        boolean relative = dialogProps.getBoolean(ChartEngineNode.RELATIVE_TAG, true);
        int result = chartBuilder.setDisplayInfo(contChartType, catChartType, displayColumns, byColumns, numBins, this.getShowStats(), showPercents, relative);
        if (result != -1) {
            try {
                chartBuilder.displayCharts(this.getLabelText());
            }
            catch (OutOfMemoryError oom) {
                chartBuilder.clearMemory();
                chartBuilder = null;
            }
        }
    }

    protected boolean getShowStats() {
        return this.getXTProps().getBoolean(ChartEngineNode.SHOW_STATISTICS_TAG, false);
    }

    protected int getContinuousChartType(boolean[] executeChartType) {
        if (executeChartType[ChartEngineNode.BOXPLOT_POS]) {
            return 1;
        }
        return 0;
    }

    protected int getCategoricalChartType(boolean[] executeChartType) {
        if (executeChartType[ChartEngineNode.DOTCHART_POS]) {
            return 2;
        }
        if (executeChartType[ChartEngineNode.PIECHART_POS]) {
            return 4;
        }
        if (executeChartType[ChartEngineNode.COLUMNCHART_POS]) {
            return 5;
        }
        return 3;
    }

    protected Vector getColumns(XTProps dialogProps, XTMetaData inputMD, String name) {
        Vector cols = dialogProps.getSubProperties(name);
        try {
            int numCols = cols.size();
            for (int i = numCols - 1; i >= 0; --i) {
                if (!inputMD.isStringColumn((String)cols.get(i))) continue;
                cols.remove(i);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cols;
    }
}

