/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.tree.gui.ColorBroker;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColumnHeaderPanel
extends JPanel
implements ActionListener {
    private Object colOrRow = null;
    private boolean objectIsString = false;
    private int columnIndex = 0;
    public static final String DRILLDOWN_ACTION_COMMAND = "DRILLDOWN";
    private JMenuItem drillDown = null;
    private JPopupMenu popup;
    private int borderWidth = 1;
    private ChartBuilder chartBuilder = null;

    public ColumnHeaderPanel(ChartBuilder cb) {
        this.setRequestFocusEnabled(true);
        this.chartBuilder = cb;
        this.popup = this.createPopupMenu();
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) == 16) {
                    if (e.getClickCount() == 2) {
                        ColumnHeaderPanel.this.handleDoubleClick();
                    } else {
                        ColumnHeaderPanel.this.handleLeftClick(e);
                    }
                } else if ((e.getModifiers() & 4) == 4) {
                    ColumnHeaderPanel.this.handleRightClick(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
    }

    public void setSelectedColumn(String name) {
        this.colOrRow = name;
        this.objectIsString = true;
    }

    public void setRowSpecifier(Hashtable groupBySpecification, int colIndex) {
        this.colOrRow = groupBySpecification;
        this.columnIndex = colIndex;
        this.objectIsString = false;
    }

    public Object getColOrRow() {
        return this.colOrRow;
    }

    public boolean isColumn() {
        return this.objectIsString;
    }

    public void setVariableWidthBorder(Color color, int strokeWidth) {
        this.borderWidth = strokeWidth;
        this.setBorder(BorderFactory.createLineBorder(color, strokeWidth));
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    protected JPopupMenu createPopupMenu() {
        MinerPopupMenu result = new MinerPopupMenu("Chart:");
        this.drillDown = new JMenuItem(ChartBuilder.getText("clusterFrame_viewcharts"));
        this.drillDown.setActionCommand(DRILLDOWN_ACTION_COMMAND);
        this.drillDown.addActionListener(this);
        result.add(this.drillDown);
        return result;
    }

    private void handleDoubleClick() {
        this.chartBuilder.showDrillDownCharts();
    }

    private void handleLeftClick(MouseEvent e) {
        this.chartBuilder.selectRowOrColumn(this, e.isShiftDown() || e.isControlDown());
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartSelectionColor"), this.getBorderWidth()));
        this.repaint();
    }

    private void handleRightClick(MouseEvent e) {
        if (this.popup != null) {
            this.popup.show(this, e.getX(), e.getY());
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(DRILLDOWN_ACTION_COMMAND)) {
            this.chartBuilder.showDrillDownCharts();
        }
    }
}

