/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.ChartBuilder;
import com.insightful.miner.DataCacheFileReader;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.MinerRandom;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class EngineNode {
    private DataCacheFileReader[][] m_cacheFileReaders = null;
    private Thread m_chartStat_updateMonitor = null;
    private ChartBuilder m_chartStat_chartBuilder;
    private String m_chartStat_title;
    private Object[] m_chartStat_args = null;
    private int m_chartStat_nodeViewerID = 0;
    protected static final int CNKPROC_EXEC_TYPE = 0;
    protected static final int DATA_CACHE_EXEC_TYPE = 1;
    protected static final int MULTI_PHASE_EXEC_TYPE = 2;
    private ProgressUpdater m_progressUpdater = null;
    private String m_nodeID = null;
    private EngineNetworkManager m_networkManager = null;
    private EngineNode m_phaseParentNode = null;
    private Object m_execPauseObject = new Object();
    private boolean m_execPause = false;

    protected EngineNode() {
    }

    public String getNodeID() {
        return this.m_nodeID;
    }

    public EngineNode getNode(String nodeID) {
        return this.getNetworkManager().getNode(nodeID);
    }

    protected EngineNetworkManager getNetworkManager() {
        return this.m_networkManager;
    }

    protected void setNodeID(String nodeID) {
        this.m_nodeID = nodeID;
    }

    protected void setNetworkManager(EngineNetworkManager mgr) {
        this.m_networkManager = mgr;
    }

    public String getNodeName() {
        return this.m_networkManager.getNodeName(this.getNodeID());
    }

    protected boolean getIsTypeRegression() {
        return true;
    }

    protected String getWorksheetID() {
        return this.getNetworkManager().getWorksheetID();
    }

    public String getInputNodeName(int inputNum) {
        return this.m_networkManager.getInputNodeName(this.getNodeID(), inputNum);
    }

    public String getInputNodeID(int inputNum) {
        return this.m_networkManager.getInputNodeID(this.getNodeID(), inputNum);
    }

    public boolean hasInputNode(int inputNum) {
        return this.m_networkManager.hasInputNode(this.getNodeID(), inputNum);
    }

    public XTMetaData getInputMetaData(int inputNum) {
        return this.m_networkManager.getInputMetaData(this.getNodeID(), inputNum);
    }

    public XTMetaData[] getAllInputMetaData() {
        int numInputs = this.getNumInputs();
        XTMetaData[] val = new XTMetaData[numInputs];
        for (int i = 0; i < numInputs; ++i) {
            val[i] = this.getInputMetaData(i);
        }
        return val;
    }

    public XTMetaData getOutputMetaData(int outputNum) {
        return this.m_networkManager.getOutputMetaData(this.getNodeID(), outputNum);
    }

    public XTMetaData[] getAllOutputMetaData() {
        int numOutputs = this.getNumOutputs();
        XTMetaData[] val = new XTMetaData[numOutputs];
        for (int i = 0; i < numOutputs; ++i) {
            val[i] = this.getOutputMetaData(i);
        }
        return val;
    }

    public XMLTree getNodeCache(String cacheName) {
        return this.m_networkManager.getNodeCache(this.getNodeID(), cacheName);
    }

    public XTProps getNodeCacheXTProps(String cacheName) {
        return this.m_networkManager.getNodeCacheXTProps(this.getNodeID(), cacheName);
    }

    public XTMetaData getNodeCacheXTMetaData(String cacheName) {
        return this.m_networkManager.getNodeCacheXTMetaData(this.getNodeID(), cacheName);
    }

    public void setNodeCache(String cacheName, XMLTree newValue) {
        this.m_networkManager.setNodeCache(this.getNodeID(), cacheName, newValue);
    }

    public Set getNodeCacheNames() {
        return this.m_networkManager.getNodeCacheNames(this.getNodeID());
    }

    public XTProps getNodeProperties() {
        return this.m_networkManager.getNodeProperties(this.getNodeID());
    }

    private void setNodeProperties(XTProps arg) throws Exception {
        this.m_networkManager.setNodeProperties(this.getNodeID(), arg);
    }

    protected String getModelFileName() {
        return this.m_networkManager.getNodeCacheFileName(this.getNodeID(), "model");
    }

    protected XMLTree getModel() {
        return this.m_networkManager.getModel(this.getNodeID());
    }

    protected void setModel(XMLTree model) throws Exception {
        this.m_networkManager.setModel(this.getNodeID(), model);
    }

    public int getMaxRowsPerBlock() {
        return this.m_networkManager.getMaxRowsPerBlock(this.getNodeID());
    }

    public boolean getUseCache() {
        return this.m_networkManager.getUseCache(this.getNodeID());
    }

    public int getNumInputs() {
        return this.m_networkManager.getNumInputs(this.getNodeID());
    }

    public int getNumOutputs() {
        return this.m_networkManager.getNumOutputs(this.getNodeID());
    }

    public boolean isValid() {
        return this.m_networkManager.isValid(this.getNodeID());
    }

    public boolean isInterruptRequested() {
        return this.m_networkManager.isInterruptRequested();
    }

    public void printDebug(String msg) {
        this.m_networkManager.printDebug(msg);
    }

    public void printlnDebug(String msg) {
        this.m_networkManager.printlnDebug(msg);
    }

    public void printVerbose(String msg) {
        this.m_networkManager.printVerbose(msg);
    }

    public void printlnVerbose(String msg) {
        this.m_networkManager.printlnVerbose(msg);
    }

    public void printInformation(String msg) {
        this.m_networkManager.printInformation(msg);
    }

    public void printlnInformation(String msg) {
        this.m_networkManager.printlnInformation(msg);
    }

    public void printWarning(String msg) {
        this.m_networkManager.printWarning(msg);
    }

    public void printlnWarning(String msg) {
        this.m_networkManager.printlnWarning(msg);
    }

    public void printError(String msg) {
        this.m_networkManager.printError(msg);
    }

    public void printlnError(String msg) {
        this.m_networkManager.printlnError(msg);
    }

    public String getAbsolutePath(String filePath) {
        return this.m_networkManager.getAbsolutePath(filePath);
    }

    public String getWorksheetDirPath() {
        return this.m_networkManager.getWorksheetDirPath();
    }

    public File createWorkspaceTempFile(String prefix, String suffix) throws IOException {
        File dirFile = this.m_networkManager == null ? null : new File(this.m_networkManager.getWorksheetDirPath());
        File tempFile = File.createTempFile(prefix, suffix, dirFile);
        return tempFile;
    }

    public void invalidateNodeState() {
    }

    protected void closeDataViewerFiles() {
        DataCacheFileReader rdr = null;
        if (this.m_cacheFileReaders == null) {
            return;
        }
        for (int io = 0; io < 2; ++io) {
            for (int i = 0; i < this.m_cacheFileReaders[io].length; ++i) {
                rdr = this.m_cacheFileReaders[io][i];
                if (rdr == null) continue;
                try {
                    rdr.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
                rdr = null;
            }
        }
        this.m_cacheFileReaders = null;
    }

    private DataCacheFileReader getReader(int portIndex, boolean isInput) {
        int io;
        DataCacheFileReader rdr = null;
        String filename = null;
        int numPorts = isInput ? this.getNumInputs() : this.getNumOutputs();
        int n = io = isInput ? 0 : 1;
        if (!this.isValid() || portIndex >= numPorts) {
            return null;
        }
        if (this.m_cacheFileReaders == null) {
            this.m_cacheFileReaders = new DataCacheFileReader[2][];
            this.m_cacheFileReaders[0] = new DataCacheFileReader[this.getNumInputs()];
            this.m_cacheFileReaders[1] = new DataCacheFileReader[this.getNumOutputs()];
        }
        if (this.m_cacheFileReaders[io][portIndex] != null) {
            rdr = this.m_cacheFileReaders[io][portIndex];
        } else {
            try {
                if (isInput) {
                    filename = this.getInputDataCacheFileName(portIndex);
                    String blobFileName = this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), portIndex);
                    rdr = new DataCacheFileReader(filename, blobFileName, this.getInputMetaData(portIndex), this.getNetworkManager().getWorksheetPropertiesManager());
                } else {
                    filename = this.getOutputDataCacheFileName(portIndex);
                    String blobFileName = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), portIndex);
                    rdr = new DataCacheFileReader(filename, blobFileName, this.getOutputMetaData(portIndex), this.getNetworkManager().getWorksheetPropertiesManager());
                }
                this.printlnDebug("TableView opened file: " + filename);
                if (rdr != null) {
                    this.m_cacheFileReaders[io][portIndex] = rdr;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return rdr;
    }

    protected long getDataViewerNumRows(int portIndex, boolean isInput) {
        DataCacheFileReader rdr = this.getReader(portIndex, isInput);
        return rdr == null ? 0L : rdr.getNumRows();
    }

    protected int getDataViewerNumColumns(int portIndex, boolean isInput) {
        DataCacheFileReader rdr = this.getReader(portIndex, isInput);
        return rdr == null ? 0 : rdr.getNumColumns();
    }

    protected String[] getDataViewerColumnNames(int portIndex, boolean isInput) {
        DataCacheFileReader rdr = this.getReader(portIndex, isInput);
        return rdr == null ? null : rdr.getColumnNames();
    }

    protected String[] getDataViewerDataArray(long fromRow, long toRow, int fromCol, int toCol, int portIndex, boolean isInput) {
        if (fromRow > toRow || fromCol > toCol) {
            return new String[0];
        }
        int[] colNums = new int[toCol - fromCol + 1];
        for (int i = 0; i < colNums.length; ++i) {
            colNums[i] = fromCol + i;
        }
        return this.getDataViewerDataArray(fromRow, toRow, colNums, portIndex, isInput, false);
    }

    /*
     * Unable to fully structure code
     */
    protected String[] getDataViewerDataArray(long fromRow, long toRow, int[] colNums, int portIndex, boolean isInput, boolean splusStrings) {
        if (fromRow > toRow || colNums == null || colNums.length == 0) {
            return new String[0];
        }
        data = this.getOriginalData(colNums, fromRow, (int)(toRow - fromRow + 1L), portIndex, isInput);
        if (data == null) {
            return new String[0];
        }
        numRows = (int)(toRow - fromRow + 1L);
        numColumns = colNums.length;
        val = new String[numRows * numColumns];
lbl9:
        // 5 sources

        try {
            for (col = 0; col < numColumns; ++col) {
                block17: {
                    block16: {
                        block15: {
                            columnData = data[col];
                            if (columnData == null) continue;
                            if (!(columnData instanceof double[])) break block15;
                            transColumnData = (double[])columnData;
                            for (row = 0; row < numRows; ++row) {
                                oneVal = transColumnData[row];
                                val[row + col * numRows] = CNKObj.isDoubleNA(oneVal) != false ? "" : Double.toString(oneVal);
                            }
                            ** GOTO lbl9
                        }
                        if (!(columnData instanceof long[])) break block16;
                        transColumnData = (long[])columnData;
                        formatter = this.getWorksheetPropertiesManager().getDateFormatter();
                        for (row = 0; row < numRows; ++row) {
                            oneVal = transColumnData[row];
                            val[row + col * numRows] = CNKObj.isTimeDateNA(oneVal) != false ? "" : formatter.convertTimeDateToString(oneVal);
                        }
                        ** GOTO lbl9
                    }
                    if (!(columnData instanceof String[])) break block17;
                    isCategorical = this.getReader(portIndex, isInput).getRowBuf().isFactor(colNums[col]);
                    transColumnData = (String[])columnData;
                    for (row = 0; row < numRows; ++row) {
                        oneVal = transColumnData[row];
                        if (splusStrings) {
                            if (CNKObj.isStringNA(oneVal)) {
                                oneVal = "NA";
                            }
                        } else if (CNKObj.isStringNA(oneVal)) {
                            oneVal = "";
                        } else if (!isCategorical) {
                            oneVal = "\"" + oneVal + "\"";
                        }
                        val[row + col * numRows] = oneVal;
                    }
                    ** GOTO lbl9
                }
                if (!(columnData instanceof Object[])) continue;
                transColumnData = (Object[])columnData;
                for (row = 0; row < numRows; ++row) {
                    oneVal = transColumnData[row];
                    val[row + col * numRows] = oneVal == null ? "" : oneVal.toString();
                }
                ** GOTO lbl9
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    protected void getDataViewerChartStats(Vector displayColumns, int portIndex, boolean isInput, int viewerID, long updateTime, String title, ChartBuilder cBuilder) {
        Object byCols = null;
        double[][] interestCols = null;
        ByColumnStatisticAccumulator bcs = null;
        int[] interestColumnNums = null;
        DataCacheFileReader rdr = null;
        XTMetaData metaData = null;
        this.m_chartStat_args = null;
        this.m_chartStat_nodeViewerID = viewerID;
        this.m_chartStat_chartBuilder = cBuilder;
        this.m_chartStat_title = title;
        Object[] wrapper = new Object[]{Integer.decode(Integer.toString(this.m_chartStat_nodeViewerID))};
        try {
            metaData = isInput ? this.getInputMetaData(portIndex) : this.getOutputMetaData(portIndex);
            Vector byColumns = new Vector();
            int numQuantiles = 4;
            int kVal = 100;
            bcs = new ByColumnStatisticAccumulator(byColumns, displayColumns, numQuantiles, kVal, metaData);
            interestColumnNums = new int[displayColumns.size()];
            for (int i = 0; i < interestColumnNums.length; ++i) {
                interestColumnNums[i] = metaData.nameToOrdinal((String)displayColumns.get(i));
            }
            rdr = this.getReader(portIndex, isInput);
            if (rdr == null) {
                EngineMessageHandler.sendMessageToApp("resetCursor", wrapper);
                return;
            }
            long totalNumRows = this.getDataViewerNumRows(portIndex, isInput);
            int chunksize = this.getMaxRowsPerBlock();
            byCols = new double[0][];
            interestCols = new double[interestColumnNums.length][chunksize];
            this.m_chartStat_args = new Object[3];
            this.m_chartStat_args[0] = new Integer(viewerID);
            long lastTime = -1L;
            int row = 0;
            boolean freshData = false;
            for (long i = 0L; i < totalNumRows; ++i) {
                if (this.isInterruptRequested()) {
                    EngineMessageHandler.sendMessageToApp("resetCursor", wrapper);
                    return;
                }
                for (int j = 0; j < interestColumnNums.length; ++j) {
                    interestCols[j][row] = rdr.getDouble(i, interestColumnNums[j]);
                }
                ++row;
                if (i == totalNumRows - 1L || i % (long)(chunksize - 1) == 0L && i != 0L) {
                    bcs.updateStatistics((double[][])byCols, interestCols, row);
                    freshData = true;
                    row = 0;
                }
                long thisTime = System.currentTimeMillis();
                if (i != totalNumRows - 1L && thisTime - lastTime <= updateTime) continue;
                this.m_chartStat_args[1] = new Long(i);
                if (freshData) {
                    this.m_chartStat_args[2] = bcs.outputColumnStats();
                    ((XTProps)this.m_chartStat_args[2]).set("binCount", bcs.getBinCount());
                    freshData = false;
                    if (!this.m_chartStat_chartBuilder.isFrameDisplayed() && !this.m_chartStat_chartBuilder.getThreadStopRequest()) {
                        this.m_chartStat_chartBuilder.setProps((XTProps)this.m_chartStat_args[2]);
                        int result = this.m_chartStat_chartBuilder.setDisplayInfo(0, 3, displayColumns, new Vector(), ((XTProps)this.m_chartStat_args[2]).getInt("binCount", 10), true, false, true);
                        if (result != -1) {
                            try {
                                this.m_chartStat_chartBuilder.displayCharts(this.m_chartStat_title + "(" + Long.toString(i + 1L) + " rows read)", false);
                            }
                            catch (OutOfMemoryError oom) {
                                this.m_chartStat_chartBuilder.clearMemory();
                                this.m_chartStat_chartBuilder = null;
                            }
                        }
                        EngineMessageHandler.sendMessageToApp("resetCursor", wrapper);
                    } else {
                        this.m_chartStat_chartBuilder.nextStoreProps = (XTProps)this.m_chartStat_args[2];
                        this.m_chartStat_chartBuilder.numRowsDoneByViewer = i;
                        if (this.m_chartStat_updateMonitor == null) {
                            this.m_chartStat_updateMonitor = new Thread(){

                                public void run() {
                                    String updateTitle = "";
                                    block4: while (true) {
                                        XTProps thisLoopProps = ((EngineNode)EngineNode.this).m_chartStat_chartBuilder.nextStoreProps;
                                        long nextRowCount = ((EngineNode)EngineNode.this).m_chartStat_chartBuilder.numRowsDoneByViewer;
                                        updateTitle = EngineNode.this.m_chartStat_title + "(" + Long.toString(((EngineNode)EngineNode.this).m_chartStat_chartBuilder.numRowsDoneByViewer + 1L) + " rows read)";
                                        EngineNode.this.m_chartStat_chartBuilder.updateCharts(updateTitle, thisLoopProps, nextRowCount);
                                        if (((EngineNode)EngineNode.this).m_chartStat_chartBuilder.rowCount == EngineNode.this.m_chartStat_chartBuilder.getTotalNumRows() - 1L || EngineNode.this.m_chartStat_chartBuilder.getThreadStopRequest()) break;
                                        try {
                                            while (true) {
                                                if (((EngineNode)EngineNode.this).m_chartStat_chartBuilder.nextStoreProps != thisLoopProps) continue block4;
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (IllegalMonitorStateException imse) {
                                                    imse.printStackTrace();
                                                }
                                            }
                                        }
                                        catch (InterruptedException ie) {
                                            ie.printStackTrace();
                                            continue;
                                        }
                                        break;
                                    }
                                    Object[] wrapper = new Object[]{Integer.decode(Integer.toString(EngineNode.this.m_chartStat_nodeViewerID))};
                                    EngineMessageHandler.sendMessageToApp("resetCursor", wrapper);
                                    EngineNode.this.m_chartStat_updateMonitor = null;
                                }
                            };
                            this.m_chartStat_updateMonitor.start();
                        }
                    }
                } else {
                    this.m_chartStat_args[2] = null;
                }
                lastTime = thisTime;
            }
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        interestColumnNums = null;
        interestCols = null;
        metaData = null;
        byCols = null;
        rdr = null;
        this.m_chartStat_args = null;
        bcs = null;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            XTMetaData inputMD;
            if (this.getNumInputs() > 0 && (inputMD = this.getInputMetaData(0)) != null) {
                md = (XTMetaData)inputMD.clone();
            }
            if (md == null) {
                md = new XTMetaData();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public boolean propertiesChanged(XTProps props) {
        return !this.getNodeProperties().equals(props);
    }

    public CNKProc procCreate() throws Exception {
        return null;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
    }

    public void procExtractResults(CNKProc proc) throws Exception {
    }

    public void procDelete(CNKProc proc) {
        if (proc != null) {
            proc.destroyCNKObj();
        }
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        return -1L;
    }

    public InputRequirements getInputRequirements(int inputNum) {
        return InputRequirements.getDefaultRequirements();
    }

    protected int getExecutionType() {
        if (this.hasCNKProc()) {
            return 0;
        }
        if (this.hasDataCacheProc()) {
            return 1;
        }
        return 0;
    }

    protected boolean hasCNKProc() {
        return true;
    }

    protected boolean hasDataCacheProc() {
        return false;
    }

    protected boolean hasDynamicOutputs() {
        return false;
    }

    protected void procModifyDynamicOutputsMetaData(CNKProc proc, int outputNum, XTMetaData md) {
    }

    protected boolean executeDataCacheProc() throws Exception {
        return false;
    }

    protected boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return false;
    }

    protected String getInputDataCacheFileName(int inputNum) {
        return this.m_networkManager.getInputDataCacheFileName(this.getNodeID(), inputNum);
    }

    protected String getOutputDataCacheFileName(int outputNum) {
        return this.m_networkManager.getOutputDataCacheFileName(this.getNodeID(), outputNum);
    }

    protected void setOutputMetaData(int outputNum, XTMetaData md) {
        this.m_networkManager.setOutputMetaData(this.getNodeID(), outputNum, md);
    }

    private ProgressUpdater getProgressUpdater() {
        if (this.m_progressUpdater == null) {
            this.m_progressUpdater = new ProgressUpdater(this.getNetworkManager());
        }
        return this.m_progressUpdater;
    }

    protected void setUpdateTime(int newTime) {
        this.getProgressUpdater().setUpdateTime(newTime);
    }

    protected void setUpdateResponsibility(Object source) {
        this.getProgressUpdater().setUpdateResponsibility(source);
    }

    protected void resetUpdateResponsibility() {
        this.getProgressUpdater().resetUpdateResponsibility();
    }

    protected boolean hasUpdatedProgress() {
        if (this.m_progressUpdater == null) {
            return false;
        }
        return this.getProgressUpdater().hasUpdatedProgress();
    }

    protected boolean updateProgressIndicator(int percent) {
        return this.updateProgressIndicator(percent, this);
    }

    protected boolean updateProgressIndicator(int percent, Object source) {
        return this.getProgressUpdater().updateUser(percent, source);
    }

    protected boolean updateProgressIndicator(int percent, int exeCount, String baseText) {
        return this.updateProgressIndicator(percent, exeCount, baseText, this);
    }

    protected boolean updateProgressIndicator(int percent, int exeCount, String baseText, Object source) {
        return this.getProgressUpdater().updateUser(percent, exeCount, baseText, source);
    }

    public void setProgress(int percent, String msg) {
        this.getProgressUpdater().setProgress(percent, msg);
    }

    protected void resetProgressIndicator() {
        this.getProgressUpdater().reset();
    }

    protected void resetProgressDone() {
        if (this.m_progressUpdater == null) {
            this.getProgressUpdater();
        } else {
            this.getProgressUpdater().resetProgressDone();
        }
    }

    protected void setPhaseParentNode(EngineNode node) {
        this.m_phaseParentNode = node;
    }

    protected EngineNode getPhaseParentNode() {
        return this.m_phaseParentNode;
    }

    protected Phase getPhase(int phaseNum) throws Exception {
        return null;
    }

    protected Phase createPhase(String statusLabel, EngineNode node, PortSpec[] inputPorts, PortSpec[] outputPorts) {
        return this.createPhase(statusLabel, node, inputPorts, outputPorts, null, null);
    }

    protected Phase createPhase(String statusLabel, EngineNode node, PortSpec[] inputPorts, PortSpec[] outputPorts, XTProps props, String modelString) {
        Phase ph = new Phase();
        ph.m_parentNode = this;
        ph.m_statusLabel = statusLabel;
        ph.m_node = node;
        ph.m_inputPortSpecs = inputPorts;
        ph.m_outputPortSpecs = outputPorts;
        ph.m_props = props;
        ph.m_modelString = modelString;
        node.setPhaseParentNode(this);
        return ph;
    }

    protected static PortSpec getInputPortSpec(int portNum) {
        return new PortSpec(portNum, true, false);
    }

    protected static PortSpec getOutputPortSpec(int portNum) {
        return new PortSpec(portNum, false, false);
    }

    protected static PortSpec getTempPortSpec(int portNum) {
        return new PortSpec(portNum, false, true);
    }

    protected void createExecViewer(String displayClassName) {
        EngineNode.sendMessageToApp("createExecViewer", new Object[]{this.getWorksheetID(), this.getNodeID(), this.getNodeName(), displayClassName});
    }

    protected Object sendMessageToExecViewer(String msg, Object[] args) {
        Object val = EngineNode.sendMessageToApp("sendMessageToExecViewer", new Object[]{this.getWorksheetID(), this.getNodeID(), new Object[]{msg, args}});
        return val;
    }

    protected void closeExecViewer() {
        EngineNode.sendMessageToApp("closeExecViewer", new Object[]{this.getWorksheetID(), this.getNodeID()});
    }

    protected static Object sendMessageToApp(String msg, Object[] args) {
        Object val = EngineMessageHandler.sendMessageToApp(msg, args);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execPause() {
        Object object = this.m_execPauseObject;
        synchronized (object) {
            if (this.m_execPause) {
                System.out.println("execPause: recursive call");
                return;
            }
            try {
                this.m_execPause = true;
                this.m_execPauseObject.wait();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.m_execPause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execContinue() {
        Object object = this.m_execPauseObject;
        synchronized (object) {
            if (this.m_execPause) {
                this.m_execPauseObject.notify();
            }
        }
    }

    protected boolean execIsPaused() {
        return this.m_execPause;
    }

    public boolean hasRandomSeed() {
        XTProps props = this.getNodeProperties();
        boolean seedExists = props.getValue("randomSeed", "").equals("enterSeed");
        boolean worksheetSeedsFixed = this.getWorksheetPropertiesManager().getFixRandomSeed();
        return seedExists || worksheetSeedsFixed;
    }

    public long getRandomSeed() {
        XTProps props = this.getNodeProperties();
        long seed = this.getRandomSeedFromProps(props);
        return seed;
    }

    protected long getRandomSeedFromProps(XTProps props) {
        block7: {
            boolean seedExists = props.getValue("randomSeed", "").equals("enterSeed");
            boolean worksheetSeedsFixed = this.getWorksheetPropertiesManager().getFixRandomSeed();
            if (seedExists) {
                try {
                    return Long.parseLong(props.getValue("randomSeedValue"));
                }
                catch (Exception e) {
                    break block7;
                }
            }
            if (worksheetSeedsFixed) {
                int eltNum = 0;
                try {
                    eltNum = Integer.parseInt(this.getNodeID());
                }
                catch (Exception ex) {
                    eltNum = Math.abs(this.getNodeID().hashCode()) % 201;
                }
                MinerRandom rng = new MinerRandom(12345L);
                long seed = rng.nextLong();
                for (int i = 0; i < eltNum; ++i) {
                    seed = rng.nextLong();
                }
                return seed;
            }
        }
        return System.currentTimeMillis();
    }

    public Random getRandomGenerator() {
        return new MinerRandom(this.getRandomSeed());
    }

    public WorksheetPropertiesManager getWorksheetPropertiesManager() {
        return this.getNetworkManager().getWorksheetPropertiesManager();
    }

    public XMLTree handleCallEngineNode(String str, XMLTree arg) {
        return null;
    }

    public Object[] getOriginalData(int[] colNums, long firstRow, int numRows, int portIndex, boolean isInput) {
        Object[] val = null;
        Object blobOffsetData = null;
        Object blobLengthData = null;
        try {
            int i;
            if (colNums == null || this.getNetworkManager().isRunning()) {
                return null;
            }
            DataCacheFileReader rdr = this.getReader(portIndex, isInput);
            if (rdr == null) {
                return null;
            }
            int totalNumColumns = this.getDataViewerNumColumns(portIndex, isInput);
            long totalNumRows = this.getDataViewerNumRows(portIndex, isInput);
            if (firstRow < 0L || firstRow + (long)numRows > totalNumRows) {
                return null;
            }
            int numColumns = colNums.length;
            val = new Object[numColumns];
            String[] colTypes = new String[numColumns];
            XTMetaData md = isInput ? this.getInputMetaData(portIndex) : this.getOutputMetaData(portIndex);
            for (i = 0; i < numColumns; ++i) {
                String colType;
                if (colNums[i] < 0 || colNums[i] >= totalNumColumns) {
                    return null;
                }
                colTypes[i] = colType = md.getColumnType(colNums[i]);
                if (colType == null) continue;
                if (colType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    val[i] = new double[numRows];
                    continue;
                }
                if (colType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    val[i] = new String[numRows];
                    continue;
                }
                if (colType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    val[i] = new String[numRows];
                    continue;
                }
                if (colType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    val[i] = new long[numRows];
                    continue;
                }
                if (!colType.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
                if (blobOffsetData == null) {
                    blobOffsetData = new long[numColumns][];
                    blobLengthData = new long[numColumns][];
                }
                blobOffsetData[i] = new long[numRows];
                blobLengthData[i] = new long[numRows];
            }
            for (int row = 0; row < numRows; ++row) {
                for (int i2 = 0; i2 < numColumns; ++i2) {
                    String colType = colTypes[i2];
                    if (colType == null) continue;
                    if (colType.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                        ((double[])val[i2])[row] = rdr.getDouble(firstRow + (long)row, colNums[i2]);
                        continue;
                    }
                    if (colType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                        ((String[])val[i2])[row] = rdr.getCategoricalString(firstRow + (long)row, colNums[i2]);
                        continue;
                    }
                    if (colType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                        ((String[])val[i2])[row] = rdr.getString(firstRow + (long)row, colNums[i2]);
                        continue;
                    }
                    if (colType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                        ((long[])val[i2])[row] = rdr.getDateTime(firstRow + (long)row, colNums[i2]);
                        continue;
                    }
                    if (!colType.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
                    blobOffsetData[i2][row] = rdr.getBlobOffset(firstRow + (long)row, colNums[i2]);
                    blobLengthData[i2][row] = rdr.getBlobLength(firstRow + (long)row, colNums[i2]);
                }
            }
            if (blobOffsetData != null) {
                for (i = 0; i < numColumns; ++i) {
                    String colType = colTypes[i];
                    if (colType == null || !colType.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
                    val[i] = rdr.getBlobColumn(colNums[i], blobOffsetData[i], blobLengthData[i]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return val;
    }

    public String getNodeTempFileName(String tagName) {
        return this.getNetworkManager().getNodeTempFileName(this.getNodeID(), tagName);
    }

    public Set getNodeTempFileTags() {
        return this.getNetworkManager().getNodeTempFileTags(this.getNodeID());
    }

    public void deleteNodeTempFile(String tagName) {
        this.getNetworkManager().deleteNodeTempFile(this.getNodeID(), tagName);
    }

    protected static class PortSpec {
        private int m_portNum = 0;
        private boolean m_isInput = false;
        private boolean m_isTemp = false;

        private PortSpec(int portNum, boolean isInput, boolean isTemp) {
            this.m_portNum = portNum;
            this.m_isInput = isInput;
            this.m_isTemp = isTemp;
        }

        public boolean isInput() {
            return this.m_isInput;
        }

        public boolean isOutput() {
            return !this.m_isInput && !this.m_isTemp;
        }

        public boolean isTemp() {
            return this.m_isTemp;
        }

        public int getPortNum() {
            return this.m_portNum;
        }
    }

    protected static class Phase {
        public EngineNode m_parentNode = null;
        public String m_statusLabel = null;
        public EngineNode m_node = null;
        public PortSpec[] m_inputPortSpecs = null;
        public PortSpec[] m_outputPortSpecs = null;
        public XTProps m_props = null;
        public String m_modelString = null;
        public String m_modelParent = null;
        public String m_executeAfter = null;

        private Phase() {
        }

        public int getNumInputs() {
            return this.m_inputPortSpecs == null ? 0 : this.m_inputPortSpecs.length;
        }

        public int getNumOutputs() {
            return this.m_outputPortSpecs == null ? 0 : this.m_outputPortSpecs.length;
        }

        public PortSpec getInputPortSpec(int portNum) {
            return this.m_inputPortSpecs == null ? null : this.m_inputPortSpecs[portNum];
        }

        public PortSpec getOutputPortSpec(int portNum) {
            return this.m_outputPortSpecs == null ? null : this.m_outputPortSpecs[portNum];
        }
    }

    public static class InputRequirements {
        private boolean m_needsMultiPass = false;
        private boolean m_needsRandomAccess = false;
        private boolean m_needsFactorLevels = false;
        private boolean m_needsTotalRows = false;
        private boolean m_needsDataSummary = false;
        private boolean m_needsPermanentInputCacheFile = false;
        private static InputRequirements m_defaultReqs = new InputRequirements(true, true, true, true, true, false);
        private static InputRequirements m_minReqs = new InputRequirements(false, false, false, false, false, false);
        private static InputRequirements m_permInputReqs = new InputRequirements(true, true, true, true, true, true);

        public InputRequirements(boolean needsMultiPass, boolean needsRandomAccess, boolean needsFactorLevels, boolean needsTotalRows, boolean needsDataSummary, boolean needsPermanentInputCacheFile) {
            this.m_needsMultiPass = needsMultiPass;
            this.m_needsRandomAccess = needsRandomAccess;
            this.m_needsFactorLevels = needsFactorLevels;
            this.m_needsTotalRows = needsTotalRows;
            this.m_needsDataSummary = needsDataSummary;
            this.m_needsPermanentInputCacheFile = needsPermanentInputCacheFile;
        }

        public static InputRequirements getDefaultRequirements() {
            return m_defaultReqs;
        }

        public static InputRequirements getMinRequirements() {
            return m_minReqs;
        }

        public static InputRequirements getPermanentInputRequirements() {
            return m_permInputReqs;
        }

        public boolean needsMultiPass() {
            return this.m_needsMultiPass;
        }

        public boolean needsRandomAccess() {
            return this.m_needsRandomAccess;
        }

        public boolean needsFactorLevels() {
            return this.m_needsFactorLevels;
        }

        public boolean needsTotalRows() {
            return this.m_needsTotalRows;
        }

        public boolean needsDataSummary() {
            return this.m_needsDataSummary;
        }

        public boolean needsPermanentInputCacheFile() {
            return this.m_needsPermanentInputCacheFile;
        }
    }

    private static class ProgressUpdater {
        private EngineNetworkManager manager = null;
        private Object updater = null;
        private int lastPercent = -1;
        private int lastExeDone = 1;
        private long lastTime = 0L;
        private boolean hasOutput = false;
        private int updateTime = 2000;

        public ProgressUpdater(EngineNetworkManager mn) {
            this.manager = mn;
            this.hasOutput = false;
            this.reset();
        }

        public void reset() {
            this.lastTime = System.currentTimeMillis();
            this.hasOutput = false;
            this.lastPercent = -1;
            this.lastExeDone = 1;
            EngineMessageHandler.sendMessageToApp("setProgressDone", new Object[]{new Integer(0)});
        }

        public void resetProgressDone() {
            this.lastTime = System.currentTimeMillis();
            this.hasOutput = false;
            this.lastPercent = -1;
            EngineMessageHandler.sendMessageToApp("setProgressDone", new Object[]{new Integer(0)});
        }

        public void setUpdateTime(int newTime) {
            this.updateTime = newTime;
        }

        public void setUpdateResponsibility(Object updater) {
            this.updater = updater;
        }

        public void resetUpdateResponsibility() {
            this.updater = null;
        }

        public boolean hasUpdatedProgress() {
            return this.hasOutput;
        }

        public boolean updateUser(int percent, Object source) {
            return this.updateUser(percent, this.lastExeDone, "", source);
        }

        public boolean updateUser(int percent, int exeDone, String baseText, Object source) {
            if (this.manager.isInterruptRequested()) {
                this.updater = null;
                return false;
            }
            if (this.updater != null && this.updater != source) {
                return true;
            }
            long curTime = System.currentTimeMillis();
            if (exeDone > this.lastExeDone) {
                this.lastTime = curTime;
                this.lastExeDone = exeDone;
                this.lastPercent = percent;
                String text = baseText + " <Pass " + exeDone + ">";
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{text});
                EngineMessageHandler.sendMessageToApp("setProgressDone", new Object[]{new Integer(percent)});
            } else if (curTime - this.lastTime > (long)this.updateTime) {
                this.lastTime = curTime;
                if (percent > this.lastPercent) {
                    this.lastPercent = percent;
                    this.hasOutput = true;
                    EngineMessageHandler.sendMessageToApp("setProgressDone", new Object[]{new Integer(percent)});
                } else {
                    EngineMessageHandler.sendMessageToApp("setSameProgressDone", new Object[0]);
                }
            }
            return true;
        }

        public void setProgress(int percent, String msg) {
            if (msg != null) {
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{msg});
            }
            EngineMessageHandler.sendMessageToApp("setProgressDone", new Object[]{new Integer(percent)});
        }
    }
}

