/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.TextOutputScrollPane;
import com.insightful.splus.SplusOutputHandler;
import java.io.OutputStream;
import java.rmi.RemoteException;

public class MinerOutputHandler
implements SplusOutputHandler {
    TextOutputScrollPane m_pane = null;
    OutputStream m_stream = null;
    boolean m_writeToOutputPane = true;

    public MinerOutputHandler(TextOutputScrollPane scrollpane) throws RemoteException {
        this.m_pane = scrollpane;
    }

    public void write(String data, boolean prompted) {
        try {
            if (data.equals("> ")) {
                return;
            }
            if (this.m_writeToOutputPane) {
                this.m_pane.write(data, prompted);
            }
            if (this.m_stream != null) {
                if (System.getProperty("debug.scripts", "F").equals("T")) {
                    System.out.println("writing to save-stream");
                }
                this.m_stream.write(data.getBytes());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setOutputStream(OutputStream stream) {
        if (System.getProperty("debug.scripts", "F").equals("T")) {
            System.out.println("MinerOutputHandler::setOutputStream() called with stream:");
            if (stream != null) {
                System.out.println("     " + stream.toString());
            } else {
                System.out.println("     null");
            }
        }
        if (this.m_stream != null) {
            try {
                this.m_stream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_stream = stream;
    }

    public void setWriteToOutputPane(boolean doWrite) {
        this.m_writeToOutputPane = doWrite;
    }
}

