/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MultiLineDocument;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoTextEdit;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;

public class MinerTextEdit
extends JGoTextEdit {
    private JTextComponent m_textc;
    private boolean m_multiline;
    private String m_origText;
    private Font m_origFont;
    private Color m_origBackground;

    public MinerTextEdit(Rectangle rect, String origText, boolean multiline, JGoText obj) {
        super(rect, origText, multiline, obj);
        this.m_multiline = multiline;
        this.m_origText = origText;
        this.m_origFont = obj.getFont();
        this.m_origBackground = obj.getBkColor();
    }

    public JComponent createComponent(JGoView view) {
        this.m_textc = this.m_multiline ? new MinerJTextArea(this.m_origText, this) : new MinerJTextField(this.m_origText, this);
        return this.m_textc;
    }

    public Rectangle getBoundingRect() {
        Rectangle rect = super.getBoundingRect();
        Dimension dim = this.m_textc.getSize();
        rect.width = dim.width;
        rect.height = dim.height;
        return rect;
    }

    class MinerJTextArea
    extends JTextArea {
        JGoTextEdit myTextEdit;

        MinerJTextArea(String s, JGoTextEdit obj) {
            this.setFont(((MinerTextEdit)obj).m_origFont);
            this.setBackground(((MinerTextEdit)obj).m_origBackground);
            MultiLineDocument doc = new MultiLineDocument(this, true);
            this.setDocument(doc);
            this.setText(MultiLineDocument.formatString(s, true));
            doc.resizeComponent();
            this.myTextEdit = obj;
            this.setBorder(new CompoundBorder(new EtchedBorder(1), new BevelBorder(1)));
            this.enableEvents(12L);
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10 && this.myTextEdit != null) {
                this.myTextEdit.setText(this.getText());
                this.myTextEdit.doEndEdit();
                this.myTextEdit = null;
            } else if (e.getKeyCode() == 27 && this.myTextEdit != null) {
                JGoTextEdit jgotextedit = this.myTextEdit;
                this.myTextEdit = null;
                jgotextedit.doEndEdit();
            } else {
                super.processKeyEvent(e);
            }
        }

        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1005 && this.myTextEdit != null) {
                this.myTextEdit.setText(this.getText());
                this.myTextEdit.doEndEdit();
                this.myTextEdit = null;
            }
            super.processFocusEvent(e);
        }

        public void scrollRectToVisible(Rectangle contentRect) {
        }
    }

    class MinerJTextField
    extends JTextField {
        JGoTextEdit myTextEdit;

        MinerJTextField(String s, JGoTextEdit obj) {
            this.setFont(((MinerTextEdit)obj).m_origFont);
            this.setBackground(((MinerTextEdit)obj).m_origBackground);
            MultiLineDocument doc = new MultiLineDocument(this, false);
            this.setDocument(doc);
            this.setText(MultiLineDocument.formatString(s, false));
            doc.resizeComponent();
            this.myTextEdit = obj;
            this.enableEvents(12L);
            switch (obj.getTextObject().getAlignment()) {
                case 0: {
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    this.setHorizontalAlignment(4);
                }
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10 && this.myTextEdit != null) {
                this.myTextEdit.setText(this.getText());
                this.myTextEdit.doEndEdit();
                this.myTextEdit = null;
            } else if (e.getKeyCode() == 27 && this.myTextEdit != null) {
                JGoTextEdit jgotextedit = this.myTextEdit;
                this.myTextEdit = null;
                jgotextedit.doEndEdit();
            } else {
                super.processKeyEvent(e);
            }
        }

        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1005 && this.myTextEdit != null) {
                this.myTextEdit.setText(this.getText());
                this.myTextEdit.doEndEdit();
                this.myTextEdit = null;
            }
            super.processFocusEvent(e);
        }

        public void scrollRectToVisible(Rectangle contentRect) {
        }
    }
}

