/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ClassificationAssessmentEngineNode;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModelEvaluationDialog;
import com.insightful.miner.RegressionAgreementEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;

public class RegressionAgreementNodeModel
extends ActivityNodeModel {
    public RegressionAgreementNodeModel(Element elt) {
        super(elt);
    }

    public RegressionAgreementNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public void showPropertiesDialog(boolean modality) {
        ModelEvaluationDialog dialog = ModelEvaluationDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public void showView(Frame frame) {
        XTProps xt = null;
        try {
            XMLTree tree = (XMLTree)this.sendMessageToEngine("getNodeCache", new Object[]{RegressionAgreementEngineNode.REGRESSION_AGREEMENT_CACHE});
            xt = new XTProps(tree);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Vector inputs = xt.getFirstLevelProperties();
        int numInputs = inputs.size();
        StringBuffer html = new StringBuffer();
        String[] titlePath = new String[]{"", ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG};
        for (int i = 0; i < numInputs; ++i) {
            titlePath[0] = (String)inputs.get(i);
            XTMetaData md = null;
            try {
                md = this.getInputMetaData(i);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (xt.getSubProperties(titlePath[0]).size() == 0) continue;
            String inputName = xt.getValue(titlePath, "Input #" + Integer.toString(i));
            if (!titlePath[0].startsWith(ClassificationAssessmentEngineNode.INPUT_PREFIX_TAG)) {
                BaseNodeArea area = this.getDocument().findFlatNodeByID(Integer.parseInt(titlePath[0]));
                if (area == null) continue;
                inputName = ((ActivityNodeArea)area).getNodeModel().getLabelText();
            }
            this.createHTMLTable(titlePath[0], inputName, xt, html);
        }
        String title = this.getLabelText();
        StringBuffer output = new StringBuffer();
        output.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        output.append("<HTML>\n<TITLE>" + title + " Summary</TITLE>");
        output.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
        output.append("<P><H1 class=\"title\">" + title + " Summary</H1>\n</P><BR>");
        output.append(html.toString());
        output.append("</HTML>\n");
        new HtmlFrame(output.toString());
    }

    private void createHTMLTable(String inputID, String inputName, XTProps props, StringBuffer buffer) {
        String[] path = new String[2];
        path[0] = inputID;
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        buffer.append("\t\t\t\t\t<p><b><font size=\"4\" class=\"tableHead\">Input Node - " + inputName + "</font></b></p>");
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        buffer.append("\t\t<TR class=\"whiteBG\">\n");
        buffer.append("\t\t\t<TD><CENTER><B>Mean Squared Error</B></CENTER></TD>\n");
        buffer.append("\t\t\t<TD><CENTER>");
        path[1] = RegressionAgreementEngineNode.MEAN_SQUARED_ERROR;
        buffer.append(MinerApp.formatDouble(props.getDouble(path, Double.NaN)));
        buffer.append("</CENTER></TD>\n");
        buffer.append("\t\t</TR>\n");
        buffer.append("\t\t<TR class=\"greyBG\">\n");
        buffer.append("\t\t\t<TD><CENTER><B>Mean Absolute Error</B></CENTER></TD>\n");
        buffer.append("\t\t\t<TD><CENTER>");
        path[1] = RegressionAgreementEngineNode.MEAN_ABSOLUTE_ERROR;
        buffer.append(MinerApp.formatDouble(props.getDouble(path, Double.NaN)));
        buffer.append("</CENTER></TD>\n");
        buffer.append("\t\t</TR>\n");
        buffer.append("\t\t<TR class=\"whiteBG\">\n");
        buffer.append("\t\t\t<TD><CENTER><B>Relative Squared Error</B></CENTER></TD>\n");
        buffer.append("\t\t\t<TD><CENTER>");
        path[1] = RegressionAgreementEngineNode.RELATIVE_SQUARED_ERROR;
        buffer.append(MinerApp.formatDouble(props.getDouble(path, Double.NaN)));
        buffer.append("</CENTER></TD>\n");
        buffer.append("\t\t</TR>\n");
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("<BR><BR><BR><BR>\n");
    }

    public static XTProps getBDLOutput(XTProps nodeCache) {
        try {
            XTProps outputProps = new XTProps();
            Vector inputs = nodeCache.getFirstLevelProperties();
            int numInputs = inputs.size();
            String[] titlePath = new String[]{"", ClassificationAssessmentEngineNode.TITLE_ATTRIBUTE_TAG};
            for (int i = 0; i < numInputs; ++i) {
                titlePath[0] = (String)inputs.get(i);
                if (nodeCache.getSubProperties(titlePath[0]).size() == 0) continue;
                String inputName = "Input" + Integer.toString(i + 1);
                RegressionAgreementNodeModel.createBDLHTMLTableList(titlePath[0], inputName, nodeCache, outputProps);
            }
            return outputProps;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void createBDLHTMLTableList(String inputID, String inputName, XTProps props, XTProps outputProps) {
        String[] errorPath = new String[]{inputName, ""};
        String[] path = new String[]{inputID, ""};
        errorPath[1] = "Mean Squared Error";
        path[1] = RegressionAgreementEngineNode.MEAN_SQUARED_ERROR;
        outputProps.set(errorPath, Double.toString(props.getDouble(path, Double.NaN)));
        errorPath[1] = "Mean Absolute Error";
        path[1] = RegressionAgreementEngineNode.MEAN_ABSOLUTE_ERROR;
        outputProps.set(errorPath, Double.toString(props.getDouble(path, Double.NaN)));
        errorPath[1] = "Relative Squared Error";
        path[1] = RegressionAgreementEngineNode.RELATIVE_SQUARED_ERROR;
        outputProps.set(errorPath, Double.toString(props.getDouble(path, Double.NaN)));
    }
}

