/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcFile;
import com.insightful.miner.EngineNode;
import com.insightful.miner.FixedFormatDictionary;
import com.insightful.miner.ReadFixedFormatFileEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.List;

public class WriteFixedFormatFileEngineNode
extends ReadFixedFormatFileEngineNode {
    public CNKProc procCreate() throws Exception {
        CNKProcFile proc = new CNKProcFile();
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData inMD = this.getInputMetaData(0);
        CNKProcFile fProc = (CNKProcFile)proc;
        fProc.setRead(false);
        fProc.setFileName(this.getNetworkManager().getAbsolutePath(props.getValue("filePath", "")));
        fProc.setFileType("FASCII");
        fProc.setVnames(0);
        this.setTextFormats(fProc, props, false);
        this.setFileProcWriteCommon(fProc, props);
        boolean isBDL = this.hasBDLProps(props);
        FixedFormatDictionary ffd = null;
        int[] selectedInputColumns = null;
        if (isBDL) {
            String format = props.getValue("format", "");
            if (format.length() < 1) {
                throw new Exception("empty format");
            }
            ffd = FixedFormatDictionary.createFixedFormatDictionaryFromSplusFormatString(format);
            selectedInputColumns = this.getBDLWriteOutputToInputColumnArray(props, inMD);
        } else {
            ffd = this.getDataDictionary(props);
        }
        List colNames = ffd.getOrderedNames();
        int numColumns = colNames.size();
        fProc.clearFixedColumnInfo();
        if (isBDL && numColumns != selectedInputColumns.length) {
            throw new Exception("number of selected columns (" + selectedInputColumns.length + ") doesn't match number of columns in format (" + numColumns + ")");
        }
        int offset = 0;
        for (int colNum = 0; colNum < numColumns; ++colNum) {
            int width;
            String name = null;
            String bdlColumnType = null;
            if (isBDL) {
                name = inMD.ordinalToName(selectedInputColumns[colNum]);
                bdlColumnType = inMD.getColumnType(selectedInputColumns[colNum]);
            } else {
                name = (String)colNames.get(colNum);
            }
            int startCol = ffd.getOrderedStart(colNum) - 1;
            if (startCol < 0) {
                startCol = offset;
            }
            if ((width = ffd.getOrderedWidth(colNum)) < 0) {
                if (colNum + 1 < numColumns && ffd.getOrderedStart(colNum + 1) >= startCol) {
                    width = ffd.getOrderedStart(colNum + 1) - startCol;
                } else {
                    throw new Exception("can't determine width for column " + name);
                }
            }
            if (inMD.nameToOrdinal(name) < 0) {
                throw new Exception("output column not found: " + name);
            }
            if (startCol < offset) {
                throw new Exception("start column " + (startCol + 1) + " for column " + name + " is before previous column");
            }
            if (startCol > offset) {
                fProc.addFixedColumnInfo("", "string");
                fProc.setFixedColumnPosition(offset, startCol - offset, 0);
            }
            String type = ffd.getOrderedType(colNum);
            if (isBDL) {
                type = bdlColumnType;
            }
            String procType = "double";
            if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                procType = "string";
            } else if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                procType = "factor";
            } else if (type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                procType = "timeDate";
            }
            int ndec = ffd.getOrderedDecimals(colNum);
            fProc.addFixedColumnInfo(name, procType);
            fProc.setFixedColumnPosition(startCol, width, ndec);
            offset = startCol + width;
        }
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }
}

