/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.Instrumenter;
import com.insightful.miner.dndtree.TreeDragSourceListener;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeDragGestureListener
implements DragGestureListener {
    private JTree m_tree;
    private Instrumenter m_instrument;
    private DragSource m_dragSource = DragSource.getDefaultDragSource();

    public TreeDragGestureListener(JTree tree, Instrumenter instrument) {
        this.m_tree = tree;
        this.m_instrument = instrument;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        try {
            TreePath[] paths = this.m_tree.getSelectionPaths();
            paths = Instrumenter.reduceSelection(paths);
            if (paths != null && paths.length != 0) {
                Object[] nodes = new DefaultMutableTreeNode[paths.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                }
                Transferable trans = this.m_instrument.getNodeFactory().createTransferable(nodes, this.m_instrument.getNextDndId());
                this.m_dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, trans, new TreeDragSourceListener(this.m_tree, this.m_instrument, (DefaultMutableTreeNode[])nodes));
            }
        }
        catch (RuntimeException ex) {
            System.out.println(ex.toString());
        }
    }
}

