/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.graph.CanvasTabbedPane;
import com.insightful.miner.graph.ExportGraphDialog;
import com.insightful.splus.SplusSystem;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

public class ExportGraphCommand
extends com.insightful.splus.graph.ExportGraphCommand {
    protected JComponent m_jcomponent = null;
    public CanvasTabbedPane m_iminer_canvasPane = null;

    public boolean useSuper() {
        return this.m_jcomponent == null || this.m_jcomponent instanceof CanvasTabbedPane || this.m_jcomponent instanceof com.insightful.splus.graph.CanvasTabbedPane;
    }

    public SCanvas getComponentCanvas() {
        if (this.m_jcomponent != null) {
            if (this.m_jcomponent instanceof CanvasTabbedPane) {
                return ((CanvasTabbedPane)this.m_jcomponent).getCanvas();
            }
            if (this.m_jcomponent instanceof com.insightful.splus.graph.CanvasTabbedPane) {
                return ((com.insightful.splus.graph.CanvasTabbedPane)this.m_jcomponent).getCanvas();
            }
        }
        return this.getCanvas();
    }

    public boolean canEncodeSPJ() {
        if (this.useSuper()) {
            return super.canEncodeSPJ();
        }
        return false;
    }

    public ExportGraphCommand() {
    }

    public ExportGraphCommand(Frame frame) {
        super(frame);
    }

    public ExportGraphCommand(Frame frame, com.insightful.splus.graph.CanvasTabbedPane tabbedPane) {
        super(frame, tabbedPane);
    }

    public ExportGraphCommand(Frame frame, SCanvas canvas) {
        super(frame, canvas);
    }

    public ExportGraphCommand(Frame frame, JComponent jcomponent) {
        super(frame, new SCanvas());
        this.m_jcomponent = jcomponent;
    }

    protected int getImageWidth() {
        if (this.m_jcomponent != null && !this.useSuper()) {
            return this.getFullSize((Component)this.m_jcomponent).width;
        }
        return super.getImageWidth();
    }

    protected int getImageHeight() {
        if (this.m_jcomponent != null && !this.useSuper()) {
            return this.getFullSize((Component)this.m_jcomponent).height;
        }
        return super.getImageHeight();
    }

    public Dimension getFullSize(Component comp) {
        Container cont = comp.getParent();
        Dimension rect = comp.getSize();
        if (cont != null) {
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!(child instanceof JScrollBar)) continue;
                JScrollBar sb = (JScrollBar)child;
                if (sb.getOrientation() == 0) {
                    rect.width = sb.getModel().getMaximum();
                    continue;
                }
                rect.height = sb.getModel().getMaximum();
            }
        }
        return rect;
    }

    public void iminer3paint(Component comp, Graphics2D g) {
        JGoObject obj;
        JGoListPosition pos;
        Dimension rect = comp.getSize();
        Dimension oldRect = comp.getSize();
        Container cont = comp.getParent();
        JScrollBar hBar = null;
        JScrollBar vBar = null;
        Point barLoc = new Point();
        if (cont instanceof JViewport) {
            cont = cont.getParent();
        }
        if (cont != null) {
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!(child instanceof JScrollBar)) continue;
                JScrollBar sb = (JScrollBar)child;
                if (sb.getOrientation() == 0) {
                    rect.width = sb.getModel().getMaximum();
                    barLoc.x = sb.getValue();
                    sb.setValue(0);
                    hBar = sb;
                    continue;
                }
                rect.height = sb.getModel().getMaximum();
                barLoc.y = sb.getValue();
                sb.setValue(0);
                vBar = sb;
            }
            if (!rect.equals(oldRect)) {
                comp.setSize(rect.width, rect.height);
            }
        }
        JGoSelection sel = null;
        if (cont instanceof WorksheetView) {
            JGoSelection oldSel = ((WorksheetView)((Object)cont)).getSelection();
            pos = oldSel.getFirstObjectPos();
            sel = new JGoSelection();
            while (pos != null) {
                obj = oldSel.getObjectAtPos(pos);
                pos = oldSel.getNextObjectPos(pos);
                sel.extendSelection(obj);
            }
            oldSel.clearSelection();
        }
        try {
            comp.paintAll(g);
        }
        catch (Throwable t) {
            comp.paintAll(g);
        }
        if (sel != null && cont instanceof WorksheetView) {
            JGoSelection newSel = ((WorksheetView)((Object)cont)).getSelection();
            pos = sel.getFirstObjectPos();
            while (pos != null) {
                obj = sel.getObjectAtPos(pos);
                pos = sel.getNextObjectPos(pos);
                newSel.extendSelection(obj);
            }
        }
        if (cont != null && !rect.equals(oldRect)) {
            comp.setSize(oldRect.width, oldRect.height);
            if (hBar != null) {
                hBar.setValue(barLoc.x);
            }
            if (vBar != null) {
                vBar.setValue(barLoc.y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGraphics2DWork(Graphics2D g, int width, int height) {
        if (this.m_jcomponent == null) {
            super.doGraphics2DWork(g, width, height);
        } else {
            block5: {
                if (this.useSuper()) {
                    SCanvas canvas = this.getComponentCanvas();
                    Dimension bestSize = canvas.getBestFitSize(new Dimension(width, height));
                    int oldWidth = canvas.getWidth();
                    int oldHeight = canvas.getHeight();
                    try {
                        g.setColor(canvas.getBackgroundColor());
                        g.fillRect(0, 0, width, height);
                        g.translate((width - bestSize.width) / 2, (height - bestSize.height) / 2);
                        canvas.setSize(bestSize.width, bestSize.height);
                        canvas.paint((Graphics)g);
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        canvas.setSize(oldWidth, oldHeight);
                        throw throwable;
                    }
                    canvas.setSize(oldWidth, oldHeight);
                    {
                        break block5;
                    }
                }
                Dimension fullSize = this.getFullSize(this.m_jcomponent);
                g.setColor(this.m_jcomponent.getBackground());
                g.fillRect(0, 0, fullSize.width, fullSize.height);
                this.iminer3paint(this.m_jcomponent, g);
            }
            g.dispose();
        }
    }

    protected void handleError(String title, String message) {
        AcceleratorOptionPane.showOKDialog(this.getParentFrame(), MinerApp.getText("ExportGraphCommand_message_splus"), message, 0);
    }

    protected boolean showExportGraphDialog() {
        ExportGraphDialog dlg = new ExportGraphDialog(this, this.getParentFrame());
        dlg.show();
        return dlg.m_ok;
    }

    public static void saveCanvasBitmap(SCanvas canvas, Properties props) {
        try {
            ExportGraphCommand exportCmd = new ExportGraphCommand(SplusSystem.getDefaultFrame(), canvas);
            exportCmd.loadProperties(props);
            exportCmd.writeBitmapFile();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.flush();
        }
    }

    public static void saveMultiCanvas(Vector canvasVector, Properties props) {
        ExportGraphCommand exportCmd = new ExportGraphCommand(SplusSystem.getDefaultFrame());
        exportCmd.loadProperties(props);
        exportCmd.writeMultiCanvas(canvasVector);
    }

    public SCanvas getCanvas() {
        return super.getCanvas();
    }

    public void writeBitmapFile() {
        if (this.getImageFilename() == null || this.getImageFilename().length() < 1) {
            return;
        }
        if (this.getImageType() == 5 && this.m_iminer_canvasPane != null) {
            this.writeMultiCanvas(this.m_iminer_canvasPane.getAllCanvases());
        } else {
            super.writeBitmapFile();
        }
    }
}

