/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Trace;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HsqlDateTime {
    private static Calendar today = new GregorianCalendar();
    private static Calendar tempCalDefault = new GregorianCalendar();
    private static Calendar tempCalGMT1 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static java.sql.Date currentDate;
    static final String zerodatetime = "1970-01-01 00:00:00.000000000";
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    static SimpleDateFormat sdfd;
    static SimpleDateFormat sdft;
    static SimpleDateFormat sdfts;

    static Timestamp timestampValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        s = s + zerodatetime.substring(s.length());
        return Timestamp.valueOf(s);
    }

    public static Timestamp timestampValue(long time, int nano) {
        Timestamp ts = new Timestamp(time);
        ts.setNanos(nano);
        return ts;
    }

    public static java.sql.Date dateValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException(Trace.getMessage(133));
        }
        if (s.length() > sdfdPattern.length()) {
            return java.sql.Date.valueOf(s.substring(0, sdfdPattern.length()));
        }
        return java.sql.Date.valueOf(s);
    }

    public static Time timeValue(String s) {
        if (s == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        return Time.valueOf(s);
    }

    static int compare(Time a, Time b) throws HsqlException {
        if (a.getTime() == b.getTime()) {
            return 0;
        }
        return a.getTime() > b.getTime() ? 1 : -1;
    }

    public static synchronized java.sql.Date getCurrentDate(long millis) {
        HsqlDateTime.getToday(millis);
        return currentDate;
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.sql.Date getDate(String dateString, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(cal);
            Date d = sdfd.parse(dateString);
            return new java.sql.Date(d.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Time getTime(String timeString, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(cal);
            Date d = sdft.parse(timeString);
            return new Time(d.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Timestamp getTimestamp(String dateString, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(cal);
            Date d = sdfts.parse(dateString.substring(0, sdftsPattern.length()));
            String nanostring = dateString.substring(sdftsPattern.length(), dateString.length());
            Timestamp ts = new Timestamp(d.getTime());
            ts.setNanos(Integer.parseInt(nanostring));
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp x, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(cal == null ? tempCalDefault : cal);
            String s = sdfts.format(new Date(x.getTime())) + x.getNanos();
            return s + zerodatetime.substring(s.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeString(Time x, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(cal == null ? tempCalDefault : cal);
            return sdft.format(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(java.sql.Date x, Calendar cal) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(cal == null ? tempCalDefault : cal);
            return sdfd.format(x);
        }
    }

    static synchronized Calendar getToday(long millis) {
        if (millis - HsqlDateTime.getTimeInMillis(today) >= 86400000L) {
            HsqlDateTime.resetToday(millis);
        }
        return today;
    }

    public static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    private static synchronized void resetToday(long millis) {
        today.setTimeInMillis(millis);
        HsqlDateTime.resetToDate(today);
        currentDate = new java.sql.Date(HsqlDateTime.getTimeInMillis(today));
    }

    private static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    public static long getTimeInMillis(Calendar cal) {
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time getNormalisedTime(long t) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, t);
            HsqlDateTime.resetToTime(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Time(value);
        }
    }

    public static Time getNormalisedTime(Time t) {
        return HsqlDateTime.getNormalisedTime(t.getTime());
    }

    public static Time getNormalisedTime(Timestamp ts) {
        return HsqlDateTime.getNormalisedTime(ts.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d);
            HsqlDateTime.resetToDate(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(Timestamp ts) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, ts.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(java.sql.Date d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(Time t) {
        Calendar calendar = tempCalGMT1;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT1, System.currentTimeMillis());
            HsqlDateTime.resetToDate(tempCalGMT1);
            long value = HsqlDateTime.getTimeInMillis(tempCalGMT1) + t.getTime();
            return new Timestamp(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(java.sql.Date d) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, d.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long value = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Timestamp(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDateTimePart(Date d, int part) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            tempCalDefault.setTime(d);
            return tempCalDefault.get(part);
        }
    }

    static {
        HsqlDateTime.resetToday(System.currentTimeMillis());
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
    }
}

