/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.tree.gui.ClassificationRegressionTreeIcon;
import com.insightful.miner.tree.gui.ClassificationTreeGUI;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.model.ClassificationRegressionTree;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TreeLegendViewPanel
extends JPanel {
    ClassificationTreeGUI gui = null;
    ClassificationRegressionTree tree = null;
    TreeCollection treeColl = null;
    ClassificationRegressionTreeIcon legendIcon = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel backgroundPanel = new JPanel();
    private JPanel iconPanel = new JPanel();
    private JPanel ratingPanel = new JPanel();
    private JPanel navigateTreesPanel = new JPanel();
    private JPanel customizeDisplayPanel = new JPanel();
    private JLabel regMinLabel = null;
    private JLabel regMedLabel = null;
    private JLabel regMaxLabel = null;
    private JLabel classLabel = null;
    private JLabel nodeSizeLabel = new JLabel();
    private JLabel showLegendLabel = new JLabel();
    private JLabel customizeNodeLabel = new JLabel();
    private JCheckBox splitCheckbox = new JCheckBox();
    private JCheckBox nodeSizeCheckbox = new JCheckBox();
    private JCheckBox scoreCheckbox = new JCheckBox();
    private JCheckBox probCheckbox = new JCheckBox();
    private JCheckBox deviationCheckbox = new JCheckBox();
    private JCheckBox riskCheckbox = new JCheckBox();
    private JCheckBox showSizeCheckBox = new JCheckBox();
    private JSlider treeSlider = null;
    private JLabel numTreesLabel = new JLabel();
    private JButton prevTreeButton = null;
    private JButton nextTreeButton = null;

    public TreeLegendViewPanel(ClassificationTreeGUI treegui, TreeCollection tc) {
        this.gui = treegui;
        this.treeColl = tc;
        this.tree = this.treeColl.getTree(this.gui.getCurrentTreeIndex());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String numrecs = ClassificationTreeGUI.getText("treevis_legend_num_records");
        this.setLayout(this.borderLayout1);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.customizeDisplayPanel.setBackground(Color.white);
        this.customizeDisplayPanel.setBounds(new Rectangle(29, 2, 150, 144));
        this.customizeDisplayPanel.setLayout(null);
        this.prevTreeButton = new JButton("<<");
        this.nextTreeButton = new JButton(">>");
        CheckBoxListener customizeNodeListener = new CheckBoxListener();
        this.add(this.backgroundPanel);
        this.backgroundPanel.setBackground(Color.white);
        this.backgroundPanel.setLayout(null);
        this.iconPanel.setBackground(Color.white);
        this.iconPanel.setBounds(new Rectangle(1, 2, 400, 110));
        this.iconPanel.setLayout(new GridLayout(1, 5));
        this.navigateTreesPanel.setBackground(Color.lightGray);
        this.navigateTreesPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.navigateTreesPanel.setBounds(new Rectangle(5, 112, 320, 35));
        this.navigateTreesPanel.setLayout(null);
        this.numTreesLabel.setBackground(Color.lightGray);
        this.numTreesLabel.setBounds(new Rectangle(5, 3, 50, 20));
        this.numTreesLabel.setFont(ClassificationTreeGUI.labelFont);
        this.numTreesLabel.setText(this.treeColl.getNumberTrees() + " Trees:");
        this.navigateTreesPanel.add(this.numTreesLabel);
        this.treeSlider = new JSlider(0, this.treeColl.getNumberTrees() - 1, 0);
        this.treeSlider.setBounds(new Rectangle(110, 5, 150, 28));
        this.treeSlider.setBackground(Color.lightGray);
        this.treeSlider.setMajorTickSpacing(1);
        this.treeSlider.setSnapToTicks(true);
        this.treeSlider.setPaintTicks(true);
        this.treeSlider.addChangeListener(new SliderListener());
        this.treeSlider.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                int increment = TreeLegendViewPanel.this.treeSlider.getWidth() / TreeLegendViewPanel.this.treeColl.getNumberTrees() - 1;
                TreeLegendViewPanel.this.treeSlider.setValue((e.getX() - 5) / increment);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        this.navigateTreesPanel.add((Component)this.treeSlider, null);
        this.prevTreeButton.setBounds(new Rectangle(55, 7, 45, 15));
        this.prevTreeButton.setFont(ClassificationTreeGUI.labelFont);
        this.prevTreeButton.setFocusPainted(false);
        this.prevTreeButton.setEnabled(false);
        this.prevTreeButton.setFont(ClassificationTreeGUI.buttonFont);
        this.navigateTreesPanel.add(this.prevTreeButton);
        this.nextTreeButton.setBounds(new Rectangle(270, 7, 45, 15));
        this.nextTreeButton.setFont(ClassificationTreeGUI.labelFont);
        this.nextTreeButton.setFocusPainted(false);
        this.nextTreeButton.setFont(ClassificationTreeGUI.buttonFont);
        this.navigateTreesPanel.add(this.nextTreeButton);
        this.prevTreeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TreeLegendViewPanel.this.treeSlider.getValue() != 0) {
                    TreeLegendViewPanel.this.treeSlider.setValue(TreeLegendViewPanel.this.treeSlider.getValue() - 1);
                }
            }
        });
        this.nextTreeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TreeLegendViewPanel.this.treeSlider.getValue() != TreeLegendViewPanel.this.treeColl.getNumberTrees() - 1) {
                    TreeLegendViewPanel.this.treeSlider.setValue(TreeLegendViewPanel.this.treeSlider.getValue() + 1);
                }
            }
        });
        String showtext = ClassificationTreeGUI.getText("treevis_legend_show_text");
        String splitdec = ClassificationTreeGUI.getText("treevis_legend_split_dec");
        String scoretext = ClassificationTreeGUI.getText("treevis_legend_score");
        String probstext = ClassificationTreeGUI.getText("treevis_legend_probs_text");
        String devtext = "";
        if (!this.treeColl.isRegression()) {
            String crit = this.treeColl.getCriterion();
            if (this.treeColl.miningSchema_attribute_entropy_value.equals(crit)) {
                devtext = ClassificationTreeGUI.getText("treevis_legend_entropy_text");
            } else if (this.treeColl.miningSchema_attribute_gini_value.equals(crit)) {
                devtext = ClassificationTreeGUI.getText("treevis_legend_gini_text");
            } else {
                System.out.println("Error: unsupported tree type (" + crit + ").");
                devtext = ClassificationTreeGUI.getText("treevis_legend_dev_text");
            }
        }
        String risktext = "";
        risktext = this.treeColl.isRegression() ? ClassificationTreeGUI.getText("treevis_legend_sumsquarederror_text") : ClassificationTreeGUI.getText("treevis_legend_misclassification_text");
        this.customizeNodeLabel.setFont(ClassificationTreeGUI.labelFont);
        this.customizeNodeLabel.setText(showtext);
        this.customizeNodeLabel.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.customizeNodeLabel.setFont(ClassificationTreeGUI.titleFont);
        this.customizeNodeLabel.setBounds(new Rectangle(5, 3, 113, 17));
        int offset = 0;
        if (this.treeColl.isRegression()) {
            offset = 5;
        }
        this.splitCheckbox.setFocusPainted(false);
        this.splitCheckbox.setSelected(true);
        this.splitCheckbox.setText(splitdec);
        this.splitCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.splitCheckbox.setBackground(Color.white);
        this.splitCheckbox.setActionCommand("splitCheckbox");
        this.splitCheckbox.setFont(ClassificationTreeGUI.labelFont);
        this.splitCheckbox.setBounds(new Rectangle(6, 18 + offset, 136, 17));
        this.splitCheckbox.addItemListener(customizeNodeListener);
        this.scoreCheckbox.setFocusPainted(false);
        this.scoreCheckbox.setSelected(true);
        this.scoreCheckbox.setText(scoretext);
        this.scoreCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.scoreCheckbox.setBackground(Color.white);
        this.scoreCheckbox.setActionCommand("scoreCheckbox");
        this.scoreCheckbox.setFont(ClassificationTreeGUI.labelFont);
        this.scoreCheckbox.setBounds(new Rectangle(6, 33 + offset, 73, 17));
        this.scoreCheckbox.addItemListener(customizeNodeListener);
        this.nodeSizeCheckbox.setFocusPainted(false);
        this.nodeSizeCheckbox.setSelected(true);
        this.nodeSizeCheckbox.setText(numrecs);
        this.nodeSizeCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.nodeSizeCheckbox.setBackground(Color.white);
        this.nodeSizeCheckbox.setActionCommand("nodeSizeCheckbox");
        this.nodeSizeCheckbox.setFont(ClassificationTreeGUI.labelFont);
        this.nodeSizeCheckbox.setBounds(new Rectangle(6, 48 + offset, 110, 17));
        this.nodeSizeCheckbox.addItemListener(customizeNodeListener);
        this.riskCheckbox.setFocusPainted(false);
        this.riskCheckbox.setSelected(true);
        this.riskCheckbox.setText(risktext);
        this.riskCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.riskCheckbox.setBackground(Color.white);
        this.riskCheckbox.setFont(ClassificationTreeGUI.labelFont);
        this.riskCheckbox.setActionCommand("riskCheckbox");
        this.riskCheckbox.setBounds(new Rectangle(6, 63 + offset, 137, 17));
        this.riskCheckbox.addItemListener(customizeNodeListener);
        if (!this.treeColl.isRegression()) {
            this.deviationCheckbox.setFocusPainted(false);
            this.deviationCheckbox.setSelected(true);
            this.deviationCheckbox.setText(devtext);
            this.deviationCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
            this.deviationCheckbox.setBackground(Color.white);
            this.deviationCheckbox.setFont(ClassificationTreeGUI.labelFont);
            this.deviationCheckbox.setActionCommand("deviationCheckbox");
            this.deviationCheckbox.setBounds(new Rectangle(6, 78, 137, 17));
            this.deviationCheckbox.addItemListener(customizeNodeListener);
            this.probCheckbox.setFocusPainted(false);
            this.probCheckbox.setSelected(true);
            this.probCheckbox.setText(probstext);
            this.probCheckbox.setForeground(ColorBroker.getColor("nodeDetailsColor"));
            this.probCheckbox.setBackground(Color.white);
            this.probCheckbox.setActionCommand("probCheckbox");
            this.probCheckbox.setFont(ClassificationTreeGUI.labelFont);
            this.probCheckbox.setBounds(new Rectangle(6, 93, 102, 17));
            this.probCheckbox.addItemListener(customizeNodeListener);
        }
        this.customizeDisplayPanel.add((Component)this.customizeNodeLabel, null);
        this.customizeDisplayPanel.add((Component)this.splitCheckbox, null);
        this.customizeDisplayPanel.add((Component)this.nodeSizeCheckbox, null);
        this.customizeDisplayPanel.add((Component)this.scoreCheckbox, null);
        this.customizeDisplayPanel.add((Component)this.riskCheckbox, null);
        if (!this.treeColl.isRegression()) {
            this.customizeDisplayPanel.add((Component)this.deviationCheckbox, null);
            this.customizeDisplayPanel.add((Component)this.probCheckbox, null);
        }
        String classes = "";
        classes = this.tree.isRegression() ? ClassificationTreeGUI.getText("treevis_legend_predictionval") : ClassificationTreeGUI.getText("treevis_legend_classes");
        this.iconPanel.add((Component)this.ratingPanel, null);
        this.iconPanel.add((Component)this.customizeDisplayPanel, null);
        this.backgroundPanel.add((Component)this.iconPanel, null);
        this.showLegendLabel.setText(classes);
        this.showLegendLabel.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        this.showLegendLabel.setFont(ClassificationTreeGUI.titleFont);
        this.showLegendLabel.setBounds(new Rectangle(5, 3, 113, 17));
        this.ratingPanel.setBackground(Color.white);
        this.ratingPanel.setBounds(new Rectangle(2, 2, 167, 148));
        this.ratingPanel.setLayout(null);
        this.ratingPanel.add(this.showLegendLabel);
        if (this.tree.isRegression()) {
            if (this.tree.min_score == Double.NEGATIVE_INFINITY || this.tree.min_score == Double.POSITIVE_INFINITY) {
                this.tree.min_score = 0.0;
            }
            if (this.tree.max_score == Double.POSITIVE_INFINITY || this.tree.max_score == Double.NEGATIVE_INFINITY) {
                this.tree.max_score = 0.0;
            }
            double[] example_prob = new double[]{0.0};
            this.legendIcon = new ClassificationRegressionTreeIcon(this.treeColl, example_prob, 0.1, -1.0, -1.0, false, true, false, true, true);
            this.regMinLabel = new JLabel(this.treeColl.getDependentVar() + " = " + ClassificationRegressionTreeNode.doubleToFormatedString(this.tree.min_score), this.legendIcon, 2);
            this.regMinLabel.setFont(ClassificationTreeGUI.labelFont);
            this.regMinLabel.setBounds(new Rectangle(5, 21, 200, 24));
            this.ratingPanel.add(this.regMinLabel);
            if (this.tree.min_score != this.tree.max_score) {
                example_prob[0] = 0.5;
                this.legendIcon = new ClassificationRegressionTreeIcon(this.treeColl, example_prob, 1.5708748705384235, -1.0, -1.0, false, true, false, true, true);
                this.regMedLabel = new JLabel(this.treeColl.getDependentVar() + " = " + ClassificationRegressionTreeNode.doubleToFormatedString(0.5 * (this.tree.max_score + this.tree.min_score)), this.legendIcon, 2);
                this.regMedLabel.setFont(ClassificationTreeGUI.labelFont);
                this.regMedLabel.setBounds(new Rectangle(5, 41, 200, 24));
                this.ratingPanel.add(this.regMedLabel);
                example_prob[0] = 1.0;
                this.legendIcon = new ClassificationRegressionTreeIcon(this.treeColl, example_prob, 3.141278494324434, -1.0, -1.0, false, true, false, true, true);
                this.regMaxLabel = new JLabel(this.treeColl.getDependentVar() + " = " + ClassificationRegressionTreeNode.doubleToFormatedString(this.tree.max_score), this.legendIcon, 2);
                this.regMaxLabel.setFont(ClassificationTreeGUI.labelFont);
                this.regMaxLabel.setBounds(new Rectangle(5, 61, 200, 24));
                this.ratingPanel.add(this.regMaxLabel);
            }
        } else {
            double[] prob = new double[this.treeColl.getNumCatVarsArray()[this.treeColl.getDependentVarIndex()]];
            ClassificationRegressionTreeIcon[] icons = new ClassificationRegressionTreeIcon[prob.length];
            for (int i = 0; i < prob.length; ++i) {
                prob[i] = 1.0;
                if (i > 0) {
                    prob[i - 1] = 0.0;
                }
                icons[i] = this.legendIcon = new ClassificationRegressionTreeIcon(this.treeColl, prob, 0.0, -1.0, -1.0, false, true, false, true, false);
                icons[i].setDescription(this.treeColl.getLevelName(this.treeColl.getDependentVarIndex(), i));
            }
            JList<ClassificationRegressionTreeIcon> jlist = new JList<ClassificationRegressionTreeIcon>(icons);
            jlist.setSelectionBackground(Color.white);
            jlist.setSelectionForeground(Color.black);
            Renderer renderer = new Renderer();
            renderer.setPreferredSize(new Dimension(100, 15));
            jlist.setCellRenderer(renderer);
            JScrollPane legendScrollPane = new JScrollPane();
            JScrollBar scrollbar = new JScrollBar();
            legendScrollPane.setVerticalScrollBar(scrollbar);
            legendScrollPane.setBounds(5, 20, 165, 64);
            legendScrollPane.setRequestFocusEnabled(false);
            legendScrollPane.setHorizontalScrollBarPolicy(31);
            legendScrollPane.getViewport().add(jlist);
            this.ratingPanel.add(legendScrollPane);
        }
        JLabel viewByLevelLabel = new JLabel(ClassificationTreeGUI.getText("treevis_legend_viewbylevel"));
        viewByLevelLabel.setBounds(6, 90, 70, 15);
        viewByLevelLabel.setForeground(ColorBroker.getColor("nodeDetailsColor"));
        viewByLevelLabel.setFont(ClassificationTreeGUI.titleFont);
        this.ratingPanel.add(viewByLevelLabel);
        JButton downLevelButton = new JButton("<");
        downLevelButton.setRequestFocusEnabled(false);
        downLevelButton.setBounds(79, 90, 43, 15);
        downLevelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeLegendViewPanel.this.gui.collapseLevel();
            }
        });
        JButton upLevelButton = new JButton(">");
        upLevelButton.setBounds(126, 90, 43, 15);
        upLevelButton.setRequestFocusEnabled(false);
        upLevelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeLegendViewPanel.this.gui.expandLevel();
            }
        });
        this.ratingPanel.add(downLevelButton);
        this.ratingPanel.add(upLevelButton);
        this.ratingPanel.setVisible(true);
        if (this.treeColl.getNumberTrees() > 1) {
            this.backgroundPanel.add((Component)this.navigateTreesPanel, null);
        }
    }

    public void setCheckboxDefaults() {
        this.nodeSizeCheckbox.setSelected(false);
        this.scoreCheckbox.setSelected(false);
        this.riskCheckbox.setSelected(false);
        this.deviationCheckbox.setSelected(false);
        this.probCheckbox.setSelected(false);
        if (this.treeColl.isRegression()) {
            this.treeColl.setDisplayDeviance(false);
            this.treeColl.setDisplayProbs(false);
        }
    }

    private void expandButton_actionPerformed(ActionEvent e) {
        this.gui.expandAll();
    }

    private void pruneButton_actionPerformed(ActionEvent e) {
    }

    public void enablePrevTreeButton(boolean flag) {
        this.prevTreeButton.setEnabled(flag);
    }

    public void enableNextTreeButton(boolean flag) {
        this.nextTreeButton.setEnabled(flag);
    }

    private class Renderer
    extends JLabel
    implements ListCellRenderer {
        public Renderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ClassificationRegressionTreeIcon icon = (ClassificationRegressionTreeIcon)value;
            this.setText(icon.getDescription());
            this.setFont(ClassificationTreeGUI.labelFont);
            this.setIcon(icon);
            return this;
        }
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == TreeLegendViewPanel.this.splitCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplaySplit(true);
            } else if (source == TreeLegendViewPanel.this.nodeSizeCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplaySize(true);
            } else if (source == TreeLegendViewPanel.this.scoreCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplayScore(true);
            } else if (source == TreeLegendViewPanel.this.probCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplayProbs(true);
            } else if (source == TreeLegendViewPanel.this.deviationCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplayDeviance(true);
            } else if (source == TreeLegendViewPanel.this.riskCheckbox) {
                TreeLegendViewPanel.this.treeColl.setDisplayRisk(true);
            }
            if (e.getStateChange() == 2) {
                if (source == TreeLegendViewPanel.this.splitCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplaySplit(false);
                } else if (source == TreeLegendViewPanel.this.nodeSizeCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplaySize(false);
                } else if (source == TreeLegendViewPanel.this.scoreCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplayScore(false);
                } else if (source == TreeLegendViewPanel.this.probCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplayProbs(false);
                } else if (source == TreeLegendViewPanel.this.deviationCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplayDeviance(false);
                } else if (source == TreeLegendViewPanel.this.riskCheckbox) {
                    TreeLegendViewPanel.this.treeColl.setDisplayRisk(false);
                }
            }
            TreeLegendViewPanel.this.gui.getJTree().updateUI();
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int val = source.getValue();
            TreeLegendViewPanel.this.gui.viewTree(val);
        }
    }
}

