/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.bridge;

import com.insightful.splusserver.api.bridge.CommonServerBridge;
import com.insightful.splusserver.api.bridge.IExpressionServiceBridge;
import com.insightful.splusserver.exception.JobDoesNotExistException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.UrlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionServiceBridgeUrl
extends CommonServerBridge
implements IExpressionServiceBridge {
    public ExpressionServiceBridgeUrl(String serviceUrl) throws BridgeException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        this.ping();
    }

    public ExpressionServiceBridgeUrl(String userName, String password, String serviceUrl) throws BridgeException, NotAuthenticatedException, ServerNotRespondingException {
        this.setServiceUrl(serviceUrl);
        if (this.ping().booleanValue()) {
            this.setUserName(userName);
            this.setPassword(password);
            if (!this.validateUserCredentials().booleanValue()) {
                throw new NotAuthenticatedException("Invalid credentials");
            }
        }
    }

    public String eval(String cmd, Boolean async) throws BridgeException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/expression/" + "eval?cmd=" + UrlUtil.escapeUrl((String)cmd) + "&async=" + (async != null ? async : Boolean.FALSE);
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    public String eval(String cmd, long startTime) throws BridgeException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/expression/" + "eval?cmd=" + UrlUtil.escapeUrl((String)cmd) + "&at=" + startTime;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
    }

    public String getJob(String jobId) throws BridgeException, JobDoesNotExistException, NotAuthenticatedException {
        try {
            String url = this.getServiceUrl() + "/api/expression/" + "getJob" + "?" + "jobId" + "=" + jobId;
            String xml = this.readUrlResult(url);
            if ("<authentication status=\"false\" />".equals(xml)) {
                throw new NotAuthenticatedException();
            }
            if (xml == null || xml.indexOf("HTTP Status 500") >= 0) {
                throw new JobDoesNotExistException("Job does not exists for: " + jobId);
            }
            return xml;
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new BridgeException("Creation of URL failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new JobDoesNotExistException((Throwable)e);
        }
    }

    protected Log getLogger() {
        return LogFactory.getLog(ExpressionServiceBridgeUrl.class);
    }
}

