/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.LogicalMessageContextImpl;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.XMLHandlerProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;

public class ClientLogicalHandlerTube
extends HandlerTube {
    private WSBinding binding;
    private List<LogicalHandler> logicalHandlers;

    public ClientLogicalHandlerTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(tube, wSDLPort);
        this.binding = wSBinding;
    }

    public ClientLogicalHandlerTube(WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube);
        this.binding = wSBinding;
    }

    private ClientLogicalHandlerTube(ClientLogicalHandlerTube clientLogicalHandlerTube, TubeCloner tubeCloner) {
        super(clientLogicalHandlerTube, tubeCloner);
        this.binding = clientLogicalHandlerTube.binding;
    }

    boolean isHandlerChainEmpty() {
        return this.logicalHandlers.isEmpty();
    }

    public void close(MessageContext messageContext) {
        if (this.requestProcessingSucessful && this.cousinTube != null) {
            this.cousinTube.closeCall(messageContext);
        }
        if (this.processor != null) {
            this.closeLogicalHandlers(messageContext);
        }
    }

    public void closeCall(MessageContext messageContext) {
        this.closeLogicalHandlers(messageContext);
    }

    private void closeLogicalHandlers(MessageContext messageContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(messageContext, this.processor.getIndex(), 0);
            this.processor.setIndex(-1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(messageContext, this.logicalHandlers.size() - 1, 0);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ClientLogicalHandlerTube(this, tubeCloner);
    }

    void setUpProcessor() {
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        List<LogicalHandler> list = ((BindingImpl)this.binding).getHandlerConfig().getLogicalHandlers();
        if (!list.isEmpty()) {
            this.logicalHandlers.addAll(list);
            this.processor = this.binding.getSOAPVersion() == null ? new XMLHandlerProcessor(this, this.binding, this.logicalHandlers) : new SOAPHandlerProcessor(true, this, this.binding, this.logicalHandlers);
        }
    }

    MessageUpdatableContext getContext(Packet packet) {
        return new LogicalMessageContextImpl(this.binding, packet);
    }

    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, !bl);
        }
        catch (WebServiceException webServiceException) {
            this.remedyActionTaken = true;
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw new WebServiceException(runtimeException);
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }
}

