/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.event.AxisChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public abstract class ValueAxis
extends Axis {
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final double DEFAULT_MINIMUM_AXIS_VALUE = 0.0;
    public static final double DEFAULT_MAXIMUM_AXIS_VALUE = 1.0;
    public static final Stroke DEFAULT_GRID_LINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRID_LINE_PAINT = Color.gray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRID_LINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected boolean autoRange;
    protected double fixedAutoRange;
    protected double minimumAxisValue;
    protected double maximumAxisValue;
    protected boolean autoTickUnitSelection;
    protected int autoTickIndex;
    protected boolean gridLinesVisible;
    protected Stroke gridStroke;
    protected Paint gridPaint;
    protected double anchorValue;
    protected boolean crosshairVisible;
    protected double crosshairValue;
    protected Stroke crosshairStroke;
    protected Paint crosshairPaint;
    protected boolean crosshairLockedOnData = true;

    protected ValueAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, DEFAULT_GRID_LINE_STROKE, DEFAULT_GRID_LINE_PAINT, false, 0.0, DEFAULT_CROSSHAIR_STROKE, DEFAULT_CROSSHAIR_PAINT);
    }

    protected ValueAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke, boolean bl3, boolean bl4, boolean bl5, Stroke stroke2, Paint paint3, boolean bl6, double d, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, stroke);
        this.autoRange = bl3;
        this.fixedAutoRange = 0.0;
        this.autoTickUnitSelection = bl4;
        this.gridLinesVisible = bl5;
        this.gridStroke = stroke2;
        this.gridPaint = paint3;
        this.crosshairValue = d;
        this.crosshairStroke = stroke3;
        this.crosshairPaint = paint4;
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getMinimumAxisValue() {
        return this.minimumAxisValue;
    }

    public void setMinimumAxisValue(double d) {
        if (this.minimumAxisValue != d) {
            this.minimumAxisValue = d;
            this.autoRange = false;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getMaximumAxisValue() {
        return this.maximumAxisValue;
    }

    public void setMaximumAxisValue(double d) {
        if (this.maximumAxisValue != d) {
            this.maximumAxisValue = d;
            this.autoRange = false;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setAxisRange(double d, double d2) {
        this.autoRange = false;
        this.minimumAxisValue = d;
        this.maximumAxisValue = d2;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isGridLinesVisible() {
        return this.gridLinesVisible;
    }

    public void setGridLinesVisible(boolean bl) {
        if (this.gridLinesVisible != bl) {
            this.gridLinesVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("ValueAxis.setGridStroke(...): null not permitted");
        }
        this.gridStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getGridPaint() {
        return this.gridPaint;
    }

    public void setGridPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("ValueAxis.setGridPaint(...): null not permitted");
        }
        this.gridPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.anchorValue = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isCrosshairVisible() {
        return this.crosshairVisible;
    }

    public void setCrosshairVisible(boolean bl) {
        if (this.crosshairVisible != bl) {
            this.crosshairVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isCrosshairLockedOnData() {
        return this.crosshairLockedOnData;
    }

    public void setCrosshairLockedOnData(boolean bl) {
        if (this.crosshairLockedOnData != bl) {
            this.crosshairLockedOnData = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getCrosshairValue() {
        return this.crosshairValue;
    }

    public void setCrosshairValue(double d) {
        this.crosshairValue = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getCrosshairStroke() {
        return this.crosshairStroke;
    }

    public void setCrosshairStroke(Stroke stroke) {
        this.crosshairStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint paint) {
        this.crosshairPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double translateValueToJava2D(double var1, Rectangle2D var3);

    public abstract double translateJava2DtoValue(float var1, Rectangle2D var2);

    protected abstract void autoAdjustRange();

    public void setAnchoredRange(double d) {
        double d2 = this.anchorValue - d / 2.0;
        double d3 = this.anchorValue + d / 2.0;
        this.setAxisRange(d2, d3);
    }
}

