/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class VerticalXYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected double margin;

    public VerticalXYBarRenderer() {
        this(0.0);
    }

    public VerticalXYBarRenderer(double d) {
        this.margin = d;
    }

    public void setMargin(double d) {
        Double d2 = new Double(this.margin);
        this.margin = d;
        this.firePropertyChanged("VerticalXYBarRenderer.margin", d2, new Double(d));
    }

    public Shape drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, double d, CrosshairInfo crosshairInfo) {
        Rectangle2D.Double double_ = null;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = xYPlot.getSeriesPaint(n);
        Paint paint2 = xYPlot.getSeriesOutlinePaint(n);
        Number number = intervalXYDataset.getYValue(n, n2);
        double d2 = valueAxis2.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalXYDataset.getStartXValue(n, n2);
        double d3 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        Number number3 = intervalXYDataset.getEndXValue(n, n2);
        double d4 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d5 = Math.max(1.0, d4 - d3);
        double d6 = Math.abs(d2 - d);
        if (this.margin > 0.0) {
            double d7 = d5 * this.margin;
            d5 -= d7;
            d3 += d7 / 2.0;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d3, Math.min(d, d2), d5, d6);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        double_ = double_2;
        if (d4 - d3 > 3.0) {
            graphics2D.setStroke(xYPlot.getSeriesOutlineStroke(n));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_2);
        }
        return double_;
    }
}

