#ifndef PTHREADALIASES_H
#define PTHREADALIASES_H

   /** This file defines the aliases for the basic/generic commands used
       with threads in terms of the Pthreads primitives
     */
#include <pthread.h>

typedef pthread_t Thread;
typedef pthread_key_t ThreadKey;

typedef pthread_mutex_t MUTEX;
typedef pthread_cond_t COND_VAR;

typedef pthread_attr_t ThreadAttributes;

#define TRY_LOCK(mtx) pthread_mutex_trylock((mtx))
#define LOCK(mtx)  pthread_mutex_lock((mtx))
#define UNLOCK(mtx)  pthread_mutex_unlock((mtx))
#define COND_WAIT(cond, mtx) pthread_cond_wait((cond),(mtx))

#define COND_SIGNAL(cond) pthread_cond_signal((cond))
#define COND_BROADCAST(cond) pthread_cond_broadcast((cond))


#define MUTEX_INIT(m) pthread_mutex_init((m), (pthread_mutexattr_t*)NULL);
#define COND_VAR_INIT(m) pthread_cond_init((m), (pthread_condattr_t*)NULL);

#define MUTEX_DESTROY(m) if(m) pthread_mutex_destroy((m))
#define COND_VAR_DESTROY(m) if(m) pthread_cond_destroy((m))

#if defined(SUPPORTS_THREAD_YIELD)
#define YIELD() pthread_yield()
#else
#define YIELD() 
#endif

#define SET_TSD(key, val)  pthread_setspecific(key, val)
#define GET_TSD(key)  pthread_getspecific(key)


#define THREAD_ATTR_INIT(attr) pthread_attr_init(attr)


typedef struct _LockElement {
 
  MUTEX *lock;
  struct _LockElement *next;
  
} LockElement, *LockList;


#endif
