/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_eval.h,v $: $Revision: #21 $, $Date: 2006/06/26 $  */
#ifndef S_S_EVAL_H
#define S_S_EVAL_H 1

#include "libext.h"
S_begin_extern_c

#ifdef S_LEVEL_THREADS
       /* How a routine declares and computes its own S_evaluator. */
#ifdef KERNEL_THREADS   /* from Thread.h */
#define S_EVALUATOR  s_evaluator *S_evaluator = get_current_evaluator();
#else
#define S_EVALUATOR
#endif
#endif
#ifndef S_LEVEL_THREADS
#define S_EVALUATOR
#define ELOCK(a)
#define EUNLOCK(a)
#endif

#include <setjmp.h>
#include "S_classes.h"
#include "io_defs.h"
#include "ThreadEnums.h"
#include "options.h"

/* these structs are defined in eval.h */
typedef struct s_bucket S_bucket;
typedef struct s_arena S_arena;
typedef struct s_global_data_struct s_global_data;
typedef struct s_f_table_struct s_f_table;
typedef struct tname_chunk_struct tname_chunk;
typedef struct s_old_method_struct s_old_method;


typedef struct s_evaluator_struct s_evaluator;

long S_pop_Restart(long frame_num) ;
long S_set_Restart(int flag, long frame_num) ;


struct s_evaluator_struct {
  s_index id;
  s_object *_evalAction; /* how to eval. tasks; e.g, standardEval*/
  /* now the evaluation frames and many parallel things.  The
     structure goes to considerable length to make access simple and
     fast, since evaluation is everything, at cost of large thread
     structure */
  s_object *_Frames; /* the vector of eval. frames */
  long _Nframe;      /* the current eval. frame */
  s_object *_Local_data; /* and its frame pointer */
  s_object *_call_stack;  /* parallel to Frames: the calls, */
  s_object *_args_stack;  /* their arguments, */
  s_object *_fun_stack;   /* the function definitions, */
  s_object *_match_stack; /* (obsolete?) match of args to formals, */
  s_object *_Parent;      /* parent frames index, */
  s_object *_ret_stack;   /* return flags, */
  s_object *_break_stack; /* break from loop flags, */
  s_object *_next_stack;  /* next in loop flags, */
  s_object *_On_stop;     /* on.exit actions, */
  s_object *_C_on_stop;   /* C exit calls, */
  s_object *_C_assign;    /* (almost obsolete) special assigns, */
  long *_parent_frame;    /* Parent->value.Long, */
  s_object *_N_call_args; /* no. of arguments in call, */
  char ** _call_names;    /* the names of the functions, */
  jmp_buf **_frame_jmp;   /* where to jump in C stack on error, */
  s_name_table **_f_tables;/*name tables for local frame lookup, */
  s_object **_f_args;     /* the lists of actual arguments, */
  s_object **_ret_vals;   /* the return values, while waiting for return,*/
  s_object **_C_specials; /* els of C_assign, */
  long *_breaks;          /* els of break_stack, */
  long *_nexts;           /* els of next_stack. THE END! */
  int _eval_open;
  long _eval_count; /* a count of expr's evaluated */
  long _Nexpr; /* the expression depth */
  int _interrupt_code;
  int _saw_interrupt;
  char *_last_method_name;
  s_name_table *_Generics; /* all mtable objects so far formed (cast to s_index) */
  s_name_table *_GroupGenerics; /* table of group members, index in */
  s_object *_GroupGenericsObject; /* this object */

  /* control & check for quick_call's to .Internal */
  char *_quick_name; long _quick_frame; long _quick_arg_frame;
  s_object *_quick_save;
  int _sys_index; /* last index for call to .Internal */
  int _Restart; /* the frame for restarting: set by S_init or eval */
#if !defined(LINUX)
  /* On linux sizeof(jmp_buf) varies from system to system: put at end */
  jmp_buf _S_error_jmp; /* where to jump on an error */
#else
  char _jmp_buf_spacer[156] ; /* sizeof(jmp_buf) on RedHat 2.0.31 */
#endif
  int _ntry; /* no. of errors in a row before killing */
  s_object *_last_match;
  struct s_options *_S_options; /* C mirror of S options stuff */
  long _thread_storage_frame; /* the frame to use as the thread's storage "FRAME0" */
  long _cur_frame; /* the thread's current allocation frame (set by set_alloc) */
  S_arena **_evArenas; /* the storage structures for the evaluator */
  S_bucket **_evBuckets;
  S_arena *_cur_arena;

  S_bucket *_cur_bucket;
  char *_cur_block;
  long _cur_used;

  long *_Match_to;
  long _Mlength;

  s_index_table **_evFrame_maps;
  long _max_frames;
  int _quit_flag; /* signal quit from evaluator */
  long *_meta_data_index; /* db indexes forming the search list */
  long *_help_data_index;
  long *_search_data_index;
  long _end_search_data;
  long _max_search_data;
  long _thread_data_index;
  long _thread_meta_index;
  s_index_table *_search_db_table; /* table of db pos'ns in search list*/
  s_name_table *_asgn_table; /* table of objects perm. assigned in task */
  s_name_table *_objects_read; /* table of global objects read in task */
  s_global_data *_global_data; /* names of these objects, linked list by frame */
  int _cur_interact;   /* flag indicating whether this thread is interactive or a sub-thread or system thread performing an internal task */
  int _clearing_frame_int; 
  s_object *_clearing_frame_frame;

/* some code for caching and retrieving old-style method functions */
/* The actual function pointer is only filled in when we believe the */
/* function has been retrieved from the database table (so it won't */
/* get copied out from under us).  Typically this will happen (at */
/* least) on the first retrieval in a later task. */
  s_name_table *_old_methods_table;
  s_old_method *_last_old_method;

/* temporary for debugging: eventually will be a stack parallel to */
/* Frames */
  s_name_table *_frame_f_names;
  s_boolean _made_f_names_here;

  s_index _last_local_index;
  mtable *_last_mtable; 
  s_name *_last_gen_name;
  long _leaving_frame;

  int _dots_position;  /* communicate where the ... arg was to evalMethod */
  int _no_quick_match;

  int _save_err_opt;
  int _save_int_opt;

  s_object *_Warn_list;
  char *_last_error_message;
  char *_error_buf;
  char *_save_error_buf; 
  long _error_buf_length;
  int _error_buf_used;
  S_FILE *_error_file;

  s_name_table *_repl_fun_table;

/*  
  tname_chunk _tname_chunk_buf;
  s_name_table *_tname_table;
*/
  double *_dvalues;
  double *_dtable_values;
  
  S_FILE *_S_stdin;
  S_FILE *_S_stdout;
  S_FILE *_S_stderr;


  s_connection *_standard_connections[N_STANDARD_STREAMS];
  connection_save *_save_streams[N_STANDARD_STREAMS];
  s_object *_std_connection_obj[N_STANDARD_STREAMS];

  s_name_table *_expr_names_t;
 
   /* From data.c */
  s_index_table *_f_def_table; /* or directly by definition (object)*/
  s_name_table *_f_table; /* currently known functions by name */
  s_f_table *_f_defs;
  int _cur_f_table;
  int _max_f_table;

  s_boolean _stop_in_progress;


   /* The mutex and condition variable are used by other threads 
      to communicate with this one in order to control
      the run time status of this thread.
      E.g. the global controller thread can set a flag in this thread 
           or a global flag to tell it do something different 
           e.g. quit/kill itself
    */
  MUTEX *mtx;          
  COND_VAR *cond;   
  ThreadStatus status;           /* Describes the current state of the thread */
  ThreadStatus previous_status;

  MUTEX _last_value_lock;
  s_object *_last_task_value;

  s_boolean owns_db_lock;
  long lock_count;
  LockList locks;   /* Linked list of locks currently held by the evaluator in this task.
                       eval_close should remove all the entries in this list.
                     */

  struct _EvalThread_struct *eval_thread;  /* The EvalThread object that supports multiple tasks evaluated
                                      within this evaluator. */
                                      
#if defined(USE_NOTIFICATION) /*(*/
  s_boolean notifications_on;
#endif /*)*/
#if defined(LINUX)
  jmp_buf _S_error_jmp; /* where to jump on an error */
#endif
  s_object *_no_free_headers_in_any_bucket ; /* to speed up get_header */
};

#define set_local(val, name)  set_in_frame(Nframe, val, name, S_evaluator)

#if defined(KERNEL_THREADS) /*(*/
LibExtern s_evaluator * S_STDCALL get_current_evaluator();
#else
LibExtern s_evaluator *S_evaluator;
#endif
LibExtern s_object *find_in_frame(s_name *name, long n, s_evaluator *S_evaluator);
LibExtern s_object *get_from_asgn_table(s_name *name, s_evaluator *S_evaluator);
LibExtern s_boolean was_set_for_perm_removal(s_name *name, s_evaluator *S_evaluator);
LibExtern s_boolean was_set_for_perm_assign(s_name *name, s_evaluator *S_evaluator);

LibExtern s_object* S_closure_create_environment(s_object* frame_obj);
LibExtern long S_closure_getClosureEnvFrame(char* envName, s_evaluator *S_evaluator);
LibExtern char* S_closure_getClosureEnvParent(char* envName, s_evaluator *S_evaluator);
LibExtern s_object* S_closure_getFrameClosureLookupVar(s_name *name, long frame, s_evaluator *S_evaluator);
LibExtern void S_closure_saveFrameClosureInfo(long frame, s_evaluator *S_evaluator);
LibExtern void S_closure_setFrameClosure(long frame, char* ceName, s_evaluator *S_evaluator);
LibExtern char* S_closure_getFrameClosure(long frame, s_evaluator *S_evaluator);
LibExtern void S_closure_setFrameParentClosure(long frame, char* ceName, s_evaluator *S_evaluator);
LibExtern char* S_closure_getFrameParentClosure(long frame, s_evaluator *S_evaluator);
LibExtern int S_closure_isClosureFunction(s_object* obj, s_evaluator *S_evaluator);


LibExtern void S_STDCALL set_error_buf(s_evaluator *S_evaluator);
LibExtern void set_error_buf_length(long new_len, s_evaluator *S_evaluator);
LibExtern char *s_get_message(s_evaluator *S_evaluator);
LibExtern s_object *old_is_classes(s_class *cl, s_evaluator *S_evaluator);

extern void ld_init(s_evaluator *S_evaluator); /* in S_ld_init.c */

/* find db position for given named object (CRD)*/
LibExtern int db_find_named(int *db_found, s_object *objToFind, const char *name, s_evaluator *S_evaluator);

/* remove given named object from db it is found in (CRD)*/
LibExtern int db_remove_named(int *db_found, s_object *objToRemove, const char *name, s_evaluator *S_evaluator);

/* return pointer to the unhased marker */
LibExtern s_name* S_STDCALL get_unhashedMarker(void);

/* uncache data previously cached after reading from disk */ 
LibExtern int S_STDCALL db_uncached_objs(long lWhere, s_evaluator *S_evaluator);

#define NULL_THREAD (s_evaluator *)0

#define error_buf          S_evaluator->_error_buf
#define error_file	   S_evaluator->_error_file

#define S_stdin            S_evaluator->_S_stdin
#define S_stdout           S_evaluator->_S_stdout
#define S_stderr           S_evaluator->_S_stderr

#define Nframe             S_evaluator->_Nframe
#define cur_frame          S_evaluator->_cur_frame

#if defined(S_COMPATIBILITY) && S_COMPATIBILITY >= 10 /* PRIVATE DEFINES (*/
#define f_defs             S_evaluator->_f_defs
#define f_def_table        S_evaluator->_f_def_table
#define f_table            S_evaluator->_f_table
#define cur_f_table        S_evaluator->_cur_f_table
#define max_f_table        S_evaluator->_max_f_table

#define stop_in_progress   S_evaluator->_stop_in_progress
#define Warn_list          S_evaluator->_Warn_list
#define last_error_message S_evaluator->_last_error_message
#define save_error_buf     S_evaluator->_save_error_buf
#define error_buf_length   S_evaluator->_error_buf_length
#define error_buf_used     S_evaluator->_error_buf_used

#define expr_names_t 	S_evaluator->_expr_names_t

#define standard_connections	S_evaluator->_standard_connections
#define save_streams		S_evaluator->_save_streams
#define std_connection_objs	S_evaluator->_std_connection_objs

#define dvalues		S_evaluator->_dvalues
#define dtable_values	S_evaluator->_dtable_values
#define tname_table	S_evaluator->_tname_table
#define tname_chunk_buf	S_evaluator->_tname_chunk_buf
#define repl_fun_table	S_evaluator->_repl_fun_table
#define save_err_opt	S_evaluator->_save_err_opt
#define save_int_opt	S_evaluator->_save_int_opt
#define no_quick_match	S_evaluator->_no_quick_match
#define dots_position	S_evaluator->_dots_position
#define leaving_frame	S_evaluator->_leaving_frame
#define last_gen_name	S_evaluator->_last_gen_name
#define last_task_value S_evaluator->_last_task_value
#define last_value_lock S_evaluator->_last_value_lock
#define last_mtable	S_evaluator->_last_mtable
#define old_methods_table	S_evaluator->_old_methods_table
#define last_old_method	S_evaluator->_last_old_method
#define frame_f_names	S_evaluator->_frame_f_names
#define made_f_names_here	S_evaluator->_made_f_names_here
#define last_local_index	S_evaluator->_last_local_index

#define evalAction	S_evaluator->_evalAction
#define cur_arena	S_evaluator->_cur_arena
#define cur_bucket	S_evaluator->_cur_bucket
#define cur_block	S_evaluator->_cur_block
#define cur_used	S_evaluator->_cur_used
#define Frames		S_evaluator->_Frames
#define Match_to	S_evaluator->_Match_to
#define Mlength		S_evaluator->_Mlength

#define clearing_frame_int	S_evaluator->_clearing_frame_int 
#define clearing_frame_frame	S_evaluator->_clearing_frame_frame

#define Local_data	S_evaluator->_Local_data
#define call_stack	S_evaluator->_call_stack
#define args_stack	S_evaluator->_args_stack
#define fun_stack	S_evaluator->_fun_stack
#define match_stack	S_evaluator->_match_stack
#define Parent		S_evaluator->_Parent
#define ret_stack	S_evaluator->_ret_stack
#define break_stack	S_evaluator->_break_stack
#define next_stack	S_evaluator->_next_stack
#define On_stop		S_evaluator->_On_stop
#define C_on_stop	S_evaluator->_C_on_stop
#define C_assign	S_evaluator->_C_assign
#define parent_frame	S_evaluator->_parent_frame
#define N_call_args	S_evaluator->_N_call_args
#define call_names	S_evaluator->_call_names
#define frame_jmp	S_evaluator->_frame_jmp
#define f_tables	S_evaluator->_f_tables
#define f_args		S_evaluator->_f_args
#define ret_vals	S_evaluator->_ret_vals
#define C_specials	S_evaluator->_C_specials
#define breaks		S_evaluator->_breaks
#define nexts		S_evaluator->_nexts
#define eval_open	S_evaluator->_eval_open
#define eval_count	S_evaluator->_eval_count
#define Nexpr		S_evaluator->_Nexpr
#define interrupt_code	S_evaluator->_interrupt_code
#define saw_interrupt	S_evaluator->_saw_interrupt
#define last_method_name	S_evaluator->_last_method_name
#define Generics	S_evaluator->_Generics
#define GroupGenerics	S_evaluator->_GroupGenerics
#define GroupGenericsObject	S_evaluator->_GroupGenericsObject
#define quick_name	S_evaluator->_quick_name
#define quick_frame	S_evaluator->_quick_frame
#define quick_arg_frame	S_evaluator->_quick_arg_frame
#define sys_index	S_evaluator->_sys_index
#define Restart		S_evaluator->_Restart
#define S_error_jmp	S_evaluator->_S_error_jmp
#define quick_save	S_evaluator->_quick_save
#define last_match	S_evaluator->_last_match
#define ntry		S_evaluator->_ntry
#define thread_storage_frame	S_evaluator->_thread_storage_frame
#define evArenas	S_evaluator->_evArenas
#define evBuckets	S_evaluator->_evBuckets
#define evFrame_maps	S_evaluator->_evFrame_maps
#define max_frames	S_evaluator->_max_frames
#define quit_flag	S_evaluator->_quit_flag
#define search_data_index	S_evaluator->_search_data_index
#define meta_data_index	S_evaluator->_meta_data_index
/*#define help_data_index	S_evaluator->_help_data_index*/
#define end_search_data	S_evaluator->_end_search_data
#define max_search_data	S_evaluator->_max_search_data
#define search_db_table	S_evaluator->_search_db_table
#define thread_data_index	S_evaluator->_thread_data_index
#define thread_meta_index	S_evaluator->_thread_meta_index
/* currrently no thread_help_index */
#define asgn_table	S_evaluator->_asgn_table
#define RETURNED(n) (ret_vals[n]!=S_void)
#define objects_read	S_evaluator->_objects_read
#define global_data	S_evaluator->_global_data
#define cur_interact	S_evaluator->_cur_interact
#define no_free_headers_in_any_bucket S_evaluator->_no_free_headers_in_any_bucket
#endif /* ) end of PRIVATE DEFINES */

S_end_extern_c
#include "unlibext.h"
#endif /* S_S_EVAL_H */
