/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: Thread.h,v $: $Revision: #7 $, $Date: 2006/06/26 $  */
#ifndef THREAD_H
#define THREAD_H

#ifdef S_LEVEL_THREADS
#include <pthread.h>
#endif 

#include "S_engine.h"
#include "eval.h"
#include "ThreadAliases.h"

#if READER_WRITER_LOCKS
#include "rwl.h"    /* Reader Write lock header file. */
typedef rwl_t ReadWriteLock;
#endif

#ifdef S_LEVEL_THREADS
#include "ThreadStructs.h"
#include "ThreadPrototypes.h"
#endif

extern void lock_with_error(MUTEX *mtx);
extern void delete_lock_error(MUTEX *mtx);

void unlock_db_list(s_evaluator *S_evaluator);
s_boolean free_lock_list(LockList l, s_boolean unlock, s_evaluator *S_evaluator);

#ifdef S_LEVEL_THREADS
#if 1
#define ELOCK(mtx)  lock_with_error(mtx)
#define EUNLOCK(mtx)  delete_lock_error(mtx)
#else
#define ELOCK(mtx) LOCK(mtx)
#define EUNLOCK(mtx) UNLOCK(mtx)
#endif
#endif

         /*  Global variables  */
extern Thread *stdin_thread;

extern ThreadKey thread_pointer_key, cleanup_routine_key, evaluator_switch_key;
extern ThreadKey eval_data_key, eval_thread_data_key, thread_type_key;
extern ThreadKey current_lock_key;


#define ARRAY_LENGTH(arr)  sizeof((arr))/sizeof((arr)[0])
#define SLOT_NUM(obj,name) LOOKUP_SLOT((obj)->Class,make_name((name), S_evaluator))-1;


 /* Copy a value into a raw slot of an object 
    The type of the object is used to calculate the number of bytes to copy.
  */
#define COPY_TO_RAW(obj, src, type) \
   if((obj)->nalloc < sizeof(type)) { \
       PROBLEM "copying C data to raw object - not enough space allocated (%ld < %ld)",  \
       (long)(obj)->nalloc, (long)sizeof(type) \
       ERROR;                         \
     } else                           \
       Memcpy((char*)((obj)->value.name), (char*)(src),sizeof(type));



 /* Copy a value from a raw slot of an object to the specified position.
    The type of the object is used to calculate the number of bytes to copy.
 */
#define COPY_FROM_RAW(obj, src, type) \
   if((src)->nalloc > sizeof(type)) { \
       PROBLEM "copying C data from raw object - not enough space in destination object (%ld > %ld)",  \
       (long)(src)->nalloc, (long)sizeof(type) \
       ERROR;                         \
     } else                           \
       Memcpy((char*)obj,(char*)((src)->value.name), sizeof(type));



  /* Message indicating that routine is not supported in the non-threaded version */
#ifdef __GNUC__
#define NO_THREAD_MESSAGE "%s not supported in non-threaded version", __PRETTY_FUNCTION__
#else
#define NO_THREAD_MESSAGE "not supported in non-threaded version" 
#endif

#define NO_THREADED_IMPLEMENTATION PROBLEM NO_THREAD_MESSAGE  WARN; return(S_void);


#ifdef S_LEVEL_THREADS
void set_evaluator_specific_thread_data(EvalThread *thread, int *type);
#endif

#endif
