/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: eval.h,v $: $Revision: #46 $, $Date: 2006/06/26 $  */
#ifndef S_EVAL_H
#define S_EVAL_H 1

#include "S_eval.h"
#include "libext.h"
#ifdef __cplusplus
extern "C" {
#endif

/* expose the new debug hooks */
#define S_DEBUG_API_HOOKS
#define S_DEBUG_WITH_LINE_NUMBERS

/* the last caught error, owned by catchall.c */
extern int last_signal, SignalPending;
extern char *last_sub_name; /* owned by S_interface */

typedef enum {S_TOP_EVAL, S_SUB_EVAL, S_GUI_EVAL, S_TEST_EVAL} s_eval_type;

/* S_CALLBACK_FREQUENCY determines the initial rate at which
	 we actually issue callbacks to registered callback functions.
	 If set to 5, the callback will be called every 5th time
	 WhileEvaluatingCallback is called.
 */
#define S_CALLBACK_FREQUENCY 20

/* the S storage allocation structures: largely restricted to
   c_support.c, but must be declared here to be part of the evaluator
   thread structure */

typedef union s_basic_unit basic_unit;
union s_basic_unit {
        s_complex cx;
        struct s_arena *ar;
};

LibExtern s_boolean S_is_env_removable_char(void);

enum arena_WHY {UNSET_WHY, STANDARD_WHY, ATOMIC_WHY, RECURSIVE_WHY, CHAR_WHY};
LibExtern enum arena_WHY S_STDCALL S_get_arena_why(s_object* ps_object, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_set_arena_why(s_object* ps_object, enum arena_WHY why, s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL S_is_removable_char(s_object *object, s_evaluator *S_evaluator);

struct s_arena {
        int Type;
        char *block;
        long used;
        struct s_arena *next;
        struct s_arena *prev;
        long size;
        int frame;
        int count;
        enum arena_WHY why;
#ifndef HAS_64BIT_LONG
	char s_arena_pad[4] ;
#endif
        basic_unit bu[1];
};

#define BUCKET_SIZE 75

struct vector_in_bucket {
	s_object ent ;
	struct s_bucket *my_bucket ;
#ifdef TRACE_HEADERS
	long my_type ;
	long my_id ;
#endif /* TRACE_HEADERS */
} ;

struct s_bucket {
	int Type;
	struct vector_in_bucket vectors_in_bucket[BUCKET_SIZE];
	s_object *last_freed;
	long nfree;
	long top;
	struct s_bucket *prev;
	struct s_bucket *next;
	long my_frame ;
};

#define SET_BUCKETS(frame, b) (frame < 0 ? (dbBuckets[-frame -1] = b) \
			       : (evBuckets[frame] = b))

LibExtern s_object *unset_variable; /* point unevaluated frame el's here */
extern s_object *missing_argument; /* point missing arg's here */

/* linked-list structure for the global data accessed during a task.
   Function objects are generally kept & do not appear here.  The
   objects pointed to by this structure will be deref'd by the object
   server when the relevant evaluation frame exits. */
struct s_global_data_struct {
  long frame;
  s_name *name;
  s_object *object;
  s_db_purposes purp;
  struct s_global_data_struct *next;
};


struct s_old_method_struct {
  s_name *name;
  int by_group;
  s_object *class_vector;
  s_object *function;
  s_name_table *f_names;
};


struct tname_chunk_struct {
  s_tname *buf;
  int length;
  int pos;
  struct tname_chunk_struct *prev;
};

struct s_f_table_struct {
  s_object *f;
  s_object *body;
  s_object *semantic;
  s_name_table *f_names;
  int pos;
  int dbs;
  struct s_f_table_struct *next;
};

extern void S_StartEarlyDataCommit(void);
extern void S_StopEarlyDataCommit(void);

/* the objects for the evaluation model: a list of evaluation frames,
   with associated calls, function def's, parent frames, etc.  These
   make up the evaluation thread structure.  In a threaded
   implementation there will be multiple such structures, with
   S_evaluator switched to point to the current thread on context
   switching.  In a single-thread version, S_evaluator is constant */


/* standard evaluator is NULL by default; e.g., in top-level thread */
#define STANDARD_EVALUATOR (evalAction == NULL_ENTRY || evalAction == standardEvaluator)
extern s_object *standardEvaluator;

/* number of consecutive errors before killing thread */
#define RETRIES 20

/* various initializing routines.  Called from S_init */
extern void deparse_init(s_evaluator *S_evaluator); /* in deparse.c */
extern s_name_table *name_table; /* in string.c */
extern void init_na(void); /* in comp_util.c */
extern void signal_init(void); /* in debug.c */
extern s_evaluator *thread_init(s_evaluator *t, s_evaluator *parent);
extern void init_thread_db(s_evaluator *t,s_evaluator *S_evaluator);
extern void frames_init(s_evaluator *t, s_evaluator *S_evaluator);
extern void set_perm_assign(s_name *name, s_object *obj, s_evaluator *S_evaluator);

extern s_object *S_frame_attr(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
extern int check_assign(long frame, s_name *name, s_object *value, s_evaluator *S_evaluator);
/* frame attributes are coded as an ordinary object with a reserved */
/* name. Better to use frame meta-data when/if that exists */
#define FRAME_ATTRS_NAME Dot_frame_attrs
/* following used to be  Frames->value.tree[(i-1)], valid only for i>0 */
/* The code in set_frames_vector keeps this consistent with: */
#define FRAME_POINTER(i) get_frame_pointer(i, S_evaluator)
/* FRAME_POINTER has no names; to get a list consistent with the */
/* evaluation model, use frame_object */
extern s_object *frame_object(int frame, s_boolean names_only, s_evaluator *S_evaluator);
extern s_object *move_value(s_object *val, int old_frame, s_evaluator *S_evaluator);
extern s_object *move_value2(s_object *val, int old_frame, int par_frame, s_evaluator *S_evaluator);
extern void move_block(char *ptr);
extern s_object *db_move_value(s_object *val, s_object *frame_ptr, s_boolean incr, s_evaluator *S_evaluator);
extern s_object *cleanup_value(s_object *val, int old_frame,
			       s_object *old_frame_ptr, s_boolean exiting, s_evaluator *S_evaluator);
extern s_object *cleanup_value2(s_object *val, s_evaluator *S_evaluator);
extern void deref_frame(int old, s_evaluator *S_evaluator);
extern void clear_frame(int old, s_evaluator *S_evaluator);
extern long cur_shift_frame; /* set by move_value, used by check_obj */
extern int quick_ref_count(char *p); /* used by Eval in for loops */
extern s_name *dot_name(int i, s_evaluator *S_evaluator);

extern s_object *do_na_funs(s_object *obj, int which, s_object *call, s_evaluator *S_evaluator);

extern s_object *Eval(s_object *ent, long frame, s_evaluator *S_evaluator);
extern s_object *do_standard_eval(s_object *p);
extern s_object *do_sub_eval(s_object *p, int frame, s_evaluator *S_evaluator);
/* used to assign .Last.value if proper conditions exist, and return whether */
/* eval_result should be auto-printed (0/1; 2 => auto-print .Last.value) */
LibExtern int S_STDCALL DoLastValueAndShouldShow(s_eval_type eval_type, int expr_mode, s_object *eval_result);
LibExtern void S_STDCALL DoShouldShow(int should_show, s_object *eval_expr, s_object *show_call);
extern S_sig process_signal(void);
extern s_object *ensure_method_body(s_object **method_ptr, s_evaluator *S_evaluator);
extern s_object *s_c_find_fun(s_object *name_obj, s_object *generic,
			      s_object *must_find);
extern s_object *read_fun(s_name *name, s_object **body, s_object
			  **semantic, s_name_table **f_names, s_evaluator *S_evaluator, s_boolean lock);
extern s_object *get_f_from_table(s_name *name, s_object **body, s_object **semantic,
		   s_name_table **f_names);
/* extern s_object *old_is_classes(s_class *cl, s_evaluator *S_evaluator); needed by SDK */
extern void set_for_method(s_boolean set, s_object *Class, s_object *method,
			   s_object *generic, s_object *group, s_evaluator *S_evaluator);
extern void clear_parse(void);
extern s_boolean ok_frame(s_object *object, long target, s_evaluator *S_evaluator);
extern int found_in(s_object *search_in, s_object *look_for, s_boolean exit);
extern void end_of_session_actions(void);


/* parameters for how to treat signals */
enum sig_treatment {STD_SIGNAL, TERMINAL_SIGNAL, IGNORED_SIGNAL, NOT_S_SIGNAL};
struct signal_par_struct{
  char *message;
  enum sig_treatment action;
};
#define N_S_SIGNALS 20

typedef struct signal_par_struct signal_par;
extern signal_par S_sig_pars[]; extern int n_S_signals;
extern void set_S_signals(int on);

#define CLEARED_FRAME(i) (FRAME_POINTER(i)->nalloc == 0)

/* codes for the element functions, used in eval.c and subset.c The
   order of the codes in the enum MUST match the names and the entry
   pointers in the define's following. */
enum subset_fun_code {
   SUBSET_FUN=1, AT_FUN, ELEMENT_FUN, ATTR_FUN, MODE_FUN,  LENGTH_FUN,
   DOLLAR_FUN, NAMES_FUN, EL_NAMED_FUN, DIM_FUN, DIMNAMES_FUN, TSP_FUN,
   LEVELS_FUN, ALL_ATTR_FUN,  STORAGE_FUN, CLASS_FUN, EL_FUN,
/* the definitions below this line are those not taking an object */
/* as the first argument.  New builtin assignment functions should be */
/* inserted above or below this point as appropriate */
   DICT_ATTR_FUN, FRAME_ATTR_FUN, DICT_STATUS_FUN, MAX_SUB_CODE};

#define MAX_SUB_FUN MAX_SUB_CODE+1

/* the replacement functions, left side and complete versions */
#define REPLACE_FUN_STRINGS  { \
	"[", "@", "[[", "attr", "mode", "length", \
	"$", "names", "elNamed", "dim", "dimnames", "tsp", \
	"levels", "attributes", "storage.mode", "class", "el", \
	"database.attr", "frame.attr", "database.status", \
	NULL}
#define REPLACE_NAME_STRINGS {\
	"[<-", "@<-", "[[<-", "attr<-", "mode<-", "length<-",\
	"$<-", "names<-", "elNamed<-", "dim<-", "dimnames<-", "tsp<-",\
	"levels<-", "attributes<-", "storage.mode<-", "class<-",\
	"el<-", \
	"database.attr<-", "frame.attr<-", "database.status<-",\
	NULL}
#define REPLACE_FUN_PTRS {\
	S_replace,do_AT_GETS,S_replace,S_replace,S_replace,S_replace,\
	S_replace,S_replace,S_el_named,S_replace,S_replace,S_replace,\
	S_replace,S_replace,S_replace,S_class,S_element, \
	S_dictionary, S_frame_attr, S_dictionary,\
	/* the rest should never get used */\
	0}
#define REPLACE_METHODS_OK { \
    S_TRUE, S_FALSE, S_TRUE,S_TRUE,S_TRUE,S_TRUE, \
    S_TRUE,S_TRUE, S_FALSE, S_TRUE,S_TRUE,S_TRUE, \
    S_TRUE,S_TRUE,S_FALSE,S_FALSE,S_FALSE, \
      S_FALSE,S_FALSE,S_FALSE,0}

/* the comment expression object: two slots for text and for the */
/* actual expression.  Can appear only as a function body and in {} */
enum comment_expr_slots {COM_TEXT_SLOT, COM_EXPR_SLOT};
#define COM_EXPR_NSLOTS COM_EXPR_SLOT + 1
extern s_object *Comments; /* shared with lex.l */

/* getting the names from an expression */
extern void all_names(s_object **expr_p, long *calls_p, char **names_p, long *max_name_p,
		      s_object **enames_p, long  *unique_p);

enum expr_names_mode {GET_ANY_NAME, GET_VARIABLES, GET_ASSIGNED_NAMES, GET_FUNCTION_NAMES};
/* meaning:  all names, exclude function call names, locally assigned variables only*/

extern void expr_names_table(s_object *expr, s_name_table *t,
	  enum expr_names_mode which);
extern s_name_table *function_name_table(s_object *f, s_boolean body_also, s_evaluator *S_evaluator);
extern void put_f_def_in_table(s_object *f, s_object *body,  s_object *semantic,
			s_name_table *f_names, int storage, s_evaluator *S_evaluator);
extern s_name_table *get_f_def_table(s_object *f, s_evaluator *S_evaluator);
extern s_name_table *method_name_table(s_name_table *args_table,
				       s_object *method);
extern int temp_C_assign(s_name *name);
extern void set_replace_function(s_name *name, s_name *r_name, s_evaluator *S_evaluator);
extern void reset_replace_functions(s_evaluator *S_evaluator);


enum argument_case  {EVALUATED, ACTUAL_ARGUMENT, DEFAULT_ARGUMENT};

extern s_object *find_local(s_name *name, enum argument_case *isarg, s_evaluator *S_evaluator);

/* names used in evaluation */
  extern s_name *Dot_generic, *Dot_method, *Dot_class, *Dot_group,
    *Dot_signature, *Dot_frame_attrs, *Dot_random, *Dot_last_value,
    *Dot_groups, *s_CLASSES_name, *s_COPY_name, *s_PACKAGE_name;

/* extra communication for Version 3 method matching */
extern s_object *saved_method;extern s_name_table *saved_f_names;

#define REPLACE_FRAME(n) (FRAME_POINTER(n)->Class == s_replace_class)

/* routines, variables used in dumping & reloading */
extern s_object *perm_frames_for_dump(int extra, s_evaluator *S_evaluator);
extern char *prog_name, *reload_path; extern s_boolean reload_flag;
extern s_object *reload_sinks_list, *reload_task_list;
extern s_object *connections_for_dump(void);
extern void reload_connections(s_object *con_objs, long *pars, s_evaluator *S_evaluator);
extern s_object *sinks_for_dump(s_evaluator *S_evaluator);
extern void reload_sinks();
extern s_object *tasks_for_dump(void);
extern void reload_tasks(void);

extern void session_announce(s_evaluator *S_evaluator);
extern s_name_table *make_frame_table(long target, s_evaluator *S_evaluator);
extern s_name_table *make_db_table(long n, double open_ratio, long target, s_evaluator *S_evaluator);
extern s_object *s_table_to_object(s_name_table *t, s_boolean names_only,
          s_object *frame_object, s_evaluator *S_evaluator);

/* utilities for managing global data references */
extern void thread_add_global(long frame, s_name *name, s_object *obj, s_evaluator *S_evaluator);
extern void thread_drop_global(s_name *name, s_evaluator *S_evaluator);
extern void commit_assigns(int error, s_evaluator *S_evaluator);
extern s_object *find_in_search_db(const char *name, long i, s_evaluator *S_evaluator);
extern s_name_table *list_name_table(s_object *obj, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL get_frame_pointer(long i, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL get_na_string();

extern s_evaluator * S_STDCALL get_current_evaluator();

extern int do_task(s_object *arg, s_evaluator *);

/* Version to save warnings from evaluator - used by SPL layer */
extern int do_task_savewarns(s_object *arg, s_evaluator *);

extern s_entry_point *s_find_interface(s_name *name, enum s_interface_type intf, long nargs, s_object *copy,
                            s_object *classes, s_object *naok, s_evaluator *S_evaluator);
extern s_entry_point *s_merge_interface_info(s_entry_point *ep, enum s_interface_type intf, long nargs, s_object *copy,
                            s_object *classes, s_object *naok, s_evaluator *S_evaluator);
extern s_object *make_c_call(s_object *ent, s_evaluator * S_evaluator);

extern void do_error_message(char *header, char *message, s_object *ent, char *S_fun_name, FILE *file, s_evaluator *S_evaluator);
extern s_boolean doing_error_message(void);
extern void stop_doing_error_message(void);
extern void set_doing_error_message(void);
extern void unset_doing_error_message(void);

#ifdef TRACE_HEADERS
void set_header_type(s_object *ent, long type, char *file, int line) ;
#define SET_HEADER_TYPE(ent, type) set_header_type(ent, type, __FILE__, __LINE__)
long get_header_type(s_object *ent) ;
void table_header_types(long frame, long print_zeros) ;
void S_table_header_types(long *frame, long *print_zeros) ;
#else
#define SET_HEADER_TYPE(ent, type)
#endif

/* fast bdObject dispatching */
extern s_object* BDL_check_arglist_for_bdObject(char* fn, s_object* arglist, int ignore_last_n_args, s_evaluator *S_evaluator);

#ifdef __cplusplus
}
#endif
#include "unlibext.h"
#endif
