/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_io.h,v $: $Revision: #47 $, $Date: 2006/06/26 $  */
#ifndef S_IO_H
#define S_IO_H 1

#include "S_extern.h"
#include "libext.h"
S_begin_extern_c

#if defined(_POSIX_C_SOURCE) && defined(SUNOS5) /*(*/
#undef _POSIX_C_SOURCE
#include <sys/stat.h>
#define _POSIX_C_SOURCE 1
#else /*)(*/
#include <sys/stat.h>
#endif /*)*/

#include <fcntl.h>

#if defined(S_ENGINE_BUILD) || !defined(WIN32)
#include <sys/time.h>
#elif WIN32
#include <time.h>
#endif

#include "S_eval.h"  /* This includes io_defs.h */

#if defined(LINUX)
#define AS_FPOS(x) ((x).__pos)
#else
#define AS_FPOS(x) (x)
#endif

/* macro versions of some members. These check & get con'n into */
/* desired mode, so for efficiency the pointer should be copied if */
/* it's going to be used repeatedly. */
#define READ_FILE(con) (ok_for_read(con, S_TRUE, con->mode,S_evaluator), con->rfile)
#define WRITE_FILE(con) (ok_for_write(con, S_TRUE, con->mode, S_evaluator), con->wfile)
#define READ_FILE_DESCRIPTOR(con) (ok_for_read(con, S_TRUE, con->mode, S_evaluator), con->rfd)
#define WRITE_FILE_DESCRIPTOR(con) (ok_for_write(con, S_TRUE, con->mode, S_evaluator), con->wfd)
#define CONNECTION_DESCRIPTION(con) con->description
#define CURRENT_MODE(con) con->cur_mode

#define READ_SELECT(n,f,t) select(n,f,0,0,t)

/*  a pointer to the (initial) working */
/* directory name, guaranteed to be a place we can write into */
extern char *init_swork;

/* the current version of data objects */
#define DATA_VERSION 0x3
#define NO_ALIGN_VERSION 1
#define NO_HALIGN_VERSION 2
/* HEADER_LONG_SIZE_64 or'ed into last byte of header means
 * object contains 64 bit longs.  No 0x40 means 32 bit longs.
 * This causes problems in previous versions of Splus on OSF/1,
 * which had 64 bit longs but no flag in header to say so.
 * On that machine we will need another way to disambiguate.
 */
#define HEADER_LONG_SIZE_64 0x40
#define HEADER_ALIGN cur_obj_version > NO_HALIGN_VERSION

/* while these look like they could be an enum, the values are really */
/* hard-coded: they have to `or' correctly, and are used as the */
/* rightmost two bits of a mode field, with the other modes specified */
/* by Posix macros */
#define CLOSED_MODE 0
#define READ_MODE 1
#define WRITE_MODE 2
#define READ_WRITE_MODE 3

/* For Binopen() - this is typically #define'd on Windows but not on Unix */
#if !defined(O_BINARY) /*(*/
/* Blasted Microsoft #defines _O_BINARY, but only #defines O_BINARY if non-ANSI(!?) */
#if !defined(_O_BINARY) /*(*/
#define _O_BINARY 0
#endif /*)*/
#define O_BINARY _O_BINARY
#endif /*)*/

/* macros to combine output and testing.  These could be modified to */
/* use a connection argument and apply put-back operations to text */
/* connections */
/* These first two are now functions:
#define ok_puts(s, f) (fputs(s, f) == EOF ? io_err("string output",f,S_evaluator) : 0)
#define ok_putc(c, f) (fputc(c, f) == EOF ? io_err("output",f,S_evaluator) : 0)
#define ok_printf1(f, fmt, a1) (fprintf(f, fmt, a1) < 0 ? io_err("formatted output",f,S_evaluator) : 0)
*/
#define ok_fileno(f,e) (IS_CLIPBOARD_FILEP(f) ? (int)f : fileno(f))
#define ok_clearerr(f,e) (IS_CLIPBOARD_FILEP(f) ? 0 : (clearerr(f),0))
#define ok_printf1(f, fmt, a1, e) \
			(IS_CLIPBOARD_FILEP(f) ? \
			 ok_clip_printf(e, fmt, a1) : \
			 (fprintf(f, fmt, a1) < 0 ? io_err("formatted output",f,e) : 0))
#define ok_printf2(f, fmt, a1, a2, e) \
			(IS_CLIPBOARD_FILEP(f) ? \
			 ok_clip_printf(e, fmt, a1, a2) : \
			 (fprintf(f, fmt, a1, a2) < 0 ? io_err("formatted output",f,e) : 0))
#define ok_printf3(f, fmt, a1, a2, a3, e) \
			(IS_CLIPBOARD_FILEP(f) ? \
			 ok_clip_printf(e, fmt, a1, a2, a3) : \
			 (fprintf(f, fmt, a1, a2, a3) < 0 ? io_err("formatted output",f,e) : 0))

extern s_index connection_tag; /* no. of connection tags so far. */
extern s_index_table *connection_table; /* table of current conn'ns by tag 8*/


#define OPEN_FOR_ANY(p) is_open_con(p, 0, S_TRUE, S_evaluator)
#define OPEN_FOR_READ(p) is_open_con(p, READ_MODE, S_TRUE, S_evaluator)
#define OPEN_FOR_WRITE(p) is_open_con(p, WRITE_MODE, S_TRUE,S_evaluator)
#define OPEN_FOR_READ_WRITE(p) is_open_con(p, READ_WRITE_MODE, S_TRUE,S_evaluator)
#define DEFAULT_CONNECTION(con) con = *s_connection_prototype

extern s_boolean any_sink_in_effect(s_evaluator *S_evaluator);

/* the current read/write position is the file position if the con. is in the */
/* corresponding mode, otherwise the stored last position */
#define READ_POS(p) ((p->rfile && !IS_CLIPBOARD(p) && p->cur_mode == READ_MODE) ? ftell(p->rfile) : AS_FPOS(p->rpos))
#define WRITE_POS(p) ((p->wfile && !IS_CLIPBOARD(p) && p->cur_mode == WRITE_MODE) ? ftell(p->wfile) : AS_FPOS(p->wpos))

extern s_name *r_mode, *w_mode, *a_mode, *rw_mode, *std_mode, *rp_mode,
       *no_mode, *ra_mode;
#define STD_MODE (char *)std_mode->text


#define N_CONNECTION_PARS 20
#define INVALID_CONNECTION_PAR -1
#define INVALID_CONNECTION_FILE (FILE *)0
#define NULL_CONNECTION (s_connection *)0
#define KEEP_CONNECTION (s_connection *)1

/* some macros using the sbuf (created in open_file) */
#define IS_REGULAR_FILE(con) (con->sbuf && S_ISREG(con->sbuf->st_mode))
#define IS_FIFO(con) (con->sbuf && S_ISFIFO(con->sbuf->st_mode))

/* clipboard detection macros */
#define CLIPBOARD_CLASSNAME		"clipboardConnection"
#define CLIPBOARD_DESCRIPTION	"clipboard"
#define CLIPBOARD_RFD			(-FOPEN_MAX)
#define CLIPBOARD_RFILEP		((FILE *)(-FOPEN_MAX))
#define CLIPBOARD_WFD			(-(FOPEN_MAX+1))
#define CLIPBOARD_WFILEP		((FILE *)(-(FOPEN_MAX+1)))
#define IS_CLIPBOARD_STRING(s)	(S_stricmp(s,CLIPBOARD_DESCRIPTION)==0)
#define IS_CLIPBOARD(con)		IS_CLIPBOARD_STRING(con->description)
#define IS_CLIPBOARD_INIT(con)	(con->put_back!=NULL)
#define IS_CLIPBOARD_FD(f)		((f)==CLIPBOARD_RFD || (f)==CLIPBOARD_WFD)
#define IS_CLIPBOARD_FILEP(f)	((f)==CLIPBOARD_RFILEP || (f)==CLIPBOARD_WFILEP)
#define WHICH_CLIPBOARD(f)		(((f)==CLIPBOARD_RFILEP) ? READ_MODE:WRITE_MODE)

#define TEST_CLIP_FIRSTTIME		0x40000000
#define IS_CLIP_FIRSTTIME(e)	eval_used_clipboard(FALSE,e)
#define CLEAR_CLIP_FIRSTTIME(e)	eval_used_clipboard(TRUE,e)

/* the classes for various connection objects */
extern s_class *s_pipe_class, *s_file_class, *s_connection_class,
   *s_fifo_class, *s_textConnection_class, *s_clipboard_class, *s_terminal_class;
/* new connection class for use by S+SDK */
extern s_class *s_fdConnection_class;
extern s_connection *s_connection_prototype;

extern s_connection *last_con_ptr;
extern s_object *connection_to_object(s_connection *con);

/* some definitions related to parsing (could do to be in a separate header) */
#define yyerror Syyerror /* might allow other parsers */

#define yyparse Syyparse
#define yylval Syylval
/* the old yacc-style file pointers, minimally used by generated by lex*/
extern FILE *yyin, *yyout;
extern void yyerror(char *string, s_evaluator *S_evaluator); /* Actually should depend on YYDEBUG */

extern s_connection *lookup_connection(s_connection *p, s_evaluator *S_evaluator);

extern s_object *con_describe(s_connection *p);
extern s_connection *io_con;
extern s_object *make_echo_connection(s_object *obj, s_object *echo_sep);

/* routines to do input from files or connections.  The sequence
   con_setup_input-s_get_line-close_last_connection is the general
   recommendation; it uses all the features of S connections and is
   efficient for longish sequences of input.  To get
   a single line from an open connection, con_get_line is fine, but it
   does allocation and updates the connection each time.  For paranoid
   situations or booting_S, simple_get_line is used which does NOT
   include the complete S features, such as push-back text */
extern int close_last_connection(s_evaluator *);
extern char *con_get_line(s_connection *con, int buf_len, s_evaluator *S_evaluator);

extern size_t max_tag_fd;
extern int *fd_tags; /*points to tags, >0 if corresponding fd is in */
		     /*use for a connection */
#define IS_CON_FD(fd) (fd >= 0 && fd < max_tag_fd && fd_tags[fd]>0)



/* file pointers used to manage echoing */
extern FILE *echo_stderr, *echo_stdout; extern char *echo_separator;

/* the standard i/o streams and associated  (initial) connections */
enum standard_streams {INPUT_STREAM, OUTPUT_STREAM, MESSAGE_STREAM};
#if 0   
  /* Now in s_evaluator defined in eval.h */
extern s_connection *standard_connections[N_STANDARD_STREAMS];
extern connection_save *save_streams[N_STANDARD_STREAMS];
extern s_object *std_connection_obj[N_STANDARD_STREAMS];
#endif

#define stdin_connection standard_connections[INPUT_STREAM]
#define stdout_connection standard_connections[OUTPUT_STREAM]
#define stderr_connection standard_connections[MESSAGE_STREAM]

/* audit file stuff */

extern s_connection *audit_con;
extern FILE *audit_file;
extern char *audit_filename;
#ifdef S_LEVEL_THREADS
extern MUTEX AuditLock;
#endif

/* event management */
extern void next_event(void);

#ifdef S_LEVEL_THREADS
extern s_index set_reader(s_object *obj, s_object *arg,
    		          s_object *on_quit, s_object *setup); 
/* extern s_object *drop_reader(ReaderThread *, s_boolean ); */
#else
extern s_object *drop_reader(int tag);
extern s_index set_reader(s_object *obj, s_object *arg,
		       s_object *on_quit, s_object *setup);
#endif
extern s_object *drop_reader_fd(int fd);
extern void set_event_timeout(double *timeout_val);
extern void input_task(int fd);
extern void do_quit(s_connection *con);
extern int is_task_reader(int fd);
LibExtern s_object* S_STDCALL do_parse_lines(s_object *con_obj, s_object *prev_input,
				s_object *max_lines, s_object *audit, s_object *extended_parse);
LibExtern s_object* S_STDCALL create_textConnection(s_object* obj, s_evaluator *S_evaluator);

extern void con_err(s_connection *p, char *problem);
extern void con_warn(s_connection *p, char *problem);




/* for db_backup action */
enum db_action {TO_READ, TO_WRITE, TO_REMOVE, TO_MOVE_OBJECT};
extern s_object * db_set_data(const char *name, s_object *object, long
			    database, enum db_action action);
extern s_object * db_set_data_name(s_name *name, s_object *object, long database, enum db_action action);

/* stuff to do with parsing, shared among parse.c, lex.l, lang.y */
extern s_connection *parse_con;

#define END_STAT	0

extern s_class *s_lex_class;
enum lex_slots {LEX_INPUT_SLOT, LEX_PROMPT_SLOT};

enum connection_slots { CON_DESCRIPTION_SLOT, CON_PARS_SLOT, CON_MODE_SLOT};
#define N_CON_SLOTS CON_MODE_SLOT+1
#define STALE_PID(p) (!(p)->pid || ((p)->type != s_pipe_class && (p)->pid != mainpid))

enum attach_slots {ATC_NAME_SLOT, ATC_CLASS_SLOT, ATC_ID_SLOT};

extern s_object *s_set_stream(s_object *con_obj, s_object *which_obj);

#define NOT_A_DB S_NOT_A_DB
#define ANY_DATABASE S_ANY_DATABASE
#define SYS_DATABASE S_SYS_DATABASE

extern s_object *s_c_raw(s_object *what_obj);


/****** Below are the prototypes that require s_evaluator to be defined *******/

LibExtern void S_STDCALL eval_init_clipboard(int set, s_evaluator *S_evaluator);
LibExtern int S_STDCALL eval_used_clipboard(int set, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_clipboard_modes(s_connection *con, int mode, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_clipboard_pos(s_connection *con, int mode, long offset, s_evaluator *S_evaluator);
LibExtern void S_STDCALL setup_clipboard_input(s_connection *con, s_evaluator *S_evaluator);

LibExtern int S_STDCALL open_clipboard(s_connection *con, int mode, s_evaluator *S_evaluator);
LibExtern int S_STDCALL seek_clipboard(s_connection *con, int which, long offset, int origin, s_evaluator *S_evaluator);
LibExtern int S_STDCALL cache_clipboard(s_connection *con, int which, char *text, s_evaluator *S_evaluator);
LibExtern int S_STDCALL read_clipboard(s_connection *con, s_evaluator *S_evaluator);
LibExtern int S_STDCALL write_clipboard(s_connection *con, s_evaluator *S_evaluator);
LibExtern int S_STDCALL close_clipboard(s_connection *con, int which, s_evaluator *S_evaluator);

extern int io_err(char *what, FILE *f, s_evaluator *S_evaluator);
LibExtern void S_STDCALL ok_flush(S_FILE *f, s_evaluator *S_evaluator);
LibExtern s_connection * S_STDCALL open_connection(s_connection *con, s_object *obj,
		int purpose, s_boolean *opened_here, s_connection *deflt, s_evaluator *S_evaluator);
extern s_connection *object_to_connection(s_object *obj, int purpose,
					  s_boolean *opened_here, s_evaluator *S_evaluator);


/* ok_for_read, ok_for_write don't test all the properties of the connection, */
/* just it's read/write status.  Used for switching a connection known */
/* to be open back and forth between read, write */
extern s_boolean ok_for_write(s_connection *p, s_boolean fail, int flag, s_evaluator *S_evaluator);
extern s_boolean ok_for_read(s_connection *p, s_boolean fail, int flag, s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL is_open_con(s_connection *p, int what, int fail_on_bad, s_evaluator *S_evaluator);
extern fpos_t con_seek(s_connection *p, long n, int how, int mode, s_evaluator *S_evaluator);

extern void save_connection(s_connection *p, s_evaluator *S_evaluator);
extern void push_back_object(s_object *data, s_connection *con, s_boolean newline, s_evaluator *S_evaluator);
LibExtern void S_STDCALL init_back_text(s_connection *con, int free_previous);



extern void ok_read(void *ptr, size_t size, size_t n, FILE *stream, s_evaluator *S_evaluator);
extern void ok_write(void *ptr, size_t size, size_t n, FILE *stream, s_evaluator *S_evaluator);
LibExtern int S_STDCALL ok_getc(FILE *f, s_evaluator *S_evaluator);
LibExtern int S_STDCALL ok_putc(int c, FILE *f, s_evaluator *S_evaluator);
LibExtern int S_STDCALL ok_puts(char *s, FILE *f, s_evaluator *S_evaluator);
LibExtern int S_STDCALL ok_eof(FILE *f, s_evaluator *S_evaluator);
/*PRINTFLIKE2*/
LibExtern int S_CDECL ok_clip_printf(s_evaluator *S_evaluator, char *format, ...);
LibExtern void S_STDCALL close_connection(s_connection *con, s_evaluator *S_evaluator);
LibExtern void S_STDCALL prompt_for_lex( s_connection *con, s_evaluator *S_evaluator);
LibExtern void S_STDCALL ok_close(FILE *f, int optional, s_evaluator *S_evaluator);
LibExtern void S_STDCALL connection_init(s_evaluator *S_evaluator);
LibExtern int S_STDCALL do_parse(s_boolean continue_input, long max_lines, extended_parse_info *extended_info, s_evaluator *S_evaluator);
LibExtern void S_STDCALL push_back_parse(s_evaluator *S_evaluator);
LibExtern int S_STDCALL get_token_list(int cont, int parse_line, s_evaluator *S_evaluator);

extern void ok_seek(FILE *file, long int offset, int whence, char *p, s_evaluator *S_evaluator);
extern void ok_getpos(FILE *stream, fpos_t *pos, s_evaluator *S_evaluator);
extern void ok_setpos(FILE *stream, fpos_t *pos, s_evaluator *S_evaluator);
extern s_connection *update_connection(s_connection *p, int purpose, s_evaluator *S_evaluator);
extern s_connection *new_s_connection(s_evaluator *S_evaluator);
extern FILE *ok_open(char *cmd, char *rw, int mode, char *message,
		     s_connection *con, s_evaluator *S_evaluator);
extern int set_close_on_exec(int fd);
LibExtern int S_STDCALL connection_mode(char *rw, s_boolean blocking, s_evaluator *S_evaluator);
extern void set_open(s_connection *con, int purpose, s_evaluator *S_evaluator);
extern void echo_to_input(s_evaluator *S_evaluator);
extern void set_interact(s_evaluator *S_evaluator);
extern char *simple_get_line(FILE *file, s_evaluator *S_evaluator);
extern s_connection *con_setup_input(s_object *con_obj, s_boolean *open_ptr, s_evaluator *S_evaluator);
extern char *s_get_line(s_evaluator *S_evaluator);
extern void close_file_maps(int fd, s_evaluator *S_evaluator);

/* if status== S_QUIT_WITHOUT_EXIT, quit_session() does not call exit() */
#define S_QUIT_WITHOUT_EXIT 999
LibExtern void S_STDCALL quit_session(int status, s_evaluator *S_evaluator);

extern char *get_back_text(s_connection *con, s_evaluator *S_evaluator);
extern void push_back_text(char *text, s_connection *con, s_boolean add_newline,s_boolean head, s_evaluator *S_evaluator);
extern void pop_back_text(s_connection *con, int nread, s_evaluator *S_evaluator);
extern void dump_data_put(s_object *ent, FILE *f, s_evaluator *S_evaluator);
extern s_object *dump_data_get(FILE *f, s_evaluator *S_evaluator);
/* task management */
extern int do_task(s_object *arg, s_evaluator *);

/* Version to save warnings from evaluator - used by SPL layer */
extern int do_task_savewarns(s_object *arg, s_evaluator *S_evaluator);

extern int next_parse_char(s_evaluator *S_evaluator);
extern int more_parse_input(int continue_input);
extern void s_scan_number(char *string, s_object *value, s_evaluator *S_evaluator);


extern long database_position(s_object *object, s_boolean optional, s_db_purposes meta_data, s_evaluator *S_evaluator);
extern long search_position(s_object *object, s_db_purposes purpose, s_evaluator *S_evaluator);

/* routines shared by data.c & deparse.c, used in booting_S */
extern void boot_objects(s_object *where_obj, int meta,  s_evaluator *S_evaluator);
extern s_object *dget_one_object(char **name_p,  s_evaluator *S_evaluator);
extern void con_get_all(s_connection *con, int buflen, s_evaluator *S_evaluator);

extern int S_get_char(s_connection *con, s_evaluator *S_evaluator);
extern void S_unget_char(int c, s_connection *con, s_evaluator *S_evaluator);
extern void as_s_connection(s_connection *con, s_object *obj, s_evaluator *S_evaluator);
extern s_object *db_names(long n, s_evaluator *S_evaluator);
extern s_object * S_db_names(long n);

#ifdef S_LEVEL_THREADS
extern int input_waiting(int this_fd, long wait,  s_evaluator *S_evaluator);
#endif

/* externally-callable entries called by bdl dump/restore */
extern void bdl_deparse_put_line(char *string);
extern char* bdl_deparse_get_line();

typedef void (*bdl_read_values_hook_fn_ptr)(s_object *ent, const char* dbname);
typedef s_object* (*bdl_put_values_hook_fn_ptr)(s_object *ent);
typedef void (*bdl_put_in_dir_hook_fn_ptr)(const char* fname, const char* dbname, int after);
typedef void (*bdl_do_rm_hook_fn_ptr)(const char* fname, const char* dbname);
typedef void (*bdl_commit_assigns_hook_fn_ptr)(int error);
typedef s_object* (*bdl_dput_to_file_hook_fn_ptr)(s_object *ent);
typedef s_object* (*bdl_dget_from_file_hook_fn_ptr)(s_object *ent);
typedef s_object* (*bdl_create_memref_hook_fn_ptr)(s_object* cache, s_object* dir);
typedef long (*bdl_memref_hook_fn_ptr)(const char* data, int op);

extern bdl_read_values_hook_fn_ptr g_bdl_read_values_hook_fn;
extern bdl_put_values_hook_fn_ptr g_bdl_put_values_hook_fn;
extern bdl_put_in_dir_hook_fn_ptr g_bdl_put_in_dir_hook_fn;
extern bdl_do_rm_hook_fn_ptr g_bdl_do_rm_hook_fn;
extern bdl_commit_assigns_hook_fn_ptr g_bdl_commit_assigns_hook_fn;
extern bdl_dput_to_file_hook_fn_ptr g_bdl_dput_to_file_hook_fn;
extern bdl_dget_from_file_hook_fn_ptr g_bdl_dget_from_file_hook_fn;
extern bdl_create_memref_hook_fn_ptr g_bdl_create_memref_hook_fn;
extern bdl_memref_hook_fn_ptr g_bdl_memref_hook_fn;
extern void bdl_set_hook_fns(bdl_read_values_hook_fn_ptr read_values_hook_fn,
			     bdl_put_values_hook_fn_ptr put_values_hook_fn,
			     bdl_put_in_dir_hook_fn_ptr put_in_dir_hook_fn,
			     bdl_do_rm_hook_fn_ptr do_rm_hook_fn,
			     bdl_commit_assigns_hook_fn_ptr commit_assigns_hook_fn,
                             bdl_dput_to_file_hook_fn_ptr dput_to_file_hook_fn,
                             bdl_dget_from_file_hook_fn_ptr dget_from_file_hook_fn,
			     bdl_create_memref_hook_fn_ptr create_memref_hook_fn,
			     bdl_memref_hook_fn_ptr memref_hook_fn
                             );

extern long bdl_is_enabled();
extern void S_bdl_is_enabled(long *ret);
extern s_object* S_bdl_create_memref(s_object* cache, s_object* dir);

#define BDL_IS_CACHE_OBJECT(ent) ( ent!=NULL && ent->Class!=NULL && \
				   ent->Class->name!=NULL && \
				   strcmp(ent->Class->name, "bdInternalCache")==0 )
#define BDL_IS_CACHE_INVALID(ent) ( ent==NULL || ent->length<1 || \
				    ent->mode!=LIST || \
				    RECURSIVE_DATA(ent)[0]==NULL || \
				    RECURSIVE_DATA(ent)[0]->mode!=CHAR || \
				    RECURSIVE_DATA(ent)[0]->length<1 )

/* magic numbers match for first four bytes in BDL memref object */
#define BDL_MEMREF_MAGIC_MATCH(nm) (nm!=NULL && nm[0]=='!' && nm[1]=='Z' && nm[2]=='9' && nm[3]=='a')


S_end_extern_c
#include "unlibext.h"
#endif
